#ifndef SCANBAG_H
#define SCANBAG_H

#include <map>
#include <list>
#include <set>
#include <vector>
#include <string>

#include "Parser.h"

class ScanBag : protected std::map<std::string, std::set<std::string> >
{
	std::list<const Scan*> scans;
	std::string defaultProfile;

public:
	/// Add a new test to the candidate profiles
	void add(const Scan* scan) throw ();

	/// Notify the success of a test, returning the list of candidate profiles
	std::vector<std::string> notify(const Scan* scan) throw ();

	/// Get the list of available tests
	const std::list<const Scan*>& getScans() const throw () { return scans; }

	/// Get the less specific profile among the available ones
	std::string getLessSpecific() const throw ();

	/// Remove all items from this ScanBag
	void clear() throw ()
	{
		std::map<std::string, std::set<std::string> >::clear();
		scans.clear();
	}

	/// Debug method: dump the contents to stdout
	void dump() const throw ();
};

// vim:set ts=3 sw=3:
#endif
