#ifndef SCANS_H
#define SCANS_H

#include "nettypes.h"

class Scan
{
protected:
	std::string _name;

public:
	Scan(const std::string& name) throw () : _name(name) {}
	virtual ~Scan() {}
	
	const std::string& name() const throw () { return _name; }

	virtual std::string signature() const throw () = 0;
};

class DefaultScan : public Scan
{
public:
	DefaultScan(const std::string& name) throw () : Scan(name) {}

	virtual std::string signature() const throw ();
};

class LinkBeatScan : public Scan
{
public:
	LinkBeatScan(const std::string& name) throw ()
		: Scan(name) {}

	virtual std::string signature() const throw ();
};

class DHCPScan : public Scan
{
public:
	DHCPScan(const std::string& name) throw ()
		: Scan(name) {}

	virtual std::string signature() const throw ();
};

class PeerScan : public Scan
{
protected:
	struct ether_addr _mac;
	IPAddress _ip;
	IPAddress _source;

public:
	PeerScan(const std::string& name, const ether_addr& mac, const IPAddress& ip) throw ()
		: Scan(name), _mac(mac), _ip(ip), _source("0.0.0.0") {}

	PeerScan(const std::string& name, const ether_addr& mac, const IPAddress& ip, const IPAddress& source) throw ()
		: Scan(name), _mac(mac), _ip(ip), _source(source) {}

	const ether_addr& mac() const throw () { return _mac; }
	const IPAddress& ip() const throw () { return _ip; }
	const IPAddress& source() const throw () { return _source; }

	virtual std::string signature() const throw ();
};

class ScriptScan : public Scan
{
protected:
	std::string _cmdline;

public:
	ScriptScan(const std::string& name, const std::string& cmdline) throw ()
		: Scan(name), _cmdline(cmdline) {}

	const std::string& cmdline() const throw () { return _cmdline; }

	virtual std::string signature() const throw ();
};

class ScanConsumer
{
public:
	virtual void handleScan(const Scan* scan) throw () = 0;
};

// vim:set ts=3 sw=3:
#endif
