# GUI For ufw (Uncomplicated FireWall) - Version 0.20.6
# Web: http://gufw.tuxfamily.org
# Licenced by GPL 3 or (at your option) any later version.
# Copyright (C) 2008 Marcos Alvarez Costales

# Gufw is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public Licence as published
# by the Free Software Foundation; either version 3 of the Licence,
# or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Import
import gtk
import locale
import gettext
_ = gettext.gettext

from checks                   import check_show_tray,check_minimize_on_close

from variables_paths_messages import *



# TRAY ICON
def tray_quit_cb(widget, data=None):

    if data:
        data.set_visible(False)
    gtk.main_quit()
    
def tray_popup_menu_cb(widget,button,time,p_gufw,data=None):

    if ( button == 3 ) and ( p_gufw.flg_status.get_text() != c_working_txt ):
        menu.show_all()
        menu.popup(None,None,None,3,time)
    pass

def tray_activate_icon_about(widget,data = None):
    
    # About window
    about = gtk.glade.XML(path_about).get_widget("aboutdialog")
    about.show_all()
    about.run()
    about.hide_all()
    
def tray_activate_icon_cb(self,p_gufw):
    if p_gufw.flg_status.get_text() == c_working_txt:
        return True
            
    if p_gufw.window.get_property("visible"):
        l_coordinates = p_gufw.window.get_position()
        v_coordx[0] = l_coordinates[0]
        v_coordy[0] = l_coordinates[1]
        p_gufw.window.hide()
    else:
        p_gufw.window.move(v_coordx[0],v_coordy[0])
        p_gufw.window.show()

        
def tray_activate_icon_change(self,p_gufw):

    if p_gufw.firewall.get_active():
        p_gufw.firewall.set_active(0)
    else:
        p_gufw.firewall.set_active(1)
        


# Create tray icon
def create_tray_icon(p_gufw):
    
    # Contextual menu Enable/Disabled
    iconw = gtk.Image()
    iconw.set_from_file(path_icon_tray)
    
    menuItem = gtk.ImageMenuItem(_(text_008))
    menuItem.set_image(iconw)
    menuItem.connect('activate', tray_activate_icon_change,p_gufw)
    menu.append(menuItem)
        
    # Contextual menu About
    menuItem = gtk.ImageMenuItem(gtk.STOCK_ABOUT)
    menuItem.connect('activate', tray_activate_icon_about)
    menu.append(menuItem)
    
    # Contextual menu Close Gufw
    menuItem = gtk.ImageMenuItem(gtk.STOCK_QUIT)
    menuItem.connect('activate', tray_quit_cb,tray_icon)
    menu.append(menuItem)
    
    # Events tray icon.
    tray_icon.connect('activate',   tray_activate_icon_cb,p_gufw)
    tray_icon.connect('popup-menu', tray_popup_menu_cb, p_gufw)
    
    tray_icon.set_visible(check_show_tray())



# Show/Hide window when close button pressed
def show_hide_tray_close_button(widget,data,p_gufw):
    if p_gufw.flg_status.get_text() == c_working_txt:
        return True

    # Minimize when close?
    if check_minimize_on_close() == c_enabled:
        if p_gufw.window.get_property("visible"):
            l_coordinates = p_gufw.window.get_position()
            v_coordx[0] = l_coordinates[0]
            v_coordy[0] = l_coordinates[1]
            p_gufw.window.hide()
        return True
    # Exit when close?
    else:
        sys.exit()
        
