# GUI For ufw (Uncomplicated FireWall) - Version 0.20.7
# Web: http://gufw.tuxfamily.org
# Licenced by GPL 3 or (at your option) any later version.
# Copyright (C) 2008 Marcos Alvarez Costales

# Gufw is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public Licence as published
# by the Free Software Foundation; either version 3 of the Licence,
# or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Imports
import gtk
import string
import os
import commands
import time
import locale
import gettext
_ = gettext.gettext

from checks                   import check_gufw_log,check_ipv6
from file_operations          import file_add_line
from set_window               import set_window_values
from variables_paths_messages import *





# ---------------------------  POP-UP ---------------------------------
# Popup with message
def popup(p_msg):
    dlg = gtk.MessageDialog(None, buttons=gtk.BUTTONS_CLOSE, message_format=p_msg)
    dlg.run()
    dlg.destroy()
    

def popup_answer(p_msg):
    # Confirmation popup
    dialog = gtk.MessageDialog( 
        type=gtk.MESSAGE_WARNING, 
        buttons=gtk.BUTTONS_OK_CANCEL, 
        message_format= p_msg) 
    dialog.set_default_response(gtk.RESPONSE_CANCEL) 
    result = dialog.run() 
    dialog.destroy()
    if result == -4:
    	result = gtk.RESPONSE_CANCEL
    return result




# ------------------------ COMPONENT RULES ----------------------------
# Return the Protocol rule
def get_proto(p_rule):
    
    l_rule = p_rule.upper()
    
    # Anywhere
    if l_rule.find(c_anywhere.upper()) != -1:
        return c_any
            
    # Return tcp or udp
    if l_rule.find(c_tcp.upper()) != -1:
        return c_tcp
    if l_rule.find(c_udp.upper()) != -1:
        return c_udp
                    
    # Return None
    return c_any
    


# Return the Port rule
def get_port(p_rule):
    
    l_aux = p_rule
    l_aux = l_aux.upper()
    l_aux = l_aux.replace("/TCP","")
    l_aux = l_aux.replace("/UDP","")
    l_aux = l_aux.replace(":TCP","")
    l_aux = l_aux.replace(":UDP","")
    l_aux = l_aux.replace("(V6)","")
    
    # Anywhere
    if l_aux.find(c_anywhere.upper()) != -1:
        return c_any
            
    l_descomponent_rule = l_aux.split(" ")
    
    for l_rule in l_descomponent_rule:
            
        # Is a number? -> Return Port
        l_isport = True
        try:
            string.atoi(l_rule)
        except ValueError:
            l_isport = False
            
        if l_isport:
            return l_rule
                    
    # Return None
    return c_any
                        
                    
# Return the IP rule
def get_ip(p_rule):
    l_aux = p_rule
    l_aux = l_aux.upper()
    l_aux = l_aux.replace("/TCP","")
    l_aux = l_aux.replace("/UDP","")
    l_aux = l_aux.replace(":TCP","")
    l_aux = l_aux.replace(":UDP","")
    l_aux = l_aux.replace("(V6)","")
    
    # Anywhere
    if l_aux.find(c_anywhere.upper()) != -1:
        return c_blank_ipv4
            
    l_descomponent_rule = l_aux.split(" ")
    
    for l_rule in l_descomponent_rule:
            
        # Is not a number? -> Return IP
        l_isport = True
        try:
            string.atoi(l_rule)
        except ValueError:
            l_isport = False
            
        if ( not l_isport ) and ( ( l_rule.find(":") != -1 ) or ( l_rule.find(".") != -1 ) ):
            return l_rule
                    
    # Return None
    return c_blank_ipv4


	
# Component command
def component_command(p_delete,p_rule,p_proto,p_from_ip,p_from_port,p_to_ip,p_to_port):		

    l_to_ip   = p_to_ip
    l_from_ip = p_from_ip
    if p_to_ip == c_blank_ipv4 or p_to_ip == c_blank_ipv6 or p_to_ip == "":
        l_to_ip = c_any
    if p_from_ip == c_blank_ipv4 or p_from_ip == c_blank_ipv6 or p_from_ip == "":
        l_from_ip = c_any
    
    # Basic Command
    l_command = "ufw " + p_delete + p_rule.lower() + " "
    
    # Protocol
    if p_proto.upper() != c_any.upper():
        l_command = l_command + "proto " + p_proto.lower() + " "
            
    # FROM
    l_command = l_command + "from " + l_from_ip.lower() + " "
    if str(p_from_port).upper() != c_any.upper():
        l_command = l_command + "port " + str(p_from_port) + " "
    
    # TO
    l_command = l_command + "to " + l_to_ip.lower() + " "
    if str(p_to_port).upper() != c_any.upper():
        l_command = l_command + "port " + str(p_to_port)
                    
    return l_command
                    

		
# Component command delete
def component_command_as_file(p_rule,p_proto,p_from_ip,p_from_port,p_to_ip,p_to_port):		

    p_rule      = p_rule.strip()
    p_proto     = p_proto.strip()
    p_from_ip   = p_from_ip.strip()
    p_from_port = p_from_port.strip()
    p_to_ip     = p_to_ip.strip()
    p_to_port   = p_to_port.strip()

    # Basic Command
    l_command = c_tuple           + " " + \
                p_rule.upper()    + " " + \
                p_proto.upper()   + " " + \
                p_to_port.upper() + " " + \
                p_to_ip           + " " + \
                p_from_port       + " " + \
                p_from_ip
    
    l_command = l_command.upper()
    return l_command



   



# ------------------------ OTHERS -------------------------------------
# Add a message to gufw log
def add_to_gufw_log(p_msg):
    if check_gufw_log() != c_enabled:
        return
        
    l_time = "[" + time.strftime('%x %X') + "] "
    l_msg = l_time + str(p_msg) + "\n"

    file_add_line(path_gufw_log,l_msg)

    
  

# See operation
def view_print(p_msg):
    l_parameters = sys.argv
    
    for l_param in l_parameters:
        if l_param == "--test":
        	print p_msg


# Click in FROM IP Address.
def click_from_ip(widget,data,p_gufw):
    if p_gufw.advanced_fromip.get_text() == c_any:
        p_gufw.advanced_fromip.set_text("")
    
    

# Click in TO IP Address.
def click_to_ip(widget,data,p_gufw):
    if p_gufw.advanced_toip.get_text() == c_any:
        p_gufw.advanced_toip.set_text("")



# Refresh gufw log file
def refresh_gufw_log(p_file):
    l_file = open(p_file, "w")
    l_file.close()


# Recovery preferences after installation.
def recovery_gufw_preferences():
    l_result = commands.getstatusoutput("diff " + path_gufw_config + " " + path_gufw_config + "_backup")
    if l_result[0] == 256:
        commands.getstatusoutput("cp -f " + path_gufw_config + "_backup " + path_gufw_config)

	
	
# Put "Any" in IP box.
def set_text_advanced_ip(p_gufw):
    
    p_gufw.advanced_fromip.set_text(c_any)
    p_gufw.advanced_toip.set_text(c_any)




# Type preconfigured pushed.
def change_preconf_type(self,p_gufw):
    set_window_values(p_gufw,c_not_working,c_disabled)




