# -*- coding: utf-8 -*-
# Gufw 13.10.2 - http://gufw.org
# Copyright (C) 2008-2013 Marcos Alvarez Costales https://launchpad.net/~costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.

from gi.repository import Gtk
import os


class WinAbout:
    def __init__(self, winMain):
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("gufw")
        self.builder.add_from_file(os.path.join('/usr', 'share', 'gufw', 'ui', 'about.ui'))
        self.win_about = self.builder.get_object('about')
        self.win_about.set_transient_for(winMain)
        self.win_about.connect('response', lambda d, r: d.destroy())
        self.win_about.show()

