#!/usr/bin/env python
# Gufw 9.10.4 - http://gufw.tuxfamily.org
# Copyright (C) 2009 Marcos Alvarez Costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.


import view.guiGufw
from instance   import Instance
from instance   import Check
from controller import Controller 


if __name__ == "__main__":

    # Is root?
    check = Check()
    
    if check.is_root():
    
        # Check wether there a instance exists or we create a new one
        appInstance = Instance()

        # Show GUI
        controler = Controller()
        
        firewall  = controler.get_firewall()
        variable  = controler.get_variable()
        
        app = view.guiGufw.Guigufw(variable, firewall)

        # Remove current instance
        appInstance.exitApplication()

