/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2004 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef GF_EVENT_H
#define GF_EVENT_H

#define GF_EVENT(obj)	((GfEvent *)(obj))

#define TOKENS_DEFAULT "%aDdHhiMmNpsTtuwXYy"

typedef enum _GfEventPriority {
	GF_EVENT_PRIORITY_LOWEST = -9999,
	GF_EVENT_PRIORITY_LOWER = -6666,
	GF_EVENT_PRIORITY_LOW = -3333,
	GF_EVENT_PRIORITY_NORMAL = 0,
	GF_EVENT_PRIORITY_HIGH = 3333,
	GF_EVENT_PRIORITY_HIGHER = 6666,
	GF_EVENT_PRIORITY_HIGHEST = 9999,
} GfEventPriority;

typedef struct _GfEvent GfEvent;

#include <glib.h>

#include <plugin.h>

G_BEGIN_DECLS

GfEvent *gf_event_new(const gchar *notification_type, const gchar *tokens,
					  const gchar *name, const gchar *description,
					  GfEventPriority priority);
GfEvent *gf_event_find_for_notification(const gchar *type);
void gf_event_destroy(GfEvent *event);

const gchar *gf_event_get_notification_type(GfEvent *event);
const gchar *gf_event_get_tokens(GfEvent *event);
const gchar *gf_event_get_name(GfEvent *event);
const gchar *gf_event_get_description(GfEvent *event);
GfEventPriority gf_event_get_priority(GfEvent *event);

void gf_event_set_show(GfEvent *event, gboolean show);
gboolean gf_event_get_show(GfEvent *event);

gboolean gf_event_show_notification(const gchar *n_type);

const GList *gf_events_get();
void gf_events_save();
gint gf_events_count();
const gchar *gf_events_get_nth_name(gint nth);
const gchar *gf_events_get_nth_notification(gint nth);

void gf_events_init(GaimPlugin *plugin);
void gf_events_uninit();

G_END_DECLS

#endif /* GF_EVENT_H */
