# This should avoid the need to --define gaimver foo, as long as I remember
# to update it whenever we need to use new API stuff or Gaim's major version
# increases
%{!?gaimver: %{expand: %%define gaimver 1.0.0}}
%define gaim_major_ver %(echo %{gaimver} | sed -e 's/\\([[0-9]]*\\).\\([[0-9]]*\\).\\([[0-9]]*\\)/\\1/' -)
%define gaim_minor_ver %(echo %{gaimver} | sed -e 's/\\([[0-9]]*\\).\\([[0-9]]*\\).\\([[0-9]]*\\)/\\2/' -)
%define gaim_next_major_ver %(echo $((%{gaim_major_ver}+1)))

Summary:    Guifications Plugin for Gaim
Name:       gaim-guifications
Version:    2.9
Release:    %{gaim_major_ver}.%{gaim_minor_ver}.0%{?gaimdist:.%{gaimdist}}
Epoch:      0
License:    GPL
Group:      Applications/Internet
Url:        http://guifications.sourceforge.net/
Source:     guifications-%{version}.tar.gz
BuildRoot:  %{_tmppath}/%{name}-%{version}-root

Requires:	gaim >= 1:%{gaim_major_ver}.%{gaim_minor_ver}, gaim < 1:%{gaim_next_major_ver}

BuildRequires: pkgconfig, libtool, gaim-devel >= 1:%{gaim_major_ver}.%{gaim_minor_ver}, gaim-devel < 1:%{gaim_next_major_ver}
%if "%{_vendor}" == "MandrakeSoft"
BuildRequires: libgtk+2.0_0-devel
%else
BuildRequires: gtk2-devel
%endif

%description
Guifications is a graphical notification plugin for the open source instant messaging client Gaim

To rebuild for a specific Gaim version:
rpmbuild --rebuild gaim-guifications-2.9-%{release}.src.rpm --define 'gaimver %{gaimver}' --define 'gaimdist %{!?gaimdist:fc1}%{?gaimdist:%{gaimdist}}'

%prep
%setup -q -n guifications-2.9

%build
%configure
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%if "%{_vendor}" == "MandrakeSoft"
mv -f $RPM_BUILD_ROOT%{_libdir}/gaim/guifications $RPM_BUILD_ROOT%{_libdir}/gaim/guifications.so || :
%endif

strip $RPM_BUILD_ROOT%{_libdir}/gaim/*.so || :
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/*.la $RPM_BUILD_ROOT%{_libdir}/gaim/*.a

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc AUTHORS ChangeLog COPYING README doc/flow.png doc/flow.dia doc/QUOTES
%{_libdir}/gaim/*.so
%{_datadir}/pixmaps/gaim/guifications/*
%{_datadir}/locale/*/*/*

%changelog
* Fri Dec 17 2004 Stu Tomlinson <stu@nosnilmot.com>
- Tweaks to the Gaim version dependencies

* Sat Oct  9 2004 Stu Tomlinson <stu@nosnilmot.com>
- Add Gaim version checks to match new Gaim versioning

* Wed Jun 30 2004 Stu Tomlinson <stu@nosnilmot.com>
- Initial spec file for Guifications 2
