//$Id: bitmap-res.cc,v 1.8 2004/03/13 17:24:49 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "bitmap-res.h"

#include "io/io.h"

#include <Magick++.h>
#include <libgnomevfs/gnome-vfs.h>

using namespace Guikachu;

Resources::Bitmap::Bitmap (ResourceManager   *manager,
			   const std::string &id,
			   serial_t           serial):
    Resource (manager, id, serial),
    bitmap_type (changed, TYPE_COLOR_256)
{
}

void Resources::Bitmap::load_file (const std::string &uri)
{
    char             *data = 0;
    GnomeVFSFileSize  len;

    if (IO::load_uri (uri, data, len) != GNOME_VFS_OK)
    {
	delete[] data;
	return;
    }

    Magick::Blob blob;
    blob.updateNoCopy (data, len);
    
    set_image (blob);
}

void Resources::Bitmap::save_file_bmp (const std::string &uri) const
{
    // Serialize image data in uncompressed BMP format
    Magick::Blob blob;
    Magick::Image image_cpy (image);
    
    image_cpy.compressType (Magick::NoCompression);
    image_cpy.write (&blob, "BMP");

    const char       *data = reinterpret_cast<const char*> (blob.data ());
    GnomeVFSFileSize  len = blob.length ();

    IO::save_uri (uri, data, len);
}

void Resources::Bitmap::set_image (const Magick::Blob &blob)
{
    image.read (blob);

    changed.emit ();
}

void Resources::Bitmap::set_image (const Magick::Image &image_)
{
    image = image_;

    changed.emit ();
}
