//$Id: form-editor.cc,v 1.29 2003/12/21 22:57:17 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2003 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "form-editor/form-editor.h"

#include "resource-manager.h"
#include "target.h"

using namespace Guikachu::GUI;
using Guikachu::GUI::FormEditor::Font;

#define GUIKACHU_TITLE_FONT 1

const Font &FormEditor::get_font (int font_num)
{
    static Font standard_fonts[8];
    static bool init[8] = {false, false, false, false, false, false, false, false};
    static const char* const font_filenames[] = { "stdfont.txt", "boldfont.txt", "bigfont.txt",
                                                  "symbol.txt", "symbol11.txt", "symbol7.txt",
                                                  "ledfont.txt", "bigbold.txt" };

    if (font_num > 7)
    {
        g_warning ("Font number %d out of range", font_num);
        font_num = 0;
    }
    
    if (!init[font_num])
    {
        standard_fonts[font_num].parse (font_filenames[font_num]);
        init[font_num] = true;
    }
    
    return standard_fonts[font_num];
}


const Font &FormEditor::get_title_font ()
{
    return get_font (GUIKACHU_TITLE_FONT);
}

int FormEditor::get_font_height (int font_num)
{
    const Font &font = get_font (font_num);
    return font.get_line_height ();
}

int FormEditor::get_line_width (int font_num, const std::string &text)
{
    const Font &font = get_font (font_num);
    return font.get_line_width (text);
}

void FormEditor::get_text_extents (int font_num, const std::string &text,
				   int &width, int &height)
{
    const Font &font = get_font (font_num);
    font.get_text_extents (text, width, height);
}

