// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Private definitions of directory selection dialog
// ****************************************************************************


#ifndef __DLGDIRSEL_PRIVATE_H__
#define __DLGDIRSEL_PRIVATE_H__

#include <QtGui> //lint !e537 Repeated include

#ifndef __COMMON_H__
   #include "common.h"
#endif

class t_TreeView: public QTreeView
{
   Q_OBJECT

   public:
      t_TreeView (QWidget *pParent=NULL)
         :QTreeView (pParent)
      {
      }

     ~t_TreeView (void)
      {
      }

   protected:
      virtual void currentChanged (const QModelIndex &Current, const QModelIndex &Previous)
      {
         QTreeView::currentChanged (Current, Previous);
         emit SignalCurrentChanged (Current);
      }

   signals:
      void SignalCurrentChanged (const QModelIndex &Current);
};

#endif

