// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Wait dialog
// ****************************************************************************

#include "dlgwait.h"

// -----------------------------
//           Constants
// -----------------------------


// -----------------------------
//           Classes
// -----------------------------

class t_DlgWaitLocal
{
   public:
      QLabel *pLabel;
};

t_DlgWait::t_DlgWait ()
{
   CHK_EXIT (ERROR_DLGWAIT_CONSTRUCTOR_NOT_SUPPORTED)
} //lint !e1401 pOwn not initialised

t_DlgWait::t_DlgWait (const QString &Title, const QString &Message, QWidget *pParent, Qt::WFlags Flags)
   :QDialog (pParent, Flags)
{
   static bool Initialised = false;
   QSize       MaxSize;
   QVBoxLayout *pLayout;

   if (!Initialised)
   {
      Initialised = true;
      CHK_EXIT (TOOL_ERROR_REGISTER_CODE (ERROR_DLGWAIT_CONSTRUCTOR_NOT_SUPPORTED))
   }

   pOwn = new t_DlgWaitLocal;

   pLayout = new QVBoxLayout ();
   pOwn->pLabel = new QLabel (Message, this);

   pLayout->addWidget (pOwn->pLabel);

   setLayout (pLayout);
   setWindowTitle (Title);

//   CHK_QT_EXIT (connect (pOwn->pButtonClose, SIGNAL (released()), this, SLOT(accept())))
}

APIRET t_DlgWait::setLabelText (const QString &Text)
{
   pOwn->pLabel->setText (Text);

   return NO_ERROR;
}

t_DlgWait::~t_DlgWait ()
{
   delete pOwn->pLabel;
   delete pOwn;
}

APIRET t_DlgWait::Show (const QString &Title, const QString &Message)
{
   t_DlgWait *pDlg;

   pDlg = new t_DlgWait (Title, Message);
   pDlg->setModal      (true);
   pDlg->show          ();
   pDlg->exec          ();
   delete pDlg;

   return NO_ERROR;
}

