/*  GWhere
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*!
 * @header	gwdiskdata.h
 *		GWhere<br>
 *		Copyright (C) 2000  Sbastien LECACHEUR<br><br>
 *		This Distributed under the terms of the <a href="http://www.gnu.org/copyleft/gpl.html">GNU General Public Licence</a><br><br>
 *		This component was developed for the GWhere project.<br>
 *		It's an object for disk representation. His structure gets many informations and the list of his components.<br><br>
 * @abstract	This is the dirdata data structure.
 * @author	Sbastien LECACHEUR <zero@gwhere.org>
 * @version	1.0 2001/08/21
 * @see		glib.h
 * @see		gwsupport.h
 * @see		gwdiskinfo.h
 * @link		GWhere Web Site <http://www.gwhere.org>
 * @link		GTK+ Web Site <http://www.gtk.org>
 * @ref		gwdiskdata.c
 * @author	Author <zero@gwhere.org>
 */


#ifndef GW_DATA_DISK_DATA_H
#define GW_DATA_DISK_DATA_H


#include <glib.h>
#include "gwdiskinfo.h"


/*!
 * @struct	disk_data
 * @abstract	Disk data structure
 * @discussion	Disk data is an opaque data structure containing information about disk properties and all contained sub items.
 */
struct disk_data;


/*!
 * @function	disk_data_new
 * @abstract	Creates a new disk data.
 * @discussion	This function creates a new disk data. It's an allocation function.
 * @result	a pointer to the disk data structure.<br>
 * 		Returns <i>NULL</i> when an error occured.<br>
 */
struct disk_data * disk_data_new ( void);


/*!
 * @function	disk_data_set_info
 * @abstract	Sets the disk data's informations.
 * @discussion	This function sets the disk's information. Disk informations is a <i>struct disk_info</i>.<br>
 * @param	p		the disk data to set the informations
 * @param	info		the disk informations
 * @result	an error code.<br>
 *		Returns <i>0</i> when it's done.<br>
 *		Returns <i>-1</i> when an error occured.<br>
 */
gint disk_data_set_info ( struct disk_data *p, struct disk_info *info);


/*!
 * @function	disk_data_set_child
 * @abstract	Sets the disk data's children.
 * @discussion	This function sets the disk's children. The list of children is the list of file and subfolders in the disk.<br>
 * @param	p		the disk data to set the children
 * @param	child		the list of children
 * @result	an error code.<br>
 *		Returns <i>0</i> when it's done.<br>
 *		Returns <i>-1</i> when an error occured.<br>
 */
gint disk_data_set_child ( struct disk_data *p, GList *child);


/*!
 * @function	disk_data_append_child
 * @abstract	Appends in the disk data's children a new child.
 * @discussion	This function appends in the disk dat's children list a new child.<br>
 * @param	p		the disk data to append a child
 * @param	child		the child
 * @result	an error code.<br>
 *		Returns <i>0</i> when it's done.<br>
 *		Returns <i>-1</i> when an error occured.<br>
 */
gint disk_data_append_child ( struct disk_data *p, struct file_info *child);


/*!
 * @function	disk_data_get_info
 * @abstract	Gets disk data's informations.
 * @discussion	This function gets the disk data's informations.<br>
 * @param	p		the disk data to get informations
 * @result	the disk informations.<br>
 *		Returns <i>NULL</i> when an error occured.<br>
 */
struct disk_info * disk_data_get_info ( struct disk_data *p);


/*!
 * @function	disk_data_get_child
 * @abstract	Gets disk data's list of children.
 * @discussion	This function gets the disk data's list of children. This list is the list of files and subfolders in the disk.<br>
 * @param	p		the disk data to get list of children
 * @result	the list of children.<br>
 *		Returns <i>NULL</i> when an error occured.<br>
 */
GList * disk_data_get_child ( struct disk_data *p);


/*!
 * @function	disk_data_free
 * @abstract	Frees datas structure.
 * @discussion	This function frees the disk data's datas.
 * @param	p		the disk data to free
 * @result	an error code.<br>
 *		Returns <i>0</i> when it's done.<br>
 *		Returns <i>-1</i> when an error occured.<br>
 */
gint disk_data_free ( struct disk_data *p);


#endif
