/*  GWhere.
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*!
 * @header	gwdescr.h
 *		GWhere<br>
 *		Copyright (C) 2000  Sbastien LECACHEUR<br><br>
 *		This Distributed under the terms of the <a href="http://www.gnu.org/copyleft/gpl.html">GNU General Public Licence</a><br><br>
 *		This component was developed for the GWhere project.<br><br>
 * @abstract	This is the interface specification of description plugins.
 * @author	Sbastien LECACHEUR <zero@gwhere.org>
 * @version	1.0 2003/08/19
 * @see		gwsupport.h
 * @link	GWhere Web Site <http://www.gwhere.org>
 * @author	Author <zero@gwhere.org>
 */


#ifndef GW_PLUGINS_DESCR_H
#define GW_PLUGINS_DESCR_H


/*!
 * @typedef	func_get_author_t
 *		The function get the author of the plugin.
 * @abstract	Desription plugin functions specification
 * @return	The author name
 */
typedef gchar* (*func_get_author_t)(void);


/*!
 * @typedef	func_get_info_t
 *		The function get some information about the plugin.
 * @abstract	Desription plugin functions specification
 * @return	The information
 */
typedef gchar* (*func_get_info_t)(void);


/*!
 * @typedef	func_get_help_t
 *		The function get some help about the plugin.
 * @abstract	Desription plugin functions specification
 * @return	The help
 */
typedef gchar* (*func_get_help_t)(void);


/*!
 * @typedef	func_get_allowed_ext_t
 *		The function get a list for file extention supported by the plugin.
 * @abstract	Desription plugin functions specification
 * @return	The file extensions list separated by <i>"|"</i>.
 */
typedef gchar* (*func_get_allowed_ext_t)(void);


/*!
 * @typedef	func_get_allowed_name_t
 *		The function get a list for file name supported by the plugin.
 * @abstract	Desription plugin functions specification
 * @return	The file name list separated by <i>"|"</i>.
 */
typedef gchar* (*func_get_allowed_name_t)(void);


/*!
 * @typedef	func_get_file_descr_t
 *		The function get the file description.
 * @abstract	Desription plugin functions specification
 * @param	file_path	file path to make description
 * @param	mode		mode to build description
 * @return	The file description.
 */
typedef gchar* (*func_get_file_descr_t)(const char* file_path, const char* mode);


/*!
 * @typedef	func_get_files_descr_t
 *		The function get the files description.
 * @abstract	Desription plugin functions specification
 * @param	file_path	file path to make description
 * @param	mode		mode to build description
 * @return	The file description.
 */
typedef gchar*** (*func_get_files_descr_t)(const char* file_path, const char* mode);


/*!
 * @typedef	func_descr_t
 *		The function get the author of the plugin.
 * @abstract	Desription plugin functions specification
 * @param	file_name		file name to get description
 */
typedef gchar* (*func_get_parent_descr_t)(const char*, const char*);



#endif
