
import dbus, gobject
from . import config, table, gintegration, resources, microblog
import gtk, gtk.glade, webkit, urllib, urlparse, json

import gettext

_ = gettext.lgettext

def button_url(w, url):
  gintegration.load_url(url)

class AccountBar(gtk.HBox):
  def __init__(self):
    gtk.HBox.__init__(self)
    self.accounts = config.Accounts()

    self.bus = dbus.SessionBus()
    self.microblog = dbus.Interface(self.bus.get_object("com.Gwibber", "/com/gwibber/Microblog"), "com.Gwibber")
    self.protocols = self.microblog.protocols()

    for acct in self.accounts:
      if acct["protocol"] in self.protocols:
        if "send" in self.protocols[acct["protocol"]]["features"]:
          icon = resources.get_ui_asset("icons/16x16/%s.png" % acct["protocol"])
          color = gtk.gdk.color_parse(acct["message_color"])
          
          button = gtk.ToggleButton()
          button.set_image(gtk.image_new_from_file(icon))
          button.modify_bg(gtk.STATE_NORMAL, color)
          
          acct.bind(button, "send_enabled")
          self.pack_start(button, False)

class AccountManager(gobject.GObject, config.Accounts):
  __gsignals__ = {
      "account-updated": (gobject.SIGNAL_RUN_LAST | gobject.SIGNAL_ACTION, None, (str,)),
      "account-deleted": (gobject.SIGNAL_RUN_LAST | gobject.SIGNAL_ACTION, None, (str,)),
  }
  def __init__(self, path = config.GCONF_ACCOUNTS_DIR):
    gobject.GObject.__init__(self)
    self.accounts = self
    self.path = path

    self.bus = dbus.SessionBus()
    self.microblog = dbus.Interface(self.bus.get_object("com.Gwibber", "/com/gwibber/Microblog"), "com.Gwibber")
    self.protocols = dbus.Interface(self.bus.get_object("com.Gwibber", "/com/gwibber/Protocol"), "com.Gwibber")

  def get_protocol(self, a):
    return dbus.Interface(
      self.bus.get_object("com.Gwibber", "/com/gwibber/Protocol/%s" % a), "com.Gwibber")

  def facebook_authorize(self, account):

    def on_finish_auth(w, web):
      try:
        url = web.get_main_frame().get_uri()
        data = json.loads(urlparse.parse_qs(url.split("?", 1)[1])["session"][0])
        account["session_key"] = str(data["session_key"])
        account["secret_key"] = str(data["secret"])
        fbc = microblog.facebook.Client(account)
        fbuid = account["session_key"].split("-")[1]
        account["username"] = str(fbc.facebook.users.getInfo(fbuid)[0]["name"])
      except:
        d = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR,
          gtk.BUTTONS_OK, "Facebook authorization failed. Please try again.")
        if d.run(): d.destroy()

      
    web = webkit.WebView()
    web.load_html_string("<p>Please wait...</p>", "file:///")

    url = urllib.urlencode({
      "api_key": "71b85c6d8cb5bbb9f1a3f8bbdcdd4b05",
      "connect_display": "popup",
      "v": "1.0",
      "next": "http://www.facebook.com/connect/login_success.html",
      "cancel_url": "http://www.facebook.com/connect/login_failure.html",
      "fbconnect": "true",
      "return_session": "true",
      "req_perms": "publish_stream,read_stream,status_update,offline_access"
    })

    w = gtk.Window()
    w.resize(750, 600)
    w.connect("destroy", on_finish_auth, web)
    web.open("http://www.facebook.com/login.php?" + url)
    w.add(web)
    w.show_all()
    
  def show_properties_dialog(self, acct, create = False):
    def on_close(w):
      self.emit("account-updated", acct["id"])

    glade = gtk.glade.XML(resources.get_ui_asset("preferences.glade"))
    dialog = glade.get_widget("dialog_%s" % acct["protocol"])
    dialog.connect("destroy", on_close)
    dialog.show_all()

    for widget in self.get_protocol(acct["protocol"]).config():
      w = glade.get_widget("%s_%s" % (acct["protocol"], widget.replace("private:", "")))
      if w:
        if isinstance(w, gtk.ColorButton): acct.bind(w, widget, default="#729FCF")
        else: acct.bind(w, widget)

    glade.get_widget("%s_btnclose" % acct["protocol"]).connect("clicked",
      lambda a: dialog.destroy())

    try:
      lb = glade.get_widget("%s_linkbutton" % acct["protocol"])
      lb.connect("clicked", button_url, lb.get_uri())
    except: pass

    if create:
      glade.get_widget("%s_btndelete" % acct["protocol"]).props.label = gtk.STOCK_CANCEL
      glade.get_widget("%s_btnclose" % acct["protocol"]).props.label = gtk.STOCK_OK
      
    glade.get_widget("%s_btndelete" % acct["protocol"]).connect("clicked",
      lambda a: self.on_account_delete(acct, dialog, create = create))

    if acct["protocol"] == "facebook":
      glade.get_widget("btnAuthorize").connect("clicked",
        lambda a: self.facebook_authorize(acct))

    if create:
      dialog.set_title(_("Create %s account") % acct["protocol"])
    else:
      dialog.set_title(_("Edit %s account") % acct["protocol"])

  def on_account_create(self, w, protocol):
    a = self.accounts.new_account()
    a["protocol"] = protocol
    self.show_properties_dialog(a, create=True)

  def on_account_delete(self, acct, dialog = None, create = False):
    if create:
      msg = _("Are you sure you want to cancel the creation of this account?")
    else:
      msg = _("Are you sure you want to delete this account?")
              
    d = gtk.MessageDialog(dialog, gtk.DIALOG_MODAL, gtk.MESSAGE_QUESTION,
      gtk.BUTTONS_YES_NO, msg)
    
    if d.run() == gtk.RESPONSE_YES:
      if dialog: dialog.destroy()
      aid = acct["id"]
      self.accounts.delete_account(acct)
      self.emit("account-deleted", aid)
    d.destroy()

  def show_account_list(self):
    self.manager = gtk.Window()
    self.manager.set_title(_("Manage Accounts"))
    self.manager.set_border_width(10)
    self.manager.resize(390, 240)

    self.manager.add(self.get_account_list())
    self.manager.show_all()

  def get_account_list(self):
    def toggle_table_checkbox(cr, i, key, table):
      a = table.tree_store.get_obj(i)
      a[key] = (a[key] and [False] or [True])[0]

    col_receive = gtk.CellRendererToggle()
    col_send = gtk.CellRendererToggle()
    col_search = gtk.CellRendererToggle()

    col_protocol = gtk.TreeViewColumn(_("Protocol"))
    col_proto1 = gtk.CellRendererPixbuf()
    col_proto2 = gtk.CellRendererText()
    col_protocol.pack_start(col_proto1, False)
    col_protocol.pack_start(col_proto2, True)

    def generate_account_name(acct):
      return acct["username"]

    def supports(acct, feature):
      return feature in self.get_protocol(acct["protocol"]).features()

    def proto_name(acct):
      return self.get_protocol(acct["protocol"]).name()

    def get_proto_icon(acct):
      return gtk.gdk.pixbuf_new_from_file(resources.get_ui_asset("icons/%s.png" % acct["protocol"]))

    data = table.generate([
      ["username", lambda a: generate_account_name(a), _("Username")],
      ["receive",  (col_receive, {
        "active": lambda a: a["receive_enabled"],
        "visible": lambda a: supports(a, "receive")}), _("Receive")],
      ["send", (col_send, {
        "active": lambda a: a["send_enabled"],
        "visible": lambda a: supports(a, "send")}), _("Send")],
      ["search", (col_search, {
        "active": lambda a: a["search_enabled"],
        "visible": lambda a: supports(a, "send")}), _("Search")],
      ["protocol", (col_protocol,
        ({"pixbuf": get_proto_icon}, {"text": proto_name})),
          _("Protocol")],
    ])

    col_receive.connect("toggled", toggle_table_checkbox, "receive_enabled", data)
    col_send.connect("toggled", toggle_table_checkbox, "send_enabled", data)
    col_search.connect("toggled", toggle_table_checkbox, "search_enabled", data)

    for a in self.accounts: data += a
    
    scroll = gtk.ScrolledWindow()
    scroll.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
    scroll.add_with_viewport(data)
    data.set_property("rules-hint", True)

    buttons = gtk.HButtonBox()
    buttons.set_layout(gtk.BUTTONBOX_END)

    def on_click_button(w, stock):
      if stock == gtk.STOCK_CLOSE:
        self.manager.destroy()

      elif stock == gtk.STOCK_ADD:
        mac = gtk.Menu()
        for p in list(microblog.PROTOCOLS.keys()):
          mi = gtk.MenuItem(microblog.PROTOCOLS[p].PROTOCOL_INFO["name"])
          mi.connect("activate", self.on_account_create, p)
          mac.append(mi)
        mac.show_all()
        mac.popup(None, None, None, 1, 0)

      elif stock == gtk.STOCK_PROPERTIES:
        if isinstance(data.get_selected(), config.Account):
          self.show_properties_dialog(data.get_selected())

      elif stock == gtk.STOCK_DELETE:
        if isinstance(data.get_selected(), config.Account):
          self.on_account_delete(data.get_selected())

    def on_account_change(gc, v, entry, t):
      if len([a for a in self.accounts]) != len(t.tree_store):
        t.tree_store.clear()
        for a in self.accounts: t+= a
    
    config.GCONF.notify_add(self.accounts.path, on_account_change, data)

    for stock in [gtk.STOCK_ADD, gtk.STOCK_PROPERTIES, gtk.STOCK_DELETE, gtk.STOCK_CLOSE]:
      b = gtk.Button(stock=stock)
      b.connect("clicked", on_click_button, stock)
      buttons.pack_start(b)

    vb = gtk.VBox(spacing=5)
    vb.pack_start(scroll)
    vb.pack_start(buttons, False, False)

    return vb

