/*
 * Copyright 2009 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.missingplugin.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * The entry point that launches the download UI.
 */
public class MissingPlugin implements EntryPoint {

  public void onModuleLoad() {
    DownloadInfo linkInfo = getAmbientLinkInfo();
    MissingPluginPane pane = new MissingPluginPane(linkInfo);
    RootPanel.get().add(pane);
  }

  private DownloadInfo getAmbientLinkInfo() {
    DownloadInfo r = getAmbientLinkInfo0();
    assert r != null : "expecting $wnd.downloadInfo";
    return r;
  }
  
  private native DownloadInfo getAmbientLinkInfo0() /*-{
    return $wnd.downloadInfo;
  }-*/;

}
