# Makefile for compiling the .c and .s files
# If you want to compile .dylan files, don't use this makefile.

CCFLAGS = -I. -I/usr/include -gstabs1 -O -fno-inline-functions
LIBTOOL = libtool
GC_LIBS = -lgc
# We only know the ultimate target when we've finished building the rest
# of this makefile.  So we use this fake target...
#
all : all-at-end-of-file

library.lo : library.c
	$(LIBTOOL) --mode=compile gcc $(CCFLAGS) -c library.c -o library.lo
sockets-api.lo : sockets-api.c
	$(LIBTOOL) --mode=compile gcc $(CCFLAGS) -c sockets-api.c -o sockets-api.lo
network-init.lo : network-init.c
	$(LIBTOOL) --mode=compile gcc $(CCFLAGS) -c network-init.c -o network-init.lo
network-heap.lo : network-heap.c
	$(LIBTOOL) --mode=compile gcc $(CCFLAGS) -c network-heap.c -o network-heap.lo

libnetwork-dylan.la :  library.lo sockets-api.lo network-init.lo network-heap.lo
	rm -f libnetwork-dylan.la
	$(LIBTOOL) --mode=link gcc -o libnetwork-dylan.la  library.lo sockets-api.lo network-init.lo network-heap.lo -rpath /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/dylan-user

all-at-end-of-file : libnetwork-dylan.la

all-at-end-of-file : libnetwork-dylan.la

clean :
	rm -f  library.lo sockets-api.lo network-init.lo network-heap.lo libnetwork-dylan.la libnetwork-dylan.la

realclean :
	rm -f  cc-network-files.mak library.lo library.c sockets-api.lo sockets-api.c network-init.lo network-init.c network-heap.lo network-heap.c libnetwork-dylan.la libnetwork-dylan.la network.lib.du
