# Makefile for compiling the .c and .s files
# If you want to compile .dylan files, don't use this makefile.

CCFLAGS = -I. -I/usr/include -gstabs1 -O -fno-inline-functions
LIBTOOL = libtool
GC_LIBS = -lgc
# We only know the ultimate target when we've finished building the rest
# of this makefile.  So we use this fake target...
#
all : all-at-end-of-file

network-test-imports.o : network-test-imports.c
	gcc $(CCFLAGS) -c network-test-imports.c -o network-test-imports.o
gettimeofday.o : gettimeofday.c
	gcc $(CCFLAGS) -c gettimeofday.c -o gettimeofday.o
network-test.o : network-test.c
	gcc $(CCFLAGS) -c network-test.c -o network-test.o
network-test-init.o : network-test-init.c
	gcc $(CCFLAGS) -c network-test-init.c -o network-test-init.o
network-test-heap.o : network-test-heap.c
	gcc $(CCFLAGS) -c network-test-heap.c -o network-test-heap.o
heap.o : heap.c
	gcc $(CCFLAGS) -c heap.c -o heap.o
inits.o : inits.c
	gcc $(CCFLAGS) -c inits.c -o inits.o

network-test :  network-test-imports.o gettimeofday.o network-test.o network-test-init.o network-test-heap.o heap.o inits.o
	$(LIBTOOL) --mode=link gcc -o network-test  network-test-imports.o gettimeofday.o network-test.o network-test-init.o network-test-heap.o heap.o inits.o  ./libnetwork-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libio-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libcommon-dylan-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libthreads-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libcommon-extensions-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libregular-expressions-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libstring-extensions-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libcollection-extensions-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/librandom-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libtranscendental-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libformat-out-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libtable-extensions-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libstandard-io-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libformat-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libprint-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libstreams-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libmelange-support-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libdylan-dylan.la /usr/lib/dylan/2.3.10pre1/x86-linux-gcc/libruntime.la  $(GC_LIBS) -lm -gstabs1

all-at-end-of-file : network-test

clean :
	rm -f  network-test-imports.o gettimeofday.o network-test.o network-test-init.o network-test-heap.o heap.o inits.o network-test

realclean :
	rm -f  cc-network-test-files.mak network-test-imports.o network-test-imports.c gettimeofday.o gettimeofday.c network-test.o network-test.c network-test-init.o network-test-init.c network-test-heap.o network-test-heap.c heap.o heap.c inits.o inits.c network-test
