#include <stddef.h>

#include <stdlib.h>

#define GD_HAVE_LONG_LONG
#include "runtime.h"

#include <math.h>

extern descriptor_t dylanZtrue;	/* #t */

#define obj_True dylanZtrue.heapptr
extern descriptor_t dylanZfalse;	/* #f */

#define obj_False dylanZfalse.heapptr

#define GENERAL_ENTRY(func) \
    ((entry_t)SLOT(func, void *, 8))
#define GENERIC_ENTRY(func) \
    ((entry_t)SLOT(func, void *, 32))

#define GD_CTASSERT(name, x) \
    typedef char gd_assert_ ## name[(x) ? 1 : -1];
#define GD_VERIFY_SIZE_ASSUMPTION(name, type, size)\
    GD_CTASSERT(size_ ## name, sizeof(type) == (size))
#define GD_VERIFY_ALIGN_ASSUMPTION(name, type, align)\
    typedef struct { char c; type x; } \
      gd_align_ ## name; \
    GD_CTASSERT(align_ ## name, offsetof(gd_align_ ## name, x) == (align))

GD_VERIFY_SIZE_ASSUMPTION(general, descriptor_t, 8);
GD_VERIFY_ALIGN_ASSUMPTION(general, descriptor_t, 4);
GD_VERIFY_SIZE_ASSUMPTION(heap, heapptr_t, 4);
GD_VERIFY_ALIGN_ASSUMPTION(heap, heapptr_t, 4);
GD_VERIFY_SIZE_ASSUMPTION(boolean, int, 4);
GD_VERIFY_ALIGN_ASSUMPTION(boolean, int, 4);
GD_VERIFY_SIZE_ASSUMPTION(long_long, long long, 8);
GD_VERIFY_ALIGN_ASSUMPTION(long_long, long long, 4);
GD_VERIFY_SIZE_ASSUMPTION(long, long, 4);
GD_VERIFY_ALIGN_ASSUMPTION(long, long, 4);
GD_VERIFY_SIZE_ASSUMPTION(int, int, 4);
GD_VERIFY_ALIGN_ASSUMPTION(int, int, 4);
GD_VERIFY_SIZE_ASSUMPTION(uint, unsigned int, 4);
GD_VERIFY_ALIGN_ASSUMPTION(uint, unsigned int, 4);
GD_VERIFY_SIZE_ASSUMPTION(short, short, 2);
GD_VERIFY_ALIGN_ASSUMPTION(short, short, 2);
GD_VERIFY_SIZE_ASSUMPTION(ushort, unsigned short, 2);
GD_VERIFY_ALIGN_ASSUMPTION(ushort, unsigned short, 2);
GD_VERIFY_SIZE_ASSUMPTION(float, float, 4);
GD_VERIFY_ALIGN_ASSUMPTION(float, float, 4);
GD_VERIFY_SIZE_ASSUMPTION(double, double, 8);
GD_VERIFY_ALIGN_ASSUMPTION(double, double, 4);
GD_VERIFY_SIZE_ASSUMPTION(long_double, long double, 12);
GD_VERIFY_ALIGN_ASSUMPTION(long_double, long double, 4);
GD_VERIFY_SIZE_ASSUMPTION(ptr, void *, 4);
GD_VERIFY_ALIGN_ASSUMPTION(ptr, void *, 4);

/* Define Library getaddrinfo-test. */


/* Define Module getaddrinfo-test. */


/* {Implicit} Define Generic data */

/* data is data */


/* {Implicit} Define Generic data-setter */

/* data-setter is data-setter */


/* Define Class <network-address> */

/* <network-address> is <network-address> */

extern struct dylanZdylan_visceraZCLS_class {
    heapptr_t PCTobject_class;	 /* %object-class */
    heapptr_t class_name;	 /* class-name */
    long unique_id;	 /* unique-id */
    heapptr_t direct_superclasses;	 /* direct-superclasses */
    heapptr_t all_superclasses;	 /* all-superclasses */
    heapptr_t closest_primary_superclass;	 /* closest-primary-superclass */
    heapptr_t direct_subclasses;	 /* direct-subclasses */
    char class_functionalQUERY;	 /* class-functional? */
    char class_primaryQUERY;	 /* class-primary? */
    char class_abstractQUERY;	 /* class-abstract? */
    char class_sealedQUERY;	 /* class-sealed? */
    heapptr_t class_deferred_evaluations;	 /* class-deferred-evaluations */
    heapptr_t class_key_defaulter;	 /* class-key-defaulter */
    heapptr_t class_maker;	 /* class-maker */
    heapptr_t class_new_slot_descriptors;	 /* class-new-slot-descriptors */
    heapptr_t class_slot_overrides;	 /* class-slot-overrides */
    heapptr_t class_all_slot_descriptors;	 /* class-all-slot-descriptors */
    long class_bucket;	 /* class-bucket */
    heapptr_t class_row;	 /* class-row */
} getaddrinfo_testZgetaddrinfo_testZCLS_network_address_HEAP;

extern void dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1);	/* missing-required-init-keyword-error */

extern struct dylanZdylan_visceraZCLS_symbol {
    heapptr_t PCTobject_class;	 /* %object-class */
    descriptor_t symbol_string;	 /* symbol-string */
    long symbol_hashing;	 /* symbol-hashing */
    heapptr_t symbol_next;	 /* symbol-next */
} SYM_data_HEAP;

/* maker for <network-address> */
heapptr_t getaddrinfo_testZgetaddrinfo_testZCLS_network_address_MAKER_FUN(descriptor_t *orig_sp, heapptr_t A_data /* data */)
{
    descriptor_t *cluster_0_top;
    heapptr_t L_instance; /* instance */


    /* #line 7 "getaddrinfo-test.dylan" */
    if ((A_data != NULL)) {
	L_instance = allocate(8);
	SLOT(L_instance, heapptr_t, 0) = (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_network_address_HEAP;
	SLOT(L_instance, heapptr_t, 4) = A_data;
	return L_instance;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, (heapptr_t)&SYM_data_HEAP, (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_network_address_HEAP);
	not_reached();
    }
}

extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_symbol_HEAP;

extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_byte_vector_HEAP;

extern void dylanZdylan_visceraZtype_error_with_location_FUN(descriptor_t *orig_sp, descriptor_t A0, heapptr_t A1, descriptor_t A2);	/* type-error-with-location */

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE49 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[49];	 /* %element */
} getaddrinfo_testZstr_ROOT;

extern void dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(descriptor_t *orig_sp);	/* odd-number-of-keyword/value-arguments-error */

/* general-entry for maker for <network-address> */
descriptor_t * getaddrinfo_testZgetaddrinfo_testZCLS_network_address_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    heapptr_t L_data; /* data */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    heapptr_t L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_data = 0;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if (((heapptr_t)&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == (heapptr_t)&SYM_data_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if (((heapptr_t)&dylanZdylan_visceraZCLS_byte_vector_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_data = L_value.heapptr;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, (heapptr_t)&dylanZdylan_visceraZCLS_byte_vector_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, (heapptr_t)&dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <network-address> */
	L_result0 = getaddrinfo_testZgetaddrinfo_testZCLS_network_address_MAKER_FUN(orig_sp, L_data);
	L_temp_4.heapptr = L_result0;
	L_temp_4.dataword.l = 0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Class <ipv4-network-address> */

/* <ipv4-network-address> is <ipv4-network-address> */

extern struct dylanZdylan_visceraZCLS_class getaddrinfo_testZgetaddrinfo_testZCLS_ipv4_network_address_HEAP;

/* maker for <ipv4-network-address> */
heapptr_t getaddrinfo_testZgetaddrinfo_testZCLS_ipv4_network_address_MAKER_FUN(descriptor_t *orig_sp, heapptr_t A_data /* data */)
{
    descriptor_t *cluster_0_top;
    heapptr_t L_instance; /* instance */


    /* #line 10 "getaddrinfo-test.dylan" */
    if ((A_data != NULL)) {
	L_instance = allocate(8);
	SLOT(L_instance, heapptr_t, 0) = (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_ipv4_network_address_HEAP;
	SLOT(L_instance, heapptr_t, 4) = A_data;
	return L_instance;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, (heapptr_t)&SYM_data_HEAP, (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_ipv4_network_address_HEAP);
	not_reached();
    }
}

/* general-entry for maker for <ipv4-network-address> */
descriptor_t * getaddrinfo_testZgetaddrinfo_testZCLS_ipv4_network_address_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    heapptr_t L_data; /* data */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    heapptr_t L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_data = 0;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if (((heapptr_t)&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == (heapptr_t)&SYM_data_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if (((heapptr_t)&dylanZdylan_visceraZCLS_byte_vector_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_data = L_value.heapptr;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, (heapptr_t)&dylanZdylan_visceraZCLS_byte_vector_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, (heapptr_t)&dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <ipv4-network-address> */
	L_result0 = getaddrinfo_testZgetaddrinfo_testZCLS_ipv4_network_address_MAKER_FUN(orig_sp, L_data);
	L_temp_4.heapptr = L_result0;
	L_temp_4.dataword.l = 0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* {Implicit} Define Generic address-length */

/* address-length is address-length */


/* Define Method address-length{singleton(<ipv4-network-address>)} */

extern descriptor_t getaddrinfo_testZliteral;	/* proxy for <integer> */

/* address-length{singleton(<ipv4-network-address>)} */
descriptor_t * getaddrinfo_testZgetaddrinfo_testZaddress_length_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{
    descriptor_t L_temp;

    L_temp.heapptr = getaddrinfo_testZliteral.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic sockaddr-offset */

/* sockaddr-offset is sockaddr-offset */


/* Define Method sockaddr-offset{singleton(<ipv4-network-address>)} */

/* sockaddr-offset{singleton(<ipv4-network-address>)} */
descriptor_t * getaddrinfo_testZgetaddrinfo_testZsockaddr_offset_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{
    descriptor_t L_temp;

    L_temp.heapptr = getaddrinfo_testZliteral.heapptr;
    L_temp.dataword.l = 2;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <ipv6-network-address> */

/* <ipv6-network-address> is <ipv6-network-address> */

extern struct dylanZdylan_visceraZCLS_class getaddrinfo_testZgetaddrinfo_testZCLS_ipv6_network_address_HEAP;

/* maker for <ipv6-network-address> */
heapptr_t getaddrinfo_testZgetaddrinfo_testZCLS_ipv6_network_address_MAKER_FUN(descriptor_t *orig_sp, heapptr_t A_data /* data */)
{
    descriptor_t *cluster_0_top;
    heapptr_t L_instance; /* instance */


    /* #line 22 "getaddrinfo-test.dylan" */
    if ((A_data != NULL)) {
	L_instance = allocate(8);
	SLOT(L_instance, heapptr_t, 0) = (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_ipv6_network_address_HEAP;
	SLOT(L_instance, heapptr_t, 4) = A_data;
	return L_instance;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, (heapptr_t)&SYM_data_HEAP, (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_ipv6_network_address_HEAP);
	not_reached();
    }
}

/* general-entry for maker for <ipv6-network-address> */
descriptor_t * getaddrinfo_testZgetaddrinfo_testZCLS_ipv6_network_address_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    heapptr_t L_data; /* data */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    heapptr_t L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_data = 0;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if (((heapptr_t)&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == (heapptr_t)&SYM_data_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if (((heapptr_t)&dylanZdylan_visceraZCLS_byte_vector_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_data = L_value.heapptr;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, (heapptr_t)&dylanZdylan_visceraZCLS_byte_vector_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, (heapptr_t)&dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <ipv6-network-address> */
	L_result0 = getaddrinfo_testZgetaddrinfo_testZCLS_ipv6_network_address_MAKER_FUN(orig_sp, L_data);
	L_temp_4.heapptr = L_result0;
	L_temp_4.dataword.l = 0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Method address-length{singleton(<ipv6-network-address>)} */

/* address-length{singleton(<ipv6-network-address>)} */
descriptor_t * getaddrinfo_testZgetaddrinfo_testZaddress_length_METH_2(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{
    descriptor_t L_temp;

    L_temp.heapptr = getaddrinfo_testZliteral.heapptr;
    L_temp.dataword.l = 16;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method sockaddr-offset{singleton(<ipv6-network-address>)} */

/* sockaddr-offset{singleton(<ipv6-network-address>)} */
descriptor_t * getaddrinfo_testZgetaddrinfo_testZsockaddr_offset_METH_2(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{
    descriptor_t L_temp;

    L_temp.heapptr = getaddrinfo_testZliteral.heapptr;
    L_temp.dataword.l = 6;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method make{singleton(<network-address>)} */

extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_integer_HEAP;

extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_false_HEAP;

extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_true_HEAP;

extern heapptr_t dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(descriptor_t *orig_sp, long A0, descriptor_t A1);	/* maker for <simple-object-vector> */

extern descriptor_t * dylanZdylan_visceraZsignal_METH_2(descriptor_t *orig_sp, descriptor_t A0, heapptr_t A1, heapptr_t A2);	/* signal{<string>} */

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE75 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[75];	 /* %element */
} getaddrinfo_testZstr_ROOT_2;

extern struct dylanZdylan_visceraZCLS_empty_list {
    heapptr_t PCTobject_class;	 /* %object-class */
    descriptor_t head;	 /* head */
    descriptor_t tail;	 /* tail */
} dylanZempty_list_ROOT;

extern descriptor_t * dylanZdylan_visceraZgf_call_FUN(descriptor_t *orig_sp, heapptr_t A0, long A1);	/* gf-call */

extern struct dylanZdylan_visceraZCLS_generic_function {
    heapptr_t PCTobject_class;	 /* %object-class */
    heapptr_t function_name;	 /* function-name */
    void * general_entry;	 /* general-entry */
    heapptr_t function_specializers;	 /* function-specializers */
    char function_restQUERY;	 /* function-rest? */
    char function_all_keysQUERY;	 /* function-all-keys? */
    unsigned char HOLE1[2];
    heapptr_t function_keywords;	 /* function-keywords */
    heapptr_t function_values;	 /* function-values */
    heapptr_t function_rest_value;	 /* function-rest-value */
    heapptr_t generic_function_methods;	 /* generic-function-methods */
    heapptr_t method_cache;	 /* method-cache */
} network_L101;

struct mv_result_0 {
    heapptr_t R0;
    heapptr_t R1;
};

extern struct mv_result_0 dylanZdylan_visceraZgf_call_lookup_FUN(descriptor_t *orig_sp, heapptr_t A0, long A1);	/* gf-call-lookup */

extern struct dylanZdylan_visceraZCLS_generic_function getaddrinfo_testZgetaddrinfo_testZsockaddr_offset_ROOT;

extern struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZPLUS_HEAP;

extern struct dylanZdylan_visceraZCLS_generic_function getaddrinfo_testZgetaddrinfo_testZaddress_length_ROOT;

extern int dylanZdylan_visceraZPCTsubtypeQUERY_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1, heapptr_t A2);	/* %subtype?{<class>, <class>} */

extern struct dylanZdylan_visceraZCLS_class melange_supportZmelange_supportZCLS_c_vector_HEAP;

extern struct dylanZdylan_visceraZCLS_pair {
    heapptr_t PCTobject_class;	 /* %object-class */
    descriptor_t head;	 /* head */
    descriptor_t tail;	 /* tail */
} dylanZliteral_ROOT_2;

extern struct dylanZdylan_visceraZCLS_symbol SYM_size_HEAP;

extern descriptor_t getaddrinfo_testZgetaddrinfo_testZcopy_vector_METH(descriptor_t *orig_sp, heapptr_t A0, descriptor_t A1, heapptr_t A2, heapptr_t A3, descriptor_t A4);	/* copy-vector{subclass(<vector>), <c-vector>} */

extern struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZmake_HEAP;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE182 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[182];	 /* %element */
} getaddrinfo_testZstr_ROOT_3;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE183 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[183];	 /* %element */
} getaddrinfo_testZstr_ROOT_4;

extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_boolean_HEAP;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE56 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[56];	 /* %element */
} getaddrinfo_testZstr_ROOT_5;

/* make{singleton(<network-address>)} */
heapptr_t getaddrinfo_testZgetaddrinfo_testZmake_METH(descriptor_t *orig_sp, heapptr_t A_class /* class */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_args /* args */, descriptor_t A_address_family /* address-family */, descriptor_t A_sockaddr /* sockaddr */)
{
    descriptor_t *cluster_0_top;
    descriptor_t *cluster_1_top;
    int L_temp; /* temp */
    heapptr_t L_PCTobject_class; /* %object-class */
    int L_temp_2; /* temp */
    int L_temp_3; /* temp */
    int L_result; /* result */
    descriptor_t L_desired_class; /* desired-class */
    int L_result_2; /* result */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp_4;
    descriptor_t L_desired_class_2; /* desired-class */
    descriptor_t L_arg0; /* arg0 */
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_arg1_2; /* arg1 */
    descriptor_t L_arg3; /* arg3 */
    int L_condition; /* condition */
    heapptr_t L_instance_2; /* instance */
    descriptor_t L_temp_5;
    descriptor_t L_new_data; /* new-data */
    descriptor_t L_temp_6;
    descriptor_t L_temp_7; /* temp */
    heapptr_t L_PCTobject_class_2; /* %object-class */
    int L_temp_8; /* temp */
    descriptor_t L_temp_9;
    descriptor_t L_temp_10;
    descriptor_t L_temp_11;
    descriptor_t L_temp_12;

    /* #line {Class <compound-macro-source-location>} */
    L_temp = ((heapptr_t)&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(A_address_family.heapptr, heapptr_t, 0));

    /* #line 386 "./condition.dylan" */
    L_PCTobject_class = SLOT((L_temp ? obj_True : obj_False), heapptr_t, 0);
    if (((heapptr_t)&dylanZdylan_visceraZCLS_false_HEAP == L_PCTobject_class)) {
	L_temp_2 = TRUE;
    }
    else {
	L_temp_2 = ((heapptr_t)&dylanZdylan_visceraZCLS_true_HEAP == L_PCTobject_class);
    }
    if (L_temp_2) {
	/* #line {Class <compound-macro-source-location>} */
	L_temp_3 = L_temp;
	if (L_temp_3) {
	    L_result = (2 == A_address_family.dataword.l);
	}
	else {
	    L_result = FALSE;
	}
	if (L_result) {

	    /* #line 37 "getaddrinfo-test.dylan" */
	    L_desired_class.heapptr = (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_ipv4_network_address_HEAP;
	    L_desired_class.dataword.l = 0;
	}
	else {
	    if (L_temp_3) {
		/* #line {Class <compound-macro-source-location>} */
		L_result_2 = (10 == A_address_family.dataword.l);
	    }
	    else {
		L_result_2 = FALSE;
	    }
	    if (L_result_2) {

		/* #line 38 "getaddrinfo-test.dylan" */
		L_desired_class.heapptr = (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_ipv6_network_address_HEAP;
		L_desired_class.dataword.l = 0;
	    }
	    else {

		/* #line 39 "getaddrinfo-test.dylan" */
		/* maker for <simple-object-vector> */
		L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
		L_temp_4.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_2;
		L_temp_4.dataword.l = 0;
		/* signal{<string>} */
		cluster_0_top = dylanZdylan_visceraZsignal_METH_2(orig_sp, L_temp_4, (heapptr_t)&dylanZempty_list_ROOT, L_instance);
		L_desired_class = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);
	    }
	}

	/* #line 40 "getaddrinfo-test.dylan" */
	L_desired_class_2 = L_desired_class;

	/* #line 42 "getaddrinfo-test.dylan" */
	orig_sp[0] = A_sockaddr;
	/* get-sa-data */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 1, (heapptr_t)&network_L101, 1);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 1, L_meth, 1, L_next_info);
	}
	L_arg0 = orig_sp[0];

	/* #line 43 "getaddrinfo-test.dylan" */
	orig_sp[0] = L_desired_class_2;
	/* sockaddr-offset */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 1, (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZsockaddr_offset_ROOT, 1);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 1, L_meth, 1, L_next_info);
	}
	L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

	/* #line 43 "getaddrinfo-test.dylan" */
	orig_sp[0] = L_arg0;
	orig_sp[1] = L_arg1;
	/* + */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, (heapptr_t)&dylanZdylan_visceraZPLUS_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_arg1_2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

	/* #line 44 "getaddrinfo-test.dylan" */
	orig_sp[0] = L_desired_class_2;
	/* address-length */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 1, (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZaddress_length_ROOT, 1);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 1, L_meth, 1, L_next_info);
	}
	L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

	/* #line 49 "./object.dylan" */

	/* #line 386 "./condition.dylan" */
	/* %subtype?{<class>, <class>} */
	L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_arg1_2.heapptr, heapptr_t, 0), (heapptr_t)&melange_supportZmelange_supportZCLS_c_vector_HEAP, (heapptr_t)&dylanZliteral_ROOT_2);
	if (L_condition) {

	    /* #line 44 "getaddrinfo-test.dylan" */
	    /* maker for <simple-object-vector> */
	    L_instance_2 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
	    L_temp_5.heapptr = (heapptr_t)&SYM_size_HEAP;
	    L_temp_5.dataword.l = 0;
	    SLOT(L_instance_2, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp_5;
	    SLOT(L_instance_2, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_arg3;
	    /* copy-vector{subclass(<vector>), <c-vector>} */
	    L_new_data = getaddrinfo_testZgetaddrinfo_testZcopy_vector_METH(orig_sp, (heapptr_t)&dylanZdylan_visceraZCLS_byte_vector_HEAP, L_arg1_2, (heapptr_t)&dylanZempty_list_ROOT, L_instance_2, L_arg3);

	    /* #line 46 "getaddrinfo-test.dylan" */
	    L_temp_6.heapptr = (heapptr_t)&SYM_data_HEAP;
	    L_temp_6.dataword.l = 0;
	    cluster_0_top = orig_sp + 3;
	    orig_sp[0] = L_desired_class_2;
	    orig_sp[1] = L_temp_6;
	    orig_sp[2] = L_new_data;

	    /* #line 125 "./misc.dylan" */
	    cluster_1_top = values_sequence(cluster_0_top, A_args);

	    /* #line 46 "getaddrinfo-test.dylan" */
	    cluster_0_top = cluster_1_top;
	    /* make */
	    {
	      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(cluster_0_top, (heapptr_t)&dylanZdylan_visceraZmake_HEAP, cluster_0_top - orig_sp);
	      heapptr_t L_meth = L_temp.R0;
	      heapptr_t L_next_info = L_temp.R1;
	      cluster_0_top = GENERIC_ENTRY(L_meth)(cluster_0_top, L_meth, cluster_0_top - orig_sp, L_next_info);
	    }
	    L_temp_7 = orig_sp[0];

	    /* #line 386 "./condition.dylan" */
	    L_PCTobject_class_2 = SLOT(L_temp_7.heapptr, heapptr_t, 0);
	    if (((heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_ipv6_network_address_HEAP == L_PCTobject_class_2)) {
		L_temp_8 = TRUE;
	    }
	    else if (((heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_ipv4_network_address_HEAP == L_PCTobject_class_2)) {
		L_temp_8 = TRUE;
	    }
	    else {
		L_temp_8 = ((heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_network_address_HEAP == L_PCTobject_class_2);
	    }
	    if (L_temp_8) {

		/* #line 46 "getaddrinfo-test.dylan" */
		return L_temp_7.heapptr;
	    }
	    else {

		/* #line 389 "./condition.dylan" */
		L_temp_9.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_3;
		L_temp_9.dataword.l = 0;
		/* type-error-with-location */
		dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_7, (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_network_address_HEAP, L_temp_9);
		not_reached();
	    }
	}
	else {
	    L_temp_10.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_4;
	    L_temp_10.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg1_2, (heapptr_t)&melange_supportZmelange_supportZCLS_c_vector_HEAP, L_temp_10);
	    not_reached();
	}
    }
    else {
	L_temp_11.heapptr = (L_temp ? obj_True : obj_False);
	L_temp_11.dataword.l = 0;
	L_temp_12.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_5;
	L_temp_12.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_11, (heapptr_t)&dylanZdylan_visceraZCLS_boolean_HEAP, L_temp_12);
	not_reached();
    }
}

extern heapptr_t dylanZdylan_visceraZmake_rest_arg_FUN(descriptor_t *orig_sp, void * A0, long A1);	/* make-rest-arg */

extern struct dylanZdylan_visceraZCLS_symbol SYM_address_family_HEAP;

extern struct dylanZdylan_visceraZCLS_symbol SYM_sockaddr_HEAP;

/* generic-entry for make{singleton(<network-address>)} */
descriptor_t * getaddrinfo_testZgetaddrinfo_testZmake_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    heapptr_t L_rest; /* rest */
    descriptor_t L_address_family; /* address-family */
    descriptor_t L_sockaddr; /* sockaddr */
    long L_index; /* index */
    descriptor_t L_key; /* key */
    heapptr_t L_key_2; /* key */
    descriptor_t L_value; /* value */
    heapptr_t L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_address_family = dylanZfalse;
    L_sockaddr = dylanZfalse;
    L_index = (A_nargs - 2);
    while (1) {
	if ((L_index < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index]);
	    L_key_2 = L_key.heapptr;
	    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
	    if ((L_key_2 == (heapptr_t)&SYM_address_family_HEAP)) {
		L_address_family = L_value;
	    }
	    else if ((L_key_2 == (heapptr_t)&SYM_sockaddr_HEAP)) {
		L_sockaddr = L_value;
	    }
	    L_index = (L_index - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* make{singleton(<network-address>)} */
    L_result0 = getaddrinfo_testZgetaddrinfo_testZmake_METH(orig_sp, (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_network_address_HEAP, A_next_method_info, L_rest, L_address_family, L_sockaddr);
    L_temp.heapptr = L_result0;
    L_temp.dataword.l = 0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}

/* generic-entry for sockaddr-offset{singleton(<ipv6-network-address>)} */
descriptor_t * getaddrinfo_testZgetaddrinfo_testZsockaddr_offset_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;

    orig_sp = ((void *)(orig_sp - 1));
    /* sockaddr-offset{singleton(<ipv6-network-address>)} */
    cluster_0_top = getaddrinfo_testZgetaddrinfo_testZsockaddr_offset_METH_2(orig_sp, (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_ipv6_network_address_HEAP, A_next_method_info);
    return cluster_0_top;
}

/* generic-entry for sockaddr-offset{singleton(<ipv4-network-address>)} */
descriptor_t * getaddrinfo_testZgetaddrinfo_testZsockaddr_offset_METH_GENERIC_2(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;

    orig_sp = ((void *)(orig_sp - 1));
    /* sockaddr-offset{singleton(<ipv4-network-address>)} */
    cluster_0_top = getaddrinfo_testZgetaddrinfo_testZsockaddr_offset_METH(orig_sp, (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_ipv4_network_address_HEAP, A_next_method_info);
    return cluster_0_top;
}

/* generic-entry for address-length{singleton(<ipv6-network-address>)} */
descriptor_t * getaddrinfo_testZgetaddrinfo_testZaddress_length_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;

    orig_sp = ((void *)(orig_sp - 1));
    /* address-length{singleton(<ipv6-network-address>)} */
    cluster_0_top = getaddrinfo_testZgetaddrinfo_testZaddress_length_METH_2(orig_sp, (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_ipv6_network_address_HEAP, A_next_method_info);
    return cluster_0_top;
}

/* generic-entry for address-length{singleton(<ipv4-network-address>)} */
descriptor_t * getaddrinfo_testZgetaddrinfo_testZaddress_length_METH_GENERIC_2(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;

    orig_sp = ((void *)(orig_sp - 1));
    /* address-length{singleton(<ipv4-network-address>)} */
    cluster_0_top = getaddrinfo_testZgetaddrinfo_testZaddress_length_METH(orig_sp, (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_ipv4_network_address_HEAP, A_next_method_info);
    return cluster_0_top;
}


/* Define Method print-object{<network-address>, <stream>} */

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[7];	 /* %element */
} getaddrinfo_testZstr_ROOT_6;

extern struct dylanZdylan_visceraZCLS_generic_function formatZformatZformat_ROOT;

/* print-object{<network-address>, <stream>} */
void getaddrinfo_testZgetaddrinfo_testZprint_object_METH(descriptor_t *orig_sp, heapptr_t A_address /* address */, heapptr_t A_s /* s */, heapptr_t A2)
{
    heapptr_t L_class_name; /* class-name */
    heapptr_t L_data; /* data */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4;


    /* #line 49 "./object.dylan" */

    /* #line 50 "getaddrinfo-test.dylan" */

    /* #line 50 "getaddrinfo-test.dylan" */
    L_class_name = SLOT(SLOT(A_address, heapptr_t, 0), heapptr_t, 4);
    L_data = SLOT(A_address, heapptr_t, 4);

    /* #line 50 "getaddrinfo-test.dylan" */
    L_temp.heapptr = A_s;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_6;
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = L_class_name;
    L_temp_3.dataword.l = 0;
    L_temp_4.heapptr = L_data;
    L_temp_4.dataword.l = 0;
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    orig_sp[2] = L_temp_3;
    orig_sp[3] = L_temp_4;
    /* format */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 4, (heapptr_t)&formatZformatZformat_ROOT, 4);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      GENERIC_ENTRY(L_meth)(orig_sp + 4, L_meth, 4, L_next_info);
    }
    return;
}

/* generic-entry for print-object{<network-address>, <stream>} */
descriptor_t * getaddrinfo_testZgetaddrinfo_testZprint_object_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_arg_3; /* arg */
    heapptr_t L_arg_4; /* arg */

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 2));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_arg_3 = L_arg.heapptr;
    L_arg_4 = L_arg_2.heapptr;
    orig_sp = L_args;
    /* print-object{<network-address>, <stream>} */
    getaddrinfo_testZgetaddrinfo_testZprint_object_METH(orig_sp, L_arg_3, L_arg_4, A_next_method_info);
    return orig_sp + 0;
}


/* Top level form. */

extern heapptr_t common_extensionsZcommon_extensionsZapplication_arguments_FUN(descriptor_t *orig_sp);	/* application-arguments */

extern struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_addrinfo_HEAP;

extern struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZas_HEAP;

extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_byte_string_HEAP;

struct mv_result_1 {
    long R0;
    void * R1;
};

extern struct mv_result_1 networkZnetwork_internalZgetaddrinfo_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1, void * A2, heapptr_t A3);	/* getaddrinfo{<byte-string>, <byte-string>, <addrinfo>} */

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[4];	 /* %element */
} getaddrinfo_testZstr_ROOT_7;

extern descriptor_t melange_supportZmelange_supportZCnull_pointer;	/* $null-pointer */

extern descriptor_t standard_ioZstandard_ioZVstandard_outputV;	/* *standard-output* */

extern void formatZformatZformat_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1, heapptr_t A2, heapptr_t A3);	/* format{<buffered-stream>, <byte-string>} */

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE50 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[50];	 /* %element */
} getaddrinfo_testZstr_ROOT_8;

extern struct dylanZdylan_visceraZCLS_pair getaddrinfo_testZliteral_ROOT;

extern struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_c_char_vector_HEAP;

extern descriptor_t getaddrinfo_testZliteral_2;	/* proxy for <raw-pointer> */

extern struct dylanZdylan_visceraZCLS_class melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP;

extern struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP;

extern struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP;

extern struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP;

extern struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZEQUAL_HEAP;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[19];	 /* %element */
} getaddrinfo_testZstr_ROOT_9;

extern struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_sockaddr_HEAP;

extern struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_sockaddr_in_HEAP;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[12];	 /* %element */
} getaddrinfo_testZstr_ROOT_10;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE181 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[181];	 /* %element */
} getaddrinfo_testZstr_ROOT_11;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE175 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[175];	 /* %element */
} getaddrinfo_testZstr_ROOT_12;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE181 getaddrinfo_testZstr_ROOT_13;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE175 getaddrinfo_testZstr_ROOT_14;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE181 getaddrinfo_testZstr_ROOT_15;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE175 getaddrinfo_testZstr_ROOT_16;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[10];	 /* %element */
} getaddrinfo_testZstr_ROOT_17;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE183 getaddrinfo_testZstr_ROOT_18;

extern void dylanZdylan_visceraZelement_error_FUN(descriptor_t *orig_sp, descriptor_t A0, long A1);	/* element-error */

/* form at {<known-source-location> 0x08e57870,
   source: {<source-file> 0x087cfb10, name: "getaddrinfo-test.dylan"},
   start-line: 54,
   start-column: 2,
   end-line: 77,
   end-column: 6} */
void getaddrinfo_testZLINE_54(descriptor_t *orig_sp)
{
    descriptor_t *cluster_0_top;
    heapptr_t L_arg0; /* arg0 */
    descriptor_t L_PCTelement; /* %element */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_arg2; /* arg2 */
    heapptr_t L_temp_3; /* temp */
    struct mv_result_1 L_temp_4;
    long L_rc; /* rc */
    void * L_address_list; /* address-list */
    void * L_a; /* a */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    void * L_raw_value; /* raw-value */
    long L_result; /* result */
    long L_result_2; /* result */
    long L_result_3; /* result */
    descriptor_t L_temp_7;
    heapptr_t L_temp_8; /* temp */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp_9;
    descriptor_t L_temp_10;
    descriptor_t L_temp_11;
    descriptor_t L_temp_12;
    descriptor_t L_temp_13;
    descriptor_t L_temp_14;
    descriptor_t L_temp_15; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result_4; /* result */
    heapptr_t L_PCTobject_class; /* %object-class */
    int L_temp_16; /* temp */
    descriptor_t L_result_5; /* result */
    descriptor_t L_temp_17;
    descriptor_t L_temp_18; /* temp */
    int L_arg0_2; /* arg0 */
    descriptor_t L_temp_19;
    heapptr_t L_temp_20; /* temp */
    heapptr_t L_instance_2; /* instance */
    long L_result_6; /* result */
    descriptor_t L_temp_21;
    descriptor_t L_temp_22;
    descriptor_t L_temp_23; /* temp */
    int L_condition_2; /* condition */
    descriptor_t L_result_7; /* result */
    heapptr_t L_PCTobject_class_2; /* %object-class */
    int L_temp_24; /* temp */
    descriptor_t L_temp_25;
    descriptor_t L_temp_26;
    descriptor_t L_temp_27;
    descriptor_t L_temp_28;
    descriptor_t L_address; /* address */
    descriptor_t L_temp_29;
    heapptr_t L_temp_30; /* temp */
    heapptr_t L_instance_3; /* instance */
    descriptor_t L_temp_31;
    descriptor_t L_temp_32;
    descriptor_t L_temp_33; /* temp */
    int L_condition_3; /* condition */
    descriptor_t L_result_8; /* result */
    descriptor_t L_temp_34;
    descriptor_t L_temp_35;
    descriptor_t L_temp_36;
    descriptor_t L_temp_37;
    descriptor_t L_temp_38;
    descriptor_t L_temp_39;
    descriptor_t L_temp_40;
    heapptr_t L_temp_41; /* temp */
    heapptr_t L_instance_4; /* instance */
    descriptor_t L_temp_42;
    descriptor_t L_temp_43;
    descriptor_t L_temp_44;
    descriptor_t L_temp_45;


    /* #line 54 "getaddrinfo-test.dylan" */
    /* application-arguments */
    L_arg0 = common_extensionsZcommon_extensionsZapplication_arguments_FUN(orig_sp);

    /* #line 141 "./vector.dylan" */

    /* #line 141 "./vector.dylan" */
    if ((0 < SLOT(L_arg0, long, 4))) {

	/* #line 142 "./vector.dylan" */
	L_PCTelement = SLOT(L_arg0, descriptor_t, 8 + 0 * sizeof(descriptor_t));

	/* #line 55 "getaddrinfo-test.dylan" */
	L_temp.heapptr = (heapptr_t)&networkZnetwork_internalZCLS_addrinfo_HEAP;
	L_temp.dataword.l = 0;
	L_temp_2.heapptr = getaddrinfo_testZliteral.heapptr;
	L_temp_2.dataword.l = 0;
	orig_sp[0] = L_temp;
	orig_sp[1] = L_temp_2;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, (heapptr_t)&dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_arg2 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if (((heapptr_t)&dylanZdylan_visceraZCLS_byte_string_HEAP == SLOT(L_PCTelement.heapptr, heapptr_t, 0))) {

	    /* #line 55 "getaddrinfo-test.dylan" */

	    /* #line 386 "./condition.dylan" */
	    L_temp_3 = L_PCTelement.heapptr;
	    if (((heapptr_t)&networkZnetwork_internalZCLS_addrinfo_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

		/* #line 55 "getaddrinfo-test.dylan" */
		/* getaddrinfo{<byte-string>, <byte-string>, <addrinfo>} */
		L_temp_4 = networkZnetwork_internalZgetaddrinfo_METH(orig_sp, L_temp_3, (heapptr_t)&getaddrinfo_testZstr_ROOT_7, L_arg2.dataword.ptr, (heapptr_t)&dylanZempty_list_ROOT);
		L_rc = L_temp_4.R0;
		L_address_list = L_temp_4.R1;

		/* #line 164 "./cmp.dylan" */
		if ((L_rc == 0)) {
		    /* #line {Class <compound-macro-source-location>} */
		    L_a = L_address_list;
		    while (1) {
			/* #line {Class <unknown-source-location>} */

			/* #line 60 "getaddrinfo-test.dylan" */
			if ((L_temp_5 = melange_supportZmelange_supportZCnull_pointer).heapptr == NULL) abort();
			L_temp_6 = L_temp_5;

			/* #line 309 "./melange.dylan" */
			L_raw_value = L_a;

			/* #line 309 "./melange.dylan" */

			/* #line 60 "getaddrinfo-test.dylan" */
			if ((L_raw_value == L_temp_6.dataword.ptr)) {
			    goto block0;
			}
			else {

			    /* #line 91 "./rawptr.dylan" */

			    /* #line 91 "./rawptr.dylan" */
			    L_result = (*(long *)((char *)L_raw_value + 0 ));

			    /* #line 91 "./rawptr.dylan" */
			    L_result_2 = (*(long *)((char *)L_raw_value + 4 ));

			    /* #line 91 "./rawptr.dylan" */
			    L_result_3 = (*(long *)((char *)L_raw_value + 8 ));

			    /* #line 36 "./format-out.dylan" */
			    if ((L_temp_7 = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
			    L_temp_8 = L_temp_7.heapptr;

			    /* #line 36 "./format-out.dylan" */
			    /* maker for <simple-object-vector> */
			    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 4, dylanZfalse);
			    L_temp_9.heapptr = getaddrinfo_testZliteral.heapptr;
			    L_temp_9.dataword.l = L_result;
			    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp_9;
			    L_temp_10.heapptr = getaddrinfo_testZliteral.heapptr;
			    L_temp_10.dataword.l = L_result_2;
			    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_10;
			    L_temp_11.heapptr = getaddrinfo_testZliteral.heapptr;
			    L_temp_11.dataword.l = L_result_3;
			    SLOT(L_instance, descriptor_t, 8 + 2 * sizeof(descriptor_t)) = L_temp_11;
			    L_temp_12.heapptr = getaddrinfo_testZliteral.heapptr;
			    L_temp_12.dataword.l = (*(long *)((char *)L_raw_value + 12 ));
			    SLOT(L_instance, descriptor_t, 8 + 3 * sizeof(descriptor_t)) = L_temp_12;
			    /* format{<buffered-stream>, <byte-string>} */
			    formatZformatZformat_METH(orig_sp, L_temp_8, (heapptr_t)&getaddrinfo_testZstr_ROOT_8, (heapptr_t)&getaddrinfo_testZliteral_ROOT, L_instance);

			    /* #line 91 "./rawptr.dylan" */

			    /* #line 290 "./melange.dylan" */
			    L_temp_13.heapptr = (heapptr_t)&networkZnetwork_internalZCLS_c_char_vector_HEAP;
			    L_temp_13.dataword.l = 0;
			    L_temp_14.heapptr = getaddrinfo_testZliteral_2.heapptr;
			    L_temp_14.dataword.ptr = (*(void * *)((char *)L_raw_value + 24 ));
			    orig_sp[0] = L_temp_13;
			    orig_sp[1] = L_temp_14;
			    /* as */
			    {
			      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, (heapptr_t)&dylanZdylan_visceraZas_HEAP, 2);
			      heapptr_t L_meth = L_temp.R0;
			      heapptr_t L_next_info = L_temp.R1;
			      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
			    }
			    L_temp_15 = orig_sp[0];

			    /* #line 49 "./object.dylan" */

			    /* #line 386 "./condition.dylan" */
			    /* %subtype?{<class>, <class>} */
			    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_15.heapptr, heapptr_t, 0), (heapptr_t)&melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, (heapptr_t)&dylanZliteral_ROOT_2);
			    if (L_condition) {

				/* #line 290 "./melange.dylan" */
				L_result_4 = L_temp_15;

				/* #line 386 "./condition.dylan" */
				L_PCTobject_class = SLOT(L_result_4.heapptr, heapptr_t, 0);
				if (((heapptr_t)&networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP == L_PCTobject_class)) {
				    L_temp_16 = TRUE;
				}
				else if (((heapptr_t)&networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP == L_PCTobject_class)) {
				    L_temp_16 = TRUE;
				}
				else if (((heapptr_t)&networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP == L_PCTobject_class)) {
				    L_temp_16 = TRUE;
				}
				else {
				    L_temp_16 = ((heapptr_t)&networkZnetwork_internalZCLS_c_char_vector_HEAP == L_PCTobject_class);
				}
				if (L_temp_16) {

				    /* #line 3661 "./sockets-api.dylan" */
				    L_result_5 = L_result_4;

				    /* #line 68 "getaddrinfo-test.dylan" */
				    if ((L_temp_17 = melange_supportZmelange_supportZCnull_pointer).heapptr == NULL) abort();
				    L_temp_18 = L_temp_17;

				    /* #line 164 "./cmp.dylan" */
				    orig_sp[0] = L_result_5;
				    orig_sp[1] = L_temp_18;
				    /* = */
				    {
				      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, (heapptr_t)&dylanZdylan_visceraZEQUAL_HEAP, 2);
				      heapptr_t L_meth = L_temp.R0;
				      heapptr_t L_next_info = L_temp.R1;
				      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
				    }
				    L_arg0_2 = (orig_sp[0].heapptr != obj_False);
				    if (L_arg0_2) {
				    }
				    else {

					/* #line 36 "./format-out.dylan" */
					if ((L_temp_19 = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
					L_temp_20 = L_temp_19.heapptr;

					/* #line 36 "./format-out.dylan" */
					/* maker for <simple-object-vector> */
					L_instance_2 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 1, dylanZfalse);
					SLOT(L_instance_2, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_result_5;
					/* format{<buffered-stream>, <byte-string>} */
					formatZformatZformat_METH(orig_sp, L_temp_20, (heapptr_t)&getaddrinfo_testZstr_ROOT_9, (heapptr_t)&getaddrinfo_testZliteral_ROOT, L_instance_2);
				    }

				    /* #line 91 "./rawptr.dylan" */

				    /* #line 91 "./rawptr.dylan" */
				    L_result_6 = (*(long *)((char *)L_raw_value + 4 ));

				    /* #line 290 "./melange.dylan" */
				    L_temp_21.heapptr = (heapptr_t)&networkZnetwork_internalZCLS_sockaddr_HEAP;
				    L_temp_21.dataword.l = 0;
				    L_temp_22.heapptr = getaddrinfo_testZliteral_2.heapptr;
				    L_temp_22.dataword.ptr = (*(void * *)((char *)L_raw_value + 20 ));
				    orig_sp[0] = L_temp_21;
				    orig_sp[1] = L_temp_22;
				    /* as */
				    {
				      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, (heapptr_t)&dylanZdylan_visceraZas_HEAP, 2);
				      heapptr_t L_meth = L_temp.R0;
				      heapptr_t L_next_info = L_temp.R1;
				      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
				    }
				    L_temp_23 = orig_sp[0];

				    /* #line 49 "./object.dylan" */

				    /* #line 386 "./condition.dylan" */
				    /* %subtype?{<class>, <class>} */
				    L_condition_2 = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_23.heapptr, heapptr_t, 0), (heapptr_t)&melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, (heapptr_t)&dylanZliteral_ROOT_2);
				    if (L_condition_2) {

					/* #line 290 "./melange.dylan" */
					L_result_7 = L_temp_23;

					/* #line 386 "./condition.dylan" */
					L_PCTobject_class_2 = SLOT(L_result_7.heapptr, heapptr_t, 0);
					if (((heapptr_t)&networkZnetwork_internalZCLS_sockaddr_in_HEAP == L_PCTobject_class_2)) {
					    L_temp_24 = TRUE;
					}
					else {
					    L_temp_24 = ((heapptr_t)&networkZnetwork_internalZCLS_sockaddr_HEAP == L_PCTobject_class_2);
					}
					if (L_temp_24) {

					    /* #line 3650 "./sockets-api.dylan" */

					    /* #line 73 "getaddrinfo-test.dylan" */
					    L_temp_25.heapptr = (heapptr_t)&getaddrinfo_testZgetaddrinfo_testZCLS_network_address_HEAP;
					    L_temp_25.dataword.l = 0;
					    L_temp_26.heapptr = (heapptr_t)&SYM_address_family_HEAP;
					    L_temp_26.dataword.l = 0;
					    L_temp_27.heapptr = getaddrinfo_testZliteral.heapptr;
					    L_temp_27.dataword.l = L_result_6;
					    L_temp_28.heapptr = (heapptr_t)&SYM_sockaddr_HEAP;
					    L_temp_28.dataword.l = 0;
					    orig_sp[0] = L_temp_25;
					    orig_sp[1] = L_temp_26;
					    orig_sp[2] = L_temp_27;
					    orig_sp[3] = L_temp_28;
					    orig_sp[4] = L_result_7;
					    /* make */
					    {
					      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 5, (heapptr_t)&dylanZdylan_visceraZmake_HEAP, 5);
					      heapptr_t L_meth = L_temp.R0;
					      heapptr_t L_next_info = L_temp.R1;
					      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 5, L_meth, 5, L_next_info);
					    }
					    L_address = orig_sp[0];

					    /* #line 36 "./format-out.dylan" */
					    if ((L_temp_29 = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
					    L_temp_30 = L_temp_29.heapptr;

					    /* #line 36 "./format-out.dylan" */
					    /* maker for <simple-object-vector> */
					    L_instance_3 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 1, dylanZfalse);
					    SLOT(L_instance_3, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_address;
					    /* format{<buffered-stream>, <byte-string>} */
					    formatZformatZformat_METH(orig_sp, L_temp_30, (heapptr_t)&getaddrinfo_testZstr_ROOT_10, (heapptr_t)&getaddrinfo_testZliteral_ROOT, L_instance_3);

					    /* #line 91 "./rawptr.dylan" */

					    /* #line 290 "./melange.dylan" */
					    L_temp_31.heapptr = (heapptr_t)&networkZnetwork_internalZCLS_addrinfo_HEAP;
					    L_temp_31.dataword.l = 0;
					    L_temp_32.heapptr = getaddrinfo_testZliteral_2.heapptr;
					    L_temp_32.dataword.ptr = (*(void * *)((char *)L_raw_value + 28 ));
					    orig_sp[0] = L_temp_31;
					    orig_sp[1] = L_temp_32;
					    /* as */
					    {
					      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, (heapptr_t)&dylanZdylan_visceraZas_HEAP, 2);
					      heapptr_t L_meth = L_temp.R0;
					      heapptr_t L_next_info = L_temp.R1;
					      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
					    }
					    L_temp_33 = orig_sp[0];

					    /* #line 49 "./object.dylan" */

					    /* #line 386 "./condition.dylan" */
					    /* %subtype?{<class>, <class>} */
					    L_condition_3 = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_33.heapptr, heapptr_t, 0), (heapptr_t)&melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, (heapptr_t)&dylanZliteral_ROOT_2);
					    if (L_condition_3) {

						/* #line 290 "./melange.dylan" */
						L_result_8 = L_temp_33;

						/* #line 386 "./condition.dylan" */
						if (((heapptr_t)&networkZnetwork_internalZCLS_addrinfo_HEAP == SLOT(L_result_8.heapptr, heapptr_t, 0))) {

						    /* #line 3672 "./sockets-api.dylan" */
						    /* #line {Class <compound-macro-source-location>} */
						    L_a = L_result_8.dataword.ptr;
						}
						else {

						    /* #line 389 "./condition.dylan" */
						    L_temp_34.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_11;
						    L_temp_34.dataword.l = 0;
						    /* type-error-with-location */
						    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_8, (heapptr_t)&networkZnetwork_internalZCLS_addrinfo_HEAP, L_temp_34);
						    not_reached();
						}
					    }
					    else {
						L_temp_35.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_12;
						L_temp_35.dataword.l = 0;
						/* type-error-with-location */
						dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_33, (heapptr_t)&melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_35);
						not_reached();
					    }
					}
					else {
					    L_temp_36.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_13;
					    L_temp_36.dataword.l = 0;
					    /* type-error-with-location */
					    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_7, (heapptr_t)&networkZnetwork_internalZCLS_sockaddr_HEAP, L_temp_36);
					    not_reached();
					}
				    }
				    else {
					L_temp_37.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_14;
					L_temp_37.dataword.l = 0;
					/* type-error-with-location */
					dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_23, (heapptr_t)&melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_37);
					not_reached();
				    }
				}
				else {
				    L_temp_38.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_15;
				    L_temp_38.dataword.l = 0;
				    /* type-error-with-location */
				    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_4, (heapptr_t)&networkZnetwork_internalZCLS_c_char_vector_HEAP, L_temp_38);
				    not_reached();
				}
			    }
			    else {
				L_temp_39.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_16;
				L_temp_39.dataword.l = 0;
				/* type-error-with-location */
				dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_15, (heapptr_t)&melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_39);
				not_reached();
			    }
			}
		    }
		  block0:;
		}
		else {

		    /* #line 36 "./format-out.dylan" */
		    if ((L_temp_40 = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
		    L_temp_41 = L_temp_40.heapptr;

		    /* #line 36 "./format-out.dylan" */
		    /* maker for <simple-object-vector> */
		    L_instance_4 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 1, dylanZfalse);
		    L_temp_42.heapptr = getaddrinfo_testZliteral.heapptr;
		    L_temp_42.dataword.l = L_rc;
		    SLOT(L_instance_4, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp_42;
		    /* format{<buffered-stream>, <byte-string>} */
		    formatZformatZformat_METH(orig_sp, L_temp_41, (heapptr_t)&getaddrinfo_testZstr_ROOT_17, (heapptr_t)&getaddrinfo_testZliteral_ROOT, L_instance_4);
		}
		return;
	    }
	    else {

		/* #line 389 "./condition.dylan" */
		L_temp_43.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_18;
		L_temp_43.dataword.l = 0;
		/* type-error-with-location */
		dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, (heapptr_t)&networkZnetwork_internalZCLS_addrinfo_HEAP, L_temp_43);
		not_reached();
	    }
	}
	else {
	    L_temp_44.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_18;
	    L_temp_44.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_PCTelement, (heapptr_t)&dylanZdylan_visceraZCLS_byte_string_HEAP, L_temp_44);
	    not_reached();
	}
    }
    else {

	/* #line 144 "./vector.dylan" */
	L_temp_45.heapptr = L_arg0;
	L_temp_45.dataword.l = 0;
	/* element-error */
	dylanZdylan_visceraZelement_error_FUN(orig_sp, L_temp_45, 0);
	not_reached();
    }
}


/* {Implicit} Define Generic copy-vector */

/* copy-vector is copy-vector */


/* Define Method copy-vector{subclass(<vector>), <c-vector>} */

extern struct dylanZdylan_visceraZCLS_generic_function melange_supportZmelange_supportZcontent_size_HEAP;

extern struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZLESS_HEAP;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE37 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[37];	 /* %element */
} getaddrinfo_testZstr_ROOT_19;

extern int dylanZdylan_visceraZLESSEQUAL_DISCRIM_FUN(descriptor_t *orig_sp, descriptor_t A0, descriptor_t A1);	/* discriminator for <= */

extern struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZelement_HEAP;

extern struct dylanZdylan_visceraZCLS_generic_function dylan_L304;

extern struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZelement_setter_HEAP;

extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_vector_HEAP;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE184 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[184];	 /* %element */
} getaddrinfo_testZstr_ROOT_20;

/* copy-vector{subclass(<vector>), <c-vector>} */
descriptor_t getaddrinfo_testZgetaddrinfo_testZcopy_vector_METH(descriptor_t *orig_sp, heapptr_t A_class /* class */, descriptor_t A_c_vector /* c-vector */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_size /* size */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    long L_vector_size; /* vector-size */
    descriptor_t L_temp_2;
    int L_condition; /* condition */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp_3;
    descriptor_t L_new_size; /* new-size */
    descriptor_t L_temp_4;
    descriptor_t L_new_size_2; /* new-size */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6;
    descriptor_t L_new_vector; /* new-vector */
    long L_i; /* i */
    long L_i_2; /* i */
    descriptor_t L_temp_7;
    int L_answer; /* answer */
    descriptor_t L_temp_8;
    descriptor_t L_arg0; /* arg0 */
    descriptor_t L_temp_9;
    descriptor_t L_new_value; /* new-value */
    descriptor_t L_temp_10;
    int L_condition_2; /* condition */
    descriptor_t L_temp_11;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */

    /* #line 82 "getaddrinfo-test.dylan" */
    L_temp.heapptr = SLOT(A_c_vector.heapptr, heapptr_t, 0);
    L_temp.dataword.l = 0;
    orig_sp[0] = L_temp;
    /* content-size */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 1, (heapptr_t)&melange_supportZmelange_supportZcontent_size_HEAP, 1);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 1, L_meth, 1, L_next_info);
    }
    L_vector_size = orig_sp[0].dataword.l;
    if ((A_size.heapptr != obj_False)) {

	/* #line 85 "getaddrinfo-test.dylan" */
	L_temp_2.heapptr = getaddrinfo_testZliteral.heapptr;
	L_temp_2.dataword.l = L_vector_size;
	orig_sp[0] = L_temp_2;
	orig_sp[1] = A_size;
	/* < */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, (heapptr_t)&dylanZdylan_visceraZLESS_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_condition = (orig_sp[0].heapptr != obj_False);
	if (L_condition) {

	    /* #line 86 "getaddrinfo-test.dylan" */
	    /* maker for <simple-object-vector> */
	    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
	    L_temp_3.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_19;
	    L_temp_3.dataword.l = 0;
	    /* signal{<string>} */
	    dylanZdylan_visceraZsignal_METH_2(orig_sp, L_temp_3, (heapptr_t)&dylanZempty_list_ROOT, L_instance);
	}

	/* #line 91 "getaddrinfo-test.dylan" */
	L_new_size = A_size;
    }
    else {

	/* #line 94 "getaddrinfo-test.dylan" */
	L_temp_4.heapptr = getaddrinfo_testZliteral.heapptr;
	L_temp_4.dataword.l = L_vector_size;
	L_new_size = L_temp_4;
    }

    /* #line 98 "getaddrinfo-test.dylan" */
    L_new_size_2 = L_new_size;

    /* #line 100 "getaddrinfo-test.dylan" */
    L_temp_5.heapptr = A_class;
    L_temp_5.dataword.l = 0;
    L_temp_6.heapptr = (heapptr_t)&SYM_size_HEAP;
    L_temp_6.dataword.l = 0;
    orig_sp[0] = L_temp_5;
    orig_sp[1] = L_temp_6;
    orig_sp[2] = L_new_size_2;
    /* make */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 3, (heapptr_t)&dylanZdylan_visceraZmake_HEAP, 3);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 3, L_meth, 3, L_next_info);
    }
    L_new_vector = orig_sp[0];
    /* #line {Class <compound-macro-source-location>} */
    L_i = 0;
    while (1) {
	/* #line {Class <unknown-source-location>} */
	L_i_2 = L_i;

	/* #line 173 "./cmp.dylan" */
	L_temp_7.heapptr = getaddrinfo_testZliteral.heapptr;
	L_temp_7.dataword.l = L_i_2;
	/* discriminator for <= */
	L_answer = dylanZdylan_visceraZLESSEQUAL_DISCRIM_FUN(orig_sp, L_new_size_2, L_temp_7);
	if (L_answer) {
	    goto block0;
	}
	else {

	    /* #line 102 "getaddrinfo-test.dylan" */
	    L_temp_8.heapptr = getaddrinfo_testZliteral.heapptr;
	    L_temp_8.dataword.l = L_i_2;
	    orig_sp[0] = A_c_vector;
	    orig_sp[1] = L_temp_8;
	    /* element */
	    {
	      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, (heapptr_t)&dylanZdylan_visceraZelement_HEAP, 2);
	      heapptr_t L_meth = L_temp.R0;
	      heapptr_t L_next_info = L_temp.R1;
	      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	    }
	    L_arg0 = orig_sp[0];

	    /* #line 102 "getaddrinfo-test.dylan" */
	    L_temp_9.heapptr = getaddrinfo_testZliteral.heapptr;
	    L_temp_9.dataword.l = 256;
	    orig_sp[0] = L_arg0;
	    orig_sp[1] = L_temp_9;
	    /* modulo */
	    {
	      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, (heapptr_t)&dylan_L304, 2);
	      heapptr_t L_meth = L_temp.R0;
	      heapptr_t L_next_info = L_temp.R1;
	      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	    }
	    L_new_value = orig_sp[0];
	    /* #line {Class <unknown-source-location>} */
	    L_temp_10.heapptr = getaddrinfo_testZliteral.heapptr;
	    L_temp_10.dataword.l = L_i_2;
	    orig_sp[0] = L_new_value;
	    orig_sp[1] = L_new_vector;
	    orig_sp[2] = L_temp_10;
	    /* element-setter */
	    {
	      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 3, (heapptr_t)&dylanZdylan_visceraZelement_setter_HEAP, 3);
	      heapptr_t L_meth = L_temp.R0;
	      heapptr_t L_next_info = L_temp.R1;
	      GENERIC_ENTRY(L_meth)(orig_sp + 3, L_meth, 3, L_next_info);
	    }
	    /* #line {Class <compound-macro-source-location>} */
	    L_i = (L_i_2 + 1);
	}
    }
  block0:;

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition_2 = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_new_vector.heapptr, heapptr_t, 0), (heapptr_t)&dylanZdylan_visceraZCLS_vector_HEAP, (heapptr_t)&dylanZliteral_ROOT_2);
    if (L_condition_2) {

	/* #line 104 "getaddrinfo-test.dylan" */
	return L_new_vector;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_11.heapptr = (heapptr_t)&getaddrinfo_testZstr_ROOT_20;
	L_temp_11.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_new_vector, (heapptr_t)&dylanZdylan_visceraZCLS_vector_HEAP, L_temp_11);
	not_reached();
    }
}

extern void getaddrinfo_testZLINE_54(descriptor_t *sp);

void getaddrinfo_test_Library_init(descriptor_t *sp)
{
    getaddrinfo_testZLINE_54(sp);
}

extern heapptr_t L0;

descriptor_t getaddrinfo_testZliteral =
    { (heapptr_t) &L0, { 0 } } /* roots[0] */;


extern heapptr_t L1;

descriptor_t getaddrinfo_testZliteral_2 =
{ (heapptr_t) &L1, { 0 } } /* roots[1] */;


/* heap base */

/* proxy for <integer> */
heapptr_t L0 =
(heapptr_t) &dylanZdylan_visceraZCLS_integer_HEAP /* %object-class */;

/* proxy for <raw-pointer> */
extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_raw_pointer_HEAP;

heapptr_t L1 =
(heapptr_t) &dylanZdylan_visceraZCLS_raw_pointer_HEAP /* %object-class */;

/* data */
extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_generic_function_HEAP;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L7;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[1];	 /* %element */
} L8;

extern struct dylanZdylan_visceraZCLS_false {
    heapptr_t PCTobject_class;	 /* %object-class */
} dylan_L1;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE0 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
} dylanZliteral_ROOT_5;

extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_object_HEAP;

extern struct dylanZdylan_visceraZCLS_pair L9;

struct dylanZdylan_visceraZCLS_generic_function L2 = {
(heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L7 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L8 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L9 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* data-setter */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[11];	 /* %element */
} L10;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[2];	 /* %element */
} L11;

extern struct dylanZdylan_visceraZCLS_pair L12;

struct dylanZdylan_visceraZCLS_generic_function L3 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L10 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L11 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L12 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* "{<unknown-source-location> instance at 0x860dfc8}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE49 getaddrinfo_testZstr_ROOT = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    49 /* size */,
    "{<unknown-source-location> instance at 0x860dfc8}",
};

/* address-length */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[14];	 /* %element */
} L13;

extern struct dylanZdylan_visceraZCLS_pair L14;

struct dylanZdylan_visceraZCLS_generic_function getaddrinfo_testZgetaddrinfo_testZaddress_length_ROOT = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L13 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L8 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L14 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* sockaddr-offset */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[15];	 /* %element */
} L15;

extern struct dylanZdylan_visceraZCLS_pair L16;

struct dylanZdylan_visceraZCLS_generic_function getaddrinfo_testZgetaddrinfo_testZsockaddr_offset_ROOT = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L15 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L8 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L16 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* make{singleton(<network-address>)} */
extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_method_HEAP;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE34 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[34];	 /* %element */
} L17;

extern descriptor_t * dylanZdylan_visceraZgeneral_call_FUN(descriptor_t *orig_sp, heapptr_t A0, long A1);	/* general-call */

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L18;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L19;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L20;

extern struct dylanZdylan_visceraZCLS_union {
    heapptr_t PCTobject_class;	 /* %object-class */
    heapptr_t union_members;	 /* union-members */
    heapptr_t union_singletons;	 /* union-singletons */
} dylanZliteral_ROOT_37;

struct dylanZdylan_visceraZCLS_method {
    heapptr_t PCTobject_class;	 /* %object-class */
    heapptr_t function_name;	 /* function-name */
    void * general_entry;	 /* general-entry */
    heapptr_t function_specializers;	 /* function-specializers */
    char function_restQUERY;	 /* function-rest? */
    char function_all_keysQUERY;	 /* function-all-keys? */
    unsigned char HOLE1[2];
    heapptr_t function_keywords;	 /* function-keywords */
    heapptr_t function_values;	 /* function-values */
    heapptr_t function_rest_value;	 /* function-rest-value */
    void * generic_entry;	 /* generic-entry */
} L4 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_method_HEAP /* %object-class */,
    (heapptr_t) &L17 /* function-name */,
    dylanZdylan_visceraZgeneral_call_FUN /* general-entry */,
    (heapptr_t) &L18 /* function-specializers */,
    1 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L19 /* function-keywords */,
    (heapptr_t) &L20 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    getaddrinfo_testZgetaddrinfo_testZmake_METH_GENERIC /* generic-entry */,
};

/* "Unknown Address Family in call to make(<network-address>, address-family: )" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE75 getaddrinfo_testZstr_ROOT_2 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    75 /* size */,
    "Unknown Address Family in call to make(<network-address>, address-family: )",
};

/* "{<known-source-location> 0x08dc9078,\n   source: {<source-file> 0x087cfb10, name: \"getaddrinfo-test.dylan\"},\n   start-line: 46,\n   start-column: 2,\n   end-line: 46,\n   end-column: 53}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE182 getaddrinfo_testZstr_ROOT_3 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    182 /* size */,
    "{<known-source-location> 0x08dc9078,\n   source: {<source-file> 0x087cfb10, name: \"getaddrinfo-test.dylan\"},\n   start-line: 46,\n   start-column: 2,\n   end-line: 46,\n   end-column: 53}",
};

/* "{<known-source-location> 0x08dc3b40,\n   source: {<source-file> 0x087cfb10, name: \"getaddrinfo-test.dylan\"},\n   start-line: 41,\n   start-column: 17,\n   end-line: 44,\n   end-column: 64}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE183 getaddrinfo_testZstr_ROOT_4 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    183 /* size */,
    "{<known-source-location> 0x08dc3b40,\n   source: {<source-file> 0x087cfb10, name: \"getaddrinfo-test.dylan\"},\n   start-line: 41,\n   start-column: 17,\n   end-line: 44,\n   end-column: 64}",
};

/* "{<compound-macro-source-location> instance at 0x8bd8300}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE56 getaddrinfo_testZstr_ROOT_5 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    56 /* size */,
    "{<compound-macro-source-location> instance at 0x8bd8300}",
};

/* print-object{<network-address>, <stream>} */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE41 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[41];	 /* %element */
} L21;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L22;

struct dylanZdylan_visceraZCLS_method L5 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_method_HEAP /* %object-class */,
    (heapptr_t) &L21 /* function-name */,
    dylanZdylan_visceraZgeneral_call_FUN /* general-entry */,
    (heapptr_t) &L22 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    getaddrinfo_testZgetaddrinfo_testZprint_object_METH_GENERIC /* generic-entry */,
};

/* "{%s %=}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE7 getaddrinfo_testZstr_ROOT_6 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    7 /* size */,
    "{%s %=}",
};

/* "http" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE4 getaddrinfo_testZstr_ROOT_7 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    4 /* size */,
    "http",
};

/* "Flags: %=, Family: %=, Socktype: %=, Protocol: %=\n" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE50 getaddrinfo_testZstr_ROOT_8 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    50 /* size */,
    "Flags: %=, Family: %=, Socktype: %=, Protocol: %=\n",
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_pair_HEAP;

extern struct dylanZdylan_visceraZCLS_method format_L110;

struct dylanZdylan_visceraZCLS_pair getaddrinfo_testZliteral_ROOT = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &format_L110, { 0 } } /* head */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* tail */,
};

/* "Canoncial name: %=\n" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE19 getaddrinfo_testZstr_ROOT_9 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    19 /* size */,
    "Canoncial name: %=\n",
};

/* "Address: %=\n" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE12 getaddrinfo_testZstr_ROOT_10 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    12 /* size */,
    "Address: %=\n",
};

/* "{<known-source-location> 0x08c33550,\n   source: {<source-file> 0x09df0888, name: \"sockets-api.dylan\"},\n   start-line: 3672,\n   start-column: 2,\n   end-line: 3672,\n   end-column: 48}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE181 getaddrinfo_testZstr_ROOT_11 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    181 /* size */,
    "{<known-source-location> 0x08c33550,\n   source: {<source-file> 0x09df0888, name: \"sockets-api.dylan\"},\n   start-line: 3672,\n   start-column: 2,\n   end-line: 3672,\n   end-column: 48}",
};

/* "{<known-source-location> 0x08c33618,\n   source: {<source-file> 0x09edb2d0, name: \"melange.dylan\"},\n   start-line: 290,\n   start-column: 2,\n   end-line: 290,\n   end-column: 55}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE175 getaddrinfo_testZstr_ROOT_12 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    175 /* size */,
    "{<known-source-location> 0x08c33618,\n   source: {<source-file> 0x09edb2d0, name: \"melange.dylan\"},\n   start-line: 290,\n   start-column: 2,\n   end-line: 290,\n   end-column: 55}",
};

/* "{<known-source-location> 0x08c04118,\n   source: {<source-file> 0x09df0888, name: \"sockets-api.dylan\"},\n   start-line: 3650,\n   start-column: 2,\n   end-line: 3650,\n   end-column: 48}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE181 getaddrinfo_testZstr_ROOT_13 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    181 /* size */,
    "{<known-source-location> 0x08c04118,\n   source: {<source-file> 0x09df0888, name: \"sockets-api.dylan\"},\n   start-line: 3650,\n   start-column: 2,\n   end-line: 3650,\n   end-column: 48}",
};

/* "{<known-source-location> 0x08c041e0,\n   source: {<source-file> 0x09edb2d0, name: \"melange.dylan\"},\n   start-line: 290,\n   start-column: 2,\n   end-line: 290,\n   end-column: 55}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE175 getaddrinfo_testZstr_ROOT_14 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    175 /* size */,
    "{<known-source-location> 0x08c041e0,\n   source: {<source-file> 0x09edb2d0, name: \"melange.dylan\"},\n   start-line: 290,\n   start-column: 2,\n   end-line: 290,\n   end-column: 55}",
};

/* "{<known-source-location> 0x08c33e10,\n   source: {<source-file> 0x09df0888, name: \"sockets-api.dylan\"},\n   start-line: 3661,\n   start-column: 2,\n   end-line: 3661,\n   end-column: 53}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE181 getaddrinfo_testZstr_ROOT_15 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    181 /* size */,
    "{<known-source-location> 0x08c33e10,\n   source: {<source-file> 0x09df0888, name: \"sockets-api.dylan\"},\n   start-line: 3661,\n   start-column: 2,\n   end-line: 3661,\n   end-column: 53}",
};

/* "{<known-source-location> 0x08c33fa0,\n   source: {<source-file> 0x09edb2d0, name: \"melange.dylan\"},\n   start-line: 290,\n   start-column: 2,\n   end-line: 290,\n   end-column: 55}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE175 getaddrinfo_testZstr_ROOT_16 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    175 /* size */,
    "{<known-source-location> 0x08c33fa0,\n   source: {<source-file> 0x09edb2d0, name: \"melange.dylan\"},\n   start-line: 290,\n   start-column: 2,\n   end-line: 290,\n   end-column: 55}",
};

/* "Error: %=\n" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE10 getaddrinfo_testZstr_ROOT_17 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    10 /* size */,
    "Error: %=\n",
};

/* "{<known-source-location> 0x08e04320,\n   source: {<source-file> 0x087cfb10, name: \"getaddrinfo-test.dylan\"},\n   start-line: 55,\n   start-column: 27,\n   end-line: 55,\n   end-column: 71}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE183 getaddrinfo_testZstr_ROOT_18 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    183 /* size */,
    "{<known-source-location> 0x08e04320,\n   source: {<source-file> 0x087cfb10, name: \"getaddrinfo-test.dylan\"},\n   start-line: 55,\n   start-column: 27,\n   end-line: 55,\n   end-column: 71}",
};

/* copy-vector */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L23;

extern struct dylanZdylan_visceraZCLS_pair L24;

struct dylanZdylan_visceraZCLS_generic_function L6 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L23 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L11 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L24 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* "Accessing C array beyond known bounds" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE37 getaddrinfo_testZstr_ROOT_19 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    37 /* size */,
    "Accessing C array beyond known bounds",
};

/* "{<known-source-location> 0x08eaed20,\n   source: {<source-file> 0x087cfb10, name: \"getaddrinfo-test.dylan\"},\n   start-line: 104,\n   start-column: 2,\n   end-line: 104,\n   end-column: 12}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE184 getaddrinfo_testZstr_ROOT_20 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    184 /* size */,
    "{<known-source-location> 0x08eaed20,\n   source: {<source-file> 0x087cfb10, name: \"getaddrinfo-test.dylan\"},\n   start-line: 104,\n   start-column: 2,\n   end-line: 104,\n   end-column: 12}",
};

/* "data" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L7 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    4 /* size */,
    "data",
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_object_vector_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L8 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_accessor_method {
    heapptr_t PCTobject_class;	 /* %object-class */
    heapptr_t function_name;	 /* function-name */
    void * general_entry;	 /* general-entry */
    heapptr_t function_specializers;	 /* function-specializers */
    char function_restQUERY;	 /* function-rest? */
    char function_all_keysQUERY;	 /* function-all-keys? */
    unsigned char HOLE1[2];
    heapptr_t function_keywords;	 /* function-keywords */
    heapptr_t function_values;	 /* function-values */
    heapptr_t function_rest_value;	 /* function-rest-value */
    void * generic_entry;	 /* generic-entry */
    heapptr_t accessor_slot;	 /* accessor-slot */
} L25;

struct dylanZdylan_visceraZCLS_pair L9 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &L25, { 0 } } /* head */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* tail */,
};

/* "data-setter" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L10 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    11 /* size */,
    "data-setter",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L11 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_accessor_method L26;

struct dylanZdylan_visceraZCLS_pair L12 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &L26, { 0 } } /* head */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* tail */,
};

/* "address-length" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L13 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    14 /* size */,
    "address-length",
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method L27;

extern struct dylanZdylan_visceraZCLS_pair L28;

struct dylanZdylan_visceraZCLS_pair L14 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &L27, { 0 } } /* head */,
    { (heapptr_t) &L28, { 0 } } /* tail */,
};

/* "sockaddr-offset" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L15 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    15 /* size */,
    "sockaddr-offset",
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method L29;

extern struct dylanZdylan_visceraZCLS_pair L30;

struct dylanZdylan_visceraZCLS_pair L16 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &L29, { 0 } } /* head */,
    { (heapptr_t) &L30, { 0 } } /* tail */,
};

/* "make{singleton(<network-address>)}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE34 L17 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    34 /* size */,
    "make{singleton(<network-address>)}",
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_singleton {
    heapptr_t PCTobject_class;	 /* %object-class */
    descriptor_t singleton_object;	 /* singleton-object */
} L31;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L18 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L31, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L19 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &SYM_address_family_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &SYM_sockaddr_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L20 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &getaddrinfo_testZgetaddrinfo_testZCLS_network_address_HEAP, { 0 } } /* %element[0] */,
    },
};

/* "print-object{<network-address>, <stream>}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE41 L21 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    41 /* size */,
    "print-object{<network-address>, <stream>}",
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_stream_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L22 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &getaddrinfo_testZgetaddrinfo_testZCLS_network_address_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &streamsZstreamsZCLS_stream_HEAP, { 0 } } /* %element[1] */,
    },
};

/* "copy-vector" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L23 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    11 /* size */,
    "copy-vector",
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method L32;

struct dylanZdylan_visceraZCLS_pair L24 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &L32, { 0 } } /* head */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* tail */,
};

/* data{<network-address>} */
extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_accessor_method_HEAP;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[23];	 /* %element */
} L33;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L34;

extern descriptor_t * dylanZdylan_visceraZheap_rep_getter_FUN(descriptor_t *orig_sp, heapptr_t A0, long A1, heapptr_t A2);	/* heap-rep-getter */

extern struct dylanZdylan_visceraZCLS_slot_descriptor {
    heapptr_t PCTobject_class;	 /* %object-class */
    heapptr_t slot_name;	 /* slot-name */
    heapptr_t slot_allocation;	 /* slot-allocation */
    heapptr_t slot_type;	 /* slot-type */
    heapptr_t slot_getter;	 /* slot-getter */
    heapptr_t slot_init_function;	 /* slot-init-function */
    descriptor_t slot_init_value;	 /* slot-init-value */
    heapptr_t slot_init_keyword;	 /* slot-init-keyword */
    char slot_init_keyword_requiredQUERY;	 /* slot-init-keyword-required? */
    unsigned char HOLE1[3];
    heapptr_t slot_positions;	 /* slot-positions */
    descriptor_t slot_positions_cache;	 /* slot-positions-cache */
    heapptr_t slot_representation;	 /* slot-representation */
    heapptr_t slot_initializedQUERY_slot;	 /* slot-initialized?-slot */
} getaddrinfo_testZgetaddrinfo_testZCLS_network_addressZgetaddrinfo_testZgetaddrinfo_testZdata_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_accessor_method L25 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_accessor_method_HEAP /* %object-class */,
    (heapptr_t) &L33 /* function-name */,
    dylanZdylan_visceraZgeneral_call_FUN /* general-entry */,
    (heapptr_t) &L20 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L34 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    dylanZdylan_visceraZheap_rep_getter_FUN /* generic-entry */,
    (heapptr_t) &getaddrinfo_testZgetaddrinfo_testZCLS_network_addressZgetaddrinfo_testZgetaddrinfo_testZdata_SLOT_HEAP /* accessor-slot */,
};

/* data-setter{<byte-vector>, <network-address>} */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE45 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[45];	 /* %element */
} L36;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L37;

extern descriptor_t * dylanZdylan_visceraZheap_rep_setter_FUN(descriptor_t *orig_sp, heapptr_t A0, long A1, heapptr_t A2);	/* heap-rep-setter */

struct dylanZdylan_visceraZCLS_accessor_method L26 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_accessor_method_HEAP /* %object-class */,
    (heapptr_t) &L36 /* function-name */,
    dylanZdylan_visceraZgeneral_call_FUN /* general-entry */,
    (heapptr_t) &L37 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L34 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    dylanZdylan_visceraZheap_rep_setter_FUN /* generic-entry */,
    (heapptr_t) &getaddrinfo_testZgetaddrinfo_testZCLS_network_addressZgetaddrinfo_testZgetaddrinfo_testZdata_SLOT_HEAP /* accessor-slot */,
};

/* address-length{singleton(<ipv6-network-address>)} */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE49 L38;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L39;

struct dylanZdylan_visceraZCLS_method L27 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_method_HEAP /* %object-class */,
    (heapptr_t) &L38 /* function-name */,
    dylanZdylan_visceraZgeneral_call_FUN /* general-entry */,
    (heapptr_t) &L39 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    getaddrinfo_testZgetaddrinfo_testZaddress_length_METH_GENERIC /* generic-entry */,
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method L40;

struct dylanZdylan_visceraZCLS_pair L28 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &L40, { 0 } } /* head */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* tail */,
};

/* sockaddr-offset{singleton(<ipv6-network-address>)} */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE50 L41;

struct dylanZdylan_visceraZCLS_method L29 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_method_HEAP /* %object-class */,
    (heapptr_t) &L41 /* function-name */,
    dylanZdylan_visceraZgeneral_call_FUN /* general-entry */,
    (heapptr_t) &L39 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    getaddrinfo_testZgetaddrinfo_testZsockaddr_offset_METH_GENERIC /* generic-entry */,
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method L42;

struct dylanZdylan_visceraZCLS_pair L30 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &L42, { 0 } } /* head */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* tail */,
};

/* singleton(<network-address>) */
extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_singleton_HEAP;

struct dylanZdylan_visceraZCLS_singleton L31 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_singleton_HEAP /* %object-class */,
    { (heapptr_t) &getaddrinfo_testZgetaddrinfo_testZCLS_network_address_HEAP, { 0 } } /* singleton-object */,
};

/* copy-vector{subclass(<vector>), <c-vector>} */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE43 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[43];	 /* %element */
} L43;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L44;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L45;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L46;

struct dylanZdylan_visceraZCLS_method L32 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_method_HEAP /* %object-class */,
    (heapptr_t) &L43 /* function-name */,
    dylanZdylan_visceraZgeneral_call_FUN /* general-entry */,
    (heapptr_t) &L44 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L45 /* function-keywords */,
    (heapptr_t) &L46 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (void *) 0 /* generic-entry */,
};

/* "data{<network-address>}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L33 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    23 /* size */,
    "data{<network-address>}",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L34 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_byte_vector_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {<slot-descriptor> for data introduced by <network-address>} */
extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_slot_descriptor_HEAP;

extern struct dylanZdylan_visceraZCLS_symbol SYM_instance_HEAP;

extern struct dylanZdylan_visceraZCLS_not_supplied_marker {
    heapptr_t PCTobject_class;	 /* %object-class */
} dylanZliteral_ROOT;

extern struct dylanZdylan_visceraZCLS_pair L47;

extern struct dylanZdylan_visceraZCLS_symbol SYM_heap_HEAP;

struct dylanZdylan_visceraZCLS_slot_descriptor getaddrinfo_testZgetaddrinfo_testZCLS_network_addressZgetaddrinfo_testZgetaddrinfo_testZdata_SLOT_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptor_HEAP /* %object-class */,
    (heapptr_t) &L7 /* slot-name */,
    (heapptr_t) &SYM_instance_HEAP /* slot-allocation */,
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_vector_HEAP /* slot-type */,
    (heapptr_t) &L2 /* slot-getter */,
    (heapptr_t) &dylan_L1 /* slot-init-function */,
    { (heapptr_t) &dylanZliteral_ROOT, { 0 } } /* slot-init-value */,
    (heapptr_t) &SYM_data_HEAP /* slot-init-keyword */,
    1 /* slot-init-keyword-required? */,
    { 0, 0, 0, }, /* hole */
    (heapptr_t) &L47 /* slot-positions */,
    { (heapptr_t) &dylan_L1, { 0 } } /* slot-positions-cache */,
    (heapptr_t) &SYM_heap_HEAP /* slot-representation */,
    (heapptr_t) &dylan_L1 /* slot-initialized?-slot */,
};

/* "data-setter{<byte-vector>, <network-address>}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE45 L36 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    45 /* size */,
    "data-setter{<byte-vector>, <network-address>}",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L37 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_byte_vector_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &getaddrinfo_testZgetaddrinfo_testZCLS_network_address_HEAP, { 0 } } /* %element[1] */,
    },
};

/* "address-length{singleton(<ipv6-network-address>)}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE49 L38 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    49 /* size */,
    "address-length{singleton(<ipv6-network-address>)}",
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_singleton L48;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L39 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L48, { 0 } } /* %element[0] */,
    },
};

/* address-length{singleton(<ipv4-network-address>)} */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE49 L49;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L50;

struct dylanZdylan_visceraZCLS_method L40 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_method_HEAP /* %object-class */,
    (heapptr_t) &L49 /* function-name */,
    dylanZdylan_visceraZgeneral_call_FUN /* general-entry */,
    (heapptr_t) &L50 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    getaddrinfo_testZgetaddrinfo_testZaddress_length_METH_GENERIC_2 /* generic-entry */,
};

/* "sockaddr-offset{singleton(<ipv6-network-address>)}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE50 L41 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    50 /* size */,
    "sockaddr-offset{singleton(<ipv6-network-address>)}",
};

/* sockaddr-offset{singleton(<ipv4-network-address>)} */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE50 L51;

struct dylanZdylan_visceraZCLS_method L42 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_method_HEAP /* %object-class */,
    (heapptr_t) &L51 /* function-name */,
    dylanZdylan_visceraZgeneral_call_FUN /* general-entry */,
    (heapptr_t) &L50 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    getaddrinfo_testZgetaddrinfo_testZsockaddr_offset_METH_GENERIC_2 /* generic-entry */,
};

/* "copy-vector{subclass(<vector>), <c-vector>}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE43 L43 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    43 /* size */,
    "copy-vector{subclass(<vector>), <c-vector>}",
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_subclass {
    heapptr_t PCTobject_class;	 /* %object-class */
    heapptr_t subclass_of;	 /* subclass-of */
} L52;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L44 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &L52, { 0 } } /* %element[0] */,
	{ (heapptr_t) &melange_supportZmelange_supportZCLS_c_vector_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L45 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &SYM_size_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L46 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_vector_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L53;

struct dylanZdylan_visceraZCLS_pair L47 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &L53, { 0 } } /* head */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* tail */,
};

/* singleton(<ipv6-network-address>) */
struct dylanZdylan_visceraZCLS_singleton L48 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_singleton_HEAP /* %object-class */,
    { (heapptr_t) &getaddrinfo_testZgetaddrinfo_testZCLS_ipv6_network_address_HEAP, { 0 } } /* singleton-object */,
};

/* "address-length{singleton(<ipv4-network-address>)}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE49 L49 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    49 /* size */,
    "address-length{singleton(<ipv4-network-address>)}",
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_singleton L54;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L50 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L54, { 0 } } /* %element[0] */,
    },
};

/* "sockaddr-offset{singleton(<ipv4-network-address>)}" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE50 L51 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    50 /* size */,
    "sockaddr-offset{singleton(<ipv4-network-address>)}",
};

/* subclass(<vector>) */
extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_subclass_HEAP;

struct dylanZdylan_visceraZCLS_subclass L52 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_subclass_HEAP /* %object-class */,
    (heapptr_t) &dylanZdylan_visceraZCLS_vector_HEAP /* subclass-of */,
};

/* {a <pair>} */
struct dylanZdylan_visceraZCLS_pair L53 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &getaddrinfo_testZgetaddrinfo_testZCLS_network_address_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L0, { 4 } } /* tail */,
};

/* singleton(<ipv4-network-address>) */
struct dylanZdylan_visceraZCLS_singleton L54 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_singleton_HEAP /* %object-class */,
    { (heapptr_t) &getaddrinfo_testZgetaddrinfo_testZCLS_ipv4_network_address_HEAP, { 0 } } /* singleton-object */,
};

/* heap base */

/* #"Cheap-Err" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[9];	 /* %element */
} L67;

struct dylanZdylan_visceraZCLS_symbol SYM_cheap_err_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L67, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &dylan_L1 /* symbol-next */,
};

/* #"Cheap-IO" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[8];	 /* %element */
} L68;

struct dylanZdylan_visceraZCLS_symbol SYM_cheap_io_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L68, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_cheap_err_HEAP /* symbol-next */,
};

/* <not-supplied-marker> */
extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_class_HEAP;

extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[21];	 /* %element */
} L69;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L70;

extern struct dylanZdylan_visceraZCLS_raw_function {
    heapptr_t PCTobject_class;	 /* %object-class */
    heapptr_t function_name;	 /* function-name */
    void * general_entry;	 /* general-entry */
    heapptr_t function_specializers;	 /* function-specializers */
    char function_restQUERY;	 /* function-rest? */
    char function_all_keysQUERY;	 /* function-all-keys? */
    unsigned char HOLE1[2];
    heapptr_t function_keywords;	 /* function-keywords */
    heapptr_t function_values;	 /* function-values */
    heapptr_t function_rest_value;	 /* function-rest-value */
} L71;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L72;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L73;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[13];	 /* %element */
} L74;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_not_supplied_marker_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L69 /* class-name */,
    69 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L70 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L71 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L72 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L74 /* class-row */,
};

/* <symbol> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L75;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L76;

extern struct dylanZdylan_visceraZCLS_raw_function L77;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[3];	 /* %element */
} L78;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L79;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[4];	 /* %element */
} L80;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L81;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_symbol_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L75 /* class-name */,
    26 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L76 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L77 /* class-maker */,
    (heapptr_t) &L78 /* class-new-slot-descriptors */,
    (heapptr_t) &L79 /* class-slot-overrides */,
    (heapptr_t) &L80 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L81 /* class-row */,
};

/* = */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE1 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[1];	 /* %element */
} L82;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L83;

extern struct dylanZdylan_visceraZCLS_pair L84;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZEQUAL_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L82 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L11 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L83 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L84 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <not-found-marker> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[18];	 /* %element */
} L85;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L86;

extern struct dylanZdylan_visceraZCLS_raw_function L87;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L88;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L89;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_not_found_marker_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L85 /* class-name */,
    68 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L86 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L87 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L88 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L89 /* class-row */,
};

/* make */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L90;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L91;

extern struct dylanZdylan_visceraZCLS_pair L92;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZmake_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L90 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L91 /* function-specializers */,
    1 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L92 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <simple-object-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE22 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[22];	 /* %element */
} L93;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L94;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[9];	 /* %element */
} L95;

extern struct dylanZdylan_visceraZCLS_raw_function L96;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L97;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L98;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L99;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L100;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_object_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L93 /* class-name */,
    64 /* unique-id */,
    (heapptr_t) &L94 /* direct-superclasses */,
    (heapptr_t) &L95 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L96 /* class-maker */,
    (heapptr_t) &L97 /* class-new-slot-descriptors */,
    (heapptr_t) &L98 /* class-slot-overrides */,
    (heapptr_t) &L99 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L100 /* class-row */,
};

/* as */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE2 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[2];	 /* %element */
} L101;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L102;

extern struct dylanZdylan_visceraZCLS_pair L103;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZas_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L101 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L102 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L103 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <sequence> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L104;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L105;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L106;

extern struct dylanZdylan_visceraZCLS_pair L107;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L108;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_sequence_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L104 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L105 /* direct-superclasses */,
    (heapptr_t) &L106 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L107 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    8 /* class-bucket */,
    (heapptr_t) &L108 /* class-row */,
};

/* <double-integer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[16];	 /* %element */
} L109;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L110;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[7];	 /* %element */
} L111;

extern struct dylanZdylan_visceraZCLS_raw_function L112;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L113;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L114;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L115;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L116;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_double_integer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L109 /* class-name */,
    89 /* unique-id */,
    (heapptr_t) &L110 /* direct-superclasses */,
    (heapptr_t) &L111 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L112 /* class-maker */,
    (heapptr_t) &L113 /* class-new-slot-descriptors */,
    (heapptr_t) &L114 /* class-slot-overrides */,
    (heapptr_t) &L115 /* class-all-slot-descriptors */,
    5 /* class-bucket */,
    (heapptr_t) &L116 /* class-row */,
};

/* <double-float> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L117;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L118;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[6];	 /* %element */
} L119;

extern struct dylanZdylan_visceraZCLS_raw_function L120;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L121;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L122;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L123;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L124;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_double_float_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L117 /* class-name */,
    84 /* unique-id */,
    (heapptr_t) &L118 /* direct-superclasses */,
    (heapptr_t) &L119 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L120 /* class-maker */,
    (heapptr_t) &L121 /* class-new-slot-descriptors */,
    (heapptr_t) &L122 /* class-slot-overrides */,
    (heapptr_t) &L123 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L124 /* class-row */,
};

/* <extended-float> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L125;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L126;

extern struct dylanZdylan_visceraZCLS_raw_function L127;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L128;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L129;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L130;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L131;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_extended_float_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L125 /* class-name */,
    83 /* unique-id */,
    (heapptr_t) &L118 /* direct-superclasses */,
    (heapptr_t) &L126 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L127 /* class-maker */,
    (heapptr_t) &L128 /* class-new-slot-descriptors */,
    (heapptr_t) &L129 /* class-slot-overrides */,
    (heapptr_t) &L130 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L131 /* class-row */,
};

/* <boolean> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L132;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L133;

extern struct dylanZdylan_visceraZCLS_pair L134;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L135;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_boolean_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L132 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L133 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L134 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L135 /* class-row */,
};

/* <true> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[6];	 /* %element */
} L136;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L137;

extern struct dylanZdylan_visceraZCLS_raw_function L138;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L139;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L140;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_true_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L136 /* class-name */,
    91 /* unique-id */,
    (heapptr_t) &L83 /* direct-superclasses */,
    (heapptr_t) &L137 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L138 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L139 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L140 /* class-row */,
};

/* <false> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L141;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L142;

extern struct dylanZdylan_visceraZCLS_raw_function L143;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L144;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L145;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_false_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L141 /* class-name */,
    90 /* unique-id */,
    (heapptr_t) &L83 /* direct-superclasses */,
    (heapptr_t) &L142 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L143 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L144 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L145 /* class-row */,
};

/* functional-== */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[13];	 /* %element */
} L146;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L147;

extern struct dylanZdylan_visceraZCLS_pair L148;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZfunctional_EQUALEQUAL_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L146 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L147 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L83 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L148 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* < */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE1 L149;

extern struct dylanZdylan_visceraZCLS_pair L150;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZLESS_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L149 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L11 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L83 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L150 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <single-float> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L151;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L152;

extern struct dylanZdylan_visceraZCLS_raw_function L153;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L154;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L155;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L156;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L157;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_single_float_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L151 /* class-name */,
    85 /* unique-id */,
    (heapptr_t) &L118 /* direct-superclasses */,
    (heapptr_t) &L152 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L153 /* class-maker */,
    (heapptr_t) &L154 /* class-new-slot-descriptors */,
    (heapptr_t) &L155 /* class-slot-overrides */,
    (heapptr_t) &L156 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L157 /* class-row */,
};

/* <type> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L158;

extern struct dylanZdylan_visceraZCLS_pair L159;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L160;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_type_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L158 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L102 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L159 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L160 /* class-row */,
};

/* <union> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L161;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L162;

extern struct dylanZdylan_visceraZCLS_raw_function L163;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L164;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L165;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L166;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L167;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_union_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L161 /* class-name */,
    77 /* unique-id */,
    (heapptr_t) &L91 /* direct-superclasses */,
    (heapptr_t) &L162 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L163 /* class-maker */,
    (heapptr_t) &L164 /* class-new-slot-descriptors */,
    (heapptr_t) &L165 /* class-slot-overrides */,
    (heapptr_t) &L166 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L167 /* class-row */,
};

/* #"members" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L168;

struct dylanZdylan_visceraZCLS_symbol SYM_members_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L168, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_cheap_io_HEAP /* symbol-next */,
};

/* #"singletons" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L169;

struct dylanZdylan_visceraZCLS_symbol SYM_singletons_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L169, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_members_HEAP /* symbol-next */,
};

/* <empty-list> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L170;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L171;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L172;

extern struct dylanZdylan_visceraZCLS_raw_function L173;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L174;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L175;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L176;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_empty_list_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L170 /* class-name */,
    46 /* unique-id */,
    (heapptr_t) &L171 /* direct-superclasses */,
    (heapptr_t) &L172 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L173 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L174 /* class-slot-overrides */,
    (heapptr_t) &L175 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L176 /* class-row */,
};

/* <pair> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L177;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L178;

extern struct dylanZdylan_visceraZCLS_raw_function L179;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L180;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L181;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_pair_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L177 /* class-name */,
    47 /* unique-id */,
    (heapptr_t) &L171 /* direct-superclasses */,
    (heapptr_t) &L178 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L179 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L180 /* class-slot-overrides */,
    (heapptr_t) &L175 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L181 /* class-row */,
};

/* <list> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L182;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L183;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L184;

extern struct dylanZdylan_visceraZCLS_pair L185;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L186;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L187;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_list_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L182 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L183 /* direct-superclasses */,
    (heapptr_t) &L184 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L185 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L186 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L175 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L187 /* class-row */,
};

/* <direct-instance> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[17];	 /* %element */
} L188;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L189;

extern struct dylanZdylan_visceraZCLS_raw_function L190;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L191;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L192;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L193;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L194;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_direct_instance_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L188 /* class-name */,
    72 /* unique-id */,
    (heapptr_t) &L91 /* direct-superclasses */,
    (heapptr_t) &L189 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L190 /* class-maker */,
    (heapptr_t) &L191 /* class-new-slot-descriptors */,
    (heapptr_t) &L192 /* class-slot-overrides */,
    (heapptr_t) &L193 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L194 /* class-row */,
};

/* #"of" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE2 L195;

struct dylanZdylan_visceraZCLS_symbol SYM_of_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L195, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_singletons_HEAP /* symbol-next */,
};

/* <designator-class> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L196;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L197;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L198;

extern struct dylanZdylan_visceraZCLS_raw_function L199;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L200;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L201;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE23 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[23];	 /* %element */
} L202;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L203;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_designator_class_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L196 /* class-name */,
    81 /* unique-id */,
    (heapptr_t) &L197 /* direct-superclasses */,
    (heapptr_t) &L198 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L199 /* class-maker */,
    (heapptr_t) &L200 /* class-new-slot-descriptors */,
    (heapptr_t) &L201 /* class-slot-overrides */,
    (heapptr_t) &L202 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L203 /* class-row */,
};

/* <class> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L204;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L205;

extern struct dylanZdylan_visceraZCLS_pair L206;

extern struct dylanZdylan_visceraZCLS_raw_function L207;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE18 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[18];	 /* %element */
} L208;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L209;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE19 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[19];	 /* %element */
} L210;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L211;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_class_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L204 /* class-name */,
    80 /* unique-id */,
    (heapptr_t) &L91 /* direct-superclasses */,
    (heapptr_t) &L205 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L206 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L207 /* class-maker */,
    (heapptr_t) &L208 /* class-new-slot-descriptors */,
    (heapptr_t) &L209 /* class-slot-overrides */,
    (heapptr_t) &L210 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L211 /* class-row */,
};

/* <subclass> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L212;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L213;

extern struct dylanZdylan_visceraZCLS_raw_function L214;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L215;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L216;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L217;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L218;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_subclass_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L212 /* class-name */,
    71 /* unique-id */,
    (heapptr_t) &L91 /* direct-superclasses */,
    (heapptr_t) &L213 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L214 /* class-maker */,
    (heapptr_t) &L215 /* class-new-slot-descriptors */,
    (heapptr_t) &L216 /* class-slot-overrides */,
    (heapptr_t) &L217 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L218 /* class-row */,
};

/* <singleton> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L219;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L220;

extern struct dylanZdylan_visceraZCLS_raw_function L221;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L222;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L223;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L224;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L225;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_singleton_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L219 /* class-name */,
    79 /* unique-id */,
    (heapptr_t) &L91 /* direct-superclasses */,
    (heapptr_t) &L220 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L221 /* class-maker */,
    (heapptr_t) &L222 /* class-new-slot-descriptors */,
    (heapptr_t) &L223 /* class-slot-overrides */,
    (heapptr_t) &L224 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L225 /* class-row */,
};

/* #"object" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L226;

struct dylanZdylan_visceraZCLS_symbol SYM_object_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L226, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_of_HEAP /* symbol-next */,
};

/* <limited-type> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L227;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L228;

extern struct dylanZdylan_visceraZCLS_pair L229;

extern struct dylanZdylan_visceraZCLS_raw_function L230;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L231;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L232;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L233;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L234;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_limited_type_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L227 /* class-name */,
    73 /* unique-id */,
    (heapptr_t) &L91 /* direct-superclasses */,
    (heapptr_t) &L228 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L229 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L230 /* class-maker */,
    (heapptr_t) &L231 /* class-new-slot-descriptors */,
    (heapptr_t) &L232 /* class-slot-overrides */,
    (heapptr_t) &L233 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L234 /* class-row */,
};

/* #"base-class" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L235;

struct dylanZdylan_visceraZCLS_symbol SYM_base_class_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L235, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_object_HEAP /* symbol-next */,
};

/* <limited-integer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L236;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L237;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L238;

extern struct dylanZdylan_visceraZCLS_raw_function L239;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L240;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L241;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L242;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L243;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_limited_integer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L236 /* class-name */,
    75 /* unique-id */,
    (heapptr_t) &L237 /* direct-superclasses */,
    (heapptr_t) &L238 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L239 /* class-maker */,
    (heapptr_t) &L240 /* class-new-slot-descriptors */,
    (heapptr_t) &L241 /* class-slot-overrides */,
    (heapptr_t) &L242 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L243 /* class-row */,
};

/* #"max" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE3 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[3];	 /* %element */
} L244;

struct dylanZdylan_visceraZCLS_symbol SYM_max_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L244, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_base_class_HEAP /* symbol-next */,
};

/* #"min" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE3 L245;

struct dylanZdylan_visceraZCLS_symbol SYM_min_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L245, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_max_HEAP /* symbol-next */,
};

/* <integer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L246;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L247;

extern struct dylanZdylan_visceraZCLS_raw_function L248;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L249;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L250;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L251;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L252;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_integer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L246 /* class-name */,
    88 /* unique-id */,
    (heapptr_t) &L110 /* direct-superclasses */,
    (heapptr_t) &L247 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L248 /* class-maker */,
    (heapptr_t) &L249 /* class-new-slot-descriptors */,
    (heapptr_t) &L250 /* class-slot-overrides */,
    (heapptr_t) &L251 /* class-all-slot-descriptors */,
    5 /* class-bucket */,
    (heapptr_t) &L252 /* class-row */,
};

/* <extended-integer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L253;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L254;

extern struct dylanZdylan_visceraZCLS_raw_function L255;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L256;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L257;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L258;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L259;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_extended_integer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L253 /* class-name */,
    87 /* unique-id */,
    (heapptr_t) &L110 /* direct-superclasses */,
    (heapptr_t) &L254 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L255 /* class-maker */,
    (heapptr_t) &L256 /* class-new-slot-descriptors */,
    (heapptr_t) &L257 /* class-slot-overrides */,
    (heapptr_t) &L258 /* class-all-slot-descriptors */,
    5 /* class-bucket */,
    (heapptr_t) &L259 /* class-row */,
};

/* <general-integer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L260;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L261;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L262;

extern struct dylanZdylan_visceraZCLS_pair L263;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L264;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_general_integer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L260 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L261 /* direct-superclasses */,
    (heapptr_t) &L262 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L263 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L264 /* class-row */,
};

/* + */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE1 L265;

extern struct dylanZdylan_visceraZCLS_pair L266;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZPLUS_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L265 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L11 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L266 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* - */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE1 L267;

extern struct dylanZdylan_visceraZCLS_pair L268;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZ__HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L267 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L11 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L268 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <limited-collection> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[20];	 /* %element */
} L269;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L270;

extern struct dylanZdylan_visceraZCLS_raw_function L271;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L272;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L273;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[5];	 /* %element */
} L274;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L275;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_limited_collection_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L269 /* class-name */,
    76 /* unique-id */,
    (heapptr_t) &L237 /* direct-superclasses */,
    (heapptr_t) &L270 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L271 /* class-maker */,
    (heapptr_t) &L272 /* class-new-slot-descriptors */,
    (heapptr_t) &L273 /* class-slot-overrides */,
    (heapptr_t) &L274 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L275 /* class-row */,
};

/* #"size" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L276;

struct dylanZdylan_visceraZCLS_symbol SYM_size_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L276, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_min_HEAP /* symbol-next */,
};

/* #"dimensions" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L277;

struct dylanZdylan_visceraZCLS_symbol SYM_dimensions_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L277, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_size_HEAP /* symbol-next */,
};

/* <object> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L278;

extern struct dylanZdylan_visceraZCLS_pair L279;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L280;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_object_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L278 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* direct-superclasses */,
    (heapptr_t) &L8 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L279 /* direct-subclasses */,
    0 /* class-functional? */,
    1 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L73 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    11 /* class-bucket */,
    (heapptr_t) &L280 /* class-row */,
};

/* <real> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L281;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L282;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L283;

extern struct dylanZdylan_visceraZCLS_pair L284;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L285;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_real_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L281 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L282 /* direct-superclasses */,
    (heapptr_t) &L283 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L284 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L285 /* class-row */,
};

/* <character> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L286;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L287;

extern struct dylanZdylan_visceraZCLS_raw_function L288;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L289;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L290;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L291;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L292;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_character_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L286 /* class-name */,
    36 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L287 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L288 /* class-maker */,
    (heapptr_t) &L289 /* class-new-slot-descriptors */,
    (heapptr_t) &L290 /* class-slot-overrides */,
    (heapptr_t) &L291 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L292 /* class-row */,
};

/* <byte-string> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L293;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L294;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L295;

extern struct dylanZdylan_visceraZCLS_raw_function L296;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L297;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L298;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L299;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L300;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_byte_string_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L293 /* class-name */,
    45 /* unique-id */,
    (heapptr_t) &L294 /* direct-superclasses */,
    (heapptr_t) &L295 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L296 /* class-maker */,
    (heapptr_t) &L297 /* class-new-slot-descriptors */,
    (heapptr_t) &L298 /* class-slot-overrides */,
    (heapptr_t) &L299 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L300 /* class-row */,
};

/* <unicode-string> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L301;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L302;

extern struct dylanZdylan_visceraZCLS_raw_function L303;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L304;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L305;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L306;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L307;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_unicode_string_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L301 /* class-name */,
    44 /* unique-id */,
    (heapptr_t) &L294 /* direct-superclasses */,
    (heapptr_t) &L302 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L303 /* class-maker */,
    (heapptr_t) &L304 /* class-new-slot-descriptors */,
    (heapptr_t) &L305 /* class-slot-overrides */,
    (heapptr_t) &L306 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L307 /* class-row */,
};

/* element-type */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L308;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L309;

extern struct dylanZdylan_visceraZCLS_pair L310;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZelement_type_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L308 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L8 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L309 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L310 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <collection> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L311;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L312;

extern struct dylanZdylan_visceraZCLS_pair L313;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L314;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_collection_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L311 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L312 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L313 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    9 /* class-bucket */,
    (heapptr_t) &L314 /* class-row */,
};

/* <explicit-key-collection> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE25 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[25];	 /* %element */
} L315;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L316;

extern struct dylanZdylan_visceraZCLS_pair L317;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L318;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_explicit_key_collection_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L315 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L105 /* direct-superclasses */,
    (heapptr_t) &L316 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L317 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    3 /* class-bucket */,
    (heapptr_t) &L318 /* class-row */,
};

/* <mutable-collection> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L319;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L320;

extern struct dylanZdylan_visceraZCLS_pair L321;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L322;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_mutable_collection_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L319 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L105 /* direct-superclasses */,
    (heapptr_t) &L320 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L321 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    7 /* class-bucket */,
    (heapptr_t) &L322 /* class-row */,
};

/* <stretchy-collection> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L323;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L324;

extern struct dylanZdylan_visceraZCLS_pair L325;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L326;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_stretchy_collection_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L323 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L105 /* direct-superclasses */,
    (heapptr_t) &L324 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L325 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    5 /* class-bucket */,
    (heapptr_t) &L326 /* class-row */,
};

/* <mutable-explicit-key-collection> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE33 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[33];	 /* %element */
} L327;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L328;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L329;

extern struct dylanZdylan_visceraZCLS_pair L330;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L331;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_mutable_explicit_key_collection_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L327 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L328 /* direct-superclasses */,
    (heapptr_t) &L329 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L330 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L331 /* class-row */,
};

/* <mutable-sequence> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L332;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L333;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L334;

extern struct dylanZdylan_visceraZCLS_pair L335;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L336;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_mutable_sequence_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L332 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L333 /* direct-superclasses */,
    (heapptr_t) &L334 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L335 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    6 /* class-bucket */,
    (heapptr_t) &L336 /* class-row */,
};

/* <table> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L337;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L338;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L339;

extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_table_HEAP;

extern struct dylanZdylan_visceraZCLS_pair L340;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L341;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L342;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L343;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_table_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L337 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L338 /* direct-superclasses */,
    (heapptr_t) &L339 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_table_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L340 /* direct-subclasses */,
    0 /* class-functional? */,
    1 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L341 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L342 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L343 /* class-row */,
};

/* <object-table> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L344;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L345;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[8];	 /* %element */
} L346;

extern struct dylanZdylan_visceraZCLS_pair L347;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L348;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_object_table_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L344 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L345 /* direct-superclasses */,
    (heapptr_t) &L346 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_table_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L347 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L342 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L348 /* class-row */,
};

/* <array> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L349;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L350;

extern struct dylanZdylan_visceraZCLS_pair L351;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L352;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_array_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L349 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L183 /* direct-superclasses */,
    (heapptr_t) &L350 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L351 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    3 /* class-bucket */,
    (heapptr_t) &L352 /* class-row */,
};

/* <vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L353;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L354;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L355;

extern struct dylanZdylan_visceraZCLS_pair L356;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L357;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L353 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L354 /* direct-superclasses */,
    (heapptr_t) &L355 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L356 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L357 /* class-row */,
};

/* <simple-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L358;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L359;

extern struct dylanZdylan_visceraZCLS_pair L360;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L361;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L358 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L46 /* direct-superclasses */,
    (heapptr_t) &L359 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L360 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L361 /* class-row */,
};

/* <stretchy-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L362;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L363;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[10];	 /* %element */
} L364;

extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_stretchy_vector_HEAP;

extern struct dylanZdylan_visceraZCLS_pair L365;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L366;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_stretchy_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L362 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L363 /* direct-superclasses */,
    (heapptr_t) &L364 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_vector_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L365 /* direct-subclasses */,
    0 /* class-functional? */,
    1 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L366 /* class-row */,
};

/* <deque> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L367;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L368;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L369;

extern struct dylanZdylan_visceraZCLS_pair L370;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L371;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_deque_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L367 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L368 /* direct-superclasses */,
    (heapptr_t) &L369 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L370 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L371 /* class-row */,
};

/* <string> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L372;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L373;

extern struct dylanZdylan_visceraZCLS_pair L374;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L375;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_string_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L372 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L183 /* direct-superclasses */,
    (heapptr_t) &L373 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L374 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L375 /* class-row */,
};

/* <range> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L376;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L377;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L378;

extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_range_HEAP;

extern struct dylanZdylan_visceraZCLS_pair L379;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L380;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_range_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L376 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L377 /* direct-superclasses */,
    (heapptr_t) &L378 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_range_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L379 /* direct-subclasses */,
    0 /* class-functional? */,
    1 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L380 /* class-row */,
};

/* <byte-character-type> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L381;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L382;

extern struct dylanZdylan_visceraZCLS_raw_function L383;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L384;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L385;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_byte_character_type_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L381 /* class-name */,
    78 /* unique-id */,
    (heapptr_t) &L91 /* direct-superclasses */,
    (heapptr_t) &L382 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L383 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L384 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L385 /* class-row */,
};

/* <none-of> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L386;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L387;

extern struct dylanZdylan_visceraZCLS_raw_function L388;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L389;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L390;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L391;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L392;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_none_of_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L386 /* class-name */,
    70 /* unique-id */,
    (heapptr_t) &L91 /* direct-superclasses */,
    (heapptr_t) &L387 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L388 /* class-maker */,
    (heapptr_t) &L389 /* class-new-slot-descriptors */,
    (heapptr_t) &L390 /* class-slot-overrides */,
    (heapptr_t) &L391 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L392 /* class-row */,
};

/* #"excluded" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L393;

struct dylanZdylan_visceraZCLS_symbol SYM_excluded_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L393, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_dimensions_HEAP /* symbol-next */,
};

/* #"base" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L394;

struct dylanZdylan_visceraZCLS_symbol SYM_base_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L394, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_excluded_HEAP /* symbol-next */,
};

/* <type-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L395;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L396;

extern struct dylanZdylan_visceraZCLS_raw_function L397;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L398;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L399;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L400;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L401;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_type_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L395 /* class-name */,
    63 /* unique-id */,
    (heapptr_t) &L94 /* direct-superclasses */,
    (heapptr_t) &L396 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L397 /* class-maker */,
    (heapptr_t) &L398 /* class-new-slot-descriptors */,
    (heapptr_t) &L399 /* class-slot-overrides */,
    (heapptr_t) &L400 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L401 /* class-row */,
};

/* size */
extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L402;

extern struct dylanZdylan_visceraZCLS_pair L403;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZsize_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L276 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L8 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L402 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L403 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* * */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE1 L404;

extern struct dylanZdylan_visceraZCLS_pair L405;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L404 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L11 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L405 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* reduce1 */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L406;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L407;

extern struct dylanZdylan_visceraZCLS_pair L408;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZreduce1_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L406 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L407 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L408 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <limited-function> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L409;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L410;

extern struct dylanZdylan_visceraZCLS_raw_function L411;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L412;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L413;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L414;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L415;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_limited_function_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L409 /* class-name */,
    74 /* unique-id */,
    (heapptr_t) &L237 /* direct-superclasses */,
    (heapptr_t) &L410 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L411 /* class-maker */,
    (heapptr_t) &L412 /* class-new-slot-descriptors */,
    (heapptr_t) &L413 /* class-slot-overrides */,
    (heapptr_t) &L414 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L415 /* class-row */,
};

/* #"return-types" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L416;

struct dylanZdylan_visceraZCLS_symbol SYM_return_types_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L416, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_base_HEAP /* symbol-next */,
};

/* #"specializers" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L417;

struct dylanZdylan_visceraZCLS_symbol SYM_specializers_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L417, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_return_types_HEAP /* symbol-next */,
};

/* <function> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L418;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L419;

extern struct dylanZdylan_visceraZCLS_pair L420;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L421;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L422;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L423;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_function_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L418 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L419 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L420 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L421 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L422 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L423 /* class-row */,
};

/* #"all" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE3 L424;

struct dylanZdylan_visceraZCLS_symbol SYM_all_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L424, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_specializers_HEAP /* symbol-next */,
};

/* #"class-bucket" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L425;

struct dylanZdylan_visceraZCLS_symbol SYM_class_bucket_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L425, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_all_HEAP /* symbol-next */,
};

/* #"slot-overrides" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L426;

struct dylanZdylan_visceraZCLS_symbol SYM_slot_overrides_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L426, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_class_bucket_HEAP /* symbol-next */,
};

/* #"slots" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[5];	 /* %element */
} L427;

struct dylanZdylan_visceraZCLS_symbol SYM_slots_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L427, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_slot_overrides_HEAP /* symbol-next */,
};

/* #"closest-primary-superclass" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE26 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[26];	 /* %element */
} L428;

struct dylanZdylan_visceraZCLS_symbol SYM_closest_primary_superclass_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L428, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_slots_HEAP /* symbol-next */,
};

/* #"all-superclasses" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L429;

struct dylanZdylan_visceraZCLS_symbol SYM_all_superclasses_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L429, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_closest_primary_superclass_HEAP /* symbol-next */,
};

/* #"superclasses" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L430;

struct dylanZdylan_visceraZCLS_symbol SYM_superclasses_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L430, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_all_superclasses_HEAP /* symbol-next */,
};

/* #"debug-name" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L431;

struct dylanZdylan_visceraZCLS_symbol SYM_debug_name_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L431, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_superclasses_HEAP /* symbol-next */,
};

/* #"functional" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L432;

struct dylanZdylan_visceraZCLS_symbol SYM_functional_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L432, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_debug_name_HEAP /* symbol-next */,
};

/* #"primary" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L433;

struct dylanZdylan_visceraZCLS_symbol SYM_primary_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L433, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_functional_HEAP /* symbol-next */,
};

/* #"abstract" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L434;

struct dylanZdylan_visceraZCLS_symbol SYM_abstract_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L434, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_primary_HEAP /* symbol-next */,
};

/* #"sealed" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L435;

struct dylanZdylan_visceraZCLS_symbol SYM_sealed_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L435, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_abstract_HEAP /* symbol-next */,
};

/* <slot-descriptor> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L436;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L437;

extern struct dylanZdylan_visceraZCLS_raw_function L438;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE12 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[12];	 /* %element */
} L439;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L440;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L441;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L442;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_slot_descriptor_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L436 /* class-name */,
    25 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L437 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L438 /* class-maker */,
    (heapptr_t) &L439 /* class-new-slot-descriptors */,
    (heapptr_t) &L440 /* class-slot-overrides */,
    (heapptr_t) &L441 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L442 /* class-row */,
};

/* #"getter" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L443;

struct dylanZdylan_visceraZCLS_symbol SYM_getter_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L443, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_sealed_HEAP /* symbol-next */,
};

/* #"allocation" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L444;

struct dylanZdylan_visceraZCLS_symbol SYM_allocation_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L444, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_getter_HEAP /* symbol-next */,
};

/* #"name" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L445;

struct dylanZdylan_visceraZCLS_symbol SYM_name_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L445, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_allocation_HEAP /* symbol-next */,
};

/* #"instance" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L446;

struct dylanZdylan_visceraZCLS_symbol SYM_instance_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L446, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_name_HEAP /* symbol-next */,
};

/* #"each-subclass" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L447;

struct dylanZdylan_visceraZCLS_symbol SYM_each_subclass_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L447, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_instance_HEAP /* symbol-next */,
};

/* #"class" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L448;

struct dylanZdylan_visceraZCLS_symbol SYM_class_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L448, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_each_subclass_HEAP /* symbol-next */,
};

/* #"virtual" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L449;

struct dylanZdylan_visceraZCLS_symbol SYM_virtual_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L449, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_class_HEAP /* symbol-next */,
};

/* #"type" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L450;

struct dylanZdylan_visceraZCLS_symbol SYM_type_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L450, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_virtual_HEAP /* symbol-next */,
};

/* <generic-function> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L451;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L452;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L453;

extern struct dylanZdylan_visceraZCLS_raw_function L454;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L455;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L456;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[11];	 /* %element */
} L457;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L458;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_generic_function_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L451 /* class-name */,
    35 /* unique-id */,
    (heapptr_t) &L452 /* direct-superclasses */,
    (heapptr_t) &L453 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L454 /* class-maker */,
    (heapptr_t) &L455 /* class-new-slot-descriptors */,
    (heapptr_t) &L456 /* class-slot-overrides */,
    (heapptr_t) &L457 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L458 /* class-row */,
};

/* <position-cache-node> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L459;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L460;

extern struct dylanZdylan_visceraZCLS_raw_function L461;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L462;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L463;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L464;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L465;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_position_cache_node_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L459 /* class-name */,
    24 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L460 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L461 /* class-maker */,
    (heapptr_t) &L462 /* class-new-slot-descriptors */,
    (heapptr_t) &L463 /* class-slot-overrides */,
    (heapptr_t) &L464 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L465 /* class-row */,
};

/* #"next" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L466;

struct dylanZdylan_visceraZCLS_symbol SYM_next_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L466, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_type_HEAP /* symbol-next */,
};

/* #"position" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L467;

struct dylanZdylan_visceraZCLS_symbol SYM_position_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L467, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_next_HEAP /* symbol-next */,
};

/* #"data-word" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L468;

struct dylanZdylan_visceraZCLS_symbol SYM_data_word_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L468, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_position_HEAP /* symbol-next */,
};

/* <override-descriptor> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L469;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L470;

extern struct dylanZdylan_visceraZCLS_raw_function L471;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L472;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L473;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L474;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L475;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_override_descriptor_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L469 /* class-name */,
    23 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L470 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L471 /* class-maker */,
    (heapptr_t) &L472 /* class-new-slot-descriptors */,
    (heapptr_t) &L473 /* class-slot-overrides */,
    (heapptr_t) &L474 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L475 /* class-row */,
};

/* #"init-value" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L476;

struct dylanZdylan_visceraZCLS_symbol SYM_init_value_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L476, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_data_word_HEAP /* symbol-next */,
};

/* #"init-function" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L477;

struct dylanZdylan_visceraZCLS_symbol SYM_init_function_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L477, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_init_value_HEAP /* symbol-next */,
};

/* <accessor-method> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L478;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L479;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L480;

extern struct dylanZdylan_visceraZCLS_raw_function L481;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L482;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L483;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L484;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L485;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_accessor_method_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L478 /* class-name */,
    29 /* unique-id */,
    (heapptr_t) &L479 /* direct-superclasses */,
    (heapptr_t) &L480 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L481 /* class-maker */,
    (heapptr_t) &L482 /* class-new-slot-descriptors */,
    (heapptr_t) &L483 /* class-slot-overrides */,
    (heapptr_t) &L484 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L485 /* class-row */,
};

/* #"general" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L486;

struct dylanZdylan_visceraZCLS_symbol SYM_general_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L486, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_init_function_HEAP /* symbol-next */,
};

/* #"heap" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L487;

struct dylanZdylan_visceraZCLS_symbol SYM_heap_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L487, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_general_HEAP /* symbol-next */,
};

/* initialize */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L488;

extern struct dylanZdylan_visceraZCLS_pair L489;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZinitialize_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L488 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L8 /* function-specializers */,
    1 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L489 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"alignment" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L490;

struct dylanZdylan_visceraZCLS_symbol SYM_alignment_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L490, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_heap_HEAP /* symbol-next */,
};

/* #"referenced-type" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L491;

struct dylanZdylan_visceraZCLS_symbol SYM_referenced_type_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L491, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_alignment_HEAP /* symbol-next */,
};

/* #"class-struct-slot-descriptors" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE29 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[29];	 /* %element */
} L492;

struct dylanZdylan_visceraZCLS_symbol SYM_class_struct_slot_descriptors_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L492, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_referenced_type_HEAP /* symbol-next */,
};

/* <struct-slot-descriptor> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE24 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[24];	 /* %element */
} L493;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L494;

extern struct dylanZdylan_visceraZCLS_raw_function L495;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L496;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L497;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L498;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L499;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_struct_slot_descriptor_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L493 /* class-name */,
    22 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L494 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L495 /* class-maker */,
    (heapptr_t) &L496 /* class-new-slot-descriptors */,
    (heapptr_t) &L497 /* class-slot-overrides */,
    (heapptr_t) &L498 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L499 /* class-row */,
};

/* #"offset" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L500;

struct dylanZdylan_visceraZCLS_symbol SYM_offset_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L500, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_class_struct_slot_descriptors_HEAP /* symbol-next */,
};

/* #"c-type" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L501;

struct dylanZdylan_visceraZCLS_symbol SYM_c_type_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L501, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_offset_HEAP /* symbol-next */,
};

/* <closure> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L502;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L503;

extern struct dylanZdylan_visceraZCLS_pair L504;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L505;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L506;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L507;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_closure_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L502 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L452 /* direct-superclasses */,
    (heapptr_t) &L503 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L504 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L505 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L506 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L507 /* class-row */,
};

/* <raw-function> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L508;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L509;

extern struct dylanZdylan_visceraZCLS_pair L510;

extern struct dylanZdylan_visceraZCLS_raw_function L511;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L512;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L513;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_raw_function_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L508 /* class-name */,
    33 /* unique-id */,
    (heapptr_t) &L452 /* direct-superclasses */,
    (heapptr_t) &L509 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L510 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L511 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L512 /* class-slot-overrides */,
    (heapptr_t) &L422 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L513 /* class-row */,
};

/* #"rest-value" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L514;

struct dylanZdylan_visceraZCLS_symbol SYM_rest_value_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L514, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_c_type_HEAP /* symbol-next */,
};

/* #"values" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L515;

struct dylanZdylan_visceraZCLS_symbol SYM_values_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L515, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_rest_value_HEAP /* symbol-next */,
};

/* #"all-keys?" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L516;

struct dylanZdylan_visceraZCLS_symbol SYM_all_keysQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L516, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_values_HEAP /* symbol-next */,
};

/* #"keywords" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L517;

struct dylanZdylan_visceraZCLS_symbol SYM_keywords_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L517, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_all_keysQUERY_HEAP /* symbol-next */,
};

/* #"rest?" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L518;

struct dylanZdylan_visceraZCLS_symbol SYM_restQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L518, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_keywords_HEAP /* symbol-next */,
};

/* #"general-entry" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L519;

struct dylanZdylan_visceraZCLS_symbol SYM_general_entry_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L519, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_restQUERY_HEAP /* symbol-next */,
};

/* #"function-name" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L520;

struct dylanZdylan_visceraZCLS_symbol SYM_function_name_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L520, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_general_entry_HEAP /* symbol-next */,
};

/* <raw-pointer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L521;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L522;

extern struct dylanZdylan_visceraZCLS_raw_function L523;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L524;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L525;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L526;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L527;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_raw_pointer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L521 /* class-name */,
    82 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L522 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L523 /* class-maker */,
    (heapptr_t) &L524 /* class-new-slot-descriptors */,
    (heapptr_t) &L525 /* class-slot-overrides */,
    (heapptr_t) &L526 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L527 /* class-row */,
};

/* <callback-function> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L528;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L529;

extern struct dylanZdylan_visceraZCLS_pair L530;

extern struct dylanZdylan_visceraZCLS_raw_function L531;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L532;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L533;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L534;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L535;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_callback_function_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L528 /* class-name */,
    31 /* unique-id */,
    (heapptr_t) &L452 /* direct-superclasses */,
    (heapptr_t) &L529 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L530 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L531 /* class-maker */,
    (heapptr_t) &L532 /* class-new-slot-descriptors */,
    (heapptr_t) &L533 /* class-slot-overrides */,
    (heapptr_t) &L534 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L535 /* class-row */,
};

/* #"callback-signature" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L536;

struct dylanZdylan_visceraZCLS_symbol SYM_callback_signature_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L536, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_function_name_HEAP /* symbol-next */,
};

/* #"callback-entry" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L537;

struct dylanZdylan_visceraZCLS_symbol SYM_callback_entry_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L537, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_callback_signature_HEAP /* symbol-next */,
};

/* <raw-closure> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L538;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L539;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L540;

extern struct dylanZdylan_visceraZCLS_raw_function L541;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L542;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L543;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_raw_closure_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L538 /* class-name */,
    34 /* unique-id */,
    (heapptr_t) &L539 /* direct-superclasses */,
    (heapptr_t) &L540 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L541 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L542 /* class-slot-overrides */,
    (heapptr_t) &L506 /* class-all-slot-descriptors */,
    3 /* class-bucket */,
    (heapptr_t) &L543 /* class-row */,
};

/* #"closure-size" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L544;

struct dylanZdylan_visceraZCLS_symbol SYM_closure_size_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L544, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_callback_entry_HEAP /* symbol-next */,
};

/* <callback-closure> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L545;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L546;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L547;

extern struct dylanZdylan_visceraZCLS_raw_function L548;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L549;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L550;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L551;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_callback_closure_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L545 /* class-name */,
    32 /* unique-id */,
    (heapptr_t) &L546 /* direct-superclasses */,
    (heapptr_t) &L547 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L548 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L549 /* class-slot-overrides */,
    (heapptr_t) &L550 /* class-all-slot-descriptors */,
    3 /* class-bucket */,
    (heapptr_t) &L551 /* class-row */,
};

/* <method> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L552;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L553;

extern struct dylanZdylan_visceraZCLS_pair L554;

extern struct dylanZdylan_visceraZCLS_raw_function L555;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L556;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L557;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L558;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L559;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_method_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L552 /* class-name */,
    27 /* unique-id */,
    (heapptr_t) &L452 /* direct-superclasses */,
    (heapptr_t) &L553 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L554 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L555 /* class-maker */,
    (heapptr_t) &L556 /* class-new-slot-descriptors */,
    (heapptr_t) &L557 /* class-slot-overrides */,
    (heapptr_t) &L558 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L559 /* class-row */,
};

/* #"generic-entry" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L560;

struct dylanZdylan_visceraZCLS_symbol SYM_generic_entry_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L560, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_closure_size_HEAP /* symbol-next */,
};

/* <dynamic-method> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L561;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L562;

extern struct dylanZdylan_visceraZCLS_raw_function L563;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L564;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L565;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L566;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L567;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_dynamic_method_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L561 /* class-name */,
    30 /* unique-id */,
    (heapptr_t) &L479 /* direct-superclasses */,
    (heapptr_t) &L562 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L563 /* class-maker */,
    (heapptr_t) &L564 /* class-new-slot-descriptors */,
    (heapptr_t) &L565 /* class-slot-overrides */,
    (heapptr_t) &L566 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L567 /* class-row */,
};

/* #"real-method" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L568;

struct dylanZdylan_visceraZCLS_symbol SYM_real_method_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L568, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_generic_entry_HEAP /* symbol-next */,
};

/* #"slot" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L569;

struct dylanZdylan_visceraZCLS_symbol SYM_slot_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L569, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_real_method_HEAP /* symbol-next */,
};

/* <method-closure> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L570;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L571;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L572;

extern struct dylanZdylan_visceraZCLS_raw_function L573;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L574;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE12 L575;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L576;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_method_closure_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L570 /* class-name */,
    28 /* unique-id */,
    (heapptr_t) &L571 /* direct-superclasses */,
    (heapptr_t) &L572 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L573 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L574 /* class-slot-overrides */,
    (heapptr_t) &L575 /* class-all-slot-descriptors */,
    3 /* class-bucket */,
    (heapptr_t) &L576 /* class-row */,
};

/* #"fill" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L577;

struct dylanZdylan_visceraZCLS_symbol SYM_fill_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L577, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_slot_HEAP /* symbol-next */,
};

/* #"default" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L578;

struct dylanZdylan_visceraZCLS_symbol SYM_default_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L578, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_fill_HEAP /* symbol-next */,
};

/* <gf-cache> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L579;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L580;

extern struct dylanZdylan_visceraZCLS_raw_function L581;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L582;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L583;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L584;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L585;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_gf_cache_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L579 /* class-name */,
    21 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L580 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L581 /* class-maker */,
    (heapptr_t) &L582 /* class-new-slot-descriptors */,
    (heapptr_t) &L583 /* class-slot-overrides */,
    (heapptr_t) &L584 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L585 /* class-row */,
};

/* #"classes" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L586;

struct dylanZdylan_visceraZCLS_symbol SYM_classes_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L586, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_default_HEAP /* symbol-next */,
};

/* #"methods" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L587;

struct dylanZdylan_visceraZCLS_symbol SYM_methods_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L587, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_classes_HEAP /* symbol-next */,
};

/* forward-iteration-protocol */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE26 L588;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L589;

extern struct dylanZdylan_visceraZCLS_pair L590;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZforward_iteration_protocol_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L588 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L105 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L589 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L590 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"required" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L591;

struct dylanZdylan_visceraZCLS_symbol SYM_required_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L591, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_methods_HEAP /* symbol-next */,
};

/* #"key" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE3 L592;

struct dylanZdylan_visceraZCLS_symbol SYM_key_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L592, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_required_HEAP /* symbol-next */,
};

/* #"end" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE3 L593;

struct dylanZdylan_visceraZCLS_symbol SYM_end_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L593, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_key_HEAP /* symbol-next */,
};

/* #"more-specific" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L594;

struct dylanZdylan_visceraZCLS_symbol SYM_more_specific_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L594, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_end_HEAP /* symbol-next */,
};

/* #"less-specific" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L595;

struct dylanZdylan_visceraZCLS_symbol SYM_less_specific_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L595, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_more_specific_HEAP /* symbol-next */,
};

/* #"ambiguous" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L596;

struct dylanZdylan_visceraZCLS_symbol SYM_ambiguous_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L596, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_less_specific_HEAP /* symbol-next */,
};

/* #"identical" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L597;

struct dylanZdylan_visceraZCLS_symbol SYM_identical_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L597, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_ambiguous_HEAP /* symbol-next */,
};

/* element */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L598;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L599;

extern struct dylanZdylan_visceraZCLS_pair L600;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZelement_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L598 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L312 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L599 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L600 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* member? */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L601;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L602;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L603;

extern struct dylanZdylan_visceraZCLS_pair L604;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZmemberQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L601 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L602 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L603 /* function-keywords */,
    (heapptr_t) &L83 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L604 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <complex> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L605;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L606;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L607;

extern struct dylanZdylan_visceraZCLS_pair L608;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L609;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_complex_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L605 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L606 /* direct-superclasses */,
    (heapptr_t) &L607 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L608 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L609 /* class-row */,
};

/* <rational> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L610;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L611;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L612;

extern struct dylanZdylan_visceraZCLS_pair L613;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L614;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_rational_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L610 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L611 /* direct-superclasses */,
    (heapptr_t) &L612 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L613 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    3 /* class-bucket */,
    (heapptr_t) &L614 /* class-row */,
};

/* <float> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L615;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L616;

extern struct dylanZdylan_visceraZCLS_pair L617;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L618;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_float_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L615 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L611 /* direct-superclasses */,
    (heapptr_t) &L616 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L617 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    3 /* class-bucket */,
    (heapptr_t) &L618 /* class-row */,
};

/* zero? */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L619;

extern struct dylanZdylan_visceraZCLS_pair L620;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZzeroQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L619 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L8 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L83 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L620 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* / */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE1 L621;

extern struct dylanZdylan_visceraZCLS_pair L622;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZSLASH_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L621 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L11 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L622 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* negative? */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L623;

extern struct dylanZdylan_visceraZCLS_pair L624;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZnegativeQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L623 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L8 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L83 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L624 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* negative */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L625;

extern struct dylanZdylan_visceraZCLS_pair L626;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZnegative_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L625 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L8 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L626 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* even? */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L627;

extern struct dylanZdylan_visceraZCLS_pair L628;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZevenQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L627 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L8 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L83 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L628 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <number> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L629;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L630;

extern struct dylanZdylan_visceraZCLS_pair L631;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L632;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_number_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L629 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L630 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L631 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L632 /* class-row */,
};

/* <digit> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L633;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L634;

extern struct dylanZdylan_visceraZCLS_raw_function L635;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L636;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L637;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L638;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L639;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_digit_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L633 /* class-name */,
    20 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L634 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L635 /* class-maker */,
    (heapptr_t) &L636 /* class-new-slot-descriptors */,
    (heapptr_t) &L637 /* class-slot-overrides */,
    (heapptr_t) &L638 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L639 /* class-row */,
};

/* #"value" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L640;

struct dylanZdylan_visceraZCLS_symbol SYM_value_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L640, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_identical_HEAP /* symbol-next */,
};

/* #"equal" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L641;

struct dylanZdylan_visceraZCLS_symbol SYM_equal_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L641, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_value_HEAP /* symbol-next */,
};

/* #"less" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L642;

struct dylanZdylan_visceraZCLS_symbol SYM_less_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L642, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_equal_HEAP /* symbol-next */,
};

/* #"greater" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L643;

struct dylanZdylan_visceraZCLS_symbol SYM_greater_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L643, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_less_HEAP /* symbol-next */,
};

/* <ratio> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L644;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L645;

extern struct dylanZdylan_visceraZCLS_raw_function L646;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L647;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L648;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L649;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L650;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_ratio_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L644 /* class-name */,
    86 /* unique-id */,
    (heapptr_t) &L261 /* direct-superclasses */,
    (heapptr_t) &L645 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L646 /* class-maker */,
    (heapptr_t) &L647 /* class-new-slot-descriptors */,
    (heapptr_t) &L648 /* class-slot-overrides */,
    (heapptr_t) &L649 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L650 /* class-row */,
};

/* #"denominator" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L651;

struct dylanZdylan_visceraZCLS_symbol SYM_denominator_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L651, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_greater_HEAP /* symbol-next */,
};

/* #"numerator" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L652;

struct dylanZdylan_visceraZCLS_symbol SYM_numerator_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L652, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_denominator_HEAP /* symbol-next */,
};

/* <machine-word> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L653;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L654;

extern struct dylanZdylan_visceraZCLS_raw_function L655;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L656;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L657;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L658;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L659;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_machine_word_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L653 /* class-name */,
    19 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L654 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L655 /* class-maker */,
    (heapptr_t) &L656 /* class-new-slot-descriptors */,
    (heapptr_t) &L657 /* class-slot-overrides */,
    (heapptr_t) &L658 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L659 /* class-row */,
};

/* <invalid-bit-number> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L660;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L661;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L662;

extern struct dylanZdylan_visceraZCLS_pair L663;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L664;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L665;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L666;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_invalid_bit_number_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L660 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L661 /* direct-superclasses */,
    (heapptr_t) &L662 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L663 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L664 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L665 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L666 /* class-row */,
};

/* <invalid-bit-index> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L667;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L668;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L669;

extern struct dylanZdylan_visceraZCLS_raw_function L670;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L671;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L672;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_invalid_bit_index_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L667 /* class-name */,
    18 /* unique-id */,
    (heapptr_t) &L668 /* direct-superclasses */,
    (heapptr_t) &L669 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L670 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L671 /* class-slot-overrides */,
    (heapptr_t) &L665 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L672 /* class-row */,
};

/* #"bit-number" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L673;

struct dylanZdylan_visceraZCLS_symbol SYM_bit_number_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L673, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_numerator_HEAP /* symbol-next */,
};

/* <symbol-table> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L674;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L675;

extern struct dylanZdylan_visceraZCLS_raw_function L676;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L677;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L678;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L679;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L680;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_symbol_table_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L674 /* class-name */,
    9 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L675 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L676 /* class-maker */,
    (heapptr_t) &L677 /* class-new-slot-descriptors */,
    (heapptr_t) &L678 /* class-slot-overrides */,
    (heapptr_t) &L679 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L680 /* class-row */,
};

/* #"string" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L681;

struct dylanZdylan_visceraZCLS_symbol SYM_string_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L681, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_bit_number_HEAP /* symbol-next */,
};

/* #"table" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L682;

struct dylanZdylan_visceraZCLS_symbol SYM_table_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L682, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_string_HEAP /* symbol-next */,
};

/* #"code" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L683;

struct dylanZdylan_visceraZCLS_symbol SYM_code_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L683, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_table_HEAP /* symbol-next */,
};

/* <value-cell> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L684;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L685;

extern struct dylanZdylan_visceraZCLS_raw_function L686;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L687;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L688;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L689;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L690;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_value_cell_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L684 /* class-name */,
    8 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L685 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L686 /* class-maker */,
    (heapptr_t) &L687 /* class-new-slot-descriptors */,
    (heapptr_t) &L688 /* class-slot-overrides */,
    (heapptr_t) &L689 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L690 /* class-row */,
};

/* element-setter */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L691;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L692;

extern struct dylanZdylan_visceraZCLS_pair L693;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZelement_setter_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L691 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L692 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L693 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* key-test */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L694;

extern struct dylanZdylan_visceraZCLS_pair L695;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZkey_test_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L694 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L105 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L452 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L695 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* key-sequence */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L696;

extern struct dylanZdylan_visceraZCLS_pair L697;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZkey_sequence_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L696 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L105 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L377 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L697 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"test" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L698;

struct dylanZdylan_visceraZCLS_symbol SYM_test_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L698, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_code_HEAP /* symbol-next */,
};

/* intersection */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L699;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L700;

extern struct dylanZdylan_visceraZCLS_pair L701;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZintersection_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L699 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L700 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L603 /* function-keywords */,
    (heapptr_t) &L377 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L701 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* type-for-copy */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L702;

extern struct dylanZdylan_visceraZCLS_pair L703;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZtype_for_copy_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L702 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L8 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L91 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L703 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"skip" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L704;

struct dylanZdylan_visceraZCLS_symbol SYM_skip_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L704, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_test_HEAP /* symbol-next */,
};

/* #"failure" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L705;

struct dylanZdylan_visceraZCLS_symbol SYM_failure_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L705, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_skip_HEAP /* symbol-next */,
};

/* #"count" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L706;

struct dylanZdylan_visceraZCLS_symbol SYM_count_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L706, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_failure_HEAP /* symbol-next */,
};

/* add */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE3 L707;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L708;

extern struct dylanZdylan_visceraZCLS_pair L709;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZadd_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L707 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L708 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L377 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L709 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* add! */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L710;

extern struct dylanZdylan_visceraZCLS_pair L711;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZaddD_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L710 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L708 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L377 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L711 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* remove */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L712;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L713;

extern struct dylanZdylan_visceraZCLS_pair L714;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZremove_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L712 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L708 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L713 /* function-keywords */,
    (heapptr_t) &L377 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L714 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* reverse */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L715;

extern struct dylanZdylan_visceraZCLS_pair L716;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZreverse_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L715 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L377 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L377 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L716 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* choose */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L717;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L718;

extern struct dylanZdylan_visceraZCLS_pair L719;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZchoose_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L717 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L718 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L377 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L719 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* difference */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L720;

extern struct dylanZdylan_visceraZCLS_pair L721;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZdifference_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L720 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L700 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L603 /* function-keywords */,
    (heapptr_t) &L377 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L721 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* remove-duplicates */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L722;

extern struct dylanZdylan_visceraZCLS_pair L723;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZremove_duplicates_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L722 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L377 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L603 /* function-keywords */,
    (heapptr_t) &L377 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L723 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"start" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L724;

struct dylanZdylan_visceraZCLS_symbol SYM_start_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L724, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_count_HEAP /* symbol-next */,
};

/* copy-sequence */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L725;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L726;

extern struct dylanZdylan_visceraZCLS_pair L727;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZcopy_sequence_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L725 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L377 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L726 /* function-keywords */,
    (heapptr_t) &L377 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L727 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* empty? */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L728;

extern struct dylanZdylan_visceraZCLS_pair L729;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZemptyQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L728 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L105 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L83 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L729 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"from" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L730;

struct dylanZdylan_visceraZCLS_symbol SYM_from_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L730, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_start_HEAP /* symbol-next */,
};

/* #"below" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L731;

struct dylanZdylan_visceraZCLS_symbol SYM_below_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L731, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_from_HEAP /* symbol-next */,
};

/* dimensions */
extern struct dylanZdylan_visceraZCLS_pair L732;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZdimensions_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L277 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L354 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L377 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L732 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* reduce */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L733;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L734;

extern struct dylanZdylan_visceraZCLS_pair L735;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZreduce_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L733 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L734 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L735 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* row-major-index */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L736;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L737;

extern struct dylanZdylan_visceraZCLS_pair L738;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZrow_major_index_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L736 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L354 /* function-specializers */,
    1 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L737 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L738 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <simple-object-array> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L739;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L740;

extern struct dylanZdylan_visceraZCLS_raw_function L741;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L742;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L743;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L744;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L745;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_object_array_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L739 /* class-name */,
    48 /* unique-id */,
    (heapptr_t) &L354 /* direct-superclasses */,
    (heapptr_t) &L740 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L741 /* class-maker */,
    (heapptr_t) &L742 /* class-new-slot-descriptors */,
    (heapptr_t) &L743 /* class-slot-overrides */,
    (heapptr_t) &L744 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L745 /* class-row */,
};

/* #"rank" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L746;

struct dylanZdylan_visceraZCLS_symbol SYM_rank_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L746, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_below_HEAP /* symbol-next */,
};

/* #"data-vector" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L747;

struct dylanZdylan_visceraZCLS_symbol SYM_data_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L747, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_rank_HEAP /* symbol-next */,
};

/* {<slot-descriptor> for ssv-current-size introduced by <builtin-stretchy-vector>} */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L748;

extern struct dylanZdylan_visceraZCLS_pair L749;

extern struct dylanZdylan_visceraZCLS_symbol SYM_long_HEAP;

struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_builtin_stretchy_vectorZdylanZdylan_visceraZssv_current_size_SLOT_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptor_HEAP /* %object-class */,
    (heapptr_t) &L748 /* slot-name */,
    (heapptr_t) &SYM_instance_HEAP /* slot-allocation */,
    (heapptr_t) &dylanZdylan_visceraZCLS_integer_HEAP /* slot-type */,
    (heapptr_t) 0 /* slot-getter */,
    (heapptr_t) &dylan_L1 /* slot-init-function */,
    { (heapptr_t) &L0, { 0 } } /* slot-init-value */,
    (heapptr_t) &dylan_L1 /* slot-init-keyword */,
    0 /* slot-init-keyword-required? */,
    { 0, 0, 0, }, /* hole */
    (heapptr_t) &L749 /* slot-positions */,
    { (heapptr_t) &dylan_L1, { 0 } } /* slot-positions-cache */,
    (heapptr_t) &SYM_long_HEAP /* slot-representation */,
    (heapptr_t) &dylan_L1 /* slot-initialized?-slot */,
};

/* <stretchy-object-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE24 L750;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L751;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE12 L752;

extern struct dylanZdylan_visceraZCLS_raw_function L753;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L754;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L755;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L756;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L757;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_stretchy_object_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L750 /* class-name */,
    40 /* unique-id */,
    (heapptr_t) &L751 /* direct-superclasses */,
    (heapptr_t) &L752 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_vector_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L753 /* class-maker */,
    (heapptr_t) &L754 /* class-new-slot-descriptors */,
    (heapptr_t) &L755 /* class-slot-overrides */,
    (heapptr_t) &L756 /* class-all-slot-descriptors */,
    10 /* class-bucket */,
    (heapptr_t) &L757 /* class-row */,
};

/* ssv-data-setter */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L758;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L759;

extern struct dylanZdylan_visceraZCLS_pair L760;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZssv_data_setter_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L758 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L759 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L760 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* lsv-data-type */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L761;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L762;

extern struct dylanZdylan_visceraZCLS_pair L763;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZlsv_data_type_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L761 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L762 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L197 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L763 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* lsv-fill */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L764;

extern struct dylanZdylan_visceraZCLS_pair L765;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZlsv_fill_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L764 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L762 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L765 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* fill! */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L766;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L767;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L768;

extern struct dylanZdylan_visceraZCLS_pair L769;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZfillD_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L766 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L767 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &L768 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L769 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* ssv-data */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L770;

extern struct dylanZdylan_visceraZCLS_pair L771;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZssv_data_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L770 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L751 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L771 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* ***foo-internal*** */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L772;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L773;

extern struct dylanZdylan_visceraZCLS_raw_function L774;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L775;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L776;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L777;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L778;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZVVVfoo_internalVVV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L772 /* class-name */,
    50 /* unique-id */,
    (heapptr_t) &L46 /* direct-superclasses */,
    (heapptr_t) &L773 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L774 /* class-maker */,
    (heapptr_t) &L775 /* class-new-slot-descriptors */,
    (heapptr_t) &L776 /* class-slot-overrides */,
    (heapptr_t) &L777 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L778 /* class-row */,
};

/* <foo> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L779;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L780;

extern struct dylanZdylan_visceraZCLS_raw_function L781;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L782;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L783;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L784;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L785;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_foo_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L779 /* class-name */,
    39 /* unique-id */,
    (heapptr_t) &L762 /* direct-superclasses */,
    (heapptr_t) &L780 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_vector_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L781 /* class-maker */,
    (heapptr_t) &L782 /* class-new-slot-descriptors */,
    (heapptr_t) &L783 /* class-slot-overrides */,
    (heapptr_t) &L784 /* class-all-slot-descriptors */,
    12 /* class-bucket */,
    (heapptr_t) &L785 /* class-row */,
};

/* <byte-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L786;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L787;

extern struct dylanZdylan_visceraZCLS_raw_function L788;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L789;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L790;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L791;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L792;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_byte_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L786 /* class-name */,
    62 /* unique-id */,
    (heapptr_t) &L94 /* direct-superclasses */,
    (heapptr_t) &L787 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L788 /* class-maker */,
    (heapptr_t) &L789 /* class-new-slot-descriptors */,
    (heapptr_t) &L790 /* class-slot-overrides */,
    (heapptr_t) &L791 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L792 /* class-row */,
};

/* <buffer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L793;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L794;

extern struct dylanZdylan_visceraZCLS_raw_function L795;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L796;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L797;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L798;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L799;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_buffer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L793 /* class-name */,
    61 /* unique-id */,
    (heapptr_t) &L94 /* direct-superclasses */,
    (heapptr_t) &L794 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L795 /* class-maker */,
    (heapptr_t) &L796 /* class-new-slot-descriptors */,
    (heapptr_t) &L797 /* class-slot-overrides */,
    (heapptr_t) &L798 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L799 /* class-row */,
};

/* #"tail" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L800;

struct dylanZdylan_visceraZCLS_symbol SYM_tail_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L800, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_data_vector_HEAP /* symbol-next */,
};

/* #"head" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L801;

struct dylanZdylan_visceraZCLS_symbol SYM_head_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L801, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_tail_HEAP /* symbol-next */,
};

/* <builtin-range> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L802;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L803;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L804;

extern struct dylanZdylan_visceraZCLS_pair L805;

extern struct dylanZdylan_visceraZCLS_raw_function L806;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L807;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L808;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L809;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L810;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_builtin_range_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L802 /* class-name */,
    65 /* unique-id */,
    (heapptr_t) &L803 /* direct-superclasses */,
    (heapptr_t) &L804 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_range_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L805 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L806 /* class-maker */,
    (heapptr_t) &L807 /* class-new-slot-descriptors */,
    (heapptr_t) &L808 /* class-slot-overrides */,
    (heapptr_t) &L809 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L810 /* class-row */,
};

/* #"by" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE2 L811;

struct dylanZdylan_visceraZCLS_symbol SYM_by_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L811, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_head_HEAP /* symbol-next */,
};

/* #"none" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L812;

struct dylanZdylan_visceraZCLS_symbol SYM_none_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L812, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_by_HEAP /* symbol-next */,
};

/* #"increasing" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L813;

struct dylanZdylan_visceraZCLS_symbol SYM_increasing_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L813, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_none_HEAP /* symbol-next */,
};

/* #"decreasing" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L814;

struct dylanZdylan_visceraZCLS_symbol SYM_decreasing_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L814, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_increasing_HEAP /* symbol-next */,
};

/* <unbounded-range> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L815;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L816;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L817;

extern struct dylanZdylan_visceraZCLS_raw_function L818;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L819;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L820;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_unbounded_range_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L815 /* class-name */,
    67 /* unique-id */,
    (heapptr_t) &L816 /* direct-superclasses */,
    (heapptr_t) &L817 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_range_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L818 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L819 /* class-slot-overrides */,
    (heapptr_t) &L809 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L820 /* class-row */,
};

/* <bounded-range> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L821;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L822;

extern struct dylanZdylan_visceraZCLS_raw_function L823;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L824;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L825;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L826;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L827;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_bounded_range_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L821 /* class-name */,
    66 /* unique-id */,
    (heapptr_t) &L816 /* direct-superclasses */,
    (heapptr_t) &L822 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_range_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L823 /* class-maker */,
    (heapptr_t) &L824 /* class-new-slot-descriptors */,
    (heapptr_t) &L825 /* class-slot-overrides */,
    (heapptr_t) &L826 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L827 /* class-row */,
};

/* positive? */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L828;

extern struct dylanZdylan_visceraZCLS_pair L829;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZpositiveQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L828 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L8 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L83 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L829 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"to" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE2 L830;

struct dylanZdylan_visceraZCLS_symbol SYM_to_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L830, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_decreasing_HEAP /* symbol-next */,
};

/* #"above" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L831;

struct dylanZdylan_visceraZCLS_symbol SYM_above_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L831, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_to_HEAP /* symbol-next */,
};

/* #"stable" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L832;

struct dylanZdylan_visceraZCLS_symbol SYM_stable_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L832, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_above_HEAP /* symbol-next */,
};

/* last */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L833;

extern struct dylanZdylan_visceraZCLS_pair L834;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZlast_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L833 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L377 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L599 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L834 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"increasing-increasing" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L835;

struct dylanZdylan_visceraZCLS_symbol SYM_increasing_increasing_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L835, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_stable_HEAP /* symbol-next */,
};

/* #"increasing-decreasing" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L836;

struct dylanZdylan_visceraZCLS_symbol SYM_increasing_decreasing_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L836, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_increasing_increasing_HEAP /* symbol-next */,
};

/* #"decreasing-increasing" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L837;

struct dylanZdylan_visceraZCLS_symbol SYM_decreasing_increasing_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L837, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_increasing_decreasing_HEAP /* symbol-next */,
};

/* #"decreasing-decreasing" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L838;

struct dylanZdylan_visceraZCLS_symbol SYM_decreasing_decreasing_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L838, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_decreasing_increasing_HEAP /* symbol-next */,
};

/* <simple-object-deque> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L839;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L840;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L841;

extern struct dylanZdylan_visceraZCLS_raw_function L842;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L843;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L844;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L845;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L846;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_object_deque_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L839 /* class-name */,
    38 /* unique-id */,
    (heapptr_t) &L840 /* direct-superclasses */,
    (heapptr_t) &L841 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L842 /* class-maker */,
    (heapptr_t) &L843 /* class-new-slot-descriptors */,
    (heapptr_t) &L844 /* class-slot-overrides */,
    (heapptr_t) &L845 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L846 /* class-row */,
};

/* <deque-element> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L847;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L848;

extern struct dylanZdylan_visceraZCLS_raw_function L849;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L850;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L851;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L852;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L853;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_deque_element_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L847 /* class-name */,
    7 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L848 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L849 /* class-maker */,
    (heapptr_t) &L850 /* class-new-slot-descriptors */,
    (heapptr_t) &L851 /* class-slot-overrides */,
    (heapptr_t) &L852 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L853 /* class-row */,
};

/* #"data" */
struct dylanZdylan_visceraZCLS_symbol SYM_data_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L7, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_decreasing_decreasing_HEAP /* symbol-next */,
};

/* push */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L854;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L855;

extern struct dylanZdylan_visceraZCLS_pair L856;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZpush_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L854 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L855 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L856 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"ordered" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L857;

struct dylanZdylan_visceraZCLS_symbol SYM_ordered_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L857, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_data_HEAP /* symbol-next */,
};

/* <table-item> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L858;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L859;

extern struct dylanZdylan_visceraZCLS_raw_function L860;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L861;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L862;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L863;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L864;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_table_item_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L858 /* class-name */,
    6 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L859 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L860 /* class-maker */,
    (heapptr_t) &L861 /* class-new-slot-descriptors */,
    (heapptr_t) &L862 /* class-slot-overrides */,
    (heapptr_t) &L863 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L864 /* class-row */,
};

/* #"hash-id" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L865;

struct dylanZdylan_visceraZCLS_symbol SYM_hash_id_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L865, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_ordered_HEAP /* symbol-next */,
};

/* #"item" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L866;

struct dylanZdylan_visceraZCLS_symbol SYM_item_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L866, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_hash_id_HEAP /* symbol-next */,
};

/* <entry-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L867;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L868;

extern struct dylanZdylan_visceraZCLS_raw_function L869;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L870;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L871;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L872;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L873;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_entry_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L867 /* class-name */,
    49 /* unique-id */,
    (heapptr_t) &L46 /* direct-superclasses */,
    (heapptr_t) &L868 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L869 /* class-maker */,
    (heapptr_t) &L870 /* class-new-slot-descriptors */,
    (heapptr_t) &L871 /* class-slot-overrides */,
    (heapptr_t) &L872 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L873 /* class-row */,
};

/* <simple-object-table> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L874;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L875;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L876;

extern struct dylanZdylan_visceraZCLS_raw_function L877;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L878;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L879;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_object_table_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L874 /* class-name */,
    43 /* unique-id */,
    (heapptr_t) &L875 /* direct-superclasses */,
    (heapptr_t) &L876 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_table_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L877 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L878 /* class-slot-overrides */,
    (heapptr_t) &L342 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L879 /* class-row */,
};

/* <equal-table> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L880;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L881;

extern struct dylanZdylan_visceraZCLS_raw_function L882;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L883;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L884;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_equal_table_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L880 /* class-name */,
    41 /* unique-id */,
    (heapptr_t) &L345 /* direct-superclasses */,
    (heapptr_t) &L881 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_table_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L882 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L883 /* class-slot-overrides */,
    (heapptr_t) &L342 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L884 /* class-row */,
};

/* table-protocol */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L885;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L886;

extern struct dylanZdylan_visceraZCLS_pair L887;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZtable_protocol_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L885 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L345 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L886 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L887 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* equal-hash */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L888;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L889;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L890;

extern struct dylanZdylan_visceraZCLS_pair L891;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZequal_hash_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L888 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L889 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L890 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L891 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <table-iterator> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L892;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L893;

extern struct dylanZdylan_visceraZCLS_raw_function L894;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L895;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L896;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L897;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L898;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_table_iterator_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L892 /* class-name */,
    5 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L893 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L894 /* class-maker */,
    (heapptr_t) &L895 /* class-new-slot-descriptors */,
    (heapptr_t) &L896 /* class-slot-overrides */,
    (heapptr_t) &L897 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L898 /* class-row */,
};

/* #"entries" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L899;

struct dylanZdylan_visceraZCLS_symbol SYM_entries_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L899, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_item_HEAP /* symbol-next */,
};

/* #"current" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L900;

struct dylanZdylan_visceraZCLS_symbol SYM_current_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L900, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_entries_HEAP /* symbol-next */,
};

/* value-hash */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L901;

extern struct dylanZdylan_visceraZCLS_pair L902;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZvalue_hash_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L901 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L889 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L890 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L902 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* sort! */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L903;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L904;

extern struct dylanZdylan_visceraZCLS_pair L905;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZsortD_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L903 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L377 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L904 /* function-keywords */,
    (heapptr_t) &L377 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L905 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <limited-collection-mixin> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE26 L906;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L907;

extern struct dylanZdylan_visceraZCLS_pair L908;

extern struct dylanZdylan_visceraZCLS_raw_function L909;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L910;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L911;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L912;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L913;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_limited_collection_mixin_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L906 /* class-name */,
    37 /* unique-id */,
    (heapptr_t) &L105 /* direct-superclasses */,
    (heapptr_t) &L907 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L908 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L909 /* class-maker */,
    (heapptr_t) &L910 /* class-new-slot-descriptors */,
    (heapptr_t) &L911 /* class-slot-overrides */,
    (heapptr_t) &L912 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L913 /* class-row */,
};

/* #"collection-type" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L914;

struct dylanZdylan_visceraZCLS_symbol SYM_collection_type_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L914, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_current_HEAP /* symbol-next */,
};

/* <limited-object-table> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE22 L915;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L916;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L917;

extern struct dylanZdylan_visceraZCLS_raw_function L918;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L919;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L920;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L921;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_limited_object_table_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L915 /* class-name */,
    42 /* unique-id */,
    (heapptr_t) &L916 /* direct-superclasses */,
    (heapptr_t) &L917 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_table_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L918 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L919 /* class-slot-overrides */,
    (heapptr_t) &L920 /* class-all-slot-descriptors */,
    6 /* class-bucket */,
    (heapptr_t) &L921 /* class-row */,
};

/* <simple-uchar-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L922;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L923;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L924;

extern struct dylanZdylan_visceraZCLS_raw_function L925;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L926;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L927;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L928;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L929;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_uchar_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L922 /* class-name */,
    60 /* unique-id */,
    (heapptr_t) &L923 /* direct-superclasses */,
    (heapptr_t) &L924 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L925 /* class-maker */,
    (heapptr_t) &L926 /* class-new-slot-descriptors */,
    (heapptr_t) &L927 /* class-slot-overrides */,
    (heapptr_t) &L928 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L929 /* class-row */,
};

/* <simple-schar-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L930;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L931;

extern struct dylanZdylan_visceraZCLS_raw_function L932;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L933;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L934;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L935;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L936;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_schar_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L930 /* class-name */,
    59 /* unique-id */,
    (heapptr_t) &L923 /* direct-superclasses */,
    (heapptr_t) &L931 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L932 /* class-maker */,
    (heapptr_t) &L933 /* class-new-slot-descriptors */,
    (heapptr_t) &L934 /* class-slot-overrides */,
    (heapptr_t) &L935 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L936 /* class-row */,
};

/* <simple-ushort-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE22 L937;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L938;

extern struct dylanZdylan_visceraZCLS_raw_function L939;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L940;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L941;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L942;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L943;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_ushort_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L937 /* class-name */,
    58 /* unique-id */,
    (heapptr_t) &L923 /* direct-superclasses */,
    (heapptr_t) &L938 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L939 /* class-maker */,
    (heapptr_t) &L940 /* class-new-slot-descriptors */,
    (heapptr_t) &L941 /* class-slot-overrides */,
    (heapptr_t) &L942 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L943 /* class-row */,
};

/* <simple-sshort-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE22 L944;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L945;

extern struct dylanZdylan_visceraZCLS_raw_function L946;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L947;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L948;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L949;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L950;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_sshort_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L944 /* class-name */,
    57 /* unique-id */,
    (heapptr_t) &L923 /* direct-superclasses */,
    (heapptr_t) &L945 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L946 /* class-maker */,
    (heapptr_t) &L947 /* class-new-slot-descriptors */,
    (heapptr_t) &L948 /* class-slot-overrides */,
    (heapptr_t) &L949 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L950 /* class-row */,
};

/* <limited-simple-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L951;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L952;

extern struct dylanZdylan_visceraZCLS_raw_function L953;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L954;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L955;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L956;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L957;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_limited_simple_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L951 /* class-name */,
    51 /* unique-id */,
    (heapptr_t) &L923 /* direct-superclasses */,
    (heapptr_t) &L952 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L953 /* class-maker */,
    (heapptr_t) &L954 /* class-new-slot-descriptors */,
    (heapptr_t) &L955 /* class-slot-overrides */,
    (heapptr_t) &L956 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L957 /* class-row */,
};

/* <simple-integer-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L958;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L959;

extern struct dylanZdylan_visceraZCLS_raw_function L960;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L961;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L962;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L963;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L964;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_integer_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L958 /* class-name */,
    56 /* unique-id */,
    (heapptr_t) &L923 /* direct-superclasses */,
    (heapptr_t) &L959 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L960 /* class-maker */,
    (heapptr_t) &L961 /* class-new-slot-descriptors */,
    (heapptr_t) &L962 /* class-slot-overrides */,
    (heapptr_t) &L963 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L964 /* class-row */,
};

/* <simple-character-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE25 L965;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L966;

extern struct dylanZdylan_visceraZCLS_raw_function L967;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L968;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L969;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L970;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L971;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_character_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L965 /* class-name */,
    55 /* unique-id */,
    (heapptr_t) &L923 /* direct-superclasses */,
    (heapptr_t) &L966 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L967 /* class-maker */,
    (heapptr_t) &L968 /* class-new-slot-descriptors */,
    (heapptr_t) &L969 /* class-slot-overrides */,
    (heapptr_t) &L970 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L971 /* class-row */,
};

/* <simple-float-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L972;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L973;

extern struct dylanZdylan_visceraZCLS_raw_function L974;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L975;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L976;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L977;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L978;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_float_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L972 /* class-name */,
    54 /* unique-id */,
    (heapptr_t) &L923 /* direct-superclasses */,
    (heapptr_t) &L973 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L974 /* class-maker */,
    (heapptr_t) &L975 /* class-new-slot-descriptors */,
    (heapptr_t) &L976 /* class-slot-overrides */,
    (heapptr_t) &L977 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L978 /* class-row */,
};

/* <simple-double-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE22 L979;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L980;

extern struct dylanZdylan_visceraZCLS_raw_function L981;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L982;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L983;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L984;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L985;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_double_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L979 /* class-name */,
    53 /* unique-id */,
    (heapptr_t) &L923 /* direct-superclasses */,
    (heapptr_t) &L980 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L981 /* class-maker */,
    (heapptr_t) &L982 /* class-new-slot-descriptors */,
    (heapptr_t) &L983 /* class-slot-overrides */,
    (heapptr_t) &L984 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L985 /* class-row */,
};

/* <simple-extended-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE24 L986;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L987;

extern struct dylanZdylan_visceraZCLS_raw_function L988;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L989;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L990;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L991;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L992;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_extended_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L986 /* class-name */,
    52 /* unique-id */,
    (heapptr_t) &L923 /* direct-superclasses */,
    (heapptr_t) &L987 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L988 /* class-maker */,
    (heapptr_t) &L989 /* class-new-slot-descriptors */,
    (heapptr_t) &L990 /* class-slot-overrides */,
    (heapptr_t) &L991 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L992 /* class-row */,
};

/* <handler> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L993;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L994;

extern struct dylanZdylan_visceraZCLS_raw_function L995;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L996;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L997;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L998;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L999;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_handler_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L993 /* class-name */,
    4 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L994 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L995 /* class-maker */,
    (heapptr_t) &L996 /* class-new-slot-descriptors */,
    (heapptr_t) &L997 /* class-slot-overrides */,
    (heapptr_t) &L998 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L999 /* class-row */,
};

/* #"prev" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1000;

struct dylanZdylan_visceraZCLS_symbol SYM_prev_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1000, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_collection_type_HEAP /* symbol-next */,
};

/* #"init-arguments" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1001;

struct dylanZdylan_visceraZCLS_symbol SYM_init_arguments_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1001, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_prev_HEAP /* symbol-next */,
};

/* #"function" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L1002;

struct dylanZdylan_visceraZCLS_symbol SYM_function_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1002, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_init_arguments_HEAP /* symbol-next */,
};

/* <unwind-block> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1003;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1004;

extern struct dylanZdylan_visceraZCLS_pair L1005;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1006;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1007;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1008;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_unwind_block_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1003 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1004 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1005 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L1006 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L1007 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1008 /* class-row */,
};

/* <unwind-protect> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L1009;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1010;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1011;

extern struct dylanZdylan_visceraZCLS_raw_function L1012;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1013;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1014;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1015;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1016;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_unwind_protect_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1009 /* class-name */,
    3 /* unique-id */,
    (heapptr_t) &L1010 /* direct-superclasses */,
    (heapptr_t) &L1011 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1012 /* class-maker */,
    (heapptr_t) &L1013 /* class-new-slot-descriptors */,
    (heapptr_t) &L1014 /* class-slot-overrides */,
    (heapptr_t) &L1015 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1016 /* class-row */,
};

/* #"cleanup" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L1017;

struct dylanZdylan_visceraZCLS_symbol SYM_cleanup_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1017, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_function_HEAP /* symbol-next */,
};

/* #"saved-handler" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1018;

struct dylanZdylan_visceraZCLS_symbol SYM_saved_handler_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1018, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_cleanup_HEAP /* symbol-next */,
};

/* #"saved-uwp" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1019;

struct dylanZdylan_visceraZCLS_symbol SYM_saved_uwp_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1019, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_saved_handler_HEAP /* symbol-next */,
};

/* #"saved-stack" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1020;

struct dylanZdylan_visceraZCLS_symbol SYM_saved_stack_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1020, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_saved_uwp_HEAP /* symbol-next */,
};

/* <catcher> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1021;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1022;

extern struct dylanZdylan_visceraZCLS_raw_function L1023;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1024;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1025;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L1026;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1027;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_catcher_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1021 /* class-name */,
    2 /* unique-id */,
    (heapptr_t) &L1010 /* direct-superclasses */,
    (heapptr_t) &L1022 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1023 /* class-maker */,
    (heapptr_t) &L1024 /* class-new-slot-descriptors */,
    (heapptr_t) &L1025 /* class-slot-overrides */,
    (heapptr_t) &L1026 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1027 /* class-row */,
};

/* #"thread" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1028;

struct dylanZdylan_visceraZCLS_symbol SYM_thread_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1028, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_saved_stack_HEAP /* symbol-next */,
};

/* #"saved-state" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1029;

struct dylanZdylan_visceraZCLS_symbol SYM_saved_state_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1029, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_thread_HEAP /* symbol-next */,
};

/* <thread> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L1030;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1031;

extern struct dylanZdylan_visceraZCLS_raw_function L1032;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1033;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1034;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1035;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1036;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_thread_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1030 /* class-name */,
    1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1031 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1032 /* class-maker */,
    (heapptr_t) &L1033 /* class-new-slot-descriptors */,
    (heapptr_t) &L1034 /* class-slot-overrides */,
    (heapptr_t) &L1035 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1036 /* class-row */,
};

/* report-condition */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L1037;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1038;

extern struct dylanZdylan_visceraZCLS_pair L1039;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZreport_condition_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1037 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1038 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1039 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* {<slot-descriptor> for condition-format-string introduced by <format-string-condition>} */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L1040;

extern struct dylanZdylan_visceraZCLS_generic_function dylan_L1106;

extern struct dylanZdylan_visceraZCLS_symbol SYM_format_string_HEAP;

extern struct dylanZdylan_visceraZCLS_pair L1041;

struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_format_string_conditionZdylanZdylan_visceraZcondition_format_string_SLOT_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptor_HEAP /* %object-class */,
    (heapptr_t) &L1040 /* slot-name */,
    (heapptr_t) &SYM_instance_HEAP /* slot-allocation */,
    (heapptr_t) &dylanZdylan_visceraZCLS_string_HEAP /* slot-type */,
    (heapptr_t) &dylan_L1106 /* slot-getter */,
    (heapptr_t) &dylan_L1 /* slot-init-function */,
    { (heapptr_t) &dylanZliteral_ROOT, { 0 } } /* slot-init-value */,
    (heapptr_t) &SYM_format_string_HEAP /* slot-init-keyword */,
    1 /* slot-init-keyword-required? */,
    { 0, 0, 0, }, /* hole */
    (heapptr_t) &L1041 /* slot-positions */,
    { (heapptr_t) &dylan_L1, { 0 } } /* slot-positions-cache */,
    (heapptr_t) &SYM_general_HEAP /* slot-representation */,
    (heapptr_t) &dylan_L1 /* slot-initialized?-slot */,
};

/* {<slot-descriptor> for condition-format-arguments introduced by <format-string-condition>} */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE26 L1042;

extern struct dylanZdylan_visceraZCLS_generic_function dylan_L1107;

extern struct dylanZdylan_visceraZCLS_symbol SYM_format_arguments_HEAP;

extern struct dylanZdylan_visceraZCLS_pair L1043;

struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_format_string_conditionZdylanZdylan_visceraZcondition_format_arguments_SLOT_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptor_HEAP /* %object-class */,
    (heapptr_t) &L1042 /* slot-name */,
    (heapptr_t) &SYM_instance_HEAP /* slot-allocation */,
    (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP /* slot-type */,
    (heapptr_t) &dylan_L1107 /* slot-getter */,
    (heapptr_t) &dylan_L1 /* slot-init-function */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* slot-init-value */,
    (heapptr_t) &SYM_format_arguments_HEAP /* slot-init-keyword */,
    0 /* slot-init-keyword-required? */,
    { 0, 0, 0, }, /* hole */
    (heapptr_t) &L1043 /* slot-positions */,
    { (heapptr_t) &dylan_L1, { 0 } } /* slot-positions-cache */,
    (heapptr_t) &SYM_general_HEAP /* slot-representation */,
    (heapptr_t) &dylan_L1 /* slot-initialized?-slot */,
};

/* <simple-error> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1044;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1045;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L1046;

extern struct dylanZdylan_visceraZCLS_raw_function L1047;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1048;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1049;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1050;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1044 /* class-name */,
    17 /* unique-id */,
    (heapptr_t) &L1045 /* direct-superclasses */,
    (heapptr_t) &L1046 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1047 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1048 /* class-slot-overrides */,
    (heapptr_t) &L1049 /* class-all-slot-descriptors */,
    5 /* class-bucket */,
    (heapptr_t) &L1050 /* class-row */,
};

/* #"format-string" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1051;

struct dylanZdylan_visceraZCLS_symbol SYM_format_string_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1051, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_saved_state_HEAP /* symbol-next */,
};

/* #"format-arguments" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L1052;

struct dylanZdylan_visceraZCLS_symbol SYM_format_arguments_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1052, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_format_string_HEAP /* symbol-next */,
};

/* <type-error> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1053;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1054;

extern struct dylanZdylan_visceraZCLS_raw_function L1055;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1056;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1057;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1058;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1059;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_type_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1053 /* class-name */,
    16 /* unique-id */,
    (heapptr_t) &L661 /* direct-superclasses */,
    (heapptr_t) &L1054 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1055 /* class-maker */,
    (heapptr_t) &L1056 /* class-new-slot-descriptors */,
    (heapptr_t) &L1057 /* class-slot-overrides */,
    (heapptr_t) &L1058 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1059 /* class-row */,
};

/* #"source-location" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1060;

struct dylanZdylan_visceraZCLS_symbol SYM_source_location_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1060, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_format_arguments_HEAP /* symbol-next */,
};

/* <sealed-object-error> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L1061;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1062;

extern struct dylanZdylan_visceraZCLS_raw_function L1063;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1064;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1065;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_sealed_object_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1061 /* class-name */,
    15 /* unique-id */,
    (heapptr_t) &L661 /* direct-superclasses */,
    (heapptr_t) &L1062 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1063 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1064 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1065 /* class-row */,
};

/* <simple-warning> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L1066;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1067;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L1068;

extern struct dylanZdylan_visceraZCLS_pair L1069;

extern struct dylanZdylan_visceraZCLS_raw_function L1070;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1071;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1072;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_warning_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1066 /* class-name */,
    12 /* unique-id */,
    (heapptr_t) &L1067 /* direct-superclasses */,
    (heapptr_t) &L1068 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1069 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1070 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1071 /* class-slot-overrides */,
    (heapptr_t) &L1049 /* class-all-slot-descriptors */,
    3 /* class-bucket */,
    (heapptr_t) &L1072 /* class-row */,
};

/* <simple-restart> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L1073;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1074;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L1075;

extern struct dylanZdylan_visceraZCLS_raw_function L1076;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1077;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1078;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_simple_restart_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1073 /* class-name */,
    11 /* unique-id */,
    (heapptr_t) &L1074 /* direct-superclasses */,
    (heapptr_t) &L1075 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1076 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1077 /* class-slot-overrides */,
    (heapptr_t) &L1049 /* class-all-slot-descriptors */,
    3 /* class-bucket */,
    (heapptr_t) &L1078 /* class-row */,
};

/* <abort> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 dylanZstr_ROOT_522;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1079;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1080;

extern struct dylanZdylan_visceraZCLS_raw_function L1081;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1082;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1083;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1084;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1085;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_abort_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &dylanZstr_ROOT_522 /* class-name */,
    10 /* unique-id */,
    (heapptr_t) &L1079 /* direct-superclasses */,
    (heapptr_t) &L1080 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1081 /* class-maker */,
    (heapptr_t) &L1082 /* class-new-slot-descriptors */,
    (heapptr_t) &L1083 /* class-slot-overrides */,
    (heapptr_t) &L1084 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1085 /* class-row */,
};

/* #"description" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1086;

struct dylanZdylan_visceraZCLS_symbol SYM_description_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1086, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_source_location_HEAP /* symbol-next */,
};

/* condition-format */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L1087;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1088;

extern struct dylanZdylan_visceraZCLS_pair L1089;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZcondition_format_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1087 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1088 /* function-specializers */,
    1 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1089 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* default-handler */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1090;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1091;

extern struct dylanZdylan_visceraZCLS_pair L1092;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZdefault_handler_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1090 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1091 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L1092 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* invoke-debugger */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1093;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1094;

extern struct dylanZdylan_visceraZCLS_pair L1095;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZinvoke_debugger_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1093 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1094 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L1095 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <breakpoint> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1096;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1097;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L1098;

extern struct dylanZdylan_visceraZCLS_raw_function L1099;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1100;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1101;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_breakpoint_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1096 /* class-name */,
    13 /* unique-id */,
    (heapptr_t) &L1097 /* direct-superclasses */,
    (heapptr_t) &L1098 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1099 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1100 /* class-slot-overrides */,
    (heapptr_t) &L1049 /* class-all-slot-descriptors */,
    5 /* class-bucket */,
    (heapptr_t) &L1101 /* class-row */,
};

/* <uninitialized-slot-error> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE26 L1102;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1103;

extern struct dylanZdylan_visceraZCLS_raw_function L1104;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1105;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1106;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1107;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1108;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_uninitialized_slot_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1102 /* class-name */,
    14 /* unique-id */,
    (heapptr_t) &L661 /* direct-superclasses */,
    (heapptr_t) &L1103 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1104 /* class-maker */,
    (heapptr_t) &L1105 /* class-new-slot-descriptors */,
    (heapptr_t) &L1106 /* class-slot-overrides */,
    (heapptr_t) &L1107 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1108 /* class-row */,
};

/* <error> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L1109;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1110;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1111;

extern struct dylanZdylan_visceraZCLS_pair L1112;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1113;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1109 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1110 /* direct-superclasses */,
    (heapptr_t) &L1111 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1112 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1113 /* class-row */,
};

/* condition-force-output */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE22 L1114;

extern struct dylanZdylan_visceraZCLS_pair L1115;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZcondition_force_output_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1114 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L8 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1115 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <null-debugger> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1116;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1117;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1118;

extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_debugger_HEAP;

extern struct dylanZdylan_visceraZCLS_raw_function L1119;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1120;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1121;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_null_debugger_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1116 /* class-name */,
    0 /* unique-id */,
    (heapptr_t) &L1117 /* direct-superclasses */,
    (heapptr_t) &L1118 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_debugger_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1119 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1120 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1121 /* class-row */,
};

/* <debugger> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L1122;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1123;

extern struct dylanZdylan_visceraZCLS_pair L1124;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1125;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_debugger_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1122 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1123 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_debugger_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1124 /* direct-subclasses */,
    0 /* class-functional? */,
    1 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1125 /* class-row */,
};

/* #"exit-code" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1126;

struct dylanZdylan_visceraZCLS_symbol SYM_exit_code_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1126, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_description_HEAP /* symbol-next */,
};

/* main */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1127;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZmain_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1127 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L8 /* function-specializers */,
    1 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &dylanZempty_list_ROOT /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"long" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1128;

struct dylanZdylan_visceraZCLS_symbol SYM_long_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1128, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_exit_code_HEAP /* symbol-next */,
};

/* %element */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L1129;

extern struct dylanZdylan_visceraZCLS_pair L1130;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZPCTelement_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1129 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L312 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1130 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* rank */
extern struct dylanZdylan_visceraZCLS_pair L1131;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZrank_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L746 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L354 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L737 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1131 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <builtin-stretchy-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE25 L1132;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1133;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L1134;

extern struct dylanZdylan_visceraZCLS_pair L1135;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1136;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1137;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1138;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_builtin_stretchy_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1132 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1133 /* direct-superclasses */,
    (heapptr_t) &L1134 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_vector_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1135 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L1136 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L1137 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L1138 /* class-row */,
};

/* <limited-stretchy-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE25 L1139;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE12 L1140;

extern struct dylanZdylan_visceraZCLS_pair L1141;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1142;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_limited_stretchy_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1139 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L751 /* direct-superclasses */,
    (heapptr_t) &L1140 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_vector_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1141 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L1137 /* class-all-slot-descriptors */,
    10 /* class-bucket */,
    (heapptr_t) &L1142 /* class-row */,
};

/* %elem */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1143;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1144;

extern struct dylanZdylan_visceraZCLS_pair L1145;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZPCTelem_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1143 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1144 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1145 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"byte-char" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1146;

struct dylanZdylan_visceraZCLS_symbol SYM_byte_char_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1146, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_long_HEAP /* symbol-next */,
};

/* #"ubyte" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1147;

struct dylanZdylan_visceraZCLS_symbol SYM_ubyte_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1147, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_byte_char_HEAP /* symbol-next */,
};

/* <condition> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1148;

extern struct dylanZdylan_visceraZCLS_pair L1149;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1150;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_condition_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1148 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1038 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1149 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L1150 /* class-row */,
};

/* #"byte" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1151;

struct dylanZdylan_visceraZCLS_symbol SYM_byte_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1151, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_ubyte_HEAP /* symbol-next */,
};

/* #"ushort" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1152;

struct dylanZdylan_visceraZCLS_symbol SYM_ushort_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1152, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_byte_HEAP /* symbol-next */,
};

/* #"short" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1153;

struct dylanZdylan_visceraZCLS_symbol SYM_short_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1153, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_ushort_HEAP /* symbol-next */,
};

/* #"float" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1154;

struct dylanZdylan_visceraZCLS_symbol SYM_float_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1154, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_short_HEAP /* symbol-next */,
};

/* #"double" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1155;

struct dylanZdylan_visceraZCLS_symbol SYM_double_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1155, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_float_HEAP /* symbol-next */,
};

/* #"long-double" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1156;

struct dylanZdylan_visceraZCLS_symbol SYM_long_double_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1156, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_double_HEAP /* symbol-next */,
};

/* <format-string-condition> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE25 L1157;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1158;

extern struct dylanZdylan_visceraZCLS_pair L1159;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1160;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1161;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_format_string_condition_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1157 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1091 /* direct-superclasses */,
    (heapptr_t) &L1158 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1159 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L1160 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L1049 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L1161 /* class-row */,
};

/* <serious-condition> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L1162;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1163;

extern struct dylanZdylan_visceraZCLS_pair L1164;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1165;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_serious_condition_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1162 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1091 /* direct-superclasses */,
    (heapptr_t) &L1163 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1164 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    3 /* class-bucket */,
    (heapptr_t) &L1165 /* class-row */,
};

/* <warning> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1166;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1167;

extern struct dylanZdylan_visceraZCLS_pair L1168;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1169;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_warning_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1166 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1091 /* direct-superclasses */,
    (heapptr_t) &L1167 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1168 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1169 /* class-row */,
};

/* <restart> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1170;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1171;

extern struct dylanZdylan_visceraZCLS_pair L1172;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1173;

struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_restart_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1170 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1091 /* direct-superclasses */,
    (heapptr_t) &L1171 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1172 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1173 /* class-row */,
};

/* #"boolean-char" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1174;

struct dylanZdylan_visceraZCLS_symbol SYM_boolean_char_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1174, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_long_double_HEAP /* symbol-next */,
};

/* #"ptr" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE3 L1175;

struct dylanZdylan_visceraZCLS_symbol SYM_ptr_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1175, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_boolean_char_HEAP /* symbol-next */,
};

/* #"pointer" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L1176;

struct dylanZdylan_visceraZCLS_symbol SYM_pointer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1176, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_ptr_HEAP /* symbol-next */,
};

/* <statically-typed-pointer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE26 L1177;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1178;

extern struct dylanZdylan_visceraZCLS_pair L1179;

extern struct dylanZdylan_visceraZCLS_raw_function L1180;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1181;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1182;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1183;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1184;

struct dylanZdylan_visceraZCLS_class melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1177 /* class-name */,
    7000 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1178 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1179 /* direct-subclasses */,
    1 /* class-functional? */,
    1 /* class-primary? */,
    0 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1180 /* class-maker */,
    (heapptr_t) &L1181 /* class-new-slot-descriptors */,
    (heapptr_t) &L1182 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    10 /* class-bucket */,
    (heapptr_t) &L1184 /* class-row */,
};

/* content-size */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1185;

extern struct dylanZdylan_visceraZCLS_pair L1186;

struct dylanZdylan_visceraZCLS_generic_function melange_supportZmelange_supportZcontent_size_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1185 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L197 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L737 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1186 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"extra-bytes" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1187;

struct dylanZdylan_visceraZCLS_symbol SYM_extra_bytes_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1187, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_pointer_HEAP /* symbol-next */,
};

/* #"element-count" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1188;

struct dylanZdylan_visceraZCLS_symbol SYM_element_count_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1188, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_extra_bytes_HEAP /* symbol-next */,
};

/* <machine-pointer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L1189;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1190;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1191;

extern struct dylanZdylan_visceraZCLS_raw_function L1192;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1193;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1194;

struct dylanZdylan_visceraZCLS_class melange_supportZmelange_supportZCLS_machine_pointer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1189 /* class-name */,
    7002 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L1191 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1192 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1193 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1194 /* class-row */,
};

/* <void> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1195;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1196;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1197;

struct dylanZdylan_visceraZCLS_class melange_supportZmelange_supportZCLS_void_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1195 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1196 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1197 /* class-row */,
};

/* <c-string> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L1198;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1199;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L1200;

extern struct dylanZdylan_visceraZCLS_pair L1201;

extern struct dylanZdylan_visceraZCLS_raw_function L1202;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1203;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1204;

struct dylanZdylan_visceraZCLS_class melange_supportZmelange_supportZCLS_c_string_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1198 /* class-name */,
    7003 /* unique-id */,
    (heapptr_t) &L1199 /* direct-superclasses */,
    (heapptr_t) &L1200 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1201 /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1202 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1203 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1204 /* class-row */,
};

/* <sealed-c-string> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L1205;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1206;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L1207;

extern struct dylanZdylan_visceraZCLS_raw_function L1208;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1209;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1210;

struct dylanZdylan_visceraZCLS_class melange_supportZmelange_supportZCLS_sealed_c_string_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1205 /* class-name */,
    7004 /* unique-id */,
    (heapptr_t) &L1206 /* direct-superclasses */,
    (heapptr_t) &L1207 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1208 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1209 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1210 /* class-row */,
};

/* #"index" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1211;

struct dylanZdylan_visceraZCLS_symbol SYM_index_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1211, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_element_count_HEAP /* symbol-next */,
};

/* pointer-value */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1212;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1213;

extern struct dylanZdylan_visceraZCLS_pair L1214;

struct dylanZdylan_visceraZCLS_generic_function melange_supportZmelange_supportZpointer_value_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1212 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1190 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1213 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L1214 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* pointer-value-setter */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L1215;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1216;

extern struct dylanZdylan_visceraZCLS_pair L1217;

struct dylanZdylan_visceraZCLS_generic_function melange_supportZmelange_supportZpointer_value_setter_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1215 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1216 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1213 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L1217 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <c-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L1218;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1219;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L1220;

extern struct dylanZdylan_visceraZCLS_pair L1221;

extern struct dylanZdylan_visceraZCLS_raw_function L1222;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1223;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1224;

struct dylanZdylan_visceraZCLS_class melange_supportZmelange_supportZCLS_c_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1218 /* class-name */,
    7005 /* unique-id */,
    (heapptr_t) &L1219 /* direct-superclasses */,
    (heapptr_t) &L1220 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1221 /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1222 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1223 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1224 /* class-row */,
};

/* <function-pointer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L1225;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1226;

extern struct dylanZdylan_visceraZCLS_raw_function L1227;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1228;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1229;

struct dylanZdylan_visceraZCLS_class melange_supportZmelange_supportZCLS_function_pointer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1225 /* class-name */,
    7001 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L1226 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1227 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1228 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1229 /* class-row */,
};

/* <lock> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1230;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1231;

extern struct dylanZdylan_visceraZCLS_pair L1232;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1233;

struct dylanZdylan_visceraZCLS_class streamsZthreadsZCLS_lock_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1230 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1231 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1232 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1233 /* class-row */,
};

/* <semaphore> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1234;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1235;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1236;

extern struct dylanZdylan_visceraZCLS_raw_function L1237;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1238;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1239;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1240;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1241;

struct dylanZdylan_visceraZCLS_class streamsZthreadsZCLS_semaphore_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1234 /* class-name */,
    1610 /* unique-id */,
    (heapptr_t) &L1235 /* direct-superclasses */,
    (heapptr_t) &L1236 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1237 /* class-maker */,
    (heapptr_t) &L1238 /* class-new-slot-descriptors */,
    (heapptr_t) &L1239 /* class-slot-overrides */,
    (heapptr_t) &L1240 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1241 /* class-row */,
};

/* <multilock> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1242;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1243;

extern struct dylanZdylan_visceraZCLS_raw_function L1244;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1245;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1246;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1247;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1248;

struct dylanZdylan_visceraZCLS_class streamsZthreadsZCLS_multilock_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1242 /* class-name */,
    1611 /* unique-id */,
    (heapptr_t) &L1235 /* direct-superclasses */,
    (heapptr_t) &L1243 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1244 /* class-maker */,
    (heapptr_t) &L1245 /* class-new-slot-descriptors */,
    (heapptr_t) &L1246 /* class-slot-overrides */,
    (heapptr_t) &L1247 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1248 /* class-row */,
};

/* <syscall-error> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1249;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1250;

extern struct dylanZdylan_visceraZCLS_raw_function L1251;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1252;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1253;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1254;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1255;

struct dylanZdylan_visceraZCLS_class streamsZinternalsZCLS_syscall_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1249 /* class-name */,
    1619 /* unique-id */,
    (heapptr_t) &L661 /* direct-superclasses */,
    (heapptr_t) &L1250 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1251 /* class-maker */,
    (heapptr_t) &L1252 /* class-new-slot-descriptors */,
    (heapptr_t) &L1253 /* class-slot-overrides */,
    (heapptr_t) &L1254 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1255 /* class-row */,
};

/* #"errno" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1256;

struct dylanZdylan_visceraZCLS_symbol SYM_errno_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1256, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_index_HEAP /* symbol-next */,
};

/* <file-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1257;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1258;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1259;

extern struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_buffered_stream_HEAP;

extern struct dylanZdylan_visceraZCLS_pair L1260;

extern struct dylanZdylan_visceraZCLS_raw_function L1261;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1262;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1263;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1264;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_file_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1257 /* class-name */,
    1609 /* unique-id */,
    (heapptr_t) &L1258 /* direct-superclasses */,
    (heapptr_t) &L1259 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_buffered_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1260 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1261 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1262 /* class-slot-overrides */,
    (heapptr_t) &L1263 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1264 /* class-row */,
};

/* #"outer-stream" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1265;

struct dylanZdylan_visceraZCLS_symbol SYM_outer_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1265, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_errno_HEAP /* symbol-next */,
};

/* <stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L1266;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1267;

extern struct dylanZdylan_visceraZCLS_pair L1268;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1269;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1270;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1271;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1266 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1267 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1268 /* direct-subclasses */,
    0 /* class-functional? */,
    1 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L1269 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L1270 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L1271 /* class-row */,
};

/* <sequence-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L1272;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1273;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1274;

extern struct dylanZdylan_visceraZCLS_pair L1275;

extern struct dylanZdylan_visceraZCLS_raw_function L1276;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1277;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1278;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_sequence_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1272 /* class-name */,
    1601 /* unique-id */,
    (heapptr_t) &L1273 /* direct-superclasses */,
    (heapptr_t) &L1274 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1275 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1276 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1277 /* class-slot-overrides */,
    (heapptr_t) &L1270 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L1278 /* class-row */,
};

/* <string-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1279;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1280;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1281;

extern struct dylanZdylan_visceraZCLS_pair L1282;

extern struct dylanZdylan_visceraZCLS_raw_function L1283;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1284;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1285;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_string_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1279 /* class-name */,
    1605 /* unique-id */,
    (heapptr_t) &L1280 /* direct-superclasses */,
    (heapptr_t) &L1281 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1282 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1283 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1284 /* class-slot-overrides */,
    (heapptr_t) &L1270 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1285 /* class-row */,
};

/* <simple-sequence-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE24 L1286;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1287;

extern struct dylanZdylan_visceraZCLS_pair L1288;

extern struct dylanZdylan_visceraZCLS_raw_function L1289;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1290;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1291;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L1292;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1293;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_simple_sequence_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1286 /* class-name */,
    1602 /* unique-id */,
    (heapptr_t) &L1280 /* direct-superclasses */,
    (heapptr_t) &L1287 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1288 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1289 /* class-maker */,
    (heapptr_t) &L1290 /* class-new-slot-descriptors */,
    (heapptr_t) &L1291 /* class-slot-overrides */,
    (heapptr_t) &L1292 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1293 /* class-row */,
};

/* #"contents" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L1294;

struct dylanZdylan_visceraZCLS_symbol SYM_contents_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1294, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_outer_stream_HEAP /* symbol-next */,
};

/* #"input" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1295;

struct dylanZdylan_visceraZCLS_symbol SYM_input_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1295, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_contents_HEAP /* symbol-next */,
};

/* #"direction" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1296;

struct dylanZdylan_visceraZCLS_symbol SYM_direction_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1296, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_input_HEAP /* symbol-next */,
};

/* #"input-output" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1297;

struct dylanZdylan_visceraZCLS_symbol SYM_input_output_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1297, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_direction_HEAP /* symbol-next */,
};

/* #"output" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1298;

struct dylanZdylan_visceraZCLS_symbol SYM_output_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1298, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_input_output_HEAP /* symbol-next */,
};

/* <byte-string-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L1299;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1300;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L1301;

extern struct dylanZdylan_visceraZCLS_raw_function L1302;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1303;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1304;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_byte_string_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1299 /* class-name */,
    1604 /* unique-id */,
    (heapptr_t) &L1300 /* direct-superclasses */,
    (heapptr_t) &L1301 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1302 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1303 /* class-slot-overrides */,
    (heapptr_t) &L1292 /* class-all-slot-descriptors */,
    5 /* class-bucket */,
    (heapptr_t) &L1304 /* class-row */,
};

/* <unicode-string-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L1305;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L1306;

extern struct dylanZdylan_visceraZCLS_raw_function L1307;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1308;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1309;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_unicode_string_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1305 /* class-name */,
    1603 /* unique-id */,
    (heapptr_t) &L1300 /* direct-superclasses */,
    (heapptr_t) &L1306 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1307 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1308 /* class-slot-overrides */,
    (heapptr_t) &L1292 /* class-all-slot-descriptors */,
    5 /* class-bucket */,
    (heapptr_t) &L1309 /* class-row */,
};

/* <fd-file-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L1310;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1311;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L1312;

extern struct dylanZdylan_visceraZCLS_raw_function L1313;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1314;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1315;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L1316;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1317;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_fd_file_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1310 /* class-name */,
    1608 /* unique-id */,
    (heapptr_t) &L1311 /* direct-superclasses */,
    (heapptr_t) &L1312 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_buffered_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1313 /* class-maker */,
    (heapptr_t) &L1314 /* class-new-slot-descriptors */,
    (heapptr_t) &L1315 /* class-slot-overrides */,
    (heapptr_t) &L1316 /* class-all-slot-descriptors */,
    5 /* class-bucket */,
    (heapptr_t) &L1317 /* class-row */,
};

/* type-for-sequence-stream */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE24 L1318;

extern struct dylanZdylan_visceraZCLS_pair L1319;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZtype_for_sequence_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1318 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L377 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L91 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1319 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* type-for-file-stream */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L1320;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1321;

extern struct dylanZdylan_visceraZCLS_pair L1322;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZtype_for_file_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1320 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1321 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L91 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1322 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"locator" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L1323;

struct dylanZdylan_visceraZCLS_symbol SYM_locator_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1323, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_output_HEAP /* symbol-next */,
};

/* #"element-type" */
struct dylanZdylan_visceraZCLS_symbol SYM_element_type_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L308, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_locator_HEAP /* symbol-next */,
};

/* #"encoding" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L1324;

struct dylanZdylan_visceraZCLS_symbol SYM_encoding_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1324, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_element_type_HEAP /* symbol-next */,
};

/* outer-stream-setter */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L1325;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1326;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1327;

extern struct dylanZdylan_visceraZCLS_pair L1328;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZouter_stream_setter_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1325 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1326 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L1327 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1328 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <stream-position> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L1329;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1330;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1331;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_stream_position_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1329 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1330 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1331 /* class-row */,
};

/* #"clear-contents?" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1332;

struct dylanZdylan_visceraZCLS_symbol SYM_clear_contentsQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1332, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_encoding_HEAP /* symbol-next */,
};

/* <end-of-stream-error> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L1333;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1334;

extern struct dylanZdylan_visceraZCLS_pair L1335;

extern struct dylanZdylan_visceraZCLS_raw_function L1336;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1337;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1338;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1339;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1340;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_end_of_stream_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1333 /* class-name */,
    1617 /* unique-id */,
    (heapptr_t) &L661 /* direct-superclasses */,
    (heapptr_t) &L1334 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1335 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1336 /* class-maker */,
    (heapptr_t) &L1337 /* class-new-slot-descriptors */,
    (heapptr_t) &L1338 /* class-slot-overrides */,
    (heapptr_t) &L1339 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1340 /* class-row */,
};

/* #"stream" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1341;

struct dylanZdylan_visceraZCLS_symbol SYM_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1341, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_clear_contentsQUERY_HEAP /* symbol-next */,
};

/* <incomplete-read-error> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L1342;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1343;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L1344;

extern struct dylanZdylan_visceraZCLS_raw_function L1345;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1346;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1347;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1348;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1349;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_incomplete_read_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1342 /* class-name */,
    1618 /* unique-id */,
    (heapptr_t) &L1343 /* direct-superclasses */,
    (heapptr_t) &L1344 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1345 /* class-maker */,
    (heapptr_t) &L1346 /* class-new-slot-descriptors */,
    (heapptr_t) &L1347 /* class-slot-overrides */,
    (heapptr_t) &L1348 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L1349 /* class-row */,
};

/* #"sequence" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L1350;

struct dylanZdylan_visceraZCLS_symbol SYM_sequence_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1350, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_stream_HEAP /* symbol-next */,
};

/* <file-error> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1351;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1352;

extern struct dylanZdylan_visceraZCLS_pair L1353;

extern struct dylanZdylan_visceraZCLS_raw_function L1354;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1355;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1356;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1357;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1358;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_file_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1351 /* class-name */,
    1613 /* unique-id */,
    (heapptr_t) &L661 /* direct-superclasses */,
    (heapptr_t) &L1352 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1353 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1354 /* class-maker */,
    (heapptr_t) &L1355 /* class-new-slot-descriptors */,
    (heapptr_t) &L1356 /* class-slot-overrides */,
    (heapptr_t) &L1357 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1358 /* class-row */,
};

/* <file-exists-error> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L1359;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1360;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L1361;

extern struct dylanZdylan_visceraZCLS_raw_function L1362;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1363;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1364;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_file_exists_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1359 /* class-name */,
    1616 /* unique-id */,
    (heapptr_t) &L1360 /* direct-superclasses */,
    (heapptr_t) &L1361 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1362 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1363 /* class-slot-overrides */,
    (heapptr_t) &L1357 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L1364 /* class-row */,
};

/* <file-does-not-exist-error> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE27 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[27];	 /* %element */
} L1365;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L1366;

extern struct dylanZdylan_visceraZCLS_raw_function L1367;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1368;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1369;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_file_does_not_exist_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1365 /* class-name */,
    1615 /* unique-id */,
    (heapptr_t) &L1360 /* direct-superclasses */,
    (heapptr_t) &L1366 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1367 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1368 /* class-slot-overrides */,
    (heapptr_t) &L1357 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L1369 /* class-row */,
};

/* <invalid-file-permissions-error> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE32 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[32];	 /* %element */
} L1370;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L1371;

extern struct dylanZdylan_visceraZCLS_raw_function L1372;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1373;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1374;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_invalid_file_permissions_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1370 /* class-name */,
    1614 /* unique-id */,
    (heapptr_t) &L1360 /* direct-superclasses */,
    (heapptr_t) &L1371 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1372 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1373 /* class-slot-overrides */,
    (heapptr_t) &L1357 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L1374 /* class-row */,
};

/* size-setter */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1375;

extern struct dylanZdylan_visceraZCLS_pair L1376;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZsize_setter_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1375 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L11 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1376 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <buffered-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L1377;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1378;

extern struct dylanZdylan_visceraZCLS_pair L1379;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1380;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1381;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_buffered_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1377 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1327 /* direct-superclasses */,
    (heapptr_t) &L1378 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_buffered_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1379 /* direct-subclasses */,
    0 /* class-functional? */,
    1 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L1380 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L1263 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L1381 /* class-row */,
};

/* #"bytes" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1382;

struct dylanZdylan_visceraZCLS_symbol SYM_bytes_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1382, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_sequence_HEAP /* symbol-next */,
};

/* do-get-output-buffer */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L1383;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1384;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1385;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1386;

extern struct dylanZdylan_visceraZCLS_pair L1387;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZdo_get_output_buffer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1383 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1384 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1385 /* function-keywords */,
    (heapptr_t) &L1386 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1387 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* do-force-output-buffers */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L1388;

extern struct dylanZdylan_visceraZCLS_pair L1389;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZdo_force_output_buffers_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1388 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1384 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L1389 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* do-release-output-buffer */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE24 L1390;

extern struct dylanZdylan_visceraZCLS_pair L1391;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZdo_release_output_buffer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1390 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1384 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L1391 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"wait?" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1392;

struct dylanZdylan_visceraZCLS_symbol SYM_waitQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1392, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_bytes_HEAP /* symbol-next */,
};

/* do-get-input-buffer */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L1393;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1394;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1395;

extern struct dylanZdylan_visceraZCLS_pair L1396;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZdo_get_input_buffer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1393 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1384 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1394 /* function-keywords */,
    (heapptr_t) &L1395 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1396 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* stream-element-type */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L1397;

extern struct dylanZdylan_visceraZCLS_pair L1398;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZstream_element_type_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1397 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L91 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1398 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* do-release-input-buffer */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L1399;

extern struct dylanZdylan_visceraZCLS_pair L1400;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZdo_release_input_buffer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1399 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1384 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L1400 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"on-end-of-stream" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L1401;

struct dylanZdylan_visceraZCLS_symbol SYM_on_end_of_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1401, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_waitQUERY_HEAP /* symbol-next */,
};

/* stream-position */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1402;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1403;

extern struct dylanZdylan_visceraZCLS_pair L1404;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZstream_position_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1402 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1273 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L1403 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1404 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* stream-position-setter */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE22 L1405;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1406;

extern struct dylanZdylan_visceraZCLS_pair L1407;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZstream_position_setter_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1405 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1406 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L1403 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1407 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* do-next-input-buffer */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L1408;

extern struct dylanZdylan_visceraZCLS_pair L1409;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZdo_next_input_buffer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1408 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1384 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1394 /* function-keywords */,
    (heapptr_t) &L1395 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1409 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* do-input-available-at-source? */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE29 L1410;

extern struct dylanZdylan_visceraZCLS_pair L1411;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZdo_input_available_at_sourceQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1410 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1384 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L83 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1411 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* read */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1412;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1413;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1414;

extern struct dylanZdylan_visceraZCLS_pair L1415;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZread_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1412 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1413 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1414 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1415 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* read-element */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1416;

extern struct dylanZdylan_visceraZCLS_pair L1417;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZread_element_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1416 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1414 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1417 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"eos" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE3 L1418;

struct dylanZdylan_visceraZCLS_symbol SYM_eos_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1418, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_on_end_of_stream_HEAP /* symbol-next */,
};

/* do-next-output-buffer */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L1419;

extern struct dylanZdylan_visceraZCLS_pair L1420;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZdo_next_output_buffer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1419 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1384 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1385 /* function-keywords */,
    (heapptr_t) &L1386 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1420 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* read-line */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1421;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1422;

extern struct dylanZdylan_visceraZCLS_pair L1423;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZread_line_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1421 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1414 /* function-keywords */,
    (heapptr_t) &L1422 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1423 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"size-limit" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L1424;

struct dylanZdylan_visceraZCLS_symbol SYM_size_limit_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1424, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_eos_HEAP /* symbol-next */,
};

/* replace-subsequence! */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L1425;

extern struct dylanZdylan_visceraZCLS_pair L1426;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZreplace_subsequenceD_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1425 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L700 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L726 /* function-keywords */,
    (heapptr_t) &L377 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1426 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"grow?" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1427;

struct dylanZdylan_visceraZCLS_symbol SYM_growQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1427, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_size_limit_HEAP /* symbol-next */,
};

/* write-element */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1428;

extern struct dylanZdylan_visceraZCLS_pair L1429;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZwrite_element_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1428 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1267 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1429 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* do-synchronize */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1430;

extern struct dylanZdylan_visceraZCLS_pair L1431;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZdo_synchronize_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1430 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1384 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L1431 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* {<slot-descriptor> for inner-stream introduced by <wrapper-stream>} */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1432;

extern struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZinner_stream_HEAP;

extern struct dylanZdylan_visceraZCLS_symbol SYM_inner_stream_HEAP;

extern struct dylanZdylan_visceraZCLS_pair L1433;

struct dylanZdylan_visceraZCLS_slot_descriptor streamsZstreamsZCLS_wrapper_streamZstreamsZstreamsZinner_stream_SLOT_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptor_HEAP /* %object-class */,
    (heapptr_t) &L1432 /* slot-name */,
    (heapptr_t) &SYM_instance_HEAP /* slot-allocation */,
    (heapptr_t) &streamsZstreamsZCLS_stream_HEAP /* slot-type */,
    (heapptr_t) &streamsZstreamsZinner_stream_HEAP /* slot-getter */,
    (heapptr_t) &dylan_L1 /* slot-init-function */,
    { (heapptr_t) &dylanZliteral_ROOT, { 0 } } /* slot-init-value */,
    (heapptr_t) &SYM_inner_stream_HEAP /* slot-init-keyword */,
    0 /* slot-init-keyword-required? */,
    { 0, 0, 0, }, /* hole */
    (heapptr_t) &L1433 /* slot-positions */,
    { (heapptr_t) &dylan_L1, { 0 } } /* slot-positions-cache */,
    (heapptr_t) &SYM_heap_HEAP /* slot-representation */,
    (heapptr_t) &dylan_L1 /* slot-initialized?-slot */,
};

/* <wrapper-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L1434;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1435;

extern struct dylanZdylan_visceraZCLS_raw_function L1436;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1437;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1438;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1439;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1440;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_wrapper_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1434 /* class-name */,
    1600 /* unique-id */,
    (heapptr_t) &L1327 /* direct-superclasses */,
    (heapptr_t) &L1435 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1436 /* class-maker */,
    (heapptr_t) &L1437 /* class-new-slot-descriptors */,
    (heapptr_t) &L1438 /* class-slot-overrides */,
    (heapptr_t) &L1439 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1440 /* class-row */,
};

/* #"inner-stream" */
struct dylanZdylan_visceraZCLS_symbol SYM_inner_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1432, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_growQUERY_HEAP /* symbol-next */,
};

/* inner-stream */
extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1441;

extern struct dylanZdylan_visceraZCLS_pair L1442;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZinner_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1432 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1441 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L1327 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1442 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* close */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1443;

extern struct dylanZdylan_visceraZCLS_pair L1444;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZclose_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1443 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* function-rest-value */,
    (heapptr_t) &L1444 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* stream-open? */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1445;

extern struct dylanZdylan_visceraZCLS_pair L1446;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZstream_openQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1445 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L83 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1446 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* stream-at-end? */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1447;

extern struct dylanZdylan_visceraZCLS_pair L1448;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZstream_at_endQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1447 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L83 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1448 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* peek */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1449;

extern struct dylanZdylan_visceraZCLS_pair L1450;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZpeek_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1449 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1414 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1450 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* read-into! */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L1451;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1452;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1453;

extern struct dylanZdylan_visceraZCLS_pair L1454;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZread_intoD_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1451 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1452 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1453 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1454 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* discard-input */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1455;

extern struct dylanZdylan_visceraZCLS_pair L1456;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZdiscard_input_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1455 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1456 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* stream-input-available? */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L1457;

extern struct dylanZdylan_visceraZCLS_pair L1458;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZstream_input_availableQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1457 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L83 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1458 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* write */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1459;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1460;

extern struct dylanZdylan_visceraZCLS_pair L1461;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZwrite_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1459 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1460 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L726 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1461 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* force-output */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1462;

extern struct dylanZdylan_visceraZCLS_pair L1463;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZforce_output_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1462 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1463 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* synchronize-output */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L1464;

extern struct dylanZdylan_visceraZCLS_pair L1465;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZsynchronize_output_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1464 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1465 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* discard-output */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1466;

extern struct dylanZdylan_visceraZCLS_pair L1467;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZdiscard_output_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1466 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1467 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* read-line-into! */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1468;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1469;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1470;

extern struct dylanZdylan_visceraZCLS_pair L1471;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZread_line_intoD_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1468 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1469 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1470 /* function-keywords */,
    (heapptr_t) &L1422 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1471 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* write-line */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L1472;

extern struct dylanZdylan_visceraZCLS_pair L1473;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZwrite_line_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1472 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1469 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L726 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1473 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* new-line */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L1474;

extern struct dylanZdylan_visceraZCLS_pair L1475;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZnew_line_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1474 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1475 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <fd-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1476;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1477;

extern struct dylanZdylan_visceraZCLS_pair L1478;

extern struct dylanZdylan_visceraZCLS_raw_function L1479;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1480;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1481;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L1482;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1483;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_fd_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1476 /* class-name */,
    1607 /* unique-id */,
    (heapptr_t) &L1384 /* direct-superclasses */,
    (heapptr_t) &L1477 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_buffered_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1478 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1479 /* class-maker */,
    (heapptr_t) &L1480 /* class-new-slot-descriptors */,
    (heapptr_t) &L1481 /* class-slot-overrides */,
    (heapptr_t) &L1482 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1483 /* class-row */,
};

/* #"fd" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE2 L1484;

struct dylanZdylan_visceraZCLS_symbol SYM_fd_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1484, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_inner_stream_HEAP /* symbol-next */,
};

/* #"replace" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L1485;

struct dylanZdylan_visceraZCLS_symbol SYM_replace_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1485, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_fd_HEAP /* symbol-next */,
};

/* #"signal" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1486;

struct dylanZdylan_visceraZCLS_symbol SYM_signal_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1486, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_replace_HEAP /* symbol-next */,
};

/* #"create" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1487;

struct dylanZdylan_visceraZCLS_symbol SYM_create_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1487, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_signal_HEAP /* symbol-next */,
};

/* #"truncate" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L1488;

struct dylanZdylan_visceraZCLS_symbol SYM_truncate_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1488, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_create_HEAP /* symbol-next */,
};

/* #"append" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1489;

struct dylanZdylan_visceraZCLS_symbol SYM_append_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1489, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_truncate_HEAP /* symbol-next */,
};

/* #"new-version" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1490;

struct dylanZdylan_visceraZCLS_symbol SYM_new_version_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1490, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_append_HEAP /* symbol-next */,
};

/* #"if-exists" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1491;

struct dylanZdylan_visceraZCLS_symbol SYM_if_exists_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1491, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_new_version_HEAP /* symbol-next */,
};

/* #"overwrite" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1492;

struct dylanZdylan_visceraZCLS_symbol SYM_overwrite_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1492, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_if_exists_HEAP /* symbol-next */,
};

/* #"if-does-not-exist" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L1493;

struct dylanZdylan_visceraZCLS_symbol SYM_if_does_not_exist_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1493, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_overwrite_HEAP /* symbol-next */,
};

/* #"ANSI" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1494;

struct dylanZdylan_visceraZCLS_symbol SYM_ansi_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1494, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_if_does_not_exist_HEAP /* symbol-next */,
};

/* #"big-endian" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L1495;

struct dylanZdylan_visceraZCLS_symbol SYM_big_endian_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1495, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_ansi_HEAP /* symbol-next */,
};

/* #"buffer-size" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1496;

struct dylanZdylan_visceraZCLS_symbol SYM_buffer_size_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1496, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_big_endian_HEAP /* symbol-next */,
};

/* <buffered-byte-string-output-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE36 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[36];	 /* %element */
} L1497;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1498;

extern struct dylanZdylan_visceraZCLS_raw_function L1499;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1500;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1501;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L1502;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1503;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_buffered_byte_string_output_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1497 /* class-name */,
    1606 /* unique-id */,
    (heapptr_t) &L1258 /* direct-superclasses */,
    (heapptr_t) &L1498 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_buffered_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1499 /* class-maker */,
    (heapptr_t) &L1500 /* class-new-slot-descriptors */,
    (heapptr_t) &L1501 /* class-slot-overrides */,
    (heapptr_t) &L1502 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1503 /* class-row */,
};

/* <int-ptr> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1504;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1505;

extern struct dylanZdylan_visceraZCLS_raw_function L1506;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1507;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1508;

struct dylanZdylan_visceraZCLS_class streamsZpiped_execZCLS_int_ptr_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1504 /* class-name */,
    1612 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L1505 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1506 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1507 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1508 /* class-row */,
};

/* export-value */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1509;

extern struct dylanZdylan_visceraZCLS_pair L1510;

struct dylanZdylan_visceraZCLS_generic_function melange_supportZmelange_supportZexport_value_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1509 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L102 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1510 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* outer-stream */
extern struct dylanZdylan_visceraZCLS_pair L1511;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZouter_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1265 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L1327 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1511 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <positionable-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L1512;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1513;

extern struct dylanZdylan_visceraZCLS_pair L1514;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1515;

struct dylanZdylan_visceraZCLS_class streamsZstreamsZCLS_positionable_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1512 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1327 /* direct-superclasses */,
    (heapptr_t) &L1513 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1514 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L1270 /* class-all-slot-descriptors */,
    3 /* class-bucket */,
    (heapptr_t) &L1515 /* class-row */,
};

/* <pretty-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1516;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1517;

extern struct dylanZdylan_visceraZCLS_raw_function L1518;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE14 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[14];	 /* %element */
} L1519;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1520;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE18 L1521;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1522;

struct dylanZdylan_visceraZCLS_class printZpprintZCLS_pretty_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1516 /* class-name */,
    559 /* unique-id */,
    (heapptr_t) &L1384 /* direct-superclasses */,
    (heapptr_t) &L1517 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_buffered_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1518 /* class-maker */,
    (heapptr_t) &L1519 /* class-new-slot-descriptors */,
    (heapptr_t) &L1520 /* class-slot-overrides */,
    (heapptr_t) &L1521 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1522 /* class-row */,
};

/* #"target" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1523;

struct dylanZdylan_visceraZCLS_symbol SYM_target_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1523, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_buffer_size_HEAP /* symbol-next */,
};

/* #"line-length" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1524;

struct dylanZdylan_visceraZCLS_symbol SYM_line_length_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1524, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_target_HEAP /* symbol-next */,
};

/* #"column" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1525;

struct dylanZdylan_visceraZCLS_symbol SYM_column_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1525, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_line_length_HEAP /* symbol-next */,
};

/* <queued-op> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1526;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1527;

extern struct dylanZdylan_visceraZCLS_pair L1528;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1529;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1530;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1531;

struct dylanZdylan_visceraZCLS_class printZpprintZCLS_queued_op_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1526 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1527 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1528 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L1529 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L1530 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1531 /* class-row */,
};

/* #"literal" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L1532;

struct dylanZdylan_visceraZCLS_symbol SYM_literal_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1532, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_column_HEAP /* symbol-next */,
};

/* <logical-block> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1533;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1534;

extern struct dylanZdylan_visceraZCLS_raw_function L1535;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L1536;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1537;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L1538;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1539;

struct dylanZdylan_visceraZCLS_class printZpprintZCLS_logical_block_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1533 /* class-name */,
    556 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1534 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1535 /* class-maker */,
    (heapptr_t) &L1536 /* class-new-slot-descriptors */,
    (heapptr_t) &L1537 /* class-slot-overrides */,
    (heapptr_t) &L1538 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1539 /* class-row */,
};

/* #"section-start-line" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L1540;

struct dylanZdylan_visceraZCLS_symbol SYM_section_start_line_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1540, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_literal_HEAP /* symbol-next */,
};

/* #"suffix-length" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1541;

struct dylanZdylan_visceraZCLS_symbol SYM_suffix_length_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1541, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_section_start_line_HEAP /* symbol-next */,
};

/* #"prefix-length" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1542;

struct dylanZdylan_visceraZCLS_symbol SYM_prefix_length_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1542, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_suffix_length_HEAP /* symbol-next */,
};

/* #"per-line-prefix-end" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L1543;

struct dylanZdylan_visceraZCLS_symbol SYM_per_line_prefix_end_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1543, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_prefix_length_HEAP /* symbol-next */,
};

/* #"section-column" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1544;

struct dylanZdylan_visceraZCLS_symbol SYM_section_column_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1544, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_per_line_prefix_end_HEAP /* symbol-next */,
};

/* #"start-column" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1545;

struct dylanZdylan_visceraZCLS_symbol SYM_start_column_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1545, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_section_column_HEAP /* symbol-next */,
};

/* push-last */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1546;

extern struct dylanZdylan_visceraZCLS_pair L1547;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZpush_last_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1546 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L855 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1547 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <section-start> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1548;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1549;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1550;

extern struct dylanZdylan_visceraZCLS_pair L1551;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1552;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1553;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1554;

struct dylanZdylan_visceraZCLS_class printZpprintZCLS_section_start_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1548 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1549 /* direct-superclasses */,
    (heapptr_t) &L1550 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1551 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L1552 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L1553 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1554 /* class-row */,
};

/* <newline> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1555;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1556;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1557;

extern struct dylanZdylan_visceraZCLS_raw_function L1558;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1559;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1560;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1561;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1562;

struct dylanZdylan_visceraZCLS_class printZpprintZCLS_newline_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1555 /* class-name */,
    555 /* unique-id */,
    (heapptr_t) &L1556 /* direct-superclasses */,
    (heapptr_t) &L1557 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1558 /* class-maker */,
    (heapptr_t) &L1559 /* class-new-slot-descriptors */,
    (heapptr_t) &L1560 /* class-slot-overrides */,
    (heapptr_t) &L1561 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L1562 /* class-row */,
};

/* #"kind" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1563;

struct dylanZdylan_visceraZCLS_symbol SYM_kind_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1563, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_start_column_HEAP /* symbol-next */,
};

/* #"depth" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1564;

struct dylanZdylan_visceraZCLS_symbol SYM_depth_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1564, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_kind_HEAP /* symbol-next */,
};

/* #"miser" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1565;

struct dylanZdylan_visceraZCLS_symbol SYM_miser_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1565, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_depth_HEAP /* symbol-next */,
};

/* #"mandatory" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1566;

struct dylanZdylan_visceraZCLS_symbol SYM_mandatory_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1566, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_miser_HEAP /* symbol-next */,
};

/* #"linear" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1567;

struct dylanZdylan_visceraZCLS_symbol SYM_linear_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1567, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_mandatory_HEAP /* symbol-next */,
};

/* <block-start> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1568;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1569;

extern struct dylanZdylan_visceraZCLS_raw_function L1570;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1571;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1572;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L1573;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1574;

struct dylanZdylan_visceraZCLS_class printZpprintZCLS_block_start_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1568 /* class-name */,
    554 /* unique-id */,
    (heapptr_t) &L1556 /* direct-superclasses */,
    (heapptr_t) &L1569 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1570 /* class-maker */,
    (heapptr_t) &L1571 /* class-new-slot-descriptors */,
    (heapptr_t) &L1572 /* class-slot-overrides */,
    (heapptr_t) &L1573 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L1574 /* class-row */,
};

/* <block-end> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1575;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1576;

extern struct dylanZdylan_visceraZCLS_raw_function L1577;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1578;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1579;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1580;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1581;

struct dylanZdylan_visceraZCLS_class printZpprintZCLS_block_end_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1575 /* class-name */,
    553 /* unique-id */,
    (heapptr_t) &L1549 /* direct-superclasses */,
    (heapptr_t) &L1576 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1577 /* class-maker */,
    (heapptr_t) &L1578 /* class-new-slot-descriptors */,
    (heapptr_t) &L1579 /* class-slot-overrides */,
    (heapptr_t) &L1580 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1581 /* class-row */,
};

/* <indentation> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1582;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1583;

extern struct dylanZdylan_visceraZCLS_raw_function L1584;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1585;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1586;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1587;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1588;

struct dylanZdylan_visceraZCLS_class printZpprintZCLS_indentation_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1582 /* class-name */,
    552 /* unique-id */,
    (heapptr_t) &L1549 /* direct-superclasses */,
    (heapptr_t) &L1583 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1584 /* class-maker */,
    (heapptr_t) &L1585 /* class-new-slot-descriptors */,
    (heapptr_t) &L1586 /* class-slot-overrides */,
    (heapptr_t) &L1587 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1588 /* class-row */,
};

/* #"amount" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1589;

struct dylanZdylan_visceraZCLS_symbol SYM_amount_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1589, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_linear_HEAP /* symbol-next */,
};

/* #"block" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1590;

struct dylanZdylan_visceraZCLS_symbol SYM_block_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1590, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_amount_HEAP /* symbol-next */,
};

/* #"suffix" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1591;

struct dylanZdylan_visceraZCLS_symbol SYM_suffix_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1591, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_block_HEAP /* symbol-next */,
};

/* #"prefix" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1592;

struct dylanZdylan_visceraZCLS_symbol SYM_prefix_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1592, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_suffix_HEAP /* symbol-next */,
};

/* <tab> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1593;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1594;

extern struct dylanZdylan_visceraZCLS_raw_function L1595;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1596;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1597;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L1598;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1599;

struct dylanZdylan_visceraZCLS_class printZpprintZCLS_tab_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1593 /* class-name */,
    551 /* unique-id */,
    (heapptr_t) &L1549 /* direct-superclasses */,
    (heapptr_t) &L1594 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1595 /* class-maker */,
    (heapptr_t) &L1596 /* class-new-slot-descriptors */,
    (heapptr_t) &L1597 /* class-slot-overrides */,
    (heapptr_t) &L1598 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1599 /* class-row */,
};

/* #"colinc" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1600;

struct dylanZdylan_visceraZCLS_symbol SYM_colinc_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1600, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_prefix_HEAP /* symbol-next */,
};

/* #"colnum" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1601;

struct dylanZdylan_visceraZCLS_symbol SYM_colnum_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1601, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_colinc_HEAP /* symbol-next */,
};

/* #"relative?" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1602;

struct dylanZdylan_visceraZCLS_symbol SYM_relativeQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1602, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_colnum_HEAP /* symbol-next */,
};

/* #"section?" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L1603;

struct dylanZdylan_visceraZCLS_symbol SYM_sectionQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1603, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_relativeQUERY_HEAP /* symbol-next */,
};

/* #"line" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1604;

struct dylanZdylan_visceraZCLS_symbol SYM_line_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1604, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_sectionQUERY_HEAP /* symbol-next */,
};

/* #"line-relative" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1605;

struct dylanZdylan_visceraZCLS_symbol SYM_line_relative_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1605, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_line_HEAP /* symbol-next */,
};

/* #"section" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L1606;

struct dylanZdylan_visceraZCLS_symbol SYM_section_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1606, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_line_relative_HEAP /* symbol-next */,
};

/* pop */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE3 L1607;

extern struct dylanZdylan_visceraZCLS_pair L1608;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZpop_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1607 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L840 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1608 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"dont-know" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1609;

struct dylanZdylan_visceraZCLS_symbol SYM_dont_know_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1609, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_section_HEAP /* symbol-next */,
};

/* #"per-line-prefix" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1610;

struct dylanZdylan_visceraZCLS_symbol SYM_per_line_prefix_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1610, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_dont_know_HEAP /* symbol-next */,
};

/* #"body" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1611;

struct dylanZdylan_visceraZCLS_symbol SYM_body_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1611, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_per_line_prefix_HEAP /* symbol-next */,
};

/* <print-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1612;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1613;

extern struct dylanZdylan_visceraZCLS_pair L1614;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L1615;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE12 L1616;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1617;

struct dylanZdylan_visceraZCLS_class printZprintZCLS_print_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1612 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1327 /* direct-superclasses */,
    (heapptr_t) &L1613 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1614 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L1615 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L1616 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1617 /* class-row */,
};

/* <buffered-print-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L1618;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1619;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1620;

extern struct dylanZdylan_visceraZCLS_raw_function L1621;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1622;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1623;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1624;

struct dylanZdylan_visceraZCLS_class printZprintZCLS_buffered_print_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1618 /* class-name */,
    558 /* unique-id */,
    (heapptr_t) &L1619 /* direct-superclasses */,
    (heapptr_t) &L1620 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_buffered_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1621 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1622 /* class-slot-overrides */,
    (heapptr_t) &L1623 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1624 /* class-row */,
};

/* #"level" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1625;

struct dylanZdylan_visceraZCLS_symbol SYM_level_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1625, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_body_HEAP /* symbol-next */,
};

/* #"length" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1626;

struct dylanZdylan_visceraZCLS_symbol SYM_length_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1626, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_level_HEAP /* symbol-next */,
};

/* #"pretty?" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L1627;

struct dylanZdylan_visceraZCLS_symbol SYM_prettyQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1627, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_length_HEAP /* symbol-next */,
};

/* #"circle?" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L1628;

struct dylanZdylan_visceraZCLS_symbol SYM_circleQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1628, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_prettyQUERY_HEAP /* symbol-next */,
};

/* <unbuffered-print-stream> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE25 L1629;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1630;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1631;

extern struct dylanZdylan_visceraZCLS_raw_function L1632;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1633;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1634;

struct dylanZdylan_visceraZCLS_class printZprintZCLS_unbuffered_print_stream_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1629 /* class-name */,
    557 /* unique-id */,
    (heapptr_t) &L1630 /* direct-superclasses */,
    (heapptr_t) &L1631 /* all-superclasses */,
    (heapptr_t) &streamsZstreamsZCLS_stream_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1632 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1633 /* class-slot-overrides */,
    (heapptr_t) &L1616 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1634 /* class-row */,
};

/* <print-reference> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L1635;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1636;

extern struct dylanZdylan_visceraZCLS_raw_function L1637;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1638;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1639;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1640;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1641;

struct dylanZdylan_visceraZCLS_class printZprintZCLS_print_reference_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1635 /* class-name */,
    550 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1636 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1637 /* class-maker */,
    (heapptr_t) &L1638 /* class-new-slot-descriptors */,
    (heapptr_t) &L1639 /* class-slot-overrides */,
    (heapptr_t) &L1640 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1641 /* class-row */,
};

/* #"radix" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1642;

struct dylanZdylan_visceraZCLS_symbol SYM_radix_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1642, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_circleQUERY_HEAP /* symbol-next */,
};

/* print-object */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1643;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1644;

extern struct dylanZdylan_visceraZCLS_pair L1645;

struct dylanZdylan_visceraZCLS_generic_function printZprintZprint_object_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1643 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1644 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1645 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* pprint-logical-block */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L1646;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1647;

extern struct dylanZdylan_visceraZCLS_pair L1648;

struct dylanZdylan_visceraZCLS_generic_function printZpprintZpprint_logical_block_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1646 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1647 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1648 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* pprint-indent */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1649;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1650;

extern struct dylanZdylan_visceraZCLS_pair L1651;

struct dylanZdylan_visceraZCLS_generic_function printZpprintZpprint_indent_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1649 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1650 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1651 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* pprint-newline */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1652;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1653;

extern struct dylanZdylan_visceraZCLS_pair L1654;

struct dylanZdylan_visceraZCLS_generic_function printZpprintZpprint_newline_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1652 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1653 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1654 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"lowest-array-level" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L1655;

struct dylanZdylan_visceraZCLS_symbol SYM_lowest_array_level_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1655, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_radix_HEAP /* symbol-next */,
};

/* ^ */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE1 L1656;

extern struct dylanZdylan_visceraZCLS_pair L1657;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZRAISE_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1656 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L11 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1657 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* stream-contents */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1658;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1659;

extern struct dylanZdylan_visceraZCLS_pair L1660;

struct dylanZdylan_visceraZCLS_generic_function streamsZstreamsZstream_contents_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1658 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1273 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1659 /* function-keywords */,
    (heapptr_t) &L377 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1660 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* pprint-tab */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L1661;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1662;

extern struct dylanZdylan_visceraZCLS_pair L1663;

struct dylanZdylan_visceraZCLS_generic_function printZpprintZpprint_tab_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1661 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1662 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1663 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"section-relative" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L1664;

struct dylanZdylan_visceraZCLS_symbol SYM_section_relative_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1664, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_lowest_array_level_HEAP /* symbol-next */,
};

/* #"uint" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1665;

struct dylanZdylan_visceraZCLS_symbol SYM_uint_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1665, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_section_relative_HEAP /* symbol-next */,
};

/* #"digit" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1666;

struct dylanZdylan_visceraZCLS_symbol SYM_digit_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1666, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_uint_HEAP /* symbol-next */,
};

/* print-message */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1667;

extern struct dylanZdylan_visceraZCLS_pair L1668;

struct dylanZdylan_visceraZCLS_generic_function formatZformatZprint_message_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1667 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1644 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1668 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <buffer-desc> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1669;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1670;

extern struct dylanZdylan_visceraZCLS_raw_function L1671;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1672;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1673;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1674;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1675;

struct dylanZdylan_visceraZCLS_class formatZformatZCLS_buffer_desc_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1669 /* class-name */,
    1900 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1670 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1671 /* class-maker */,
    (heapptr_t) &L1672 /* class-new-slot-descriptors */,
    (heapptr_t) &L1673 /* class-slot-overrides */,
    (heapptr_t) &L1674 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1675 /* class-row */,
};

/* #"limit" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1676;

struct dylanZdylan_visceraZCLS_symbol SYM_limit_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1676, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_digit_HEAP /* symbol-next */,
};

/* #"buffer" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1677;

struct dylanZdylan_visceraZCLS_symbol SYM_buffer_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1677, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_limit_HEAP /* symbol-next */,
};

/* <string-table> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1678;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1679;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L1680;

extern struct dylanZdylan_visceraZCLS_raw_function L1681;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1682;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1683;

struct dylanZdylan_visceraZCLS_class table_extensionsZtable_extensionsZCLS_string_table_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1678 /* class-name */,
    1001 /* unique-id */,
    (heapptr_t) &L1679 /* direct-superclasses */,
    (heapptr_t) &L1680 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_table_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1681 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1682 /* class-slot-overrides */,
    (heapptr_t) &L342 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L1683 /* class-row */,
};

/* <case-insensitive-string-table> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE31 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[31];	 /* %element */
} L1684;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L1685;

extern struct dylanZdylan_visceraZCLS_raw_function L1686;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1687;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1688;

struct dylanZdylan_visceraZCLS_class table_extensionsZtable_extensionsZCLS_case_insensitive_string_table_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1684 /* class-name */,
    1000 /* unique-id */,
    (heapptr_t) &L1679 /* direct-superclasses */,
    (heapptr_t) &L1685 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_table_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1686 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1687 /* class-slot-overrides */,
    (heapptr_t) &L342 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L1688 /* class-row */,
};

/* remove-key! */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1689;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1690;

extern struct dylanZdylan_visceraZCLS_pair L1691;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZremove_keyD_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1689 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1690 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L83 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1691 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <random-state> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1692;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1693;

extern struct dylanZdylan_visceraZCLS_raw_function L1694;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1695;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1696;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1697;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1698;

struct dylanZdylan_visceraZCLS_class randomZrandomZCLS_random_state_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1692 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1693 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1694 /* class-maker */,
    (heapptr_t) &L1695 /* class-new-slot-descriptors */,
    (heapptr_t) &L1696 /* class-slot-overrides */,
    (heapptr_t) &L1697 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1698 /* class-row */,
};

/* #"seed" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1699;

struct dylanZdylan_visceraZCLS_symbol SYM_seed_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1699, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_buffer_HEAP /* symbol-next */,
};

/* #"state" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1700;

struct dylanZdylan_visceraZCLS_symbol SYM_state_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1700, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_seed_HEAP /* symbol-next */,
};

/* #"mean" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1701;

struct dylanZdylan_visceraZCLS_symbol SYM_mean_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1701, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_state_HEAP /* symbol-next */,
};

/* #"standard-deviation" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L1702;

struct dylanZdylan_visceraZCLS_symbol SYM_standard_deviation_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1702, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_mean_HEAP /* symbol-next */,
};

/* #"lambda" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1703;

struct dylanZdylan_visceraZCLS_symbol SYM_lambda_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1703, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_standard_deviation_HEAP /* symbol-next */,
};

/* <self-organizing-list> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE22 L1704;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L1705;

extern struct dylanZdylan_visceraZCLS_raw_function L1706;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1707;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1708;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1709;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1710;

struct dylanZdylan_visceraZCLS_class collection_extensionsZself_organizing_listZCLS_self_organizing_list_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1704 /* class-name */,
    407 /* unique-id */,
    (heapptr_t) &L338 /* direct-superclasses */,
    (heapptr_t) &L1705 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1706 /* class-maker */,
    (heapptr_t) &L1707 /* class-new-slot-descriptors */,
    (heapptr_t) &L1708 /* class-slot-overrides */,
    (heapptr_t) &L1709 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1710 /* class-row */,
};

/* <subsequence> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1711;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1712;

extern struct dylanZdylan_visceraZCLS_pair L1713;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1714;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1715;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1716;

struct dylanZdylan_visceraZCLS_class collection_extensionsZsubseqZCLS_subsequence_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1711 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L377 /* direct-superclasses */,
    (heapptr_t) &L1712 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1713 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L1714 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L1715 /* class-all-slot-descriptors */,
    5 /* class-bucket */,
    (heapptr_t) &L1716 /* class-row */,
};

/* #"source" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1717;

struct dylanZdylan_visceraZCLS_symbol SYM_source_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1717, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_lambda_HEAP /* symbol-next */,
};

/* <generic-subsequence> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L1718;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1719;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1720;

extern struct dylanZdylan_visceraZCLS_raw_function L1721;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L1722;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1723;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L1724;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1725;

struct dylanZdylan_visceraZCLS_class collection_extensionsZsubseqZCLS_generic_subsequence_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1718 /* class-name */,
    405 /* unique-id */,
    (heapptr_t) &L1719 /* direct-superclasses */,
    (heapptr_t) &L1720 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1721 /* class-maker */,
    (heapptr_t) &L1722 /* class-new-slot-descriptors */,
    (heapptr_t) &L1723 /* class-slot-overrides */,
    (heapptr_t) &L1724 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1725 /* class-row */,
};

/* #"copy" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1726;

struct dylanZdylan_visceraZCLS_symbol SYM_copy_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1726, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_source_HEAP /* symbol-next */,
};

/* #"elem-setter" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1727;

struct dylanZdylan_visceraZCLS_symbol SYM_elem_setter_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1727, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_copy_HEAP /* symbol-next */,
};

/* #"elem" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1728;

struct dylanZdylan_visceraZCLS_symbol SYM_elem_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1728, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_elem_setter_HEAP /* symbol-next */,
};

/* #"done" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1729;

struct dylanZdylan_visceraZCLS_symbol SYM_done_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1729, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_elem_HEAP /* symbol-next */,
};

/* #"init" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1730;

struct dylanZdylan_visceraZCLS_symbol SYM_init_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1730, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_done_HEAP /* symbol-next */,
};

/* <vector-subsequence> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L1731;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1732;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L1733;

extern struct dylanZdylan_visceraZCLS_pair L1734;

extern struct dylanZdylan_visceraZCLS_raw_function L1735;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1736;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1737;

struct dylanZdylan_visceraZCLS_class collection_extensionsZsubseqZCLS_vector_subsequence_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1731 /* class-name */,
    404 /* unique-id */,
    (heapptr_t) &L1732 /* direct-superclasses */,
    (heapptr_t) &L1733 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1734 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1735 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1736 /* class-slot-overrides */,
    (heapptr_t) &L1715 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1737 /* class-row */,
};

/* <string-subsequence> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L1738;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1739;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L1740;

extern struct dylanZdylan_visceraZCLS_pair L1741;

extern struct dylanZdylan_visceraZCLS_raw_function L1742;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1743;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1744;

struct dylanZdylan_visceraZCLS_class collection_extensionsZsubseqZCLS_string_subsequence_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1738 /* class-name */,
    402 /* unique-id */,
    (heapptr_t) &L1739 /* direct-superclasses */,
    (heapptr_t) &L1740 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1741 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1742 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1743 /* class-slot-overrides */,
    (heapptr_t) &L1715 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1744 /* class-row */,
};

/* <vs-subsequence> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L1745;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1746;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE12 L1747;

extern struct dylanZdylan_visceraZCLS_raw_function L1748;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1749;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1750;

struct dylanZdylan_visceraZCLS_class collection_extensionsZsubseqZCLS_vs_subsequence_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1745 /* class-name */,
    403 /* unique-id */,
    (heapptr_t) &L1746 /* direct-superclasses */,
    (heapptr_t) &L1747 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1748 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1749 /* class-slot-overrides */,
    (heapptr_t) &L1715 /* class-all-slot-descriptors */,
    10 /* class-bucket */,
    (heapptr_t) &L1750 /* class-row */,
};

/* aref */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1751;

extern struct dylanZdylan_visceraZCLS_pair L1752;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZaref_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1751 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L354 /* function-specializers */,
    1 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1752 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* aref-setter */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1753;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1754;

extern struct dylanZdylan_visceraZCLS_pair L1755;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZaref_setter_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1753 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1754 /* function-specializers */,
    1 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1755 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <SDE-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1756;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1757;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1758;

extern struct dylanZdylan_visceraZCLS_raw_function L1759;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1760;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1761;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1762;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1763;

struct dylanZdylan_visceraZCLS_class collection_extensionsZsde_vectorZCLS_sde_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1756 /* class-name */,
    406 /* unique-id */,
    (heapptr_t) &L1757 /* direct-superclasses */,
    (heapptr_t) &L1758 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1759 /* class-maker */,
    (heapptr_t) &L1760 /* class-new-slot-descriptors */,
    (heapptr_t) &L1761 /* class-slot-overrides */,
    (heapptr_t) &L1762 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1763 /* class-row */,
};

/* <script-entry> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1764;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1765;

extern struct dylanZdylan_visceraZCLS_pair L1766;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1767;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1768;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1769;

struct dylanZdylan_visceraZCLS_class collection_extensionsZsequence_diffZCLS_script_entry_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1764 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1765 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1766 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L1767 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L1768 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1769 /* class-row */,
};

/* <insert-entry> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1770;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1771;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1772;

extern struct dylanZdylan_visceraZCLS_raw_function L1773;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1774;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1775;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1776;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1777;

struct dylanZdylan_visceraZCLS_class collection_extensionsZsequence_diffZCLS_insert_entry_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1770 /* class-name */,
    401 /* unique-id */,
    (heapptr_t) &L1771 /* direct-superclasses */,
    (heapptr_t) &L1772 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1773 /* class-maker */,
    (heapptr_t) &L1774 /* class-new-slot-descriptors */,
    (heapptr_t) &L1775 /* class-slot-overrides */,
    (heapptr_t) &L1776 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1777 /* class-row */,
};

/* #"source-index" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1778;

struct dylanZdylan_visceraZCLS_symbol SYM_source_index_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1778, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_init_HEAP /* symbol-next */,
};

/* #"dest-index" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L1779;

struct dylanZdylan_visceraZCLS_symbol SYM_dest_index_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1779, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_source_index_HEAP /* symbol-next */,
};

/* <delete-entry> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1780;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1781;

extern struct dylanZdylan_visceraZCLS_raw_function L1782;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1783;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1784;

struct dylanZdylan_visceraZCLS_class collection_extensionsZsequence_diffZCLS_delete_entry_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1780 /* class-name */,
    400 /* unique-id */,
    (heapptr_t) &L1771 /* direct-superclasses */,
    (heapptr_t) &L1781 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1782 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1783 /* class-slot-overrides */,
    (heapptr_t) &L1768 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1784 /* class-row */,
};

/* #"cons" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1785;

struct dylanZdylan_visceraZCLS_symbol SYM_cons_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1785, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_dest_index_HEAP /* symbol-next */,
};

/* #"add" */
struct dylanZdylan_visceraZCLS_symbol SYM_add_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L707, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_cons_HEAP /* symbol-next */,
};

/* #"datum" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1786;

struct dylanZdylan_visceraZCLS_symbol SYM_datum_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1786, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_add_HEAP /* symbol-next */,
};

/* #"not-found" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1787;

struct dylanZdylan_visceraZCLS_symbol SYM_not_found_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1787, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_datum_HEAP /* symbol-next */,
};

/* #"uppercase" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1788;

struct dylanZdylan_visceraZCLS_symbol SYM_uppercase_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1788, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_not_found_HEAP /* symbol-next */,
};

/* <parse-string> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1789;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1790;

extern struct dylanZdylan_visceraZCLS_raw_function L1791;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1792;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1793;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1794;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1795;

struct dylanZdylan_visceraZCLS_class string_extensionsZPCTparse_stringZCLS_parse_string_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1789 /* class-name */,
    655 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1790 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1791 /* class-maker */,
    (heapptr_t) &L1792 /* class-new-slot-descriptors */,
    (heapptr_t) &L1793 /* class-slot-overrides */,
    (heapptr_t) &L1794 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1795 /* class-row */,
};

/* <character-set> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1796;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1797;

extern struct dylanZdylan_visceraZCLS_pair L1798;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1799;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1800;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1801;

struct dylanZdylan_visceraZCLS_class string_extensionsZstring_hackingZCLS_character_set_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1796 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L105 /* direct-superclasses */,
    (heapptr_t) &L1797 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1798 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &L1799 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L1800 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1801 /* class-row */,
};

/* <case-sensitive-character-set> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE30 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[30];	 /* %element */
} L1802;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1803;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1804;

extern struct dylanZdylan_visceraZCLS_raw_function L1805;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1806;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1807;

struct dylanZdylan_visceraZCLS_class string_extensionsZstring_hackingZCLS_case_sensitive_character_set_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1802 /* class-name */,
    657 /* unique-id */,
    (heapptr_t) &L1803 /* direct-superclasses */,
    (heapptr_t) &L1804 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1805 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1806 /* class-slot-overrides */,
    (heapptr_t) &L1800 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1807 /* class-row */,
};

/* <byte-character-table> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE22 L1808;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1809;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L1810;

extern struct dylanZdylan_visceraZCLS_raw_function L1811;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1812;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1813;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1814;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1815;

struct dylanZdylan_visceraZCLS_class string_extensionsZstring_hackingZCLS_byte_character_table_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1808 /* class-name */,
    658 /* unique-id */,
    (heapptr_t) &L1809 /* direct-superclasses */,
    (heapptr_t) &L1810 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1811 /* class-maker */,
    (heapptr_t) &L1812 /* class-new-slot-descriptors */,
    (heapptr_t) &L1813 /* class-slot-overrides */,
    (heapptr_t) &L1814 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1815 /* class-row */,
};

/* <case-insensitive-character-set> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE32 L1816;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1817;

extern struct dylanZdylan_visceraZCLS_raw_function L1818;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1819;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1820;

struct dylanZdylan_visceraZCLS_class string_extensionsZstring_hackingZCLS_case_insensitive_character_set_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1816 /* class-name */,
    656 /* unique-id */,
    (heapptr_t) &L1803 /* direct-superclasses */,
    (heapptr_t) &L1817 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1818 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1819 /* class-slot-overrides */,
    (heapptr_t) &L1800 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1820 /* class-row */,
};

/* <char-set-iterator> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L1821;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1822;

extern struct dylanZdylan_visceraZCLS_raw_function L1823;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1824;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1825;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1826;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1827;

struct dylanZdylan_visceraZCLS_class string_extensionsZstring_hackingZCLS_char_set_iterator_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1821 /* class-name */,
    654 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1822 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1823 /* class-maker */,
    (heapptr_t) &L1824 /* class-new-slot-descriptors */,
    (heapptr_t) &L1825 /* class-slot-overrides */,
    (heapptr_t) &L1826 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1827 /* class-row */,
};

/* #"range" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1828;

struct dylanZdylan_visceraZCLS_symbol SYM_range_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1828, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_uppercase_HEAP /* symbol-next */,
};

/* #"single" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1829;

struct dylanZdylan_visceraZCLS_symbol SYM_single_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1829, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_range_HEAP /* symbol-next */,
};

/* #"case-sensitive" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1830;

struct dylanZdylan_visceraZCLS_symbol SYM_case_sensitive_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1830, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_single_HEAP /* symbol-next */,
};

/* #"replace-with" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1831;

struct dylanZdylan_visceraZCLS_symbol SYM_replace_with_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1831, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_case_sensitive_HEAP /* symbol-next */,
};

/* <substring> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1832;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1833;

extern struct dylanZdylan_visceraZCLS_raw_function L1834;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1835;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1836;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1837;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1838;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_substring_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1832 /* class-name */,
    1412 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1833 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1834 /* class-maker */,
    (heapptr_t) &L1835 /* class-new-slot-descriptors */,
    (heapptr_t) &L1836 /* class-slot-overrides */,
    (heapptr_t) &L1837 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1838 /* class-row */,
};

/* #"final-state" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1839;

struct dylanZdylan_visceraZCLS_symbol SYM_final_state_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1839, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_replace_with_HEAP /* symbol-next */,
};

/* #"beginning-of-string" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L1840;

struct dylanZdylan_visceraZCLS_symbol SYM_beginning_of_string_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1840, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_final_state_HEAP /* symbol-next */,
};

/* #"end-of-string" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1841;

struct dylanZdylan_visceraZCLS_symbol SYM_end_of_string_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1841, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_beginning_of_string_HEAP /* symbol-next */,
};

/* #"word-boundary" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1842;

struct dylanZdylan_visceraZCLS_symbol SYM_word_boundary_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1842, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_end_of_string_HEAP /* symbol-next */,
};

/* #"not-word-boundary" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L1843;

struct dylanZdylan_visceraZCLS_symbol SYM_not_word_boundary_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1843, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_word_boundary_HEAP /* symbol-next */,
};

/* <parsed-regexp> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1844;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1845;

extern struct dylanZdylan_visceraZCLS_pair L1846;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1847;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_parsed_regexp_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1844 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1845 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1846 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1847 /* class-row */,
};

/* <mark> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1848;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1849;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1850;

extern struct dylanZdylan_visceraZCLS_raw_function L1851;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1852;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1853;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1854;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1855;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_mark_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1848 /* class-name */,
    1411 /* unique-id */,
    (heapptr_t) &L1849 /* direct-superclasses */,
    (heapptr_t) &L1850 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1851 /* class-maker */,
    (heapptr_t) &L1852 /* class-new-slot-descriptors */,
    (heapptr_t) &L1853 /* class-slot-overrides */,
    (heapptr_t) &L1854 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1855 /* class-row */,
};

/* #"group" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1856;

struct dylanZdylan_visceraZCLS_symbol SYM_group_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1856, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_not_word_boundary_HEAP /* symbol-next */,
};

/* #"child" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1857;

struct dylanZdylan_visceraZCLS_symbol SYM_child_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1857, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_group_HEAP /* symbol-next */,
};

/* <union> */
extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1858;

extern struct dylanZdylan_visceraZCLS_raw_function L1859;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1860;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1861;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1862;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1863;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_union_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L161 /* class-name */,
    1410 /* unique-id */,
    (heapptr_t) &L1849 /* direct-superclasses */,
    (heapptr_t) &L1858 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1859 /* class-maker */,
    (heapptr_t) &L1860 /* class-new-slot-descriptors */,
    (heapptr_t) &L1861 /* class-slot-overrides */,
    (heapptr_t) &L1862 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1863 /* class-row */,
};

/* #"right" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L1864;

struct dylanZdylan_visceraZCLS_symbol SYM_right_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1864, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_child_HEAP /* symbol-next */,
};

/* #"left" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1865;

struct dylanZdylan_visceraZCLS_symbol SYM_left_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1865, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_right_HEAP /* symbol-next */,
};

/* <alternative> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1866;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1867;

extern struct dylanZdylan_visceraZCLS_raw_function L1868;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1869;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1870;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1871;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1872;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_alternative_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1866 /* class-name */,
    1409 /* unique-id */,
    (heapptr_t) &L1849 /* direct-superclasses */,
    (heapptr_t) &L1867 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1868 /* class-maker */,
    (heapptr_t) &L1869 /* class-new-slot-descriptors */,
    (heapptr_t) &L1870 /* class-slot-overrides */,
    (heapptr_t) &L1871 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1872 /* class-row */,
};

/* <parsed-assertion> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L1873;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1874;

extern struct dylanZdylan_visceraZCLS_raw_function L1875;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1876;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1877;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1878;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1879;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_parsed_assertion_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1873 /* class-name */,
    1408 /* unique-id */,
    (heapptr_t) &L1849 /* direct-superclasses */,
    (heapptr_t) &L1874 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1875 /* class-maker */,
    (heapptr_t) &L1876 /* class-new-slot-descriptors */,
    (heapptr_t) &L1877 /* class-slot-overrides */,
    (heapptr_t) &L1878 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1879 /* class-row */,
};

/* #"assertion" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1880;

struct dylanZdylan_visceraZCLS_symbol SYM_assertion_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1880, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_left_HEAP /* symbol-next */,
};

/* <quantified-atom> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L1881;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1882;

extern struct dylanZdylan_visceraZCLS_raw_function L1883;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1884;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1885;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1886;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1887;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_quantified_atom_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1881 /* class-name */,
    1407 /* unique-id */,
    (heapptr_t) &L1849 /* direct-superclasses */,
    (heapptr_t) &L1882 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1883 /* class-maker */,
    (heapptr_t) &L1884 /* class-new-slot-descriptors */,
    (heapptr_t) &L1885 /* class-slot-overrides */,
    (heapptr_t) &L1886 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1887 /* class-row */,
};

/* #"atom" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L1888;

struct dylanZdylan_visceraZCLS_symbol SYM_atom_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1888, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_assertion_HEAP /* symbol-next */,
};

/* <parsed-atom> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1889;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1890;

extern struct dylanZdylan_visceraZCLS_pair L1891;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1892;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_parsed_atom_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1889 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1849 /* direct-superclasses */,
    (heapptr_t) &L1890 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1891 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1892 /* class-row */,
};

/* <parsed-character> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L1893;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1894;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1895;

extern struct dylanZdylan_visceraZCLS_raw_function L1896;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1897;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1898;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1899;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1900;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_parsed_character_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1893 /* class-name */,
    1406 /* unique-id */,
    (heapptr_t) &L1894 /* direct-superclasses */,
    (heapptr_t) &L1895 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1896 /* class-maker */,
    (heapptr_t) &L1897 /* class-new-slot-descriptors */,
    (heapptr_t) &L1898 /* class-slot-overrides */,
    (heapptr_t) &L1899 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L1900 /* class-row */,
};

/* #"character" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1901;

struct dylanZdylan_visceraZCLS_symbol SYM_character_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1901, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_atom_HEAP /* symbol-next */,
};

/* <parsed-string> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1902;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1903;

extern struct dylanZdylan_visceraZCLS_raw_function L1904;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1905;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1906;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1907;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1908;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_parsed_string_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1902 /* class-name */,
    1405 /* unique-id */,
    (heapptr_t) &L1894 /* direct-superclasses */,
    (heapptr_t) &L1903 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1904 /* class-maker */,
    (heapptr_t) &L1905 /* class-new-slot-descriptors */,
    (heapptr_t) &L1906 /* class-slot-overrides */,
    (heapptr_t) &L1907 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L1908 /* class-row */,
};

/* <parsed-set> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1909;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1910;

extern struct dylanZdylan_visceraZCLS_raw_function L1911;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1912;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1913;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1914;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1915;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_parsed_set_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1909 /* class-name */,
    1404 /* unique-id */,
    (heapptr_t) &L1894 /* direct-superclasses */,
    (heapptr_t) &L1910 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1911 /* class-maker */,
    (heapptr_t) &L1912 /* class-new-slot-descriptors */,
    (heapptr_t) &L1913 /* class-slot-overrides */,
    (heapptr_t) &L1914 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L1915 /* class-row */,
};

/* #"set" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE3 L1916;

struct dylanZdylan_visceraZCLS_symbol SYM_set_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1916, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_character_HEAP /* symbol-next */,
};

/* <parsed-backreference> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE22 L1917;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1918;

extern struct dylanZdylan_visceraZCLS_raw_function L1919;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1920;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1921;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1922;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1923;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_parsed_backreference_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1917 /* class-name */,
    1403 /* unique-id */,
    (heapptr_t) &L1894 /* direct-superclasses */,
    (heapptr_t) &L1918 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1919 /* class-maker */,
    (heapptr_t) &L1920 /* class-new-slot-descriptors */,
    (heapptr_t) &L1921 /* class-slot-overrides */,
    (heapptr_t) &L1922 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L1923 /* class-row */,
};

/* <parse-info> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1924;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1925;

extern struct dylanZdylan_visceraZCLS_raw_function L1926;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1927;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1928;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L1929;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1930;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_parse_info_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1924 /* class-name */,
    1402 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1925 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1926 /* class-maker */,
    (heapptr_t) &L1927 /* class-new-slot-descriptors */,
    (heapptr_t) &L1928 /* class-slot-overrides */,
    (heapptr_t) &L1929 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1930 /* class-row */,
};

/* #"set-type" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L1931;

struct dylanZdylan_visceraZCLS_symbol SYM_set_type_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1931, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_set_HEAP /* symbol-next */,
};

/* <illegal-regexp> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L1932;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L1933;

extern struct dylanZdylan_visceraZCLS_raw_function L1934;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1935;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1936;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1937;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1938;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_illegal_regexp_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1932 /* class-name */,
    1413 /* unique-id */,
    (heapptr_t) &L661 /* direct-superclasses */,
    (heapptr_t) &L1933 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1934 /* class-maker */,
    (heapptr_t) &L1935 /* class-new-slot-descriptors */,
    (heapptr_t) &L1936 /* class-slot-overrides */,
    (heapptr_t) &L1937 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1938 /* class-row */,
};

/* #"regexp" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1939;

struct dylanZdylan_visceraZCLS_symbol SYM_regexp_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1939, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_set_type_HEAP /* symbol-next */,
};

/* <cache-key> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L1940;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1941;

extern struct dylanZdylan_visceraZCLS_raw_function L1942;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1943;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1944;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1945;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1946;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_cache_key_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1940 /* class-name */,
    1401 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1941 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1942 /* class-maker */,
    (heapptr_t) &L1943 /* class-new-slot-descriptors */,
    (heapptr_t) &L1944 /* class-slot-overrides */,
    (heapptr_t) &L1945 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1946 /* class-row */,
};

/* #"character-set-type" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L1947;

struct dylanZdylan_visceraZCLS_symbol SYM_character_set_type_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1947, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_regexp_HEAP /* symbol-next */,
};

/* #"regexp-string" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1948;

struct dylanZdylan_visceraZCLS_symbol SYM_regexp_string_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1948, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_character_set_type_HEAP /* symbol-next */,
};

/* <cache-element> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1949;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1950;

extern struct dylanZdylan_visceraZCLS_raw_function L1951;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1952;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1953;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1954;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1955;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_cache_element_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1949 /* class-name */,
    1400 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L1950 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1951 /* class-maker */,
    (heapptr_t) &L1952 /* class-new-slot-descriptors */,
    (heapptr_t) &L1953 /* class-slot-overrides */,
    (heapptr_t) &L1954 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1955 /* class-row */,
};

/* #"last-group" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L1956;

struct dylanZdylan_visceraZCLS_symbol SYM_last_group_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1956, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_regexp_string_HEAP /* symbol-next */,
};

/* #"parse-tree" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L1957;

struct dylanZdylan_visceraZCLS_symbol SYM_parse_tree_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1957, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_last_group_HEAP /* symbol-next */,
};

/* <regexp-cache> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1958;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L1959;

extern struct dylanZdylan_visceraZCLS_raw_function L1960;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1961;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1962;

struct dylanZdylan_visceraZCLS_class regular_expressionsZregular_expressionsZCLS_regexp_cache_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1958 /* class-name */,
    1414 /* unique-id */,
    (heapptr_t) &L345 /* direct-superclasses */,
    (heapptr_t) &L1959 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_table_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1960 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1961 /* class-slot-overrides */,
    (heapptr_t) &L342 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1962 /* class-row */,
};

/* #"byte-characters-only" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L1963;

struct dylanZdylan_visceraZCLS_symbol SYM_byte_characters_only_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1963, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_parse_tree_HEAP /* symbol-next */,
};

/* #"need-marks" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L1964;

struct dylanZdylan_visceraZCLS_symbol SYM_need_marks_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1964, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_byte_characters_only_HEAP /* symbol-next */,
};

/* #"maximum-compile" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L1965;

struct dylanZdylan_visceraZCLS_symbol SYM_maximum_compile_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1965, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_need_marks_HEAP /* symbol-next */,
};

/* #"delete" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L1966;

struct dylanZdylan_visceraZCLS_symbol SYM_delete_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1966, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_maximum_compile_HEAP /* symbol-next */,
};

/* #"remove-empty-items" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L1967;

struct dylanZdylan_visceraZCLS_symbol SYM_remove_empty_items_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1967, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_delete_HEAP /* symbol-next */,
};

/* <anonymous-1> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L1968;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1969;

extern struct dylanZdylan_visceraZCLS_raw_function L1970;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1971;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1972;

struct dylanZdylan_visceraZCLS_class common_extensionsZc_supportZCLS_anonymous_1_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1968 /* class-name */,
    5100 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L1969 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1970 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1971 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L1972 /* class-row */,
};

/* import-value */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L1973;

extern struct dylanZdylan_visceraZCLS_pair L1974;

struct dylanZdylan_visceraZCLS_generic_function melange_supportZmelange_supportZimport_value_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1973 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L102 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1974 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"predicate" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L1975;

struct dylanZdylan_visceraZCLS_symbol SYM_predicate_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L1975, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_remove_empty_items_HEAP /* symbol-next */,
};

/* find-key */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L1976;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1977;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L1978;

extern struct dylanZdylan_visceraZCLS_pair L1979;

struct dylanZdylan_visceraZCLS_generic_function dylanZdylan_visceraZfind_key_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1976 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1977 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1978 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L1979 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* <lock> */
extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1980;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1981;

extern struct dylanZdylan_visceraZCLS_pair L1982;

extern struct dylanZdylan_visceraZCLS_raw_function L1983;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1984;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1985;

struct dylanZdylan_visceraZCLS_class threadsZthreadsZCLS_lock_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1230 /* class-name */,
    5502 /* unique-id */,
    (heapptr_t) &L1980 /* direct-superclasses */,
    (heapptr_t) &L1981 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1982 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1983 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1984 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1985 /* class-row */,
};

/* <notification> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L1986;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L1987;

extern struct dylanZdylan_visceraZCLS_raw_function L1988;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1989;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1990;

struct dylanZdylan_visceraZCLS_class threadsZthreadsZCLS_notification_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1986 /* class-name */,
    5501 /* unique-id */,
    (heapptr_t) &L1980 /* direct-superclasses */,
    (heapptr_t) &L1987 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1988 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1989 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L1990 /* class-row */,
};

/* <exclusive-lock> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L1991;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1992;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1993;

extern struct dylanZdylan_visceraZCLS_pair L1994;

extern struct dylanZdylan_visceraZCLS_raw_function L1995;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L1996;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L1997;

struct dylanZdylan_visceraZCLS_class threadsZthreadsZCLS_exclusive_lock_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1991 /* class-name */,
    5504 /* unique-id */,
    (heapptr_t) &L1992 /* direct-superclasses */,
    (heapptr_t) &L1993 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L1994 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1995 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L1996 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L1997 /* class-row */,
};

/* <semaphore> */
extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L1998;

extern struct dylanZdylan_visceraZCLS_class threadsZthreadsZCLS_semaphore_HEAP;

extern struct dylanZdylan_visceraZCLS_raw_function L1999;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2000;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2001;

struct dylanZdylan_visceraZCLS_class threadsZthreadsZCLS_semaphore_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1234 /* class-name */,
    5503 /* unique-id */,
    (heapptr_t) &L1992 /* direct-superclasses */,
    (heapptr_t) &L1998 /* all-superclasses */,
    (heapptr_t) &threadsZthreadsZCLS_semaphore_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    1 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L1999 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2000 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    2 /* class-bucket */,
    (heapptr_t) &L2001 /* class-row */,
};

/* <recursive-lock> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L2002;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2003;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L2004;

extern struct dylanZdylan_visceraZCLS_class threadsZthreadsZCLS_recursive_lock_HEAP;

extern struct dylanZdylan_visceraZCLS_raw_function L2005;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2006;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2007;

struct dylanZdylan_visceraZCLS_class threadsZthreadsZCLS_recursive_lock_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2002 /* class-name */,
    5507 /* unique-id */,
    (heapptr_t) &L2003 /* direct-superclasses */,
    (heapptr_t) &L2004 /* all-superclasses */,
    (heapptr_t) &threadsZthreadsZCLS_recursive_lock_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    1 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2005 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2006 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    3 /* class-bucket */,
    (heapptr_t) &L2007 /* class-row */,
};

/* <read-write-lock> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L2008;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L2009;

extern struct dylanZdylan_visceraZCLS_class threadsZthreadsZCLS_read_write_lock_HEAP;

extern struct dylanZdylan_visceraZCLS_raw_function L2010;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2011;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2012;

struct dylanZdylan_visceraZCLS_class threadsZthreadsZCLS_read_write_lock_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2008 /* class-name */,
    5506 /* unique-id */,
    (heapptr_t) &L2003 /* direct-superclasses */,
    (heapptr_t) &L2009 /* all-superclasses */,
    (heapptr_t) &threadsZthreadsZCLS_read_write_lock_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    1 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2010 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2011 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    3 /* class-bucket */,
    (heapptr_t) &L2012 /* class-row */,
};

/* <simple-lock> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L2013;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L2014;

extern struct dylanZdylan_visceraZCLS_class threadsZthreadsZCLS_simple_lock_HEAP;

extern struct dylanZdylan_visceraZCLS_raw_function L2015;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2016;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2017;

struct dylanZdylan_visceraZCLS_class threadsZthreadsZCLS_simple_lock_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2013 /* class-name */,
    5505 /* unique-id */,
    (heapptr_t) &L2003 /* direct-superclasses */,
    (heapptr_t) &L2014 /* all-superclasses */,
    (heapptr_t) &threadsZthreadsZCLS_simple_lock_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    1 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2015 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2016 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    3 /* class-bucket */,
    (heapptr_t) &L2017 /* class-row */,
};

/* <thread> */
extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2018;

extern struct dylanZdylan_visceraZCLS_raw_function L2019;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2020;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2021;

struct dylanZdylan_visceraZCLS_class threadsZthreadsZCLS_thread_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1030 /* class-name */,
    5500 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L2018 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2019 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2020 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2021 /* class-row */,
};

/* #"timeout" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L2022;

struct dylanZdylan_visceraZCLS_symbol SYM_timeout_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L2022, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_predicate_HEAP /* symbol-next */,
};

/* {<slot-descriptor> for stream-error-stream introduced by <stream-error>} */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L2023;

extern struct dylanZdylan_visceraZCLS_generic_function common_dylan_L4;

extern struct dylanZdylan_visceraZCLS_pair L2024;

struct dylanZdylan_visceraZCLS_slot_descriptor common_dylanZcommon_dylan_internalsZCLS_stream_errorZcommon_dylanZcommon_dylan_internalsZstream_error_stream_SLOT_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptor_HEAP /* %object-class */,
    (heapptr_t) &L2023 /* slot-name */,
    (heapptr_t) &SYM_instance_HEAP /* slot-allocation */,
    (heapptr_t) &streamsZstreamsZCLS_stream_HEAP /* slot-type */,
    (heapptr_t) &common_dylan_L4 /* slot-getter */,
    (heapptr_t) &dylan_L1 /* slot-init-function */,
    { (heapptr_t) &dylanZliteral_ROOT, { 0 } } /* slot-init-value */,
    (heapptr_t) &SYM_stream_HEAP /* slot-init-keyword */,
    1 /* slot-init-keyword-required? */,
    { 0, 0, 0, }, /* hole */
    (heapptr_t) &L2024 /* slot-positions */,
    { (heapptr_t) &dylan_L1, { 0 } } /* slot-positions-cache */,
    (heapptr_t) &SYM_heap_HEAP /* slot-representation */,
    (heapptr_t) &dylan_L1 /* slot-initialized?-slot */,
};

/* <stream-error> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L2025;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2026;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L2027;

extern struct dylanZdylan_visceraZCLS_pair L2028;

extern struct dylanZdylan_visceraZCLS_raw_function L2029;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2030;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2031;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L2032;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2033;

struct dylanZdylan_visceraZCLS_class common_dylanZcommon_dylan_internalsZCLS_stream_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2025 /* class-name */,
    5200 /* unique-id */,
    (heapptr_t) &L2026 /* direct-superclasses */,
    (heapptr_t) &L2027 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2028 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2029 /* class-maker */,
    (heapptr_t) &L2030 /* class-new-slot-descriptors */,
    (heapptr_t) &L2031 /* class-slot-overrides */,
    (heapptr_t) &L2032 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2033 /* class-row */,
};

/* <end-of-stream-error> */
extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2034;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L2035;

extern struct dylanZdylan_visceraZCLS_pair L2036;

extern struct dylanZdylan_visceraZCLS_raw_function L2037;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2038;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2039;

struct dylanZdylan_visceraZCLS_class common_dylanZcommon_dylan_internalsZCLS_end_of_stream_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1333 /* class-name */,
    5201 /* unique-id */,
    (heapptr_t) &L2034 /* direct-superclasses */,
    (heapptr_t) &L2035 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2036 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2037 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2038 /* class-slot-overrides */,
    (heapptr_t) &L2032 /* class-all-slot-descriptors */,
    5 /* class-bucket */,
    (heapptr_t) &L2039 /* class-row */,
};

/* <incomplete-read-error> */
extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2040;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L2041;

extern struct dylanZdylan_visceraZCLS_raw_function L2042;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2043;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2044;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L2045;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2046;

struct dylanZdylan_visceraZCLS_class common_dylanZcommon_dylan_internalsZCLS_incomplete_read_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L1342 /* class-name */,
    5203 /* unique-id */,
    (heapptr_t) &L2040 /* direct-superclasses */,
    (heapptr_t) &L2041 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2042 /* class-maker */,
    (heapptr_t) &L2043 /* class-new-slot-descriptors */,
    (heapptr_t) &L2044 /* class-slot-overrides */,
    (heapptr_t) &L2045 /* class-all-slot-descriptors */,
    6 /* class-bucket */,
    (heapptr_t) &L2046 /* class-row */,
};

/* <incomplete-write-error> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE24 L2047;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L2048;

extern struct dylanZdylan_visceraZCLS_raw_function L2049;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2050;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2051;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L2052;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2053;

struct dylanZdylan_visceraZCLS_class common_dylanZcommon_dylan_internalsZCLS_incomplete_write_error_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2047 /* class-name */,
    5202 /* unique-id */,
    (heapptr_t) &L2040 /* direct-superclasses */,
    (heapptr_t) &L2048 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2049 /* class-maker */,
    (heapptr_t) &L2050 /* class-new-slot-descriptors */,
    (heapptr_t) &L2051 /* class-slot-overrides */,
    (heapptr_t) &L2052 /* class-all-slot-descriptors */,
    6 /* class-bucket */,
    (heapptr_t) &L2053 /* class-row */,
};

/* read-into! */
extern struct dylanZdylan_visceraZCLS_pair L2054;

struct dylanZdylan_visceraZCLS_generic_function common_dylanZcommon_dylan_internalsZread_intoD_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1451 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1452 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1453 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &L2054 /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* read-element */
struct dylanZdylan_visceraZCLS_generic_function common_dylanZcommon_dylan_internalsZread_element_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1416 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1327 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L1414 /* function-keywords */,
    (heapptr_t) &L8 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &dylanZempty_list_ROOT /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* write-element */
struct dylanZdylan_visceraZCLS_generic_function common_dylanZcommon_dylan_internalsZwrite_element_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP /* %object-class */,
    (heapptr_t) &L1428 /* function-name */,
    dylanZdylan_visceraZgf_call_FUN /* general-entry */,
    (heapptr_t) &L1267 /* function-specializers */,
    0 /* function-rest? */,
    0 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylan_L1 /* function-keywords */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
    (heapptr_t) &dylanZempty_list_ROOT /* generic-function-methods */,
    (heapptr_t) &dylan_L1 /* method-cache */,
};

/* #"synchronize?" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L2055;

struct dylanZdylan_visceraZCLS_symbol SYM_synchronizeQUERY_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L2055, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_timeout_HEAP /* symbol-next */,
};

/* <closable-object> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L2056;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2057;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2058;

struct dylanZdylan_visceraZCLS_class common_dylanZcommon_dylan_internalsZCLS_closable_object_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2056 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L2057 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2058 /* class-row */,
};

/* <locator> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L2059;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2060;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2061;

extern struct dylanZdylan_visceraZCLS_pair L2062;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2063;

struct dylanZdylan_visceraZCLS_class common_dylanZcommon_dylan_internalsZCLS_locator_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2059 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2060 /* direct-superclasses */,
    (heapptr_t) &L2061 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2062 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    1 /* class-abstract? */,
    0 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &dylan_L1 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-slot-overrides */,
    (heapptr_t) &L73 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L2063 /* class-row */,
};

/* <pollfd> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L2064;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2065;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L2066;

extern struct dylanZdylan_visceraZCLS_raw_function L2067;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2068;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2069;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_pollfd_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2064 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2065 /* direct-superclasses */,
    (heapptr_t) &L2066 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2067 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2068 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2069 /* class-row */,
};

/* <unsigned-char*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L2070;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2071;

extern struct dylanZdylan_visceraZCLS_pair L2072;

extern struct dylanZdylan_visceraZCLS_raw_function L2073;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2074;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2075;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_unsigned_charV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2070 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2071 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2072 /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2073 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2074 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2075 /* class-row */,
};

/* <unsigned-char<@14>> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L2076;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2077;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L2078;

extern struct dylanZdylan_visceraZCLS_raw_function L2079;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2080;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2081;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_unsigned_charLESSX4014GREATER_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2076 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2077 /* direct-superclasses */,
    (heapptr_t) &L2078 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2079 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2080 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L2081 /* class-row */,
};

/* <osockaddr> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L2082;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2083;

extern struct dylanZdylan_visceraZCLS_raw_function L2084;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2085;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2086;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_osockaddr_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2082 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2083 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2084 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2085 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2086 /* class-row */,
};

/* <int*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L2087;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2088;

extern struct dylanZdylan_visceraZCLS_pair L2089;

extern struct dylanZdylan_visceraZCLS_raw_function L2090;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2091;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2092;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_intV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2087 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2088 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2089 /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2090 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2091 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2092 /* class-row */,
};

/* <int<@2>> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L2093;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2094;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L2095;

extern struct dylanZdylan_visceraZCLS_raw_function L2096;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2097;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2098;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_intLESSX402GREATER_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2093 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2094 /* direct-superclasses */,
    (heapptr_t) &L2095 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2096 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2097 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L2098 /* class-row */,
};

/* <c-char-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L2099;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L2100;

extern struct dylanZdylan_visceraZCLS_pair L2101;

extern struct dylanZdylan_visceraZCLS_raw_function L2102;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2103;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2104;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_c_char_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2099 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2065 /* direct-superclasses */,
    (heapptr_t) &L2100 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2101 /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2102 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2103 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2104 /* class-row */,
};

/* <char<@14>> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L2105;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2106;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L2107;

extern struct dylanZdylan_visceraZCLS_raw_function L2108;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2109;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2110;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2105 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2106 /* direct-superclasses */,
    (heapptr_t) &L2107 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2108 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2109 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L2110 /* class-row */,
};

/* <sockaddr> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L2111;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2112;

extern struct dylanZdylan_visceraZCLS_pair L2113;

extern struct dylanZdylan_visceraZCLS_raw_function L2114;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2115;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2116;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_sockaddr_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2111 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2112 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2113 /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2114 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2115 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2116 /* class-row */,
};

/* <sockaddr-in> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L2117;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2118;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L2119;

extern struct dylanZdylan_visceraZCLS_raw_function L2120;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2121;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2122;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_sockaddr_in_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2117 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2118 /* direct-superclasses */,
    (heapptr_t) &L2119 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2120 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2121 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L2122 /* class-row */,
};

/* <socklen-t*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L2123;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2124;

extern struct dylanZdylan_visceraZCLS_raw_function L2125;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2126;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2127;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_socklen_tV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2123 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2124 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2125 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2126 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2127 /* class-row */,
};

/* <iovec> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L2128;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2129;

extern struct dylanZdylan_visceraZCLS_raw_function L2130;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2131;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2132;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_iovec_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2128 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2129 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2130 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2131 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2132 /* class-row */,
};

/* <msghdr> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L2133;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2134;

extern struct dylanZdylan_visceraZCLS_raw_function L2135;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2136;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2137;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_msghdr_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2133 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2134 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2135 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2136 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2137 /* class-row */,
};

/* <char<@120>> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L2138;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L2139;

extern struct dylanZdylan_visceraZCLS_raw_function L2140;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2141;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2142;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2138 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2106 /* direct-superclasses */,
    (heapptr_t) &L2139 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2140 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2141 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L2142 /* class-row */,
};

/* <sockaddr-storage> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L2143;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2144;

extern struct dylanZdylan_visceraZCLS_raw_function L2145;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2146;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2147;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_sockaddr_storage_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2143 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2144 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2145 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2146 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2147 /* class-row */,
};

/* <cmsghdr> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L2148;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2149;

extern struct dylanZdylan_visceraZCLS_raw_function L2150;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2151;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2152;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_cmsghdr_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2148 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2149 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2150 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2151 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2152 /* class-row */,
};

/* <ucred> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L2153;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2154;

extern struct dylanZdylan_visceraZCLS_raw_function L2155;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2156;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2157;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_ucred_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2153 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2154 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2155 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2156 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2157 /* class-row */,
};

/* <linger> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L2158;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2159;

extern struct dylanZdylan_visceraZCLS_raw_function L2160;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2161;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2162;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_linger_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2158 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2159 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2160 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2161 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2162 /* class-row */,
};

/* <long*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L2163;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2164;

extern struct dylanZdylan_visceraZCLS_pair L2165;

extern struct dylanZdylan_visceraZCLS_raw_function L2166;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2167;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2168;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_longV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2163 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2164 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2165 /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2166 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2167 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2168 /* class-row */,
};

/* <long<@2>> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L2169;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2170;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L2171;

extern struct dylanZdylan_visceraZCLS_raw_function L2172;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2173;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2174;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_longLESSX402GREATER_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2169 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2170 /* direct-superclasses */,
    (heapptr_t) &L2171 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2172 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2173 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L2174 /* class-row */,
};

/* <__quad-t> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L2175;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2176;

extern struct dylanZdylan_visceraZCLS_raw_function L2177;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2178;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2179;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_X_X_quad_t_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2175 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2176 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2177 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2178 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2179 /* class-row */,
};

/* <__u-long*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L2180;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2181;

extern struct dylanZdylan_visceraZCLS_pair L2182;

extern struct dylanZdylan_visceraZCLS_raw_function L2183;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2184;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2185;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_X_X_u_longV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2180 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2181 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2182 /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2183 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2184 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2185 /* class-row */,
};

/* <__u-long<@2>> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L2186;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2187;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L2188;

extern struct dylanZdylan_visceraZCLS_raw_function L2189;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2190;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2191;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_X_X_u_longLESSX402GREATER_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2186 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2187 /* direct-superclasses */,
    (heapptr_t) &L2188 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2189 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2190 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L2191 /* class-row */,
};

/* <__u-quad-t> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L2192;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2193;

extern struct dylanZdylan_visceraZCLS_raw_function L2194;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2195;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2196;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_X_X_u_quad_t_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2192 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2193 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2194 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2195 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2196 /* class-row */,
};

/* <__fsid-t> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L2197;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2198;

extern struct dylanZdylan_visceraZCLS_raw_function L2199;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2200;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2201;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_X_X_fsid_t_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2197 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2198 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2199 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2200 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2201 /* class-row */,
};

/* <_pthread-fastlock> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L2202;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2203;

extern struct dylanZdylan_visceraZCLS_raw_function L2204;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2205;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2206;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_X_pthread_fastlock_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2202 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2203 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2204 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2205 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2206 /* class-row */,
};

/* <_pthread-descr-struct> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L2207;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2208;

extern struct dylanZdylan_visceraZCLS_raw_function L2209;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2210;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2211;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_X_pthread_descr_struct_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2207 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2208 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2209 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2210 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2211 /* class-row */,
};

/* <__sched-param> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L2212;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2213;

extern struct dylanZdylan_visceraZCLS_raw_function L2214;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2215;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2216;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_X_X_sched_param_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2212 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2213 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2214 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2215 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2216 /* class-row */,
};

/* <__pthread-attr-s> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L2217;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2218;

extern struct dylanZdylan_visceraZCLS_raw_function L2219;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2220;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2221;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_X_X_pthread_attr_s_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2217 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2218 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2219 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2220 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2221 /* class-row */,
};

/* <pthread-cond-t> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L2222;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2223;

extern struct dylanZdylan_visceraZCLS_raw_function L2224;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2225;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2226;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_pthread_cond_t_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2222 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2223 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2224 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2225 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2226 /* class-row */,
};

/* <pthread-condattr-t> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L2227;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2228;

extern struct dylanZdylan_visceraZCLS_raw_function L2229;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2230;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2231;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_pthread_condattr_t_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2227 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2228 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2229 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2230 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2231 /* class-row */,
};

/* <pthread-mutex-t> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L2232;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2233;

extern struct dylanZdylan_visceraZCLS_raw_function L2234;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2235;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2236;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_pthread_mutex_t_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2232 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2233 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2234 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2235 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2236 /* class-row */,
};

/* <pthread-mutexattr-t> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L2237;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2238;

extern struct dylanZdylan_visceraZCLS_raw_function L2239;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2240;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2241;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_pthread_mutexattr_t_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2237 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2238 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2239 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2240 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2241 /* class-row */,
};

/* <unsigned-long*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L2242;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2243;

extern struct dylanZdylan_visceraZCLS_pair L2244;

extern struct dylanZdylan_visceraZCLS_raw_function L2245;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2246;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2247;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_unsigned_longV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2242 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2243 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2244 /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2245 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2246 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2247 /* class-row */,
};

/* <unsigned-long<@32>> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L2248;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2249;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L2250;

extern struct dylanZdylan_visceraZCLS_raw_function L2251;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2252;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2253;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_unsigned_longLESSX4032GREATER_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2248 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2249 /* direct-superclasses */,
    (heapptr_t) &L2250 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2251 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2252 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L2253 /* class-row */,
};

/* <__sigset-t> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L2254;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2255;

extern struct dylanZdylan_visceraZCLS_raw_function L2256;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2257;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2258;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_X_X_sigset_t_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2254 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2255 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2256 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2257 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2258 /* class-row */,
};

/* <__fd-mask*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L2259;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2260;

extern struct dylanZdylan_visceraZCLS_pair L2261;

extern struct dylanZdylan_visceraZCLS_raw_function L2262;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2263;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2264;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_X_X_fd_maskV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2259 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2260 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2261 /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2262 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2263 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2264 /* class-row */,
};

/* <__fd-mask<@32>> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L2265;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2266;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L2267;

extern struct dylanZdylan_visceraZCLS_raw_function L2268;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2269;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2270;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_X_X_fd_maskLESSX4032GREATER_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2265 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2266 /* direct-superclasses */,
    (heapptr_t) &L2267 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2268 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2269 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L2270 /* class-row */,
};

/* <fd-set> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L2271;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2272;

extern struct dylanZdylan_visceraZCLS_raw_function L2273;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2274;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2275;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_fd_set_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2271 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2272 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2273 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2274 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2275 /* class-row */,
};

/* <timeval> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L2276;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2277;

extern struct dylanZdylan_visceraZCLS_raw_function L2278;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2279;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2280;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_timeval_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2276 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2277 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2278 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2279 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2280 /* class-row */,
};

/* <timespec> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L2281;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2282;

extern struct dylanZdylan_visceraZCLS_raw_function L2283;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2284;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2285;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_timespec_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2281 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2282 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2283 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2284 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2285 /* class-row */,
};

/* <in-addr> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L2286;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2287;

extern struct dylanZdylan_visceraZCLS_raw_function L2288;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2289;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2290;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_in_addr_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2286 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2287 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2288 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2289 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2290 /* class-row */,
};

/* <uint8-t*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L2291;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2292;

extern struct dylanZdylan_visceraZCLS_pair L2293;

extern struct dylanZdylan_visceraZCLS_raw_function L2294;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2295;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2296;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_uint8_tV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2291 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2292 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2293 /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2294 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2295 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2296 /* class-row */,
};

/* <uint8-t<@16>> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L2297;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2298;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L2299;

extern struct dylanZdylan_visceraZCLS_raw_function L2300;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2301;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2302;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_uint8_tLESSX4016GREATER_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2297 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2298 /* direct-superclasses */,
    (heapptr_t) &L2299 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2300 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2301 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L2302 /* class-row */,
};

/* <uint16-t*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L2303;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2304;

extern struct dylanZdylan_visceraZCLS_pair L2305;

extern struct dylanZdylan_visceraZCLS_raw_function L2306;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2307;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2308;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_uint16_tV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2303 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2304 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2305 /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2306 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2307 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2308 /* class-row */,
};

/* <uint16-t<@8>> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L2309;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2310;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L2311;

extern struct dylanZdylan_visceraZCLS_raw_function L2312;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2313;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2314;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_uint16_tLESSX408GREATER_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2309 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2310 /* direct-superclasses */,
    (heapptr_t) &L2311 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2312 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2313 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L2314 /* class-row */,
};

/* <uint32-t*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L2315;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2316;

extern struct dylanZdylan_visceraZCLS_pair L2317;

extern struct dylanZdylan_visceraZCLS_raw_function L2318;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2319;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2320;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_uint32_tV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2315 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2316 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2317 /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2318 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2319 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2320 /* class-row */,
};

/* <uint32-t<@4>> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L2321;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2322;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L2323;

extern struct dylanZdylan_visceraZCLS_raw_function L2324;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2325;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2326;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_uint32_tLESSX404GREATER_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2321 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2322 /* direct-superclasses */,
    (heapptr_t) &L2323 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2324 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2325 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L2326 /* class-row */,
};

/* <anonymous-6> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L2327;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2328;

extern struct dylanZdylan_visceraZCLS_raw_function L2329;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2330;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2331;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_anonymous_6_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2327 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2328 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2329 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2330 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2331 /* class-row */,
};

/* <in6-addr> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L2332;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2333;

extern struct dylanZdylan_visceraZCLS_raw_function L2334;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2335;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2336;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_in6_addr_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2332 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2333 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2334 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2335 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2336 /* class-row */,
};

/* <unsigned-char<@8>> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L2337;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L2338;

extern struct dylanZdylan_visceraZCLS_raw_function L2339;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2340;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2341;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_unsigned_charLESSX408GREATER_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2337 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2077 /* direct-superclasses */,
    (heapptr_t) &L2338 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2339 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2340 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L2341 /* class-row */,
};

/* <sockaddr-in6> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L2342;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2343;

extern struct dylanZdylan_visceraZCLS_raw_function L2344;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2345;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2346;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_sockaddr_in6_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2342 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2343 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2344 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2345 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2346 /* class-row */,
};

/* <ipv6-mreq> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L2347;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2348;

extern struct dylanZdylan_visceraZCLS_raw_function L2349;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2350;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2351;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_ipv6_mreq_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2347 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2348 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2349 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2350 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2351 /* class-row */,
};

/* <in6-pktinfo> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L2352;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2353;

extern struct dylanZdylan_visceraZCLS_raw_function L2354;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2355;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2356;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_in6_pktinfo_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2352 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2353 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2354 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2355 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2356 /* class-row */,
};

/* <char<@40>> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L2357;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L2358;

extern struct dylanZdylan_visceraZCLS_raw_function L2359;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2360;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2361;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2357 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2106 /* direct-superclasses */,
    (heapptr_t) &L2358 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2359 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2360 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    4 /* class-bucket */,
    (heapptr_t) &L2361 /* class-row */,
};

/* <ip-opts> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L2362;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2363;

extern struct dylanZdylan_visceraZCLS_raw_function L2364;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2365;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2366;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_ip_opts_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2362 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2363 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2364 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2365 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2366 /* class-row */,
};

/* <ip-mreq> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L2367;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2368;

extern struct dylanZdylan_visceraZCLS_raw_function L2369;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2370;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2371;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_ip_mreq_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2367 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2368 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2369 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2370 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2371 /* class-row */,
};

/* <ip-mreqn> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L2372;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2373;

extern struct dylanZdylan_visceraZCLS_raw_function L2374;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2375;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2376;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_ip_mreqn_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2372 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2373 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2374 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2375 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2376 /* class-row */,
};

/* <in-pktinfo> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L2377;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2378;

extern struct dylanZdylan_visceraZCLS_raw_function L2379;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2380;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2381;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_in_pktinfo_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2377 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2378 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2379 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2380 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2381 /* class-row */,
};

/* <c-char-pointer-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L2382;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L2383;

extern struct dylanZdylan_visceraZCLS_raw_function L2384;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2385;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2386;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2382 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L2065 /* direct-superclasses */,
    (heapptr_t) &L2383 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2384 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2385 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2386 /* class-row */,
};

/* <hostent> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L2387;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2388;

extern struct dylanZdylan_visceraZCLS_raw_function L2389;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2390;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2391;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_hostent_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2387 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2388 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2389 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2390 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2391 /* class-row */,
};

/* <hostent*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L2392;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2393;

extern struct dylanZdylan_visceraZCLS_raw_function L2394;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2395;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2396;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_hostentV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2392 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2393 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2394 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2395 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2396 /* class-row */,
};

/* <netent> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L2397;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2398;

extern struct dylanZdylan_visceraZCLS_raw_function L2399;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2400;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2401;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_netent_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2397 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2398 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2399 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2400 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2401 /* class-row */,
};

/* <netent*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L2402;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2403;

extern struct dylanZdylan_visceraZCLS_raw_function L2404;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2405;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2406;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_netentV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2402 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2403 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2404 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2405 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2406 /* class-row */,
};

/* <servent> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L2407;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2408;

extern struct dylanZdylan_visceraZCLS_raw_function L2409;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2410;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2411;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_servent_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2407 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2408 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2409 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2410 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2411 /* class-row */,
};

/* <servent*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L2412;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2413;

extern struct dylanZdylan_visceraZCLS_raw_function L2414;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2415;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2416;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_serventV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2412 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2413 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2414 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2415 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2416 /* class-row */,
};

/* <protoent> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L2417;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2418;

extern struct dylanZdylan_visceraZCLS_raw_function L2419;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2420;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2421;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_protoent_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2417 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2418 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2419 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2420 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2421 /* class-row */,
};

/* <protoent*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L2422;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2423;

extern struct dylanZdylan_visceraZCLS_raw_function L2424;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2425;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2426;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_protoentV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2422 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2423 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2424 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2425 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2426 /* class-row */,
};

/* <addrinfo> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L2427;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2428;

extern struct dylanZdylan_visceraZCLS_raw_function L2429;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2430;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2431;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_addrinfo_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2427 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2428 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2429 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2430 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2431 /* class-row */,
};

/* <addrinfo*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L2432;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2433;

extern struct dylanZdylan_visceraZCLS_raw_function L2434;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2435;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2436;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_addrinfoV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2432 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2433 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2434 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2435 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2436 /* class-row */,
};

/* <rpcent> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L2437;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2438;

extern struct dylanZdylan_visceraZCLS_raw_function L2439;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2440;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2441;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_rpcent_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2437 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2438 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2439 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2440 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2441 /* class-row */,
};

/* <rpcent*> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L2442;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2443;

extern struct dylanZdylan_visceraZCLS_raw_function L2444;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2445;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2446;

struct dylanZdylan_visceraZCLS_class networkZnetwork_internalZCLS_rpcentV_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2442 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L1190 /* direct-superclasses */,
    (heapptr_t) &L2443 /* all-superclasses */,
    (heapptr_t) &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    1 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2444 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2445 /* class-slot-overrides */,
    (heapptr_t) &L1183 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2446 /* class-row */,
};

/* <network-address> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L2447;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2448;

extern struct dylanZdylan_visceraZCLS_pair L2449;

extern struct dylanZdylan_visceraZCLS_raw_function L2450;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2451;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2452;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2453;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2454;

struct dylanZdylan_visceraZCLS_class getaddrinfo_testZgetaddrinfo_testZCLS_network_address_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2447 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L8 /* direct-superclasses */,
    (heapptr_t) &L2448 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &L2449 /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2450 /* class-maker */,
    (heapptr_t) &L2451 /* class-new-slot-descriptors */,
    (heapptr_t) &L2452 /* class-slot-overrides */,
    (heapptr_t) &L2453 /* class-all-slot-descriptors */,
    0 /* class-bucket */,
    (heapptr_t) &L2454 /* class-row */,
};

/* <ipv4-network-address> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE22 L2455;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2456;

extern struct dylanZdylan_visceraZCLS_raw_function L2457;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2458;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2459;

struct dylanZdylan_visceraZCLS_class getaddrinfo_testZgetaddrinfo_testZCLS_ipv4_network_address_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2455 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L20 /* direct-superclasses */,
    (heapptr_t) &L2456 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2457 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2458 /* class-slot-overrides */,
    (heapptr_t) &L2453 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L2459 /* class-row */,
};

/* <ipv6-network-address> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE22 L2460;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2461;

extern struct dylanZdylan_visceraZCLS_raw_function L2462;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2463;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L2464;

struct dylanZdylan_visceraZCLS_class getaddrinfo_testZgetaddrinfo_testZCLS_ipv6_network_address_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP /* %object-class */,
    (heapptr_t) &L2460 /* class-name */,
    -1 /* unique-id */,
    (heapptr_t) &L20 /* direct-superclasses */,
    (heapptr_t) &L2461 /* all-superclasses */,
    (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP /* closest-primary-superclass */,
    (heapptr_t) &dylanZempty_list_ROOT /* direct-subclasses */,
    0 /* class-functional? */,
    0 /* class-primary? */,
    0 /* class-abstract? */,
    1 /* class-sealed? */,
    (heapptr_t) &dylan_L1 /* class-deferred-evaluations */,
    (heapptr_t) &dylan_L1 /* class-key-defaulter */,
    (heapptr_t) &L2462 /* class-maker */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* class-new-slot-descriptors */,
    (heapptr_t) &L2463 /* class-slot-overrides */,
    (heapptr_t) &L2453 /* class-all-slot-descriptors */,
    1 /* class-bucket */,
    (heapptr_t) &L2464 /* class-row */,
};

/* #"address-family" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L2465;

struct dylanZdylan_visceraZCLS_symbol SYM_address_family_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L2465, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_synchronizeQUERY_HEAP /* symbol-next */,
};

/* #"sockaddr" */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L2466;

struct dylanZdylan_visceraZCLS_symbol SYM_sockaddr_HEAP = {
    (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP /* %object-class */,
    { (heapptr_t) &L2466, { 0 } } /* symbol-string */,
    0 /* symbol-hashing */,
    (heapptr_t) &SYM_address_family_HEAP /* symbol-next */,
};

/* "Cheap-Err" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L67 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    9 /* size */,
    "Cheap-Err",
};

/* "Cheap-IO" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L68 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    8 /* size */,
    "Cheap-IO",
};

/* "<not-supplied-marker>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L69 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    21 /* size */,
    "<not-supplied-marker>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L70 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_not_supplied_marker_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
    },
};

/* maker for <not-supplied-marker> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE31 L2467;

extern descriptor_t * dylanZdylan_visceraZCLS_not_supplied_marker_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2468;

struct dylanZdylan_visceraZCLS_raw_function L71 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2467 /* function-name */,
    dylanZdylan_visceraZCLS_not_supplied_marker_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &L2468 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor {
    heapptr_t PCTobject_class;	 /* %object-class */
    descriptor_t override_init_value;	 /* override-init-value */
    heapptr_t override_init_function;	 /* override-init-function */
} L2469;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L72 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2469, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L73 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L74 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 60 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<symbol>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L75 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    8 /* size */,
    "<symbol>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L76 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_symbol_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
    },
};

/* maker for <symbol> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L2470;

extern descriptor_t * dylanZdylan_visceraZCLS_symbol_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2471;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2472;

struct dylanZdylan_visceraZCLS_raw_function L77 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2470 /* function-name */,
    dylanZdylan_visceraZCLS_symbol_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2471 /* function-keywords */,
    (heapptr_t) &L2472 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_symbolZdylanZdylan_visceraZsymbol_string_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_symbolZdylanZdylan_visceraZsymbol_hashing_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_symbolZdylanZdylan_visceraZsymbol_next_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L78 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_symbolZdylanZdylan_visceraZsymbol_string_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_symbolZdylanZdylan_visceraZsymbol_hashing_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_symbolZdylanZdylan_visceraZsymbol_next_SLOT_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2473;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L79 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2473, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L80 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    4 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_symbolZdylanZdylan_visceraZsymbol_string_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_symbolZdylanZdylan_visceraZsymbol_hashing_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_symbolZdylanZdylan_visceraZsymbol_next_SLOT_HEAP, { 0 } } /* %element[3] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L81 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 58 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "=" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE1 L82 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    1 /* size */,
    "=",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L83 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_boolean_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method melange_support_L65;

extern struct dylanZdylan_visceraZCLS_pair L2474;

struct dylanZdylan_visceraZCLS_pair L84 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &melange_support_L65, { 0 } } /* head */,
    { (heapptr_t) &L2474, { 0 } } /* tail */,
};

/* "<not-found-marker>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L85 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    18 /* size */,
    "<not-found-marker>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L86 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_not_found_marker_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
    },
};

/* maker for <not-found-marker> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE28 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    unsigned char PCTelement[28];	 /* %element */
} L2475;

extern descriptor_t * dylanZdylan_visceraZCLS_not_found_marker_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2476;

struct dylanZdylan_visceraZCLS_raw_function L87 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2475 /* function-name */,
    dylanZdylan_visceraZCLS_not_found_marker_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &L2476 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2477;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L88 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2477, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L89 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 62 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "make" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L90 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    4 /* size */,
    "make",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L91 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2478;

struct dylanZdylan_visceraZCLS_pair L92 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &L4, { 0 } } /* head */,
    { (heapptr_t) &L2478, { 0 } } /* tail */,
};

/* "<simple-object-vector>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE22 L93 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    22 /* size */,
    "<simple-object-vector>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L94 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_simple_vector_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L95 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    9 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_simple_vector_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_vector_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_array_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[8] */,
    },
};

/* maker for <simple-object-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE32 L2479;

extern descriptor_t * dylanZdylan_visceraZCLS_simple_object_vector_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2480;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2481;

struct dylanZdylan_visceraZCLS_raw_function L96 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2479 /* function-name */,
    dylanZdylan_visceraZCLS_simple_object_vector_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2480 /* function-keywords */,
    (heapptr_t) &L2481 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_simple_object_vectorZdylanZdylan_visceraZsize_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_simple_object_vectorZdylanZdylan_visceraZPCTelement_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L97 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vectorZdylanZdylan_visceraZsize_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vectorZdylanZdylan_visceraZPCTelement_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2482;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L98 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2482, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L99 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vectorZdylanZdylan_visceraZsize_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vectorZdylanZdylan_visceraZPCTelement_SLOT_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L100 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 3 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 69 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "as" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE2 L101 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    2 /* size */,
    "as",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L102 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method string_extensions_L57;

extern struct dylanZdylan_visceraZCLS_pair L2483;

struct dylanZdylan_visceraZCLS_pair L103 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &string_extensions_L57, { 0 } } /* head */,
    { (heapptr_t) &L2483, { 0 } } /* tail */,
};

/* "<sequence>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L104 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    10 /* size */,
    "<sequence>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L105 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L106 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2484;

struct dylanZdylan_visceraZCLS_pair L107 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &collection_extensionsZsubseqZCLS_subsequence_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2484, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L108 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 0 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<double-integer>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L109 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    16 /* size */,
    "<double-integer>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L110 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_general_integer_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L111 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    7 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_double_integer_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_general_integer_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_rational_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_real_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_complex_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_number_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[6] */,
    },
};

/* maker for <double-integer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE26 L2485;

extern descriptor_t * dylanZdylan_visceraZCLS_double_integer_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2486;

struct dylanZdylan_visceraZCLS_raw_function L112 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2485 /* function-name */,
    dylanZdylan_visceraZCLS_double_integer_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &L2486 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_double_integerZdylanZdylan_visceraZvalue_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L113 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_double_integerZdylanZdylan_visceraZvalue_SLOT_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2488;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L114 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2488, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L115 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_double_integerZdylanZdylan_visceraZvalue_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L116 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 43 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 26 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 9 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 10 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 9 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 10 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<double-float>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L117 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    14 /* size */,
    "<double-float>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L118 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_float_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L119 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    6 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_double_float_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_float_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_real_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_complex_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_number_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[5] */,
    },
};

/* maker for <double-float> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE24 L2489;

extern descriptor_t * dylanZdylan_visceraZCLS_double_float_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2490;

struct dylanZdylan_visceraZCLS_raw_function L120 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2489 /* function-name */,
    dylanZdylan_visceraZCLS_double_float_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &L2490 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_double_floatZdylanZdylan_visceraZvalue_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L121 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_double_floatZdylanZdylan_visceraZvalue_SLOT_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2492;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L122 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2492, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L123 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_double_floatZdylanZdylan_visceraZvalue_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L124 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 43 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 26 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 9 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 11 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 6 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<extended-float>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L125 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    16 /* size */,
    "<extended-float>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L126 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    6 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_extended_float_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_float_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_real_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_complex_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_number_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[5] */,
    },
};

/* maker for <extended-float> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE26 L2493;

extern descriptor_t * dylanZdylan_visceraZCLS_extended_float_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2494;

struct dylanZdylan_visceraZCLS_raw_function L127 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2493 /* function-name */,
    dylanZdylan_visceraZCLS_extended_float_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &L2494 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_extended_floatZdylanZdylan_visceraZvalue_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L128 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_extended_floatZdylanZdylan_visceraZvalue_SLOT_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2496;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L129 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2496, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L130 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_extended_floatZdylanZdylan_visceraZvalue_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L131 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 43 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 26 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 9 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 11 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 7 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<boolean>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L132 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    9 /* size */,
    "<boolean>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L133 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_boolean_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2497;

struct dylanZdylan_visceraZCLS_pair L134 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_false_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2497, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L135 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 61 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<true>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L136 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    6 /* size */,
    "<true>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L137 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_true_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_boolean_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* maker for <true> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L2498;

extern descriptor_t * dylanZdylan_visceraZCLS_true_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2499;

struct dylanZdylan_visceraZCLS_raw_function L138 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2498 /* function-name */,
    dylanZdylan_visceraZCLS_true_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &L2499 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2500;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L139 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2500, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L140 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 61 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 28 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<false>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L141 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    7 /* size */,
    "<false>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L142 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_false_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_boolean_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* maker for <false> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L2501;

extern descriptor_t * dylanZdylan_visceraZCLS_false_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2502;

struct dylanZdylan_visceraZCLS_raw_function L143 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2501 /* function-name */,
    dylanZdylan_visceraZCLS_false_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &L2502 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2503;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L144 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2503, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L145 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 61 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 27 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "functional-==" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L146 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    13 /* size */,
    "functional-==",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L147 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method melange_support_L12;

extern struct dylanZdylan_visceraZCLS_pair L2504;

struct dylanZdylan_visceraZCLS_pair L148 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &melange_support_L12, { 0 } } /* head */,
    { (heapptr_t) &L2504, { 0 } } /* tail */,
};

/* "<" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE1 L149 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    1 /* size */,
    "<",
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method melange_support_L64;

extern struct dylanZdylan_visceraZCLS_pair L2505;

struct dylanZdylan_visceraZCLS_pair L150 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &melange_support_L64, { 0 } } /* head */,
    { (heapptr_t) &L2505, { 0 } } /* tail */,
};

/* "<single-float>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L151 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    14 /* size */,
    "<single-float>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L152 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    6 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_single_float_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_float_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_real_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_complex_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_number_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[5] */,
    },
};

/* maker for <single-float> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE24 L2506;

extern descriptor_t * dylanZdylan_visceraZCLS_single_float_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2507;

struct dylanZdylan_visceraZCLS_raw_function L153 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2506 /* function-name */,
    dylanZdylan_visceraZCLS_single_float_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &L2507 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_single_floatZdylanZdylan_visceraZvalue_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L154 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_single_floatZdylanZdylan_visceraZvalue_SLOT_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2509;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L155 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2509, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L156 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_single_floatZdylanZdylan_visceraZvalue_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L157 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 43 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 26 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 9 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 11 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 5 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<type>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L158 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    6 /* size */,
    "<type>",
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2510;

struct dylanZdylan_visceraZCLS_pair L159 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2510, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L160 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 45 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<union>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L161 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    7 /* size */,
    "<union>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L162 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_union_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* maker for <union> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L2511;

extern descriptor_t * dylanZdylan_visceraZCLS_union_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2512;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2513;

struct dylanZdylan_visceraZCLS_raw_function L163 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2511 /* function-name */,
    dylanZdylan_visceraZCLS_union_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2512 /* function-keywords */,
    (heapptr_t) &L2513 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_unionZdylanZdylan_visceraZunion_members_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_unionZdylanZdylan_visceraZunion_singletons_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L164 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_unionZdylanZdylan_visceraZunion_members_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_unionZdylanZdylan_visceraZunion_singletons_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2514;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L165 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2514, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L166 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_unionZdylanZdylan_visceraZunion_members_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_unionZdylanZdylan_visceraZunion_singletons_SLOT_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L167 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 45 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 22 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "members" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L168 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    7 /* size */,
    "members",
};

/* "singletons" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L169 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    10 /* size */,
    "singletons",
};

/* "<empty-list>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L170 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    12 /* size */,
    "<empty-list>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L171 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_list_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L172 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    7 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_empty_list_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_list_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[6] */,
    },
};

/* maker for <empty-list> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE22 L2515;

extern descriptor_t * dylanZdylan_visceraZCLS_empty_list_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2516;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2517;

struct dylanZdylan_visceraZCLS_raw_function L173 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2515 /* function-name */,
    dylanZdylan_visceraZCLS_empty_list_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2516 /* function-keywords */,
    (heapptr_t) &L2517 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2518;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L174 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2518, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_listZdylanZdylan_visceraZhead_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_listZdylanZdylan_visceraZtail_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L175 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_listZdylanZdylan_visceraZhead_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_listZdylanZdylan_visceraZtail_SLOT_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L176 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 127 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 53 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<pair>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L177 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    6 /* size */,
    "<pair>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L178 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    7 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_list_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[6] */,
    },
};

/* maker for <pair> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L2519;

extern descriptor_t * dylanZdylan_visceraZCLS_pair_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2520;

struct dylanZdylan_visceraZCLS_raw_function L179 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2519 /* function-name */,
    dylanZdylan_visceraZCLS_pair_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2516 /* function-keywords */,
    (heapptr_t) &L2520 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2521;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L180 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2521, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L181 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 127 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 52 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<list>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L182 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    6 /* size */,
    "<list>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L183 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L184 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    6 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_list_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[5] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2522;

struct dylanZdylan_visceraZCLS_pair L185 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2522, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L186 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_listZdylanZdylan_visceraZhead_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_listZdylanZdylan_visceraZtail_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L187 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 127 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<direct-instance>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L188 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    17 /* size */,
    "<direct-instance>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L189 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_direct_instance_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* maker for <direct-instance> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE27 L2523;

extern descriptor_t * dylanZdylan_visceraZCLS_direct_instance_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2524;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2525;

struct dylanZdylan_visceraZCLS_raw_function L190 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2523 /* function-name */,
    dylanZdylan_visceraZCLS_direct_instance_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2524 /* function-keywords */,
    (heapptr_t) &L2525 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_direct_instanceZdylanZdylan_visceraZdirect_instance_of_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L191 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_direct_instanceZdylanZdylan_visceraZdirect_instance_of_SLOT_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2526;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L192 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2526, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L193 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_direct_instanceZdylanZdylan_visceraZdirect_instance_of_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L194 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 45 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 21 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "of" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE2 L195 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    2 /* size */,
    "of",
};

/* "<designator-class>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L196 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    18 /* size */,
    "<designator-class>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L197 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L198 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    4 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_designator_class_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[3] */,
    },
};

/* maker for <designator-class> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE28 L2527;

extern descriptor_t * dylanZdylan_visceraZCLS_designator_class_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE15 {
    heapptr_t PCTobject_class;	 /* %object-class */
    long size;	 /* size */
    descriptor_t PCTelement[15];	 /* %element */
} L2528;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2529;

struct dylanZdylan_visceraZCLS_raw_function L199 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2527 /* function-name */,
    dylanZdylan_visceraZCLS_designator_class_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2528 /* function-keywords */,
    (heapptr_t) &L2529 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_designator_classZdylanZdylan_visceraZsize_of_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_designator_classZdylanZdylan_visceraZalignment_of_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_designator_classZdylanZdylan_visceraZreferenced_type_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_designator_classZdylanZdylan_visceraZclass_struct_slot_descriptors_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L200 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    4 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_designator_classZdylanZdylan_visceraZsize_of_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_designator_classZdylanZdylan_visceraZalignment_of_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_designator_classZdylanZdylan_visceraZreferenced_type_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_designator_classZdylanZdylan_visceraZclass_struct_slot_descriptors_SLOT_HEAP, { 0 } } /* %element[3] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2530;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L201 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2530, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_name_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZunique_id_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZdirect_superclasses_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZall_superclasses_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclosest_primary_superclass_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZdirect_subclasses_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_functionalQUERY_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_primaryQUERY_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_abstractQUERY_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_sealedQUERY_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_deferred_evaluations_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_key_defaulter_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_maker_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_new_slot_descriptors_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_slot_overrides_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_all_slot_descriptors_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_bucket_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_row_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE23 L202 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    23 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_name_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZunique_id_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZdirect_superclasses_SLOT_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZall_superclasses_SLOT_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclosest_primary_superclass_SLOT_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZdirect_subclasses_SLOT_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_functionalQUERY_SLOT_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_primaryQUERY_SLOT_HEAP, { 0 } } /* %element[8] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_abstractQUERY_SLOT_HEAP, { 0 } } /* %element[9] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_sealedQUERY_SLOT_HEAP, { 0 } } /* %element[10] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_deferred_evaluations_SLOT_HEAP, { 0 } } /* %element[11] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_key_defaulter_SLOT_HEAP, { 0 } } /* %element[12] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_maker_SLOT_HEAP, { 0 } } /* %element[13] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_new_slot_descriptors_SLOT_HEAP, { 0 } } /* %element[14] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_slot_overrides_SLOT_HEAP, { 0 } } /* %element[15] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_all_slot_descriptors_SLOT_HEAP, { 0 } } /* %element[16] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_bucket_SLOT_HEAP, { 0 } } /* %element[17] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_row_SLOT_HEAP, { 0 } } /* %element[18] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_designator_classZdylanZdylan_visceraZsize_of_SLOT_HEAP, { 0 } } /* %element[19] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_designator_classZdylanZdylan_visceraZalignment_of_SLOT_HEAP, { 0 } } /* %element[20] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_designator_classZdylanZdylan_visceraZreferenced_type_SLOT_HEAP, { 0 } } /* %element[21] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_designator_classZdylanZdylan_visceraZclass_struct_slot_descriptors_SLOT_HEAP, { 0 } } /* %element[22] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L203 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 45 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 25 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 21 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<class>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L204 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    7 /* size */,
    "<class>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L205 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_class_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <pair>} */
struct dylanZdylan_visceraZCLS_pair L206 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_designator_class_HEAP, { 0 } } /* head */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* tail */,
};

/* maker for <class> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L2531;

extern descriptor_t * dylanZdylan_visceraZCLS_class_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L2532;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2533;

struct dylanZdylan_visceraZCLS_raw_function L207 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2531 /* function-name */,
    dylanZdylan_visceraZCLS_class_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2532 /* function-keywords */,
    (heapptr_t) &L2533 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE18 L208 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    18 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_name_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZunique_id_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZdirect_superclasses_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZall_superclasses_SLOT_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclosest_primary_superclass_SLOT_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZdirect_subclasses_SLOT_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_functionalQUERY_SLOT_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_primaryQUERY_SLOT_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_abstractQUERY_SLOT_HEAP, { 0 } } /* %element[8] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_sealedQUERY_SLOT_HEAP, { 0 } } /* %element[9] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_deferred_evaluations_SLOT_HEAP, { 0 } } /* %element[10] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_key_defaulter_SLOT_HEAP, { 0 } } /* %element[11] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_maker_SLOT_HEAP, { 0 } } /* %element[12] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_new_slot_descriptors_SLOT_HEAP, { 0 } } /* %element[13] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_slot_overrides_SLOT_HEAP, { 0 } } /* %element[14] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_all_slot_descriptors_SLOT_HEAP, { 0 } } /* %element[15] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_bucket_SLOT_HEAP, { 0 } } /* %element[16] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_row_SLOT_HEAP, { 0 } } /* %element[17] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2534;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L209 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2534, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE19 L210 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    19 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_name_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZunique_id_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZdirect_superclasses_SLOT_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZall_superclasses_SLOT_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclosest_primary_superclass_SLOT_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZdirect_subclasses_SLOT_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_functionalQUERY_SLOT_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_primaryQUERY_SLOT_HEAP, { 0 } } /* %element[8] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_abstractQUERY_SLOT_HEAP, { 0 } } /* %element[9] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_sealedQUERY_SLOT_HEAP, { 0 } } /* %element[10] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_deferred_evaluations_SLOT_HEAP, { 0 } } /* %element[11] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_key_defaulter_SLOT_HEAP, { 0 } } /* %element[12] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_maker_SLOT_HEAP, { 0 } } /* %element[13] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_new_slot_descriptors_SLOT_HEAP, { 0 } } /* %element[14] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_slot_overrides_SLOT_HEAP, { 0 } } /* %element[15] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_all_slot_descriptors_SLOT_HEAP, { 0 } } /* %element[16] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_bucket_SLOT_HEAP, { 0 } } /* %element[17] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_classZdylanZdylan_visceraZclass_row_SLOT_HEAP, { 0 } } /* %element[18] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L211 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 45 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 25 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<subclass>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L212 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    10 /* size */,
    "<subclass>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L213 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_subclass_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* maker for <subclass> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L2535;

extern descriptor_t * dylanZdylan_visceraZCLS_subclass_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2536;

struct dylanZdylan_visceraZCLS_raw_function L214 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2535 /* function-name */,
    dylanZdylan_visceraZCLS_subclass_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2524 /* function-keywords */,
    (heapptr_t) &L2536 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_subclassZdylanZdylan_visceraZsubclass_of_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L215 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_subclassZdylanZdylan_visceraZsubclass_of_SLOT_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2537;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L216 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2537, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L217 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_subclassZdylanZdylan_visceraZsubclass_of_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L218 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 45 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 24 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<singleton>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L219 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    11 /* size */,
    "<singleton>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L220 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_singleton_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* maker for <singleton> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L2538;

extern descriptor_t * dylanZdylan_visceraZCLS_singleton_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2539;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2540;

struct dylanZdylan_visceraZCLS_raw_function L221 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2538 /* function-name */,
    dylanZdylan_visceraZCLS_singleton_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2539 /* function-keywords */,
    (heapptr_t) &L2540 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_singletonZdylanZdylan_visceraZsingleton_object_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L222 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_singletonZdylanZdylan_visceraZsingleton_object_SLOT_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2541;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L223 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2541, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L224 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_singletonZdylanZdylan_visceraZsingleton_object_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L225 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 45 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 23 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "object" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L226 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    6 /* size */,
    "object",
};

/* "<limited-type>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L227 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    14 /* size */,
    "<limited-type>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L228 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_type_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2542;

struct dylanZdylan_visceraZCLS_pair L229 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_limited_collection_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2542, { 0 } } /* tail */,
};

/* maker for <limited-type> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE24 L2543;

extern descriptor_t * dylanZdylan_visceraZCLS_limited_type_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2544;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2545;

struct dylanZdylan_visceraZCLS_raw_function L230 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2543 /* function-name */,
    dylanZdylan_visceraZCLS_limited_type_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2544 /* function-keywords */,
    (heapptr_t) &L2545 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_limited_typeZdylanZdylan_visceraZlimited_integer_base_class_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L231 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_typeZdylanZdylan_visceraZlimited_integer_base_class_SLOT_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2546;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L232 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2546, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L233 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_typeZdylanZdylan_visceraZlimited_integer_base_class_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L234 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 45 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 20 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "base-class" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L235 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    10 /* size */,
    "base-class",
};

/* "<limited-integer>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L236 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    17 /* size */,
    "<limited-integer>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L237 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_type_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L238 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    4 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_integer_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_type_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[3] */,
    },
};

/* maker for <limited-integer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE27 L2547;

extern descriptor_t * dylanZdylan_visceraZCLS_limited_integer_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2548;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2549;

struct dylanZdylan_visceraZCLS_raw_function L239 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2547 /* function-name */,
    dylanZdylan_visceraZCLS_limited_integer_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2548 /* function-keywords */,
    (heapptr_t) &L2549 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_limited_integerZdylanZdylan_visceraZlimited_integer_minimum_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_limited_integerZdylanZdylan_visceraZlimited_integer_maximum_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L240 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_integerZdylanZdylan_visceraZlimited_integer_minimum_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_integerZdylanZdylan_visceraZlimited_integer_maximum_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2550;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L241 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2550, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L242 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    4 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_typeZdylanZdylan_visceraZlimited_integer_base_class_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_integerZdylanZdylan_visceraZlimited_integer_minimum_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_integerZdylanZdylan_visceraZlimited_integer_maximum_SLOT_HEAP, { 0 } } /* %element[3] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L243 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 45 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 20 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 8 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "max" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE3 L244 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    3 /* size */,
    "max",
};

/* "min" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE3 L245 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    3 /* size */,
    "min",
};

/* "<integer>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L246 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    9 /* size */,
    "<integer>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L247 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    7 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_integer_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_general_integer_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_rational_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_real_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_complex_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_number_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[6] */,
    },
};

/* maker for <integer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L2551;

extern descriptor_t * dylanZdylan_visceraZCLS_integer_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2552;

struct dylanZdylan_visceraZCLS_raw_function L248 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2551 /* function-name */,
    dylanZdylan_visceraZCLS_integer_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &L2552 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_integerZdylanZdylan_visceraZvalue_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L249 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_integerZdylanZdylan_visceraZvalue_SLOT_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2554;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L250 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2554, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L251 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_integerZdylanZdylan_visceraZvalue_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L252 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 43 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 26 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 9 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 10 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 9 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 9 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<extended-integer>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L253 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    18 /* size */,
    "<extended-integer>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L254 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    7 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_extended_integer_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_general_integer_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_rational_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_real_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_complex_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_number_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[6] */,
    },
};

/* maker for <extended-integer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE28 L2555;

extern descriptor_t * dylanZdylan_visceraZCLS_extended_integer_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2556;

struct dylanZdylan_visceraZCLS_raw_function L255 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2555 /* function-name */,
    dylanZdylan_visceraZCLS_extended_integer_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2480 /* function-keywords */,
    (heapptr_t) &L2556 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_extended_integerZdylanZdylan_visceraZbignum_size_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_extended_integerZdylanZdylan_visceraZbignum_digit_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L256 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_extended_integerZdylanZdylan_visceraZbignum_size_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_extended_integerZdylanZdylan_visceraZbignum_digit_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2557;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L257 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2557, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L258 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_extended_integerZdylanZdylan_visceraZbignum_size_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_extended_integerZdylanZdylan_visceraZbignum_digit_SLOT_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L259 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 43 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 26 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 9 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 10 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 9 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 11 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<general-integer>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L260 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    17 /* size */,
    "<general-integer>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L261 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_rational_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L262 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    6 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_general_integer_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_rational_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_real_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_complex_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_number_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[5] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2558;

struct dylanZdylan_visceraZCLS_pair L263 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_integer_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2558, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L264 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 43 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 26 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 9 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 10 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 9 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "+" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE1 L265 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    1 /* size */,
    "+",
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method melange_support_L46;

extern struct dylanZdylan_visceraZCLS_pair L2559;

struct dylanZdylan_visceraZCLS_pair L266 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &melange_support_L46, { 0 } } /* head */,
    { (heapptr_t) &L2559, { 0 } } /* tail */,
};

/* "-" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE1 L267 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    1 /* size */,
    "-",
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method melange_support_L47;

extern struct dylanZdylan_visceraZCLS_pair L2560;

struct dylanZdylan_visceraZCLS_pair L268 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &melange_support_L47, { 0 } } /* head */,
    { (heapptr_t) &L2560, { 0 } } /* tail */,
};

/* "<limited-collection>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L269 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    20 /* size */,
    "<limited-collection>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L270 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    4 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_collection_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_type_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[3] */,
    },
};

/* maker for <limited-collection> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE30 L2561;

extern descriptor_t * dylanZdylan_visceraZCLS_limited_collection_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L2562;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2563;

struct dylanZdylan_visceraZCLS_raw_function L271 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2561 /* function-name */,
    dylanZdylan_visceraZCLS_limited_collection_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2562 /* function-keywords */,
    (heapptr_t) &L2563 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_limited_collectionZdylanZdylan_visceraZlimited_element_type_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_limited_collectionZdylanZdylan_visceraZlimited_size_restriction_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_limited_collectionZdylanZdylan_visceraZlimited_dimensions_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L272 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_collectionZdylanZdylan_visceraZlimited_element_type_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_collectionZdylanZdylan_visceraZlimited_size_restriction_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_collectionZdylanZdylan_visceraZlimited_dimensions_SLOT_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2564;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L273 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2564, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L274 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    5 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_typeZdylanZdylan_visceraZlimited_integer_base_class_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_collectionZdylanZdylan_visceraZlimited_element_type_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_collectionZdylanZdylan_visceraZlimited_size_restriction_SLOT_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_collectionZdylanZdylan_visceraZlimited_dimensions_SLOT_HEAP, { 0 } } /* %element[4] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L275 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 45 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 20 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 11 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "size" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L276 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    4 /* size */,
    "size",
};

/* "dimensions" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L277 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    10 /* size */,
    "dimensions",
};

/* "<object>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L278 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    8 /* size */,
    "<object>",
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2565;

struct dylanZdylan_visceraZCLS_pair L279 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &getaddrinfo_testZgetaddrinfo_testZCLS_network_address_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2565, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L280 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 0 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<real>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L281 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    6 /* size */,
    "<real>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L282 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_complex_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L283 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    4 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_real_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_complex_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_number_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[3] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2566;

struct dylanZdylan_visceraZCLS_pair L284 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_rational_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2566, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L285 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 43 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 26 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 9 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<character>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE11 L286 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    11 /* size */,
    "<character>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L287 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_character_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
    },
};

/* maker for <character> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L2567;

extern descriptor_t * dylanZdylan_visceraZCLS_character_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2568;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2569;

struct dylanZdylan_visceraZCLS_raw_function L288 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2567 /* function-name */,
    dylanZdylan_visceraZCLS_character_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2568 /* function-keywords */,
    (heapptr_t) &L2569 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_characterZdylanZdylan_visceraZvalue_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L289 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_characterZdylanZdylan_visceraZvalue_SLOT_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2571;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L290 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2571, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L291 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_characterZdylanZdylan_visceraZvalue_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L292 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 68 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<byte-string>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L293 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    13 /* size */,
    "<byte-string>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L294 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_string_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_vector_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L295 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    9 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_string_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_vector_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_array_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[8] */,
    },
};

/* maker for <byte-string> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L2572;

extern descriptor_t * dylanZdylan_visceraZCLS_byte_string_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2573;

struct dylanZdylan_visceraZCLS_raw_function L296 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2572 /* function-name */,
    dylanZdylan_visceraZCLS_byte_string_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2480 /* function-keywords */,
    (heapptr_t) &L2573 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_byte_stringZdylanZdylan_visceraZsize_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_byte_stringZdylanZdylan_visceraZPCTelement_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L297 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_byte_stringZdylanZdylan_visceraZsize_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_byte_stringZdylanZdylan_visceraZPCTelement_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2574;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L298 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2574, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L299 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_byte_stringZdylanZdylan_visceraZsize_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_byte_stringZdylanZdylan_visceraZPCTelement_SLOT_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L300 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 147 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<unicode-string>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L301 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    16 /* size */,
    "<unicode-string>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L302 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    9 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_unicode_string_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_string_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_vector_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_array_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[8] */,
    },
};

/* maker for <unicode-string> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE26 L2575;

extern descriptor_t * dylanZdylan_visceraZCLS_unicode_string_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2576;

struct dylanZdylan_visceraZCLS_raw_function L303 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2575 /* function-name */,
    dylanZdylan_visceraZCLS_unicode_string_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2480 /* function-keywords */,
    (heapptr_t) &L2576 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_unicode_stringZdylanZdylan_visceraZsize_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_unicode_stringZdylanZdylan_visceraZPCTelement_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L304 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_unicode_stringZdylanZdylan_visceraZsize_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_unicode_stringZdylanZdylan_visceraZPCTelement_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2577;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L305 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2577, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L306 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_unicode_stringZdylanZdylan_visceraZsize_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_unicode_stringZdylanZdylan_visceraZPCTelement_SLOT_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L307 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 146 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "element-type" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L308 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    12 /* size */,
    "element-type",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L309 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_boolean_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method dylan_L1027;

extern struct dylanZdylan_visceraZCLS_pair L2578;

struct dylanZdylan_visceraZCLS_pair L310 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylan_L1027, { 0 } } /* head */,
    { (heapptr_t) &L2578, { 0 } } /* tail */,
};

/* "<collection>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L311 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    12 /* size */,
    "<collection>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L312 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2579;

struct dylanZdylan_visceraZCLS_pair L313 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &string_extensionsZstring_hackingZCLS_character_set_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2579, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L314 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 0 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<explicit-key-collection>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE25 L315 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    25 /* size */,
    "<explicit-key-collection>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L316 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_explicit_key_collection_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <pair>} */
struct dylanZdylan_visceraZCLS_pair L317 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_mutable_explicit_key_collection_HEAP, { 0 } } /* head */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L318 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 0 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 4 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<mutable-collection>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE20 L319 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    20 /* size */,
    "<mutable-collection>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L320 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2580;

struct dylanZdylan_visceraZCLS_pair L321 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &collection_extensionsZsde_vectorZCLS_sde_vector_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2580, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L322 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 0 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<stretchy-collection>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L323 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    21 /* size */,
    "<stretchy-collection>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L324 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_collection_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2581;

struct dylanZdylan_visceraZCLS_pair L325 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &collection_extensionsZsde_vectorZCLS_sde_vector_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2581, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L326 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 0 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 2 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<mutable-explicit-key-collection>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE33 L327 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    33 /* size */,
    "<mutable-explicit-key-collection>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L328 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_explicit_key_collection_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L329 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    5 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_explicit_key_collection_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_explicit_key_collection_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[4] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2582;

struct dylanZdylan_visceraZCLS_pair L330 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &string_extensionsZstring_hackingZCLS_byte_character_table_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2582, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L331 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 0 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 3 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 4 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<mutable-sequence>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L332 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    18 /* size */,
    "<mutable-sequence>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L333 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L334 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    5 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[4] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2583;

struct dylanZdylan_visceraZCLS_pair L335 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_deque_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2583, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L336 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 0 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<table>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L337 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    7 /* size */,
    "<table>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L338 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_explicit_key_collection_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_collection_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L339 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    7 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_table_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_explicit_key_collection_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_explicit_key_collection_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_collection_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[6] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2584;

struct dylanZdylan_visceraZCLS_pair L340 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &regular_expressionsZregular_expressionsZCLS_regexp_cache_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2584, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_tableZdylanZdylan_visceraZtable_size_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_tableZdylanZdylan_visceraZlower_resize_trigger_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_tableZdylanZdylan_visceraZupper_resize_trigger_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_tableZdylanZdylan_visceraZbuckets_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L341 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    4 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_tableZdylanZdylan_visceraZtable_size_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_tableZdylanZdylan_visceraZlower_resize_trigger_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_tableZdylanZdylan_visceraZupper_resize_trigger_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_tableZdylanZdylan_visceraZbuckets_SLOT_HEAP, { 0 } } /* %element[3] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE5 L342 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    5 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_tableZdylanZdylan_visceraZtable_size_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_tableZdylanZdylan_visceraZlower_resize_trigger_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_tableZdylanZdylan_visceraZupper_resize_trigger_SLOT_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_tableZdylanZdylan_visceraZbuckets_SLOT_HEAP, { 0 } } /* %element[4] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L343 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 0 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 4 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 3 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 4 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 2 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<object-table>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L344 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    14 /* size */,
    "<object-table>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L345 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_table_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L346 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    8 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_table_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_table_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_explicit_key_collection_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_explicit_key_collection_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_collection_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[7] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2585;

struct dylanZdylan_visceraZCLS_pair L347 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_table_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2585, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L348 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 4 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 4 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 3 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 4 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 2 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<array>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L349 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    7 /* size */,
    "<array>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L350 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    6 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_array_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[5] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2586;

struct dylanZdylan_visceraZCLS_pair L351 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_array_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2586, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L352 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 0 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<vector>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L353 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    8 /* size */,
    "<vector>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L354 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_array_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE7 L355 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    7 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_vector_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_array_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[6] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2587;

struct dylanZdylan_visceraZCLS_pair L356 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &collection_extensionsZsubseqZCLS_vector_subsequence_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2587, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L357 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 0 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<simple-vector>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L358 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    15 /* size */,
    "<simple-vector>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L359 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    8 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_simple_vector_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_vector_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_array_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[7] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2588;

struct dylanZdylan_visceraZCLS_pair L360 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2588, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L361 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 3 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<stretchy-vector>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L362 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    17 /* size */,
    "<stretchy-vector>",
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_class dylanZdylan_visceraZCLS_stretchy_sequence_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L363 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_sequence_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_vector_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L364 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    10 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_vector_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_sequence_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_collection_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_vector_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_array_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[8] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[9] */,
    },
};

/* {a <pair>} */
struct dylanZdylan_visceraZCLS_pair L365 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_builtin_stretchy_vector_HEAP, { 0 } } /* head */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L366 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 8 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 54 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 2 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<deque>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L367 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    7 /* size */,
    "<deque>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L368 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_sequence_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L369 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    8 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_deque_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_sequence_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_stretchy_collection_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[7] */,
    },
};

/* {a <pair>} */
struct dylanZdylan_visceraZCLS_pair L370 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_deque_HEAP, { 0 } } /* head */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L371 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 8 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 50 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 2 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<string>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L372 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    8 /* size */,
    "<string>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE6 L373 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    6 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_string_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[5] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2590;

struct dylanZdylan_visceraZCLS_pair L374 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &collection_extensionsZsubseqZCLS_string_subsequence_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2590, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L375 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 0 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<range>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L376 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    7 /* size */,
    "<range>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L377 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L378 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    4 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_range_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[3] */,
    },
};

/* {a <pair>} */
struct dylanZdylan_visceraZCLS_pair L379 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_builtin_range_HEAP, { 0 } } /* head */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L380 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 125 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<byte-character-type>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L381 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    21 /* size */,
    "<byte-character-type>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L382 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_byte_character_type_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* maker for <byte-character-type> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE31 L2591;

extern descriptor_t * dylanZdylan_visceraZCLS_byte_character_type_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2592;

struct dylanZdylan_visceraZCLS_raw_function L383 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2591 /* function-name */,
    dylanZdylan_visceraZCLS_byte_character_type_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-keywords */,
    (heapptr_t) &L2592 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2593;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L384 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2593, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L385 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 45 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 18 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<none-of>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L386 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    9 /* size */,
    "<none-of>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L387 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_none_of_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* maker for <none-of> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L2594;

extern descriptor_t * dylanZdylan_visceraZCLS_none_of_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2595;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2596;

struct dylanZdylan_visceraZCLS_raw_function L388 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2594 /* function-name */,
    dylanZdylan_visceraZCLS_none_of_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2595 /* function-keywords */,
    (heapptr_t) &L2596 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_none_ofZdylanZdylan_visceraZbase_type_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_none_ofZdylanZdylan_visceraZexcluded_types_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L389 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_none_ofZdylanZdylan_visceraZbase_type_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_none_ofZdylanZdylan_visceraZexcluded_types_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2597;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L390 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2597, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L391 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_none_ofZdylanZdylan_visceraZbase_type_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_none_ofZdylanZdylan_visceraZexcluded_types_SLOT_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L392 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 45 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 19 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "excluded" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L393 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    8 /* size */,
    "excluded",
};

/* "base" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L394 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    4 /* size */,
    "base",
};

/* "<type-vector>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L395 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    13 /* size */,
    "<type-vector>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L396 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    9 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_vector_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_simple_vector_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_vector_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_array_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_sequence_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_mutable_collection_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_sequence_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[8] */,
    },
};

/* maker for <type-vector> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L2598;

extern descriptor_t * dylanZdylan_visceraZCLS_type_vector_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2599;

struct dylanZdylan_visceraZCLS_raw_function L397 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2598 /* function-name */,
    dylanZdylan_visceraZCLS_type_vector_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2480 /* function-keywords */,
    (heapptr_t) &L2599 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_type_vectorZdylanZdylan_visceraZsize_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_type_vectorZdylanZdylan_visceraZPCTelement_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L398 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_vectorZdylanZdylan_visceraZsize_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_vectorZdylanZdylan_visceraZPCTelement_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2600;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L399 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2600, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L400 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_vectorZdylanZdylan_visceraZsize_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_vectorZdylanZdylan_visceraZPCTelement_SLOT_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L401 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 3 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 67 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_union dylanZliteral_ROOT_10;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L402 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZliteral_ROOT_10, { 0 } } /* %element[0] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method collection_extensions_L78;

extern struct dylanZdylan_visceraZCLS_pair L2601;

struct dylanZdylan_visceraZCLS_pair L403 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &collection_extensions_L78, { 0 } } /* head */,
    { (heapptr_t) &L2601, { 0 } } /* tail */,
};

/* "*" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE1 L404 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    1 /* size */,
    "*",
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method dylan_L608;

extern struct dylanZdylan_visceraZCLS_pair L2602;

struct dylanZdylan_visceraZCLS_pair L405 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylan_L608, { 0 } } /* head */,
    { (heapptr_t) &L2602, { 0 } } /* tail */,
};

/* "reduce1" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L406 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    7 /* size */,
    "reduce1",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L407 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_function_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_collection_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method dylan_L895;

extern struct dylanZdylan_visceraZCLS_pair L2603;

struct dylanZdylan_visceraZCLS_pair L408 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylan_L895, { 0 } } /* head */,
    { (heapptr_t) &L2603, { 0 } } /* tail */,
};

/* "<limited-function>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L409 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    18 /* size */,
    "<limited-function>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L410 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    4 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_function_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_type_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_type_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[3] */,
    },
};

/* maker for <limited-function> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE28 L2604;

extern descriptor_t * dylanZdylan_visceraZCLS_limited_function_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2605;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2606;

struct dylanZdylan_visceraZCLS_raw_function L411 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2604 /* function-name */,
    dylanZdylan_visceraZCLS_limited_function_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2605 /* function-keywords */,
    (heapptr_t) &L2606 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_limited_functionZdylanZdylan_visceraZlf_specializers_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_limited_functionZdylanZdylan_visceraZlf_return_types_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L412 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_functionZdylanZdylan_visceraZlf_specializers_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_functionZdylanZdylan_visceraZlf_return_types_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2607;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L413 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2607, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L414 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    4 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_typeZdylanZdylan_visceraZlimited_integer_base_class_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_functionZdylanZdylan_visceraZlf_specializers_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_limited_functionZdylanZdylan_visceraZlf_return_types_SLOT_HEAP, { 0 } } /* %element[3] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L415 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 45 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 20 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 12 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "return-types" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L416 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    12 /* size */,
    "return-types",
};

/* "specializers" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L417 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    12 /* size */,
    "specializers",
};

/* "<function>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L418 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    10 /* size */,
    "<function>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L419 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_function_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2608;

struct dylanZdylan_visceraZCLS_pair L420 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_method_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2608, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_name_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZgeneral_entry_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_specializers_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_restQUERY_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_keywords_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_all_keysQUERY_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_values_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_rest_value_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L421 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    8 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_name_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZgeneral_entry_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_specializers_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_restQUERY_SLOT_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_keywords_SLOT_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_all_keysQUERY_SLOT_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_values_SLOT_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_rest_value_SLOT_HEAP, { 0 } } /* %element[7] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L422 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    9 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_name_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZgeneral_entry_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_specializers_SLOT_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_restQUERY_SLOT_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_keywords_SLOT_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_all_keysQUERY_SLOT_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_values_SLOT_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_rest_value_SLOT_HEAP, { 0 } } /* %element[8] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L423 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 0 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 6 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "all" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE3 L424 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    3 /* size */,
    "all",
};

/* "class-bucket" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L425 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    12 /* size */,
    "class-bucket",
};

/* "slot-overrides" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L426 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    14 /* size */,
    "slot-overrides",
};

/* "slots" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L427 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    5 /* size */,
    "slots",
};

/* "closest-primary-superclass" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE26 L428 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    26 /* size */,
    "closest-primary-superclass",
};

/* "all-superclasses" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE16 L429 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    16 /* size */,
    "all-superclasses",
};

/* "superclasses" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE12 L430 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    12 /* size */,
    "superclasses",
};

/* "debug-name" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L431 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    10 /* size */,
    "debug-name",
};

/* "functional" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L432 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    10 /* size */,
    "functional",
};

/* "primary" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L433 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    7 /* size */,
    "primary",
};

/* "abstract" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L434 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    8 /* size */,
    "abstract",
};

/* "sealed" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L435 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    6 /* size */,
    "sealed",
};

/* "<slot-descriptor>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L436 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    17 /* size */,
    "<slot-descriptor>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L437 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptor_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
    },
};

/* maker for <slot-descriptor> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE27 L2609;

extern descriptor_t * dylanZdylan_visceraZCLS_slot_descriptor_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L2610;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2611;

struct dylanZdylan_visceraZCLS_raw_function L438 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2609 /* function-name */,
    dylanZdylan_visceraZCLS_slot_descriptor_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2610 /* function-keywords */,
    (heapptr_t) &L2611 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_name_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_allocation_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_type_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_getter_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_init_function_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_init_value_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_init_keyword_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_init_keyword_requiredQUERY_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_positions_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_positions_cache_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_representation_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_initializedQUERY_slot_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE12 L439 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    12 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_name_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_allocation_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_type_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_getter_SLOT_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_init_function_SLOT_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_init_value_SLOT_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_init_keyword_SLOT_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_init_keyword_requiredQUERY_SLOT_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_positions_SLOT_HEAP, { 0 } } /* %element[8] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_positions_cache_SLOT_HEAP, { 0 } } /* %element[9] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_representation_SLOT_HEAP, { 0 } } /* %element[10] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_initializedQUERY_slot_SLOT_HEAP, { 0 } } /* %element[11] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2612;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L440 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2612, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L441 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_name_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_allocation_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_type_SLOT_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_getter_SLOT_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_init_function_SLOT_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_init_value_SLOT_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_init_keyword_SLOT_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_init_keyword_requiredQUERY_SLOT_HEAP, { 0 } } /* %element[8] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_positions_SLOT_HEAP, { 0 } } /* %element[9] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_positions_cache_SLOT_HEAP, { 0 } } /* %element[10] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_representation_SLOT_HEAP, { 0 } } /* %element[11] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_slot_descriptorZdylanZdylan_visceraZslot_initializedQUERY_slot_SLOT_HEAP, { 0 } } /* %element[12] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L442 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 25 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "getter" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L443 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    6 /* size */,
    "getter",
};

/* "allocation" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L444 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    10 /* size */,
    "allocation",
};

/* "name" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L445 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    4 /* size */,
    "name",
};

/* "instance" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L446 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    8 /* size */,
    "instance",
};

/* "each-subclass" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L447 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    13 /* size */,
    "each-subclass",
};

/* "class" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L448 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    5 /* size */,
    "class",
};

/* "virtual" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L449 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    7 /* size */,
    "virtual",
};

/* "type" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L450 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    4 /* size */,
    "type",
};

/* "<generic-function>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE18 L451 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    18 /* size */,
    "<generic-function>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L452 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_function_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L453 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_generic_function_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_function_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* maker for <generic-function> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE28 L2613;

extern descriptor_t * dylanZdylan_visceraZCLS_generic_function_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE9 L2614;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2615;

struct dylanZdylan_visceraZCLS_raw_function L454 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2613 /* function-name */,
    dylanZdylan_visceraZCLS_generic_function_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2614 /* function-keywords */,
    (heapptr_t) &L2615 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_generic_functionZdylanZdylan_visceraZgeneric_function_methods_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_generic_functionZdylanZdylan_visceraZmethod_cache_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L455 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_generic_functionZdylanZdylan_visceraZgeneric_function_methods_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_generic_functionZdylanZdylan_visceraZmethod_cache_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2616;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L456 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2616, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L457 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    11 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_name_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZgeneral_entry_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_specializers_SLOT_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_restQUERY_SLOT_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_keywords_SLOT_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_all_keysQUERY_SLOT_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_values_SLOT_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_rest_value_SLOT_HEAP, { 0 } } /* %element[8] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_generic_functionZdylanZdylan_visceraZgeneric_function_methods_SLOT_HEAP, { 0 } } /* %element[9] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_generic_functionZdylanZdylan_visceraZmethod_cache_SLOT_HEAP, { 0 } } /* %element[10] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L458 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 84 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 6 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<position-cache-node>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L459 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    21 /* size */,
    "<position-cache-node>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L460 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_position_cache_node_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
    },
};

/* maker for <position-cache-node> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE31 L2617;

extern descriptor_t * dylanZdylan_visceraZCLS_position_cache_node_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L2618;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2619;

struct dylanZdylan_visceraZCLS_raw_function L461 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2617 /* function-name */,
    dylanZdylan_visceraZCLS_position_cache_node_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2618 /* function-keywords */,
    (heapptr_t) &L2619 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_position_cache_nodeZdylanZdylan_visceraZcache_class_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_position_cache_nodeZdylanZdylan_visceraZcache_position_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_position_cache_nodeZdylanZdylan_visceraZcache_next_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L462 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_position_cache_nodeZdylanZdylan_visceraZcache_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_position_cache_nodeZdylanZdylan_visceraZcache_position_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_position_cache_nodeZdylanZdylan_visceraZcache_next_SLOT_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2620;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L463 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2620, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L464 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    4 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_position_cache_nodeZdylanZdylan_visceraZcache_class_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_position_cache_nodeZdylanZdylan_visceraZcache_position_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_position_cache_nodeZdylanZdylan_visceraZcache_next_SLOT_HEAP, { 0 } } /* %element[3] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L465 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 34 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "next" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L466 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    4 /* size */,
    "next",
};

/* "position" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L467 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    8 /* size */,
    "position",
};

/* "data-word" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L468 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    9 /* size */,
    "data-word",
};

/* "<override-descriptor>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE21 L469 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    21 /* size */,
    "<override-descriptor>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L470 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_override_descriptor_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
    },
};

/* maker for <override-descriptor> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE31 L2621;

extern descriptor_t * dylanZdylan_visceraZCLS_override_descriptor_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2622;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2623;

struct dylanZdylan_visceraZCLS_raw_function L471 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2621 /* function-name */,
    dylanZdylan_visceraZCLS_override_descriptor_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2622 /* function-keywords */,
    (heapptr_t) &L2623 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_override_descriptorZdylanZdylan_visceraZoverride_init_value_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_override_descriptorZdylanZdylan_visceraZoverride_init_function_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L472 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_override_descriptorZdylanZdylan_visceraZoverride_init_value_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_override_descriptorZdylanZdylan_visceraZoverride_init_function_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2624;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L473 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2624, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L474 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_override_descriptorZdylanZdylan_visceraZoverride_init_value_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_override_descriptorZdylanZdylan_visceraZoverride_init_function_SLOT_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L475 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 33 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "init-value" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L476 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    10 /* size */,
    "init-value",
};

/* "init-function" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L477 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    13 /* size */,
    "init-function",
};

/* "<accessor-method>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE17 L478 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    17 /* size */,
    "<accessor-method>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L479 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_method_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE4 L480 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    4 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_accessor_method_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_method_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_function_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[3] */,
    },
};

/* maker for <accessor-method> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE27 L2625;

extern descriptor_t * dylanZdylan_visceraZCLS_accessor_method_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L2626;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2627;

struct dylanZdylan_visceraZCLS_raw_function L481 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2625 /* function-name */,
    dylanZdylan_visceraZCLS_accessor_method_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2626 /* function-keywords */,
    (heapptr_t) &L2627 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_accessor_methodZdylanZdylan_visceraZaccessor_slot_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L482 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_accessor_methodZdylanZdylan_visceraZaccessor_slot_SLOT_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2628;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L483 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2628, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_methodZdylanZdylan_visceraZgeneric_entry_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L484 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    11 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_name_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZgeneral_entry_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_specializers_SLOT_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_restQUERY_SLOT_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_keywords_SLOT_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_all_keysQUERY_SLOT_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_values_SLOT_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_rest_value_SLOT_HEAP, { 0 } } /* %element[8] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_methodZdylanZdylan_visceraZgeneric_entry_SLOT_HEAP, { 0 } } /* %element[9] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_accessor_methodZdylanZdylan_visceraZaccessor_slot_SLOT_HEAP, { 0 } } /* %element[10] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L485 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 11 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 49 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 6 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "general" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE7 L486 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    7 /* size */,
    "general",
};

/* "heap" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE4 L487 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    4 /* size */,
    "heap",
};

/* "initialize" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L488 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    10 /* size */,
    "initialize",
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_method string_extensions_L50;

extern struct dylanZdylan_visceraZCLS_pair L2629;

struct dylanZdylan_visceraZCLS_pair L489 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &string_extensions_L50, { 0 } } /* head */,
    { (heapptr_t) &L2629, { 0 } } /* tail */,
};

/* "alignment" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L490 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    9 /* size */,
    "alignment",
};

/* "referenced-type" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE15 L491 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    15 /* size */,
    "referenced-type",
};

/* "class-struct-slot-descriptors" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE29 L492 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    29 /* size */,
    "class-struct-slot-descriptors",
};

/* "<struct-slot-descriptor>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE24 L493 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    24 /* size */,
    "<struct-slot-descriptor>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L494 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_struct_slot_descriptor_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
    },
};

/* maker for <struct-slot-descriptor> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE34 L2630;

extern descriptor_t * dylanZdylan_visceraZCLS_struct_slot_descriptor_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L2631;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2632;

struct dylanZdylan_visceraZCLS_raw_function L495 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2630 /* function-name */,
    dylanZdylan_visceraZCLS_struct_slot_descriptor_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2631 /* function-keywords */,
    (heapptr_t) &L2632 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_struct_slot_descriptorZdylanZdylan_visceraZstruct_slot_c_type_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_struct_slot_descriptorZdylanZdylan_visceraZstruct_slot_offset_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L496 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_struct_slot_descriptorZdylanZdylan_visceraZstruct_slot_c_type_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_struct_slot_descriptorZdylanZdylan_visceraZstruct_slot_offset_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2633;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L497 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2633, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L498 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_struct_slot_descriptorZdylanZdylan_visceraZstruct_slot_c_type_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_struct_slot_descriptorZdylanZdylan_visceraZstruct_slot_offset_SLOT_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L499 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 24 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "offset" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L500 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    6 /* size */,
    "offset",
};

/* "c-type" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L501 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    6 /* size */,
    "c-type",
};

/* "<closure>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L502 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    9 /* size */,
    "<closure>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L503 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_closure_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_function_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <pair>} */
extern struct dylanZdylan_visceraZCLS_pair L2634;

struct dylanZdylan_visceraZCLS_pair L504 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_method_closure_HEAP, { 0 } } /* head */,
    { (heapptr_t) &L2634, { 0 } } /* tail */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_closureZdylanZdylan_visceraZclosure_size_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_closureZdylanZdylan_visceraZclosure_var_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L505 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_closureZdylanZdylan_visceraZclosure_size_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_closureZdylanZdylan_visceraZclosure_var_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L506 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    11 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_name_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZgeneral_entry_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_specializers_SLOT_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_restQUERY_SLOT_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_keywords_SLOT_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_all_keysQUERY_SLOT_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_values_SLOT_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_rest_value_SLOT_HEAP, { 0 } } /* %element[8] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_closureZdylanZdylan_visceraZclosure_size_SLOT_HEAP, { 0 } } /* %element[9] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_closureZdylanZdylan_visceraZclosure_var_SLOT_HEAP, { 0 } } /* %element[10] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L507 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 0 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 8 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 6 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<raw-function>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE14 L508 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    14 /* size */,
    "<raw-function>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L509 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_function_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <pair>} */
struct dylanZdylan_visceraZCLS_pair L510 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_raw_closure_HEAP, { 0 } } /* head */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* tail */,
};

/* maker for <raw-function> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE24 L2635;

extern descriptor_t * dylanZdylan_visceraZCLS_raw_function_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE8 L2636;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2637;

struct dylanZdylan_visceraZCLS_raw_function L511 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2635 /* function-name */,
    dylanZdylan_visceraZCLS_raw_function_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2636 /* function-keywords */,
    (heapptr_t) &L2637 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2638;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L512 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2638, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L513 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 10 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 6 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "rest-value" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE10 L514 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    10 /* size */,
    "rest-value",
};

/* "values" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE6 L515 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    6 /* size */,
    "values",
};

/* "all-keys?" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE9 L516 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    9 /* size */,
    "all-keys?",
};

/* "keywords" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE8 L517 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    8 /* size */,
    "keywords",
};

/* "rest?" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE5 L518 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    5 /* size */,
    "rest?",
};

/* "general-entry" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L519 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    13 /* size */,
    "general-entry",
};

/* "function-name" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L520 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    13 /* size */,
    "function-name",
};

/* "<raw-pointer>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE13 L521 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    13 /* size */,
    "<raw-pointer>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L522 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_raw_pointer_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[1] */,
    },
};

/* maker for <raw-pointer> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE23 L2639;

extern descriptor_t * dylanZdylan_visceraZCLS_raw_pointer_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2640;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2641;

struct dylanZdylan_visceraZCLS_raw_function L523 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2639 /* function-name */,
    dylanZdylan_visceraZCLS_raw_pointer_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2640 /* function-keywords */,
    (heapptr_t) &L2641 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_raw_pointerZdylanZdylan_visceraZvalue_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L524 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_raw_pointerZdylanZdylan_visceraZvalue_SLOT_HEAP, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2643;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L525 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2643, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L526 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_raw_pointerZdylanZdylan_visceraZvalue_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L527 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 57 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[12] */,
    },
};

/* "<callback-function>" */
struct dylanZdylan_visceraZCLS_byte_string_SIZE19 L528 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_byte_string_HEAP /* %object-class */,
    19 /* size */,
    "<callback-function>",
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE3 L529 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    3 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_callback_function_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_function_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_object_HEAP, { 0 } } /* %element[2] */,
    },
};

/* {a <pair>} */
struct dylanZdylan_visceraZCLS_pair L530 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_pair_HEAP /* %object-class */,
    { (heapptr_t) &dylanZdylan_visceraZCLS_callback_closure_HEAP, { 0 } } /* head */,
    { (heapptr_t) &dylanZempty_list_ROOT, { 0 } } /* tail */,
};

/* maker for <callback-function> */
extern struct dylanZdylan_visceraZCLS_byte_string_SIZE29 L2644;

extern descriptor_t * dylanZdylan_visceraZCLS_callback_function_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A0 /* self */, long A1 /* nargs */);

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE10 L2645;

extern struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L2646;

struct dylanZdylan_visceraZCLS_raw_function L531 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_raw_function_HEAP /* %object-class */,
    (heapptr_t) &L2644 /* function-name */,
    dylanZdylan_visceraZCLS_callback_function_MAKER_GENERAL /* general-entry */,
    (heapptr_t) &dylanZliteral_ROOT_5 /* function-specializers */,
    0 /* function-rest? */,
    1 /* function-all-keys? */,
    { 0, 0, }, /* hole */
    (heapptr_t) &L2645 /* function-keywords */,
    (heapptr_t) &L2646 /* function-values */,
    (heapptr_t) &dylanZliteral_ROOT_37 /* function-rest-value */,
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_callback_functionZdylanZdylan_visceraZcallback_entry_SLOT_HEAP;

extern struct dylanZdylan_visceraZCLS_slot_descriptor dylanZdylan_visceraZCLS_callback_functionZdylanZdylan_visceraZcallback_signature_SLOT_HEAP;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE2 L532 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    2 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_callback_functionZdylanZdylan_visceraZcallback_entry_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_callback_functionZdylanZdylan_visceraZcallback_signature_SLOT_HEAP, { 0 } } /* %element[1] */,
    },
};

/* {a <simple-object-vector>} */
extern struct dylanZdylan_visceraZCLS_override_descriptor L2647;

struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE1 L533 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    1 /* size */,
    {
	{ (heapptr_t) &L2647, { 0 } } /* %element[0] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE11 L534 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    11 /* size */,
    {
	{ (heapptr_t) &dylanZdylan_visceraZCLS_objectZdylanZdylan_visceraZPCTobject_class_SLOT_HEAP, { 0 } } /* %element[0] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_name_SLOT_HEAP, { 0 } } /* %element[1] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZgeneral_entry_SLOT_HEAP, { 0 } } /* %element[2] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_specializers_SLOT_HEAP, { 0 } } /* %element[3] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_restQUERY_SLOT_HEAP, { 0 } } /* %element[4] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_keywords_SLOT_HEAP, { 0 } } /* %element[5] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_all_keysQUERY_SLOT_HEAP, { 0 } } /* %element[6] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_values_SLOT_HEAP, { 0 } } /* %element[7] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_functionZdylanZdylan_visceraZfunction_rest_value_SLOT_HEAP, { 0 } } /* %element[8] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_callback_functionZdylanZdylan_visceraZcallback_entry_SLOT_HEAP, { 0 } } /* %element[9] */,
	{ (heapptr_t) &dylanZdylan_visceraZCLS_callback_functionZdylanZdylan_visceraZcallback_signature_SLOT_HEAP, { 0 } } /* %element[10] */,
    },
};

/* {a <simple-object-vector>} */
struct dylanZdylan_visceraZCLS_simple_object_vector_SIZE13 L535 = {
    (heapptr_t) &dylanZdylan_visceraZCLS_simple_object_vector_HEAP /* %object-class */,
    13 /* size */,
    {
	{ (heapptr_t) &L0, { 9 } } /* %element[0] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[1] */,
	{ (heapptr_t) &L0, { 6 } } /* %element[2] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[3] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[4] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[5] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[6] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[7] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[8] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[9] */,
	{ (heapptr_t) &L0, { 0 } } /* %element[10] */,
	{ (heapptr_t) &L0, { 1 } } /* %element[11] */,