module: network-test

c-include("/usr/include/sys/time.h");

define functional class <timezone> (<statically-typed-pointer>) end;

define sealed domain make (singleton(<timezone>));

define sealed inline method get-tz-minuteswest
    (ptr :: <timezone>) => (result :: <integer>);
  signed-long-at(ptr, offset: 0);
end method get-tz-minuteswest;

define sealed inline method get-tz-minuteswest-setter
    (value :: <integer>, ptr :: <timezone>) => (result :: <integer>);
  signed-long-at(ptr, offset: 0) := value;
  value;
end method get-tz-minuteswest-setter;

define sealed inline method get-tz-dsttime
    (ptr :: <timezone>) => (result :: <integer>);
  signed-long-at(ptr, offset: 4);
end method get-tz-dsttime;

define sealed inline method get-tz-dsttime-setter
    (value :: <integer>, ptr :: <timezone>) => (result :: <integer>);
  signed-long-at(ptr, offset: 4) := value;
  value;
end method get-tz-dsttime-setter;

define method pointer-value (value :: <timezone>, #key index = 0) => (result :: <timezone>);
  value + index * 8;
end method pointer-value;

define method content-size (value :: subclass(<timezone>)) => (result :: <integer>);
  8;
end method content-size;

define constant <__time-t> = <integer>;

define constant <__suseconds-t> = <integer>;

define functional class <timeval> (<statically-typed-pointer>) end;

define sealed domain make (singleton(<timeval>));

define sealed inline method get-tv-sec
    (ptr :: <timeval>) => (result :: <__time-t>);
  signed-long-at(ptr, offset: 0);
end method get-tv-sec;

define sealed inline method get-tv-sec-setter
    (value :: <__time-t>, ptr :: <timeval>) => (result :: <__time-t>);
  signed-long-at(ptr, offset: 0) := value;
  value;
end method get-tv-sec-setter;

define sealed inline method get-tv-usec
    (ptr :: <timeval>) => (result :: <__suseconds-t>);
  signed-long-at(ptr, offset: 4);
end method get-tv-usec;

define sealed inline method get-tv-usec-setter
    (value :: <__suseconds-t>, ptr :: <timeval>) => (result :: <__suseconds-t>);
  signed-long-at(ptr, offset: 4) := value;
  value;
end method get-tv-usec-setter;

define method pointer-value (value :: <timeval>, #key index = 0) => (result :: <timeval>);
  value + index * 8;
end method pointer-value;

define method content-size (value :: subclass(<timeval>)) => (result :: <integer>);
  8;
end method content-size;

define constant <__timezone-ptr-t> = <timezone>;

define method gettimeofday
    (arg1 :: <timeval>, arg2 :: <__timezone-ptr-t>)
 => (result :: <integer>);
  let result-value
    = call-out("gettimeofday", int:, ptr: (arg1).raw-value, ptr: (arg2).raw-value);
  values(result-value);
end method gettimeofday;

