#include <stddef.h>

#include <stdlib.h>

#define GD_HAVE_LONG_LONG
#include "runtime.h"

#include <math.h>

extern descriptor_t dylanZtrue;	/* #t */

#define obj_True dylanZtrue.heapptr
extern descriptor_t dylanZfalse;	/* #f */

#define obj_False dylanZfalse.heapptr

#define GENERAL_ENTRY(func) \
    ((entry_t)SLOT(func, void *, 8))
#define GENERIC_ENTRY(func) \
    ((entry_t)SLOT(func, void *, 32))

#define GD_CTASSERT(name, x) \
    typedef char gd_assert_ ## name[(x) ? 1 : -1];
#define GD_VERIFY_SIZE_ASSUMPTION(name, type, size)\
    GD_CTASSERT(size_ ## name, sizeof(type) == (size))
#define GD_VERIFY_ALIGN_ASSUMPTION(name, type, align)\
    typedef struct { char c; type x; } \
      gd_align_ ## name; \
    GD_CTASSERT(align_ ## name, offsetof(gd_align_ ## name, x) == (align))

GD_VERIFY_SIZE_ASSUMPTION(general, descriptor_t, 8);
GD_VERIFY_ALIGN_ASSUMPTION(general, descriptor_t, 4);
GD_VERIFY_SIZE_ASSUMPTION(heap, heapptr_t, 4);
GD_VERIFY_ALIGN_ASSUMPTION(heap, heapptr_t, 4);
GD_VERIFY_SIZE_ASSUMPTION(boolean, int, 4);
GD_VERIFY_ALIGN_ASSUMPTION(boolean, int, 4);
GD_VERIFY_SIZE_ASSUMPTION(long_long, long long, 8);
GD_VERIFY_ALIGN_ASSUMPTION(long_long, long long, 4);
GD_VERIFY_SIZE_ASSUMPTION(long, long, 4);
GD_VERIFY_ALIGN_ASSUMPTION(long, long, 4);
GD_VERIFY_SIZE_ASSUMPTION(int, int, 4);
GD_VERIFY_ALIGN_ASSUMPTION(int, int, 4);
GD_VERIFY_SIZE_ASSUMPTION(uint, unsigned int, 4);
GD_VERIFY_ALIGN_ASSUMPTION(uint, unsigned int, 4);
GD_VERIFY_SIZE_ASSUMPTION(short, short, 2);
GD_VERIFY_ALIGN_ASSUMPTION(short, short, 2);
GD_VERIFY_SIZE_ASSUMPTION(ushort, unsigned short, 2);
GD_VERIFY_ALIGN_ASSUMPTION(ushort, unsigned short, 2);
GD_VERIFY_SIZE_ASSUMPTION(float, float, 4);
GD_VERIFY_ALIGN_ASSUMPTION(float, float, 4);
GD_VERIFY_SIZE_ASSUMPTION(double, double, 8);
GD_VERIFY_ALIGN_ASSUMPTION(double, double, 4);
GD_VERIFY_SIZE_ASSUMPTION(long_double, long double, 12);
GD_VERIFY_ALIGN_ASSUMPTION(long_double, long double, 4);
GD_VERIFY_SIZE_ASSUMPTION(ptr, void *, 4);
GD_VERIFY_ALIGN_ASSUMPTION(ptr, void *, 4);

/* {Implicit} Define Generic tcp-client-test */

/* tcp-client-test is tcp-client-test */


/* Define Method tcp-client-test{} */

extern heapptr_t common_extensionsZcommon_extensionsZapplication_arguments_FUN(descriptor_t *orig_sp);	/* application-arguments */

extern void dylanZdylan_visceraZelement_error_FUN(descriptor_t *orig_sp, descriptor_t A0, long A1);	/* element-error */

extern struct heapobj network_testZstr_ROOT_4;

extern struct heapobj dylanZdylan_visceraZCLS_byte_string_HEAP;

extern heapptr_t dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(descriptor_t *orig_sp, long A0, descriptor_t A1);	/* maker for <simple-object-vector> */

extern struct heapobj SYM_default_HEAP;

extern descriptor_t network_testZliteral_2;	/* proxy for <integer> */

struct mv_result_0 {
    long R0;
    long R1;
};

extern struct mv_result_0 common_extensionsZcommon_extensionsZstring_to_integer_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1, heapptr_t A2, long A3, long A4, long A5, int A6, descriptor_t A7);	/* string-to-integer{<byte-string>} */

extern struct heapobj dylanZempty_list_ROOT;

extern void dylanZdylan_visceraZtype_error_with_location_FUN(descriptor_t *orig_sp, descriptor_t A0, heapptr_t A1, descriptor_t A2);	/* type-error-with-location */

extern struct heapobj network_testZstr_ROOT_5;

extern void * networkZnetwork_internalZgethostbyname_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1);	/* gethostbyname{<byte-string>} */

extern descriptor_t melange_supportZmelange_supportZmake_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1, heapptr_t A2, long A3, descriptor_t A4, long A5);	/* make{subclass(<statically-typed-pointer>)} */

extern struct heapobj networkZnetwork_internalZCLS_sockaddr_in_HEAP;

extern struct heapobj network_testZliteral_ROOT;

extern struct heapobj networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP;

extern descriptor_t network_testZliteral_4;	/* proxy for <raw-pointer> */

extern descriptor_t * dylanZdylan_visceraZgf_call_FUN(descriptor_t *orig_sp, heapptr_t A0, long A1);	/* gf-call */

extern struct heapobj dylanZdylan_visceraZas_HEAP;

struct mv_result_1 {
    heapptr_t R0;
    heapptr_t R1;
};

extern struct mv_result_1 dylanZdylan_visceraZgf_call_lookup_FUN(descriptor_t *orig_sp, heapptr_t A0, long A1);	/* gf-call-lookup */

extern int dylanZdylan_visceraZPCTsubtypeQUERY_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1, heapptr_t A2);	/* %subtype?{<class>, <class>} */

extern struct heapobj melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP;

extern struct heapobj dylanZliteral_ROOT_2;

extern descriptor_t network_testZliteral_5;	/* proxy for <c-char-pointer-vector> */

extern struct heapobj dylanZdylan_visceraZelement_HEAP;

extern descriptor_t network_testZliteral_6;	/* proxy for <sockaddr-in> */

extern struct heapobj networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP;

extern descriptor_t network_testZliteral_7;	/* proxy for <char<@14>> */

extern struct heapobj dylanZdylan_visceraZelement_setter_HEAP;

extern struct heapobj network_testZstr_ROOT_6;

extern struct heapobj network_testZstr_ROOT_7;

extern struct heapobj network_testZstr_ROOT_8;

extern struct heapobj network_testZstr_ROOT_9;

extern long networkZnetwork_internalZhtons_METH(descriptor_t *orig_sp, long A0, heapptr_t A1);	/* htons{<integer>} */

extern long networkZnetwork_internalZsocket_METH(descriptor_t *orig_sp, long A0, long A1, long A2, heapptr_t A3);	/* socket{<integer>, <integer>, <integer>} */

extern void dylanZdylan_visceraZerror_METH(descriptor_t *orig_sp, descriptor_t A0, heapptr_t A1, heapptr_t A2);	/* error{<string>} */

extern struct heapobj network_testZstr_ROOT_10;

extern struct heapobj melange_supportZmelange_supportZcontent_size_HEAP;

extern long networkZnetwork_internalZconnect_METH(descriptor_t *orig_sp, long A0, descriptor_t A1, long A2, heapptr_t A3);	/* connect{<integer>, <sockaddr>, <integer>} */

extern heapptr_t streamsZstreamsZCLS_fd_stream_MAKER_FUN(descriptor_t *orig_sp, heapptr_t A0);	/* maker for <fd-stream> */

extern struct heapobj SYM_fd_HEAP;

extern struct heapobj SYM_direction_HEAP;

extern struct heapobj SYM_input_HEAP;

extern heapptr_t streamsZstreamsZinitialize_METH_4(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1, heapptr_t A2, heapptr_t A3, long A4, long A5);	/* initialize{<fd-stream>} */

extern struct heapobj network_testZliteral_ROOT_2;

extern struct heapobj SYM_output_HEAP;

extern struct heapobj SYM_element_count_HEAP;

extern struct heapobj networkZnetwork_internalZCLS_pollfd_HEAP;

extern descriptor_t standard_ioZstandard_ioZVstandard_inputV;	/* *standard-input* */

extern descriptor_t standard_ioZstandard_ioZVstandard_outputV;	/* *standard-output* */

extern heapptr_t dylanZdylan_visceraZCLS_pair_MAKER_FUN(descriptor_t *orig_sp, descriptor_t A0, descriptor_t A1);	/* maker for <pair> */

extern descriptor_t dylanZdylan_visceraZmap_as_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1, descriptor_t A2, heapptr_t A3, heapptr_t A4);	/* map-as{<type>, <function>, <sequence>} */

extern struct heapobj dylanZdylan_visceraZCLS_list_HEAP;

extern struct heapobj network_L87;

extern struct heapobj network_testZliteral_ROOT_3;

extern struct heapobj network_L89;

extern long networkZnetwork_internalZpoll_METH(descriptor_t *orig_sp, void * A0, long A1, long A2, heapptr_t A3);	/* poll{<pollfd>, <integer>, <integer>} */

extern descriptor_t network_testZliteral_8;	/* proxy for <pollfd> */

struct mv_result_2 {
    descriptor_t R0;
    int R1;
};

extern struct mv_result_2 streamsZstreamsZread_line_METH_2(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1, heapptr_t A2, descriptor_t A3);	/* read-line{<fd-stream>} */

extern struct heapobj network_testZliteral_ROOT_4;

extern struct heapobj streamsZstr_ROOT_28;

extern void formatZformatZformat_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1, heapptr_t A2, heapptr_t A3);	/* format{<buffered-stream>, <byte-string>} */

extern struct heapobj network_testZstr_ROOT_11;

extern struct heapobj network_testZliteral_ROOT_5;

extern void streamsZstreamsZforce_output_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1);	/* force-output{<buffered-stream>} */

extern struct heapobj network_testZstr_ROOT_12;

extern struct heapobj network_testZstr_ROOT_13;

extern struct heapobj network_testZstr_ROOT_14;

extern struct heapobj network_testZstr_ROOT;

extern struct heapobj network_testZstr_ROOT_15;

/* tcp-client-test{} */
descriptor_t * network_testZnetwork_testZtcp_client_test_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;
    heapptr_t L_argument; /* argument */
    heapptr_t L_arg0; /* arg0 */
    descriptor_t L_PCTelement; /* %element */
    descriptor_t L_hostname; /* hostname */
    descriptor_t L_temp;
    descriptor_t L_hostname_2; /* hostname */
    heapptr_t L_argument_2; /* argument */
    heapptr_t L_arg0_2; /* arg0 */
    descriptor_t L_PCTelement_2; /* %element */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4;
    struct mv_result_0 L_temp_5;
    long L_port; /* port */
    descriptor_t L_temp_6;
    descriptor_t L_temp_7;
    heapptr_t L_argument_3; /* argument */
    long L_port_2; /* port */
    heapptr_t L_arg0_3; /* arg0 */
    descriptor_t L_temp_8;
    void * L_host; /* host */
    heapptr_t L_instance_2; /* instance */
    descriptor_t L_server_address; /* server-address */
    void * L_raw_value; /* raw-value */
    long L_result; /* result */
    void * L_temp_9; /* temp */
    void * L_raw_value_2; /* raw-value */
    long L_result_2; /* result */
    long L_i; /* i */
    long L_i_2; /* i */
    descriptor_t L_temp_10;
    descriptor_t L_temp_11;
    descriptor_t L_temp_12; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result_3; /* result */
    descriptor_t L_temp_13;
    descriptor_t L_temp_14;
    descriptor_t L_arg0_4; /* arg0 */
    descriptor_t L_temp_15;
    descriptor_t L_new_value; /* new-value */
    descriptor_t L_temp_16;
    descriptor_t L_temp_17;
    descriptor_t L_temp_18;
    descriptor_t L_temp_19; /* temp */
    int L_condition_2; /* condition */
    descriptor_t L_temp_20;
    descriptor_t L_temp_21; /* temp */
    descriptor_t L_temp_22;
    descriptor_t L_temp_23;
    descriptor_t L_temp_24;
    descriptor_t L_temp_25;
    descriptor_t L_temp_26;
    descriptor_t L_temp_27;
    long L_new_value_2; /* new-value */
    long L_foo; /* foo */
    heapptr_t L_instance_3; /* instance */
    descriptor_t L_temp_28;
    descriptor_t L_temp_29;
    long L_arg2; /* arg2 */
    descriptor_t L_temp_30;
    heapptr_t L_instance_4; /* instance */
    heapptr_t L_instance_5; /* instance */
    descriptor_t L_temp_31;
    descriptor_t L_temp_32;
    descriptor_t L_temp_33;
    descriptor_t L_temp_34;
    heapptr_t L_instance_6; /* instance */
    heapptr_t L_instance_7; /* instance */
    descriptor_t L_temp_35;
    descriptor_t L_temp_36;
    descriptor_t L_temp_37;
    descriptor_t L_temp_38;
    heapptr_t L_instance_8; /* instance */
    descriptor_t L_temp_39;
    descriptor_t L_temp_40;
    descriptor_t L_poll_list; /* poll-list */
    descriptor_t L_temp_41;
    heapptr_t L_temp_42; /* temp */
    long L_file_descriptor; /* file-descriptor */
    descriptor_t L_temp_43;
    heapptr_t L_temp_44; /* temp */
    long L_file_descriptor_2; /* file-descriptor */
    descriptor_t L_temp_45;
    descriptor_t L_temp_46;
    heapptr_t L_instance_9; /* instance */
    descriptor_t L_temp_47;
    descriptor_t L_temp_48;
    heapptr_t L_instance_10; /* instance */
    descriptor_t L_temp_49;
    descriptor_t L_temp_50;
    heapptr_t L_instance_11; /* instance */
    descriptor_t L_temp_51;
    descriptor_t L_temp_52;
    heapptr_t L_instance_12; /* instance */
    heapptr_t L_instance_13; /* instance */
    descriptor_t L_temp_53;
    descriptor_t L_temp_54;
    descriptor_t L_temp_55;
    heapptr_t L_instance_14; /* instance */
    descriptor_t L_temp_56;
    descriptor_t L_temp_57;
    heapptr_t L_instance_15; /* instance */
    descriptor_t L_temp_58;
    descriptor_t L_temp_59;
    heapptr_t L_instance_16; /* instance */
    descriptor_t L_temp_60;
    descriptor_t L_temp_61;
    heapptr_t L_instance_17; /* instance */
    heapptr_t L_instance_18; /* instance */
    descriptor_t L_temp_62;
    void * L_temp_63; /* temp */
    descriptor_t L_temp_64;
    descriptor_t L_temp_65;
    descriptor_t L_argument_4; /* argument */
    descriptor_t L_temp_66;
    heapptr_t L_temp_67; /* temp */
    heapptr_t L_instance_19; /* instance */
    descriptor_t L_temp_68;
    struct mv_result_2 L_temp_69;
    descriptor_t L_arg2_2; /* arg2 */
    heapptr_t L_instance_20; /* instance */
    descriptor_t L_temp_70;
    heapptr_t L_temp_71; /* temp */
    descriptor_t L_temp_72;
    descriptor_t L_temp_73;
    descriptor_t L_argument_5; /* argument */
    descriptor_t L_temp_74;
    heapptr_t L_temp_75; /* temp */
    heapptr_t L_instance_21; /* instance */
    descriptor_t L_temp_76;
    struct mv_result_2 L_temp_77;
    descriptor_t L_arg2_3; /* arg2 */
    heapptr_t L_instance_22; /* instance */
    descriptor_t L_temp_78;
    descriptor_t L_temp_79;
    descriptor_t L_temp_80;
    descriptor_t L_temp_81;
    descriptor_t L_temp_82;


    /* #line 4 "./network-test.dylan" */
    /* application-arguments */
    L_argument = common_extensionsZcommon_extensionsZapplication_arguments_FUN(orig_sp);

    /* #line 4 "./network-test.dylan" */

    /* #line 4 "./network-test.dylan" */
    if ((0 < SLOT(L_argument, long, 4))) {

	/* #line 5 "./network-test.dylan" */
	/* application-arguments */
	L_arg0 = common_extensionsZcommon_extensionsZapplication_arguments_FUN(orig_sp);

	/* #line 141 "./vector.dylan" */

	/* #line 141 "./vector.dylan" */
	if ((0 < SLOT(L_arg0, long, 4))) {

	    /* #line 142 "./vector.dylan" */
	    L_PCTelement = SLOT(L_arg0, descriptor_t, 8 + 0 * sizeof(descriptor_t));

	    /* #line 5 "./network-test.dylan" */
	    L_hostname = L_PCTelement;
	}
	else {

	    /* #line 144 "./vector.dylan" */
	    L_temp.heapptr = L_arg0;
	    L_temp.dataword.l = 0;
	    /* element-error */
	    dylanZdylan_visceraZelement_error_FUN(orig_sp, L_temp, 0);
	    not_reached();
	}
    }
    else {

	/* #line 7 "./network-test.dylan" */
	L_hostname.heapptr = &network_testZstr_ROOT_4;
	L_hostname.dataword.l = 0;
    }

    /* #line 8 "./network-test.dylan" */
    L_hostname_2 = L_hostname;

    /* #line 9 "./network-test.dylan" */
    /* application-arguments */
    L_argument_2 = common_extensionsZcommon_extensionsZapplication_arguments_FUN(orig_sp);

    /* #line 9 "./network-test.dylan" */

    /* #line 9 "./network-test.dylan" */
    if ((1 < SLOT(L_argument_2, long, 4))) {

	/* #line 10 "./network-test.dylan" */
	/* application-arguments */
	L_arg0_2 = common_extensionsZcommon_extensionsZapplication_arguments_FUN(orig_sp);

	/* #line 141 "./vector.dylan" */

	/* #line 141 "./vector.dylan" */
	if ((1 < SLOT(L_arg0_2, long, 4))) {

	    /* #line 142 "./vector.dylan" */
	    L_PCTelement_2 = SLOT(L_arg0_2, descriptor_t, 8 + 1 * sizeof(descriptor_t));

	    /* #line 386 "./condition.dylan" */
	    if ((&dylanZdylan_visceraZCLS_byte_string_HEAP == SLOT(L_PCTelement_2.heapptr, heapptr_t, 0))) {

		/* #line 11 "./network-test.dylan" */
		/* maker for <simple-object-vector> */
		L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
		L_temp_2.heapptr = &SYM_default_HEAP;
		L_temp_2.dataword.l = 0;
		SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp_2;
		L_temp_3.heapptr = network_testZliteral_2.heapptr;
		L_temp_3.dataword.l = 80;
		SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_3;
		L_temp_4.heapptr = network_testZliteral_2.heapptr;
		L_temp_4.dataword.l = 80;
		/* string-to-integer{<byte-string>} */
		L_temp_5 = common_extensionsZcommon_extensionsZstring_to_integer_METH(orig_sp, L_PCTelement_2.heapptr, &dylanZempty_list_ROOT, L_instance, 10, 0, 0, FALSE, L_temp_4);
		L_port = L_temp_5.R0;
	    }
	    else {

		/* #line 389 "./condition.dylan" */
		L_temp_6.heapptr = &network_testZstr_ROOT_5;
		L_temp_6.dataword.l = 0;
		/* type-error-with-location */
		dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_PCTelement_2, &dylanZdylan_visceraZCLS_byte_string_HEAP, L_temp_6);
		not_reached();
	    }
	}
	else {

	    /* #line 144 "./vector.dylan" */
	    L_temp_7.heapptr = L_arg0_2;
	    L_temp_7.dataword.l = 0;
	    /* element-error */
	    dylanZdylan_visceraZelement_error_FUN(orig_sp, L_temp_7, 1);
	    not_reached();
	}
    }
    else {

	/* #line 13 "./network-test.dylan" */
	L_port = 80;
    }

    /* #line 14 "./network-test.dylan" */

    /* #line 15 "./network-test.dylan" */
    /* application-arguments */
    L_argument_3 = common_extensionsZcommon_extensionsZapplication_arguments_FUN(orig_sp);

    /* #line 15 "./network-test.dylan" */

    /* #line 15 "./network-test.dylan" */
    L_port_2 = L_port;
    if ((2 < SLOT(L_argument_3, long, 4))) {

	/* #line 16 "./network-test.dylan" */
	/* application-arguments */
	L_arg0_3 = common_extensionsZcommon_extensionsZapplication_arguments_FUN(orig_sp);

	/* #line 141 "./vector.dylan" */

	/* #line 141 "./vector.dylan" */
	if ((2 < SLOT(L_arg0_3, long, 4))) {
	}
	else {

	    /* #line 144 "./vector.dylan" */
	    L_temp_8.heapptr = L_arg0_3;
	    L_temp_8.dataword.l = 0;
	    /* element-error */
	    dylanZdylan_visceraZelement_error_FUN(orig_sp, L_temp_8, 2);
	    not_reached();
	}
    }

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_byte_string_HEAP == SLOT(L_hostname_2.heapptr, heapptr_t, 0))) {

	/* #line 21 "./network-test.dylan" */
	/* gethostbyname{<byte-string>} */
	L_host = networkZnetwork_internalZgethostbyname_METH(orig_sp, L_hostname_2.heapptr, &dylanZempty_list_ROOT);

	/* #line 22 "./network-test.dylan" */
	/* maker for <simple-object-vector> */
	L_instance_2 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
	/* make{subclass(<statically-typed-pointer>)} */
	L_server_address = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_sockaddr_in_HEAP, &network_testZliteral_ROOT, L_instance_2, 0, dylanZfalse, 1);

	/* #line 198 "./melange.dylan" */
	L_raw_value = L_host;

	/* #line 91 "./rawptr.dylan" */

	/* #line 386 "./condition.dylan" */
	L_result = (*(long *)((char *)L_raw_value + 8 ));
	if ((&networkZnetwork_internalZCLS_sockaddr_in_HEAP == SLOT(L_server_address.heapptr, heapptr_t, 0))) {
	    /* #line {Class <unknown-source-location>} */
	    L_temp_9 = L_server_address.dataword.ptr;
	    L_raw_value_2 = L_temp_9;

	    /* #line 97 "./rawptr.dylan" */
	    *(unsigned short *)((char *)L_raw_value_2 + 0) = L_result;

	    /* #line 91 "./rawptr.dylan" */
	    /* #line {Class <compound-macro-source-location>} */
	    L_result_2 = (*(long *)((char *)L_raw_value + 12 ));
	    L_i = 0;
	    while (1) {
		/* #line {Class <unknown-source-location>} */
		L_i_2 = L_i;

		/* #line 148 "./cmp.dylan" */
		if ((L_i_2 < L_result_2)) {

		    /* #line 91 "./rawptr.dylan" */

		    /* #line 290 "./melange.dylan" */
		    L_temp_10.heapptr = &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP;
		    L_temp_10.dataword.l = 0;
		    L_temp_11.heapptr = network_testZliteral_4.heapptr;
		    L_temp_11.dataword.ptr = (*(void * *)((char *)L_raw_value + 16 ));
		    orig_sp[0] = L_temp_10;
		    orig_sp[1] = L_temp_11;
		    /* as */
		    {
		      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
		      heapptr_t L_meth = L_temp.R0;
		      heapptr_t L_next_info = L_temp.R1;
		      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
		    }
		    L_temp_12 = orig_sp[0];

		    /* #line 49 "./object.dylan" */

		    /* #line 386 "./condition.dylan" */
		    /* %subtype?{<class>, <class>} */
		    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_12.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
		    if (L_condition) {

			/* #line 290 "./melange.dylan" */
			L_result_3 = L_temp_12;

			/* #line 386 "./condition.dylan" */
			if ((&networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP == SLOT(L_result_3.heapptr, heapptr_t, 0))) {

			    /* #line 2951 "./sockets-api.dylan" */

			    /* #line 26 "./network-test.dylan" */
			    L_temp_13.heapptr = network_testZliteral_5.heapptr;
			    L_temp_13.dataword.ptr = L_result_3.dataword.ptr;
			    L_temp_14.heapptr = network_testZliteral_2.heapptr;
			    L_temp_14.dataword.l = 0;
			    orig_sp[0] = L_temp_13;
			    orig_sp[1] = L_temp_14;
			    /* element */
			    {
			      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZelement_HEAP, 2);
			      heapptr_t L_meth = L_temp.R0;
			      heapptr_t L_next_info = L_temp.R1;
			      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
			    }
			    L_arg0_4 = orig_sp[0];

			    /* #line 26 "./network-test.dylan" */
			    L_temp_15.heapptr = network_testZliteral_2.heapptr;
			    L_temp_15.dataword.l = L_i_2;
			    orig_sp[0] = L_arg0_4;
			    orig_sp[1] = L_temp_15;
			    /* element */
			    {
			      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZelement_HEAP, 2);
			      heapptr_t L_meth = L_temp.R0;
			      heapptr_t L_next_info = L_temp.R1;
			      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
			    }
			    L_new_value = orig_sp[0];

			    /* #line 49 "./object.dylan" */
			    L_temp_16.heapptr = network_testZliteral_6.heapptr;
			    L_temp_16.dataword.ptr = L_temp_9;

			    /* #line 324 "./melange.dylan" */

			    /* #line 324 "./melange.dylan" */
			    L_temp_17.heapptr = SLOT(L_temp_16.heapptr, heapptr_t, 0);
			    L_temp_17.dataword.l = 0;
			    L_temp_18.heapptr = network_testZliteral_4.heapptr;
			    L_temp_18.dataword.ptr = ((void *)((char *)L_raw_value_2 + 2));
			    orig_sp[0] = L_temp_17;
			    orig_sp[1] = L_temp_18;
			    /* as */
			    {
			      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
			      heapptr_t L_meth = L_temp.R0;
			      heapptr_t L_next_info = L_temp.R1;
			      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
			    }
			    L_temp_19 = orig_sp[0];

			    /* #line 49 "./object.dylan" */

			    /* #line 386 "./condition.dylan" */
			    /* %subtype?{<class>, <class>} */
			    L_condition_2 = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_19.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
			    if (L_condition_2) {

				/* #line 324 "./melange.dylan" */

				/* #line 275 "./sockets-api.dylan" */
				L_temp_20.heapptr = &networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP;
				L_temp_20.dataword.l = 0;
				orig_sp[0] = L_temp_20;
				orig_sp[1] = L_temp_19;
				/* as */
				{
				  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
				  heapptr_t L_meth = L_temp.R0;
				  heapptr_t L_next_info = L_temp.R1;
				  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
				}
				L_temp_21 = orig_sp[0];

				/* #line 386 "./condition.dylan" */
				if ((&networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP == SLOT(L_temp_21.heapptr, heapptr_t, 0))) {

				    /* #line 275 "./sockets-api.dylan" */

				    /* #line 25 "./network-test.dylan" */
				    /* #line {Class <unknown-source-location>} */
				    L_temp_22.heapptr = network_testZliteral_7.heapptr;
				    L_temp_22.dataword.ptr = L_temp_21.dataword.ptr;
				    L_temp_23.heapptr = network_testZliteral_2.heapptr;
				    L_temp_23.dataword.l = (L_i_2 + 2);
				    orig_sp[0] = L_new_value;
				    orig_sp[1] = L_temp_22;
				    orig_sp[2] = L_temp_23;
				    /* element-setter */
				    {
				      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 3, &dylanZdylan_visceraZelement_setter_HEAP, 3);
				      heapptr_t L_meth = L_temp.R0;
				      heapptr_t L_next_info = L_temp.R1;
				      GENERIC_ENTRY(L_meth)(orig_sp + 3, L_meth, 3, L_next_info);
				    }
				    /* #line {Class <compound-macro-source-location>} */
				    L_i = (L_i_2 + 1);
				}
				else {

				    /* #line 389 "./condition.dylan" */
				    L_temp_24.heapptr = &network_testZstr_ROOT_6;
				    L_temp_24.dataword.l = 0;
				    /* type-error-with-location */
				    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_21, &networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP, L_temp_24);
				    not_reached();
				}
			    }
			    else {
				L_temp_25.heapptr = &network_testZstr_ROOT_7;
				L_temp_25.dataword.l = 0;
				/* type-error-with-location */
				dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_19, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_25);
				not_reached();
			    }
			}
			else {
			    L_temp_26.heapptr = &network_testZstr_ROOT_8;
			    L_temp_26.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_3, &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP, L_temp_26);
			    not_reached();
			}
		    }
		    else {
			L_temp_27.heapptr = &network_testZstr_ROOT_9;
			L_temp_27.dataword.l = 0;
			/* type-error-with-location */
			dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_12, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_27);
			not_reached();
		    }
		}
		else {
		    goto block0;
		}
	    }
	  block0:;

	    /* #line 28 "./network-test.dylan" */
	    /* htons{<integer>} */
	    L_new_value_2 = networkZnetwork_internalZhtons_METH(orig_sp, L_port_2, &dylanZempty_list_ROOT);

	    /* #line 97 "./rawptr.dylan" */
	    *(unsigned short *)((char *)L_raw_value_2 + 2) = L_new_value_2;

	    /* #line 30 "./network-test.dylan" */
	    /* socket{<integer>, <integer>, <integer>} */
	    L_foo = networkZnetwork_internalZsocket_METH(orig_sp, 2, 1, 6, &dylanZempty_list_ROOT);

	    /* #line 31 "./network-test.dylan" */
	    if ((L_foo == -1)) {

		/* #line 32 "./network-test.dylan" */
		/* maker for <simple-object-vector> */
		L_instance_3 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
		L_temp_28.heapptr = &network_testZstr_ROOT_10;
		L_temp_28.dataword.l = 0;
		/* error{<string>} */
		dylanZdylan_visceraZerror_METH(orig_sp, L_temp_28, &dylanZempty_list_ROOT, L_instance_3);
		not_reached();
	    }
	    else {

		/* #line 35 "./network-test.dylan" */
		L_temp_29.heapptr = &networkZnetwork_internalZCLS_sockaddr_in_HEAP;
		L_temp_29.dataword.l = 0;
		orig_sp[0] = L_temp_29;
		/* content-size */
		{
		  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 1, &melange_supportZmelange_supportZcontent_size_HEAP, 1);
		  heapptr_t L_meth = L_temp.R0;
		  heapptr_t L_next_info = L_temp.R1;
		  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 1, L_meth, 1, L_next_info);
		}
		L_arg2 = orig_sp[0].dataword.l;

		/* #line 35 "./network-test.dylan" */
		L_temp_30.heapptr = network_testZliteral_6.heapptr;
		L_temp_30.dataword.ptr = L_temp_9;
		/* connect{<integer>, <sockaddr>, <integer>} */
		networkZnetwork_internalZconnect_METH(orig_sp, L_foo, L_temp_30, L_arg2, &dylanZempty_list_ROOT);

		/* #line 40 "./network-test.dylan" */
		/* maker for <fd-stream> */
		L_instance_4 = streamsZstreamsZCLS_fd_stream_MAKER_FUN(orig_sp, 0);
		/* maker for <simple-object-vector> */
		L_instance_5 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 4, dylanZfalse);
		L_temp_31.heapptr = &SYM_fd_HEAP;
		L_temp_31.dataword.l = 0;
		SLOT(L_instance_5, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp_31;
		L_temp_32.heapptr = network_testZliteral_2.heapptr;
		L_temp_32.dataword.l = L_foo;
		SLOT(L_instance_5, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_32;
		L_temp_33.heapptr = &SYM_direction_HEAP;
		L_temp_33.dataword.l = 0;
		SLOT(L_instance_5, descriptor_t, 8 + 2 * sizeof(descriptor_t)) = L_temp_33;
		L_temp_34.heapptr = &SYM_input_HEAP;
		L_temp_34.dataword.l = 0;
		SLOT(L_instance_5, descriptor_t, 8 + 3 * sizeof(descriptor_t)) = L_temp_34;
		/* initialize{<fd-stream>} */
		streamsZstreamsZinitialize_METH_4(orig_sp, L_instance_4, &network_testZliteral_ROOT_2, L_instance_5, &SYM_input_HEAP, L_foo, 65536);

		/* #line 41 "./network-test.dylan" */
		/* maker for <fd-stream> */
		L_instance_6 = streamsZstreamsZCLS_fd_stream_MAKER_FUN(orig_sp, 0);
		/* maker for <simple-object-vector> */
		L_instance_7 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 4, dylanZfalse);
		L_temp_35.heapptr = &SYM_fd_HEAP;
		L_temp_35.dataword.l = 0;
		SLOT(L_instance_7, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp_35;
		L_temp_36.heapptr = network_testZliteral_2.heapptr;
		L_temp_36.dataword.l = L_foo;
		SLOT(L_instance_7, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_36;
		L_temp_37.heapptr = &SYM_direction_HEAP;
		L_temp_37.dataword.l = 0;
		SLOT(L_instance_7, descriptor_t, 8 + 2 * sizeof(descriptor_t)) = L_temp_37;
		L_temp_38.heapptr = &SYM_output_HEAP;
		L_temp_38.dataword.l = 0;
		SLOT(L_instance_7, descriptor_t, 8 + 3 * sizeof(descriptor_t)) = L_temp_38;
		/* initialize{<fd-stream>} */
		streamsZstreamsZinitialize_METH_4(orig_sp, L_instance_6, &network_testZliteral_ROOT_2, L_instance_7, &SYM_output_HEAP, L_foo, 65536);

		/* #line 43 "./network-test.dylan" */
		/* maker for <simple-object-vector> */
		L_instance_8 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
		L_temp_39.heapptr = &SYM_element_count_HEAP;
		L_temp_39.dataword.l = 0;
		SLOT(L_instance_8, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp_39;
		L_temp_40.heapptr = network_testZliteral_2.heapptr;
		L_temp_40.dataword.l = 4;
		SLOT(L_instance_8, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_40;
		/* make{subclass(<statically-typed-pointer>)} */
		L_poll_list = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_pollfd_HEAP, &network_testZliteral_ROOT, L_instance_8, 0, dylanZfalse, 4);

		/* #line 45 "./network-test.dylan" */
		if ((L_temp_41 = standard_ioZstandard_ioZVstandard_inputV).heapptr == NULL) abort();
		L_temp_42 = L_temp_41.heapptr;

		/* #line 45 "./network-test.dylan" */
		L_file_descriptor = SLOT(L_temp_42, long, 20);

		/* #line 46 "./network-test.dylan" */
		if ((L_temp_43 = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
		L_temp_44 = L_temp_43.heapptr;

		/* #line 46 "./network-test.dylan" */
		L_file_descriptor_2 = SLOT(L_temp_44, long, 20);

		/* #line 151 "./list.dylan" */
		L_temp_45.heapptr = network_testZliteral_2.heapptr;
		L_temp_45.dataword.l = L_file_descriptor_2;
		L_temp_46.heapptr = &dylanZempty_list_ROOT;
		L_temp_46.dataword.l = 0;
		/* maker for <pair> */
		L_instance_9 = dylanZdylan_visceraZCLS_pair_MAKER_FUN(orig_sp, L_temp_45, L_temp_46);
		L_temp_47.heapptr = network_testZliteral_2.heapptr;
		L_temp_47.dataword.l = L_file_descriptor;
		L_temp_48.heapptr = L_instance_9;
		L_temp_48.dataword.l = 0;
		/* maker for <pair> */
		L_instance_10 = dylanZdylan_visceraZCLS_pair_MAKER_FUN(orig_sp, L_temp_47, L_temp_48);
		L_temp_49.heapptr = network_testZliteral_2.heapptr;
		L_temp_49.dataword.l = L_foo;
		L_temp_50.heapptr = L_instance_10;
		L_temp_50.dataword.l = 0;
		/* maker for <pair> */
		L_instance_11 = dylanZdylan_visceraZCLS_pair_MAKER_FUN(orig_sp, L_temp_49, L_temp_50);
		L_temp_51.heapptr = network_testZliteral_2.heapptr;
		L_temp_51.dataword.l = L_foo;
		L_temp_52.heapptr = L_instance_11;
		L_temp_52.dataword.l = 0;
		/* maker for <pair> */
		L_instance_12 = dylanZdylan_visceraZCLS_pair_MAKER_FUN(orig_sp, L_temp_51, L_temp_52);

		/* #line 250 "./collection.dylan" */
		/* maker for <simple-object-vector> */
		L_instance_13 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 1, dylanZfalse);
		SLOT(L_instance_13, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_poll_list;
		L_temp_53.heapptr = L_instance_12;
		L_temp_53.dataword.l = 0;
		/* map-as{<type>, <function>, <sequence>} */
		dylanZdylan_visceraZmap_as_METH(orig_sp, &dylanZdylan_visceraZCLS_list_HEAP, &network_L87, L_temp_53, &network_testZliteral_ROOT_3, L_instance_13);

		/* #line 151 "./list.dylan" */
		L_temp_54.heapptr = network_testZliteral_2.heapptr;
		L_temp_54.dataword.l = 4;
		L_temp_55.heapptr = &dylanZempty_list_ROOT;
		L_temp_55.dataword.l = 0;
		/* maker for <pair> */
		L_instance_14 = dylanZdylan_visceraZCLS_pair_MAKER_FUN(orig_sp, L_temp_54, L_temp_55);
		L_temp_56.heapptr = network_testZliteral_2.heapptr;
		L_temp_56.dataword.l = 1;
		L_temp_57.heapptr = L_instance_14;
		L_temp_57.dataword.l = 0;
		/* maker for <pair> */
		L_instance_15 = dylanZdylan_visceraZCLS_pair_MAKER_FUN(orig_sp, L_temp_56, L_temp_57);
		L_temp_58.heapptr = network_testZliteral_2.heapptr;
		L_temp_58.dataword.l = 4;
		L_temp_59.heapptr = L_instance_15;
		L_temp_59.dataword.l = 0;
		/* maker for <pair> */
		L_instance_16 = dylanZdylan_visceraZCLS_pair_MAKER_FUN(orig_sp, L_temp_58, L_temp_59);
		L_temp_60.heapptr = network_testZliteral_2.heapptr;
		L_temp_60.dataword.l = 1;
		L_temp_61.heapptr = L_instance_16;
		L_temp_61.dataword.l = 0;
		/* maker for <pair> */
		L_instance_17 = dylanZdylan_visceraZCLS_pair_MAKER_FUN(orig_sp, L_temp_60, L_temp_61);

		/* #line 250 "./collection.dylan" */
		/* maker for <simple-object-vector> */
		L_instance_18 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 1, dylanZfalse);
		SLOT(L_instance_18, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_poll_list;
		L_temp_62.heapptr = L_instance_17;
		L_temp_62.dataword.l = 0;
		/* map-as{<type>, <function>, <sequence>} */
		dylanZdylan_visceraZmap_as_METH(orig_sp, &dylanZdylan_visceraZCLS_list_HEAP, &network_L89, L_temp_62, &network_testZliteral_ROOT_3, L_instance_18);
		while (1) {

		    /* #line 386 "./condition.dylan" */
		    if ((&networkZnetwork_internalZCLS_pollfd_HEAP == SLOT(L_poll_list.heapptr, heapptr_t, 0))) {

			/* #line 57 "./network-test.dylan" */
			L_temp_63 = L_poll_list.dataword.ptr;
			/* poll{<pollfd>, <integer>, <integer>} */
			networkZnetwork_internalZpoll_METH(orig_sp, L_temp_63, 4, 1000, &dylanZempty_list_ROOT);

			/* #line 62 "./network-test.dylan" */
			L_temp_64.heapptr = network_testZliteral_8.heapptr;
			L_temp_64.dataword.ptr = L_temp_63;
			L_temp_65.heapptr = network_testZliteral_2.heapptr;
			L_temp_65.dataword.l = 0;
			orig_sp[0] = L_temp_64;
			orig_sp[1] = L_temp_65;
			/* element */
			{
			  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZelement_HEAP, 2);
			  heapptr_t L_meth = L_temp.R0;
			  heapptr_t L_next_info = L_temp.R1;
			  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
			}
			L_argument_4 = orig_sp[0];

			/* #line 386 "./condition.dylan" */
			if ((&networkZnetwork_internalZCLS_pollfd_HEAP == SLOT(L_argument_4.heapptr, heapptr_t, 0))) {

			    /* #line 62 "./network-test.dylan" */

			    /* #line 172 "./melange.dylan" */

			    /* #line 91 "./rawptr.dylan" */

			    /* #line 182 "./cmp.dylan" */

			    /* #line 62 "./network-test.dylan" */
			    if ((0 < ((*(short *)((char *)L_argument_4.dataword.ptr + 6 )) & 1))) {

				/* #line 63 "./network-test.dylan" */
				if ((L_temp_66 = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
				L_temp_67 = L_temp_66.heapptr;

				/* #line 63 "./network-test.dylan" */
				/* maker for <simple-object-vector> */
				L_instance_19 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
				L_temp_68.heapptr = &streamsZstr_ROOT_28;
				L_temp_68.dataword.l = 0;
				/* read-line{<fd-stream>} */
				L_temp_69 = streamsZstreamsZread_line_METH_2(orig_sp, L_instance_4, &network_testZliteral_ROOT_4, L_instance_19, L_temp_68);
				L_arg2_2 = L_temp_69.R0;

				/* #line 63 "./network-test.dylan" */
				/* maker for <simple-object-vector> */
				L_instance_20 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 1, dylanZfalse);
				SLOT(L_instance_20, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_arg2_2;
				/* format{<buffered-stream>, <byte-string>} */
				formatZformatZformat_METH(orig_sp, L_temp_67, &network_testZstr_ROOT_11, &network_testZliteral_ROOT_5, L_instance_20);

				/* #line 64 "./network-test.dylan" */
				if ((L_temp_70 = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
				L_temp_71 = L_temp_70.heapptr;

				/* #line 64 "./network-test.dylan" */
				/* force-output{<buffered-stream>} */
				streamsZstreamsZforce_output_METH(orig_sp, L_temp_71, &dylanZempty_list_ROOT);
			    }

			    /* #line 66 "./network-test.dylan" */
			    L_temp_72.heapptr = network_testZliteral_8.heapptr;
			    L_temp_72.dataword.ptr = L_temp_63;
			    L_temp_73.heapptr = network_testZliteral_2.heapptr;
			    L_temp_73.dataword.l = 2;
			    orig_sp[0] = L_temp_72;
			    orig_sp[1] = L_temp_73;
			    /* element */
			    {
			      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZelement_HEAP, 2);
			      heapptr_t L_meth = L_temp.R0;
			      heapptr_t L_next_info = L_temp.R1;
			      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
			    }
			    L_argument_5 = orig_sp[0];

			    /* #line 386 "./condition.dylan" */
			    if ((&networkZnetwork_internalZCLS_pollfd_HEAP == SLOT(L_argument_5.heapptr, heapptr_t, 0))) {

				/* #line 66 "./network-test.dylan" */

				/* #line 172 "./melange.dylan" */

				/* #line 91 "./rawptr.dylan" */

				/* #line 182 "./cmp.dylan" */

				/* #line 66 "./network-test.dylan" */
				if ((0 < ((*(short *)((char *)L_argument_5.dataword.ptr + 6 )) & 1))) {

				    /* #line 67 "./network-test.dylan" */
				    if ((L_temp_74 = standard_ioZstandard_ioZVstandard_inputV).heapptr == NULL) abort();
				    L_temp_75 = L_temp_74.heapptr;

				    /* #line 67 "./network-test.dylan" */
				    /* maker for <simple-object-vector> */
				    L_instance_21 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
				    L_temp_76.heapptr = &streamsZstr_ROOT_28;
				    L_temp_76.dataword.l = 0;
				    /* read-line{<fd-stream>} */
				    L_temp_77 = streamsZstreamsZread_line_METH_2(orig_sp, L_temp_75, &network_testZliteral_ROOT_4, L_instance_21, L_temp_76);
				    L_arg2_3 = L_temp_77.R0;

				    /* #line 67 "./network-test.dylan" */
				    /* maker for <simple-object-vector> */
				    L_instance_22 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 1, dylanZfalse);
				    SLOT(L_instance_22, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_arg2_3;
				    /* format{<buffered-stream>, <byte-string>} */
				    formatZformatZformat_METH(orig_sp, L_instance_6, &network_testZstr_ROOT_11, &network_testZliteral_ROOT_5, L_instance_22);

				    /* #line 68 "./network-test.dylan" */
				    /* force-output{<buffered-stream>} */
				    streamsZstreamsZforce_output_METH(orig_sp, L_instance_6, &dylanZempty_list_ROOT);
				}
			    }
			    else {

				/* #line 389 "./condition.dylan" */
				L_temp_78.heapptr = &network_testZstr_ROOT_12;
				L_temp_78.dataword.l = 0;
				/* type-error-with-location */
				dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_argument_5, &networkZnetwork_internalZCLS_pollfd_HEAP, L_temp_78);
				not_reached();
			    }
			}
			else {
			    L_temp_79.heapptr = &network_testZstr_ROOT_13;
			    L_temp_79.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_argument_4, &networkZnetwork_internalZCLS_pollfd_HEAP, L_temp_79);
			    not_reached();
			}
		    }
		    else {
			L_temp_80.heapptr = &network_testZstr_ROOT_14;
			L_temp_80.dataword.l = 0;
			/* type-error-with-location */
			dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_poll_list, &networkZnetwork_internalZCLS_pollfd_HEAP, L_temp_80);
			not_reached();
		    }
		}
	    }
	}
	else {
	    L_temp_81.heapptr = &network_testZstr_ROOT;
	    L_temp_81.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_server_address, &networkZnetwork_internalZCLS_sockaddr_in_HEAP, L_temp_81);
	    not_reached();
	}
    }
    else {
	L_temp_82.heapptr = &network_testZstr_ROOT_15;
	L_temp_82.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_hostname_2, &dylanZdylan_visceraZCLS_byte_string_HEAP, L_temp_82);
	not_reached();
    }
}


/* {Implicit} Define Generic udp-client-test */

/* udp-client-test is udp-client-test */


/* Define Method udp-client-test{} */

extern struct heapobj network_testZstr_ROOT_16;

extern struct heapobj network_testZstr_ROOT_17;

extern struct heapobj dylanZdylan_visceraZsize_HEAP;

extern struct heapobj dylanZdylan_visceraZCLS_integer_HEAP;

extern long networkZnetwork_internalZsendto_METH(descriptor_t *orig_sp, long A0, heapptr_t A1, long A2, long A3, descriptor_t A4, long A5, heapptr_t A6);	/* sendto{<integer>, <byte-string>, <integer>, <integer>, <sockaddr>, <integer>} */

extern struct heapobj network_testZstr_ROOT_18;

extern struct heapobj network_testZstr_ROOT_19;

extern struct heapobj network_testZstr_ROOT_20;

/* udp-client-test{} */
descriptor_t * network_testZnetwork_testZudp_client_test_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;
    heapptr_t L_argument; /* argument */
    heapptr_t L_arg0; /* arg0 */
    descriptor_t L_PCTelement; /* %element */
    descriptor_t L_hostname; /* hostname */
    descriptor_t L_temp;
    descriptor_t L_hostname_2; /* hostname */
    heapptr_t L_argument_2; /* argument */
    heapptr_t L_arg0_2; /* arg0 */
    descriptor_t L_PCTelement_2; /* %element */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4;
    struct mv_result_0 L_temp_5;
    long L_port; /* port */
    descriptor_t L_temp_6;
    descriptor_t L_temp_7;
    heapptr_t L_argument_3; /* argument */
    long L_port_2; /* port */
    heapptr_t L_arg0_3; /* arg0 */
    descriptor_t L_PCTelement_3; /* %element */
    descriptor_t L_request; /* request */
    descriptor_t L_temp_8;
    descriptor_t L_request_2; /* request */
    void * L_host; /* host */
    heapptr_t L_instance_2; /* instance */
    descriptor_t L_server_address; /* server-address */
    void * L_raw_value; /* raw-value */
    long L_result; /* result */
    void * L_temp_9; /* temp */
    void * L_raw_value_2; /* raw-value */
    long L_result_2; /* result */
    long L_i; /* i */
    long L_i_2; /* i */
    descriptor_t L_temp_10;
    descriptor_t L_temp_11;
    descriptor_t L_temp_12; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result_3; /* result */
    descriptor_t L_temp_13;
    descriptor_t L_temp_14;
    descriptor_t L_arg0_4; /* arg0 */
    descriptor_t L_temp_15;
    descriptor_t L_new_value; /* new-value */
    descriptor_t L_temp_16;
    descriptor_t L_temp_17;
    descriptor_t L_temp_18;
    descriptor_t L_temp_19; /* temp */
    int L_condition_2; /* condition */
    descriptor_t L_temp_20;
    descriptor_t L_temp_21; /* temp */
    descriptor_t L_temp_22;
    descriptor_t L_temp_23;
    descriptor_t L_temp_24;
    descriptor_t L_temp_25;
    descriptor_t L_temp_26;
    descriptor_t L_temp_27;
    long L_new_value_2; /* new-value */
    long L_foo; /* foo */
    heapptr_t L_instance_3; /* instance */
    descriptor_t L_temp_28;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_29;
    long L_arg5; /* arg5 */
    heapptr_t L_temp_30; /* temp */
    descriptor_t L_temp_31;
    long L_rc; /* rc */
    heapptr_t L_instance_4; /* instance */
    descriptor_t L_temp_32;
    descriptor_t L_temp_33;
    descriptor_t L_temp_34;
    descriptor_t L_temp_35;
    descriptor_t L_temp_36;

    /* #line {Class <unknown-source-location>} */

    /* #line 74 "./network-test.dylan" */
    /* application-arguments */
    L_argument = common_extensionsZcommon_extensionsZapplication_arguments_FUN(orig_sp);

    /* #line 74 "./network-test.dylan" */

    /* #line 74 "./network-test.dylan" */
    if ((0 < SLOT(L_argument, long, 4))) {

	/* #line 75 "./network-test.dylan" */
	/* application-arguments */
	L_arg0 = common_extensionsZcommon_extensionsZapplication_arguments_FUN(orig_sp);

	/* #line 141 "./vector.dylan" */

	/* #line 141 "./vector.dylan" */
	if ((0 < SLOT(L_arg0, long, 4))) {

	    /* #line 142 "./vector.dylan" */
	    L_PCTelement = SLOT(L_arg0, descriptor_t, 8 + 0 * sizeof(descriptor_t));

	    /* #line 75 "./network-test.dylan" */
	    L_hostname = L_PCTelement;
	}
	else {

	    /* #line 144 "./vector.dylan" */
	    L_temp.heapptr = L_arg0;
	    L_temp.dataword.l = 0;
	    /* element-error */
	    dylanZdylan_visceraZelement_error_FUN(orig_sp, L_temp, 0);
	    not_reached();
	}
    }
    else {

	/* #line 77 "./network-test.dylan" */
	L_hostname.heapptr = &network_testZstr_ROOT_4;
	L_hostname.dataword.l = 0;
    }

    /* #line 78 "./network-test.dylan" */
    L_hostname_2 = L_hostname;

    /* #line 79 "./network-test.dylan" */
    /* application-arguments */
    L_argument_2 = common_extensionsZcommon_extensionsZapplication_arguments_FUN(orig_sp);

    /* #line 79 "./network-test.dylan" */

    /* #line 79 "./network-test.dylan" */
    if ((1 < SLOT(L_argument_2, long, 4))) {

	/* #line 80 "./network-test.dylan" */
	/* application-arguments */
	L_arg0_2 = common_extensionsZcommon_extensionsZapplication_arguments_FUN(orig_sp);

	/* #line 141 "./vector.dylan" */

	/* #line 141 "./vector.dylan" */
	if ((1 < SLOT(L_arg0_2, long, 4))) {

	    /* #line 142 "./vector.dylan" */
	    L_PCTelement_2 = SLOT(L_arg0_2, descriptor_t, 8 + 1 * sizeof(descriptor_t));

	    /* #line 386 "./condition.dylan" */
	    if ((&dylanZdylan_visceraZCLS_byte_string_HEAP == SLOT(L_PCTelement_2.heapptr, heapptr_t, 0))) {

		/* #line 81 "./network-test.dylan" */
		/* maker for <simple-object-vector> */
		L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
		L_temp_2.heapptr = &SYM_default_HEAP;
		L_temp_2.dataword.l = 0;
		SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp_2;
		L_temp_3.heapptr = network_testZliteral_2.heapptr;
		L_temp_3.dataword.l = 80;
		SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_3;
		L_temp_4.heapptr = network_testZliteral_2.heapptr;
		L_temp_4.dataword.l = 80;
		/* string-to-integer{<byte-string>} */
		L_temp_5 = common_extensionsZcommon_extensionsZstring_to_integer_METH(orig_sp, L_PCTelement_2.heapptr, &dylanZempty_list_ROOT, L_instance, 10, 0, 0, FALSE, L_temp_4);
		L_port = L_temp_5.R0;
	    }
	    else {

		/* #line 389 "./condition.dylan" */
		L_temp_6.heapptr = &network_testZstr_ROOT_16;
		L_temp_6.dataword.l = 0;
		/* type-error-with-location */
		dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_PCTelement_2, &dylanZdylan_visceraZCLS_byte_string_HEAP, L_temp_6);
		not_reached();
	    }
	}
	else {

	    /* #line 144 "./vector.dylan" */
	    L_temp_7.heapptr = L_arg0_2;
	    L_temp_7.dataword.l = 0;
	    /* element-error */
	    dylanZdylan_visceraZelement_error_FUN(orig_sp, L_temp_7, 1);
	    not_reached();
	}
    }
    else {

	/* #line 83 "./network-test.dylan" */
	L_port = 80;
    }

    /* #line 84 "./network-test.dylan" */

    /* #line 85 "./network-test.dylan" */
    /* application-arguments */
    L_argument_3 = common_extensionsZcommon_extensionsZapplication_arguments_FUN(orig_sp);

    /* #line 85 "./network-test.dylan" */

    /* #line 85 "./network-test.dylan" */
    L_port_2 = L_port;
    if ((2 < SLOT(L_argument_3, long, 4))) {

	/* #line 86 "./network-test.dylan" */
	/* application-arguments */
	L_arg0_3 = common_extensionsZcommon_extensionsZapplication_arguments_FUN(orig_sp);

	/* #line 141 "./vector.dylan" */

	/* #line 141 "./vector.dylan" */
	if ((2 < SLOT(L_arg0_3, long, 4))) {

	    /* #line 142 "./vector.dylan" */
	    L_PCTelement_3 = SLOT(L_arg0_3, descriptor_t, 8 + 2 * sizeof(descriptor_t));

	    /* #line 86 "./network-test.dylan" */
	    L_request = L_PCTelement_3;
	}
	else {

	    /* #line 144 "./vector.dylan" */
	    L_temp_8.heapptr = L_arg0_3;
	    L_temp_8.dataword.l = 0;
	    /* element-error */
	    dylanZdylan_visceraZelement_error_FUN(orig_sp, L_temp_8, 2);
	    not_reached();
	}
    }
    else {

	/* #line 88 "./network-test.dylan" */
	L_request.heapptr = &network_testZstr_ROOT_17;
	L_request.dataword.l = 0;
    }

    /* #line 89 "./network-test.dylan" */
    L_request_2 = L_request;

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_byte_string_HEAP == SLOT(L_hostname_2.heapptr, heapptr_t, 0))) {

	/* #line 91 "./network-test.dylan" */
	/* gethostbyname{<byte-string>} */
	L_host = networkZnetwork_internalZgethostbyname_METH(orig_sp, L_hostname_2.heapptr, &dylanZempty_list_ROOT);

	/* #line 92 "./network-test.dylan" */
	/* maker for <simple-object-vector> */
	L_instance_2 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
	/* make{subclass(<statically-typed-pointer>)} */
	L_server_address = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_sockaddr_in_HEAP, &network_testZliteral_ROOT, L_instance_2, 0, dylanZfalse, 1);

	/* #line 198 "./melange.dylan" */
	L_raw_value = L_host;

	/* #line 91 "./rawptr.dylan" */

	/* #line 386 "./condition.dylan" */
	L_result = (*(long *)((char *)L_raw_value + 8 ));
	if ((&networkZnetwork_internalZCLS_sockaddr_in_HEAP == SLOT(L_server_address.heapptr, heapptr_t, 0))) {
	    /* #line {Class <unknown-source-location>} */
	    L_temp_9 = L_server_address.dataword.ptr;
	    L_raw_value_2 = L_temp_9;

	    /* #line 97 "./rawptr.dylan" */
	    *(unsigned short *)((char *)L_raw_value_2 + 0) = L_result;

	    /* #line 91 "./rawptr.dylan" */
	    /* #line {Class <compound-macro-source-location>} */
	    L_result_2 = (*(long *)((char *)L_raw_value + 12 ));
	    L_i = 0;
	    while (1) {
		/* #line {Class <unknown-source-location>} */
		L_i_2 = L_i;

		/* #line 148 "./cmp.dylan" */
		if ((L_i_2 < L_result_2)) {

		    /* #line 91 "./rawptr.dylan" */

		    /* #line 290 "./melange.dylan" */
		    L_temp_10.heapptr = &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP;
		    L_temp_10.dataword.l = 0;
		    L_temp_11.heapptr = network_testZliteral_4.heapptr;
		    L_temp_11.dataword.ptr = (*(void * *)((char *)L_raw_value + 16 ));
		    orig_sp[0] = L_temp_10;
		    orig_sp[1] = L_temp_11;
		    /* as */
		    {
		      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
		      heapptr_t L_meth = L_temp.R0;
		      heapptr_t L_next_info = L_temp.R1;
		      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
		    }
		    L_temp_12 = orig_sp[0];

		    /* #line 49 "./object.dylan" */

		    /* #line 386 "./condition.dylan" */
		    /* %subtype?{<class>, <class>} */
		    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_12.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
		    if (L_condition) {

			/* #line 290 "./melange.dylan" */
			L_result_3 = L_temp_12;

			/* #line 386 "./condition.dylan" */
			if ((&networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP == SLOT(L_result_3.heapptr, heapptr_t, 0))) {

			    /* #line 2951 "./sockets-api.dylan" */

			    /* #line 96 "./network-test.dylan" */
			    L_temp_13.heapptr = network_testZliteral_5.heapptr;
			    L_temp_13.dataword.ptr = L_result_3.dataword.ptr;
			    L_temp_14.heapptr = network_testZliteral_2.heapptr;
			    L_temp_14.dataword.l = 0;
			    orig_sp[0] = L_temp_13;
			    orig_sp[1] = L_temp_14;
			    /* element */
			    {
			      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZelement_HEAP, 2);
			      heapptr_t L_meth = L_temp.R0;
			      heapptr_t L_next_info = L_temp.R1;
			      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
			    }
			    L_arg0_4 = orig_sp[0];

			    /* #line 96 "./network-test.dylan" */
			    L_temp_15.heapptr = network_testZliteral_2.heapptr;
			    L_temp_15.dataword.l = L_i_2;
			    orig_sp[0] = L_arg0_4;
			    orig_sp[1] = L_temp_15;
			    /* element */
			    {
			      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZelement_HEAP, 2);
			      heapptr_t L_meth = L_temp.R0;
			      heapptr_t L_next_info = L_temp.R1;
			      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
			    }
			    L_new_value = orig_sp[0];

			    /* #line 49 "./object.dylan" */
			    L_temp_16.heapptr = network_testZliteral_6.heapptr;
			    L_temp_16.dataword.ptr = L_temp_9;

			    /* #line 324 "./melange.dylan" */

			    /* #line 324 "./melange.dylan" */
			    L_temp_17.heapptr = SLOT(L_temp_16.heapptr, heapptr_t, 0);
			    L_temp_17.dataword.l = 0;
			    L_temp_18.heapptr = network_testZliteral_4.heapptr;
			    L_temp_18.dataword.ptr = ((void *)((char *)L_raw_value_2 + 2));
			    orig_sp[0] = L_temp_17;
			    orig_sp[1] = L_temp_18;
			    /* as */
			    {
			      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
			      heapptr_t L_meth = L_temp.R0;
			      heapptr_t L_next_info = L_temp.R1;
			      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
			    }
			    L_temp_19 = orig_sp[0];

			    /* #line 49 "./object.dylan" */

			    /* #line 386 "./condition.dylan" */
			    /* %subtype?{<class>, <class>} */
			    L_condition_2 = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_19.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
			    if (L_condition_2) {

				/* #line 324 "./melange.dylan" */

				/* #line 275 "./sockets-api.dylan" */
				L_temp_20.heapptr = &networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP;
				L_temp_20.dataword.l = 0;
				orig_sp[0] = L_temp_20;
				orig_sp[1] = L_temp_19;
				/* as */
				{
				  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
				  heapptr_t L_meth = L_temp.R0;
				  heapptr_t L_next_info = L_temp.R1;
				  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
				}
				L_temp_21 = orig_sp[0];

				/* #line 386 "./condition.dylan" */
				if ((&networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP == SLOT(L_temp_21.heapptr, heapptr_t, 0))) {

				    /* #line 275 "./sockets-api.dylan" */

				    /* #line 95 "./network-test.dylan" */
				    /* #line {Class <unknown-source-location>} */
				    L_temp_22.heapptr = network_testZliteral_7.heapptr;
				    L_temp_22.dataword.ptr = L_temp_21.dataword.ptr;
				    L_temp_23.heapptr = network_testZliteral_2.heapptr;
				    L_temp_23.dataword.l = (L_i_2 + 2);
				    orig_sp[0] = L_new_value;
				    orig_sp[1] = L_temp_22;
				    orig_sp[2] = L_temp_23;
				    /* element-setter */
				    {
				      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 3, &dylanZdylan_visceraZelement_setter_HEAP, 3);
				      heapptr_t L_meth = L_temp.R0;
				      heapptr_t L_next_info = L_temp.R1;
				      GENERIC_ENTRY(L_meth)(orig_sp + 3, L_meth, 3, L_next_info);
				    }
				    /* #line {Class <compound-macro-source-location>} */
				    L_i = (L_i_2 + 1);
				}
				else {

				    /* #line 389 "./condition.dylan" */
				    L_temp_24.heapptr = &network_testZstr_ROOT_6;
				    L_temp_24.dataword.l = 0;
				    /* type-error-with-location */
				    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_21, &networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP, L_temp_24);
				    not_reached();
				}
			    }
			    else {
				L_temp_25.heapptr = &network_testZstr_ROOT_7;
				L_temp_25.dataword.l = 0;
				/* type-error-with-location */
				dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_19, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_25);
				not_reached();
			    }
			}
			else {
			    L_temp_26.heapptr = &network_testZstr_ROOT_8;
			    L_temp_26.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_3, &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP, L_temp_26);
			    not_reached();
			}
		    }
		    else {
			L_temp_27.heapptr = &network_testZstr_ROOT_9;
			L_temp_27.dataword.l = 0;
			/* type-error-with-location */
			dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_12, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_27);
			not_reached();
		    }
		}
		else {
		    goto block0;
		}
	    }
	  block0:;

	    /* #line 98 "./network-test.dylan" */
	    /* htons{<integer>} */
	    L_new_value_2 = networkZnetwork_internalZhtons_METH(orig_sp, L_port_2, &dylanZempty_list_ROOT);

	    /* #line 97 "./rawptr.dylan" */
	    *(unsigned short *)((char *)L_raw_value_2 + 2) = L_new_value_2;

	    /* #line 100 "./network-test.dylan" */
	    /* socket{<integer>, <integer>, <integer>} */
	    L_foo = networkZnetwork_internalZsocket_METH(orig_sp, 2, 2, 17, &dylanZempty_list_ROOT);

	    /* #line 101 "./network-test.dylan" */
	    if ((L_foo == -1)) {

		/* #line 102 "./network-test.dylan" */
		/* maker for <simple-object-vector> */
		L_instance_3 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
		L_temp_28.heapptr = &network_testZstr_ROOT_10;
		L_temp_28.dataword.l = 0;
		/* error{<string>} */
		dylanZdylan_visceraZerror_METH(orig_sp, L_temp_28, &dylanZempty_list_ROOT, L_instance_3);
		not_reached();
	    }
	    else {

		/* #line 105 "./network-test.dylan" */
		orig_sp[0] = L_request_2;
		/* size */
		{
		  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 1, &dylanZdylan_visceraZsize_HEAP, 1);
		  heapptr_t L_meth = L_temp.R0;
		  heapptr_t L_next_info = L_temp.R1;
		  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 1, L_meth, 1, L_next_info);
		}
		L_arg2 = orig_sp[0];

		/* #line 106 "./network-test.dylan" */
		L_temp_29.heapptr = &networkZnetwork_internalZCLS_sockaddr_in_HEAP;
		L_temp_29.dataword.l = 0;
		orig_sp[0] = L_temp_29;
		/* content-size */
		{
		  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 1, &melange_supportZmelange_supportZcontent_size_HEAP, 1);
		  heapptr_t L_meth = L_temp.R0;
		  heapptr_t L_next_info = L_temp.R1;
		  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 1, L_meth, 1, L_next_info);
		}
		L_arg5 = orig_sp[0].dataword.l;

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_byte_string_HEAP == SLOT(L_request_2.heapptr, heapptr_t, 0))) {

		    /* #line 106 "./network-test.dylan" */

		    /* #line 386 "./condition.dylan" */
		    L_temp_30 = L_request_2.heapptr;
		    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

			/* #line 106 "./network-test.dylan" */
			L_temp_31.heapptr = network_testZliteral_6.heapptr;
			L_temp_31.dataword.ptr = L_temp_9;
			/* sendto{<integer>, <byte-string>, <integer>, <integer>, <sockaddr>, <integer>} */
			L_rc = networkZnetwork_internalZsendto_METH(orig_sp, L_foo, L_temp_30, L_arg2.dataword.l, 0, L_temp_31, L_arg5, &dylanZempty_list_ROOT);

			/* #line 107 "./network-test.dylan" */
			if ((L_rc == -1)) {

			    /* #line 108 "./network-test.dylan" */
			    /* maker for <simple-object-vector> */
			    L_instance_4 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
			    L_temp_32.heapptr = &network_testZstr_ROOT_18;
			    L_temp_32.dataword.l = 0;
			    /* error{<string>} */
			    dylanZdylan_visceraZerror_METH(orig_sp, L_temp_32, &dylanZempty_list_ROOT, L_instance_4);
			    not_reached();
			}
			else {
			    orig_sp[0] = dylanZfalse;
			    return orig_sp + 1;
			}
		    }
		    else {

			/* #line 389 "./condition.dylan" */
			L_temp_33.heapptr = &network_testZstr_ROOT_19;
			L_temp_33.dataword.l = 0;
			/* type-error-with-location */
			dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, dylanZfalse, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_33);
			not_reached();
		    }
		}
		else {
		    L_temp_34.heapptr = &network_testZstr_ROOT_19;
		    L_temp_34.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_request_2, &dylanZdylan_visceraZCLS_byte_string_HEAP, L_temp_34);
		    not_reached();
		}
	    }
	}
	else {
	    L_temp_35.heapptr = &network_testZstr_ROOT;
	    L_temp_35.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_server_address, &networkZnetwork_internalZCLS_sockaddr_in_HEAP, L_temp_35);
	    not_reached();
	}
    }
    else {
	L_temp_36.heapptr = &network_testZstr_ROOT_20;
	L_temp_36.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_hostname_2, &dylanZdylan_visceraZCLS_byte_string_HEAP, L_temp_36);
	not_reached();
    }
}


/* Define Method as{singleton(<double-float>), <timeval>} */

/* as{singleton(<double-float>), <timeval>} */
double network_testZnetwork_testZas_METH(descriptor_t *orig_sp, heapptr_t A_class /* class */, void * A_tv /* tv */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;
    void * L_raw_value; /* raw-value */
    long L_result; /* result */

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */
    L_raw_value = A_tv;

    /* #line 91 "./rawptr.dylan" */
    L_result = (*(long *)((char *)L_raw_value + 0 ));

    /* #line 115 "./network-test.dylan" */

    /* #line 1335 "./num.dylan" */

    /* #line 115 "./network-test.dylan" */
    return (((double)L_result) + (((double)(*(long *)((char *)L_raw_value + 4 ))) / 0.1e7));
}

extern struct heapobj dylanZdylan_visceraZCLS_double_float_HEAP;

/* generic-entry for as{singleton(<double-float>), <timeval>} */
descriptor_t * network_testZnetwork_testZas_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    double L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 2));
    L_arg = (((descriptor_t *)L_args)[1]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* as{singleton(<double-float>), <timeval>} */
    L_result0 = network_testZnetwork_testZas_METH(orig_sp, &dylanZdylan_visceraZCLS_double_float_HEAP, L_arg_2, A_next_method_info);
    L_temp.heapptr = make_double_float(L_result0);
    L_temp.dataword.l = 0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method as{singleton(<timeval>), <double-float>} */

extern struct heapobj network_testZstr_ROOT_21;

extern struct heapobj network_testZnetwork_testZCLS_timeval_HEAP;

/* as{singleton(<timeval>), <double-float>} */
void * network_testZnetwork_testZas_METH_2(descriptor_t *orig_sp, heapptr_t A_class /* class */, double A_d /* d */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    heapptr_t L_instance_2; /* instance */
    descriptor_t L_tv; /* tv */
    long L_quo; /* quo */
    double L_b; /* b */
    void * L_temp_2; /* temp */
    void * L_raw_value; /* raw-value */
    descriptor_t L_temp_3;


    /* #line 120 "./network-test.dylan" */
    if ((A_d < 0.0)) {

	/* #line 121 "./network-test.dylan" */
	/* maker for <simple-object-vector> */
	L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
	L_temp.heapptr = &network_testZstr_ROOT_21;
	L_temp.dataword.l = 0;
	/* error{<string>} */
	dylanZdylan_visceraZerror_METH(orig_sp, L_temp, &dylanZempty_list_ROOT, L_instance);
	not_reached();
    }
    else {

	/* #line 123 "./network-test.dylan" */
	/* maker for <simple-object-vector> */
	L_instance_2 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
	/* make{subclass(<statically-typed-pointer>)} */
	L_tv = melange_supportZmelange_supportZmake_METH(orig_sp, &network_testZnetwork_testZCLS_timeval_HEAP, &network_testZliteral_ROOT, L_instance_2, 0, dylanZfalse, 1);

	/* #line 1365 "./num.dylan" */
	L_quo = ((long)floor(A_d));

	/* #line 1315 "./num.dylan" */

	/* #line 386 "./condition.dylan" */
	L_b = ((double)L_quo);
	if ((&network_testZnetwork_testZCLS_timeval_HEAP == SLOT(L_tv.heapptr, heapptr_t, 0))) {
	    /* #line {Class <unknown-source-location>} */
	    L_temp_2 = L_tv.dataword.ptr;
	    L_raw_value = L_temp_2;

	    /* #line 97 "./rawptr.dylan" */
	    *(long *)((char *)L_raw_value + 0) = L_quo;

	    /* #line 126 "./network-test.dylan" */

	    /* #line 1335 "./num.dylan" */
	    /* #line {Class <unknown-source-location>} */

	    /* #line 97 "./rawptr.dylan" */
	    *(long *)((char *)L_raw_value + 4) = ((long)floor(((A_d - L_b) / 0.1e7)));
	    return L_temp_2;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_3.heapptr = &network_testZstr_ROOT;
	    L_temp_3.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_tv, &network_testZnetwork_testZCLS_timeval_HEAP, L_temp_3);
	    not_reached();
	}
    }
}

extern descriptor_t network_testZliteral_3;	/* proxy for <timeval> */

/* generic-entry for as{singleton(<timeval>), <double-float>} */
descriptor_t * network_testZnetwork_testZas_METH_GENERIC_2(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    double L_arg_2; /* arg */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 2));
    L_arg = (((descriptor_t *)L_args)[1]);
    L_arg_2 = double_float_value(L_arg.heapptr);
    orig_sp = L_args;
    /* as{singleton(<timeval>), <double-float>} */
    L_result0 = network_testZnetwork_testZas_METH_2(orig_sp, &network_testZnetwork_testZCLS_timeval_HEAP, L_arg_2, A_next_method_info);
    L_temp.heapptr = network_testZliteral_3.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic now */

/* now is now */


/* Define Method now{} */

extern struct heapobj network_testZnetwork_testZCLS_timezone_HEAP;

extern long network_testZnetwork_testZgettimeofday_METH(descriptor_t *orig_sp, void * A0, void * A1, heapptr_t A2);	/* gettimeofday{<timeval>, <timezone>} */

extern struct heapobj network_testZstr_ROOT_22;

/* now{} */
descriptor_t * network_testZnetwork_testZnow_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;
    heapptr_t L_instance; /* instance */
    descriptor_t L_tv; /* tv */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_arg1; /* arg1 */
    void * L_temp_3; /* temp */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;
    descriptor_t L_result0; /* result0 */
    descriptor_t L_temp_6;
    descriptor_t L_temp_7;


    /* #line 131 "./network-test.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
    /* make{subclass(<statically-typed-pointer>)} */
    L_tv = melange_supportZmelange_supportZmake_METH(orig_sp, &network_testZnetwork_testZCLS_timeval_HEAP, &network_testZliteral_ROOT, L_instance, 0, dylanZfalse, 1);

    /* #line 132 "./network-test.dylan" */
    L_temp.heapptr = &network_testZnetwork_testZCLS_timezone_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = network_testZliteral_2.heapptr;
    L_temp_2.dataword.l = 0;
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = orig_sp[0];

    /* #line 386 "./condition.dylan" */
    if ((&network_testZnetwork_testZCLS_timeval_HEAP == SLOT(L_tv.heapptr, heapptr_t, 0))) {

	/* #line 132 "./network-test.dylan" */
	L_temp_3 = L_tv.dataword.ptr;

	/* #line 386 "./condition.dylan" */
	if ((&network_testZnetwork_testZCLS_timezone_HEAP == SLOT(L_arg1.heapptr, heapptr_t, 0))) {

	    /* #line 132 "./network-test.dylan" */
	    /* gettimeofday{<timeval>, <timezone>} */
	    network_testZnetwork_testZgettimeofday_METH(orig_sp, L_temp_3, L_arg1.dataword.ptr, &dylanZempty_list_ROOT);

	    /* #line 133 "./network-test.dylan" */
	    L_temp_4.heapptr = &dylanZdylan_visceraZCLS_double_float_HEAP;
	    L_temp_4.dataword.l = 0;
	    L_temp_5.heapptr = network_testZliteral_3.heapptr;
	    L_temp_5.dataword.ptr = L_temp_3;
	    orig_sp[0] = L_temp_4;
	    orig_sp[1] = L_temp_5;
	    /* as */
	    {
	      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	      heapptr_t L_meth = L_temp.R0;
	      heapptr_t L_next_info = L_temp.R1;
	      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	    }
	    L_result0 = orig_sp[0];
	    orig_sp[0] = L_result0;
	    return orig_sp + 1;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_6.heapptr = &network_testZstr_ROOT_22;
	    L_temp_6.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg1, &network_testZnetwork_testZCLS_timezone_HEAP, L_temp_6);
	    not_reached();
	}
    }
    else {
	L_temp_7.heapptr = &network_testZstr_ROOT_22;
	L_temp_7.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_tv, &network_testZnetwork_testZCLS_timeval_HEAP, L_temp_7);
	not_reached();
    }
}


/* Define Method print-object{<timeval>, <stream>} */

extern struct heapobj network_testZstr_ROOT_23;

extern struct heapobj formatZformatZformat_ROOT;

/* print-object{<timeval>, <stream>} */
void network_testZnetwork_testZprint_object_METH(descriptor_t *orig_sp, void * A_tv /* tv */, heapptr_t A_s /* s */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;
    void * L_raw_value; /* raw-value */
    long L_result; /* result */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */
    L_raw_value = A_tv;

    /* #line 91 "./rawptr.dylan" */
    L_result = (*(long *)((char *)L_raw_value + 0 ));

    /* #line 137 "./network-test.dylan" */
    L_temp.heapptr = A_s;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = &network_testZstr_ROOT_23;
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = network_testZliteral_2.heapptr;
    L_temp_3.dataword.l = L_result;
    L_temp_4.heapptr = network_testZliteral_2.heapptr;
    L_temp_4.dataword.l = (*(long *)((char *)L_raw_value + 4 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    orig_sp[2] = L_temp_3;
    orig_sp[3] = L_temp_4;
    /* format */
    {
      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 4, &formatZformatZformat_ROOT, 4);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      GENERIC_ENTRY(L_meth)(orig_sp + 4, L_meth, 4, L_next_info);
    }
    return;
}

/* generic-entry for print-object{<timeval>, <stream>} */
descriptor_t * network_testZnetwork_testZprint_object_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    void * L_arg_3; /* arg */
    heapptr_t L_arg_4; /* arg */

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 2));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_arg_3 = L_arg.dataword.ptr;
    L_arg_4 = L_arg_2.heapptr;
    orig_sp = L_args;
    /* print-object{<timeval>, <stream>} */
    network_testZnetwork_testZprint_object_METH(orig_sp, L_arg_3, L_arg_4, A_next_method_info);
    return orig_sp + 0;
}


/* {Implicit} Define Generic fd */

/* fd is fd */


/* {Implicit} Define Generic fd-setter */

/* fd-setter is fd-setter */


/* {Implicit} Define Generic address */

/* address is address */


/* {Implicit} Define Generic address-setter */

/* address-setter is address-setter */


/* {Implicit} Define Generic interval */

/* interval is interval */


/* {Implicit} Define Generic interval-setter */

/* interval-setter is interval-setter */


/* {Implicit} Define Generic wanted-interval */

/* wanted-interval is wanted-interval */


/* {Implicit} Define Generic wanted-interval-setter */

/* wanted-interval-setter is wanted-interval-setter */


/* {Implicit} Define Generic last-sent */

/* last-sent is last-sent */


/* {Implicit} Define Generic last-sent-setter */

/* last-sent-setter is last-sent-setter */


/* {Implicit} Define Generic data */

/* data is data */


/* {Implicit} Define Generic data-setter */

/* data-setter is data-setter */


/* Define Class <streamer> */

/* <streamer> is <streamer> */

extern struct heapobj network_testZnetwork_testZCLS_streamer_HEAP;

/* maker for <streamer> */
heapptr_t network_testZnetwork_testZCLS_streamer_MAKER_FUN(descriptor_t *orig_sp, descriptor_t A_data /* data */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_data_init_value; /* data-init-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;


    /* #line 147 "./network-test.dylan" */
    if ((A_data.heapptr != NULL)) {
	L_data_init_value = A_data;
    }
    else {
	L_data_init_value.heapptr = 0;
	L_data_init_value.dataword.l = 0;
    }
    L_instance = allocate(52);
    SLOT(L_instance, heapptr_t, 0) = &network_testZnetwork_testZCLS_streamer_HEAP;
    L_temp.heapptr = 0;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 4) = L_temp;
    L_temp_2.heapptr = 0;
    L_temp_2.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 12) = L_temp_2;
    L_temp_3.heapptr = 0;
    L_temp_3.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 20) = L_temp_3;
    L_temp_4.heapptr = 0;
    L_temp_4.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 28) = L_temp_4;
    L_temp_5.heapptr = 0;
    L_temp_5.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 36) = L_temp_5;
    SLOT(L_instance, descriptor_t, 44) = L_data_init_value;
    return L_instance;
}

extern struct heapobj dylanZdylan_visceraZCLS_symbol_HEAP;

extern struct heapobj SYM_data_HEAP;

extern void dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(descriptor_t *orig_sp);	/* odd-number-of-keyword/value-arguments-error */

/* general-entry for maker for <streamer> */
descriptor_t * network_testZnetwork_testZCLS_streamer_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_data; /* data */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    heapptr_t L_result0; /* result0 */
    descriptor_t L_temp_3;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_data.heapptr = 0;
	L_data.dataword.l = 0;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_data_HEAP)) {
			L_data = L_value;
		    }
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_2.heapptr = &network_testZstr_ROOT;
		    L_temp_2.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_2);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <streamer> */
	L_result0 = network_testZnetwork_testZCLS_streamer_MAKER_FUN(orig_sp, L_data);
	L_temp_3.heapptr = L_result0;
	L_temp_3.dataword.l = 0;
	orig_sp[0] = L_temp_3;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Method initialize{<streamer>} */

extern heapptr_t dylanZdylan_visceraZmake_rest_arg_FUN(descriptor_t *orig_sp, void * A0, long A1);	/* make-rest-arg */

extern struct heapobj network_testZstr_ROOT_24;

extern struct heapobj dylanZdylan_visceraZCLS_pair_HEAP;

extern void dylanZdylan_visceraZambiguous_method_error_FUN(descriptor_t *orig_sp, heapptr_t A0);	/* ambiguous-method-error */

extern descriptor_t network_testZliteral_9;	/* 8.0d0 */

extern struct heapobj dylanZdylan_visceraZV_HEAP;

extern struct heapobj dylanZdylan_visceraZSLASH_HEAP;

extern struct heapobj network_testZstr_ROOT_25;

extern struct heapobj network_L101;

extern void dylanZdylan_visceraZuninitialized_slot_error_FUN(descriptor_t *orig_sp, heapptr_t A0, descriptor_t A1);	/* uninitialized-slot-error */

extern struct heapobj network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZaddress_SLOT_HEAP;

extern struct heapobj dylanZdylan_visceraZCLS_false_HEAP;

extern struct heapobj dylanZdylan_visceraZCLS_true_HEAP;

extern struct heapobj network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZinterval_SLOT_HEAP;

extern struct heapobj dylanZdylan_visceraZCLS_boolean_HEAP;

extern struct heapobj network_testZstr_ROOT_26;

extern struct heapobj network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZfd_SLOT_HEAP;

extern struct heapobj network_testZstr_ROOT_27;

extern struct heapobj network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZdata_SLOT_HEAP;

/* initialize{<streamer>} */
descriptor_t * network_testZnetwork_testZinitialize_METH(descriptor_t *orig_sp, heapptr_t A_s /* s */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_bitrate /* bitrate */, descriptor_t A_target_address /* target-address */)
{
    descriptor_t *cluster_0_top;
    descriptor_t *cluster_1_top;
    descriptor_t L_temp;
    heapptr_t L_orig_args; /* orig-args */
    descriptor_t L_temp_2;
    heapptr_t L_temp_3; /* temp */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp_4;
    heapptr_t L_next_method_info; /* next-method-info */
    descriptor_t L_head; /* head */
    heapptr_t L_next; /* next */
    descriptor_t L_tail; /* tail */
    heapptr_t L_remaining_infos; /* remaining-infos */
    heapptr_t L_next_2; /* next */
    descriptor_t L_data; /* data */
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_5;
    descriptor_t L_arg0; /* arg0 */
    descriptor_t L_arg0_2; /* arg0 */
    descriptor_t L_temp_6;
    descriptor_t L_arg1_2; /* arg1 */
    descriptor_t L_new_value; /* new-value */
    descriptor_t L_interval; /* interval */
    descriptor_t L_temp_7;
    heapptr_t L_temp_8; /* temp */
    heapptr_t L_instance_2; /* instance */
    descriptor_t L_temp_9;
    heapptr_t L_temp_10; /* temp */
    void * L_host; /* host */
    heapptr_t L_instance_3; /* instance */
    descriptor_t L_new_value_2; /* new-value */
    void * L_raw_value; /* raw-value */
    long L_result; /* result */
    descriptor_t L_address; /* address */
    long L_result_2; /* result */
    long L_i; /* i */
    long L_i_2; /* i */
    descriptor_t L_temp_11;
    descriptor_t L_temp_12;
    descriptor_t L_temp_13; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result_3; /* result */
    descriptor_t L_temp_14;
    descriptor_t L_temp_15;
    descriptor_t L_arg0_3; /* arg0 */
    descriptor_t L_temp_16;
    descriptor_t L_new_value_3; /* new-value */
    descriptor_t L_address_2; /* address */
    descriptor_t L_arg1_3; /* arg1 */
    descriptor_t L_temp_17;
    descriptor_t L_temp_18;
    descriptor_t L_temp_19;
    descriptor_t L_temp_20;
    long L_new_value_4; /* new-value */
    descriptor_t L_address_3; /* address */
    long L_new_value_5; /* new-value */
    descriptor_t L_temp_21;
    descriptor_t L_fd; /* fd */
    int L_temp_22; /* temp */
    heapptr_t L_PCTobject_class; /* %object-class */
    int L_temp_23; /* temp */
    int L_result_4; /* result */
    heapptr_t L_instance_4; /* instance */
    descriptor_t L_temp_24;
    descriptor_t L_interval_2; /* interval */
    descriptor_t L_new_value_6; /* new-value */
    descriptor_t L_temp_25;
    descriptor_t L_temp_26;
    descriptor_t L_temp_27;
    descriptor_t L_temp_28;
    descriptor_t L_temp_29;
    descriptor_t L_temp_30;
    descriptor_t L_temp_31;
    descriptor_t L_temp_32;
    descriptor_t L_temp_33;
    descriptor_t L_temp_34;
    descriptor_t L_temp_35;

    L_temp.heapptr = A_s;
    L_temp.dataword.l = 0;
    cluster_0_top = orig_sp + 1;
    orig_sp[0] = L_temp;
    cluster_1_top = values_sequence(cluster_0_top, A_rest);
    cluster_0_top = cluster_1_top;
    L_orig_args = dylanZdylan_visceraZmake_rest_arg_FUN(cluster_0_top, orig_sp + 0, cluster_0_top - orig_sp - 0);

    /* #line 151 "./network-test.dylan" */
    if ((L_temp_2 = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
    L_temp_3 = L_temp_2.heapptr;

    /* #line 151 "./network-test.dylan" */
    /* force-output{<buffered-stream>} */
    streamsZstreamsZforce_output_METH(orig_sp, L_temp_3, &dylanZempty_list_ROOT);

    /* #line 152 "./network-test.dylan" */
    if ((A_next_method_info == &dylanZempty_list_ROOT)) {
	/* maker for <simple-object-vector> */
	L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
	L_temp_4.heapptr = &network_testZstr_ROOT_24;
	L_temp_4.dataword.l = 0;
	/* error{<string>} */
	dylanZdylan_visceraZerror_METH(orig_sp, L_temp_4, &dylanZempty_list_ROOT, L_instance);
	not_reached();
    }
    else {
	/* #line {Class <unknown-source-location>} */
	L_next_method_info = A_next_method_info;

	/* #line 152 "./network-test.dylan" */
	L_head = SLOT(L_next_method_info, descriptor_t, 4);
	L_next = L_head.heapptr;
	L_tail = SLOT(L_next_method_info, descriptor_t, 12);
	L_remaining_infos = L_tail.heapptr;
	if ((&dylanZdylan_visceraZCLS_pair_HEAP == SLOT(L_next, heapptr_t, 0))) {
	    /* #line {Class <unknown-source-location>} */

	    /* #line 152 "./network-test.dylan" */
	    /* ambiguous-method-error */
	    dylanZdylan_visceraZambiguous_method_error_FUN(orig_sp, L_next);
	    not_reached();
	}
	else {
	    /* #line {Class <unknown-source-location>} */

	    /* #line 152 "./network-test.dylan" */
	    cluster_0_top = values_sequence(orig_sp, L_orig_args);
	    L_next_2 = L_next;
	    GENERIC_ENTRY(L_next_2)(cluster_0_top, L_next_2, cluster_0_top - orig_sp, L_remaining_infos);

	    /* #line 153 "./network-test.dylan" */
	    L_data = SLOT(A_s, descriptor_t, 44);
	    if ((L_data.heapptr != NULL)) {

		/* #line 153 "./network-test.dylan" */
		orig_sp[0] = L_data;
		/* size */
		{
		  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 1, &dylanZdylan_visceraZsize_HEAP, 1);
		  heapptr_t L_meth = L_temp.R0;
		  heapptr_t L_next_info = L_temp.R1;
		  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 1, L_meth, 1, L_next_info);
		}
		L_arg1 = orig_sp[0];

		/* #line 153 "./network-test.dylan" */
		L_temp_5.heapptr = &dylanZdylan_visceraZCLS_double_float_HEAP;
		L_temp_5.dataword.l = 0;
		orig_sp[0] = L_temp_5;
		orig_sp[1] = L_arg1;
		/* as */
		{
		  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
		  heapptr_t L_meth = L_temp.R0;
		  heapptr_t L_next_info = L_temp.R1;
		  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
		}
		L_arg0 = orig_sp[0];

		/* #line 153 "./network-test.dylan" */
		orig_sp[0] = L_arg0;
		orig_sp[1] = network_testZliteral_9;
		/* * */
		{
		  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
		  heapptr_t L_meth = L_temp.R0;
		  heapptr_t L_next_info = L_temp.R1;
		  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
		}
		L_arg0_2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

		/* #line 154 "./network-test.dylan" */
		L_temp_6.heapptr = &dylanZdylan_visceraZCLS_double_float_HEAP;
		L_temp_6.dataword.l = 0;
		orig_sp[0] = L_temp_6;
		orig_sp[1] = A_bitrate;
		/* as */
		{
		  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
		  heapptr_t L_meth = L_temp.R0;
		  heapptr_t L_next_info = L_temp.R1;
		  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
		}
		L_arg1_2 = orig_sp[0];

		/* #line 154 "./network-test.dylan" */
		orig_sp[0] = L_arg0_2;
		orig_sp[1] = L_arg1_2;
		/* / */
		{
		  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZSLASH_HEAP, 2);
		  heapptr_t L_meth = L_temp.R0;
		  heapptr_t L_next_info = L_temp.R1;
		  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
		}
		L_new_value = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);
		/* #line {Class <unknown-source-location>} */
		SLOT(A_s, descriptor_t, 20) = L_new_value;

		/* #line 156 "./network-test.dylan" */
		L_interval = SLOT(A_s, descriptor_t, 20);
		if ((L_interval.heapptr != NULL)) {

		    /* #line 36 "./format-out.dylan" */
		    if ((L_temp_7 = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
		    L_temp_8 = L_temp_7.heapptr;

		    /* #line 36 "./format-out.dylan" */
		    /* maker for <simple-object-vector> */
		    L_instance_2 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 1, dylanZfalse);
		    SLOT(L_instance_2, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_interval;
		    /* format{<buffered-stream>, <byte-string>} */
		    formatZformatZformat_METH(orig_sp, L_temp_8, &network_testZstr_ROOT_25, &network_testZliteral_ROOT_5, L_instance_2);

		    /* #line 157 "./network-test.dylan" */
		    if ((L_temp_9 = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
		    L_temp_10 = L_temp_9.heapptr;

		    /* #line 157 "./network-test.dylan" */
		    /* force-output{<buffered-stream>} */
		    streamsZstreamsZforce_output_METH(orig_sp, L_temp_10, &dylanZempty_list_ROOT);

		    /* #line 386 "./condition.dylan" */
		    if ((&dylanZdylan_visceraZCLS_byte_string_HEAP == SLOT(A_target_address.heapptr, heapptr_t, 0))) {

			/* #line 159 "./network-test.dylan" */
			/* gethostbyname{<byte-string>} */
			L_host = networkZnetwork_internalZgethostbyname_METH(orig_sp, A_target_address.heapptr, &dylanZempty_list_ROOT);

			/* #line 160 "./network-test.dylan" */
			/* maker for <simple-object-vector> */
			L_instance_3 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
			/* make{subclass(<statically-typed-pointer>)} */
			L_new_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_sockaddr_in_HEAP, &network_testZliteral_ROOT, L_instance_3, 0, dylanZfalse, 1);
			/* #line {Class <unknown-source-location>} */
			SLOT(A_s, descriptor_t, 12) = L_new_value_2;

			/* #line 198 "./melange.dylan" */
			L_raw_value = L_host;

			/* #line 91 "./rawptr.dylan" */

			/* #line 161 "./network-test.dylan" */
			L_result = (*(long *)((char *)L_raw_value + 8 ));
			L_address = SLOT(A_s, descriptor_t, 12);
			if ((L_address.heapptr != NULL)) {

			    /* #line 386 "./condition.dylan" */
			    if ((&networkZnetwork_internalZCLS_sockaddr_in_HEAP == SLOT(L_address.heapptr, heapptr_t, 0))) {
				/* #line {Class <unknown-source-location>} */

				/* #line 97 "./rawptr.dylan" */
				*(unsigned short *)((char *)L_address.dataword.ptr + 0) = L_result;

				/* #line 91 "./rawptr.dylan" */
				/* #line {Class <compound-macro-source-location>} */
				L_result_2 = (*(long *)((char *)L_raw_value + 12 ));
				L_i = 0;
				while (1) {
				    /* #line {Class <unknown-source-location>} */
				    L_i_2 = L_i;

				    /* #line 148 "./cmp.dylan" */
				    if ((L_i_2 < L_result_2)) {

					/* #line 91 "./rawptr.dylan" */

					/* #line 290 "./melange.dylan" */
					L_temp_11.heapptr = &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP;
					L_temp_11.dataword.l = 0;
					L_temp_12.heapptr = network_testZliteral_4.heapptr;
					L_temp_12.dataword.ptr = (*(void * *)((char *)L_raw_value + 16 ));
					orig_sp[0] = L_temp_11;
					orig_sp[1] = L_temp_12;
					/* as */
					{
					  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
					  heapptr_t L_meth = L_temp.R0;
					  heapptr_t L_next_info = L_temp.R1;
					  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
					}
					L_temp_13 = orig_sp[0];

					/* #line 49 "./object.dylan" */

					/* #line 386 "./condition.dylan" */
					/* %subtype?{<class>, <class>} */
					L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_13.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
					if (L_condition) {

					    /* #line 290 "./melange.dylan" */
					    L_result_3 = L_temp_13;

					    /* #line 386 "./condition.dylan" */
					    if ((&networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP == SLOT(L_result_3.heapptr, heapptr_t, 0))) {

						/* #line 2951 "./sockets-api.dylan" */

						/* #line 164 "./network-test.dylan" */
						L_temp_14.heapptr = network_testZliteral_5.heapptr;
						L_temp_14.dataword.ptr = L_result_3.dataword.ptr;
						L_temp_15.heapptr = network_testZliteral_2.heapptr;
						L_temp_15.dataword.l = 0;
						orig_sp[0] = L_temp_14;
						orig_sp[1] = L_temp_15;
						/* element */
						{
						  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZelement_HEAP, 2);
						  heapptr_t L_meth = L_temp.R0;
						  heapptr_t L_next_info = L_temp.R1;
						  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
						}
						L_arg0_3 = orig_sp[0];

						/* #line 164 "./network-test.dylan" */
						L_temp_16.heapptr = network_testZliteral_2.heapptr;
						L_temp_16.dataword.l = L_i_2;
						orig_sp[0] = L_arg0_3;
						orig_sp[1] = L_temp_16;
						/* element */
						{
						  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZelement_HEAP, 2);
						  heapptr_t L_meth = L_temp.R0;
						  heapptr_t L_next_info = L_temp.R1;
						  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
						}
						L_new_value_3 = orig_sp[0];

						/* #line 163 "./network-test.dylan" */
						L_address_2 = SLOT(A_s, descriptor_t, 12);
						if ((L_address_2.heapptr != NULL)) {

						    /* #line 163 "./network-test.dylan" */
						    orig_sp[0] = L_address_2;
						    /* get-sa-data */
						    {
						      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 1, &network_L101, 1);
						      heapptr_t L_meth = L_temp.R0;
						      heapptr_t L_next_info = L_temp.R1;
						      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 1, L_meth, 1, L_next_info);
						    }
						    L_arg1_3 = orig_sp[0];

						    /* #line 163 "./network-test.dylan" */
						    /* #line {Class <unknown-source-location>} */
						    L_temp_17.heapptr = network_testZliteral_2.heapptr;
						    L_temp_17.dataword.l = (L_i_2 + 2);
						    orig_sp[0] = L_new_value_3;
						    orig_sp[1] = L_arg1_3;
						    orig_sp[2] = L_temp_17;
						    /* element-setter */
						    {
						      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 3, &dylanZdylan_visceraZelement_setter_HEAP, 3);
						      heapptr_t L_meth = L_temp.R0;
						      heapptr_t L_next_info = L_temp.R1;
						      GENERIC_ENTRY(L_meth)(orig_sp + 3, L_meth, 3, L_next_info);
						    }
						    /* #line {Class <compound-macro-source-location>} */
						    L_i = (L_i_2 + 1);
						}
						else {

						    /* #line 163 "./network-test.dylan" */
						    L_temp_18.heapptr = A_s;
						    L_temp_18.dataword.l = 0;
						    /* uninitialized-slot-error */
						    dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZaddress_SLOT_HEAP, L_temp_18);
						    not_reached();
						}
					    }
					    else {

						/* #line 389 "./condition.dylan" */
						L_temp_19.heapptr = &network_testZstr_ROOT_8;
						L_temp_19.dataword.l = 0;
						/* type-error-with-location */
						dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_3, &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP, L_temp_19);
						not_reached();
					    }
					}
					else {
					    L_temp_20.heapptr = &network_testZstr_ROOT_9;
					    L_temp_20.dataword.l = 0;
					    /* type-error-with-location */
					    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_13, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_20);
					    not_reached();
					}
				    }
				    else {
					goto block0;
				    }
				}
			      block0:;

				/* #line 166 "./network-test.dylan" */
				/* htons{<integer>} */
				L_new_value_4 = networkZnetwork_internalZhtons_METH(orig_sp, 1178, &dylanZempty_list_ROOT);

				/* #line 166 "./network-test.dylan" */
				L_address_3 = SLOT(A_s, descriptor_t, 12);
				if ((L_address_3.heapptr != NULL)) {

				    /* #line 386 "./condition.dylan" */
				    if ((&networkZnetwork_internalZCLS_sockaddr_in_HEAP == SLOT(L_address_3.heapptr, heapptr_t, 0))) {
					/* #line {Class <unknown-source-location>} */

					/* #line 97 "./rawptr.dylan" */
					*(unsigned short *)((char *)L_address_3.dataword.ptr + 2) = L_new_value_4;

					/* #line 168 "./network-test.dylan" */
					/* socket{<integer>, <integer>, <integer>} */
					L_new_value_5 = networkZnetwork_internalZsocket_METH(orig_sp, 2, 2, 17, &dylanZempty_list_ROOT);
					/* #line {Class <unknown-source-location>} */
					L_temp_21.heapptr = network_testZliteral_2.heapptr;
					L_temp_21.dataword.l = L_new_value_5;
					SLOT(A_s, descriptor_t, 4) = L_temp_21;

					/* #line 169 "./network-test.dylan" */
					L_fd = SLOT(A_s, descriptor_t, 4);
					if ((L_fd.heapptr != NULL)) {

					    /* #line 169 "./network-test.dylan" */
					    L_temp_22 = (&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_fd.heapptr, heapptr_t, 0));

					    /* #line 386 "./condition.dylan" */
					    L_PCTobject_class = SLOT((L_temp_22 ? obj_True : obj_False), heapptr_t, 0);
					    if ((&dylanZdylan_visceraZCLS_false_HEAP == L_PCTobject_class)) {
						L_temp_23 = TRUE;
					    }
					    else {
						L_temp_23 = (&dylanZdylan_visceraZCLS_true_HEAP == L_PCTobject_class);
					    }
					    if (L_temp_23) {

						/* #line 169 "./network-test.dylan" */
						if (L_temp_22) {
						    L_result_4 = (-1 == L_fd.dataword.l);
						}
						else {
						    L_result_4 = FALSE;
						}
						if (L_result_4) {

						    /* #line 170 "./network-test.dylan" */
						    /* maker for <simple-object-vector> */
						    L_instance_4 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
						    L_temp_24.heapptr = &network_testZstr_ROOT_10;
						    L_temp_24.dataword.l = 0;
						    /* error{<string>} */
						    dylanZdylan_visceraZerror_METH(orig_sp, L_temp_24, &dylanZempty_list_ROOT, L_instance_4);
						    not_reached();
						}
						else {

						    /* #line 172 "./network-test.dylan" */
						    L_interval_2 = SLOT(A_s, descriptor_t, 20);
						    if ((L_interval_2.heapptr != NULL)) {
							/* #line {Class <unknown-source-location>} */
							SLOT(A_s, descriptor_t, 28) = L_interval_2;

							/* #line 173 "./network-test.dylan" */
							/* now{} */
							cluster_0_top = network_testZnetwork_testZnow_METH(orig_sp, &dylanZempty_list_ROOT);
							L_new_value_6 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);
							/* #line {Class <unknown-source-location>} */
							SLOT(A_s, descriptor_t, 36) = L_new_value_6;
							orig_sp[0] = L_new_value_6;
							return orig_sp + 1;
						    }
						    else {

							/* #line 172 "./network-test.dylan" */
							L_temp_25.heapptr = A_s;
							L_temp_25.dataword.l = 0;
							/* uninitialized-slot-error */
							dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZinterval_SLOT_HEAP, L_temp_25);
							not_reached();
						    }
						}
					    }
					    else {

						/* #line 389 "./condition.dylan" */
						L_temp_26.heapptr = (L_temp_22 ? obj_True : obj_False);
						L_temp_26.dataword.l = 0;
						L_temp_27.heapptr = &network_testZstr_ROOT_26;
						L_temp_27.dataword.l = 0;
						/* type-error-with-location */
						dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_26, &dylanZdylan_visceraZCLS_boolean_HEAP, L_temp_27);
						not_reached();
					    }
					}
					else {

					    /* #line 169 "./network-test.dylan" */
					    L_temp_28.heapptr = A_s;
					    L_temp_28.dataword.l = 0;
					    /* uninitialized-slot-error */
					    dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZfd_SLOT_HEAP, L_temp_28);
					    not_reached();
					}
				    }
				    else {

					/* #line 389 "./condition.dylan" */
					L_temp_29.heapptr = &network_testZstr_ROOT;
					L_temp_29.dataword.l = 0;
					/* type-error-with-location */
					dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_address_3, &networkZnetwork_internalZCLS_sockaddr_in_HEAP, L_temp_29);
					not_reached();
				    }
				}
				else {

				    /* #line 166 "./network-test.dylan" */
				    L_temp_30.heapptr = A_s;
				    L_temp_30.dataword.l = 0;
				    /* uninitialized-slot-error */
				    dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZaddress_SLOT_HEAP, L_temp_30);
				    not_reached();
				}
			    }
			    else {

				/* #line 389 "./condition.dylan" */
				L_temp_31.heapptr = &network_testZstr_ROOT;
				L_temp_31.dataword.l = 0;
				/* type-error-with-location */
				dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_address, &networkZnetwork_internalZCLS_sockaddr_in_HEAP, L_temp_31);
				not_reached();
			    }
			}
			else {

			    /* #line 161 "./network-test.dylan" */
			    L_temp_32.heapptr = A_s;
			    L_temp_32.dataword.l = 0;
			    /* uninitialized-slot-error */
			    dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZaddress_SLOT_HEAP, L_temp_32);
			    not_reached();
			}
		    }
		    else {

			/* #line 389 "./condition.dylan" */
			L_temp_33.heapptr = &network_testZstr_ROOT_27;
			L_temp_33.dataword.l = 0;
			/* type-error-with-location */
			dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, A_target_address, &dylanZdylan_visceraZCLS_byte_string_HEAP, L_temp_33);
			not_reached();
		    }
		}
		else {

		    /* #line 156 "./network-test.dylan" */
		    L_temp_34.heapptr = A_s;
		    L_temp_34.dataword.l = 0;
		    /* uninitialized-slot-error */
		    dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZinterval_SLOT_HEAP, L_temp_34);
		    not_reached();
		}
	    }
	    else {

		/* #line 153 "./network-test.dylan" */
		L_temp_35.heapptr = A_s;
		L_temp_35.dataword.l = 0;
		/* uninitialized-slot-error */
		dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZdata_SLOT_HEAP, L_temp_35);
		not_reached();
	    }
	}
    }
}

extern struct heapobj SYM_bitrate_HEAP;

extern struct heapobj SYM_target_address_HEAP;

/* generic-entry for initialize{<streamer>} */
descriptor_t * network_testZnetwork_testZinitialize_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    heapptr_t L_arg_2; /* arg */
    descriptor_t L_bitrate; /* bitrate */
    descriptor_t L_target_address; /* target-address */
    long L_index; /* index */
    descriptor_t L_key; /* key */
    heapptr_t L_key_2; /* key */
    descriptor_t L_value; /* value */

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.heapptr;
    L_bitrate = dylanZfalse;
    L_target_address = dylanZfalse;
    L_index = (A_nargs - 2);
    while (1) {
	if ((L_index < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index]);
	    L_key_2 = L_key.heapptr;
	    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
	    if ((L_key_2 == &SYM_bitrate_HEAP)) {
		L_bitrate = L_value;
	    }
	    else if ((L_key_2 == &SYM_target_address_HEAP)) {
		L_target_address = L_value;
	    }
	    L_index = (L_index - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* initialize{<streamer>} */
    cluster_0_top = network_testZnetwork_testZinitialize_METH(orig_sp, L_arg_2, A_next_method_info, L_rest, L_bitrate, L_target_address);
    return cluster_0_top;
}


/* {Implicit} Define Generic bitrate */

/* bitrate is bitrate */


/* Define Method bitrate{<streamer>} */

extern struct heapobj network_testZstr_ROOT_28;

/* bitrate{<streamer>} */
double network_testZnetwork_testZbitrate_METH(descriptor_t *orig_sp, heapptr_t A_s /* s */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_data; /* data */
    descriptor_t L_arg0; /* arg0 */
    descriptor_t L_arg0_2; /* arg0 */
    descriptor_t L_interval; /* interval */
    descriptor_t L_temp; /* temp */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4;


    /* #line 177 "./network-test.dylan" */
    L_data = SLOT(A_s, descriptor_t, 44);
    if ((L_data.heapptr != NULL)) {

	/* #line 177 "./network-test.dylan" */
	orig_sp[0] = L_data;
	/* size */
	{
	  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 1, &dylanZdylan_visceraZsize_HEAP, 1);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 1, L_meth, 1, L_next_info);
	}
	L_arg0 = orig_sp[0];

	/* #line 177 "./network-test.dylan" */
	orig_sp[0] = L_arg0;
	orig_sp[1] = network_testZliteral_9;
	/* * */
	{
	  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_arg0_2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

	/* #line 177 "./network-test.dylan" */
	L_interval = SLOT(A_s, descriptor_t, 20);
	if ((L_interval.heapptr != NULL)) {

	    /* #line 177 "./network-test.dylan" */
	    orig_sp[0] = L_arg0_2;
	    orig_sp[1] = L_interval;
	    /* / */
	    {
	      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZSLASH_HEAP, 2);
	      heapptr_t L_meth = L_temp.R0;
	      heapptr_t L_next_info = L_temp.R1;
	      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	    }
	    L_temp = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

	    /* #line 386 "./condition.dylan" */
	    if ((&dylanZdylan_visceraZCLS_double_float_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {

		/* #line 177 "./network-test.dylan" */
		return double_float_value(L_temp.heapptr);
	    }
	    else {

		/* #line 389 "./condition.dylan" */
		L_temp_2.heapptr = &network_testZstr_ROOT_28;
		L_temp_2.dataword.l = 0;
		/* type-error-with-location */
		dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_double_float_HEAP, L_temp_2);
		not_reached();
	    }
	}
	else {

	    /* #line 177 "./network-test.dylan" */
	    L_temp_3.heapptr = A_s;
	    L_temp_3.dataword.l = 0;
	    /* uninitialized-slot-error */
	    dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZinterval_SLOT_HEAP, L_temp_3);
	    not_reached();
	}
    }
    else {

	/* #line 177 "./network-test.dylan" */
	L_temp_4.heapptr = A_s;
	L_temp_4.dataword.l = 0;
	/* uninitialized-slot-error */
	dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZdata_SLOT_HEAP, L_temp_4);
	not_reached();
    }
}


/* Define Constant *expected-jitter* */

/* *expected-jitter* is 0.1d0 */


/* {Implicit} Define Generic send-data */

/* send-data is send-data */


/* Define Method send-data{<streamer>} */

extern descriptor_t network_testZliteral_10;	/* 0.1d0 */

extern struct heapobj dylanZdylan_visceraZPLUS_HEAP;

extern struct heapobj dylanZdylan_visceraZLESS_HEAP;

extern descriptor_t network_testZliteral_11;	/* 1.01d0 */

extern struct heapobj network_testZstr_ROOT_29;

extern struct heapobj network_testZstr_ROOT_30;

extern struct heapobj network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZlast_sent_SLOT_HEAP;

extern struct heapobj networkZnetwork_internalZCLS_sockaddr_HEAP;

extern struct heapobj network_testZstr_ROOT_31;

/* send-data{<streamer>} */
descriptor_t * network_testZnetwork_testZsend_data_METH(descriptor_t *orig_sp, heapptr_t A_s /* s */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_stamp; /* stamp */
    descriptor_t L_last_sent; /* last-sent */
    descriptor_t L_arg1; /* arg1 */
    int L_answer; /* answer */
    descriptor_t L_interval; /* interval */
    descriptor_t L_new_value; /* new-value */
    descriptor_t L_temp;
    heapptr_t L_temp_2; /* temp */
    heapptr_t L_instance; /* instance */
    double L_arg1_2; /* arg1 */
    descriptor_t L_temp_3;
    heapptr_t L_temp_4; /* temp */
    heapptr_t L_instance_2; /* instance */
    descriptor_t L_temp_5;
    descriptor_t L_last_sent_2; /* last-sent */
    descriptor_t L_temp_6;
    descriptor_t L_new_value_2; /* new-value */
    descriptor_t L_temp_7;
    heapptr_t L_temp_8; /* temp */
    descriptor_t L_temp_9;
    descriptor_t L_temp_10;
    descriptor_t L_fd; /* fd */
    descriptor_t L_data; /* data */
    descriptor_t L_data_2; /* data */
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_address; /* address */
    descriptor_t L_temp_11;
    long L_arg5; /* arg5 */
    long L_temp_12; /* temp */
    heapptr_t L_temp_13; /* temp */
    heapptr_t L_PCTobject_class; /* %object-class */
    long L_temp_14; /* temp */
    int L_temp_15; /* temp */
    long L_rc; /* rc */
    heapptr_t L_instance_3; /* instance */
    descriptor_t L_temp_16;
    descriptor_t L_last_sent_3; /* last-sent */
    descriptor_t L_interval_2; /* interval */
    descriptor_t L_new_value_3; /* new-value */
    descriptor_t L_temp_17;
    descriptor_t L_temp_18;
    descriptor_t L_temp_19;
    descriptor_t L_temp_20;
    descriptor_t L_temp_21;
    descriptor_t L_temp_22;
    descriptor_t L_temp_23;
    descriptor_t L_temp_24;
    descriptor_t L_temp_25;
    descriptor_t L_temp_26;
    descriptor_t L_temp_27;

    /* #line {Class <unknown-source-location>} */

    /* #line 183 "./network-test.dylan" */
    /* now{} */
    cluster_0_top = network_testZnetwork_testZnow_METH(orig_sp, &dylanZempty_list_ROOT);
    L_stamp = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 190 "./network-test.dylan" */
    L_last_sent = SLOT(A_s, descriptor_t, 36);
    if ((L_last_sent.heapptr != NULL)) {

	/* #line 190 "./network-test.dylan" */
	orig_sp[0] = L_last_sent;
	orig_sp[1] = network_testZliteral_10;
	/* + */
	{
	  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

	/* #line 182 "./cmp.dylan" */
	orig_sp[0] = L_arg1;
	orig_sp[1] = L_stamp;
	/* < */
	{
	  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZLESS_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_answer = (orig_sp[0].heapptr != obj_False);
	if (L_answer) {

	    /* #line 191 "./network-test.dylan" */
	    L_interval = SLOT(A_s, descriptor_t, 20);
	    if ((L_interval.heapptr != NULL)) {

		/* #line 191 "./network-test.dylan" */
		orig_sp[0] = L_interval;
		orig_sp[1] = network_testZliteral_11;
		/* * */
		{
		  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
		  heapptr_t L_meth = L_temp.R0;
		  heapptr_t L_next_info = L_temp.R1;
		  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
		}
		L_new_value = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);
		/* #line {Class <unknown-source-location>} */
		SLOT(A_s, descriptor_t, 20) = L_new_value;

		/* #line 36 "./format-out.dylan" */
		if ((L_temp = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
		L_temp_2 = L_temp.heapptr;

		/* #line 36 "./format-out.dylan" */
		/* maker for <simple-object-vector> */
		L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
		/* format{<buffered-stream>, <byte-string>} */
		formatZformatZformat_METH(orig_sp, L_temp_2, &network_testZstr_ROOT_29, &network_testZliteral_ROOT_5, L_instance);

		/* #line 193 "./network-test.dylan" */
		/* bitrate{<streamer>} */
		L_arg1_2 = network_testZnetwork_testZbitrate_METH(orig_sp, A_s, &dylanZempty_list_ROOT);

		/* #line 36 "./format-out.dylan" */
		if ((L_temp_3 = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
		L_temp_4 = L_temp_3.heapptr;

		/* #line 36 "./format-out.dylan" */
		/* maker for <simple-object-vector> */
		L_instance_2 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 1, dylanZfalse);
		L_temp_5.heapptr = make_double_float(L_arg1_2);
		L_temp_5.dataword.l = 0;
		SLOT(L_instance_2, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp_5;
		/* format{<buffered-stream>, <byte-string>} */
		formatZformatZformat_METH(orig_sp, L_temp_4, &network_testZstr_ROOT_30, &network_testZliteral_ROOT_5, L_instance_2);

		/* #line 194 "./network-test.dylan" */
		L_last_sent_2 = SLOT(A_s, descriptor_t, 36);
		if ((L_last_sent_2.heapptr != NULL)) {

		    /* #line 1335 "./num.dylan" */

		    /* #line 194 "./network-test.dylan" */
		    L_temp_6.heapptr = make_double_float((0.1e0 / 0.2e1));
		    L_temp_6.dataword.l = 0;
		    orig_sp[0] = L_last_sent_2;
		    orig_sp[1] = L_temp_6;
		    /* + */
		    {
		      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
		      heapptr_t L_meth = L_temp.R0;
		      heapptr_t L_next_info = L_temp.R1;
		      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
		    }
		    L_new_value_2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);
		    /* #line {Class <unknown-source-location>} */
		    SLOT(A_s, descriptor_t, 36) = L_new_value_2;

		    /* #line 195 "./network-test.dylan" */
		    if ((L_temp_7 = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
		    L_temp_8 = L_temp_7.heapptr;

		    /* #line 195 "./network-test.dylan" */
		    /* force-output{<buffered-stream>} */
		    streamsZstreamsZforce_output_METH(orig_sp, L_temp_8, &dylanZempty_list_ROOT);
		}
		else {

		    /* #line 194 "./network-test.dylan" */
		    L_temp_9.heapptr = A_s;
		    L_temp_9.dataword.l = 0;
		    /* uninitialized-slot-error */
		    dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZlast_sent_SLOT_HEAP, L_temp_9);
		    not_reached();
		}
	    }
	    else {

		/* #line 191 "./network-test.dylan" */
		L_temp_10.heapptr = A_s;
		L_temp_10.dataword.l = 0;
		/* uninitialized-slot-error */
		dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZinterval_SLOT_HEAP, L_temp_10);
		not_reached();
	    }
	}

	/* #line 204 "./network-test.dylan" */
	L_fd = SLOT(A_s, descriptor_t, 4);
	if ((L_fd.heapptr != NULL)) {

	    /* #line 204 "./network-test.dylan" */
	    L_data = SLOT(A_s, descriptor_t, 44);
	    if ((L_data.heapptr != NULL)) {

		/* #line 204 "./network-test.dylan" */
		L_data_2 = SLOT(A_s, descriptor_t, 44);
		if ((L_data_2.heapptr != NULL)) {

		    /* #line 204 "./network-test.dylan" */
		    orig_sp[0] = L_data_2;
		    /* size */
		    {
		      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 1, &dylanZdylan_visceraZsize_HEAP, 1);
		      heapptr_t L_meth = L_temp.R0;
		      heapptr_t L_next_info = L_temp.R1;
		      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 1, L_meth, 1, L_next_info);
		    }
		    L_arg2 = orig_sp[0];

		    /* #line 205 "./network-test.dylan" */
		    L_address = SLOT(A_s, descriptor_t, 12);
		    if ((L_address.heapptr != NULL)) {

			/* #line 205 "./network-test.dylan" */
			L_temp_11.heapptr = &networkZnetwork_internalZCLS_sockaddr_in_HEAP;
			L_temp_11.dataword.l = 0;
			orig_sp[0] = L_temp_11;
			/* content-size */
			{
			  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 1, &melange_supportZmelange_supportZcontent_size_HEAP, 1);
			  heapptr_t L_meth = L_temp.R0;
			  heapptr_t L_next_info = L_temp.R1;
			  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 1, L_meth, 1, L_next_info);
			}
			L_arg5 = orig_sp[0].dataword.l;

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_fd.heapptr, heapptr_t, 0))) {

			    /* #line 205 "./network-test.dylan" */

			    /* #line 386 "./condition.dylan" */
			    L_temp_12 = L_fd.dataword.l;
			    if ((&dylanZdylan_visceraZCLS_byte_string_HEAP == SLOT(L_data.heapptr, heapptr_t, 0))) {

				/* #line 205 "./network-test.dylan" */

				/* #line 386 "./condition.dylan" */
				L_temp_13 = L_data.heapptr;
				if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

				    /* #line 205 "./network-test.dylan" */

				    /* #line 386 "./condition.dylan" */
				    L_PCTobject_class = SLOT(L_address.heapptr, heapptr_t, 0);
				    L_temp_14 = L_arg2.dataword.l;
				    if ((&networkZnetwork_internalZCLS_sockaddr_in_HEAP == L_PCTobject_class)) {
					L_temp_15 = TRUE;
				    }
				    else {
					L_temp_15 = (&networkZnetwork_internalZCLS_sockaddr_HEAP == L_PCTobject_class);
				    }
				    if (L_temp_15) {

					/* #line 205 "./network-test.dylan" */
					/* sendto{<integer>, <byte-string>, <integer>, <integer>, <sockaddr>, <integer>} */
					L_rc = networkZnetwork_internalZsendto_METH(orig_sp, L_temp_12, L_temp_13, L_temp_14, 0, L_address, L_arg5, &dylanZempty_list_ROOT);

					/* #line 206 "./network-test.dylan" */
					if ((L_rc == -1)) {

					    /* #line 207 "./network-test.dylan" */
					    /* maker for <simple-object-vector> */
					    L_instance_3 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
					    L_temp_16.heapptr = &network_testZstr_ROOT_18;
					    L_temp_16.dataword.l = 0;
					    /* error{<string>} */
					    dylanZdylan_visceraZerror_METH(orig_sp, L_temp_16, &dylanZempty_list_ROOT, L_instance_3);
					    not_reached();
					}
					else {

					    /* #line 210 "./network-test.dylan" */
					    L_last_sent_3 = SLOT(A_s, descriptor_t, 36);
					    if ((L_last_sent_3.heapptr != NULL)) {

						/* #line 210 "./network-test.dylan" */
						L_interval_2 = SLOT(A_s, descriptor_t, 20);
						if ((L_interval_2.heapptr != NULL)) {

						    /* #line 210 "./network-test.dylan" */
						    orig_sp[0] = L_last_sent_3;
						    orig_sp[1] = L_interval_2;
						    /* + */
						    {
						      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
						      heapptr_t L_meth = L_temp.R0;
						      heapptr_t L_next_info = L_temp.R1;
						      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
						    }
						    L_new_value_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);
						    /* #line {Class <unknown-source-location>} */
						    SLOT(A_s, descriptor_t, 36) = L_new_value_3;
						    orig_sp[0] = L_new_value_3;
						    return orig_sp + 1;
						}
						else {

						    /* #line 210 "./network-test.dylan" */
						    L_temp_17.heapptr = A_s;
						    L_temp_17.dataword.l = 0;
						    /* uninitialized-slot-error */
						    dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZinterval_SLOT_HEAP, L_temp_17);
						    not_reached();
						}
					    }
					    else {

						/* #line 210 "./network-test.dylan" */
						L_temp_18.heapptr = A_s;
						L_temp_18.dataword.l = 0;
						/* uninitialized-slot-error */
						dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZlast_sent_SLOT_HEAP, L_temp_18);
						not_reached();
					    }
					}
				    }
				    else {

					/* #line 389 "./condition.dylan" */
					L_temp_19.heapptr = &network_testZstr_ROOT_31;
					L_temp_19.dataword.l = 0;
					/* type-error-with-location */
					dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_address, &networkZnetwork_internalZCLS_sockaddr_HEAP, L_temp_19);
					not_reached();
				    }
				}
				else {
				    L_temp_20.heapptr = &network_testZstr_ROOT_31;
				    L_temp_20.dataword.l = 0;
				    /* type-error-with-location */
				    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, dylanZfalse, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_20);
				    not_reached();
				}
			    }
			    else {
				L_temp_21.heapptr = &network_testZstr_ROOT_31;
				L_temp_21.dataword.l = 0;
				/* type-error-with-location */
				dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_data, &dylanZdylan_visceraZCLS_byte_string_HEAP, L_temp_21);
				not_reached();
			    }
			}
			else {
			    L_temp_22.heapptr = &network_testZstr_ROOT_31;
			    L_temp_22.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_fd, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_22);
			    not_reached();
			}
		    }
		    else {

			/* #line 205 "./network-test.dylan" */
			L_temp_23.heapptr = A_s;
			L_temp_23.dataword.l = 0;
			/* uninitialized-slot-error */
			dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZaddress_SLOT_HEAP, L_temp_23);
			not_reached();
		    }
		}
		else {

		    /* #line 204 "./network-test.dylan" */
		    L_temp_24.heapptr = A_s;
		    L_temp_24.dataword.l = 0;
		    /* uninitialized-slot-error */
		    dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZdata_SLOT_HEAP, L_temp_24);
		    not_reached();
		}
	    }
	    else {

		/* #line 204 "./network-test.dylan" */
		L_temp_25.heapptr = A_s;
		L_temp_25.dataword.l = 0;
		/* uninitialized-slot-error */
		dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZdata_SLOT_HEAP, L_temp_25);
		not_reached();
	    }
	}
	else {

	    /* #line 204 "./network-test.dylan" */
	    L_temp_26.heapptr = A_s;
	    L_temp_26.dataword.l = 0;
	    /* uninitialized-slot-error */
	    dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZfd_SLOT_HEAP, L_temp_26);
	    not_reached();
	}
    }
    else {

	/* #line 190 "./network-test.dylan" */
	L_temp_27.heapptr = A_s;
	L_temp_27.dataword.l = 0;
	/* uninitialized-slot-error */
	dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZlast_sent_SLOT_HEAP, L_temp_27);
	not_reached();
    }
}


/* Top level form. */

extern struct heapobj network_testZstr_ROOT_32;

extern struct heapobj dylanZliteral_ROOT;

extern struct heapobj network_testZstr_ROOT_33;

extern struct heapobj network_testZstr_ROOT_34;

extern heapptr_t dylanZdylan_visceraZCLS_byte_string_MAKER_FUN(descriptor_t *orig_sp, long A0, long A1);	/* maker for <byte-string> */

extern struct heapobj dylanZdylan_visceraZmake_HEAP;

extern struct heapobj dylanZdylan_visceraZ__HEAP;

extern descriptor_t network_testZliteral_12;	/* 0.05d0 */

extern struct heapobj network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZwanted_interval_SLOT_HEAP;

extern struct heapobj network_testZstr_ROOT_35;

extern descriptor_t network_testZliteral_13;	/* 1000.0d0 */

struct mv_result_3 {
    descriptor_t R0;
    descriptor_t R1;
};

extern struct mv_result_3 dylanZdylan_visceraZfloor_DISCRIM_FUN(descriptor_t *orig_sp, descriptor_t A0);	/* discriminator for floor */

extern struct heapobj network_testZstr_ROOT_36;

extern struct heapobj dylanZdylan_visceraZCLS_real_HEAP;

extern struct heapobj network_testZstr_ROOT_37;

extern struct heapobj network_testZstr_ROOT_38;

/* form at {<known-source-location> 0x0983bdc0,
   source: {<source-file> 0x09df6510, name: "network-test.dylan"},
   start-line: 214,
   start-column: 2,
   end-line: 245,
   end-column: 12} */
void network_testZLINE_214(descriptor_t *orig_sp)
{
    descriptor_t *cluster_0_top;
    heapptr_t L_args; /* args */
    descriptor_t L_target_address; /* target-address */
    long L_data_size; /* data-size */
    long L_wanted_bitrate; /* wanted-bitrate */
    descriptor_t L_PCTelement; /* %element */
    descriptor_t L_PCTelement_2; /* %element */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    struct mv_result_0 L_temp_2;
    long L_new_value; /* new-value */
    descriptor_t L_PCTelement_3; /* %element */
    heapptr_t L_instance_2; /* instance */
    descriptor_t L_temp_3;
    struct mv_result_0 L_temp_4;
    long L_new_value_2; /* new-value */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6;
    heapptr_t L_instance_3; /* instance */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;
    descriptor_t L_temp_9;
    descriptor_t L_temp_10;
    descriptor_t L_temp_11;
    descriptor_t L_temp_12;
    descriptor_t L_foo; /* foo */
    heapptr_t L_temp_13; /* temp */
    descriptor_t L_stamp; /* stamp */
    descriptor_t L_last_sent; /* last-sent */
    int L_condition; /* condition */
    descriptor_t L_last_sent_2; /* last-sent */
    descriptor_t L_time_to_burn; /* time-to-burn */
    descriptor_t L_wanted_interval; /* wanted-interval */
    descriptor_t L_interval; /* interval */
    int L_condition_2; /* condition */
    descriptor_t L_interval_2; /* interval */
    descriptor_t L_wanted_interval_2; /* wanted-interval */
    descriptor_t L_less_time_wanted; /* less-time-wanted */
    descriptor_t L_wanted_interval_3; /* wanted-interval */
    descriptor_t L_arg1; /* arg1 */
    int L_condition_3; /* condition */
    descriptor_t L_wanted_interval_4; /* wanted-interval */
    descriptor_t L_temp_14;
    descriptor_t L_interval_3; /* interval */
    int L_condition_4; /* condition */
    descriptor_t L_res; /* res */
    descriptor_t L_arg1_2; /* arg1 */
    descriptor_t L_new_value_3; /* new-value */
    descriptor_t L_temp_15;
    double L_arg1_3; /* arg1 */
    descriptor_t L_temp_16;
    heapptr_t L_temp_17; /* temp */
    heapptr_t L_instance_4; /* instance */
    descriptor_t L_temp_18;
    descriptor_t L_temp_19;
    heapptr_t L_temp_20; /* temp */
    descriptor_t L_temp_21;
    descriptor_t L_temp_22;
    descriptor_t L_temp_23;
    descriptor_t L_temp_24;
    descriptor_t L_temp_25;
    descriptor_t L_arg0; /* arg0 */
    descriptor_t L_arg0_2; /* arg0 */
    long L_unique_id; /* unique-id */
    int L_temp_26; /* temp */
    struct mv_result_3 L_temp_27;
    descriptor_t L_arg2; /* arg2 */
    void * L_temp_28; /* temp */
    descriptor_t L_temp_29;
    descriptor_t L_temp_30;
    descriptor_t L_temp_31;
    descriptor_t L_temp_32;
    descriptor_t L_temp_33;
    descriptor_t L_temp_34;
    descriptor_t L_temp_35;
    descriptor_t L_temp_36;
    descriptor_t L_temp_37;

    /* #line {Class <unknown-source-location>} */

    /* #line 214 "./network-test.dylan" */
    /* application-arguments */
    L_args = common_extensionsZcommon_extensionsZapplication_arguments_FUN(orig_sp);

    /* #line 215 "./network-test.dylan" */

    /* #line 216 "./network-test.dylan" */
    L_target_address.heapptr = &network_testZstr_ROOT_32;
    L_target_address.dataword.l = 0;

    /* #line 217 "./network-test.dylan" */
    L_data_size = 1024;

    /* #line 218 "./network-test.dylan" */

    /* #line 218 "./network-test.dylan" */
    L_wanted_bitrate = 20000;
    if ((SLOT(L_args, long, 4) == 3)) {

	/* #line 142 "./vector.dylan" */
	L_PCTelement = SLOT(L_args, descriptor_t, 8 + 0 * sizeof(descriptor_t));

	/* #line 219 "./network-test.dylan" */

	/* #line 142 "./vector.dylan" */
	L_target_address = L_PCTelement;
	L_PCTelement_2 = SLOT(L_args, descriptor_t, 8 + 1 * sizeof(descriptor_t));

	/* #line 386 "./condition.dylan" */
	if ((&dylanZdylan_visceraZCLS_byte_string_HEAP == SLOT(L_PCTelement_2.heapptr, heapptr_t, 0))) {

	    /* #line 220 "./network-test.dylan" */
	    /* maker for <simple-object-vector> */
	    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
	    L_temp.heapptr = &dylanZliteral_ROOT;
	    L_temp.dataword.l = 0;
	    /* string-to-integer{<byte-string>} */
	    L_temp_2 = common_extensionsZcommon_extensionsZstring_to_integer_METH(orig_sp, L_PCTelement_2.heapptr, &dylanZempty_list_ROOT, L_instance, 10, 0, 0, FALSE, L_temp);
	    L_new_value = L_temp_2.R0;

	    /* #line 220 "./network-test.dylan" */

	    /* #line 142 "./vector.dylan" */
	    L_data_size = L_new_value;
	    L_PCTelement_3 = SLOT(L_args, descriptor_t, 8 + 2 * sizeof(descriptor_t));

	    /* #line 386 "./condition.dylan" */
	    if ((&dylanZdylan_visceraZCLS_byte_string_HEAP == SLOT(L_PCTelement_3.heapptr, heapptr_t, 0))) {

		/* #line 221 "./network-test.dylan" */
		/* maker for <simple-object-vector> */
		L_instance_2 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
		L_temp_3.heapptr = &dylanZliteral_ROOT;
		L_temp_3.dataword.l = 0;
		/* string-to-integer{<byte-string>} */
		L_temp_4 = common_extensionsZcommon_extensionsZstring_to_integer_METH(orig_sp, L_PCTelement_3.heapptr, &dylanZempty_list_ROOT, L_instance_2, 10, 0, 0, FALSE, L_temp_3);
		L_new_value_2 = L_temp_4.R0;

		/* #line 221 "./network-test.dylan" */
		L_wanted_bitrate = L_new_value_2;
	    }
	    else {

		/* #line 389 "./condition.dylan" */
		L_temp_5.heapptr = &network_testZstr_ROOT_33;
		L_temp_5.dataword.l = 0;
		/* type-error-with-location */
		dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_PCTelement_3, &dylanZdylan_visceraZCLS_byte_string_HEAP, L_temp_5);
		not_reached();
	    }
	}
	else {
	    L_temp_6.heapptr = &network_testZstr_ROOT_34;
	    L_temp_6.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_PCTelement_2, &dylanZdylan_visceraZCLS_byte_string_HEAP, L_temp_6);
	    not_reached();
	}
    }

    /* #line 225 "./network-test.dylan" */
    /* maker for <byte-string> */
    L_instance_3 = dylanZdylan_visceraZCLS_byte_string_MAKER_FUN(orig_sp, L_data_size, 'A');

    /* #line 226 "./network-test.dylan" */
    L_temp_7.heapptr = &network_testZnetwork_testZCLS_streamer_HEAP;
    L_temp_7.dataword.l = 0;
    L_temp_8.heapptr = &SYM_target_address_HEAP;
    L_temp_8.dataword.l = 0;
    L_temp_9.heapptr = &SYM_data_HEAP;
    L_temp_9.dataword.l = 0;
    L_temp_10.heapptr = L_instance_3;
    L_temp_10.dataword.l = 0;
    L_temp_11.heapptr = &SYM_bitrate_HEAP;
    L_temp_11.dataword.l = 0;
    L_temp_12.heapptr = network_testZliteral_2.heapptr;
    L_temp_12.dataword.l = L_wanted_bitrate;
    orig_sp[0] = L_temp_7;
    orig_sp[1] = L_temp_8;
    orig_sp[2] = L_target_address;
    orig_sp[3] = L_temp_9;
    orig_sp[4] = L_temp_10;
    orig_sp[5] = L_temp_11;
    orig_sp[6] = L_temp_12;
    /* make */
    {
      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 7, &dylanZdylan_visceraZmake_HEAP, 7);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 7, L_meth, 7, L_next_info);
    }
    L_foo = orig_sp[0];
    while (1) {

	/* #line 386 "./condition.dylan" */
	if ((&network_testZnetwork_testZCLS_streamer_HEAP == SLOT(L_foo.heapptr, heapptr_t, 0))) {

	    /* #line 228 "./network-test.dylan" */
	    L_temp_13 = L_foo.heapptr;
	    /* send-data{<streamer>} */
	    network_testZnetwork_testZsend_data_METH(orig_sp, L_temp_13, &dylanZempty_list_ROOT);

	    /* #line 229 "./network-test.dylan" */
	    /* now{} */
	    cluster_0_top = network_testZnetwork_testZnow_METH(orig_sp, &dylanZempty_list_ROOT);
	    L_stamp = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

	    /* #line 230 "./network-test.dylan" */
	    L_last_sent = SLOT(L_temp_13, descriptor_t, 36);
	    if ((L_last_sent.heapptr != NULL)) {

		/* #line 230 "./network-test.dylan" */
		orig_sp[0] = L_stamp;
		orig_sp[1] = L_last_sent;
		/* < */
		{
		  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZLESS_HEAP, 2);
		  heapptr_t L_meth = L_temp.R0;
		  heapptr_t L_next_info = L_temp.R1;
		  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
		}
		L_condition = (orig_sp[0].heapptr != obj_False);
		if (L_condition) {

		    /* #line 231 "./network-test.dylan" */
		    L_last_sent_2 = SLOT(L_temp_13, descriptor_t, 36);
		    if ((L_last_sent_2.heapptr != NULL)) {

			/* #line 231 "./network-test.dylan" */
			orig_sp[0] = L_last_sent_2;
			orig_sp[1] = L_stamp;
			/* - */
			{
			  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZ__HEAP, 2);
			  heapptr_t L_meth = L_temp.R0;
			  heapptr_t L_next_info = L_temp.R1;
			  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
			}
			L_time_to_burn = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

			/* #line 232 "./network-test.dylan" */
			L_wanted_interval = SLOT(L_temp_13, descriptor_t, 28);
			if ((L_wanted_interval.heapptr != NULL)) {

			    /* #line 232 "./network-test.dylan" */
			    L_interval = SLOT(L_temp_13, descriptor_t, 20);
			    if ((L_interval.heapptr != NULL)) {

				/* #line 232 "./network-test.dylan" */
				orig_sp[0] = L_wanted_interval;
				orig_sp[1] = L_interval;
				/* < */
				{
				  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZLESS_HEAP, 2);
				  heapptr_t L_meth = L_temp.R0;
				  heapptr_t L_next_info = L_temp.R1;
				  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
				}
				L_condition_2 = (orig_sp[0].heapptr != obj_False);
				if (L_condition_2) {

				    /* #line 233 "./network-test.dylan" */
				    L_interval_2 = SLOT(L_temp_13, descriptor_t, 20);
				    if ((L_interval_2.heapptr != NULL)) {

					/* #line 233 "./network-test.dylan" */
					L_wanted_interval_2 = SLOT(L_temp_13, descriptor_t, 28);
					if ((L_wanted_interval_2.heapptr != NULL)) {

					    /* #line 233 "./network-test.dylan" */
					    orig_sp[0] = L_interval_2;
					    orig_sp[1] = L_wanted_interval_2;
					    /* - */
					    {
					      struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZ__HEAP, 2);
					      heapptr_t L_meth = L_temp.R0;
					      heapptr_t L_next_info = L_temp.R1;
					      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
					    }
					    L_less_time_wanted = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

					    /* #line 234 "./network-test.dylan" */
					    L_wanted_interval_3 = SLOT(L_temp_13, descriptor_t, 28);
					    if ((L_wanted_interval_3.heapptr != NULL)) {

						/* #line 234 "./network-test.dylan" */
						orig_sp[0] = network_testZliteral_12;
						orig_sp[1] = L_wanted_interval_3;
						/* * */
						{
						  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
						  heapptr_t L_meth = L_temp.R0;
						  heapptr_t L_next_info = L_temp.R1;
						  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
						}
						L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

						/* #line 234 "./network-test.dylan" */
						orig_sp[0] = L_less_time_wanted;
						orig_sp[1] = L_arg1;
						/* < */
						{
						  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZLESS_HEAP, 2);
						  heapptr_t L_meth = L_temp.R0;
						  heapptr_t L_next_info = L_temp.R1;
						  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
						}
						L_condition_3 = (orig_sp[0].heapptr != obj_False);
						if (L_condition_3) {

						    /* #line 235 "./network-test.dylan" */
						    L_wanted_interval_4 = SLOT(L_temp_13, descriptor_t, 28);
						    if ((L_wanted_interval_4.heapptr != NULL)) {
							/* #line {Class <unknown-source-location>} */
							SLOT(L_temp_13, descriptor_t, 20) = L_wanted_interval_4;
						    }
						    else {

							/* #line 235 "./network-test.dylan" */
							L_temp_14.heapptr = L_temp_13;
							L_temp_14.dataword.l = 0;
							/* uninitialized-slot-error */
							dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZwanted_interval_SLOT_HEAP, L_temp_14);
							not_reached();
						    }
						}
						else {

						    /* #line 237 "./network-test.dylan" */
						    L_interval_3 = SLOT(L_temp_13, descriptor_t, 20);
						    if ((L_interval_3.heapptr != NULL)) {

							/* #line 204 "./cmp.dylan" */
							orig_sp[0] = L_time_to_burn;
							orig_sp[1] = L_less_time_wanted;
							/* < */
							{
							  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZLESS_HEAP, 2);
							  heapptr_t L_meth = L_temp.R0;
							  heapptr_t L_next_info = L_temp.R1;
							  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
							}
							L_condition_4 = (orig_sp[0].heapptr != obj_False);
							if (L_condition_4) {

							    /* #line 204 "./cmp.dylan" */
							    L_res = L_time_to_burn;
							}
							else {

							    /* #line 204 "./cmp.dylan" */
							    L_res = L_less_time_wanted;
							}
							/* #line {Class <unknown-source-location>} */

							/* #line 238 "./network-test.dylan" */
							orig_sp[0] = L_res;
							orig_sp[1] = network_testZliteral_12;
							/* * */
							{
							  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
							  heapptr_t L_meth = L_temp.R0;
							  heapptr_t L_next_info = L_temp.R1;
							  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
							}
							L_arg1_2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

							/* #line 238 "./network-test.dylan" */
							orig_sp[0] = L_interval_3;
							orig_sp[1] = L_arg1_2;
							/* - */
							{
							  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZ__HEAP, 2);
							  heapptr_t L_meth = L_temp.R0;
							  heapptr_t L_next_info = L_temp.R1;
							  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
							}
							L_new_value_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);
							/* #line {Class <unknown-source-location>} */
							SLOT(L_temp_13, descriptor_t, 20) = L_new_value_3;
						    }
						    else {

							/* #line 237 "./network-test.dylan" */
							L_temp_15.heapptr = L_temp_13;
							L_temp_15.dataword.l = 0;
							/* uninitialized-slot-error */
							dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZinterval_SLOT_HEAP, L_temp_15);
							not_reached();
						    }
						}

						/* #line 240 "./network-test.dylan" */
						/* bitrate{<streamer>} */
						L_arg1_3 = network_testZnetwork_testZbitrate_METH(orig_sp, L_temp_13, &dylanZempty_list_ROOT);

						/* #line 36 "./format-out.dylan" */
						if ((L_temp_16 = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
						L_temp_17 = L_temp_16.heapptr;

						/* #line 36 "./format-out.dylan" */
						/* maker for <simple-object-vector> */
						L_instance_4 = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 1, dylanZfalse);
						L_temp_18.heapptr = make_double_float(L_arg1_3);
						L_temp_18.dataword.l = 0;
						SLOT(L_instance_4, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp_18;
						/* format{<buffered-stream>, <byte-string>} */
						formatZformatZformat_METH(orig_sp, L_temp_17, &network_testZstr_ROOT_35, &network_testZliteral_ROOT_5, L_instance_4);

						/* #line 241 "./network-test.dylan" */
						if ((L_temp_19 = standard_ioZstandard_ioZVstandard_outputV).heapptr == NULL) abort();
						L_temp_20 = L_temp_19.heapptr;

						/* #line 241 "./network-test.dylan" */
						/* force-output{<buffered-stream>} */
						streamsZstreamsZforce_output_METH(orig_sp, L_temp_20, &dylanZempty_list_ROOT);
					    }
					    else {

						/* #line 234 "./network-test.dylan" */
						L_temp_21.heapptr = L_temp_13;
						L_temp_21.dataword.l = 0;
						/* uninitialized-slot-error */
						dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZwanted_interval_SLOT_HEAP, L_temp_21);
						not_reached();
					    }
					}
					else {

					    /* #line 233 "./network-test.dylan" */
					    L_temp_22.heapptr = L_temp_13;
					    L_temp_22.dataword.l = 0;
					    /* uninitialized-slot-error */
					    dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZwanted_interval_SLOT_HEAP, L_temp_22);
					    not_reached();
					}
				    }
				    else {

					/* #line 233 "./network-test.dylan" */
					L_temp_23.heapptr = L_temp_13;
					L_temp_23.dataword.l = 0;
					/* uninitialized-slot-error */
					dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZinterval_SLOT_HEAP, L_temp_23);
					not_reached();
				    }
				}

				/* #line 243 "./network-test.dylan" */
				L_temp_24.heapptr = &networkZnetwork_internalZCLS_pollfd_HEAP;
				L_temp_24.dataword.l = 0;
				L_temp_25.heapptr = network_testZliteral_2.heapptr;
				L_temp_25.dataword.l = 0;
				orig_sp[0] = L_temp_24;
				orig_sp[1] = L_temp_25;
				/* as */
				{
				  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
				  heapptr_t L_meth = L_temp.R0;
				  heapptr_t L_next_info = L_temp.R1;
				  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
				}
				L_arg0 = orig_sp[0];

				/* #line 243 "./network-test.dylan" */
				orig_sp[0] = L_time_to_burn;
				orig_sp[1] = network_testZliteral_13;
				/* * */
				{
				  struct mv_result_1 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
				  heapptr_t L_meth = L_temp.R0;
				  heapptr_t L_next_info = L_temp.R1;
				  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
				}
				L_arg0_2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

				/* #line 386 "./condition.dylan" */
				L_unique_id = SLOT(SLOT(L_arg0_2.heapptr, heapptr_t, 0), long, 8);
				if ((L_unique_id < 83)) {
				    L_temp_26 = FALSE;
				}
				else if ((89 < L_unique_id)) {
				    L_temp_26 = FALSE;
				}
				else {
				    L_temp_26 = TRUE;
				}
				if (L_temp_26) {

				    /* #line 243 "./network-test.dylan" */
				    /* discriminator for floor */
				    L_temp_27 = dylanZdylan_visceraZfloor_DISCRIM_FUN(orig_sp, L_arg0_2);
				    L_arg2 = L_temp_27.R0;

				    /* #line 386 "./condition.dylan" */
				    if ((&networkZnetwork_internalZCLS_pollfd_HEAP == SLOT(L_arg0.heapptr, heapptr_t, 0))) {

					/* #line 243 "./network-test.dylan" */

					/* #line 386 "./condition.dylan" */
					L_temp_28 = L_arg0.dataword.ptr;
					if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

					    /* #line 243 "./network-test.dylan" */
					    /* poll{<pollfd>, <integer>, <integer>} */
					    networkZnetwork_internalZpoll_METH(orig_sp, L_temp_28, 0, L_arg2.dataword.l, &dylanZempty_list_ROOT);
					}
					else {
					    /* #line {Class <unknown-source-location>} */

					    /* #line 389 "./condition.dylan" */
					    L_temp_29.heapptr = L_arg2.heapptr;
					    L_temp_29.dataword.l = 0;
					    L_temp_30.heapptr = &network_testZstr_ROOT_36;
					    L_temp_30.dataword.l = 0;
					    /* type-error-with-location */
					    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_29, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_30);
					    not_reached();
					}
				    }
				    else {
					L_temp_31.heapptr = &network_testZstr_ROOT_36;
					L_temp_31.dataword.l = 0;
					/* type-error-with-location */
					dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg0, &networkZnetwork_internalZCLS_pollfd_HEAP, L_temp_31);
					not_reached();
				    }
				}
				else {
				    L_temp_32.heapptr = &network_testZstr_ROOT_37;
				    L_temp_32.dataword.l = 0;
				    /* type-error-with-location */
				    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg0_2, &dylanZdylan_visceraZCLS_real_HEAP, L_temp_32);
				    not_reached();
				}
			    }
			    else {

				/* #line 232 "./network-test.dylan" */
				L_temp_33.heapptr = L_temp_13;
				L_temp_33.dataword.l = 0;
				/* uninitialized-slot-error */
				dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZinterval_SLOT_HEAP, L_temp_33);
				not_reached();
			    }
			}
			else {

			    /* #line 232 "./network-test.dylan" */
			    L_temp_34.heapptr = L_temp_13;
			    L_temp_34.dataword.l = 0;
			    /* uninitialized-slot-error */
			    dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZwanted_interval_SLOT_HEAP, L_temp_34);
			    not_reached();
			}
		    }
		    else {

			/* #line 231 "./network-test.dylan" */
			L_temp_35.heapptr = L_temp_13;
			L_temp_35.dataword.l = 0;
			/* uninitialized-slot-error */
			dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZlast_sent_SLOT_HEAP, L_temp_35);
			not_reached();
		    }
		}
	    }
	    else {

		/* #line 230 "./network-test.dylan" */
		L_temp_36.heapptr = L_temp_13;
		L_temp_36.dataword.l = 0;
		/* uninitialized-slot-error */
		dylanZdylan_visceraZuninitialized_slot_error_FUN(orig_sp, &network_testZnetwork_testZCLS_streamerZnetwork_testZnetwork_testZlast_sent_SLOT_HEAP, L_temp_36);
		not_reached();
	    }
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_37.heapptr = &network_testZstr_ROOT_38;
	    L_temp_37.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_foo, &network_testZnetwork_testZCLS_streamer_HEAP, L_temp_37);
	    not_reached();
	}
    }
}

