/* 
 * Copyright (C) 2003-2004 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: open_mrl.c,v 1.27 2005/11/02 23:57:28 dsalt Exp $
 *
 * open mrl dialog (plus file browser)
 */

#include "globals.h"

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <gtk/gtk.h>

#include "open_mrl.h"
#include "playlist.h"
#include "ui.h"
#include "utils.h"
#include "script_engine.h"

static GtkWidget      *mrl_dialog;
static gboolean        mrl_visible;
static GtkWidget      *mrl_entry;

void file_dialog_show(void)
{
  playlist_add_list
    (modal_multi_file_dialog (_("Select files to add to playlist"),
			      FALSE, NULL, app),
     TRUE);
}

void file_dialog_init (void) {

  /* nothing to be done natm */
}

static void open_mrl_response_cb (GtkDialog *dbox, int response, gpointer data)
{
  gchar *mrl;
  const gchar *cmrl;
  int item;
  switch (response)
  {
  case 1:
    mrl = modal_file_dialog (_("Select file for MRL"), TRUE, TRUE, TRUE,
			     NULL, NULL, mrl_dialog);
    if (mrl)
    {
      const char *prefix, *colon, *slash, *file;
      gtk_widget_grab_focus (mrl_entry);

      file = strchr (mrl + 7, '/'); /* skip "file://" and maybe a hostname */
      prefix = gtk_entry_get_text (GTK_ENTRY(mrl_entry));

      colon = strchr (prefix, ':');
      slash = strchr (prefix, '/');
      if (slash == colon + 1)
      {
	int prefix_l = slash - prefix + 1;
	char *start = g_strdup_printf ("%.*s%s", prefix_l, prefix, file);
	gtk_entry_set_text (GTK_ENTRY(mrl_entry), start);
	free (start);
	gtk_editable_select_region (GTK_EDITABLE(mrl_entry), 0, prefix_l);
      }
      else
      {
	gtk_entry_set_text (GTK_ENTRY(mrl_entry), file);
	gtk_editable_set_position (GTK_EDITABLE(mrl_entry), 0);
      }
      free (mrl);
    }
    break;

  case GTK_RESPONSE_OK:
    cmrl = gtk_entry_get_text (GTK_ENTRY (mrl_entry));
    if (cmrl)
    {
      while (isspace (*cmrl))
	++cmrl;
      if (*cmrl)
      {
	item = playlist_add_mrl (cmrl, -1);
	playlist_play (item); /* then hide */
      }
    }
  default:
    mrl_visible = FALSE;
    gtk_widget_hide (mrl_dialog);
  }
}

static JSBool js_open_show (JSContext *cx, JSObject *obj, uintN argc, 
			    jsval *argv, jsval *rval)
{
  /* se_t *se = (se_t *) JS_GetContextPrivate(cx); */
  se_log_fncall_checkinit ("open_show");
  file_dialog_show ();
  return JS_TRUE;
}

static JSBool js_open_mrl_show (JSContext *cx, JSObject *obj, uintN argc, 
				jsval *argv, jsval *rval)
{
  /* se_t *se = (se_t *) JS_GetContextPrivate(cx); */
  se_log_fncall_checkinit ("open_mrl_show");
  open_mrl_show ();
  return JS_TRUE;
}

void open_mrl_init (void)
{
  GtkWidget *hbox;

  mrl_dialog = gtk_dialog_new_with_buttons (_("Open MRL..."), NULL, 0, NULL);
  gtk_dialog_add_action_widget (GTK_DIALOG(mrl_dialog),
				ui_button_new_stock_mnemonic
				  (GTK_STOCK_OPEN, _("_File...")),
				1);
  gtk_dialog_add_buttons (GTK_DIALOG(mrl_dialog),
			  GTK_STOCK_CANCEL, GTK_RESPONSE_DELETE_EVENT,
			  GTK_STOCK_OK, GTK_RESPONSE_OK,
			  NULL);

  gtk_window_set_default_size (GTK_WINDOW (mrl_dialog), 400, -1);
  gtk_window_set_position (GTK_WINDOW (mrl_dialog), GTK_WIN_POS_CENTER);
  hide_on_delete (mrl_dialog, &mrl_visible);
  g_signal_connect (G_OBJECT (mrl_dialog), "response",
		    G_CALLBACK (open_mrl_response_cb), NULL);
  gtk_dialog_set_default_response (GTK_DIALOG(mrl_dialog), GTK_RESPONSE_OK);

  hbox = gtk_hbox_new (0, 2);

  gtk_box_pack_start (GTK_BOX(hbox), gtk_label_new ("mrl:"), FALSE, FALSE, 0);

  mrl_entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX(hbox), mrl_entry, TRUE, TRUE, 2);
  gtk_entry_set_activates_default (GTK_ENTRY(mrl_entry), TRUE);

  gtk_box_pack_start_defaults (GTK_BOX (GTK_DIALOG (mrl_dialog)->vbox), hbox);

  mrl_visible = 0;

  {
    static const se_f_def_t defs[] = {
      { "open_show", js_open_show, 0, 0, SE_GROUP_FILE, NULL, NULL },
      { "open_mrl_show", js_open_mrl_show, 0, 0, SE_GROUP_FILE, NULL, NULL },
      { NULL }
    };
    se_defuns (gse, NULL, defs);
  }
}

void open_mrl_show (void) {
  if (mrl_visible) {
    mrl_visible = FALSE;
    gtk_widget_hide (mrl_dialog);
  } else {
    mrl_visible = TRUE;
    window_show (mrl_dialog, NULL);
    gtk_widget_grab_focus (mrl_entry);
  }
}

