/**
 *
 * @file     callbacks.h
 * @author   Aleix Conchillo Flaque <aleix@member.fsf.org>
 * @date     Tue Aug 05, 2003 21:56
 * @brief    XMMS GNOME applet callbacks
 *
 * $Id: callbacks.h,v 1.6 2004/12/30 00:24:11 aleix Exp $
 *
 * @if copyright
 *
 * Copyright (C) 2003, 2004 Aleix Conchillo Flaque
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * @endif
 */


#ifndef CALLBACKS_H_ALEIX0308052156
#define CALLBACKS_H_ALEIX0308052156

#include "types.h"

void timer_on(XMMSData *xmms);

void timer_off(XMMSData *xmms);

void cb_realize(GtkWidget *w, XMMSData *xmms);

void cb_destroy(GtkWidget *w, XMMSData *xmms);

void cb_style_set(GtkWidget *w, GtkStyle *style, XMMSData *xmms);

void cb_change_size(GtkWidget *w, gint size, XMMSData *xmms);

void cb_change_orient(GtkWidget *w, PanelAppletOrient orient, XMMSData *xmms);

void cb_prev_clicked(GtkWidget *w, XMMSData *xmms);

void cb_play_pause_clicked(GtkWidget *w, XMMSData *xmms);

void cb_stop_clicked(GtkWidget *w, XMMSData *xmms);

void cb_next_clicked(GtkWidget *w, XMMSData *xmms);

void cb_eject_clicked(GtkWidget *w, XMMSData *xmms);

gboolean cb_seek(GtkWidget *w, GdkEventButton *event, gpointer data);

gboolean cb_scrollwheel(GtkWidget *w, GdkEventScroll *event, XMMSData *xmms);

gboolean cb_button_press(GtkWidget *w, GdkEventButton *event,
                         GtkWidget *applet);

void cb_repeat_menu(BonoboUIComponent *uic, XMMSData *xmms, const gchar *verb);

void cb_shuffle_menu(BonoboUIComponent *uic, XMMSData *xmms, const gchar *verb);

void cb_toggle_repeat(BonoboUIComponent *uic, const gchar *path,
                      Bonobo_UIComponent_EventType type, const gchar *state,
                      XMMSData *xmms);

void cb_toggle_shuffle(BonoboUIComponent *uic, const gchar *path,
                       Bonobo_UIComponent_EventType type, const gchar *state,
                       XMMSData *xmms);

void cb_main_win_menu(BonoboUIComponent *uic, XMMSData *xmms,
                      const gchar *verb);

void cb_pl_win_menu(BonoboUIComponent *uic, XMMSData *xmms, const gchar *verb);

void cb_eq_win_menu(BonoboUIComponent *uic, XMMSData *xmms, const gchar *verb);

void cb_show_hide_menu(BonoboUIComponent *uic, XMMSData *xmms,
                       const gchar *verb);

void cb_player_pref_menu(BonoboUIComponent *uic, XMMSData *xmms,
                         const gchar *verb);

void cb_quit_menu(BonoboUIComponent *uic, XMMSData *xmms, const gchar *verb);

void cb_about_menu(BonoboUIComponent *uic, XMMSData *xmms, const gchar *verb);

#endif /* CALLBACKS_H_ALEIX0308052156 */
