/**
 *
 * @file     gxmms.c
 * @author   Aleix Conchillo Flaque <aleix@member.fsf.org>
 * @date     Mon Jul 28, 2003 23:58
 * @brief    XMMS GNOME applet main file
 *
 * $Id: gxmms.c,v 1.4 2005/05/18 22:35:15 aleix Exp $
 *
 * @if copyright
 *
 * Copyright (C) 2003, 2004, 2005 Aleix Conchillo Flaque
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * @endif
 */


#include "gxmms.h"

#include "interface.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>

#ifdef HAVE_XMMS
PANEL_APPLET_BONOBO_FACTORY ("OAFIID:GNOME_gxmmsApplet_Factory",
                             PANEL_TYPE_APPLET,
                             "gxmms applet",
                             "0",
                             gxmms_applet_factory,
                             NULL);
#else
PANEL_APPLET_BONOBO_FACTORY ("OAFIID:GNOME_gxmms_bmpApplet_Factory",
                             PANEL_TYPE_APPLET,
                             "gxmms applet",
                             "0",
                             gxmms_applet_factory,
                             NULL);
#endif

gboolean
gxmms_applet_factory(PanelApplet *applet, const gchar *iid, gpointer data)
{
#ifdef HAVE_XMMS
    static char* applet_str = "OAFIID:GNOME_gxmmsApplet";
#else
    static char* applet_str = "OAFIID:GNOME_gxmms_bmpApplet";
#endif
    gboolean retval = FALSE;

    if (!strcmp(iid, applet_str))
    {
        retval = gxmms_applet_fill(applet);
    }

    return retval;
}

gboolean
gxmms_applet_fill(PanelApplet *applet)
{
    XMMSData *xmms;

    xmms = g_new0(XMMSData, 1);
    xmms->applet = GTK_WIDGET(applet);

    gui_create(xmms);

    return TRUE;
}
