/* 
 * File: wejpscroller.h
 *
 * A gtk2 text scroll widget
 * Copyright (c) 2005 Johannes Heimansberg
 *
 * Released under the GNU General Public License v2
 */

#ifndef __WEJPSCROLLER_H__
#define __WEJPSCROLLER_H__

#include <glib.h>
#include <gtk/gtk.h>
G_BEGIN_DECLS

#define WEJPSCROLLER_TYPE            (wejpscroller_get_type ())
#define WEJPSCROLLER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), WEJPSCROLLER_TYPE, WejpScroller))
#define WEJPSCROLLER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), WEJPSCROLLER_TYPE, WejpScrollerClass))
#define IS_WEJPSCROLLER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WEJPSCROLLER_TYPE))
#define IS_WEJPSCROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WEJPSCROLLER_TYPE))

#define FONT_STR_LENGTH 128

struct _WejpScroller {
	GtkEventBox           dummy;
	GtkPixmap            *pixmap;
	GtkWidget            *drawing_area;
	gchar                *text;
	gint                  width, height;
	guint                 pos;
	PangoLayout          *pgl;
	PangoFontDescription *pfd;
	GdkColormap          *colormap;
	PangoRectangle        extents;
	gchar                 font[FONT_STR_LENGTH];
	guint                 scroll_delay;
	gboolean              scroll;
	gint                  mouse_x;
	gint                  shortmessage_timeout;
	gint                  shortmessage_pos_backup;
	gchar                 shortmessage_text_backup[1024];
};

typedef struct _WejpScroller       WejpScroller;
typedef struct _WejpScrollerClass  WejpScrollerClass;

struct _WejpScrollerClass
{
	GtkEventBoxClass parent_class;
	void (* wejpscroller) (WejpScroller *ws);
};

GType        wejpscroller_get_type         (void);
GtkWidget   *wejpscroller_new              (guint scroll_delay);
void         wejpscroller_clear            (WejpScroller *ws);

void         wejpscroller_draw             (WejpScroller *ws);
void         wejpscroller_set_dimensions   (WejpScroller *scroller, 
                                            gint w, gint h);
void         wejpscroller_set_font         (WejpScroller *ws,
                                            gchar *font, gint fontsize);
void         wejpscroller_set_text         (WejpScroller *ws, 
                                            gchar *new_text, 
                                            gboolean reset_pos);
const gchar *wejpscroller_get_text         (WejpScroller *ws);

void         wejpscroller_shortmessage_show(WejpScroller *ws,
                                            gchar        *message,
                                            guint         timeout);

G_END_DECLS
#endif
