/* 
 * File: gmedialib.h
 *
 * Medialib search and playlist editor
 * Copyright (c) 2005 Johannes Heimansberg
 *
 * requires GTK+ 2.6 or better and XMMS2 DR2 or better
 *
 * Released under the GNU General Public License v2
 */

#ifndef __GMEDIALIB_H__
#define __GMEDIALIB_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtk/gtkdialog.h>
#include "gtrackinfo/trackinfo.h"
#include "gmlplaylist.h"
#include "gmlsearch.h"
#include "gmlbrowser.h"
#include "gmlplaylists.h"
#include "gmladdfiles.h"

G_BEGIN_DECLS

#define GMEDIALIB_TYPE            (gmedialib_get_type ())
#define GMEDIALIB(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMEDIALIB_TYPE, GMedialib))
#define GMEDIALIB_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GMEDIALIB_TYPE, GMedialibClass))
#define IS_GMEDIALIB(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMEDIALIB_TYPE))
#define IS_GMEDIALIB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GMEDIALIB_TYPE))

typedef struct _GMedialib       GMedialib;
typedef struct _GMedialibClass  GMedialibClass;
typedef struct _GMLPlaylist     GMLPlaylist;
typedef struct _GMLSearch       GMLSearch;
typedef struct _GMLPlaylists    GMLPlaylists;
typedef struct _GMLBrowser      GMLBrowser;
typedef struct _GMLAddFiles     GMLAddFiles;

enum { SEARCH_ANYTHING, SEARCH_ARTIST, SEARCH_TRACK, SEARCH_ALBUM };

struct _GMedialib
{
	GtkDialog        dialog;

	GtkWidget       *notebook,             *statusbar,           *button_close;
	GtkWidget       *hbox_mlib_search,    *image_mlib_search,    *label_mlib_search;
	GtkWidget       *hbox_mlib_browse,    *image_mlib_browse,    *label_mlib_browse;
	GtkWidget       *hbox_playlists,      *image_playlists,      *label_playlists;
	GtkWidget       *hbox_mlib_add_files, *image_mlib_add_files, *label_mlib_add_files;
	GtkWidget       *hbox_playlist,       *image_playlist,       *label_playlist;
	guint            statusbar_id;
	GtkCellRenderer *renderer_text, *renderer_text_ellipsize;

	GMLSearch        search;
	GMLBrowser       browser;
	GMLPlaylists     playlists;
	GMLPlaylist      playlist;
	GMLAddFiles      addfiles;

	gint             window_width, window_height, window_pos_x, window_pos_y;
	gint             font_size;
	gint             album_tracknr_digits;

	gboolean         notebook_mlib_search, notebook_mlib_browser, notebook_mlib_add_files;
	gboolean         notebook_playlists,   notebook_playlist;
};

struct _GMedialibClass
{
	GtkDialogClass parent_class;

	void (* gmedialib)(GMedialib *gml);
};

gboolean   gmedialib_set_info(GMedialib *gml, trackinfo *info);
GType      gmedialib_get_type(void);
GtkWidget* gmedialib_new(gboolean search,
                         gboolean browser,
                         gboolean add_files,
                         gboolean playlists,
                         gboolean playlist);
void       gmedialib_search(GMedialib *gml,  xmmsc_connection_t *conn, 
                            gchar *category, gchar *search_str, 
                            gboolean exact);

void       gml_cell_data_function(GtkTreeViewColumn *col,
                                  GtkCellRenderer   *renderer,
                                  GtkTreeModel      *model,
                                  GtkTreeIter       *iter,
                                  gpointer           user_data);
void       gml_create_mlib_search(GMedialib *gml);
void       gml_create_mlib_browser(GMedialib *gml);
void       gml_create_mlib_add_files(GMedialib *gml);
void       gml_create_playlists(GMedialib *gml);
void       gml_create_playlist(GMedialib *gml);
void       gml_setup_xmms_callbacks(GMedialib *gml);

gboolean   gml_notebook_is_mlib_search_visible(GMedialib *gml);
gboolean   gml_notebook_is_mlib_browser_visible(GMedialib *gml);
gboolean   gml_notebook_is_mlib_add_files_visible(GMedialib *gml);
gboolean   gml_notebook_is_playlists_visible(GMedialib *gml);
gboolean   gml_notebook_is_playlist_visible(GMedialib *gml);
gboolean   gml_pl_get_column_pos_visible(GMedialib *gml);
gboolean   gml_pl_get_column_id_visible(GMedialib *gml);
gboolean   gml_pl_get_column_artist_visible(GMedialib *gml);
gboolean   gml_pl_get_column_track_visible(GMedialib *gml);
gboolean   gml_pl_get_column_album_visible(GMedialib *gml);
gboolean   gml_pl_get_column_rating_visible(GMedialib *gml);
gboolean   gml_pl_get_new_playlist_confirm(GMedialib *gml);
gint       gml_pl_get_selected_pos(GMedialib *gml);
void       gml_pl_refresh_playlist(GMedialib *gml);
void       gml_pl_set_column_pos_visible(GMedialib *gml, gboolean visible);
void       gml_pl_set_column_id_visible(GMedialib *gml, gboolean visible);
void       gml_pl_set_column_artist_visible(GMedialib *gml, gboolean visible);
void       gml_pl_set_column_track_visible(GMedialib *gml, gboolean visible);
void       gml_pl_set_column_album_visible(GMedialib *gml, gboolean visible);
void       gml_pl_set_column_rating_visible(GMedialib *gml, gboolean visible);
void       gml_pl_set_new_playlist_confirm(GMedialib *gml, gboolean confirm);
void       gml_pl_setup_xmms_callbacks(GMedialib *gml);

void       gml_mlib_browse_update_artists(GMedialib *gml);

void       gml_playlists_update_playlists(GMedialib *gml);

void       gml_search_do_search(GMedialib *gml, 
                                guint search_for, gchar* search_str);
gboolean   gml_search_get_column_id_visible(GMedialib *gml);
gboolean   gml_search_get_column_artist_visible(GMedialib *gml);
gboolean   gml_search_get_column_track_visible(GMedialib *gml);
gboolean   gml_search_get_column_album_visible(GMedialib *gml);
gboolean   gml_search_get_column_rating_visible(GMedialib *gml);
void       gml_search_set_column_id_visible(GMedialib *gml, gboolean visible);
void       gml_search_set_column_artist_visible(GMedialib *gml, gboolean visible);
void       gml_search_set_column_track_visible(GMedialib *gml, gboolean visible);
void       gml_search_set_column_album_visible(GMedialib *gml, gboolean visible);
void       gml_search_set_column_rating_visible(GMedialib *gml, gboolean visible);

void       gml_set_album_tracknr_digits(GMedialib *gml, gint digits);
void       gml_set_statusbar_text(GMedialib *gml, gchar *text);
void       gml_set_font_size(GMedialib *gml, gint size);

gint       gml_window_get_pos_x(GMedialib *gml);
gint       gml_window_get_pos_y(GMedialib *gml);
gint       gml_window_get_width(GMedialib *gml);
gint       gml_window_get_height(GMedialib *gml);

void       gml_playlist_n_add_track_with_info(xmmsc_result_t *res2, void *arg);

void       gml_playlist_update_entry(GMedialib *gml, guint pos);
G_END_DECLS

#endif
