/*
 gyrus-report.h
 
 GYRUS -- GNOME Cyrus Administrator.
 
 Copyright (C) 2005 Alejandro Valds <avaldes@utalca.cl>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 
*/


#ifndef GYRUS_REPORT_H
#define GYRUS_REPORT_H

#include "gyrus-admin.h"
#include <libgnomeprint/gnome-print.h>
#include <libgnomeprint/gnome-print-job.h>
#include <libgnomeprintui/gnome-print-dialog.h>

typedef struct _GyrusReportData {
        GyrusAdmin *admin;

        gdouble n_percen;
	gchar *mailbox_temp;

	GtkWidget *button_print;
	GtkWidget *window_report;
        GtkWidget *spin_report;
        GtkTreeView *treeview_report;

	GnomePrintContext *gpc;
	GnomeFont *font;
	gint xini;
	gint yini;
	gint xlin;
	gint nlin;
	gint page;

} GyrusReportData;


void
gyrus_report_show_report (GyrusAdmin *admin);
void 
gyrus_report_on_button_cancel_clicked (GtkWidget *widget, GyrusReportData *report);
void 
gyrus_report_on_button_update_clicked (GtkWidget *widget, GyrusReportData *report);
gboolean
gyrus_report_evaluate_quota (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer data);
GtkTreeView *
gyrus_report_initialize_tree_view (GtkTreeView *treeview_report);
void
gyrus_report_on_delete_event_window_report (GtkWidget *widget, GdkEvent *event, GyrusReportData *report);
void
gyrus_report_on_button_print_clicked(GtkWidget *widget, GyrusReportData *report);
void
gyrus_report_create_print (GnomePrintJob *job, gboolean preview, GyrusReportData *report);
void
gyrus_report_create_data_page (GyrusReportData *report);
gboolean
gyrus_report_print_quota (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer data);
void
gyrus_report_draw_begin (GyrusReportData *report);
#endif /* GYRUS_REPORT_H */
