{-# OPTIONS -fallow-overlapping-instances -fth -fglasgow-exts #-}
--Copyright (C) 2006 HAppS.org. All Rights Reserved.

import Control.Monad.State
import HAppS hiding(simpleHTTP)
import HAppS.Agents.Users
import HAppS.Protocols.MessageWrap.W hiding(w)
import HAppS.Protocols.SimpleHTTP

type UEv a = Ev MyState Request a

data MyState = My { users :: Users String } deriving(Read,Show)

$(inferRecordUpdaters ''MyState)
$(inferStartState ''MyState)

instance Serialize MyState where
    typeString _  = "MyState"
    encodeStringM = defaultEncodeStringM
    decodeStringM = defaultDecodeStringM


a :: Method -> Host -> [String] -> UEv Result
a GET _ ["new",u,p]   = w $ withUsers $ newUser u p
a GET _ ["del",u]     = w $ withUsers $ modUser u $ const Nothing
a GET _ ["login",u,p] = w $ do (sk,_) <- withUsers $ loginUser 600 u $ checkPass p
                               return sk
a GET _ ["sk",sk]     = w $ withUsers $ getUser (read sk)
a _   _ p             = text $ sresult 403 ("Unknown path: "++show p)

checkPass :: String -> String -> EvUsers String ()
checkPass c p | c /= p = fail "Passwords don't match."
checkPass _ _ = return ()

text = fmap $ setHeader "Content-Type" "text/plain"

main = stdMain $ simpleHTTP "" [] a :*: End

w :: Show t => UEv t -> UEv Result
w c = wPure ehShow (\() -> text ((sresult 200 =<< fmap show c)))
