module HAppS.MACID.Saver.Types where

import qualified Data.ByteString.Char8 as P

-- | Savers
data SaverImpl = Saver { saverOpen  :: String -> IO SaverImpl
                       , saverClose :: IO ()
                       -- ^ Close the Saver.
                       -- Assures that all finalizers from previous call to saverAdd
                       -- on this Saver have been run.
                       , saverAdd   :: [P.ByteString] -> IO () -> IO ()
                         -- ^ Data to save and a finalizer.
                       , saverGet   :: String -> IO [P.ByteString]
                       , saverAtomicReplace :: String -> String -> IO ()
                         -- ^ First string is a path, the second is data.
                       , saverArchive :: String -> IO ()
                         -- ^ Notify that saved state is no longer needed
                       }
