module HAppS.MACID.Var where

import Control.Exception(block)
import Control.Concurrent.MVar
import Control.Concurrent.STM
import Data.IORef
import Data.Monoid
import HAppS.MACID.Types

class Ref ref where
    newRefSTM   :: t -> STM (ref t)
    readRefSTM  :: ref t -> STM t
    writeRefSTM :: ref t -> t -> STM ()

newRef :: Ref ref => t -> AnyEv (ref t)
newRef x = unsafeSTMToEv $ newRefSTM x
readRef :: Ref ref => ref t -> AnyEv t
readRef r = unsafeSTMToEv $ readRefSTM r
writeRef :: Ref ref => ref t -> t -> AnyEv ()
writeRef r x = unsafeSTMToEv $ writeRefSTM r x
    
newEmptyRef :: (Monoid t, Ref ref) => AnyEv (ref t)
newEmptyRef = newRef mempty

instance Ref MutVar where
    newRefSTM x        = fmap MV $ newTVar x
    readRefSTM  (MV r) = readTVar r
    writeRefSTM (MV r) x  = writeTVar r x

instance Ref VolatileVar where
    newRefSTM x        = fmap VV $ unsafeIOToSTM $ newMVar x
    readRefSTM  (VV r) = unsafeIOToSTM $ readMVar r
    writeRefSTM (VV r) x  = unsafeIOToSTM (block (takeMVar r >> putMVar r x))

-- Not persistent volatile variables
instance Ref VolatileUnsafeVar where
    newRefSTM x        = fmap VU $ unsafeIOToSTM $ newIORef x
    readRefSTM  (VU r) = unsafeIOToSTM $ readIORef r
    writeRefSTM (VU r) x  = unsafeIOToSTM $ writeIORef r x
