/*
 * Hardware Information, version 0.3.1b
 * Copyright (C) 2003 Leandro Pereira <leandro@linuxmag.com.br>
 *
 * May be modified and/or distributed under the terms of GNU GPL version 2.
 *
 */

#include "hardinfo.h"
#include "isapnp.h"

ISADevice *hi_scan_isapnp(void)
{
	FILE *proc_isapnp;
	gchar buffer[256], *buf;
	gint n=0;
	ISADevice *isa_dev, *isa;
	struct stat st;
	
	isa = NULL;
	
	if(stat("/proc/isapnp", &st)) return NULL;

	proc_isapnp = fopen("/proc/isapnp", "r");
	while(fgets(buffer, 256, proc_isapnp)){
		buf = g_strstrip(buffer);
		if(!strncmp(buf, "Card", 4)){
			gboolean lock = FALSE;
			gfloat pnpversion, prodversion;
			gint card_id;
			gpointer start = NULL, end = NULL;
			
			sscanf(buf, "Card %d", &card_id);
			
			for (; buf != NULL; buf++) {
				if (lock && *buf == '\'') {
					end = buf;
					break;
				} else if (!lock && *buf == ':') {
					start = buf+1;
					lock = TRUE;
				}
			}
			buf += 2;
			
			sscanf(buf, "PnP version %f Product version %f", &pnpversion, &prodversion);
			
			buf = end;
			*buf=0;
			buf = start;
			
			isa_dev = g_new0(ISADevice, 1);
			
			isa_dev->next = isa;
			isa = isa_dev;
			
			isa_dev->pnpversion = pnpversion;
			isa_dev->prodversion = prodversion;
			isa_dev->card_id = card_id;
			
			isa_dev->card = g_strdup(buf);
			
			n++;			
		}
	}
	fclose(proc_isapnp);
	
	return isa;
}

void hi_show_isa_info(MainWindow *mainwindow, ISADevice *device)
{
	gchar *buf;

	if(!device) return;

	gtk_window_set_title(GTK_WINDOW(mainwindow->det_window->window), _("ISA Plug and Play Device"));
	
	detail_window_set_dev_name(mainwindow->det_window, device->card);
	detail_window_set_icon(mainwindow->det_window, IMG_PREFIX "pci.png");

	detail_window_append_info_int(mainwindow->det_window, _("Card ID"),
				      device->card_id, FALSE);	
	buf = g_strdup_printf("%.2f", device->pnpversion);
	detail_window_append_info(mainwindow->det_window, _("PnP version"),
				  buf);
	g_free(buf);
	
	buf = g_strdup_printf("%.2f", device->prodversion);
	detail_window_append_info(mainwindow->det_window, _("Product version"),
				  buf);
	g_free(buf);
}

