/*
 * Hardware Information, version 0.3.1b
 * Copyright (C) 2003 Leandro Pereira <leandro@linuxmag.com.br>
 *
 * May be modified and/or distributed under the terms of GNU GPL version 2.
 */

#include "hardinfo.h"
#include "serial.h"

SerialDevice *hi_scan_serial(void)
{
	FILE *proc_tty;
	struct stat st;
	const gchar *ser_drv = "/proc/tty/driver/serial";
	gint n = 0;
	SerialDevice *serial_dev, *serial;
	
	serial = NULL;
	
	if (!stat(ser_drv, &st)) {
		gchar buffer[256];
		
		proc_tty = fopen(ser_drv, "r");
		while(fgets(buffer, 256, proc_tty)){
			gint port, irq;
			gpointer start, end;
			gchar *buf = buffer;
		
			if(*buf == 's') continue;
			if(strstr(buffer, "unknown")) continue;
		
			serial_dev = g_new0(SerialDevice, 1);
			
			serial_dev->next = serial;
			serial = serial_dev;

			serial_dev->name = g_strdup_printf
				(_("Serial Port (tty%d)"), buffer[0]-'0');

			walk_until('t');
			buf += 2;
			start = buf;
			walk_until(' ');
			end = buf;
			*buf = 0;
			buf = start;
			
			serial_dev->uart = g_strdup(buf);
			
			buf = end;
			*buf = ' ';
			
			sscanf(buf, " port:%x irq:%d", &port, &irq);
			serial->port = port;
			serial->irq = irq;
			n++;
		}
		fclose(proc_tty);
	}
	
	return serial;
}

void hi_show_serial_info(MainWindow *mainwindow, SerialDevice *device)
{
	if(!device) return;

	detail_window_set_icon(mainwindow->det_window, IMG_PREFIX "gen_connector.png");
	gtk_window_set_title(GTK_WINDOW(mainwindow->det_window->window), _("Communication Port"));

	detail_window_set_dev_name(mainwindow->det_window, device->name);
	detail_window_set_dev_type(mainwindow->det_window, _("Communication Port"));
	
	detail_window_append_info_int(mainwindow->det_window, _("I/O port"),
				      device->port, TRUE);
	detail_window_append_info_int(mainwindow->det_window, _("IRQ"),
				      device->irq, TRUE);
	detail_window_append_info(mainwindow->det_window, "UART", device->uart);				      
}
