#include "config.h"
#include "status.h"

myStatus *my_status_new(gchar *title, gchar *text)
{
	GtkWidget *window, *label, *hbox, *img, *vbox, *progress;
	myStatus *status;
	
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), title);
	gtk_container_set_border_width(GTK_CONTAINER(window), 15);
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER_ALWAYS);
	
	hbox = gtk_hbox_new(FALSE, 5);
	gtk_widget_show(hbox);
	gtk_container_add(GTK_CONTAINER(window), hbox);
	
	img = gtk_image_new_from_file(IMG_PREFIX "logo.png");
	gtk_widget_show(img);
	gtk_box_pack_start(GTK_BOX(hbox), img, FALSE, FALSE, 0);
	gtk_widget_set_usize(GTK_WIDGET(img), 96, 64);
	
	vbox = gtk_vbox_new(FALSE, 5);
	gtk_widget_show(vbox);
	gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE, 0);
	
	label = gtk_label_new(text);
	gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
	
	progress = gtk_progress_bar_new();
	gtk_widget_show(progress);
	gtk_box_pack_start(GTK_BOX(vbox), progress, TRUE, FALSE, 0);
	
	gtk_widget_show(window);
	
	status = g_new0(myStatus, 1);
	status->window   = window;
	status->label    = label;
	status->progress = progress;
	
	return status;
}

void my_status_pulse(myStatus *status)
{
	gtk_progress_bar_pulse(GTK_PROGRESS_BAR(status->progress));

	while (gtk_events_pending())
		gtk_main_iteration();
}

void my_status_destroy(myStatus *status)
{
	gtk_widget_destroy(status->window);
	g_free(status);
	status = NULL;
}

void my_status_set_text(myStatus *status, gchar *text)
{
	gtk_label_set_markup(GTK_LABEL(status->label), text);

	while (gtk_events_pending())
		gtk_main_iteration();	
}

