/* The applet class which coordinates everything.
 *
 * Copyright (c) 2003 Ole Laursen.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 */

#ifndef APPLET_HPP
#define APPLET_HPP

#include <memory>
#include <map>

#include <sigc++/connection.h>

#include <gtkmm/eventbox.h>
#include <gtkmm/window.h>
#include <gtkmm/tooltips.h>
#include <glibmm/ustring.h>

#include <gconfmm/client.h>
#include <gconfmm/entry.h>

#include <libgnomeuimm/about.h>

#include <panel-applet.h>

class PreferencesWindow; 
class View;
class Monitor;

// main monster GUI class
class Applet: public Gtk::EventBox
{
public:
  Applet(PanelApplet *panel_applet);
  ~Applet();

  Gtk::Container &get_container();
  
  unsigned int get_fg_color();	// return varying foreground colours
  int get_update_interval() const; // in milliseconds
  int get_size() const;		// in pixels
  bool horizontal() const; 	// whether we're in horizontal mode
  void set_view(View *view);	// use this view to monitor

  Glib::RefPtr<Gnome::Conf::Client> &get_gconf_client();
  Glib::ustring get_gconf_dir() const;

  Glib::RefPtr<Gdk::Pixbuf> get_icon();	// get the application icon

   // take over ownership of monitor
  void add_monitor(Monitor *monitor);
  // get rid of the monitor
  void remove_monitor(Glib::ustring mon_dir);
  void replace_monitor(Glib::ustring mon_dir, Monitor *new_monitor);
  Monitor *look_up_monitor(Glib::ustring mon_dir);

private:
  // internal decoration
  //Gtk::Frame frame;

  // monitors
  typedef std::map<Glib::ustring, Monitor *> monitor_sequence;
  typedef monitor_sequence::iterator monitor_iterator;
  monitor_sequence monitors;

  // the context menu
  void on_preferences_activated();
  void on_help_activated();
  void on_about_activated();

  // looping
  bool main_loop();
  SigC::Connection timer;
  int update_interval;

  // GConf
  Glib::RefPtr<Gnome::Conf::Client> gconf_client;
  Glib::ustring gconf_dir;

  void viewer_type_listener(unsigned int, Gnome::Conf::Entry entry);
  void update_interval_listener(unsigned int, Gnome::Conf::Entry entry);
  void background_color_listener(unsigned int, Gnome::Conf::Entry entry);
  void use_background_color_listener(unsigned int, Gnome::Conf::Entry entry);
  
  Glib::ustring find_empty_monitor_dir();
  void add_monitor(Monitor *monitor, Glib::ustring mon_dir);
  void load_monitors();
  
  // data
  PanelApplet *panel_applet;
  Glib::RefPtr<Gdk::Pixbuf> icon;
  std::auto_ptr<Gnome::UI::About> about;
  std::auto_ptr<View> view;
  std::auto_ptr<PreferencesWindow> preferences_window;

  Gtk::Tooltips tooltips;
  
  friend void display_preferences(BonoboUIComponent *, void *applet, const gchar *);

  friend void display_help(BonoboUIComponent *, void *applet, const gchar *);
  friend void display_about(BonoboUIComponent *, void *applet, const gchar *);
};

#endif
