/* A view which displays a (time, value) column plot.
 *
 * Copyright (c) 2003 Ole Laursen.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 */

#ifndef COLUMN_VIEW_HPP
#define COLUMN_VIEW_HPP

#include <list>
#include <vector>
#include <memory>

#include <libgnomecanvasmm/canvas.h>
#include <glibmm/ustring.h>

#include "canvas-view.hpp"


class ColumnGraph;

class ColumnView: public CanvasView
{
public:
  ColumnView();
  ~ColumnView();
  
private:
  virtual void do_update();
  virtual void do_attach(Monitor *monitor, const Glib::ustring &mon_dir);
  virtual void do_detach(Monitor *monitor);
  virtual void do_draw_loop();

  unsigned int samples;		// number of samples to store

  // must be destroyed before the canvas
  typedef std::list<ColumnGraph *> column_sequence;
  typedef column_sequence::iterator column_iterator;
  column_sequence columns;

  int draws_since_update;
};

#endif
