/*******************************************************************************
 * Copyright 2019-2022 Microchip FPGA Embedded Systems Solutions.
 *
 * SPDX-License-Identifier: MIT
 *
 * MPFS HSS Embedded Software
 *
 */

/**
 * \file HSS Software Initalization
 * \brief Full System Initialization
 */

#include "config.h"
#include "hss_types.h"

#include "hss_init.h"
#include "hss_debug.h"


#if IS_ENABLED(CONFIG_COLOR_OUTPUT)
  const char g0_str[] = "\033[48;5;102m ";
  const char g1_str[] = "\033[48;5;103m ";
  const char g2_str[] = "\033[48;5;109m ";
  const char g3_str[] = "\033[48;5;110m ";
  const char g4_str[] = "\033[48;5;145m ";
  const char g5_str[] = "\033[48;5;146m ";
  const char g6_str[] = "\033[48;5;152m ";
  const char g7_str[] = "\033[48;5;153m ";
  const char g8_str[] = "\033[48;5;249m ";
  const char g9_str[] = "\033[48;5;189m ";
  const char gA_str[] = "\033[48;5;195m ";

  const char W1_str[] = "\033[48;5;231m ";

  const char b0_str[] = "\033[48;5;32m ";
  const char b1_str[] = "\033[48;5;66m ";
  const char b2_str[] = "\033[48;5;68m ";
  const char b3_str[] = "\033[48;5;74m ";
  const char RST_str[] = "\033[0m ";

enum Color {
    b0 = 0,
    b1,
    b2,
    b3,
    W1,
    g0,
    g1,
    g2,
    g3,
    g4,
    g5,
    g6,
    g7,
    g8,
    g9,
    gA,
    RST,
    CRLF_token,
};

const char* tokenStringTable[] = {
    b0_str,
    b1_str,
    b2_str,
    b3_str,
    W1_str,
    g0_str,
    g1_str,
    g2_str,
    g3_str,
    g4_str,
    g5_str,
    g6_str,
    g7_str,
    g8_str,
    g9_str,
    gA_str,
    RST_str,
    CRLF,
};

static const struct __attribute__((packed)) {
    uint8_t const count;
    enum Color const tokenIndex;
} rleLogoElements[] = {
   { 1, RST }, { 1, CRLF_token },
   { 46, W1 }, { 3, b1 }, { 1, g4 }, { 25, W1 }, { 1, RST }, { 1, CRLF_token },
   { 46, W1 }, { 3, g4 }, { 26, W1 }, { 1, RST }, { 1, CRLF_token },
   { 1, W1 }, { 1, g9 }, { 15, g7 }, { 5, W1 }, { 3, g8 }, { 1, g8 }, { 3, g6 },
        { 1, g8 }, { 1, g9 }, { 6, W1 }, { 1, g8 }, { 3, W1 }, { 3, g8 },
        {1, W1 }, { 3, g8 }, { 6, W1 }, { 1, g8 }, { 2, g5 }, { 1, g8 },
        { 1, gA }, { 11, W1 }, { 5, g8 }, { 1, RST }, { 1, CRLF_token },
   { 1, gA},  { 16, b0 }, { 1, g9 }, { 3, W1 }, { 1, g8 }, { 9, b1 }, { 1, g4 },
        { 3, W1 }, { 1, g8 }, { 2, g1 }, { 1, W1 }, { 2, g8 }, { 2, b1 },
        { 1, g1 }, { 1, W1 }, { 1, g4 }, { 1, b1 }, { 1, g4 }, { 4, W1 },
        { 1, g4 }, { 6, b1 }, { 1, g4 }, { 6, W1 }, { 1, g8 }, { 1, g4 },
        { 1, g0 }, { 5, b1 }, { 1, g2 }, { 1, RST }, { 1, CRLF_token },
   { 3, W1 }, { 1, g7 }, { 1, b2 }, { 10, b0 }, { 1, b2 }, { 1, g6 }, { 6, W1 },
        { 1, g8 }, { 1, g4 }, { 1, g6 }, { 2, g8 }, { 3, W1 }, { 2, g8 },
        { 1, b1 }, { 1, g2 }, { 2, W1 }, { 1, g2 }, { 1, b1 }, { 1, g4 },
        { 1, g8 }, { 2, b1 }, { 1, g0 }, { 1, g1 }, { 1, g8 }, { 1, W1 },
        { 1, g0 }, { 1, b1 }, { 1, g8 }, { 2, W1 }, { 1, g8 }, { 1, g0 },
        { 1, b1 }, { 1, g4 }, { 1, g8 }, { 2, W1 }, { 1, g8 }, { 1, g2 },
        { 1, b1 }, { 1, g0 }, { 4, W1 }, { 1, g4 }, { 3, b1 }, { 1, g0 },
        { 1, g1 }, { 1, g4 }, { 1, g8 }, { 1, RST }, { 1, CRLF_token },
   { 1, gA }, { 1, g3 }, { 1, g9 }, { 1, W1 }, { 1, gA }, { 1, b2 }, { 6, b0 },
        { 1, b2 }, { 1, gA }, { 1, W1 }, { 1, g6 }, { 1, g3 }, { 1, gA },
        { 8, W1 }, { 4, W1 }, { 1, g8 }, { 1, b1 }, { 1, b1 }, { 1, g9 },
        { 1, W1 }, { 1, g8 }, { 1, b1 }, { 1, g0 }, { 1, b1 }, { 1, g4 },
        { 1, g8 }, { 4, W1 }, { 1, b1 }, { 1, g0 }, { 2, W1 }, { 1, g8 },
        { 2, g0 }, { 1, g8 }, { 6, W1 }, { 1, g4 }, { 1, b1 }, { 1, g4 },
        { 2, W1 }, { 1, g1 }, { 1, b1 }, { 1, g0 }, { 1, g8 }, { 1, g9 },
        { 6, W1 }, { 1, RST }, { 1, CRLF_token },
   { 1, g9 }, { 2, b0 }, { 1, g5 }, { 1, W1 }, { 1, g9 }, { 5, b0 }, { 1, b2 },
        { 1, gA }, { 1, W1 }, { 1, b3 }, { 2, b0 }, { 1, g9 }, { 13, W1 },
        { 2, b1 }, { 1, g8 }, { 1, W1 }, { 1, g8 }, { 2, b1 }, { 1, g8 },
        { 5, W1 }, { 1, g8 }, { 1, b1 }, { 1, g2 }, { 2, W1 }, { 1, g1 },
        { 1, b1 }, { 1, g8 }, { 8, W1 }, { 2, b1 }, { 1, W1 }, { 1, g8 },
        { 1, b1 }, { 1, g0 }, { 9, W1 }, { 1, RST }, { 1, CRLF_token },
   { 1, g9 }, { 3, b0 }, { 1, g9 }, { 1, W1 }, { 1, g3 }, { 4, b0 }, { 1, g9 },
        { 1, W1 }, { 1, g3 }, { 3, b0 }, { 4, W1 }, { 2, W1 }, { 1, g8 },
        { 1, g5 }, { 1, g4 }, { 1, g2 }, { 2, g4 }, { 1, g8 }, { 1, W1 },
        { 2, b1 }, { 1, g8 }, { 1, W1 }, { 1, g8 }, { 1, b1 }, { 1, g4 },
        { 6, W1 }, { 1, g6 }, { 1, b1 }, { 1, g4 }, { 1, W1 }, { 1, g8 },
        { 1, b1 }, { 1, g0 }, { 9, W1 }, { 1, g4 }, { 1, b1 }, { 1, g8 },
        { 1, W1 }, { 2, b1 }, { 1, g8 }, { 8, W1 },
        { 1, RST }, { 1, CRLF_token },
   { 1, g6 }, { 3, b0 }, { 1, b2 }, { 1, W1 }, { 1, g9 }, { 3, b0 }, { 1, g3 },
        { 1, W1 }, { 1, g9 }, { 4, b0 }, { 4, W1 }, { 1, g8 }, { 1, g1 },
        { 7, b1 }, { 1, g2 }, { 2, b1 }, { 1, g8 }, { 1, W1 }, { 1, g8 },
        { 1, b1 }, { 1, g8 }, { 6, W1 }, { 1, g4 }, { 1, b1 }, { 1, g8 },
        { 1, W1 }, { 1, g4 }, { 1, b1 }, { 11, g0 }, { 1, b1 }, { 1, g4 },
        { 1, W1 }, { 1, g8 }, { 1, b1 }, { 1, g0 }, { 1, g5 }, { 7, W1 },
        { 1, RST }, { 1, CRLF_token },
   { 1, g6 }, { 4, b0 }, { 1, g9 }, { 1, W1 }, { 1, b3 }, { 2, b0 }, { 1, g9 },
        { 1, W1 }, { 1, b2 }, { 4, b0 }, { 2, W1 }, { 1, W1 }, { 2, g8 },
        { 1, b1 }, { 1, g0 }, { 1, g8 }, { 2, W1 }, { 1, W1 }, { 1, g8 },
        { 1, g1 }, { 3, b1 }, { 2, W1 }, { 2, b1 }, { 4, W1 }, { 3, W1 },
        { 1, g0 }, { 1, b1 }, { 1, g8 }, { 1, W1 }, { 1, g4 }, { 1, b1 },
        { 12, g0 }, { 1, g5 }, { 2, W1 }, { 1, g8 }, { 1, g1 }, { 2, b1 },
        { 1, g4 }, { 1, g8 }, { 4, W1 }, { 1, RST }, { 1, CRLF_token },
   { 1, g5 }, { 4, b0 }, { 1, g3 }, { 1, W1 }, { 1, g6 }, { 1, b0 }, { 1, b2 },
        { 1, W1 }, { 1, g9 }, { 4, b0 }, { 1, b2 }, { 3, W1 }, { 1, g8 },
        { 1, b1 }, { 1, g1 }, { 7, W1 }, { 1, g2 }, { 2, b1 }, { 2, W1 },
        { 1, b1 }, { 1, g0 }, { 7, W1 }, { 2, b1 }, { 1, g8 }, { 1, W1 },
        { 1, g1 }, { 1, b1 }, { 1, g6 }, { 16, W1 }, { 1, g8 }, { 1, g4 },
        { 1, g0 }, { 1, b1 }, { 1, g0 }, { 1, g8 }, { 2, W1 },
        { 1, RST }, { 1, CRLF_token },
   { 1, g5 }, { 5, b0 }, { 1, W1 }, { 1, g9 }, { 1, b0 }, { 1, g6 }, { 1, W1 },
        { 1, g3 }, { 4, b0 }, { 1, b2 }, { 3, W1 }, { 2, g4 }, { 1, g8 },
        { 7, W1 }, { 1, g8 }, { 1, g4 }, { 1, g5 }, { 2, W1 }, { 1, g4 },
        { 1, g5 }, { 7, W1 }, { 2, g4 }, { 1, g8 }, { 1, W1 }, { 1, g8 },
        { 1, g4 }, { 1, g8 }, { 19, W1 }, { 2, g8 }, { 1, b1 }, { 1, g6 },
        { 1, W1 }, { 1, RST }, { 1, CRLF_token },
   { 1, g3 }, { 5, b0 }, { 1, g9 }, { 1, W1 }, { 1, b0 }, { 1, g9 }, { 1, gA },
        { 5, b0 }, { 1, b2 }, { 54, W1 }, { 1, gA }, { 2, b1 }, { 1, W1 },
        { 1, RST }, { 1, CRLF_token },
   { 1, g3 }, { 5, b0 }, { 1, g6 }, { 1, W1 }, { 1, b2 }, { 1, W1 }, { 1, g6 },
        { 5, b0 }, { 1, b3 }, { 16, W1 }, { 1, g4 }, { 12, W1 }, { 1, g4 },
        { 4, W1 }, { 2, g8 }, { 9, W1 }, { 1, g8 }, { 8, W1 }, { 1, g8 },
        { 2, b1 }, { 1, g8 }, { 1, RST }, { 1, CRLF_token },
   { 1, g3 }, { 5, b0 }, { 1, g3 }, { 1, W1 }, { 1, g3 }, { 1, W1 }, { 1, g3 },
        { 2, b0 }, { 3, b0 }, { 1, g3 }, { 3, W1 }, { 3, g8 }, { 2, W1 },
        { 3, g8 }, { 1, W1 }, { 2, g8 }, { 2, W1 }, { 1, g4 }, { 2, g8 },
        { 2, W1 }, { 1, W1 }, { 2, g8 }, { 3, W1 }, { 2, g8 }, { 1, g4 },
        { 2, W1 }, { 2, g8 }, { 1, g5 }, { 2, W1 }, { 3, g8 }, { 2, W1 },
        { 4, g8 }, { 5, W1 }, { 2, g8 }, { 1, g4 }, { 1, b1 }, { 1, b1 },
        { 1, g8 }, { 1, W1 }, { 1, RST }, { 1, CRLF_token },
   { 1, b3 }, { 5, b0 }, { 1, b2 }, { 1, W1 }, { 1, g7 }, { 1, W1 }, { 6, b0 },
        { 1, g3 }, { 2, W1 }, { 2, g8 }, { 3, g8 }, { 1, g8 }, { 1, W1 },
        { 1, g8 }, { 1, g6 }, { 1, W1 }, { 2, g8 }, { 1, W1 }, { 1, g4 },
        { 2, W1 }, { 1, g4 }, { 1, W1 }, { 1, g4 }, { 2, W1 }, { 1, g4 },
        { 1, W1 }, { 1, g4 }, { 2, W1 }, { 1, g4 }, { 1, W1 }, { 1, g4 },
        { 2, W1 }, { 1, g4 }, { 1, W1 }, { 2, g8 }, { 1, W1 }, { 3, g8 },
        { 1, g8 }, { 1, W1 }, { 3, g8 }, { 1, g8 }, { 2, g0 }, { 1, b1 },
        { 1, b1 }, { 1, b1 }, { 1, b1 }, { 1, b1 }, { 1, g4 }, { 3, W1 },
        { 1, RST }, { 1, CRLF_token },
   { 1, b2 }, { 6, b0 }, { 2, W1 }, { 1, g9 }, { 6, b0 }, { 1, g3 }, { 2, W1 },
        { 1, g5 }, { 8, g8 }, { 1, W1 }, { 2, g8 }, { 1, W1 }, { 1, g8 },
        { 2, W1 }, { 1, g4 }, { 1, W1 }, { 1, g4 }, { 2, g8 }, { 1, g6 },
        { 1, W1 }, { 1, g8 }, { 2, W1 }, { 1, g4 }, { 1, W1 }, { 1, g4 },
        { 2, W1 }, { 1, g8 }, { 1, W1 }, { 1, g4 }, { 4, g8 }, { 1, g4 },
        { 2, W1 }, { 3, g8 }, { 4, b1 }, { 1, g8 }, { 1, g2 }, { 1, g6 },
        { 1, gA }, { 4, W1 }, { 1, RST }, { 1, CRLF_token },
   { 7, b0 }, { 2, W1 }, { 1, g7 }, { 6, b0 }, { 1, g5 }, { 2, W1 }, { 1, g6 },
        { 4, W1 }, { 1, g8 }, { 2, W1 }, { 2, g8 }, { 1, W1 }, { 2, g8 },
        { 1, W1 }, { 1, g8 }, { 2, W1 }, { 1, g4 }, { 1, W1 }, { 1, g8 },
        { 4, W1 }, { 1, g8 }, { 2, W1 }, { 1, g4 }, { 1, W1 }, { 1, g4 },
        { 2, W1 }, { 1, g4 }, { 1, W1 }, { 1, g4 }, { 4, W1 }, { 1, g5 },
        { 2, W1 }, { 2, g8 }, { 1, W1 }, { 3, g8 }, { 8, W1 },
        { 1, RST }, { 1, CRLF_token },
   { 1, b3 }, { 6, b2 }, { 1, gA }, { 1, W1 }, { 1, g6 }, { 6, b2 }, { 1, g9 },
         { 3, W1 }, { 1, g6 }, { 2, g8 }, { 1, W1 }, { 1, g8 }, { 2, W1 },
         { 1, g8 }, { 2, W1 }, { 2, g8 }, { 1, W1 }, { 1, g5 }, { 1, g8 },
         { 1, g6 }, { 2, W1 }, { 3, g8 }, { 1, g8 }, { 1, W1 }, { 4, g8 },
         { 1, W1 }, { 3, g8 }, { 1, g4 }, { 2, W1 }, { 1, g6 }, { 2, g8 },
         { 2, W1 }, { 1, g5 }, { 1, g8 }, { 1, g5 }, { 13, W1 },
         { 1, RST }, { 1, CRLF_token },
};
#endif

bool HSS_LogoInit(void)
{
#if IS_ENABLED(CONFIG_COLOR_OUTPUT)
    int i;

    // decode and output our RLE Logo
    for (i = 0; i < ARRAY_SIZE(rleLogoElements); i++) {
        uint8_t j;

        for (j = 0u; j < rleLogoElements[i].count; j++) {
            mHSS_PUTS(tokenStringTable[rleLogoElements[i].tokenIndex]);
        }
    }

#endif

    mHSS_PUTS(CRLF
        "-------------------------" CRLF
        "--      M100PFS        --" CRLF
        "-- PolarFire SoC FPGA  --" CRLF
        "--                     --" CRLF
        "-- Copyright (c) 2021  --" CRLF
        "-- ARIES Embedded GmbH --" CRLF
        "-------------------------" CRLF
        CRLF);

    return true;
}

