{-# LANGUAGE ForeignFunctionInterface #-}
module DB.HSQL.ODBC.Functions where

import Foreign(FunPtr,Ptr)
import Foreign.C(CString)

import DB.HSQL.ODBC.Type(SQLSMALLINT,SQLUSMALLINT,SQLINTEGER,SQLLEN,SQLULEN
                        ,SQLRETURN,HSTMT,HDBC,HENV,SQLHANDLE)


#include <HsODBC.h>

#ifdef mingw32_HOST_OS
#let CALLCONV = "stdcall"
#else
#let CALLCONV = "ccall"
#endif

foreign import #{CALLCONV} "HsODBC.h SQLAllocEnv" 
 sqlAllocEnv:: Ptr HENV -> IO SQLRETURN

#ifdef mingw32_HOST_OS
foreign import ccall "HsODBC.h &my_sqlFreeEnv" 
 sqlFreeEnv_p:: FunPtr (HENV -> IO ())
#else
foreign import ccall "HsODBC.h &SQLFreeEnv" 
 sqlFreeEnv_p:: FunPtr (HENV -> IO ())
#endif

foreign import #{CALLCONV} "HsODBC.h SQLAllocConnect" 
 sqlAllocConnect:: HENV -> Ptr HDBC -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLFreeConnect" 
 sqlFreeConnect:: HDBC -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLConnect" 
 sqlConnect:: HDBC -> CString -> Int -> CString -> Int -> CString -> Int 
           -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLDriverConnect" 
 sqlDriverConnect:: HDBC -> Ptr () -> CString -> SQLSMALLINT -> CString 
                 -> SQLSMALLINT -> Ptr SQLSMALLINT -> SQLUSMALLINT 
                 -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLDisconnect" 
 sqlDisconnect:: HDBC -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLAllocStmt" 
 sqlAllocStmt:: HDBC -> Ptr HSTMT -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLFreeStmt" 
 sqlFreeStmt:: HSTMT -> SQLUSMALLINT -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLNumResultCols" 
 sqlNumResultCols:: HSTMT -> Ptr SQLUSMALLINT -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLDescribeCol" 
 sqlDescribeCol:: HSTMT -> SQLUSMALLINT -> CString -> SQLSMALLINT 
               -> Ptr SQLSMALLINT -> Ptr SQLSMALLINT -> Ptr SQLULEN 
               -> Ptr SQLSMALLINT -> Ptr SQLSMALLINT 
               -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLBindCol" 
 sqlBindCol:: HSTMT -> SQLUSMALLINT -> SQLSMALLINT -> Ptr a 
           -> SQLLEN -> Ptr SQLINTEGER 
           -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLFetch" 
 sqlFetch:: HSTMT -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLGetDiagRec" 
 sqlGetDiagRec:: SQLSMALLINT -> SQLHANDLE -> SQLSMALLINT -> CString 
              -> Ptr SQLINTEGER -> CString -> SQLSMALLINT -> Ptr SQLSMALLINT 
              -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLExecDirect" 
 sqlExecDirect:: HSTMT -> CString -> Int -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLSetConnectOption" 
 sqlSetConnectOption:: HDBC -> SQLUSMALLINT -> SQLULEN -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLTransact" 
 sqlTransact:: HENV -> HDBC -> SQLUSMALLINT -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLGetData" 
 sqlGetData:: HSTMT -> SQLUSMALLINT -> SQLSMALLINT -> Ptr () 
           -> SQLINTEGER -> Ptr SQLINTEGER 
           -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLTables" 
 sqlTables:: HSTMT -> CString -> SQLSMALLINT -> CString -> SQLSMALLINT 
          -> CString -> SQLSMALLINT -> CString -> SQLSMALLINT 
          -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLColumns" 
 sqlColumns:: HSTMT -> CString -> SQLSMALLINT -> CString -> SQLSMALLINT 
           -> CString -> SQLSMALLINT -> CString -> SQLSMALLINT 
           -> IO SQLRETURN

foreign import #{CALLCONV} "HsODBC.h SQLMoreResults" 
 sqlMoreResults:: HSTMT -> IO SQLRETURN

#if defined(MSSQL_ODBC)
foreign import #{CALLCONV} "HsODBC.h SQLSetStmtAttr" 
 sqlSetStmtAttr:: HSTMT -> SQLINTEGER -> SQLINTEGER -> SQLINTEGER 
               -> IO SQLRETURN
#endif


-- |

-- ptrField thinc = (#ptr FIELD, thinc)

-- peekField = #peek FIELD


-- | 
sqlNts:: SQLSMALLINT
sqlNts = #const SQL_NTS 

sqlDriverNoPrompt:: SQLUSMALLINT
sqlDriverNoPrompt = #const SQL_DRIVER_NOPROMPT

sqlHandleEnv:: SQLSMALLINT
sqlHandleEnv = #const SQL_HANDLE_ENV

sqlHandleDbc:: SQLSMALLINT
sqlHandleDbc = #const SQL_HANDLE_DBC

sizeOfHStmt:: Int
sizeOfHStmt = #const sizeof(HSTMT)

sizeOfField:: Int
sizeOfField = #const sizeof(FIELD)

sqlHandleStmt:: SQLSMALLINT
sqlHandleStmt = #const SQL_HANDLE_STMT

sqlDrop:: SQLUSMALLINT
sqlDrop = #const SQL_DROP

fieldNameLength:: SQLSMALLINT
fieldNameLength = #const FIELD_NAME_LENGTH

sqlAutoCommit:: SQLUSMALLINT
sqlAutoCommit = #const SQL_AUTOCOMMIT

sqlAutoCommitOff:: SQLULEN
sqlAutoCommitOff = #const SQL_AUTOCOMMIT_OFF

sqlAutoCommitOn:: SQLULEN
sqlAutoCommitOn = #const SQL_AUTOCOMMIT_ON 

sqlCommit:: SQLUSMALLINT
sqlCommit = #const SQL_COMMIT

sqlRollback:: SQLUSMALLINT
sqlRollback = #const SQL_ROLLBACK

sqlNullData:: SQLINTEGER
sqlNullData = #const SQL_NULL_DATA

sqlCChar:: SQLSMALLINT
sqlCChar = #const SQL_C_CHAR

-- (no #include <HsODBC.h> needed??
sqlAttrRowArraySize = #const SQL_ATTR_ROW_ARRAY_SIZE

sqlIsInteger = #const SQL_IS_INTEGER

sqlAttrCursorType = #const SQL_ATTR_CURSOR_TYPE

sqlCursorStatic = #const SQL_CURSOR_STATIC

