{- |
Copyright   :  (c) Henning Thielemann 2007

Maintainer  :  haskell@henning-thielemann.de
Stability   :  stable
Portability :  Haskell 98

A type class for non-negative numbers.
Prominent instances are 'Numeric.NonNegative.Wrapper.T' and peano numbers.
This class cannot do any checks,
but it let you show to the user what arguments your function expects.
In fact many standard functions ('take', '(!!)', ...)
should have this type class constraint.
Thus you must define class instances with care.
-}
module Numeric.NonNegative.Class (C(..)) where


{- |
Instances of this class must ensure non-negative values.
We cannot enforce this by types, but the type class constraint @NonNegative.C@
avoids accidental usage of types which allow for negative numbers.
-}
class (Ord a, Num a) => C a where
   {- |
   @x -| y == max 0 (x-y)@

   The default implementation is not efficient,
   because it compares the values and then subtracts, again, if safe.
   @max 0 (x-y)@ is more elegant and efficient
   but not possible in the general case,
   since @x-y@ may already yield a negative number.
   -}
   (-|) :: a -> a -> a
   x -| y  =  if x >= y then x-y else 0
