-- Built via embarrassing grep/sed technology from the XML OpenGL SDK docs at
-- https://cvs.khronos.org/svn/repos/ogl/trunk/ecosystem/public/sdk/docs/man[234].
module ManPages ( manPageURLs ) where

import qualified Data.Map as M
import MangledRegistry ( API(..), CommandName(..) )

type ManPageKey = (API, CommandName)
type URL = String
type Label = String

assocsGL2 :: [(ManPageKey, [(URL, Label)])]
assocsGL2 =
  entriesFor "gl" "OpenGL 2.x" "https://www.opengl.org/sdk/docs/man2/xhtml/" ".xml" [
  ("glAccum", "glAccum"),
  ("glActiveTexture", "glActiveTexture"),
  ("glAlphaFunc", "glAlphaFunc"),
  ("glAreTexturesResident", "glAreTexturesResident"),
  ("glArrayElement", "glArrayElement"),
  ("glAttachShader", "glAttachShader"),
  ("glBeginQuery", "glBeginQuery"),
  ("glEndQuery", "glBeginQuery"),
  ("glBegin", "glBegin"),
  ("glEnd", "glBegin"),
  ("glBindAttribLocation", "glBindAttribLocation"),
  ("glBindBuffer", "glBindBuffer"),
  ("glBindTexture", "glBindTexture"),
  ("glBitmap", "glBitmap"),
  ("glBlendColor", "glBlendColor"),
  ("glBlendEquationSeparate", "glBlendEquationSeparate"),
  ("glBlendEquation", "glBlendEquation"),
  ("glBlendFuncSeparate", "glBlendFuncSeparate"),
  ("glBlendFunc", "glBlendFunc"),
  ("glBufferData", "glBufferData"),
  ("glBufferSubData", "glBufferSubData"),
  ("glCallLists", "glCallLists"),
  ("glCallList", "glCallList"),
  ("glClearAccum", "glClearAccum"),
  ("glClearColor", "glClearColor"),
  ("glClearDepth", "glClearDepth"),
  ("glClearIndex", "glClearIndex"),
  ("glClearStencil", "glClearStencil"),
  ("glClear", "glClear"),
  ("glClientActiveTexture", "glClientActiveTexture"),
  ("glClipPlane", "glClipPlane"),
  ("glColorMask", "glColorMask"),
  ("glColorMaterial", "glColorMaterial"),
  ("glColorPointer", "glColorPointer"),
  ("glColorSubTable", "glColorSubTable"),
  ("glColorTableParameterfv", "glColorTableParameter"),
  ("glColorTableParameteriv", "glColorTableParameter"),
  ("glColorTable", "glColorTable"),
  ("glColor3b", "glColor"),
  ("glColor3s", "glColor"),
  ("glColor3i", "glColor"),
  ("glColor3f", "glColor"),
  ("glColor3d", "glColor"),
  ("glColor3ub", "glColor"),
  ("glColor3us", "glColor"),
  ("glColor3ui", "glColor"),
  ("glColor4b", "glColor"),
  ("glColor4s", "glColor"),
  ("glColor4i", "glColor"),
  ("glColor4f", "glColor"),
  ("glColor4d", "glColor"),
  ("glColor4ub", "glColor"),
  ("glColor4us", "glColor"),
  ("glColor4ui", "glColor"),
  ("glColor3bv", "glColor"),
  ("glColor3sv", "glColor"),
  ("glColor3iv", "glColor"),
  ("glColor3fv", "glColor"),
  ("glColor3dv", "glColor"),
  ("glColor3ubv", "glColor"),
  ("glColor3usv", "glColor"),
  ("glColor3uiv", "glColor"),
  ("glColor4bv", "glColor"),
  ("glColor4sv", "glColor"),
  ("glColor4iv", "glColor"),
  ("glColor4fv", "glColor"),
  ("glColor4dv", "glColor"),
  ("glColor4ubv", "glColor"),
  ("glColor4usv", "glColor"),
  ("glColor4uiv", "glColor"),
  ("glCompileShader", "glCompileShader"),
  ("glCompressedTexImage1D", "glCompressedTexImage1D"),
  ("glCompressedTexImage2D", "glCompressedTexImage2D"),
  ("glCompressedTexImage3D", "glCompressedTexImage3D"),
  ("glCompressedTexSubImage1D", "glCompressedTexSubImage1D"),
  ("glCompressedTexSubImage2D", "glCompressedTexSubImage2D"),
  ("glCompressedTexSubImage3D", "glCompressedTexSubImage3D"),
  ("glConvolutionFilter1D", "glConvolutionFilter1D"),
  ("glConvolutionFilter2D", "glConvolutionFilter2D"),
  ("glConvolutionParameterf", "glConvolutionParameter"),
  ("glConvolutionParameteri", "glConvolutionParameter"),
  ("glConvolutionParameterfv", "glConvolutionParameter"),
  ("glConvolutionParameteriv", "glConvolutionParameter"),
  ("glCopyColorSubTable", "glCopyColorSubTable"),
  ("glCopyColorTable", "glCopyColorTable"),
  ("glCopyConvolutionFilter1D", "glCopyConvolutionFilter1D"),
  ("glCopyConvolutionFilter2D", "glCopyConvolutionFilter2D"),
  ("glCopyPixels", "glCopyPixels"),
  ("glCopyTexImage1D", "glCopyTexImage1D"),
  ("glCopyTexImage2D", "glCopyTexImage2D"),
  ("glCopyTexSubImage1D", "glCopyTexSubImage1D"),
  ("glCopyTexSubImage2D", "glCopyTexSubImage2D"),
  ("glCopyTexSubImage3D", "glCopyTexSubImage3D"),
  ("glCreateProgram", "glCreateProgram"),
  ("glCreateShader", "glCreateShader"),
  ("glCullFace", "glCullFace"),
  ("glDeleteBuffers", "glDeleteBuffers"),
  ("glDeleteLists", "glDeleteLists"),
  ("glDeleteProgram", "glDeleteProgram"),
  ("glDeleteQueries", "glDeleteQueries"),
  ("glDeleteShader", "glDeleteShader"),
  ("glDeleteTextures", "glDeleteTextures"),
  ("glDepthFunc", "glDepthFunc"),
  ("glDepthMask", "glDepthMask"),
  ("glDepthRange", "glDepthRange"),
  ("glDetachShader", "glDetachShader"),
  ("glDrawArrays", "glDrawArrays"),
  ("glDrawBuffers", "glDrawBuffers"),
  ("glDrawBuffer", "glDrawBuffer"),
  ("glDrawElements", "glDrawElements"),
  ("glDrawPixels", "glDrawPixels"),
  ("glDrawRangeElements", "glDrawRangeElements"),
  ("glEdgeFlagPointer", "glEdgeFlagPointer"),
  ("glEdgeFlag", "glEdgeFlag"),
  ("glEdgeFlagv", "glEdgeFlag"),
  ("glEnableClientState", "glEnableClientState"),
  ("glDisableClientState", "glEnableClientState"),
  ("glEnableVertexAttribArray", "glEnableVertexAttribArray"),
  ("glDisableVertexAttribArray", "glEnableVertexAttribArray"),
  ("glEnable", "glEnable"),
  ("glDisable", "glEnable"),
  ("glEvalCoord1f", "glEvalCoord"),
  ("glEvalCoord1d", "glEvalCoord"),
  ("glEvalCoord2f", "glEvalCoord"),
  ("glEvalCoord2d", "glEvalCoord"),
  ("glEvalCoord1fv", "glEvalCoord"),
  ("glEvalCoord1dv", "glEvalCoord"),
  ("glEvalCoord2fv", "glEvalCoord"),
  ("glEvalCoord2dv", "glEvalCoord"),
  ("glEvalMesh1", "glEvalMesh"),
  ("glEvalMesh2", "glEvalMesh"),
  ("glEvalPoint1", "glEvalPoint"),
  ("glEvalPoint2", "glEvalPoint"),
  ("glFeedbackBuffer", "glFeedbackBuffer"),
  ("glFinish", "glFinish"),
  ("glFlush", "glFlush"),
  ("glFogCoordPointer", "glFogCoordPointer"),
  ("glFogCoordd", "glFogCoord"),
  ("glFogCoordf", "glFogCoord"),
  ("glFogCoorddv", "glFogCoord"),
  ("glFogCoordfv", "glFogCoord"),
  ("glFogf", "glFog"),
  ("glFogi", "glFog"),
  ("glFogfv", "glFog"),
  ("glFogiv", "glFog"),
  ("glFrontFace", "glFrontFace"),
  ("glFrustum", "glFrustum"),
  ("glGenBuffers", "glGenBuffers"),
  ("glGenLists", "glGenLists"),
  ("glGenQueries", "glGenQueries"),
  ("glGenTextures", "glGenTextures"),
  ("glGetActiveAttrib", "glGetActiveAttrib"),
  ("glGetActiveUniform", "glGetActiveUniform"),
  ("glGetAttachedShaders", "glGetAttachedShaders"),
  ("glGetAttribLocation", "glGetAttribLocation"),
  ("glGetBufferParameteriv", "glGetBufferParameteriv"),
  ("glGetBufferPointerv", "glGetBufferPointerv"),
  ("glGetBufferSubData", "glGetBufferSubData"),
  ("glGetClipPlane", "glGetClipPlane"),
  ("glGetColorTableParameterfv", "glGetColorTableParameter"),
  ("glGetColorTableParameteriv", "glGetColorTableParameter"),
  ("glGetColorTable", "glGetColorTable"),
  ("glGetCompressedTexImage", "glGetCompressedTexImage"),
  ("glGetConvolutionFilter", "glGetConvolutionFilter"),
  ("glGetConvolutionParameterfv", "glGetConvolutionParameter"),
  ("glGetConvolutionParameteriv", "glGetConvolutionParameter"),
  ("glGetError", "glGetError"),
  ("glGetHistogramParameterfv", "glGetHistogramParameter"),
  ("glGetHistogramParameteriv", "glGetHistogramParameter"),
  ("glGetHistogram", "glGetHistogram"),
  ("glGetLightfv", "glGetLight"),
  ("glGetLightiv", "glGetLight"),
  ("glGetMapdv", "glGetMap"),
  ("glGetMapfv", "glGetMap"),
  ("glGetMapiv", "glGetMap"),
  ("glGetMaterialfv", "glGetMaterial"),
  ("glGetMaterialiv", "glGetMaterial"),
  ("glGetMinmaxParameterfv", "glGetMinmaxParameter"),
  ("glGetMinmaxParameteriv", "glGetMinmaxParameter"),
  ("glGetMinmax", "glGetMinmax"),
  ("glGetPixelMapfv", "glGetPixelMap"),
  ("glGetPixelMapuiv", "glGetPixelMap"),
  ("glGetPixelMapusv", "glGetPixelMap"),
  ("glGetPointerv", "glGetPointerv"),
  ("glGetPolygonStipple", "glGetPolygonStipple"),
  ("glGetProgramInfoLog", "glGetProgramInfoLog"),
  ("glGetProgramiv", "glGetProgram"),
  ("glGetQueryiv", "glGetQueryiv"),
  ("glGetQueryObjectiv", "glGetQueryObject"),
  ("glGetQueryObjectuiv", "glGetQueryObject"),
  ("glGetSeparableFilter", "glGetSeparableFilter"),
  ("glGetShaderInfoLog", "glGetShaderInfoLog"),
  ("glGetShaderSource", "glGetShaderSource"),
  ("glGetShaderiv", "glGetShader"),
  ("glGetString", "glGetString"),
  ("glGetTexEnvfv", "glGetTexEnv"),
  ("glGetTexEnviv", "glGetTexEnv"),
  ("glGetTexGendv", "glGetTexGen"),
  ("glGetTexGenfv", "glGetTexGen"),
  ("glGetTexGeniv", "glGetTexGen"),
  ("glGetTexImage", "glGetTexImage"),
  ("glGetTexLevelParameterfv", "glGetTexLevelParameter"),
  ("glGetTexLevelParameteriv", "glGetTexLevelParameter"),
  ("glGetTexParameterfv", "glGetTexParameter"),
  ("glGetTexParameteriv", "glGetTexParameter"),
  ("glGetUniformLocation", "glGetUniformLocation"),
  ("glGetUniformfv", "glGetUniform"),
  ("glGetUniformiv", "glGetUniform"),
  ("glGetVertexAttribPointerv", "glGetVertexAttribPointerv"),
  ("glGetVertexAttribdv", "glGetVertexAttrib"),
  ("glGetVertexAttribfv", "glGetVertexAttrib"),
  ("glGetVertexAttribiv", "glGetVertexAttrib"),
  ("glGetBooleanv", "glGet"),
  ("glGetDoublev", "glGet"),
  ("glGetFloatv", "glGet"),
  ("glGetIntegerv", "glGet"),
  ("glHint", "glHint"),
  ("glHistogram", "glHistogram"),
  ("glIndexMask", "glIndexMask"),
  ("glIndexPointer", "glIndexPointer"),
  ("glIndexs", "glIndex"),
  ("glIndexi", "glIndex"),
  ("glIndexf", "glIndex"),
  ("glIndexd", "glIndex"),
  ("glIndexub", "glIndex"),
  ("glIndexsv", "glIndex"),
  ("glIndexiv", "glIndex"),
  ("glIndexfv", "glIndex"),
  ("glIndexdv", "glIndex"),
  ("glIndexubv", "glIndex"),
  ("glInitNames", "glInitNames"),
  ("glInterleavedArrays", "glInterleavedArrays"),
  ("glIsBuffer", "glIsBuffer"),
  ("glIsEnabled", "glIsEnabled"),
  ("glIsList", "glIsList"),
  ("glIsProgram", "glIsProgram"),
  ("glIsQuery", "glIsQuery"),
  ("glIsShader", "glIsShader"),
  ("glIsTexture", "glIsTexture"),
  ("glLightModelf", "glLightModel"),
  ("glLightModeli", "glLightModel"),
  ("glLightModelfv", "glLightModel"),
  ("glLightModeliv", "glLightModel"),
  ("glLightf", "glLight"),
  ("glLighti", "glLight"),
  ("glLightfv", "glLight"),
  ("glLightiv", "glLight"),
  ("glLineStipple", "glLineStipple"),
  ("glLineWidth", "glLineWidth"),
  ("glLinkProgram", "glLinkProgram"),
  ("glListBase", "glListBase"),
  ("glLoadIdentity", "glLoadIdentity"),
  ("glLoadMatrixd", "glLoadMatrix"),
  ("glLoadMatrixf", "glLoadMatrix"),
  ("glLoadName", "glLoadName"),
  ("glLoadTransposeMatrixd", "glLoadTransposeMatrix"),
  ("glLoadTransposeMatrixf", "glLoadTransposeMatrix"),
  ("glLogicOp", "glLogicOp"),
  ("glMap1f", "glMap1"),
  ("glMap1d", "glMap1"),
  ("glMap2f", "glMap2"),
  ("glMap2d", "glMap2"),
  ("glMapBuffer", "glMapBuffer"),
  ("glUnmapBuffer", "glMapBuffer"),
  ("glMapGrid1d", "glMapGrid"),
  ("glMapGrid1f", "glMapGrid"),
  ("glMapGrid2d", "glMapGrid"),
  ("glMapGrid2f", "glMapGrid"),
  ("glMaterialf", "glMaterial"),
  ("glMateriali", "glMaterial"),
  ("glMaterialfv", "glMaterial"),
  ("glMaterialiv", "glMaterial"),
  ("glMatrixMode", "glMatrixMode"),
  ("glMinmax", "glMinmax"),
  ("glMultiDrawArrays", "glMultiDrawArrays"),
  ("glMultiDrawElements", "glMultiDrawElements"),
  ("glMultiTexCoord1s", "glMultiTexCoord"),
  ("glMultiTexCoord1i", "glMultiTexCoord"),
  ("glMultiTexCoord1f", "glMultiTexCoord"),
  ("glMultiTexCoord1d", "glMultiTexCoord"),
  ("glMultiTexCoord2s", "glMultiTexCoord"),
  ("glMultiTexCoord2i", "glMultiTexCoord"),
  ("glMultiTexCoord2f", "glMultiTexCoord"),
  ("glMultiTexCoord2d", "glMultiTexCoord"),
  ("glMultiTexCoord3s", "glMultiTexCoord"),
  ("glMultiTexCoord3i", "glMultiTexCoord"),
  ("glMultiTexCoord3f", "glMultiTexCoord"),
  ("glMultiTexCoord3d", "glMultiTexCoord"),
  ("glMultiTexCoord4s", "glMultiTexCoord"),
  ("glMultiTexCoord4i", "glMultiTexCoord"),
  ("glMultiTexCoord4f", "glMultiTexCoord"),
  ("glMultiTexCoord4d", "glMultiTexCoord"),
  ("glMultiTexCoord1sv", "glMultiTexCoord"),
  ("glMultiTexCoord1iv", "glMultiTexCoord"),
  ("glMultiTexCoord1fv", "glMultiTexCoord"),
  ("glMultiTexCoord1dv", "glMultiTexCoord"),
  ("glMultiTexCoord2sv", "glMultiTexCoord"),
  ("glMultiTexCoord2iv", "glMultiTexCoord"),
  ("glMultiTexCoord2fv", "glMultiTexCoord"),
  ("glMultiTexCoord2dv", "glMultiTexCoord"),
  ("glMultiTexCoord3sv", "glMultiTexCoord"),
  ("glMultiTexCoord3iv", "glMultiTexCoord"),
  ("glMultiTexCoord3fv", "glMultiTexCoord"),
  ("glMultiTexCoord3dv", "glMultiTexCoord"),
  ("glMultiTexCoord4sv", "glMultiTexCoord"),
  ("glMultiTexCoord4iv", "glMultiTexCoord"),
  ("glMultiTexCoord4fv", "glMultiTexCoord"),
  ("glMultiTexCoord4dv", "glMultiTexCoord"),
  ("glMultMatrixd", "glMultMatrix"),
  ("glMultMatrixf", "glMultMatrix"),
  ("glMultTransposeMatrixd", "glMultTransposeMatrix"),
  ("glMultTransposeMatrixf", "glMultTransposeMatrix"),
  ("glNewList", "glNewList"),
  ("glEndList", "glNewList"),
  ("glNormalPointer", "glNormalPointer"),
  ("glNormal3b", "glNormal"),
  ("glNormal3d", "glNormal"),
  ("glNormal3f", "glNormal"),
  ("glNormal3i", "glNormal"),
  ("glNormal3s", "glNormal"),
  ("glNormal3bv", "glNormal"),
  ("glNormal3dv", "glNormal"),
  ("glNormal3fv", "glNormal"),
  ("glNormal3iv", "glNormal"),
  ("glNormal3sv", "glNormal"),
  ("glOrtho", "glOrtho"),
  ("glPassThrough", "glPassThrough"),
  ("glPixelMapfv", "glPixelMap"),
  ("glPixelMapuiv", "glPixelMap"),
  ("glPixelMapusv", "glPixelMap"),
  ("glPixelStoref", "glPixelStore"),
  ("glPixelStorei", "glPixelStore"),
  ("glPixelTransferf", "glPixelTransfer"),
  ("glPixelTransferi", "glPixelTransfer"),
  ("glPixelZoom", "glPixelZoom"),
  ("glPointParameterf", "glPointParameter"),
  ("glPointParameteri", "glPointParameter"),
  ("glPointParameterfv", "glPointParameter"),
  ("glPointParameteriv", "glPointParameter"),
  ("glPointSize", "glPointSize"),
  ("glPolygonMode", "glPolygonMode"),
  ("glPolygonOffset", "glPolygonOffset"),
  ("glPolygonStipple", "glPolygonStipple"),
  ("glPrioritizeTextures", "glPrioritizeTextures"),
  ("glPushAttrib", "glPushAttrib"),
  ("glPopAttrib", "glPushAttrib"),
  ("glPushClientAttrib", "glPushClientAttrib"),
  ("glPopClientAttrib", "glPushClientAttrib"),
  ("glPushMatrix", "glPushMatrix"),
  ("glPopMatrix", "glPushMatrix"),
  ("glPushName", "glPushName"),
  ("glPopName", "glPushName"),
  ("glRasterPos2s", "glRasterPos"),
  ("glRasterPos2i", "glRasterPos"),
  ("glRasterPos2f", "glRasterPos"),
  ("glRasterPos2d", "glRasterPos"),
  ("glRasterPos3s", "glRasterPos"),
  ("glRasterPos3i", "glRasterPos"),
  ("glRasterPos3f", "glRasterPos"),
  ("glRasterPos3d", "glRasterPos"),
  ("glRasterPos4s", "glRasterPos"),
  ("glRasterPos4i", "glRasterPos"),
  ("glRasterPos4f", "glRasterPos"),
  ("glRasterPos4d", "glRasterPos"),
  ("glRasterPos2sv", "glRasterPos"),
  ("glRasterPos2iv", "glRasterPos"),
  ("glRasterPos2fv", "glRasterPos"),
  ("glRasterPos2dv", "glRasterPos"),
  ("glRasterPos3sv", "glRasterPos"),
  ("glRasterPos3iv", "glRasterPos"),
  ("glRasterPos3fv", "glRasterPos"),
  ("glRasterPos3dv", "glRasterPos"),
  ("glRasterPos4sv", "glRasterPos"),
  ("glRasterPos4iv", "glRasterPos"),
  ("glRasterPos4fv", "glRasterPos"),
  ("glRasterPos4dv", "glRasterPos"),
  ("glReadBuffer", "glReadBuffer"),
  ("glReadPixels", "glReadPixels"),
  ("glRectd", "glRect"),
  ("glRectf", "glRect"),
  ("glRecti", "glRect"),
  ("glRects", "glRect"),
  ("glRectdv", "glRect"),
  ("glRectfv", "glRect"),
  ("glRectiv", "glRect"),
  ("glRectsv", "glRect"),
  ("glRenderMode", "glRenderMode"),
  ("glResetHistogram", "glResetHistogram"),
  ("glResetMinmax", "glResetMinmax"),
  ("glRotated", "glRotate"),
  ("glRotatef", "glRotate"),
  ("glSampleCoverage", "glSampleCoverage"),
  ("glScaled", "glScale"),
  ("glScalef", "glScale"),
  ("glScissor", "glScissor"),
  ("glSecondaryColorPointer", "glSecondaryColorPointer"),
  ("glSecondaryColor3b", "glSecondaryColor"),
  ("glSecondaryColor3s", "glSecondaryColor"),
  ("glSecondaryColor3i", "glSecondaryColor"),
  ("glSecondaryColor3f", "glSecondaryColor"),
  ("glSecondaryColor3d", "glSecondaryColor"),
  ("glSecondaryColor3ub", "glSecondaryColor"),
  ("glSecondaryColor3us", "glSecondaryColor"),
  ("glSecondaryColor3ui", "glSecondaryColor"),
  ("glSecondaryColor3bv", "glSecondaryColor"),
  ("glSecondaryColor3sv", "glSecondaryColor"),
  ("glSecondaryColor3iv", "glSecondaryColor"),
  ("glSecondaryColor3fv", "glSecondaryColor"),
  ("glSecondaryColor3dv", "glSecondaryColor"),
  ("glSecondaryColor3ubv", "glSecondaryColor"),
  ("glSecondaryColor3usv", "glSecondaryColor"),
  ("glSecondaryColor3uiv", "glSecondaryColor"),
  ("glSelectBuffer", "glSelectBuffer"),
  ("glSeparableFilter2D", "glSeparableFilter2D"),
  ("glShadeModel", "glShadeModel"),
  ("glShaderSource", "glShaderSource"),
  ("glStencilFuncSeparate", "glStencilFuncSeparate"),
  ("glStencilFunc", "glStencilFunc"),
  ("glStencilMaskSeparate", "glStencilMaskSeparate"),
  ("glStencilMask", "glStencilMask"),
  ("glStencilOpSeparate", "glStencilOpSeparate"),
  ("glStencilOp", "glStencilOp"),
  ("glTexCoordPointer", "glTexCoordPointer"),
  ("glTexCoord1s", "glTexCoord"),
  ("glTexCoord1i", "glTexCoord"),
  ("glTexCoord1f", "glTexCoord"),
  ("glTexCoord1d", "glTexCoord"),
  ("glTexCoord2s", "glTexCoord"),
  ("glTexCoord2i", "glTexCoord"),
  ("glTexCoord2f", "glTexCoord"),
  ("glTexCoord2d", "glTexCoord"),
  ("glTexCoord3s", "glTexCoord"),
  ("glTexCoord3i", "glTexCoord"),
  ("glTexCoord3f", "glTexCoord"),
  ("glTexCoord3d", "glTexCoord"),
  ("glTexCoord4s", "glTexCoord"),
  ("glTexCoord4i", "glTexCoord"),
  ("glTexCoord4f", "glTexCoord"),
  ("glTexCoord4d", "glTexCoord"),
  ("glTexCoord1sv", "glTexCoord"),
  ("glTexCoord1iv", "glTexCoord"),
  ("glTexCoord1fv", "glTexCoord"),
  ("glTexCoord1dv", "glTexCoord"),
  ("glTexCoord2sv", "glTexCoord"),
  ("glTexCoord2iv", "glTexCoord"),
  ("glTexCoord2fv", "glTexCoord"),
  ("glTexCoord2dv", "glTexCoord"),
  ("glTexCoord3sv", "glTexCoord"),
  ("glTexCoord3iv", "glTexCoord"),
  ("glTexCoord3fv", "glTexCoord"),
  ("glTexCoord3dv", "glTexCoord"),
  ("glTexCoord4sv", "glTexCoord"),
  ("glTexCoord4iv", "glTexCoord"),
  ("glTexCoord4fv", "glTexCoord"),
  ("glTexCoord4dv", "glTexCoord"),
  ("glTexEnvf", "glTexEnv"),
  ("glTexEnvi", "glTexEnv"),
  ("glTexEnvfv", "glTexEnv"),
  ("glTexEnviv", "glTexEnv"),
  ("glTexGeni", "glTexGen"),
  ("glTexGenf", "glTexGen"),
  ("glTexGend", "glTexGen"),
  ("glTexGeniv", "glTexGen"),
  ("glTexGenfv", "glTexGen"),
  ("glTexGendv", "glTexGen"),
  ("glTexImage1D", "glTexImage1D"),
  ("glTexImage2D", "glTexImage2D"),
  ("glTexImage3D", "glTexImage3D"),
  ("glTexParameterf", "glTexParameter"),
  ("glTexParameteri", "glTexParameter"),
  ("glTexParameterfv", "glTexParameter"),
  ("glTexParameteriv", "glTexParameter"),
  ("glTexSubImage1D", "glTexSubImage1D"),
  ("glTexSubImage2D", "glTexSubImage2D"),
  ("glTexSubImage3D", "glTexSubImage3D"),
  ("glTranslated", "glTranslate"),
  ("glTranslatef", "glTranslate"),
  ("gluBeginCurve", "gluBeginCurve"),
  ("gluEndCurve", "gluBeginCurve"),
  ("gluBeginPolygon", "gluBeginPolygon"),
  ("gluEndPolygon", "gluBeginPolygon"),
  ("gluBeginSurface", "gluBeginSurface"),
  ("gluEndSurface", "gluBeginSurface"),
  ("gluBeginTrim", "gluBeginTrim"),
  ("gluEndTrim", "gluBeginTrim"),
  ("gluBuild1DMipmapLevels", "gluBuild1DMipmapLevels"),
  ("gluBuild1DMipmaps", "gluBuild1DMipmaps"),
  ("gluBuild2DMipmapLevels", "gluBuild2DMipmapLevels"),
  ("gluBuild2DMipmaps", "gluBuild2DMipmaps"),
  ("gluBuild3DMipmapLevels", "gluBuild3DMipmapLevels"),
  ("gluBuild3DMipmaps", "gluBuild3DMipmaps"),
  ("gluCheckExtension", "gluCheckExtension"),
  ("gluCylinder", "gluCylinder"),
  ("gluDeleteNurbsRenderer", "gluDeleteNurbsRenderer"),
  ("gluDeleteQuadric", "gluDeleteQuadric"),
  ("gluDeleteTess", "gluDeleteTess"),
  ("gluDisk", "gluDisk"),
  ("gluErrorString", "gluErrorString"),
  ("gluGetNurbsProperty", "gluGetNurbsProperty"),
  ("gluGetString", "gluGetString"),
  ("gluGetTessProperty", "gluGetTessProperty"),
  ("gluLoadSamplingMatrices", "gluLoadSamplingMatrices"),
  ("gluLookAt", "gluLookAt"),
  ("gluNewNurbsRenderer", "gluNewNurbsRenderer"),
  ("gluNewQuadric", "gluNewQuadric"),
  ("gluNewTess", "gluNewTess"),
  ("gluNextContour", "gluNextContour"),
  ("glUniform1f", "glUniform"),
  ("glUniform2f", "glUniform"),
  ("glUniform3f", "glUniform"),
  ("glUniform4f", "glUniform"),
  ("glUniform1i", "glUniform"),
  ("glUniform2i", "glUniform"),
  ("glUniform3i", "glUniform"),
  ("glUniform4i", "glUniform"),
  ("glUniform1fv", "glUniform"),
  ("glUniform2fv", "glUniform"),
  ("glUniform3fv", "glUniform"),
  ("glUniform4fv", "glUniform"),
  ("glUniform1iv", "glUniform"),
  ("glUniform2iv", "glUniform"),
  ("glUniform3iv", "glUniform"),
  ("glUniform4iv", "glUniform"),
  ("glUniformMatrix2fv", "glUniform"),
  ("glUniformMatrix3fv", "glUniform"),
  ("glUniformMatrix4fv", "glUniform"),
  ("glUniformMatrix2x3fv", "glUniform"),
  ("glUniformMatrix3x2fv", "glUniform"),
  ("glUniformMatrix2x4fv", "glUniform"),
  ("glUniformMatrix4x2fv", "glUniform"),
  ("glUniformMatrix3x4fv", "glUniform"),
  ("glUniformMatrix4x3fv", "glUniform"),
  ("gluNurbsCallbackDataEXT", "gluNurbsCallbackDataEXT"),
  ("gluNurbsCallbackData", "gluNurbsCallbackData"),
  ("gluNurbsCallback", "gluNurbsCallback"),
  ("gluNurbsCurve", "gluNurbsCurve"),
  ("gluNurbsProperty", "gluNurbsProperty"),
  ("gluNurbsSurface", "gluNurbsSurface"),
  ("gluOrtho2D", "gluOrtho2D"),
  ("gluPartialDisk", "gluPartialDisk"),
  ("gluPerspective", "gluPerspective"),
  ("gluPickMatrix", "gluPickMatrix"),
  ("gluProject", "gluProject"),
  ("gluPwlCurve", "gluPwlCurve"),
  ("gluQuadricCallback", "gluQuadricCallback"),
  ("gluQuadricDrawStyle", "gluQuadricDrawStyle"),
  ("gluQuadricNormals", "gluQuadricNormals"),
  ("gluQuadricOrientation", "gluQuadricOrientation"),
  ("gluQuadricTexture", "gluQuadricTexture"),
  ("gluScaleImage", "gluScaleImage"),
  ("glUseProgram", "glUseProgram"),
  ("gluSphere", "gluSphere"),
  ("gluTessBeginContour", "gluTessBeginContour"),
  ("gluTessEndContour", "gluTessBeginContour"),
  ("gluTessBeginPolygon", "gluTessBeginPolygon"),
  ("gluTessCallback", "gluTessCallback"),
  ("gluTessEndPolygon", "gluTessEndPolygon"),
  ("gluTessNormal", "gluTessNormal"),
  ("gluTessProperty", "gluTessProperty"),
  ("gluTessVertex", "gluTessVertex"),
  ("gluUnProject4", "gluUnProject4"),
  ("gluUnProject", "gluUnProject"),
  ("glValidateProgram", "glValidateProgram"),
  ("glVertexAttribPointer", "glVertexAttribPointer"),
  ("glVertexAttrib1f", "glVertexAttrib"),
  ("glVertexAttrib1s", "glVertexAttrib"),
  ("glVertexAttrib1d", "glVertexAttrib"),
  ("glVertexAttrib2f", "glVertexAttrib"),
  ("glVertexAttrib2s", "glVertexAttrib"),
  ("glVertexAttrib2d", "glVertexAttrib"),
  ("glVertexAttrib3f", "glVertexAttrib"),
  ("glVertexAttrib3s", "glVertexAttrib"),
  ("glVertexAttrib3d", "glVertexAttrib"),
  ("glVertexAttrib4f", "glVertexAttrib"),
  ("glVertexAttrib4s", "glVertexAttrib"),
  ("glVertexAttrib4d", "glVertexAttrib"),
  ("glVertexAttrib4Nub", "glVertexAttrib"),
  ("glVertexAttrib1fv", "glVertexAttrib"),
  ("glVertexAttrib1sv", "glVertexAttrib"),
  ("glVertexAttrib1dv", "glVertexAttrib"),
  ("glVertexAttrib2fv", "glVertexAttrib"),
  ("glVertexAttrib2sv", "glVertexAttrib"),
  ("glVertexAttrib2dv", "glVertexAttrib"),
  ("glVertexAttrib3fv", "glVertexAttrib"),
  ("glVertexAttrib3sv", "glVertexAttrib"),
  ("glVertexAttrib3dv", "glVertexAttrib"),
  ("glVertexAttrib4fv", "glVertexAttrib"),
  ("glVertexAttrib4sv", "glVertexAttrib"),
  ("glVertexAttrib4dv", "glVertexAttrib"),
  ("glVertexAttrib4iv", "glVertexAttrib"),
  ("glVertexAttrib4bv", "glVertexAttrib"),
  ("glVertexAttrib4ubv", "glVertexAttrib"),
  ("glVertexAttrib4usv", "glVertexAttrib"),
  ("glVertexAttrib4uiv", "glVertexAttrib"),
  ("glVertexAttrib4Nbv", "glVertexAttrib"),
  ("glVertexAttrib4Nsv", "glVertexAttrib"),
  ("glVertexAttrib4Niv", "glVertexAttrib"),
  ("glVertexAttrib4Nubv", "glVertexAttrib"),
  ("glVertexAttrib4Nusv", "glVertexAttrib"),
  ("glVertexAttrib4Nuiv", "glVertexAttrib"),
  ("glVertexPointer", "glVertexPointer"),
  ("glVertex2s", "glVertex"),
  ("glVertex2i", "glVertex"),
  ("glVertex2f", "glVertex"),
  ("glVertex2d", "glVertex"),
  ("glVertex3s", "glVertex"),
  ("glVertex3i", "glVertex"),
  ("glVertex3f", "glVertex"),
  ("glVertex3d", "glVertex"),
  ("glVertex4s", "glVertex"),
  ("glVertex4i", "glVertex"),
  ("glVertex4f", "glVertex"),
  ("glVertex4d", "glVertex"),
  ("glVertex2sv", "glVertex"),
  ("glVertex2iv", "glVertex"),
  ("glVertex2fv", "glVertex"),
  ("glVertex2dv", "glVertex"),
  ("glVertex3sv", "glVertex"),
  ("glVertex3iv", "glVertex"),
  ("glVertex3fv", "glVertex"),
  ("glVertex3dv", "glVertex"),
  ("glVertex4sv", "glVertex"),
  ("glVertex4iv", "glVertex"),
  ("glVertex4fv", "glVertex"),
  ("glVertex4dv", "glVertex"),
  ("glViewport", "glViewport"),
  ("glWindowPos2s", "glWindowPos"),
  ("glWindowPos2i", "glWindowPos"),
  ("glWindowPos2f", "glWindowPos"),
  ("glWindowPos2d", "glWindowPos"),
  ("glWindowPos3s", "glWindowPos"),
  ("glWindowPos3i", "glWindowPos"),
  ("glWindowPos3f", "glWindowPos"),
  ("glWindowPos3d", "glWindowPos"),
  ("glWindowPos2sv", "glWindowPos"),
  ("glWindowPos2iv", "glWindowPos"),
  ("glWindowPos2fv", "glWindowPos"),
  ("glWindowPos2dv", "glWindowPos"),
  ("glWindowPos3sv", "glWindowPos"),
  ("glWindowPos3iv", "glWindowPos"),
  ("glWindowPos3fv", "glWindowPos"),
  ("glWindowPos3dv", "glWindowPos")
  ]

assocsGLX1 :: [(ManPageKey, [(URL, Label)])]
assocsGLX1 =
  entriesFor "glx" "GLX 1.x" "https://www.opengl.org/sdk/docs/man2/xhtml/" ".xml" [
  ("glXChooseFBConfig", "glXChooseFBConfig"),
  ("glXChooseVisual", "glXChooseVisual"),
  ("glXCopyContext", "glXCopyContext"),
  ("glXCreateContext", "glXCreateContext"),
  ("glXCreateGLXPixmap", "glXCreateGLXPixmap"),
  ("glXCreateNewContext", "glXCreateNewContext"),
  ("glXCreatePbuffer", "glXCreatePbuffer"),
  ("glXCreatePixmap", "glXCreatePixmap"),
  ("glXCreateWindow", "glXCreateWindow"),
  ("glXDestroyContext", "glXDestroyContext"),
  ("glXDestroyGLXPixmap", "glXDestroyGLXPixmap"),
  ("glXDestroyPbuffer", "glXDestroyPbuffer"),
  ("glXDestroyPixmap", "glXDestroyPixmap"),
  ("glXDestroyWindow", "glXDestroyWindow"),
  ("glXFreeContextEXT", "glXFreeContextEXT"),
  ("glXGetClientString", "glXGetClientString"),
  ("glXGetConfig", "glXGetConfig"),
  ("glXGetContextIDEXT", "glXGetContextIDEXT"),
  ("glXGetCurrentContext", "glXGetCurrentContext"),
  ("glXGetCurrentDisplay", "glXGetCurrentDisplay"),
  ("glXGetCurrentDrawable", "glXGetCurrentDrawable"),
  ("glXGetCurrentReadDrawable", "glXGetCurrentReadDrawable"),
  ("glXGetFBConfigAttrib", "glXGetFBConfigAttrib"),
  ("glXGetFBConfigs", "glXGetFBConfigs"),
  ("glXGetProcAddress", "glXGetProcAddress"),
  ("glXGetSelectedEvent", "glXGetSelectedEvent"),
  ("glXGetVisualFromFBConfig", "glXGetVisualFromFBConfig"),
  ("glXImportContextEXT", "glXImportContextEXT"),
  ("glXIsDirect", "glXIsDirect"),
  ("glXMakeContextCurrent", "glXMakeContextCurrent"),
  ("glXMakeCurrent", "glXMakeCurrent"),
  ("glXQueryContextInfoEXT", "glXQueryContextInfoEXT"),
  ("glXQueryContext", "glXQueryContext"),
  ("glXQueryDrawable", "glXQueryDrawable"),
  ("glXQueryExtensionsString", "glXQueryExtensionsString"),
  ("glXQueryExtension", "glXQueryExtension"),
  ("glXQueryServerString", "glXQueryServerString"),
  ("glXQueryVersion", "glXQueryVersion"),
  ("glXSelectEvent", "glXSelectEvent"),
  ("glXSwapBuffers", "glXSwapBuffers"),
  ("glXUseXFont", "glXUseXFont"),
  ("glXWaitGL", "glXWaitGL"),
  ("glXWaitX", "glXWaitX")
  ]

assocsGL3 :: [(ManPageKey, [(URL, Label)])]
assocsGL3 =
  entriesFor "gl" "OpenGL 3.x" "https://www.opengl.org/sdk/docs/man3/xhtml/" ".xml" [
  ("glActiveTexture", "glActiveTexture"),
  ("glAttachShader", "glAttachShader"),
  ("glBeginConditionalRender", "glBeginConditionalRender"),
  ("glEndConditionalRender", "glBeginConditionalRender"),
  ("glBeginQuery", "glBeginQuery"),
  ("glEndQuery", "glBeginQuery"),
  ("glBeginTransformFeedback", "glBeginTransformFeedback"),
  ("glEndTransformFeedback", "glBeginTransformFeedback"),
  ("glBindAttribLocation", "glBindAttribLocation"),
  ("glBindBufferBase", "glBindBufferBase"),
  ("glBindBufferRange", "glBindBufferRange"),
  ("glBindBuffer", "glBindBuffer"),
  ("glBindFragDataLocationIndexed", "glBindFragDataLocationIndexed"),
  ("glBindFragDataLocation", "glBindFragDataLocation"),
  ("glBindFramebuffer", "glBindFramebuffer"),
  ("glBindRenderbuffer", "glBindRenderbuffer"),
  ("glBindSampler", "glBindSampler"),
  ("glBindTexture", "glBindTexture"),
  ("glBindVertexArray", "glBindVertexArray"),
  ("glBlendColor", "glBlendColor"),
  ("glBlendEquationSeparate", "glBlendEquationSeparate"),
  ("glBlendEquation", "glBlendEquation"),
  ("glBlendFuncSeparate", "glBlendFuncSeparate"),
  ("glBlendFunc", "glBlendFunc"),
  ("glBlitFramebuffer", "glBlitFramebuffer"),
  ("glBufferData", "glBufferData"),
  ("glBufferSubData", "glBufferSubData"),
  ("glCheckFramebufferStatus", "glCheckFramebufferStatus"),
  ("glClampColor", "glClampColor"),
  ("glClearBufferiv", "glClearBuffer"),
  ("glClearBufferuiv", "glClearBuffer"),
  ("glClearBufferfv", "glClearBuffer"),
  ("glClearBufferfi", "glClearBuffer"),
  ("glClearColor", "glClearColor"),
  ("glClearDepth", "glClearDepth"),
  ("glClearStencil", "glClearStencil"),
  ("glClear", "glClear"),
  ("glClientWaitSync", "glClientWaitSync"),
  ("glColorMask", "glColorMask"),
  ("glColorMaski", "glColorMask"),
  ("glCompileShader", "glCompileShader"),
  ("glCompressedTexImage1D", "glCompressedTexImage1D"),
  ("glCompressedTexImage2D", "glCompressedTexImage2D"),
  ("glCompressedTexImage3D", "glCompressedTexImage3D"),
  ("glCompressedTexSubImage1D", "glCompressedTexSubImage1D"),
  ("glCompressedTexSubImage2D", "glCompressedTexSubImage2D"),
  ("glCompressedTexSubImage3D", "glCompressedTexSubImage3D"),
  ("glCopyBufferSubData", "glCopyBufferSubData"),
  ("glCopyTexImage1D", "glCopyTexImage1D"),
  ("glCopyTexImage2D", "glCopyTexImage2D"),
  ("glCopyTexSubImage1D", "glCopyTexSubImage1D"),
  ("glCopyTexSubImage2D", "glCopyTexSubImage2D"),
  ("glCopyTexSubImage3D", "glCopyTexSubImage3D"),
  ("glCreateProgram", "glCreateProgram"),
  ("glCreateShader", "glCreateShader"),
  ("glCullFace", "glCullFace"),
  ("glDeleteBuffers", "glDeleteBuffers"),
  ("glDeleteFramebuffers", "glDeleteFramebuffers"),
  ("glDeleteProgram", "glDeleteProgram"),
  ("glDeleteQueries", "glDeleteQueries"),
  ("glDeleteRenderbuffers", "glDeleteRenderbuffers"),
  ("glDeleteSamplers", "glDeleteSamplers"),
  ("glDeleteShader", "glDeleteShader"),
  ("glDeleteSync", "glDeleteSync"),
  ("glDeleteTextures", "glDeleteTextures"),
  ("glDeleteVertexArrays", "glDeleteVertexArrays"),
  ("glDepthFunc", "glDepthFunc"),
  ("glDepthMask", "glDepthMask"),
  ("glDepthRange", "glDepthRange"),
  ("glDetachShader", "glDetachShader"),
  ("glDrawArraysInstanced", "glDrawArraysInstanced"),
  ("glDrawArrays", "glDrawArrays"),
  ("glDrawBuffers", "glDrawBuffers"),
  ("glDrawBuffer", "glDrawBuffer"),
  ("glDrawElementsBaseVertex", "glDrawElementsBaseVertex"),
  ("glDrawElementsInstancedBaseVertex", "glDrawElementsInstancedBaseVertex"),
  ("glDrawElementsInstanced", "glDrawElementsInstanced"),
  ("glDrawElements", "glDrawElements"),
  ("glDrawRangeElementsBaseVertex", "glDrawRangeElementsBaseVertex"),
  ("glDrawRangeElements", "glDrawRangeElements"),
  ("glEnableVertexAttribArray", "glEnableVertexAttribArray"),
  ("glDisableVertexAttribArray", "glEnableVertexAttribArray"),
  ("glEnable", "glEnable"),
  ("glDisable", "glEnable"),
  ("glEnablei", "glEnable"),
  ("glDisablei", "glEnable"),
  ("glFenceSync", "glFenceSync"),
  ("glFinish", "glFinish"),
  ("glFlushMappedBufferRange", "glFlushMappedBufferRange"),
  ("glFlush", "glFlush"),
  ("glFramebufferRenderbuffer", "glFramebufferRenderbuffer"),
  ("glFramebufferTextureLayer", "glFramebufferTextureLayer"),
  ("glFramebufferTexture", "glFramebufferTexture"),
  ("glFramebufferTexture1D", "glFramebufferTexture"),
  ("glFramebufferTexture2D", "glFramebufferTexture"),
  ("glFramebufferTexture3D", "glFramebufferTexture"),
  ("glFrontFace", "glFrontFace"),
  ("glGenBuffers", "glGenBuffers"),
  ("glGenerateMipmap", "glGenerateMipmap"),
  ("glGenFramebuffers", "glGenFramebuffers"),
  ("glGenQueries", "glGenQueries"),
  ("glGenRenderbuffers", "glGenRenderbuffers"),
  ("glGenSamplers", "glGenSamplers"),
  ("glGenTextures", "glGenTextures"),
  ("glGenVertexArrays", "glGenVertexArrays"),
  ("glGetActiveAttrib", "glGetActiveAttrib"),
  ("glGetActiveUniformBlockName", "glGetActiveUniformBlockName"),
  ("glGetActiveUniformBlockiv", "glGetActiveUniformBlock"),
  ("glGetActiveUniformName", "glGetActiveUniformName"),
  ("glGetActiveUniformsiv", "glGetActiveUniformsiv"),
  ("glGetActiveUniform", "glGetActiveUniform"),
  ("glGetAttachedShaders", "glGetAttachedShaders"),
  ("glGetAttribLocation", "glGetAttribLocation"),
  ("glGetBufferParameteriv", "glGetBufferParameter"),
  ("glGetBufferParameteri64v", "glGetBufferParameter"),
  ("glGetBufferPointerv", "glGetBufferPointerv"),
  ("glGetBufferSubData", "glGetBufferSubData"),
  ("glGetCompressedTexImage", "glGetCompressedTexImage"),
  ("glGetError", "glGetError"),
  ("glGetFragDataIndex", "glGetFragDataIndex"),
  ("glGetFragDataLocation", "glGetFragDataLocation"),
  ("glGetFramebufferAttachmentParameteriv", "glGetFramebufferAttachmentParameter"),
  ("glGetMultisamplefv", "glGetMultisample"),
  ("glGetProgramInfoLog", "glGetProgramInfoLog"),
  ("glGetProgramiv", "glGetProgram"),
  ("glGetQueryiv", "glGetQueryiv"),
  ("glGetQueryObjectiv", "glGetQueryObject"),
  ("glGetQueryObjectuiv", "glGetQueryObject"),
  ("glGetQueryObjecti64v", "glGetQueryObject"),
  ("glGetQueryObjectui64v", "glGetQueryObject"),
  ("glGetRenderbufferParameteriv", "glGetRenderbufferParameter"),
  ("glGetSamplerParameterfv", "glGetSamplerParameter"),
  ("glGetSamplerParameteriv", "glGetSamplerParameter"),
  ("glGetSamplerParameterIiv", "glGetSamplerParameter"),
  ("glGetSamplerParameterIuiv", "glGetSamplerParameter"),
  ("glGetShaderInfoLog", "glGetShaderInfoLog"),
  ("glGetShaderSource", "glGetShaderSource"),
  ("glGetShaderiv", "glGetShader"),
  ("glGetString", "glGetString"),
  ("glGetStringi", "glGetString"),
  ("glGetSynciv", "glGetSync"),
  ("glGetTexImage", "glGetTexImage"),
  ("glGetTexLevelParameterfv", "glGetTexLevelParameter"),
  ("glGetTexLevelParameteriv", "glGetTexLevelParameter"),
  ("glGetTexParameterfv", "glGetTexParameter"),
  ("glGetTexParameteriv", "glGetTexParameter"),
  ("glGetTexParameterIiv", "glGetTexParameter"),
  ("glGetTexParameterIuiv", "glGetTexParameter"),
  ("glGetTransformFeedbackVarying", "glGetTransformFeedbackVarying"),
  ("glGetUniformBlockIndex", "glGetUniformBlockIndex"),
  ("glGetUniformIndices", "glGetUniformIndices"),
  ("glGetUniformLocation", "glGetUniformLocation"),
  ("glGetUniformfv", "glGetUniform"),
  ("glGetUniformiv", "glGetUniform"),
  ("glGetUniformuiv", "glGetUniform"),
  ("glGetVertexAttribPointerv", "glGetVertexAttribPointerv"),
  ("glGetVertexAttribdv", "glGetVertexAttrib"),
  ("glGetVertexAttribfv", "glGetVertexAttrib"),
  ("glGetVertexAttribiv", "glGetVertexAttrib"),
  ("glGetVertexAttribIiv", "glGetVertexAttrib"),
  ("glGetVertexAttribIuiv", "glGetVertexAttrib"),
  ("glGetBooleanv", "glGet"),
  ("glGetDoublev", "glGet"),
  ("glGetFloatv", "glGet"),
  ("glGetIntegerv", "glGet"),
  ("glGetInteger64v", "glGet"),
  ("glGetBooleani_v", "glGet"),
  ("glGetIntegeri_v", "glGet"),
  ("glGetInteger64i_v", "glGet"),
  ("glHint", "glHint"),
  ("glIsBuffer", "glIsBuffer"),
  ("glIsEnabled", "glIsEnabled"),
  ("glIsEnabledi", "glIsEnabled"),
  ("glIsFramebuffer", "glIsFramebuffer"),
  ("glIsProgram", "glIsProgram"),
  ("glIsQuery", "glIsQuery"),
  ("glIsRenderbuffer", "glIsRenderbuffer"),
  ("glIsSampler", "glIsSampler"),
  ("glIsShader", "glIsShader"),
  ("glIsSync", "glIsSync"),
  ("glIsTexture", "glIsTexture"),
  ("glIsVertexArray", "glIsVertexArray"),
  ("glLineWidth", "glLineWidth"),
  ("glLinkProgram", "glLinkProgram"),
  ("glLogicOp", "glLogicOp"),
  ("glMapBufferRange", "glMapBufferRange"),
  ("glMapBuffer", "glMapBuffer"),
  ("glUnmapBuffer", "glMapBuffer"),
  ("glMultiDrawArrays", "glMultiDrawArrays"),
  ("glMultiDrawElementsBaseVertex", "glMultiDrawElementsBaseVertex"),
  ("glMultiDrawElements", "glMultiDrawElements"),
  ("glPixelStoref", "glPixelStore"),
  ("glPixelStorei", "glPixelStore"),
  ("glPointParameterf", "glPointParameter"),
  ("glPointParameteri", "glPointParameter"),
  ("glPointParameterfv", "glPointParameter"),
  ("glPointParameteriv", "glPointParameter"),
  ("glPointSize", "glPointSize"),
  ("glPolygonMode", "glPolygonMode"),
  ("glPolygonOffset", "glPolygonOffset"),
  ("glPrimitiveRestartIndex", "glPrimitiveRestartIndex"),
  ("glProvokingVertex", "glProvokingVertex"),
  ("glQueryCounter", "glQueryCounter"),
  ("glReadBuffer", "glReadBuffer"),
  ("glReadPixels", "glReadPixels"),
  ("glRenderbufferStorageMultisample", "glRenderbufferStorageMultisample"),
  ("glRenderbufferStorage", "glRenderbufferStorage"),
  ("glSampleCoverage", "glSampleCoverage"),
  ("glSampleMaski", "glSampleMaski"),
  ("glSamplerParameterf", "glSamplerParameter"),
  ("glSamplerParameteri", "glSamplerParameter"),
  ("glSamplerParameterfv", "glSamplerParameter"),
  ("glSamplerParameteriv", "glSamplerParameter"),
  ("glSamplerParameterIiv", "glSamplerParameter"),
  ("glSamplerParameterIuiv", "glSamplerParameter"),
  ("glScissor", "glScissor"),
  ("glShaderSource", "glShaderSource"),
  ("glStencilFuncSeparate", "glStencilFuncSeparate"),
  ("glStencilFunc", "glStencilFunc"),
  ("glStencilMaskSeparate", "glStencilMaskSeparate"),
  ("glStencilMask", "glStencilMask"),
  ("glStencilOpSeparate", "glStencilOpSeparate"),
  ("glStencilOp", "glStencilOp"),
  ("glTexBuffer", "glTexBuffer"),
  ("glTexImage1D", "glTexImage1D"),
  ("glTexImage2DMultisample", "glTexImage2DMultisample"),
  ("glTexImage2D", "glTexImage2D"),
  ("glTexImage3DMultisample", "glTexImage3DMultisample"),
  ("glTexImage3D", "glTexImage3D"),
  ("glTexParameterf", "glTexParameter"),
  ("glTexParameteri", "glTexParameter"),
  ("glTexParameterfv", "glTexParameter"),
  ("glTexParameteriv", "glTexParameter"),
  ("glTexParameterIiv", "glTexParameter"),
  ("glTexParameterIuiv", "glTexParameter"),
  ("glTexSubImage1D", "glTexSubImage1D"),
  ("glTexSubImage2D", "glTexSubImage2D"),
  ("glTexSubImage3D", "glTexSubImage3D"),
  ("glTransformFeedbackVaryings", "glTransformFeedbackVaryings"),
  ("glUniformBlockBinding", "glUniformBlockBinding"),
  ("glUniform1f", "glUniform"),
  ("glUniform2f", "glUniform"),
  ("glUniform3f", "glUniform"),
  ("glUniform4f", "glUniform"),
  ("glUniform1i", "glUniform"),
  ("glUniform2i", "glUniform"),
  ("glUniform3i", "glUniform"),
  ("glUniform4i", "glUniform"),
  ("glUniform1ui", "glUniform"),
  ("glUniform2ui", "glUniform"),
  ("glUniform3ui", "glUniform"),
  ("glUniform4ui", "glUniform"),
  ("glUniform1fv", "glUniform"),
  ("glUniform2fv", "glUniform"),
  ("glUniform3fv", "glUniform"),
  ("glUniform4fv", "glUniform"),
  ("glUniform1iv", "glUniform"),
  ("glUniform2iv", "glUniform"),
  ("glUniform3iv", "glUniform"),
  ("glUniform4iv", "glUniform"),
  ("glUniform1uiv", "glUniform"),
  ("glUniform2uiv", "glUniform"),
  ("glUniform3uiv", "glUniform"),
  ("glUniform4uiv", "glUniform"),
  ("glUniformMatrix2fv", "glUniform"),
  ("glUniformMatrix3fv", "glUniform"),
  ("glUniformMatrix4fv", "glUniform"),
  ("glUniformMatrix2x3fv", "glUniform"),
  ("glUniformMatrix3x2fv", "glUniform"),
  ("glUniformMatrix2x4fv", "glUniform"),
  ("glUniformMatrix4x2fv", "glUniform"),
  ("glUniformMatrix3x4fv", "glUniform"),
  ("glUniformMatrix4x3fv", "glUniform"),
  ("glUseProgram", "glUseProgram"),
  ("glValidateProgram", "glValidateProgram"),
  ("glVertexAttribDivisor", "glVertexAttribDivisor"),
  ("glVertexAttribPointer", "glVertexAttribPointer"),
  ("glVertexAttribIPointer", "glVertexAttribPointer"),
  ("glVertexAttrib1f", "glVertexAttrib"),
  ("glVertexAttrib1s", "glVertexAttrib"),
  ("glVertexAttrib1d", "glVertexAttrib"),
  ("glVertexAttribI1i", "glVertexAttrib"),
  ("glVertexAttribI1ui", "glVertexAttrib"),
  ("glVertexAttrib2f", "glVertexAttrib"),
  ("glVertexAttrib2s", "glVertexAttrib"),
  ("glVertexAttrib2d", "glVertexAttrib"),
  ("glVertexAttribI2i", "glVertexAttrib"),
  ("glVertexAttribI2ui", "glVertexAttrib"),
  ("glVertexAttrib3f", "glVertexAttrib"),
  ("glVertexAttrib3s", "glVertexAttrib"),
  ("glVertexAttrib3d", "glVertexAttrib"),
  ("glVertexAttribI3i", "glVertexAttrib"),
  ("glVertexAttribI3ui", "glVertexAttrib"),
  ("glVertexAttrib4f", "glVertexAttrib"),
  ("glVertexAttrib4s", "glVertexAttrib"),
  ("glVertexAttrib4d", "glVertexAttrib"),
  ("glVertexAttrib4Nub", "glVertexAttrib"),
  ("glVertexAttribI4i", "glVertexAttrib"),
  ("glVertexAttribI4ui", "glVertexAttrib"),
  ("glVertexAttrib1fv", "glVertexAttrib"),
  ("glVertexAttrib1sv", "glVertexAttrib"),
  ("glVertexAttrib1dv", "glVertexAttrib"),
  ("glVertexAttribI1iv", "glVertexAttrib"),
  ("glVertexAttribI1uiv", "glVertexAttrib"),
  ("glVertexAttrib2fv", "glVertexAttrib"),
  ("glVertexAttrib2sv", "glVertexAttrib"),
  ("glVertexAttrib2dv", "glVertexAttrib"),
  ("glVertexAttribI2iv", "glVertexAttrib"),
  ("glVertexAttribI2uiv", "glVertexAttrib"),
  ("glVertexAttrib3fv", "glVertexAttrib"),
  ("glVertexAttrib3sv", "glVertexAttrib"),
  ("glVertexAttrib3dv", "glVertexAttrib"),
  ("glVertexAttribI3iv", "glVertexAttrib"),
  ("glVertexAttribI3uiv", "glVertexAttrib"),
  ("glVertexAttrib4fv", "glVertexAttrib"),
  ("glVertexAttrib4sv", "glVertexAttrib"),
  ("glVertexAttrib4dv", "glVertexAttrib"),
  ("glVertexAttrib4iv", "glVertexAttrib"),
  ("glVertexAttrib4bv", "glVertexAttrib"),
  ("glVertexAttrib4ubv", "glVertexAttrib"),
  ("glVertexAttrib4usv", "glVertexAttrib"),
  ("glVertexAttrib4uiv", "glVertexAttrib"),
  ("glVertexAttrib4Nbv", "glVertexAttrib"),
  ("glVertexAttrib4Nsv", "glVertexAttrib"),
  ("glVertexAttrib4Niv", "glVertexAttrib"),
  ("glVertexAttrib4Nubv", "glVertexAttrib"),
  ("glVertexAttrib4Nusv", "glVertexAttrib"),
  ("glVertexAttrib4Nuiv", "glVertexAttrib"),
  ("glVertexAttribI4bv", "glVertexAttrib"),
  ("glVertexAttribI4ubv", "glVertexAttrib"),
  ("glVertexAttribI4sv", "glVertexAttrib"),
  ("glVertexAttribI4usv", "glVertexAttrib"),
  ("glVertexAttribI4iv", "glVertexAttrib"),
  ("glVertexAttribI4uiv", "glVertexAttrib"),
  ("glVertexAttribP1ui", "glVertexAttrib"),
  ("glVertexAttribP2ui", "glVertexAttrib"),
  ("glVertexAttribP3ui", "glVertexAttrib"),
  ("glVertexAttribP4ui", "glVertexAttrib"),
  ("glViewport", "glViewport"),
  ("glWaitSync", "glWaitSync")
  ]

assocsGL4 :: [(ManPageKey, [(URL, Label)])]
assocsGL4 =
  entriesFor "gl" "OpenGL 4.x" "https://www.opengl.org/sdk/docs/man4/html/" ".xhtml" [
  ("glActiveShaderProgram", "glActiveShaderProgram"),
  ("glActiveTexture", "glActiveTexture"),
  ("glAttachShader", "glAttachShader"),
  ("glBeginConditionalRender", "glBeginConditionalRender"),
  ("glEndConditionalRender", "glBeginConditionalRender"),
  ("glBeginQueryIndexed", "glBeginQueryIndexed"),
  ("glEndQueryIndexed", "glBeginQueryIndexed"),
  ("glBeginQuery", "glBeginQuery"),
  ("glEndQuery", "glBeginQuery"),
  ("glBeginTransformFeedback", "glBeginTransformFeedback"),
  ("glEndTransformFeedback", "glBeginTransformFeedback"),
  ("glBindAttribLocation", "glBindAttribLocation"),
  ("glBindBufferBase", "glBindBufferBase"),
  ("glBindBufferRange", "glBindBufferRange"),
  ("glBindBuffersBase", "glBindBuffersBase"),
  ("glBindBuffersRange", "glBindBuffersRange"),
  ("glBindBuffer", "glBindBuffer"),
  ("glBindFragDataLocationIndexed", "glBindFragDataLocationIndexed"),
  ("glBindFragDataLocation", "glBindFragDataLocation"),
  ("glBindFramebuffer", "glBindFramebuffer"),
  ("glBindImageTextures", "glBindImageTextures"),
  ("glBindImageTexture", "glBindImageTexture"),
  ("glBindProgramPipeline", "glBindProgramPipeline"),
  ("glBindRenderbuffer", "glBindRenderbuffer"),
  ("glBindSamplers", "glBindSamplers"),
  ("glBindSampler", "glBindSampler"),
  ("glBindTextures", "glBindTextures"),
  ("glBindTextureUnit", "glBindTextureUnit"),
  ("glBindTexture", "glBindTexture"),
  ("glBindTransformFeedback", "glBindTransformFeedback"),
  ("glBindVertexArray", "glBindVertexArray"),
  ("glBindVertexBuffers", "glBindVertexBuffers"),
  ("glVertexArrayVertexBuffers", "glBindVertexBuffers"),
  ("glBindVertexBuffer", "glBindVertexBuffer"),
  ("glVertexArrayVertexBuffer", "glBindVertexBuffer"),
  ("glBlendColor", "glBlendColor"),
  ("glBlendEquationSeparate", "glBlendEquationSeparate"),
  ("glBlendEquationSeparatei", "glBlendEquationSeparate"),
  ("glBlendEquation", "glBlendEquation"),
  ("glBlendEquationi", "glBlendEquation"),
  ("glBlendFuncSeparate", "glBlendFuncSeparate"),
  ("glBlendFuncSeparatei", "glBlendFuncSeparate"),
  ("glBlendFunc", "glBlendFunc"),
  ("glBlendFunci", "glBlendFunc"),
  ("glBlitFramebuffer", "glBlitFramebuffer"),
  ("glBlitNamedFramebuffer", "glBlitFramebuffer"),
  ("glBufferData", "glBufferData"),
  ("glNamedBufferData", "glBufferData"),
  ("glBufferStorage", "glBufferStorage"),
  ("glNamedBufferStorage", "glBufferStorage"),
  ("glBufferSubData", "glBufferSubData"),
  ("glNamedBufferSubData", "glBufferSubData"),
  ("glCheckFramebufferStatus", "glCheckFramebufferStatus"),
  ("glCheckNamedFramebufferStatus", "glCheckFramebufferStatus"),
  ("glClampColor", "glClampColor"),
  ("glClearBufferData", "glClearBufferData"),
  ("glClearNamedBufferData", "glClearBufferData"),
  ("glClearBufferSubData", "glClearBufferSubData"),
  ("glClearNamedBufferSubData", "glClearBufferSubData"),
  ("glClearBufferiv", "glClearBuffer"),
  ("glClearBufferuiv", "glClearBuffer"),
  ("glClearBufferfv", "glClearBuffer"),
  ("glClearBufferfi", "glClearBuffer"),
  ("glClearNamedFramebufferiv", "glClearBuffer"),
  ("glClearNamedFramebufferuiv", "glClearBuffer"),
  ("glClearNamedFramebufferfv", "glClearBuffer"),
  ("glClearNamedFramebufferfi", "glClearBuffer"),
  ("glClearColor", "glClearColor"),
  ("glClearDepth", "glClearDepth"),
  ("glClearDepthf", "glClearDepth"),
  ("glClearStencil", "glClearStencil"),
  ("glClearTexImage", "glClearTexImage"),
  ("glClearTexSubImage", "glClearTexSubImage"),
  ("glClear", "glClear"),
  ("glClientWaitSync", "glClientWaitSync"),
  ("glClipControl", "glClipControl"),
  ("glColorMask", "glColorMask"),
  ("glColorMaski", "glColorMask"),
  ("glCompileShader", "glCompileShader"),
  ("glCompressedTexImage1D", "glCompressedTexImage1D"),
  ("glCompressedTexImage2D", "glCompressedTexImage2D"),
  ("glCompressedTexImage3D", "glCompressedTexImage3D"),
  ("glCompressedTexSubImage1D", "glCompressedTexSubImage1D"),
  ("glCompressedTextureSubImage1D", "glCompressedTexSubImage1D"),
  ("glCompressedTexSubImage2D", "glCompressedTexSubImage2D"),
  ("glCompressedTextureSubImage2D", "glCompressedTexSubImage2D"),
  ("glCompressedTexSubImage3D", "glCompressedTexSubImage3D"),
  ("glCompressedTextureSubImage3D", "glCompressedTexSubImage3D"),
  ("glCopyBufferSubData", "glCopyBufferSubData"),
  ("glCopyNamedBufferSubData", "glCopyBufferSubData"),
  ("glCopyImageSubData", "glCopyImageSubData"),
  ("glCopyTexImage1D", "glCopyTexImage1D"),
  ("glCopyTexImage2D", "glCopyTexImage2D"),
  ("glCopyTexSubImage1D", "glCopyTexSubImage1D"),
  ("glCopyTextureSubImage1D", "glCopyTexSubImage1D"),
  ("glCopyTexSubImage2D", "glCopyTexSubImage2D"),
  ("glCopyTextureSubImage2D", "glCopyTexSubImage2D"),
  ("glCopyTexSubImage3D", "glCopyTexSubImage3D"),
  ("glCopyTextureSubImage3D", "glCopyTexSubImage3D"),
  ("glCreateBuffers", "glCreateBuffers"),
  ("glCreateFramebuffers", "glCreateFramebuffers"),
  ("glCreateProgramPipelines", "glCreateProgramPipelines"),
  ("glCreateProgram", "glCreateProgram"),
  ("glCreateQueries", "glCreateQueries"),
  ("glCreateRenderbuffers", "glCreateRenderbuffers"),
  ("glCreateSamplers", "glCreateSamplers"),
  ("glCreateShaderProgramv", "glCreateShaderProgram"),
  ("glCreateShader", "glCreateShader"),
  ("glCreateTextures", "glCreateTextures"),
  ("glCreateTransformFeedbacks", "glCreateTransformFeedbacks"),
  ("glCreateVertexArrays", "glCreateVertexArrays"),
  ("glCullFace", "glCullFace"),
  ("glDebugMessageCallback", "glDebugMessageCallback"),
  ("glDebugMessageControl", "glDebugMessageControl"),
  ("glDebugMessageInsert", "glDebugMessageInsert"),
  ("glDeleteBuffers", "glDeleteBuffers"),
  ("glDeleteFramebuffers", "glDeleteFramebuffers"),
  ("glDeleteProgramPipelines", "glDeleteProgramPipelines"),
  ("glDeleteProgram", "glDeleteProgram"),
  ("glDeleteQueries", "glDeleteQueries"),
  ("glDeleteRenderbuffers", "glDeleteRenderbuffers"),
  ("glDeleteSamplers", "glDeleteSamplers"),
  ("glDeleteShader", "glDeleteShader"),
  ("glDeleteSync", "glDeleteSync"),
  ("glDeleteTextures", "glDeleteTextures"),
  ("glDeleteTransformFeedbacks", "glDeleteTransformFeedbacks"),
  ("glDeleteVertexArrays", "glDeleteVertexArrays"),
  ("glDepthFunc", "glDepthFunc"),
  ("glDepthMask", "glDepthMask"),
  ("glDepthRangeArrayv", "glDepthRangeArray"),
  ("glDepthRangeIndexed", "glDepthRangeIndexed"),
  ("glDepthRange", "glDepthRange"),
  ("glDepthRangef", "glDepthRange"),
  ("glDetachShader", "glDetachShader"),
  ("glDispatchComputeIndirect", "glDispatchComputeIndirect"),
  ("glDispatchCompute", "glDispatchCompute"),
  ("glDrawArraysIndirect", "glDrawArraysIndirect"),
  ("glDrawArraysInstancedBaseInstance", "glDrawArraysInstancedBaseInstance"),
  ("glDrawArraysInstanced", "glDrawArraysInstanced"),
  ("glDrawArrays", "glDrawArrays"),
  ("glDrawBuffers", "glDrawBuffers"),
  ("glNamedFramebufferDrawBuffers", "glDrawBuffers"),
  ("glDrawBuffer", "glDrawBuffer"),
  ("glNamedFramebufferDrawBuffer", "glDrawBuffer"),
  ("glDrawElementsBaseVertex", "glDrawElementsBaseVertex"),
  ("glDrawElementsIndirect", "glDrawElementsIndirect"),
  ("glDrawElementsInstancedBaseInstance", "glDrawElementsInstancedBaseInstance"),
  ("glDrawElementsInstancedBaseVertexBaseInstance", "glDrawElementsInstancedBaseVertexBaseInstance"),
  ("glDrawElementsInstancedBaseVertex", "glDrawElementsInstancedBaseVertex"),
  ("glDrawElementsInstanced", "glDrawElementsInstanced"),
  ("glDrawElements", "glDrawElements"),
  ("glDrawRangeElementsBaseVertex", "glDrawRangeElementsBaseVertex"),
  ("glDrawRangeElements", "glDrawRangeElements"),
  ("glDrawTransformFeedbackInstanced", "glDrawTransformFeedbackInstanced"),
  ("glDrawTransformFeedbackStreamInstanced", "glDrawTransformFeedbackStreamInstanced"),
  ("glDrawTransformFeedbackStream", "glDrawTransformFeedbackStream"),
  ("glDrawTransformFeedback", "glDrawTransformFeedback"),
  ("glEnableVertexAttribArray", "glEnableVertexAttribArray"),
  ("glDisableVertexAttribArray", "glEnableVertexAttribArray"),
  ("glEnableVertexArrayAttrib", "glEnableVertexAttribArray"),
  ("glDisableVertexArrayAttrib", "glEnableVertexAttribArray"),
  ("glEnable", "glEnable"),
  ("glDisable", "glEnable"),
  ("glEnablei", "glEnable"),
  ("glDisablei", "glEnable"),
  ("glFenceSync", "glFenceSync"),
  ("glFinish", "glFinish"),
  ("glFlushMappedBufferRange", "glFlushMappedBufferRange"),
  ("glFlushMappedNamedBufferRange", "glFlushMappedBufferRange"),
  ("glFlush", "glFlush"),
  ("glFramebufferParameteri", "glFramebufferParameteri"),
  ("glNamedFramebufferParameteri", "glFramebufferParameteri"),
  ("glFramebufferRenderbuffer", "glFramebufferRenderbuffer"),
  ("glNamedFramebufferRenderbuffer", "glFramebufferRenderbuffer"),
  ("glFramebufferTextureLayer", "glFramebufferTextureLayer"),
  ("glNamedFramebufferTextureLayer", "glFramebufferTextureLayer"),
  ("glFramebufferTexture", "glFramebufferTexture"),
  ("glFramebufferTexture1D", "glFramebufferTexture"),
  ("glFramebufferTexture2D", "glFramebufferTexture"),
  ("glFramebufferTexture3D", "glFramebufferTexture"),
  ("glNamedFramebufferTexture", "glFramebufferTexture"),
  ("glFrontFace", "glFrontFace"),
  ("glGenBuffers", "glGenBuffers"),
  ("glGenerateMipmap", "glGenerateMipmap"),
  ("glGenerateTextureMipmap", "glGenerateMipmap"),
  ("glGenFramebuffers", "glGenFramebuffers"),
  ("glGenProgramPipelines", "glGenProgramPipelines"),
  ("glGenQueries", "glGenQueries"),
  ("glGenRenderbuffers", "glGenRenderbuffers"),
  ("glGenSamplers", "glGenSamplers"),
  ("glGenTextures", "glGenTextures"),
  ("glGenTransformFeedbacks", "glGenTransformFeedbacks"),
  ("glGenVertexArrays", "glGenVertexArrays"),
  ("glGetActiveAtomicCounterBufferiv", "glGetActiveAtomicCounterBufferiv"),
  ("glGetActiveAttrib", "glGetActiveAttrib"),
  ("glGetActiveSubroutineName", "glGetActiveSubroutineName"),
  ("glGetActiveSubroutineUniformName", "glGetActiveSubroutineUniformName"),
  ("glGetActiveSubroutineUniformiv", "glGetActiveSubroutineUniform"),
  ("glGetActiveUniformBlockName", "glGetActiveUniformBlockName"),
  ("glGetActiveUniformBlockiv", "glGetActiveUniformBlock"),
  ("glGetActiveUniformName", "glGetActiveUniformName"),
  ("glGetActiveUniformsiv", "glGetActiveUniformsiv"),
  ("glGetActiveUniform", "glGetActiveUniform"),
  ("glGetAttachedShaders", "glGetAttachedShaders"),
  ("glGetAttribLocation", "glGetAttribLocation"),
  ("glGetBufferParameteriv", "glGetBufferParameter"),
  ("glGetBufferParameteri64v", "glGetBufferParameter"),
  ("glGetNamedBufferParameteriv", "glGetBufferParameter"),
  ("glGetNamedBufferParameteri64v", "glGetBufferParameter"),
  ("glGetBufferPointerv", "glGetBufferPointerv"),
  ("glGetNamedBufferPointerv", "glGetBufferPointerv"),
  ("glGetBufferSubData", "glGetBufferSubData"),
  ("glGetNamedBufferSubData", "glGetBufferSubData"),
  ("glGetCompressedTexImage", "glGetCompressedTexImage"),
  ("glGetnCompressedTexImage", "glGetCompressedTexImage"),
  ("glGetCompressedTextureImage", "glGetCompressedTexImage"),
  ("glGetCompressedTextureSubImage", "glGetCompressedTextureSubImage"),
  ("glGetDebugMessageLog", "glGetDebugMessageLog"),
  ("glGetError", "glGetError"),
  ("glGetFragDataIndex", "glGetFragDataIndex"),
  ("glGetFragDataLocation", "glGetFragDataLocation"),
  ("glGetFramebufferAttachmentParameteriv", "glGetFramebufferAttachmentParameter"),
  ("glGetNamedFramebufferAttachmentParameteriv", "glGetFramebufferAttachmentParameter"),
  ("glGetFramebufferParameteriv", "glGetFramebufferParameter"),
  ("glGetNamedFramebufferParameteriv", "glGetFramebufferParameter"),
  ("glGetGraphicsResetStatus", "glGetGraphicsResetStatus"),
  ("glGetInternalformativ", "glGetInternalformat"),
  ("glGetInternalformati64v", "glGetInternalformat"),
  ("glGetMultisamplefv", "glGetMultisample"),
  ("glGetObjectLabel", "glGetObjectLabel"),
  ("glGetObjectPtrLabel", "glGetObjectPtrLabel"),
  ("glGetPointerv", "glGetPointerv"),
  ("glGetProgramBinary", "glGetProgramBinary"),
  ("glGetProgramInfoLog", "glGetProgramInfoLog"),
  ("glGetProgramInterfaceiv", "glGetProgramInterface"),
  ("glGetProgramPipelineInfoLog", "glGetProgramPipelineInfoLog"),
  ("glGetProgramPipelineiv", "glGetProgramPipeline"),
  ("glGetProgramResourceIndex", "glGetProgramResourceIndex"),
  ("glGetProgramResourceLocationIndex", "glGetProgramResourceLocationIndex"),
  ("glGetProgramResourceLocation", "glGetProgramResourceLocation"),
  ("glGetProgramResourceName", "glGetProgramResourceName"),
  ("glGetProgramResourceiv", "glGetProgramResource"),
  ("glGetProgramStageiv", "glGetProgramStage"),
  ("glGetProgramiv", "glGetProgram"),
  ("glGetQueryIndexediv", "glGetQueryIndexed"),
  ("glGetQueryiv", "glGetQueryiv"),
  ("glGetQueryObjectiv", "glGetQueryObject"),
  ("glGetQueryObjectuiv", "glGetQueryObject"),
  ("glGetQueryObjecti64v", "glGetQueryObject"),
  ("glGetQueryObjectui64v", "glGetQueryObject"),
  ("glGetRenderbufferParameteriv", "glGetRenderbufferParameter"),
  ("glGetNamedRenderbufferParameteriv", "glGetRenderbufferParameter"),
  ("glGetSamplerParameterfv", "glGetSamplerParameter"),
  ("glGetSamplerParameteriv", "glGetSamplerParameter"),
  ("glGetSamplerParameterIiv", "glGetSamplerParameter"),
  ("glGetSamplerParameterIuiv", "glGetSamplerParameter"),
  ("glGetShaderInfoLog", "glGetShaderInfoLog"),
  ("glGetShaderPrecisionFormat", "glGetShaderPrecisionFormat"),
  ("glGetShaderSource", "glGetShaderSource"),
  ("glGetShaderiv", "glGetShader"),
  ("glGetString", "glGetString"),
  ("glGetStringi", "glGetString"),
  ("glGetSubroutineIndex", "glGetSubroutineIndex"),
  ("glGetSubroutineUniformLocation", "glGetSubroutineUniformLocation"),
  ("glGetSynciv", "glGetSync"),
  ("glGetTexImage", "glGetTexImage"),
  ("glGetnTexImage", "glGetTexImage"),
  ("glGetTextureImage", "glGetTexImage"),
  ("glGetTexLevelParameterfv", "glGetTexLevelParameter"),
  ("glGetTexLevelParameteriv", "glGetTexLevelParameter"),
  ("glGetTextureLevelParameterfv", "glGetTexLevelParameter"),
  ("glGetTextureLevelParameteriv", "glGetTexLevelParameter"),
  ("glGetTexParameterfv", "glGetTexParameter"),
  ("glGetTexParameteriv", "glGetTexParameter"),
  ("glGetTexParameterIiv", "glGetTexParameter"),
  ("glGetTexParameterIuiv", "glGetTexParameter"),
  ("glGetTextureParameterfv", "glGetTexParameter"),
  ("glGetTextureParameteriv", "glGetTexParameter"),
  ("glGetTextureParameterIiv", "glGetTexParameter"),
  ("glGetTextureParameterIuiv", "glGetTexParameter"),
  ("glGetTextureSubImage", "glGetTextureSubImage"),
  ("glGetTransformFeedbackVarying", "glGetTransformFeedbackVarying"),
  ("glGetTransformFeedbackiv", "glGetTransformFeedback"),
  ("glGetTransformFeedbacki_v", "glGetTransformFeedback"),
  ("glGetTransformFeedbacki64_v", "glGetTransformFeedback"),
  ("glGetUniformBlockIndex", "glGetUniformBlockIndex"),
  ("glGetUniformIndices", "glGetUniformIndices"),
  ("glGetUniformLocation", "glGetUniformLocation"),
  ("glGetUniformSubroutineuiv", "glGetUniformSubroutine"),
  ("glGetUniformfv", "glGetUniform"),
  ("glGetUniformiv", "glGetUniform"),
  ("glGetUniformuiv", "glGetUniform"),
  ("glGetUniformdv", "glGetUniform"),
  ("glGetnUniformfv", "glGetUniform"),
  ("glGetnUniformiv", "glGetUniform"),
  ("glGetnUniformuiv", "glGetUniform"),
  ("glGetnUniformdv", "glGetUniform"),
  ("glGetVertexArrayIndexed64iv", "glGetVertexArrayIndexed"),
  ("glGetVertexArrayIndexediv", "glGetVertexArrayIndexed"),
  ("glGetVertexArrayiv", "glGetVertexArrayiv"),
  ("glGetVertexAttribPointerv", "glGetVertexAttribPointerv"),
  ("glGetVertexAttribdv", "glGetVertexAttrib"),
  ("glGetVertexAttribfv", "glGetVertexAttrib"),
  ("glGetVertexAttribiv", "glGetVertexAttrib"),
  ("glGetVertexAttribIiv", "glGetVertexAttrib"),
  ("glGetVertexAttribIuiv", "glGetVertexAttrib"),
  ("glGetVertexAttribLdv", "glGetVertexAttrib"),
  ("glGetBooleanv", "glGet"),
  ("glGetDoublev", "glGet"),
  ("glGetFloatv", "glGet"),
  ("glGetIntegerv", "glGet"),
  ("glGetInteger64v", "glGet"),
  ("glGetBooleani_v", "glGet"),
  ("glGetIntegeri_v", "glGet"),
  ("glGetFloati_v", "glGet"),
  ("glGetDoublei_v", "glGet"),
  ("glGetInteger64i_v", "glGet"),
  ("glHint", "glHint"),
  ("glInvalidateBufferData", "glInvalidateBufferData"),
  ("glInvalidateBufferSubData", "glInvalidateBufferSubData"),
  ("glInvalidateFramebuffer", "glInvalidateFramebuffer"),
  ("glInvalidateNamedFramebufferData", "glInvalidateFramebuffer"),
  ("glInvalidateSubFramebuffer", "glInvalidateSubFramebuffer"),
  ("glInvalidateNamedFramebufferSubData", "glInvalidateSubFramebuffer"),
  ("glInvalidateTexImage", "glInvalidateTexImage"),
  ("glInvalidateTexSubImage", "glInvalidateTexSubImage"),
  ("glIsBuffer", "glIsBuffer"),
  ("glIsEnabled", "glIsEnabled"),
  ("glIsEnabledi", "glIsEnabled"),
  ("glIsFramebuffer", "glIsFramebuffer"),
  ("glIsProgramPipeline", "glIsProgramPipeline"),
  ("glIsProgram", "glIsProgram"),
  ("glIsQuery", "glIsQuery"),
  ("glIsRenderbuffer", "glIsRenderbuffer"),
  ("glIsSampler", "glIsSampler"),
  ("glIsShader", "glIsShader"),
  ("glIsSync", "glIsSync"),
  ("glIsTexture", "glIsTexture"),
  ("glIsTransformFeedback", "glIsTransformFeedback"),
  ("glIsVertexArray", "glIsVertexArray"),
  ("glLineWidth", "glLineWidth"),
  ("glLinkProgram", "glLinkProgram"),
  ("glLogicOp", "glLogicOp"),
  ("glMapBufferRange", "glMapBufferRange"),
  ("glMapNamedBufferRange", "glMapBufferRange"),
  ("glMapBuffer", "glMapBuffer"),
  ("glMapNamedBuffer", "glMapBuffer"),
  ("glMemoryBarrier", "glMemoryBarrier"),
  ("glMemoryBarrierByRegion", "glMemoryBarrier"),
  ("glMinSampleShading", "glMinSampleShading"),
  ("glMultiDrawArraysIndirect", "glMultiDrawArraysIndirect"),
  ("glMultiDrawArrays", "glMultiDrawArrays"),
  ("glMultiDrawElementsBaseVertex", "glMultiDrawElementsBaseVertex"),
  ("glMultiDrawElementsIndirect", "glMultiDrawElementsIndirect"),
  ("glMultiDrawElements", "glMultiDrawElements"),
  ("glObjectLabel", "glObjectLabel"),
  ("glObjectPtrLabel", "glObjectPtrLabel"),
  ("glPatchParameteri", "glPatchParameter"),
  ("glPatchParameterfv", "glPatchParameter"),
  ("glPauseTransformFeedback", "glPauseTransformFeedback"),
  ("glPixelStoref", "glPixelStore"),
  ("glPixelStorei", "glPixelStore"),
  ("glPointParameterf", "glPointParameter"),
  ("glPointParameteri", "glPointParameter"),
  ("glPointParameterfv", "glPointParameter"),
  ("glPointParameteriv", "glPointParameter"),
  ("glPointSize", "glPointSize"),
  ("glPolygonMode", "glPolygonMode"),
  ("glPolygonOffset", "glPolygonOffset"),
  ("glPopDebugGroup", "glPopDebugGroup"),
  ("glPrimitiveRestartIndex", "glPrimitiveRestartIndex"),
  ("glProgramBinary", "glProgramBinary"),
  ("glProgramParameteri", "glProgramParameter"),
  ("glProgramUniform1f", "glProgramUniform"),
  ("glProgramUniform2f", "glProgramUniform"),
  ("glProgramUniform3f", "glProgramUniform"),
  ("glProgramUniform4f", "glProgramUniform"),
  ("glProgramUniform1i", "glProgramUniform"),
  ("glProgramUniform2i", "glProgramUniform"),
  ("glProgramUniform3i", "glProgramUniform"),
  ("glProgramUniform4i", "glProgramUniform"),
  ("glProgramUniform1ui", "glProgramUniform"),
  ("glProgramUniform2ui", "glProgramUniform"),
  ("glProgramUniform3ui", "glProgramUniform"),
  ("glProgramUniform4ui", "glProgramUniform"),
  ("glProgramUniform1fv", "glProgramUniform"),
  ("glProgramUniform2fv", "glProgramUniform"),
  ("glProgramUniform3fv", "glProgramUniform"),
  ("glProgramUniform4fv", "glProgramUniform"),
  ("glProgramUniform1iv", "glProgramUniform"),
  ("glProgramUniform2iv", "glProgramUniform"),
  ("glProgramUniform3iv", "glProgramUniform"),
  ("glProgramUniform4iv", "glProgramUniform"),
  ("glProgramUniform1uiv", "glProgramUniform"),
  ("glProgramUniform2uiv", "glProgramUniform"),
  ("glProgramUniform3uiv", "glProgramUniform"),
  ("glProgramUniform4uiv", "glProgramUniform"),
  ("glProgramUniformMatrix2fv", "glProgramUniform"),
  ("glProgramUniformMatrix3fv", "glProgramUniform"),
  ("glProgramUniformMatrix4fv", "glProgramUniform"),
  ("glProgramUniformMatrix2x3fv", "glProgramUniform"),
  ("glProgramUniformMatrix3x2fv", "glProgramUniform"),
  ("glProgramUniformMatrix2x4fv", "glProgramUniform"),
  ("glProgramUniformMatrix4x2fv", "glProgramUniform"),
  ("glProgramUniformMatrix3x4fv", "glProgramUniform"),
  ("glProgramUniformMatrix4x3fv", "glProgramUniform"),
  ("glProvokingVertex", "glProvokingVertex"),
  ("glPushDebugGroup", "glPushDebugGroup"),
  ("glQueryCounter", "glQueryCounter"),
  ("glReadBuffer", "glReadBuffer"),
  ("glNamedFramebufferReadBuffer", "glReadBuffer"),
  ("glReadPixels", "glReadPixels"),
  ("glReadnPixels", "glReadPixels"),
  ("glReleaseShaderCompiler", "glReleaseShaderCompiler"),
  ("glRenderbufferStorageMultisample", "glRenderbufferStorageMultisample"),
  ("glNamedRenderbufferStorageMultisample", "glRenderbufferStorageMultisample"),
  ("glRenderbufferStorage", "glRenderbufferStorage"),
  ("glNamedRenderbufferStorage", "glRenderbufferStorage"),
  ("glResumeTransformFeedback", "glResumeTransformFeedback"),
  ("glSampleCoverage", "glSampleCoverage"),
  ("glSampleMaski", "glSampleMaski"),
  ("glSamplerParameterf", "glSamplerParameter"),
  ("glSamplerParameteri", "glSamplerParameter"),
  ("glSamplerParameterfv", "glSamplerParameter"),
  ("glSamplerParameteriv", "glSamplerParameter"),
  ("glSamplerParameterIiv", "glSamplerParameter"),
  ("glSamplerParameterIuiv", "glSamplerParameter"),
  ("glScissorArrayv", "glScissorArray"),
  ("glScissorIndexed", "glScissorIndexed"),
  ("glScissorIndexedv", "glScissorIndexed"),
  ("glScissor", "glScissor"),
  ("glShaderBinary", "glShaderBinary"),
  ("glShaderSource", "glShaderSource"),
  ("glShaderStorageBlockBinding", "glShaderStorageBlockBinding"),
  ("glStencilFuncSeparate", "glStencilFuncSeparate"),
  ("glStencilFunc", "glStencilFunc"),
  ("glStencilMaskSeparate", "glStencilMaskSeparate"),
  ("glStencilMask", "glStencilMask"),
  ("glStencilOpSeparate", "glStencilOpSeparate"),
  ("glStencilOp", "glStencilOp"),
  ("glTexBufferRange", "glTexBufferRange"),
  ("glTextureBufferRange", "glTexBufferRange"),
  ("glTexBuffer", "glTexBuffer"),
  ("glTextureBuffer", "glTexBuffer"),
  ("glTexImage1D", "glTexImage1D"),
  ("glTexImage2DMultisample", "glTexImage2DMultisample"),
  ("glTexImage2D", "glTexImage2D"),
  ("glTexImage3DMultisample", "glTexImage3DMultisample"),
  ("glTexImage3D", "glTexImage3D"),
  ("glTexParameterf", "glTexParameter"),
  ("glTexParameteri", "glTexParameter"),
  ("glTextureParameterf", "glTexParameter"),
  ("glTextureParameteri", "glTexParameter"),
  ("glTexParameterfv", "glTexParameter"),
  ("glTexParameteriv", "glTexParameter"),
  ("glTexParameterIiv", "glTexParameter"),
  ("glTexParameterIuiv", "glTexParameter"),
  ("glTextureParameterfv", "glTexParameter"),
  ("glTextureParameteriv", "glTexParameter"),
  ("glTextureParameterIiv", "glTexParameter"),
  ("glTextureParameterIuiv", "glTexParameter"),
  ("glTexStorage1D", "glTexStorage1D"),
  ("glTextureStorage1D", "glTexStorage1D"),
  ("glTexStorage2DMultisample", "glTexStorage2DMultisample"),
  ("glTextureStorage2DMultisample", "glTexStorage2DMultisample"),
  ("glTexStorage2D", "glTexStorage2D"),
  ("glTextureStorage2D", "glTexStorage2D"),
  ("glTexStorage3DMultisample", "glTexStorage3DMultisample"),
  ("glTextureStorage3DMultisample", "glTexStorage3DMultisample"),
  ("glTexStorage3D", "glTexStorage3D"),
  ("glTextureStorage3D", "glTexStorage3D"),
  ("glTexSubImage1D", "glTexSubImage1D"),
  ("glTextureSubImage1D", "glTexSubImage1D"),
  ("glTexSubImage2D", "glTexSubImage2D"),
  ("glTextureSubImage2D", "glTexSubImage2D"),
  ("glTexSubImage3D", "glTexSubImage3D"),
  ("glTextureSubImage3D", "glTexSubImage3D"),
  ("glTextureBarrier", "glTextureBarrier"),
  ("glTextureView", "glTextureView"),
  ("glTransformFeedbackBufferBase", "glTransformFeedbackBufferBase"),
  ("glTransformFeedbackBufferRange", "glTransformFeedbackBufferRange"),
  ("glTransformFeedbackVaryings", "glTransformFeedbackVaryings"),
  ("glUniformBlockBinding", "glUniformBlockBinding"),
  ("glUniformSubroutinesuiv", "glUniformSubroutines"),
  ("glUniform1f", "glUniform"),
  ("glUniform2f", "glUniform"),
  ("glUniform3f", "glUniform"),
  ("glUniform4f", "glUniform"),
  ("glUniform1i", "glUniform"),
  ("glUniform2i", "glUniform"),
  ("glUniform3i", "glUniform"),
  ("glUniform4i", "glUniform"),
  ("glUniform1ui", "glUniform"),
  ("glUniform2ui", "glUniform"),
  ("glUniform3ui", "glUniform"),
  ("glUniform4ui", "glUniform"),
  ("glUniform1fv", "glUniform"),
  ("glUniform2fv", "glUniform"),
  ("glUniform3fv", "glUniform"),
  ("glUniform4fv", "glUniform"),
  ("glUniform1iv", "glUniform"),
  ("glUniform2iv", "glUniform"),
  ("glUniform3iv", "glUniform"),
  ("glUniform4iv", "glUniform"),
  ("glUniform1uiv", "glUniform"),
  ("glUniform2uiv", "glUniform"),
  ("glUniform3uiv", "glUniform"),
  ("glUniform4uiv", "glUniform"),
  ("glUniformMatrix2fv", "glUniform"),
  ("glUniformMatrix3fv", "glUniform"),
  ("glUniformMatrix4fv", "glUniform"),
  ("glUniformMatrix2x3fv", "glUniform"),
  ("glUniformMatrix3x2fv", "glUniform"),
  ("glUniformMatrix2x4fv", "glUniform"),
  ("glUniformMatrix4x2fv", "glUniform"),
  ("glUniformMatrix3x4fv", "glUniform"),
  ("glUniformMatrix4x3fv", "glUniform"),
  ("glUnmapBuffer", "glUnmapBuffer"),
  ("glUnmapNamedBuffer", "glUnmapBuffer"),
  ("glUseProgramStages", "glUseProgramStages"),
  ("glUseProgram", "glUseProgram"),
  ("glValidateProgramPipeline", "glValidateProgramPipeline"),
  ("glValidateProgram", "glValidateProgram"),
  ("glVertexArrayElementBuffer", "glVertexArrayElementBuffer"),
  ("glVertexAttribBinding", "glVertexAttribBinding"),
  ("glVertexArrayAttribBinding", "glVertexAttribBinding"),
  ("glVertexAttribDivisor", "glVertexAttribDivisor"),
  ("glVertexAttribFormat", "glVertexAttribFormat"),
  ("glVertexAttribIFormat", "glVertexAttribFormat"),
  ("glVertexAttribLFormat", "glVertexAttribFormat"),
  ("glVertexArrayAttribFormat", "glVertexAttribFormat"),
  ("glVertexArrayAttribIFormat", "glVertexAttribFormat"),
  ("glVertexArrayAttribLFormat", "glVertexAttribFormat"),
  ("glVertexAttribPointer", "glVertexAttribPointer"),
  ("glVertexAttribIPointer", "glVertexAttribPointer"),
  ("glVertexAttribLPointer", "glVertexAttribPointer"),
  ("glVertexAttrib1f", "glVertexAttrib"),
  ("glVertexAttrib1s", "glVertexAttrib"),
  ("glVertexAttrib1d", "glVertexAttrib"),
  ("glVertexAttribI1i", "glVertexAttrib"),
  ("glVertexAttribI1ui", "glVertexAttrib"),
  ("glVertexAttrib2f", "glVertexAttrib"),
  ("glVertexAttrib2s", "glVertexAttrib"),
  ("glVertexAttrib2d", "glVertexAttrib"),
  ("glVertexAttribI2i", "glVertexAttrib"),
  ("glVertexAttribI2ui", "glVertexAttrib"),
  ("glVertexAttrib3f", "glVertexAttrib"),
  ("glVertexAttrib3s", "glVertexAttrib"),
  ("glVertexAttrib3d", "glVertexAttrib"),
  ("glVertexAttribI3i", "glVertexAttrib"),
  ("glVertexAttribI3ui", "glVertexAttrib"),
  ("glVertexAttrib4f", "glVertexAttrib"),
  ("glVertexAttrib4s", "glVertexAttrib"),
  ("glVertexAttrib4d", "glVertexAttrib"),
  ("glVertexAttrib4Nub", "glVertexAttrib"),
  ("glVertexAttribI4i", "glVertexAttrib"),
  ("glVertexAttribI4ui", "glVertexAttrib"),
  ("glVertexAttribL1d", "glVertexAttrib"),
  ("glVertexAttribL2d", "glVertexAttrib"),
  ("glVertexAttribL3d", "glVertexAttrib"),
  ("glVertexAttribL4d", "glVertexAttrib"),
  ("glVertexAttrib1fv", "glVertexAttrib"),
  ("glVertexAttrib1sv", "glVertexAttrib"),
  ("glVertexAttrib1dv", "glVertexAttrib"),
  ("glVertexAttribI1iv", "glVertexAttrib"),
  ("glVertexAttribI1uiv", "glVertexAttrib"),
  ("glVertexAttrib2fv", "glVertexAttrib"),
  ("glVertexAttrib2sv", "glVertexAttrib"),
  ("glVertexAttrib2dv", "glVertexAttrib"),
  ("glVertexAttribI2iv", "glVertexAttrib"),
  ("glVertexAttribI2uiv", "glVertexAttrib"),
  ("glVertexAttrib3fv", "glVertexAttrib"),
  ("glVertexAttrib3sv", "glVertexAttrib"),
  ("glVertexAttrib3dv", "glVertexAttrib"),
  ("glVertexAttribI3iv", "glVertexAttrib"),
  ("glVertexAttribI3uiv", "glVertexAttrib"),
  ("glVertexAttrib4fv", "glVertexAttrib"),
  ("glVertexAttrib4sv", "glVertexAttrib"),
  ("glVertexAttrib4dv", "glVertexAttrib"),
  ("glVertexAttrib4iv", "glVertexAttrib"),
  ("glVertexAttrib4bv", "glVertexAttrib"),
  ("glVertexAttrib4ubv", "glVertexAttrib"),
  ("glVertexAttrib4usv", "glVertexAttrib"),
  ("glVertexAttrib4uiv", "glVertexAttrib"),
  ("glVertexAttrib4Nbv", "glVertexAttrib"),
  ("glVertexAttrib4Nsv", "glVertexAttrib"),
  ("glVertexAttrib4Niv", "glVertexAttrib"),
  ("glVertexAttrib4Nubv", "glVertexAttrib"),
  ("glVertexAttrib4Nusv", "glVertexAttrib"),
  ("glVertexAttrib4Nuiv", "glVertexAttrib"),
  ("glVertexAttribI4bv", "glVertexAttrib"),
  ("glVertexAttribI4ubv", "glVertexAttrib"),
  ("glVertexAttribI4sv", "glVertexAttrib"),
  ("glVertexAttribI4usv", "glVertexAttrib"),
  ("glVertexAttribI4iv", "glVertexAttrib"),
  ("glVertexAttribI4uiv", "glVertexAttrib"),
  ("glVertexAttribL1dv", "glVertexAttrib"),
  ("glVertexAttribL2dv", "glVertexAttrib"),
  ("glVertexAttribL3dv", "glVertexAttrib"),
  ("glVertexAttribL4dv", "glVertexAttrib"),
  ("glVertexAttribP1ui", "glVertexAttrib"),
  ("glVertexAttribP2ui", "glVertexAttrib"),
  ("glVertexAttribP3ui", "glVertexAttrib"),
  ("glVertexAttribP4ui", "glVertexAttrib"),
  ("glVertexBindingDivisor", "glVertexBindingDivisor"),
  ("glVertexArrayBindingDivisor", "glVertexBindingDivisor"),
  ("glViewportArrayv", "glViewportArray"),
  ("glViewportIndexedf", "glViewportIndexed"),
  ("glViewportIndexedfv", "glViewportIndexed"),
  ("glViewport", "glViewport"),
  ("glWaitSync", "glWaitSync")
  ]

entriesFor :: String -> Label -> String -> String -> [(String, String)] -> [(ManPageKey, [(URL, Label)])]
entriesFor api label baseURL extension assocs =
  [ ((API api, CommandName n), [(baseURL ++ u ++ extension, label)])
  | (n, u) <- assocs ]

manPageURLs :: M.Map ManPageKey [(URL, Label)]
manPageURLs =
  M.fromListWith (++) .
  concat $
  reverse [ assocsGL2, assocsGL3, assocsGL4, assocsGLX1 ]
