{-# LANGUAGE PatternSynonyms #-}
--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.GL.EXT.VertexShader
-- Copyright   :  (c) Sven Panne 2016
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
--------------------------------------------------------------------------------

module Graphics.GL.EXT.VertexShader (
  -- * Extension Support
  glGetEXTVertexShader,
  gl_EXT_vertex_shader,
  -- * Enums
  pattern GL_CURRENT_VERTEX_EXT,
  pattern GL_FULL_RANGE_EXT,
  pattern GL_INVARIANT_DATATYPE_EXT,
  pattern GL_INVARIANT_EXT,
  pattern GL_INVARIANT_VALUE_EXT,
  pattern GL_LOCAL_CONSTANT_DATATYPE_EXT,
  pattern GL_LOCAL_CONSTANT_EXT,
  pattern GL_LOCAL_CONSTANT_VALUE_EXT,
  pattern GL_LOCAL_EXT,
  pattern GL_MATRIX_EXT,
  pattern GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT,
  pattern GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT,
  pattern GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT,
  pattern GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT,
  pattern GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT,
  pattern GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT,
  pattern GL_MAX_VERTEX_SHADER_INVARIANTS_EXT,
  pattern GL_MAX_VERTEX_SHADER_LOCALS_EXT,
  pattern GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT,
  pattern GL_MAX_VERTEX_SHADER_VARIANTS_EXT,
  pattern GL_MVP_MATRIX_EXT,
  pattern GL_NEGATIVE_ONE_EXT,
  pattern GL_NEGATIVE_W_EXT,
  pattern GL_NEGATIVE_X_EXT,
  pattern GL_NEGATIVE_Y_EXT,
  pattern GL_NEGATIVE_Z_EXT,
  pattern GL_NORMALIZED_RANGE_EXT,
  pattern GL_ONE_EXT,
  pattern GL_OP_ADD_EXT,
  pattern GL_OP_CLAMP_EXT,
  pattern GL_OP_CROSS_PRODUCT_EXT,
  pattern GL_OP_DOT3_EXT,
  pattern GL_OP_DOT4_EXT,
  pattern GL_OP_EXP_BASE_2_EXT,
  pattern GL_OP_FLOOR_EXT,
  pattern GL_OP_FRAC_EXT,
  pattern GL_OP_INDEX_EXT,
  pattern GL_OP_LOG_BASE_2_EXT,
  pattern GL_OP_MADD_EXT,
  pattern GL_OP_MAX_EXT,
  pattern GL_OP_MIN_EXT,
  pattern GL_OP_MOV_EXT,
  pattern GL_OP_MULTIPLY_MATRIX_EXT,
  pattern GL_OP_MUL_EXT,
  pattern GL_OP_NEGATE_EXT,
  pattern GL_OP_POWER_EXT,
  pattern GL_OP_RECIP_EXT,
  pattern GL_OP_RECIP_SQRT_EXT,
  pattern GL_OP_ROUND_EXT,
  pattern GL_OP_SET_GE_EXT,
  pattern GL_OP_SET_LT_EXT,
  pattern GL_OP_SUB_EXT,
  pattern GL_OUTPUT_COLOR0_EXT,
  pattern GL_OUTPUT_COLOR1_EXT,
  pattern GL_OUTPUT_FOG_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD0_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD10_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD11_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD12_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD13_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD14_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD15_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD16_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD17_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD18_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD19_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD1_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD20_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD21_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD22_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD23_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD24_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD25_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD26_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD27_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD28_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD29_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD2_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD30_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD31_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD3_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD4_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD5_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD6_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD7_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD8_EXT,
  pattern GL_OUTPUT_TEXTURE_COORD9_EXT,
  pattern GL_OUTPUT_VERTEX_EXT,
  pattern GL_SCALAR_EXT,
  pattern GL_VARIANT_ARRAY_EXT,
  pattern GL_VARIANT_ARRAY_POINTER_EXT,
  pattern GL_VARIANT_ARRAY_STRIDE_EXT,
  pattern GL_VARIANT_ARRAY_TYPE_EXT,
  pattern GL_VARIANT_DATATYPE_EXT,
  pattern GL_VARIANT_EXT,
  pattern GL_VARIANT_VALUE_EXT,
  pattern GL_VECTOR_EXT,
  pattern GL_VERTEX_SHADER_BINDING_EXT,
  pattern GL_VERTEX_SHADER_EXT,
  pattern GL_VERTEX_SHADER_INSTRUCTIONS_EXT,
  pattern GL_VERTEX_SHADER_INVARIANTS_EXT,
  pattern GL_VERTEX_SHADER_LOCALS_EXT,
  pattern GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT,
  pattern GL_VERTEX_SHADER_OPTIMIZED_EXT,
  pattern GL_VERTEX_SHADER_VARIANTS_EXT,
  pattern GL_W_EXT,
  pattern GL_X_EXT,
  pattern GL_Y_EXT,
  pattern GL_ZERO_EXT,
  pattern GL_Z_EXT,
  -- * Functions
  glBeginVertexShaderEXT,
  glBindLightParameterEXT,
  glBindMaterialParameterEXT,
  glBindParameterEXT,
  glBindTexGenParameterEXT,
  glBindTextureUnitParameterEXT,
  glBindVertexShaderEXT,
  glDeleteVertexShaderEXT,
  glDisableVariantClientStateEXT,
  glEnableVariantClientStateEXT,
  glEndVertexShaderEXT,
  glExtractComponentEXT,
  glGenSymbolsEXT,
  glGenVertexShadersEXT,
  glGetInvariantBooleanvEXT,
  glGetInvariantFloatvEXT,
  glGetInvariantIntegervEXT,
  glGetLocalConstantBooleanvEXT,
  glGetLocalConstantFloatvEXT,
  glGetLocalConstantIntegervEXT,
  glGetVariantBooleanvEXT,
  glGetVariantFloatvEXT,
  glGetVariantIntegervEXT,
  glGetVariantPointervEXT,
  glInsertComponentEXT,
  glIsVariantEnabledEXT,
  glSetInvariantEXT,
  glSetLocalConstantEXT,
  glShaderOp1EXT,
  glShaderOp2EXT,
  glShaderOp3EXT,
  glSwizzleEXT,
  glVariantPointerEXT,
  glVariantbvEXT,
  glVariantdvEXT,
  glVariantfvEXT,
  glVariantivEXT,
  glVariantsvEXT,
  glVariantubvEXT,
  glVariantuivEXT,
  glVariantusvEXT,
  glWriteMaskEXT
) where

import Graphics.GL.ExtensionPredicates
import Graphics.GL.Tokens
import Graphics.GL.Functions
