module Hat.PreludeBasic
  (gyield,hyield,glift,hlift,gthenAp,gthenLex,hthenLex,galt,halt,Eq(..),Ord(..)
    ,Enum(..),Bounded(..),Num(..),Real(..),Integral(..),Fractional(..)
    ,Floating(..),RealFrac(..),RealFloat(..),gsubtract,geven,heven,godd,ggcd
    ,hgcd,glcm,hlcm,(!^),(*^),(!^^),(*^^),gfromIntegral,grealToFrac,Functor(..)
    ,Monad(..),gsequence,gsequence_,gmapM,hmapM,gmapM_,hmapM_,(!=<<),(*=<<),gid
    ,hid,gconst,hconst,(!.),(*.),gflip,hflip,(!$),(*$),(!$!),(*$!),(!&&),(*&&)
    ,(!||),(*||),gnot,hnot,gotherwise,Maybe(..),gmaybe,hmaybe,Either(..),geither
    ,heither,Ordering(..),gintEnumFromByTo,hintEnumFromByTo,gnumericEnumFrom
    ,gnumericEnumFromThen,hnumericEnumFromThen,gnumericEnumFromTo
    ,hnumericEnumFromTo,gnumericEnumFromThenTo,hnumericEnumFromThenTo,gfst,hfst
    ,gsnd,hsnd,gcurry,hcurry,guncurry,huncurry,guntil,huntil,gasTypeOf,g_foldr
    ,h_foldr,g_filter,h_filter,gmap,hmap,(!++),(*++),gfilter,hfilter,gconcat
    ,hconcat,ghead,hhead,glast,hlast,gtail,htail,ginit,hinit,gnull,hnull,glength
    ,hlength,(!!!),(*!!),gfoldl,hfoldl,gfoldl1,hfoldl1,gscanl,hscanl,gscanl1
    ,hscanl1,gfoldr,hfoldr,gfoldr1,hfoldr1,gscanr,hscanr,gscanr1,hscanr1
    ,giterate,hiterate,grepeat,hrepeat,greplicate,hreplicate,gcycle,hcycle,gtake
    ,htake,gdrop,hdrop,gsplitAt,hsplitAt,gtakeWhile,htakeWhile,gdropWhile
    ,hdropWhile,gspan,hspan,gbreak,hbreak,glines,hlines,gwords,hwords,gunlines
    ,gunwords,hunwords,greverse,gand,gor,gany,hany,gall,hall,gelem,helem
    ,gnotElem,hnotElem,glookup,hlookup,gsum,gproduct,gmaximum,hmaximum,gminimum
    ,hminimum,gconcatMap,hconcatMap,gzip,gzip3,gzipWith,hzipWith,gzipWith3
    ,hzipWith3,gunzip,gunzip3,ReadS(),ReadS___1(),ReadS___2(),ShowS()
    ,ShowS___1(),ShowS___2(),Read(..),Show(..),greads,gshows,gread,hread
    ,gshowChar,gshowString,gshowParen,hshowParen,greadParen,hreadParen,glex,hlex
    ,FilePath(),gputStr,hputStr,gputStrLn,hputStrLn,gprint,hprint,ggetLine
    ,ginteract,hinteract,greadIO,hreadIO,greadLn,gdigitToInt,hdigitToInt
    ,gintToDigit,hintToDigit,gord,gchr,greadLitChar,hreadLitChar,gshowLitChar
    ,hshowLitChar,gprotectEsc,hprotectEsc,gasciiTab,glexLitChar,hlexLitChar
    ,gfromRat,hfromRat,gfromRat',hfromRat',gscaleRat,hscaleRat,gminExpt,gmaxExpt
    ,gexpt,hexpt,gexpts,gintegerLogBase,hintegerLogBase,gshowSigned,hshowSigned
    ,gshowOct,gshowInt,gshowHex,gshowIntAtBase,hshowIntAtBase,greadSigned
    ,hreadSigned,greadInt,hreadInt,greadDec,greadOct,greadHex,gshowEFloat
    ,hshowEFloat,gshowFFloat,hshowFFloat,gshowGFloat,hshowGFloat,gshowFloat
    ,FFFormat(..),gformatRealFloat,hformatRealFloat,groundTo,hroundTo
    ,gfloatToDigits,hfloatToDigits,greadFloat,hreadFloat,glexDigits,gnonnull
    ,hnonnull,gprec,Ratio(..),Rational(),greduce,hreduce,(!%),(*%),gnumerator
    ,hnumerator,gdenominator,hdenominator,gapproxRational,happroxRational
    ,aNothing,aJust,aLeft,aRight,aLT,aEQ,aGT,aFFExponent,aFFFixed,aFFGeneric
    ,(+:%),ayield,alift,athenAp,athenLex,aalt,(++%=^=+%=@/=),(++&=^=+&=@==)
    ,a75v5v78v26compare,(+@!=^=@!=@<=),(+@#=^=@#=^<),(+@$=^=@$=@>=)
    ,(+@%=^=@%=^>),a86v5v88v25max,a89v5v91v25min,a111v5v111v48succ
    ,a112v5v112v56pred,a113v5v113v36enumFrom,a114v5v114v36enumFromTo
    ,a115v5v115v36enumFromThen,a116v5v117v36enumFromThenTo,(+#%*=^=#%*=^-)
    ,a136v5v136v29negate,a151v8v151v11quot,a152v8v152v10rem,a153v8v153v10div
    ,a154v8v154v10mod,a155v5v158v52divMod,a168v5v168v29recip,(+#+>=^=#+>=^/)
    ,(+#@*=^=#@*=@**),a186v5v186v37logBase,a187v5v187v31sqrt,a188v5v188v39tan
    ,a189v5v189v39tanh,a200v5v200v57truncate,a202v5v207v40round
    ,a215v5v216v54ceiling,a218v5v219v54floor,a238v5v239v51exponent
    ,a241v5v242v51significand,a244v5v245v51scaleFloat,a247v5v258v30atan2
    ,asubtract,aeven,aodd,agcd,alcm,(+^),(+^^),afromIntegral,arealToFrac
    ,(+%$#=^=%$#=@>>),a322v5v322v21fail,asequence,asequence_,amapM,amapM_,(+=<<)
    ,(+%*&=^=%*&=@==),a357v3v357v22compare,a360v3v360v18fromEnum
    ,a361v3v362v78toEnum,a365v3v365v16minBound,a366v3v366v16maxBound,aid,aconst
    ,(+.),aflip,(+$),(+$!),(+&##=>=&#%=#!==),a416v3v419v26compare
    ,a422v3v423v22fromEnum,a425v3v427v70toEnum,a429v3v429v32enumFrom
    ,a430v3v430v53enumFromThen,a433v3v434v20readsPrec,a438v3v439v38showsPrec
    ,a442v3v442v18minBound,a443v3v443v17maxBound,(+&&),(+||),anot,aotherwise
    ,(+&^$=^=&^$=@==),(+&^+=^=&^+=@<=),a480v5v480v37toEnum,a481v5v481v37fromEnum
    ,a482v5v482v36enumFrom,a483v5v486v59enumFromThen,a490v5v490v31minBound
    ,a491v5v491v46maxBound,(+*!!=*#=*!!=*$==),a500v55v500v57compare
    ,a500v60v500v63readsPrec,a500v66v500v69showsPrec,amaybe,a509v5v510v34fmap
    ,(+*#&=#&=*#*=#+>>=),a516v5v516v28return,a517v5v517v31fail
    ,(+*$$=*#=*$$=*$==),a522v55v522v57compare,a522v60v522v63readsPrec
    ,a522v66v522v69showsPrec,aeither,a536v4v536v42fmap,(+*&!=*=*&!=$$>>=)
    ,a541v4v541v24return,a542v4v542v32fail,(+*&@=$#=*&@=$$==)
    ,a548v25v548v27compare,a548v30v548v33fromEnum,a548v30v548v33toEnum
    ,a548v30v548v33enumFrom,a548v30v548v33enumFromThen,a548v36v548v39readsPrec
    ,a548v42v548v45showsPrec,a548v48v548v54minBound,a548v48v548v54maxBound
    ,(+**>=*=**>=+==),(+*+!=*=*+!=+/=),(+*+%=*=*+%=*<),(+*+&=*=*+&=+<=)
    ,(+*+*=*=*+*=+>=),(+*++=*=*++=*>),(+*+>=&=*+>=&+),(+*^!=&=*^!=&-)
    ,(+*^#=&=*^#=&*),a572v2v572v27negate,a573v2v573v24abs,a574v2v574v27signum
    ,a575v2v575v37fromInteger,a578v5v578v36toRational,a581v8v581v11quot
    ,a582v8v582v10rem,a583v8v583v14quotRem,a585v5v585v46toInteger
    ,a588v3v588v13toEnum,a589v3v589v15fromEnum,a591v3v591v36enumFrom
    ,a592v3v592v78enumFromThen,a593v3v593v40enumFromTo
    ,a594v3v594v52enumFromThenTo,aintEnumFromByTo,a610v3v610v28minBound
    ,a611v3v611v28maxBound,(++#^=*=+#^=+==),(++#@=*=+#@=+/=),(++$#=*=+$#=*<)
    ,(++$$=*=+$$=+<=),(++$%=*=+$%=+>=),(++$&=*=+$&=*>),(++$^=&=+$^=&+)
    ,(++$@=&=+$@=&-),(++$>=&=+$>=&*),a630v2v630v28negate,a631v2v631v41abs
    ,a632v2v635v24signum,a636v2v636v18fromInteger,a639v5v639v24toRational
    ,a642v8v642v11quot,a643v8v643v10rem,a644v8v644v10div,a645v8v645v10mod
    ,a647v8v647v14quotRem,a649v5v649v21toInteger,a652v3v652v18succ
    ,a653v3v653v18pred,a654v3v654v26toEnum,a655v3v655v28fromEnum
    ,a657v3v657v24enumFrom,a658v3v658v41enumFromThen,a659v3v659v51enumFromTo
    ,a660v3v663v54enumFromThenTo,(+++>=*=++>=+==),(++^!=*=+^!=+/=)
    ,(++^%=*=+^%=*<),(++^&=*=+^&=+<=),(++^*=*=+^*=+>=),(++^+=*=+^+=*>)
    ,(++^>=&=+^>=&+),(++@!=&=+@!=&-),(++@#=&=+@#=&*),a682v2v682v17negate
    ,a683v2v683v26abs,a684v2v684v29signum,a685v2v685v39fromInteger
    ,a688v5v689v52toRational,(++>$=*=+>$=*/),a693v3v701v76fromRational
    ,a704v5v704v38pi,a705v5v705v41exp,a706v5v706v41log,a707v5v707v42sqrt
    ,a708v5v708v41sin,a709v5v709v41cos,a710v5v710v41tan,a711v5v711v42asin
    ,a712v5v712v42acos,a713v5v713v42atan,a714v5v714v48sinh,a715v5v715v48cosh
    ,a716v5v716v73tanh,a717v5v717v34asinh,a718v5v718v47acosh,a719v5v719v40atanh
    ,a722v5v728v67properFraction,a731v5v731v34floatRadix
    ,a732v5v732v35floatDigits,a733v5v733v34floatRange,a734v5v734v37decodeFloat
    ,a735v5v735v41encodeFloat,a737v5v737v35isNaN,a738v5v738v40isInfinite
    ,a739v5v739v44isDenormalized,a740v5v740v44isNegativeZero,a741v5v741v36isIEEE
    ,(+^&^=*=^&^=+==),(+^&@=*=^&@=+/=),(+^*#=*=^*#=*<),(+^*$=*=^*$=+<=)
    ,(+^*%=*=^*%=+>=),(+^*&=*=^*&=*>),(+^*^=&=^*^=&+),(+^*@=&=^*@=&-)
    ,(+^*>=&=^*>=&*),a760v2v760v18negate,a761v2v761v27abs,a762v2v762v30signum
    ,a763v2v763v40fromInteger,a766v5v767v51toRational,(+^^!=*=^^!=*/)
    ,a771v3v780v11fromRational,a784v5v784v39pi,a785v5v785v42exp,a786v5v786v42log
    ,a787v5v787v43sqrt,a788v5v788v42sin,a789v5v789v42cos,a790v5v790v42tan
    ,a791v5v791v43asin,a792v5v792v43acos,a793v5v793v43atan,a794v5v794v63sinh
    ,a795v5v795v63cosh,a796v5v796v67tanh,a797v5v797v34asinh,a798v5v798v47acosh
    ,a799v5v799v40atanh,a802v5v808v67properFraction,a812v5v812v35floatRadix
    ,a813v5v813v36floatDigits,a814v5v814v35floatRange,a815v5v815v38decodeFloat
    ,a816v5v816v42encodeFloat,a818v5v818v36isNaN,a819v5v819v41isInfinite
    ,a820v5v820v45isDenormalized,a821v5v821v45isNegativeZero,a822v5v822v37isIEEE
    ,a833v5v833v27succ,a834v5v834v27pred,a835v5v835v36toEnum
    ,a836v5v836v46fromEnum,a837v5v837v39enumFrom,a838v5v838v43enumFromThen
    ,a839v5v839v41enumFromTo,a840v5v840v45enumFromThenTo,a844v5v844v27succ
    ,a845v5v845v27pred,a846v5v846v36toEnum,a847v5v847v46fromEnum
    ,a848v5v848v39enumFrom,a849v5v849v43enumFromThen,a850v5v850v41enumFromTo
    ,a851v5v851v45enumFromThenTo,anumericEnumFrom,anumericEnumFromThen
    ,anumericEnumFromTo,anumericEnumFromThenTo,(+@^^=#!=@^>=##==)
    ,a882v3v889v16compare,a893v5v893v14fmap,(+@>^=^=@>^=>>>=)
    ,a898v5v898v26return,a899v5v899v25fail,(+>#!=>=>#!=#!==)
    ,a913v3v917v16compare,a920v3v920v33minBound,a921v3v921v33maxBound
    ,(+>$*=##=>$*=#$==),a928v3v933v15compare,a936v3v936v41minBound
    ,a937v3v937v41maxBound,(+>&#=#%=>&#=#&==),a944v3v951v15compare
    ,a954v3v954v50minBound,a955v3v955v50maxBound,(+>*>=#*=>*>=#+==)
    ,a963v3v972v15compare,a976v3v976v59minBound,a977v3v977v59maxBound
    ,(+>@#=#^=>@#=#@==),a985v3v996v15compare,a1000v3v1000v68minBound
    ,a1001v3v1001v68maxBound,(+#!!*=#>=#!!*=$!==),a1010v3v1023v15compare
    ,a1028v3v1028v77minBound,a1029v3v1029v77maxBound,(+#!%&=$#=#!%&=$$==)
    ,a1040v3v1054v15compare,a1059v3v1060v23minBound,a1061v3v1062v23maxBound
    ,(+#!++=$%=#!++=$&==),a1072v3v1088v13compare,a1093v3v1094v32minBound
    ,a1095v3v1096v32maxBound,(+##!#=$*=##!#=$+==),a1107v3v1125v13compare
    ,a1130v3v1131v41minBound,a1132v3v1133v41maxBound,(+##%@=$^=##%@=$@==)
    ,a1144v3v1164v13compare,a1169v3v1170v50minBound,a1171v3v1172v50maxBound
    ,(+##^^=$>=##^^=%!==),a1184v3v1206v13compare,a1211v3v1212v59minBound
    ,a1213v3v1214v59maxBound,(+#$#>=%#=#$#>=%$==),a1226v3v1251v13compare
    ,a1257v3v1258v68minBound,a1259v3v1260v68maxBound,(+#$+*=%%=#$+*=%&==)
    ,a1274v3v1301v13compare,a1307v3v1308v77minBound,a1309v3v1310v77maxBound
    ,(+#%#+=%*=#%#+=%+==),a1325v3v1354v13compare,a1360v3v1362v23minBound
    ,a1363v3v1365v23maxBound,afst,asnd,acurry,auncurry,auntil,aasTypeOf,a_foldr
    ,a_filter,amap,(+++),afilter,aconcat,ahead,alast,atail,ainit,anull,alength
    ,(+!!),afoldl,afoldl1,ascanl,ascanl1,afoldr,afoldr1,ascanr,ascanr1,aiterate
    ,arepeat,areplicate,acycle,atake,adrop,asplitAt,atakeWhile,adropWhile,aspan
    ,abreak,alines,awords,aunlines,aunwords,areverse,aand,aor,aany,aall,aelem
    ,anotElem,alookup,asum,aproduct,amaximum,aminimum,aconcatMap,azip,azip3
    ,azipWith,azipWith3,aunzip,aunzip3,a1804v5v1809v35readList
    ,a1822v5v1822v35showsPrec,a1824v5v1824v36show,a1826v5v1830v53showList,areads
    ,ashows,aread,ashowChar,ashowString,ashowParen,areadParen,alex
    ,a1917v5v1917v41showsPrec,a1923v3v1923v11readsPrec,a1929v5v1929v44showsPrec
    ,a1933v5v1933v44readsPrec,a1937v5v1937v35showsPrec,a1941v5v1941v46readsPrec
    ,a1945v5v1945v35showsPrec,a1949v5v1949v46readsPrec,a1953v5v1953v37showsPrec
    ,a1957v5v1958v30readsPrec,a1962v5v1963v68showsPrec,a1965v5v1968v64showList
    ,a1972v5v1973v30readsPrec,a1976v5v1980v19readList,a1985v5v1985v31showsPrec
    ,a1989v5v1989v31readsPrec,a1995v5v1996v61showsPrec,a2000v5v2001v30readsPrec
    ,a2009v5v2010v30readsPrec,a2020v5v2021v30readsPrec,a2033v5v2034v30readsPrec
    ,a2049v5v2050v30readsPrec,a2067v5v2068v30readsPrec,a2088v5v2089v30readsPrec
    ,a2111v5v2112v30readsPrec,a2136v5v2137v30readsPrec,a2163v5v2164v22readsPrec
    ,a2192v5v2193v22readsPrec,a2223v5v2224v22readsPrec,a2256v5v2257v22readsPrec
    ,a2292v5v2293v22readsPrec,a2329v5v2331v63showsPrec,a2338v5v2341v65showsPrec
    ,a2349v5v2353v65showsPrec,a2363v5v2368v65showsPrec,a2379v5v2385v65showsPrec
    ,a2398v5v2405v65showsPrec,a2419v5v2428v65showsPrec,a2444v5v2454v65showsPrec
    ,a2471v5v2482v65showsPrec,a2500v5v2512v65showsPrec,a2531v5v2544v65showsPrec
    ,a2564v5v2578v65showsPrec,a2599v5v2614v65showsPrec,a2650v3v2650v24show
    ,aputStr,aputStrLn,aprint,agetLine,ainteract,areadIO,areadLn,adigitToInt
    ,aintToDigit,aord,achr,areadLitChar,ashowLitChar,aprotectEsc,aasciiTab
    ,alexLitChar,afromRat,afromRat',ascaleRat,aminExpt,amaxExpt,aexpt,aexpts
    ,aintegerLogBase,ashowSigned,ashowOct,ashowInt,ashowHex,ashowIntAtBase
    ,areadSigned,areadInt,areadDec,areadOct,areadHex,ashowEFloat,ashowFFloat
    ,ashowGFloat,ashowFloat,aformatRealFloat,aroundTo,afloatToDigits,areadFloat
    ,alexDigits,anonnull,aprec,(+%#@@=*@=%#@@=*>==),areduce,(+%),anumerator
    ,adenominator,(+%$#+=#$=%$#+=#%<=),(+%$#^=#$=%$#^=#$<),(+%$$!=#$=%$$!=#$+)
    ,(+%$$#=#$=%$$#=#$*),a3222v5v3222v36negate,a3223v5v3223v37abs
    ,a3224v5v3224v40signum,a3225v5v3225v45fromInteger,a3228v5v3228v53toRational
    ,(+%$%#=#$=%$%#=#$/),a3232v5v3232v32recip,a3233v5v3233v57fromRational
    ,a3236v5v3237v53properFraction,a3240v5v3240v36toEnum,a3241v5v3241v46fromEnum
    ,a3242v5v3242v39enumFrom,a3243v5v3243v43enumFromThen
    ,a3244v5v3244v41enumFromTo,a3245v5v3245v45enumFromThenTo
    ,a3248v5v3249v32readsPrec,a3254v5v3255v68showsPrec,aapproxRational
    ,module Hat.PreludeBuiltin) where

import qualified Prelude 
import Hat.Hack 
import qualified Hat.Hat as T 
import Hat.Hat  (WrapVal(wrapVal))
import Hat.PreludeBuiltinTypes 
import Hat.PreludeBuiltin 

gyield :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (ReadS a))

hyield :: (T.R a) -> (T.R (ReadS___1 a)) -> T.RefExp -> T.R (ReadS___2 a)

gyield pyield p = T.ufun2 ayield pyield p hyield

hyield fx fr p =
  T.fromExpList T.mkNoSrcPos p
    [T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2 (T.projection T.mkNoSrcPos p fx)
        (T.projection T.mkNoSrcPos p fr)]

glift ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.Fun a (T.Fun b (ReadS c)))
          (T.Fun (ReadS a) (T.Fun (ReadS b) (ReadS c))))

hlift ::
  (T.R (T.Fun a (T.Fun b (ReadS c)))) ->
    (T.R (ReadS a)) ->
      (T.R (ReadS b)) -> (T.R (ReadS___1 c)) -> T.RefExp -> T.R (ReadS___2 c)

glift plift p = T.ufun4 alift plift p hlift

hlift fc ff fg fr p =
  T.uap2 T.mkNoSrcPos p (gconcatMap T.mkNoSrcPos p)
    (T.ufun1 T.mkLambda T.mkNoSrcPos p
      (\ v43v27v43v70v1 p ->
        case (v43v27v43v70v1) of
          (T.R (T.Tuple2 fx fs) _) ->
            T.uap2 T.mkNoSrcPos p (gconcatMap T.mkNoSrcPos p)
              (T.ufun1 T.mkLambda T.mkNoSrcPos p
                (\ v43v48v43v64v1 p ->
                  case (v43v48v43v64v1) of
                    (T.R (T.Tuple2 fy ft) _) ->
                      T.uap3 T.mkNoSrcPos p fc fx fy ft
                    _ -> T.fatal p)) (T.uap1 T.mkNoSrcPos p fg fs)
          _ -> T.fatal p)) (T.uap1 T.mkNoSrcPos p ff fr)

gthenAp ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (ReadS (T.Fun a b)) (T.Fun (ReadS a) (ReadS b)))

sthenAp :: T.R (T.Fun (ReadS (T.Fun a b)) (T.Fun (ReadS a) (ReadS b)))

gthenAp pthenAp p = T.uconstUse pthenAp p sthenAp

sthenAp =
  T.uconstDef T.mkRoot athenAp
    (\ p ->
      T.uap1 T.mkNoSrcPos p (glift T.mkNoSrcPos p)
        (T.ufun3 T.mkLambda T.mkNoSrcPos p
          (\ fh fx ft p ->
            T.fromExpList T.mkNoSrcPos p
              [T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                  (T.uap1 T.mkNoSrcPos p fh fx)
                  (T.projection T.mkNoSrcPos p ft)])))

gthenLex ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (ReadS a) (T.Fun String (ReadS a)))

hthenLex :: (T.R (ReadS a)) -> (T.R String) -> T.RefExp -> T.R (ReadS a)

gthenLex pthenLex p = T.ufun2 athenLex pthenLex p hthenLex

hthenLex ff fxs p =
  T.uap3 T.mkNoSrcPos p (glift T.mkNoSrcPos p)
    (T.ufun3 T.mkLambda T.mkNoSrcPos p
      (\ fx fy ft p ->
        T.ucif p (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fy fxs)
          (T.fromExpList T.mkNoSrcPos p
            [T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                (T.projection T.mkNoSrcPos p fx)
                (T.projection T.mkNoSrcPos p ft)])
          (T.con0 T.mkNoSrcPos p T.List T.aList))) ff (glex T.mkNoSrcPos p)

galt ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (ReadS a) (T.Fun (ReadS a) (ReadS a)))

halt ::
  (T.R (ReadS a)) ->
    (T.R (ReadS a)) -> (T.R (ReadS___1 a)) -> T.RefExp -> T.R (ReadS___2 a)

galt palt p = T.ufun3 aalt palt p halt

halt ff fg fr p =
  T.uwrapForward p
    (((T.uap1 T.mkNoSrcPos p ff fr) *++ (T.uap1 T.mkNoSrcPos p fg fr)) p)

class Eq a
  where
  
  (!==),(!/=) :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a Bool))
  
  (!/=) (%/=) p =
    T.ufun2 (++%=^=+%=@/=) (%/=) p (*/=)
    where
    
    (*/=) fx fy p =
      T.uwrapForward p
        (hnot (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fx fy) p)
    
  
  (!==) (%==) p =
    T.ufun2 (++&=^=+&=@==) (%==) p (*==)
    where
    
    (*==) fx fy p =
      T.uwrapForward p
        (hnot (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/= p) fx fy) p)
    
  
  (|==),(|/=) :: T.R (T.Fun a (T.Fun a Bool))
  

class Eq a => Ord a
  where
  
  gcompare :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a Ordering))
  
  (!<),(!<=),(!>=),(!>) ::
    T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a Bool))
  
  gmax,gmin :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))
  
  gcompare pcompare p =
    T.ufun2 a75v5v78v26compare pcompare p hcompare
    where
    
    hcompare fx fy p =
      T.ucguard (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fx fy)
        (T.con0 T.mkNoSrcPos p EQ aEQ)
        (T.ucguard (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !<= p) fx fy)
          (T.con0 T.mkNoSrcPos p LT aLT)
          (T.ucguard (gotherwise T.mkNoSrcPos p) (T.con0 T.mkNoSrcPos p GT aGT)
            (T.fatal p)))
    
  
  (!<=) (%<=) p =
    T.ufun2 (+@!=^=@!=@<=) (%<=) p (*<=)
    where
    
    (*<=) fx fy p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/= p)
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fx fy)
        (T.con0 T.mkNoSrcPos p GT aGT)
    
  
  (!<) (%<) p =
    T.ufun2 (+@#=^=@#=^<) (%<) p (*<)
    where
    
    (*<) fx fy p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p)
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fx fy)
        (T.con0 T.mkNoSrcPos p LT aLT)
    
  
  (!>=) (%>=) p =
    T.ufun2 (+@$=^=@$=@>=) (%>=) p (*>=)
    where
    
    (*>=) fx fy p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/= p)
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fx fy)
        (T.con0 T.mkNoSrcPos p LT aLT)
    
  
  (!>) (%>) p =
    T.ufun2 (+@%=^=@%=^>) (%>) p (*>)
    where
    
    (*>) fx fy p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p)
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fx fy)
        (T.con0 T.mkNoSrcPos p GT aGT)
    
  
  gmax pmax p =
    T.ufun2 a86v5v88v25max pmax p hmax
    where
    
    hmax fx fy p =
      T.ucguard (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !<= p) fx fy)
        (T.projection T.mkNoSrcPos p fy)
        (T.ucguard (gotherwise T.mkNoSrcPos p) (T.projection T.mkNoSrcPos p fx)
          (T.fatal p))
    
  
  gmin pmin p =
    T.ufun2 a89v5v91v25min pmin p hmin
    where
    
    hmin fx fy p =
      T.ucguard (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !<= p) fx fy)
        (T.projection T.mkNoSrcPos p fx)
        (T.ucguard (gotherwise T.mkNoSrcPos p) (T.projection T.mkNoSrcPos p fy)
          (T.fatal p))
    
  
  scompare :: T.R (T.Fun a (T.Fun a Ordering))
  
  (|<),(|<=),(|>=),(|>) :: T.R (T.Fun a (T.Fun a Bool))
  
  smax,smin :: T.R (T.Fun a (T.Fun a a))
  

class Enum a
  where
  
  gsucc,gpred :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a a)
  
  gtoEnum :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int a)
  
  gfromEnum :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a Int)
  
  genumFrom :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.List a))
  
  genumFromThen :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a (T.List a)))
  
  genumFromTo :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a (T.List a)))
  
  genumFromThenTo ::
    T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a (T.Fun a (T.List a))))
  
  gsucc psucc p = T.uconstUse psucc p ssucc
  
  ssucc =
    T.uconstDef T.mkRoot a111v5v111v48succ
      (\ p ->
        T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p) (gtoEnum T.mkNoSrcPos p)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
            (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !+ p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 1))) (gfromEnum T.mkNoSrcPos p)))
  
  gpred ppred p = T.uconstUse ppred p spred
  
  spred =
    T.uconstDef T.mkRoot a112v5v112v56pred
      (\ p ->
        T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p) (gtoEnum T.mkNoSrcPos p)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
            (T.uap1 T.mkNoSrcPos p (gsubtract T.mkNoSrcPos p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 1))) (gfromEnum T.mkNoSrcPos p)))
  
  genumFrom penumFrom p =
    T.ufun1 a113v5v113v36enumFrom penumFrom p henumFrom
    where
    
    henumFrom fx p =
      T.uwrapForward p
        (hmap (gtoEnum T.mkNoSrcPos p)
          (T.uap1 T.mkNoSrcPos p (genumFrom T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fx)) p)
    
  
  genumFromTo penumFromTo p =
    T.ufun2 a114v5v114v36enumFromTo penumFromTo p henumFromTo
    where
    
    henumFromTo fx fy p =
      T.uwrapForward p
        (hmap (gtoEnum T.mkNoSrcPos p)
          (T.uap2 T.mkNoSrcPos p (genumFromTo T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fx)
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fy)) p)
    
  
  genumFromThen penumFromThen p =
    T.ufun2 a115v5v115v36enumFromThen penumFromThen p henumFromThen
    where
    
    henumFromThen fx fy p =
      T.uwrapForward p
        (hmap (gtoEnum T.mkNoSrcPos p)
          (T.uap2 T.mkNoSrcPos p (genumFromThen T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fx)
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fy)) p)
    
  
  genumFromThenTo penumFromThenTo p =
    T.ufun3 a116v5v117v36enumFromThenTo penumFromThenTo p henumFromThenTo
    where
    
    henumFromThenTo fx fy fz p =
      T.uwrapForward p
        (hmap (gtoEnum T.mkNoSrcPos p)
          (T.uap3 T.mkNoSrcPos p (genumFromThenTo T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fx)
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fy)
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fz)) p)
    
  
  ssucc,spred :: T.R (T.Fun a a)
  
  stoEnum :: T.R (T.Fun Int a)
  
  sfromEnum :: T.R (T.Fun a Int)
  
  senumFrom :: T.R (T.Fun a (T.List a))
  
  senumFromThen :: T.R (T.Fun a (T.Fun a (T.List a)))
  
  senumFromTo :: T.R (T.Fun a (T.Fun a (T.List a)))
  
  senumFromThenTo :: T.R (T.Fun a (T.Fun a (T.Fun a (T.List a))))
  

class Bounded a
  where
  
  gminBound :: T.RefSrcPos -> T.RefExp -> T.R a
  
  gmaxBound :: T.RefSrcPos -> T.RefExp -> T.R a
  
  sminBound :: T.R a
  
  smaxBound :: T.R a
  

class (Eq a,Show a) => Num a
  where
  
  (!+),(!-),(!*) :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))
  
  gnegate :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a a)
  
  gabs,gsignum :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a a)
  
  gfromInteger :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Integer a)
  
  (!-) (%-) p =
    T.ufun2 (+#%*=^=#%*=^-) (%-) p (*-)
    where
    
    (*-) fx fy p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx
        (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fy)
    
  
  gnegate pnegate p =
    T.ufun1 a136v5v136v29negate pnegate p hnegate
    where
    
    hnegate fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p)
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0)) fx
    
  
  (|+),(|-),(|*) :: T.R (T.Fun a (T.Fun a a))
  
  snegate :: T.R (T.Fun a a)
  
  sabs,ssignum :: T.R (T.Fun a a)
  
  sfromInteger :: T.R (T.Fun Integer a)
  

class (Num a,Ord a) => Real a
  where
  
  gtoRational :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a Rational)
  
  stoRational :: T.R (T.Fun a Rational)
  

class (Real a,Enum a) => Integral a
  where
  
  gquot,grem :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))
  
  gdiv,gmod :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))
  
  gquotRem,gdivMod ::
    T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a (T.Tuple2 a a)))
  
  gtoInteger :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a Integer)
  
  gquot pquot p =
    T.ufun2 a151v8v151v11quot pquot p hquot
    where
    
    hquot fn fd p =
      gq T.mkNoSrcPos p
      where
      
      gq pq p = T.uconstUse pq p sq
      
      gr pq p = T.uconstUse pq p sr
      
      j151v34v151v38q =
        case T.uap2 T.mkNoSrcPos p (gquotRem T.mkNoSrcPos p) fn fd of
          T.R (T.Tuple2 fq fr) kq -> (kq,fq,fr)
          _ -> T.fatal p
      
      sq =
        T.uconstDef p a151v35v151v35q
          (\ _ -> case j151v34v151v38q of (kq,fq,fr) -> fq)
      
      sr =
        T.uconstDef p a151v37v151v37r
          (\ _ -> case j151v34v151v38q of (kq,fq,fr) -> fr)
      
    
  
  grem prem p =
    T.ufun2 a152v8v152v10rem prem p hrem
    where
    
    hrem fn fd p =
      gr T.mkNoSrcPos p
      where
      
      gq pq p = T.uconstUse pq p sq
      
      gr pq p = T.uconstUse pq p sr
      
      j152v34v152v38q =
        case T.uap2 T.mkNoSrcPos p (gquotRem T.mkNoSrcPos p) fn fd of
          T.R (T.Tuple2 fq fr) kq -> (kq,fq,fr)
          _ -> T.fatal p
      
      sq =
        T.uconstDef p a152v35v152v35q
          (\ _ -> case j152v34v152v38q of (kq,fq,fr) -> fq)
      
      sr =
        T.uconstDef p a152v37v152v37r
          (\ _ -> case j152v34v152v38q of (kq,fq,fr) -> fr)
      
    
  
  gdiv pdiv p =
    T.ufun2 a153v8v153v10div pdiv p hdiv
    where
    
    hdiv fn fd p =
      gq T.mkNoSrcPos p
      where
      
      gq pq p = T.uconstUse pq p sq
      
      gr pq p = T.uconstUse pq p sr
      
      j153v34v153v38q =
        case T.uap2 T.mkNoSrcPos p (gdivMod T.mkNoSrcPos p) fn fd of
          T.R (T.Tuple2 fq fr) kq -> (kq,fq,fr)
          _ -> T.fatal p
      
      sq =
        T.uconstDef p a153v35v153v35q
          (\ _ -> case j153v34v153v38q of (kq,fq,fr) -> fq)
      
      sr =
        T.uconstDef p a153v37v153v37r
          (\ _ -> case j153v34v153v38q of (kq,fq,fr) -> fr)
      
    
  
  gmod pmod p =
    T.ufun2 a154v8v154v10mod pmod p hmod
    where
    
    hmod fn fd p =
      gr T.mkNoSrcPos p
      where
      
      gq pq p = T.uconstUse pq p sq
      
      gr pq p = T.uconstUse pq p sr
      
      j154v34v154v38q =
        case T.uap2 T.mkNoSrcPos p (gdivMod T.mkNoSrcPos p) fn fd of
          T.R (T.Tuple2 fq fr) kq -> (kq,fq,fr)
          _ -> T.fatal p
      
      sq =
        T.uconstDef p a154v35v154v35q
          (\ _ -> case j154v34v154v38q of (kq,fq,fr) -> fq)
      
      sr =
        T.uconstDef p a154v37v154v37r
          (\ _ -> case j154v34v154v38q of (kq,fq,fr) -> fr)
      
    
  
  gdivMod pdivMod p =
    T.ufun2 a155v5v158v52divMod pdivMod p hdivMod
    where
    
    hdivMod fn fd p =
      T.ucif p
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p)
          (T.uap1 T.mkNoSrcPos p (gsignum T.mkNoSrcPos p) (gr T.mkNoSrcPos p))
          (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p (gsignum T.mkNoSrcPos p) fd)))
        (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) (gq T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 1)))
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) (gr T.mkNoSrcPos p) fd))
        (gqr T.mkNoSrcPos p)
      where
      
      gqr pqr p = T.uconstUse pqr p sqr
      
      sqr =
        T.uconstDef p a158v31v158v32qr
          (\ p -> T.uap2 T.mkNoSrcPos p (gquotRem T.mkNoSrcPos p) fn fd)
      
      gq pq p = T.uconstUse pq p sq
      
      gr pq p = T.uconstUse pq p sr
      
      j158v34v158v38q =
        case gqr T.mkNoSrcPos p of
          T.R (T.Tuple2 fq fr) kq -> (kq,fq,fr)
          _ -> T.fatal p
      
      sq =
        T.uconstDef p a158v35v158v35q
          (\ _ -> case j158v34v158v38q of (kq,fq,fr) -> fq)
      
      sr =
        T.uconstDef p a158v37v158v37r
          (\ _ -> case j158v34v158v38q of (kq,fq,fr) -> fr)
      
    
  
  squot,srem :: T.R (T.Fun a (T.Fun a a))
  
  sdiv,smod :: T.R (T.Fun a (T.Fun a a))
  
  squotRem,sdivMod :: T.R (T.Fun a (T.Fun a (T.Tuple2 a a)))
  
  stoInteger :: T.R (T.Fun a Integer)
  

class Num a => Fractional a
  where
  
  (!/) :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))
  
  grecip :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a a)
  
  gfromRational :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Rational a)
  
  grecip precip p =
    T.ufun1 a168v5v168v29recip precip p hrecip
    where
    
    hrecip fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 1)) fx
    
  
  (!/) (%/) p =
    T.ufun2 (+#+>=^=#+>=^/) (%/) p (*/)
    where
    
    (*/) fx fy p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fx
        (T.uap1 T.mkNoSrcPos p (grecip T.mkNoSrcPos p) fy)
    
  
  (|/) :: T.R (T.Fun a (T.Fun a a))
  
  srecip :: T.R (T.Fun a a)
  
  sfromRational :: T.R (T.Fun Rational a)
  

class Fractional a => Floating a
  where
  
  gpi :: T.RefSrcPos -> T.RefExp -> T.R a
  
  gexp,glog,gsqrt :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a a)
  
  (!**),glogBase :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))
  
  gsin,gcos,gtan :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a a)
  
  gasin,gacos,gatan :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a a)
  
  gsinh,gcosh,gtanh :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a a)
  
  gasinh,gacosh,gatanh :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a a)
  
  (!**) (%**) p =
    T.ufun2 (+#@*=^=#@*=@**) (%**) p (***)
    where
    
    (***) fx fy p =
      T.uap1 T.mkNoSrcPos p (gexp T.mkNoSrcPos p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
          (T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p) fx) fy)
    
  
  glogBase plogBase p =
    T.ufun2 a186v5v186v37logBase plogBase p hlogBase
    where
    
    hlogBase fx fy p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
        (T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p) fy)
        (T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p) fx)
    
  
  gsqrt psqrt p =
    T.ufun1 a187v5v187v31sqrt psqrt p hsqrt
    where
    
    hsqrt fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !** p) fx
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromRational T.mkNoSrcPos p)
          (T.R
            ((T.conInteger T.mkNoSrcPos p 1)
              Hat.PreludeBasic.:%
              (T.conInteger T.mkNoSrcPos p 2))
            (T.mkAtomRational T.mkNoSrcPos p 0.5)))
    
  
  gtan ptan p =
    T.ufun1 a188v5v188v39tan ptan p htan
    where
    
    htan fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
        (T.uap1 T.mkNoSrcPos p (gsin T.mkNoSrcPos p) fx)
        (T.uap1 T.mkNoSrcPos p (gcos T.mkNoSrcPos p) fx)
    
  
  gtanh ptanh p =
    T.ufun1 a189v5v189v39tanh ptanh p htanh
    where
    
    htanh fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
        (T.uap1 T.mkNoSrcPos p (gsinh T.mkNoSrcPos p) fx)
        (T.uap1 T.mkNoSrcPos p (gcosh T.mkNoSrcPos p) fx)
    
  
  spi :: T.R a
  
  sexp,slog,ssqrt :: T.R (T.Fun a a)
  
  (|**),slogBase :: T.R (T.Fun a (T.Fun a a))
  
  ssin,scos,stan :: T.R (T.Fun a a)
  
  sasin,sacos,satan :: T.R (T.Fun a a)
  
  ssinh,scosh,stanh :: T.R (T.Fun a a)
  
  sasinh,sacosh,satanh :: T.R (T.Fun a a)
  

class (Real a,Fractional a) => RealFrac a
  where
  
  gproperFraction ::
    Integral b => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Tuple2 b a))
  
  gtruncate,ground :: Integral b => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a b)
  
  gceiling,gfloor :: Integral b => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a b)
  
  gtruncate ptruncate p =
    T.ufun1 a200v5v200v57truncate ptruncate p htruncate
    where
    
    htruncate fx p =
      gm T.mkNoSrcPos p
      where
      
      gm pm p = T.uconstUse pm p sm
      
      j200v34v200v38m =
        case T.uap1 T.mkNoSrcPos p (gproperFraction T.mkNoSrcPos p) fx of
          T.R (T.Tuple2 fm _) km -> (km,fm)
          _ -> T.fatal p
      
      sm =
        T.uconstDef p a200v35v200v35m
          (\ _ -> case j200v34v200v38m of (km,fm) -> fm)
      
    
  
  ground pround p =
    T.ufun1 a202v5v207v40round pround p hround
    where
    
    hround fx p =
      let
        gn pn p = T.uconstUse pn p sn
        gr pn p = T.uconstUse pn p sr
        j202v29v202v33n =
          case T.uap1 T.mkNoSrcPos p (gproperFraction T.mkNoSrcPos p) fx of
            T.R (T.Tuple2 fn fr) kn -> (kn,fn,fr)
            _ -> T.fatal p
        sn =
          T.uconstDef p a202v30v202v30n
            (\ _ -> case j202v29v202v33n of (kn,fn,fr) -> fn)
        sr =
          T.uconstDef p a202v32v202v32r
            (\ _ -> case j202v29v202v33n of (kn,fn,fr) -> fr)
        gm pm p = T.uconstUse pm p sm
        sm =
          T.uconstDef p a203v29v203v66m
            (\ p ->
              T.ucif p
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p) (gr T.mkNoSrcPos p)
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 0)))
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) (gn T.mkNoSrcPos p)
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 1)))
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) (gn T.mkNoSrcPos p)
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 1)))) in
        (T.uccase T.mkNoSrcPos p
          (let
            v204v30v207v40v1 (T.R LT _) p = gn T.mkNoSrcPos p
            v204v30v207v40v1 (T.R EQ _) p =
              T.ucif p (T.uwrapForward p (heven (gn T.mkNoSrcPos p) p))
                (gn T.mkNoSrcPos p) (gm T.mkNoSrcPos p)
            v204v30v207v40v1 (T.R GT _) p = gm T.mkNoSrcPos p
            v204v30v207v40v1 _ p = T.fatal p in (v204v30v207v40v1))
          (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p (gsignum T.mkNoSrcPos p)
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p)
                (T.uap1 T.mkNoSrcPos p (gabs T.mkNoSrcPos p)
                  (gr T.mkNoSrcPos p))
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromRational T.mkNoSrcPos p)
                  (T.R
                    ((T.conInteger T.mkNoSrcPos p 1)
                      Hat.PreludeBasic.:%
                      (T.conInteger T.mkNoSrcPos p 2))
                    (T.mkAtomRational T.mkNoSrcPos p 0.5)))))
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 0))))
    
  
  gceiling pceiling p =
    T.ufun1 a215v5v216v54ceiling pceiling p hceiling
    where
    
    hceiling fx p =
      T.ucif p
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) (gr T.mkNoSrcPos p)
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 0)))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) (gn T.mkNoSrcPos p)
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 1))) (gn T.mkNoSrcPos p)
      where
      
      gn pn p = T.uconstUse pn p sn
      
      gr pn p = T.uconstUse pn p sr
      
      j216v31v216v35n =
        case T.uap1 T.mkNoSrcPos p (gproperFraction T.mkNoSrcPos p) fx of
          T.R (T.Tuple2 fn fr) kn -> (kn,fn,fr)
          _ -> T.fatal p
      
      sn =
        T.uconstDef p a216v32v216v32n
          (\ _ -> case j216v31v216v35n of (kn,fn,fr) -> fn)
      
      sr =
        T.uconstDef p a216v34v216v34r
          (\ _ -> case j216v31v216v35n of (kn,fn,fr) -> fr)
      
    
  
  gfloor pfloor p =
    T.ufun1 a218v5v219v54floor pfloor p hfloor
    where
    
    hfloor fx p =
      T.ucif p
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p) (gr T.mkNoSrcPos p)
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 0)))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) (gn T.mkNoSrcPos p)
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 1))) (gn T.mkNoSrcPos p)
      where
      
      gn pn p = T.uconstUse pn p sn
      
      gr pn p = T.uconstUse pn p sr
      
      j219v31v219v35n =
        case T.uap1 T.mkNoSrcPos p (gproperFraction T.mkNoSrcPos p) fx of
          T.R (T.Tuple2 fn fr) kn -> (kn,fn,fr)
          _ -> T.fatal p
      
      sn =
        T.uconstDef p a219v32v219v32n
          (\ _ -> case j219v31v219v35n of (kn,fn,fr) -> fn)
      
      sr =
        T.uconstDef p a219v34v219v34r
          (\ _ -> case j219v31v219v35n of (kn,fn,fr) -> fr)
      
    
  
  sproperFraction :: Integral b => T.R (T.Fun a (T.Tuple2 b a))
  
  struncate,sround :: Integral b => T.R (T.Fun a b)
  
  sceiling,sfloor :: Integral b => T.R (T.Fun a b)
  

class (RealFrac a,Floating a) => RealFloat a
  where
  
  gfloatRadix :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a Integer)
  
  gfloatDigits :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a Int)
  
  gfloatRange :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Tuple2 Int Int))
  
  gdecodeFloat ::
    T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Tuple2 Integer Int))
  
  gencodeFloat :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Integer (T.Fun Int a))
  
  gexponent :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a Int)
  
  gsignificand :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a a)
  
  gscaleFloat :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (T.Fun a a))
  
  gisNaN,gisInfinite,gisDenormalized,gisNegativeZero,gisIEEE ::
    T.RefSrcPos -> T.RefExp -> T.R (T.Fun a Bool)
  
  gatan2 :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))
  
  gexponent pexponent p =
    T.ufun1 a238v5v239v51exponent pexponent p hexponent
    where
    
    hexponent fx p =
      T.ucif p
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) (gm T.mkNoSrcPos p)
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 0)))
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) (gn T.mkNoSrcPos p)
          (T.uap1 T.mkNoSrcPos p (gfloatDigits T.mkNoSrcPos p) fx))
      where
      
      gm pm p = T.uconstUse pm p sm
      
      gn pm p = T.uconstUse pm p sn
      
      j239v31v239v35m =
        case T.uap1 T.mkNoSrcPos p (gdecodeFloat T.mkNoSrcPos p) fx of
          T.R (T.Tuple2 fm fn) km -> (km,fm,fn)
          _ -> T.fatal p
      
      sm =
        T.uconstDef p a239v32v239v32m
          (\ _ -> case j239v31v239v35m of (km,fm,fn) -> fm)
      
      sn =
        T.uconstDef p a239v34v239v34n
          (\ _ -> case j239v31v239v35m of (km,fm,fn) -> fn)
      
    
  
  gsignificand psignificand p =
    T.ufun1 a241v5v242v51significand psignificand p hsignificand
    where
    
    hsignificand fx p =
      T.uap2 T.mkNoSrcPos p (gencodeFloat T.mkNoSrcPos p) (gm T.mkNoSrcPos p)
        (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p)
          (T.uap1 T.mkNoSrcPos p (gfloatDigits T.mkNoSrcPos p) fx))
      where
      
      gm pm p = T.uconstUse pm p sm
      
      j242v31v242v35m =
        case T.uap1 T.mkNoSrcPos p (gdecodeFloat T.mkNoSrcPos p) fx of
          T.R (T.Tuple2 fm _) km -> (km,fm)
          _ -> T.fatal p
      
      sm =
        T.uconstDef p a242v32v242v32m
          (\ _ -> case j242v31v242v35m of (km,fm) -> fm)
      
    
  
  gscaleFloat pscaleFloat p =
    T.ufun2 a244v5v245v51scaleFloat pscaleFloat p hscaleFloat
    where
    
    hscaleFloat fk fx p =
      T.uap2 T.mkNoSrcPos p (gencodeFloat T.mkNoSrcPos p) (gm T.mkNoSrcPos p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) (gn T.mkNoSrcPos p) fk)
      where
      
      gm pm p = T.uconstUse pm p sm
      
      gn pm p = T.uconstUse pm p sn
      
      j245v31v245v35m =
        case T.uap1 T.mkNoSrcPos p (gdecodeFloat T.mkNoSrcPos p) fx of
          T.R (T.Tuple2 fm fn) km -> (km,fm,fn)
          _ -> T.fatal p
      
      sm =
        T.uconstDef p a245v32v245v32m
          (\ _ -> case j245v31v245v35m of (km,fm,fn) -> fm)
      
      sn =
        T.uconstDef p a245v34v245v34n
          (\ _ -> case j245v31v245v35m of (km,fm,fn) -> fn)
      
    
  
  gatan2 patan2 p =
    T.ufun2 a247v5v258v30atan2 patan2 p hatan2
    where
    
    hatan2 fy fx p =
      T.ucguard
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) fx
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 0)))
        (T.uap1 T.mkNoSrcPos p (gatan T.mkNoSrcPos p)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p) fy fx))
        (T.ucguard
          (T.uwrapForward p
            (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fx
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 0)))
                *&&
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) fy
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 0)))) p))
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p) (gpi T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 2)))
          (T.ucguard
            (T.uwrapForward p
              (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p) fx
                    (T.uap1 T.mkNoSrcPos p
                      (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                      (T.conInteger T.mkNoSrcPos p 0)))
                  *&&
                  (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) fy
                    (T.uap1 T.mkNoSrcPos p
                      (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                      (T.conInteger T.mkNoSrcPos p 0)))) p))
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) (gpi T.mkNoSrcPos p)
              (T.uap1 T.mkNoSrcPos p (gatan T.mkNoSrcPos p)
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p) fy fx)))
            (T.ucguard
              (T.uwrapForward p
                (((T.uwrapForward p
                      (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !<= p) fx
                            (T.uap1 T.mkNoSrcPos p
                              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                              (T.conInteger T.mkNoSrcPos p 0)))
                          *&&
                          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p) fy
                            (T.uap1 T.mkNoSrcPos p
                              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                              (T.conInteger T.mkNoSrcPos p 0)))) p))
                    *||
                    (T.uwrapForward p
                      (((T.uwrapForward p
                            (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p) fx
                                  (T.uap1 T.mkNoSrcPos p
                                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos
                                      p) (T.conInteger T.mkNoSrcPos p 0)))
                                *&&
                                (T.uap1 T.mkNoSrcPos p
                                  (gisNegativeZero T.mkNoSrcPos p) fy)) p))
                          *||
                          (T.uwrapForward p
                            (((T.uap1 T.mkNoSrcPos p
                                  (gisNegativeZero T.mkNoSrcPos p) fx)
                                *&&
                                (T.uap1 T.mkNoSrcPos p
                                  (gisNegativeZero T.mkNoSrcPos p) fy)) p)))
                        p))) p))
              (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p)
                (T.uap2 T.mkNoSrcPos p (gatan2 T.mkNoSrcPos p)
                  (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fy) fx))
              (T.ucguard
                (T.uwrapForward p
                  (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fy
                        (T.uap1 T.mkNoSrcPos p
                          (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                          (T.conInteger T.mkNoSrcPos p 0)))
                      *&&
                      (T.uwrapForward p
                        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p) fx
                              (T.uap1 T.mkNoSrcPos p
                                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                                (T.conInteger T.mkNoSrcPos p 0)))
                            *||
                            (T.uap1 T.mkNoSrcPos p
                              (gisNegativeZero T.mkNoSrcPos p) fx)) p))) p))
                (gpi T.mkNoSrcPos p)
                (T.ucguard
                  (T.uwrapForward p
                    (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fx
                          (T.uap1 T.mkNoSrcPos p
                            (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                            (T.conInteger T.mkNoSrcPos p 0)))
                        *&&
                        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fy
                          (T.uap1 T.mkNoSrcPos p
                            (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                            (T.conInteger T.mkNoSrcPos p 0)))) p))
                  (T.projection T.mkNoSrcPos p fy)
                  (T.ucguard (gotherwise T.mkNoSrcPos p)
                    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx fy)
                    (T.fatal p)))))))
    
  
  sfloatRadix :: T.R (T.Fun a Integer)
  
  sfloatDigits :: T.R (T.Fun a Int)
  
  sfloatRange :: T.R (T.Fun a (T.Tuple2 Int Int))
  
  sdecodeFloat :: T.R (T.Fun a (T.Tuple2 Integer Int))
  
  sencodeFloat :: T.R (T.Fun Integer (T.Fun Int a))
  
  sexponent :: T.R (T.Fun a Int)
  
  ssignificand :: T.R (T.Fun a a)
  
  sscaleFloat :: T.R (T.Fun Int (T.Fun a a))
  
  sisNaN,sisInfinite,sisDenormalized,sisNegativeZero,sisIEEE ::
    T.R (T.Fun a Bool)
  
  satan2 :: T.R (T.Fun a (T.Fun a a))
  

gsubtract :: Num a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))

ssubtract :: Num a => T.R (T.Fun a (T.Fun a a))

gsubtract psubtract p = T.uconstUse psubtract p ssubtract

ssubtract =
  T.uconstDef T.mkRoot asubtract
    (\ p -> T.uap1 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !- p))

geven,godd :: Integral a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a Bool)

heven :: Integral a => (T.R a) -> T.RefExp -> T.R Bool

sodd :: Integral a => T.R (T.Fun a Bool)

geven peven p = T.ufun1 aeven peven p heven

heven fn p =
  T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p)
    (T.uap2 T.mkNoSrcPos p (grem T.mkNoSrcPos p) fn
      (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 2)))
    (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
      (T.conInteger T.mkNoSrcPos p 0))

godd podd p = T.uconstUse podd p sodd

sodd =
  T.uconstDef T.mkRoot aodd
    (\ p ->
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p) (gnot T.mkNoSrcPos p)
        (geven T.mkNoSrcPos p))

ggcd :: Integral a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))

hgcd :: Integral a => (T.R a) -> (T.R a) -> T.RefExp -> T.R a

ggcd pgcd p = T.ufun2 agcd pgcd p hgcd

hgcd fv273v5v273v5n v273v7v273v7n p =
  T.ucguard
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fv273v5v273v5n
      (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0))) (h v273v7v273v7n p)
    (y1gcd fv273v5v273v5n v273v7v273v7n p)
  where
  
  h fv273v7v273v7n p =
    T.ucguard
      (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fv273v7v273v7n
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0))) (h p)
      (y1gcd fv273v5v273v5n v273v7v273v7n p)
    where
    
    h p =
      T.uwrapForward p
        (herror
          (T.fromLitString T.mkNoSrcPos p "Prelude.gcd: gcd 0 0 is undefined")
          p)
    h p = y1gcd fv273v5v273v5n v273v7v273v7n p
    
  h _ p = y1gcd fv273v5v273v5n v273v7v273v7n p
  
hgcd fv273v5v273v5n v273v7v273v7n p = y1gcd fv273v5v273v5n v273v7v273v7n p

y1gcd fx fy p =
  T.uwrapForward p
    (hgcd' (T.uap1 T.mkNoSrcPos p (gabs T.mkNoSrcPos p) fx)
      (T.uap1 T.mkNoSrcPos p (gabs T.mkNoSrcPos p) fy) p)
  where
  
  ggcd' pgcd' p = T.ufun2 a275v27v276v56gcd' pgcd' p hgcd'
  
  agcd' = a275v27v276v56gcd'
  
  hgcd' fx fv275v34v275v34n p =
    T.ucguard
      (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fv275v34v275v34n
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0))) (h p) (y1gcd' fx fv275v34v275v34n p)
    where
    
    h p = T.projection T.mkNoSrcPos p fx
    h p = y1gcd' fx fv275v34v275v34n p
    
  hgcd' fx fv275v34v275v34n p = y1gcd' fx fv275v34v275v34n p
  
  y1gcd' fx fy p =
    T.uwrapForward p
      (hgcd' fy (T.uap2 T.mkNoSrcPos p (grem T.mkNoSrcPos p) fx fy) p)
  

glcm :: Integral a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))

hlcm :: Integral a => (T.R a) -> (T.R a) -> T.RefExp -> T.R a

glcm plcm p = T.ufun2 alcm plcm p hlcm

hlcm (z1lcm@_) fv280v7v280v7n p =
  T.ucguard
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fv280v7v280v7n
      (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0))) (h p) (y1lcm z1lcm fv280v7v280v7n p)
  where
  
  h p =
    T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
      (T.conInteger T.mkNoSrcPos p 0)
  h p = y1lcm z1lcm fv280v7v280v7n p
  
hlcm z1lcm fv280v7v280v7n p = y1lcm z1lcm fv280v7v280v7n p

y1lcm fv281v5v281v5n v281v7v281v7n p =
  T.ucguard
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fv281v5v281v5n
      (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0))) (h v281v7v281v7n p)
    (y2lcm fv281v5v281v5n v281v7v281v7n p)
  where
  
  h _ p =
    T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
      (T.conInteger T.mkNoSrcPos p 0)
  h _ p = y2lcm fv281v5v281v5n v281v7v281v7n p
  
y1lcm fv281v5v281v5n v281v7v281v7n p = y2lcm fv281v5v281v5n v281v7v281v7n p

y2lcm fx fy p =
  T.uap1 T.mkNoSrcPos p (gabs T.mkNoSrcPos p)
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
      (T.uap2 T.mkNoSrcPos p (gquot T.mkNoSrcPos p) fx
        (T.uwrapForward p (hgcd fx fy p))) fy)

(!^) ::
  (Num a,Integral b) => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun b a))

(*^) :: (Num a,Integral b) => (T.R a) -> (T.R b) -> T.RefExp -> T.R a

(!^) (%^) p = T.ufun2 (+^) (%^) p (*^)

(*^) fx fv286v5v286v5n p =
  T.ucguard
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fv286v5v286v5n
      (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0))) (h p) ((fx >#^ fv286v5v286v5n) p)
  where
  
  h p =
    T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
      (T.conInteger T.mkNoSrcPos p 1)
  h p = (fx >#^ fv286v5v286v5n) p
  
(*^) fx fv286v5v286v5n p = (fx >#^ fv286v5v286v5n) p

(>#^) fx fn p =
  T.ucguard
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) fn
      (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0)))
    (T.uwrapForward p
      (hf fx
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fn
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 1))) fx p)) ((fx >$^ fn) p)
  where
  
  gf pf p = T.ufun3 a288v27v291v70f pf p hf
  
  af = a288v27v291v70f
  
  hf (z1f@_) fv288v31v288v31n fy p =
    T.ucguard
      (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fv288v31v288v31n
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0))) (h fy p)
      (y1f z1f fv288v31v288v31n fy p)
    where
    
    h fy p = T.projection T.mkNoSrcPos p fy
    h _ p = y1f z1f fv288v31v288v31n fy p
    
  hf z1f fv288v31v288v31n fy p = y1f z1f fv288v31v288v31n fy p
  
  y1f fx fn fy p =
    T.uwrapForward p (hg fx fn p)
    where
    
    gg pg p = T.ufun2 a290v37v291v70g pg p hg
    
    ag = a290v37v291v70g
    
    hg fx fn p =
      T.ucguard (T.uwrapForward p (heven fn p))
        (T.uwrapForward p
          (hg (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fx fx)
            (T.uap2 T.mkNoSrcPos p (gquot T.mkNoSrcPos p) fn
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 2))) p))
        (T.ucguard (gotherwise T.mkNoSrcPos p)
          (T.uwrapForward p
            (hf fx
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fn
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 1)))
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fx fy) p)) (T.fatal p))
    
  
(>#^) fx fn p = (fx >$^ fn) p

(>$^) _ _ p =
  T.uwrapForward p
    (herror (T.fromLitString T.mkNoSrcPos p "Prelude.^: negative exponent") p)

(!^^) ::
  (Fractional a,Integral b) =>
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun b a))

(*^^) :: (Fractional a,Integral b) => (T.R a) -> (T.R b) -> T.RefExp -> T.R a

(!^^) (%^^) p = T.ufun2 (+^^) (%^^) p (*^^)

(*^^) fx fn p =
  T.ucif p
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !>= p) fn
      (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0))) (T.uwrapForward p ((fx *^ fn) p))
    (T.uap1 T.mkNoSrcPos p (grecip T.mkNoSrcPos p)
      (T.uwrapForward p
        ((fx *^ (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fn)) p)))

gfromIntegral ::
  (Integral a,Num b) => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a b)

sfromIntegral :: (Integral a,Num b) => T.R (T.Fun a b)

gfromIntegral pfromIntegral p = T.uconstUse pfromIntegral p sfromIntegral

sfromIntegral =
  T.uconstDef T.mkRoot afromIntegral
    (\ p ->
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p) (gfromInteger T.mkNoSrcPos p)
        (gtoInteger T.mkNoSrcPos p))

grealToFrac ::
  (Real a,Fractional b) => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a b)

srealToFrac :: (Real a,Fractional b) => T.R (T.Fun a b)

grealToFrac prealToFrac p = T.uconstUse prealToFrac p srealToFrac

srealToFrac =
  T.uconstDef T.mkRoot arealToFrac
    (\ p ->
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p) (gfromRational T.mkNoSrcPos p)
        (gtoRational T.mkNoSrcPos p))

class Functor f
  where
  
  gfmap ::
    T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.Fun a b) (T.Fun (f a) (f b)))
  
  sfmap :: T.R (T.Fun (T.Fun a b) (T.Fun (f a) (f b)))
  

class Monad m
  where
  
  (!>>=) ::
    T.RefSrcPos -> T.RefExp -> T.R (T.Fun (m a) (T.Fun (T.Fun a (m b)) (m b)))
  
  (!>>) :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (m a) (T.Fun (m b) (m b)))
  
  greturn :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (m a))
  
  gfail :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun String (m a))
  
  (!>>) (%>>) p =
    T.ufun2 (+%$#=^=%$#=@>>) (%>>) p (*>>)
    where
    
    (*>>) fm fk p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !>>= p) fm
        (T.ufun1 T.mkLambda T.mkNoSrcPos p
          (\ _ p -> T.projection T.mkNoSrcPos p fk))
    
  
  gfail pfail p =
    T.ufun1 a322v5v322v21fail pfail p hfail
    where
    
    hfail fs p = T.uwrapForward p (herror fs p)
    
  
  (|>>=) :: T.R (T.Fun (m a) (T.Fun (T.Fun a (m b)) (m b)))
  
  (|>>) :: T.R (T.Fun (m a) (T.Fun (m b) (m b)))
  
  sreturn :: T.R (T.Fun a (m a))
  
  sfail :: T.R (T.Fun String (m a))
  

gsequence ::
  Monad m =>
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List (m a)) (m (T.List a)))

ssequence :: Monad m => T.R (T.Fun (T.List (m a)) (m (T.List a)))

gsequence psequence p = T.uconstUse psequence p ssequence

ssequence =
  T.uconstDef T.mkRoot asequence
    (\ p ->
      let
        gmcons pmcons p = T.ufun2 a327v27v327v73mcons pmcons p hmcons
        amcons = a327v27v327v73mcons
        hmcons fp fq p =
          T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !>>= p) fp
            (T.ufun1 T.mkLambda T.mkNoSrcPos p
              (\ fx p ->
                T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !>>= p) fq
                  (T.ufun1 T.mkLambda T.mkNoSrcPos p
                    (\ fy p ->
                      T.uap1 T.mkNoSrcPos p (greturn T.mkNoSrcPos p)
                        (T.con2 T.mkNoSrcPos p T.Cons T.aCons
                          (T.projection T.mkNoSrcPos p fx)
                          (T.projection T.mkNoSrcPos p fy)))))) in
        (T.uap2 T.mkNoSrcPos p (gfoldr T.mkNoSrcPos p) (gmcons T.mkNoSrcPos p)
          (T.uap1 T.mkNoSrcPos p (greturn T.mkNoSrcPos p)
            (T.con0 T.mkNoSrcPos p T.List T.aList))))

gsequence_ ::
  Monad m => T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List (m a)) (m T.Tuple0))

ssequence_ :: Monad m => T.R (T.Fun (T.List (m a)) (m T.Tuple0))

gsequence_ psequence_ p = T.uconstUse psequence_ p ssequence_

ssequence_ =
  T.uconstDef T.mkRoot asequence_
    (\ p ->
      T.uap2 T.mkNoSrcPos p (gfoldr T.mkNoSrcPos p) (T.mkNoSrcPos !>> p)
        (T.uap1 T.mkNoSrcPos p (greturn T.mkNoSrcPos p)
          (T.con0 T.mkNoSrcPos p T.Tuple0 T.aTuple0)))

gmapM ::
  Monad m =>
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a (m b)) (T.Fun (T.List a) (m (T.List b))))

hmapM ::
  Monad m =>
  (T.R (T.Fun a (m b))) -> (T.R (T.List a)) -> T.RefExp -> T.R (m (T.List b))

gmapM pmapM p = T.ufun2 amapM pmapM p hmapM

hmapM ff fas p =
  T.uap1 T.mkNoSrcPos p (gsequence T.mkNoSrcPos p)
    (T.uwrapForward p (hmap ff fas p))

gmapM_ ::
  Monad m =>
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a (m b)) (T.Fun (T.List a) (m T.Tuple0)))

hmapM_ ::
  Monad m =>
  (T.R (T.Fun a (m b))) -> (T.R (T.List a)) -> T.RefExp -> T.R (m T.Tuple0)

gmapM_ pmapM_ p = T.ufun2 amapM_ pmapM_ p hmapM_

hmapM_ ff fas p =
  T.uap1 T.mkNoSrcPos p (gsequence_ T.mkNoSrcPos p)
    (T.uwrapForward p (hmap ff fas p))

(!=<<) ::
  Monad m =>
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.Fun a (m b)) (T.Fun (m a) (m b)))

(*=<<) ::
  Monad m => (T.R (T.Fun a (m b))) -> (T.R (m a)) -> T.RefExp -> T.R (m b)

(!=<<) (%=<<) p = T.ufun2 (+=<<) (%=<<) p (*=<<)

(*=<<) ff fx p = T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !>>= p) fx ff

instance Eq (T.Tuple0)
  where
  
  (!==) (%==) p =
    T.ufun2 (+%*&=^=%*&=@==) (%==) p (*==)
    where
    
    (*==) (T.R T.Tuple0 _) (T.R T.Tuple0 _) p = T.con0 T.mkNoSrcPos p True aTrue
    (*==) _ _ p = T.fatal p
    
  

instance Ord (T.Tuple0)
  where
  
  gcompare pcompare p =
    T.ufun2 a357v3v357v22compare pcompare p hcompare
    where
    
    hcompare (T.R T.Tuple0 _) (T.R T.Tuple0 _) p = T.con0 T.mkNoSrcPos p EQ aEQ
    hcompare _ _ p = T.fatal p
    
  

instance Enum (T.Tuple0)
  where
  
  gfromEnum pfromEnum p =
    T.ufun1 a360v3v360v18fromEnum pfromEnum p hfromEnum
    where
    
    hfromEnum (T.R T.Tuple0 _) p =
      T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0)
    hfromEnum _ p = T.fatal p
    
  
  gtoEnum ptoEnum p =
    T.ufun1 a361v3v362v78toEnum ptoEnum p htoEnum
    where
    
    htoEnum fn p =
      T.ucguard
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fn
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 0)))
        (T.con0 T.mkNoSrcPos p T.Tuple0 T.aTuple0) (y1toEnum fn p)
    htoEnum fn p = y1toEnum fn p
    
    y1toEnum fn p =
      T.uwrapForward p
        (herror
          (T.uwrapForward p
            (((T.fromLitString T.mkNoSrcPos p
                  "Prelude.Enum_Prelude.Unit_toEnum on ")
                *++
                (T.uap1 T.mkNoSrcPos p (gshow T.mkNoSrcPos p) fn)) p)) p)
    
  

instance Bounded (T.Tuple0)
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a365v3v365v16minBound
      (\ p -> T.con0 T.mkNoSrcPos p T.Tuple0 T.aTuple0)
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a366v3v366v16maxBound
      (\ p -> T.con0 T.mkNoSrcPos p T.Tuple0 T.aTuple0)
  

gid :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a a)

hid :: (T.R a) -> T.RefExp -> T.R a

gid pid p = T.ufun1 aid pid p hid

hid fx p = T.projection T.mkNoSrcPos p fx

gconst :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun b a))

hconst :: (T.R a) -> (T.R b) -> T.RefExp -> T.R a

gconst pconst p = T.ufun2 aconst pconst p hconst

hconst fx _ p = T.projection T.mkNoSrcPos p fx

(!.) ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun b c) (T.Fun (T.Fun a b) (T.Fun a c)))

(*.) :: (T.R (T.Fun b c)) -> (T.R (T.Fun a b)) -> (T.R a) -> T.RefExp -> T.R c

(!.) (%.) p = T.ufun3 (+.) (%.) p (*.)

(*.) ff fg fx p = T.uap1 T.mkNoSrcPos p ff (T.uap1 T.mkNoSrcPos p fg fx)

gflip ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a (T.Fun b c)) (T.Fun b (T.Fun a c)))

hflip :: (T.R (T.Fun a (T.Fun b c))) -> (T.R b) -> (T.R a) -> T.RefExp -> T.R c

gflip pflip p = T.ufun3 aflip pflip p hflip

hflip ff fx fy p = T.uap2 T.mkNoSrcPos p ff fy fx

(!$),(!$!) :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.Fun a b) (T.Fun a b))

(*$) :: (T.R (T.Fun a b)) -> (T.R a) -> T.RefExp -> T.R b

(*$!) :: (T.R (T.Fun a b)) -> (T.R a) -> T.RefExp -> T.R b

(!$) (%$) p = T.ufun2 (+$) (%$) p (*$)

(*$) ff fx p = T.uap1 T.mkNoSrcPos p ff fx

(!$!) (%$!) p = T.ufun2 (+$!) (%$!) p (*$!)

(*$!) ff fx p = T.uwrapForward p (hseq fx (T.uap1 T.mkNoSrcPos p ff fx) p)

instance Eq (Bool)
  where
  
  (!==) (%==) p =
    T.ufun2 (+&##=>=&#%=#!==) (%==) p (*==)
    where
    
    (*==) (T.R True _) (T.R True _) p = T.con0 T.mkNoSrcPos p True aTrue
    (*==) (T.R False _) (T.R False _) p = T.con0 T.mkNoSrcPos p True aTrue
    (*==) _ _ p = T.con0 T.mkNoSrcPos p False aFalse
    
  

instance Ord (Bool)
  where
  
  gcompare pcompare p =
    T.ufun2 a416v3v419v26compare pcompare p hcompare
    where
    
    hcompare (T.R False _) (T.R False _) p = T.con0 T.mkNoSrcPos p EQ aEQ
    hcompare (T.R False _) (T.R True _) p = T.con0 T.mkNoSrcPos p LT aLT
    hcompare (T.R True _) (T.R False _) p = T.con0 T.mkNoSrcPos p GT aGT
    hcompare (T.R True _) (T.R True _) p = T.con0 T.mkNoSrcPos p EQ aEQ
    hcompare _ _ p = T.fatal p
    
  

instance Enum (Bool)
  where
  
  gfromEnum pfromEnum p =
    T.ufun1 a422v3v423v22fromEnum pfromEnum p hfromEnum
    where
    
    hfromEnum (T.R False _) p =
      T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0)
    hfromEnum (T.R True _) p =
      T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 1)
    hfromEnum _ p = T.fatal p
    
  
  gtoEnum ptoEnum p =
    T.ufun1 a425v3v427v70toEnum ptoEnum p htoEnum
    where
    
    htoEnum fv425v12v425v12n p =
      T.ucguard
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fv425v12v425v12n
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 0))) (h p)
        (y1toEnum fv425v12v425v12n p)
      where
      
      h p = T.con0 T.mkNoSrcPos p False aFalse
      h p = y1toEnum fv425v12v425v12n p
      
    htoEnum fv425v12v425v12n p = y1toEnum fv425v12v425v12n p
    
    y1toEnum fv426v12v426v12n p =
      T.ucguard
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fv426v12v426v12n
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 1))) (h p)
        (y2toEnum fv426v12v426v12n p)
      where
      
      h p = T.con0 T.mkNoSrcPos p True aTrue
      h p = y2toEnum fv426v12v426v12n p
      
    y1toEnum fv426v12v426v12n p = y2toEnum fv426v12v426v12n p
    
    y2toEnum fn p =
      T.uwrapForward p
        (herror
          (T.uwrapForward p
            (((T.fromLitString T.mkNoSrcPos p "(Prelude.toEnum ")
                *++
                (T.uwrapForward p
                  (((T.uap1 T.mkNoSrcPos p (gshow T.mkNoSrcPos p) fn)
                      *++
                      (T.fromLitString T.mkNoSrcPos p " :: Bool) is wrong"))
                    p))) p)) p)
    
  
  genumFrom penumFrom p =
    T.ufun1 a429v3v429v32enumFrom penumFrom p henumFrom
    where
    
    henumFrom fb p =
      T.uap2 T.mkNoSrcPos p (genumFromTo T.mkNoSrcPos p) fb
        (T.con0 T.mkNoSrcPos p True aTrue)
    
  
  genumFromThen penumFromThen p =
    T.ufun2 a430v3v430v53enumFromThen penumFromThen p henumFromThen
    where
    
    henumFromThen fb1 fb2 p =
      T.uap3 T.mkNoSrcPos p (genumFromThenTo T.mkNoSrcPos p) fb1 fb2
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !>= p) fb2 fb1)
    
  

instance Read (Bool)
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a433v3v434v20readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p =
      T.uwrapForward p
        (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
          (T.ufun1 T.mkLambda T.mkNoSrcPos p
            (\ fr p ->
              T.uwrapForward p
                (((T.uap1 T.mkNoSrcPos p
                      (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                        (T.ufun2 T.mkLambda T.mkNoSrcPos p
                          (\ f_x f_y p ->
                            T.uccase T.mkNoSrcPos p
                              (let
                                v0v0v0v0v1
                                  (T.R
                                    (T.Tuple2
                                      (T.R
                                        (T.Cons (T.R 'F' _)
                                          (T.R
                                            (T.Cons (T.R 'a' _)
                                              (T.R
                                                (T.Cons (T.R 'l' _)
                                                  (T.R
                                                    (T.Cons (T.R 's' _)
                                                      (T.R
                                                        (T.Cons (T.R 'e' _)
                                                          (T.R T.List _)) _))
                                                    _)) _)) _)) _) fs) _) p =
                                  T.uap1 T.mkNoSrcPos p
                                    (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                                      (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                                        (T.con0 T.mkNoSrcPos p False aFalse)
                                        fs)) f_y
                                v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y
                                in (v0v0v0v0v1)) f_x))
                        (T.uwrapForward p (hlex fr p)))
                      (T.fromExpList T.mkNoSrcPos p []))
                    *++
                    (T.uap1 T.mkNoSrcPos p
                      (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                        (T.ufun2 T.mkLambda T.mkNoSrcPos p
                          (\ f_x f_y p ->
                            T.uccase T.mkNoSrcPos p
                              (let
                                v0v0v0v0v1
                                  (T.R
                                    (T.Tuple2
                                      (T.R
                                        (T.Cons (T.R 'T' _)
                                          (T.R
                                            (T.Cons (T.R 'r' _)
                                              (T.R
                                                (T.Cons (T.R 'u' _)
                                                  (T.R
                                                    (T.Cons (T.R 'e' _)
                                                      (T.R T.List _)) _)) _))
                                            _)) _) fs) _) p =
                                  T.uap1 T.mkNoSrcPos p
                                    (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                                      (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                                        (T.con0 T.mkNoSrcPos p True aTrue) fs))
                                    f_y
                                v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y
                                in (v0v0v0v0v1)) f_x))
                        (T.uwrapForward p (hlex fr p)))
                      (T.fromExpList T.mkNoSrcPos p []))) p))) p)
    
  

instance Show (Bool)
  where
  
  gshowsPrec pshowsPrec p =
    T.ufun2 a438v3v439v38showsPrec pshowsPrec p hshowsPrec
    where
    
    hshowsPrec fp (T.R False _) p =
      T.uap1 T.mkNoSrcPos p (gshowString T.mkNoSrcPos p)
        (T.fromLitString T.mkNoSrcPos p "False")
    hshowsPrec fp (T.R True _) p =
      T.uap1 T.mkNoSrcPos p (gshowString T.mkNoSrcPos p)
        (T.fromLitString T.mkNoSrcPos p "True")
    hshowsPrec _ _ p = T.fatal p
    
  

instance Bounded (Bool)
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a442v3v442v18minBound
      (\ p -> T.con0 T.mkNoSrcPos p False aFalse)
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a443v3v443v17maxBound
      (\ p -> T.con0 T.mkNoSrcPos p True aTrue)
  

(!&&),(!||) :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Bool (T.Fun Bool Bool))

(*&&) :: (T.R Bool) -> (T.R Bool) -> T.RefExp -> T.R Bool

(*||) :: (T.R Bool) -> (T.R Bool) -> T.RefExp -> T.R Bool

(!&&) (%&&) p = T.ufun2 (+&&) (%&&) p (*&&)

(*&&) (T.R True _) fx p = T.projection T.mkNoSrcPos p fx
(*&&) (T.R False _) _ p = T.con0 T.mkNoSrcPos p False aFalse
(*&&) _ _ p = T.fatal p

(!||) (%||) p = T.ufun2 (+||) (%||) p (*||)

(*||) (T.R True _) _ p = T.con0 T.mkNoSrcPos p True aTrue
(*||) (T.R False _) fx p = T.projection T.mkNoSrcPos p fx
(*||) _ _ p = T.fatal p

gnot :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Bool Bool)

hnot :: (T.R Bool) -> T.RefExp -> T.R Bool

gnot pnot p = T.ufun1 anot pnot p hnot

hnot (T.R True _) p = T.con0 T.mkNoSrcPos p False aFalse
hnot (T.R False _) p = T.con0 T.mkNoSrcPos p True aTrue
hnot _ p = T.fatal p

gotherwise :: T.RefSrcPos -> T.RefExp -> T.R Bool

sotherwise :: T.R Bool

gotherwise potherwise p = T.uconstUse potherwise p sotherwise

sotherwise =
  T.uconstDef T.mkRoot aotherwise (\ p -> T.con0 T.mkNoSrcPos p True aTrue)

instance Eq (Char)
  where
  
  (!==) (%==) p =
    T.ufun2 (+&^$=^=&^$=@==) (%==) p (*==)
    where
    
    (*==) fc fc' p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p)
        (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fc)
        (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fc')
    
  

instance Ord (Char)
  where
  
  (!<=) (%<=) p =
    T.ufun2 (+&^+=^=&^+=@<=) (%<=) p (*<=)
    where
    
    (*<=) fc fc' p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !<= p)
        (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fc)
        (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fc')
    
  

instance Enum (Char)
  where
  
  gtoEnum ptoEnum p = T.uconstUse ptoEnum p stoEnum
  
  stoEnum =
    T.uconstDef T.mkRoot a480v5v480v37toEnum
      (\ p -> gprimIntToChar T.mkNoSrcPos p)
  
  gfromEnum pfromEnum p = T.uconstUse pfromEnum p sfromEnum
  
  sfromEnum =
    T.uconstDef T.mkRoot a481v5v481v37fromEnum
      (\ p -> gprimCharToInt T.mkNoSrcPos p)
  
  genumFrom penumFrom p =
    T.ufun1 a482v5v482v36enumFrom penumFrom p henumFrom
    where
    
    henumFrom fc p =
      T.uwrapForward p
        (hmap (gtoEnum T.mkNoSrcPos p)
          (T.uap2 T.mkNoSrcPos p (genumFromTo T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fc)
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p)
              (gmaxBound T.mkNoSrcPos p :: T.R Char))) p)
    
  
  genumFromThen penumFromThen p =
    T.ufun2 a483v5v486v59enumFromThen penumFromThen p henumFromThen
    where
    
    henumFromThen fc fc' p =
      T.uwrapForward p
        (hmap (gtoEnum T.mkNoSrcPos p)
          (T.uap3 T.mkNoSrcPos p (genumFromThenTo T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fc)
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fc')
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p)
              (glastChar T.mkNoSrcPos p))) p)
      where
      
      glastChar :: T.RefSrcPos -> T.RefExp -> T.R Char
      
      slastChar :: T.R Char
      
      glastChar plastChar p = T.uconstUse plastChar p slastChar
      
      slastChar =
        T.uconstDef p a485v29v486v59lastChar
          (\ p ->
            T.ucguard (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p) fc' fc)
              (gminBound T.mkNoSrcPos p)
              (T.ucguard (gotherwise T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
                (T.fatal p)))
      
    
  

instance Bounded (Char)
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a490v5v490v31minBound
      (\ p -> T.conChar T.mkNoSrcPos p '\o000')
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a491v5v491v46maxBound
      (\ p -> gprimUnicodeMaxBound T.mkNoSrcPos p)
  

data Maybe a = Nothing  | Just (T.R a)

instance T.WrapVal ((Maybe a))
  where
  
  wrapVal pwrapVal (kwrapVal@Nothing) p =
    T.R kwrapVal (T.mkValueUse p pwrapVal aNothing)
  wrapVal pwrapVal (kwrapVal@(Just (T.R _ z1wrapVal))) p =
    T.R kwrapVal (T.mkValueApp1 p pwrapVal aJust z1wrapVal)
  

instance Eq a => Eq ((Maybe a))
  where
  
  (!==) (%==) p =
    T.ufun2 (+*!!=*#=*!!=*$==) (%==) p (*==)
    where
    
    (*==) (T.R Nothing _) (T.R Nothing _) p = T.con0 T.mkNoSrcPos p True aTrue
    (*==) (T.R (Just fy1) _) (T.R (Just fy2) _) p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fy1 fy2
    (*==) _ _ p = T.con0 T.mkNoSrcPos p False aFalse
    
  

instance Ord a => Ord ((Maybe a))
  where
  
  gcompare pcompare p =
    T.ufun2 a500v55v500v57compare pcompare p hcompare
    where
    
    hcompare (T.R (Just fy3) _) (T.R (Just fy4) _) p =
      T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fy3 fy4
    hcompare fy1 fy2 p =
      T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p)
        (T.uwrapForward p (hlocalFromEnum fy1 p) :: T.R Int)
        (T.uwrapForward p (hlocalFromEnum fy2 p))
      where
      
      glocalFromEnum plocalFromEnum p =
        T.ufun1 a500v55v500v57localFromEnum plocalFromEnum p hlocalFromEnum
      
      alocalFromEnum = a500v55v500v57localFromEnum
      
      hlocalFromEnum (T.R (Nothing) _) p =
        T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0)
      hlocalFromEnum (T.R (Just _) _) p =
        T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 1)
      hlocalFromEnum _ p = T.fatal p
      
    
  

instance Read a => Read ((Maybe a))
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a500v60v500v63readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fy1 p =
      T.uap2 T.mkNoSrcPos p (Hat.PreludeBasic.galt T.mkNoSrcPos p)
        (T.uwrapForward p
          (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
            (T.uwrapForward p
              (Hat.PreludeBasic.hthenLex
                (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gyield T.mkNoSrcPos p)
                  (T.con0 T.mkNoSrcPos p Nothing aNothing))
                (T.fromLitString T.mkNoSrcPos p "Nothing") p)) p))
        (T.uwrapForward p
          (hreadParen
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) fy1
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 9)))
            (T.uap2 T.mkNoSrcPos p (Hat.PreludeBasic.gthenAp T.mkNoSrcPos p)
              (T.uwrapForward p
                (Hat.PreludeBasic.hthenLex
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gyield T.mkNoSrcPos p)
                    (T.pa0 Just T.cn1 T.mkNoSrcPos p aJust))
                  (T.fromLitString T.mkNoSrcPos p "Just") p))
              (T.uap1 T.mkNoSrcPos p (greadsPrec T.mkNoSrcPos p)
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 10)))) p))
    
  

instance Show a => Show ((Maybe a))
  where
  
  gshowsPrec pshowsPrec p =
    T.ufun2 a500v66v500v69showsPrec pshowsPrec p hshowsPrec
    where
    
    hshowsPrec fy1 (T.R (Nothing) _) p =
      T.uap1 T.mkNoSrcPos p (gshowString T.mkNoSrcPos p)
        (T.fromLitString T.mkNoSrcPos p "Nothing")
    hshowsPrec fy1 (T.R (Just fy2) _) p =
      T.uwrapForward p
        (hshowParen
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) fy1
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 9)))
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
            (T.uap1 T.mkNoSrcPos p (gshowString T.mkNoSrcPos p)
              (T.fromLitString T.mkNoSrcPos p "Just "))
            (T.uap2 T.mkNoSrcPos p (gshowsPrec T.mkNoSrcPos p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 10)) fy2)) p)
    hshowsPrec _ _ p = T.fatal p
    
  

gmaybe ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun b (T.Fun (T.Fun a b) (T.Fun (Maybe a) b)))

hmaybe :: (T.R b) -> (T.R (T.Fun a b)) -> (T.R (Maybe a)) -> T.RefExp -> T.R b

gmaybe pmaybe p = T.ufun3 amaybe pmaybe p hmaybe

hmaybe fn ff (T.R Nothing _) p = T.projection T.mkNoSrcPos p fn
hmaybe fn ff (T.R (Just fx) _) p = T.uap1 T.mkNoSrcPos p ff fx
hmaybe _ _ _ p = T.fatal p

instance Functor (Maybe)
  where
  
  gfmap pfmap p =
    T.ufun2 a509v5v510v34fmap pfmap p hfmap
    where
    
    hfmap ff (T.R Nothing _) p = T.con0 T.mkNoSrcPos p Nothing aNothing
    hfmap ff (T.R (Just fx) _) p =
      T.con1 T.mkNoSrcPos p Just aJust (T.uap1 T.mkNoSrcPos p ff fx)
    hfmap _ _ p = T.fatal p
    
  

instance Monad (Maybe)
  where
  
  (!>>=) (%>>=) p =
    T.ufun2 (+*#&=#&=*#*=#+>>=) (%>>=) p (*>>=)
    where
    
    (*>>=) (T.R (Just fx) _) fk p = T.uap1 T.mkNoSrcPos p fk fx
    (*>>=) (T.R Nothing _) fk p = T.con0 T.mkNoSrcPos p Nothing aNothing
    (*>>=) _ _ p = T.fatal p
    
  
  greturn preturn p = T.uconstUse preturn p sreturn
  
  sreturn =
    T.uconstDef T.mkRoot a516v5v516v28return
      (\ p -> T.pa0 Just T.cn1 T.mkNoSrcPos p aJust)
  
  gfail pfail p =
    T.ufun1 a517v5v517v31fail pfail p hfail
    where
    
    hfail fs p = T.con0 T.mkNoSrcPos p Nothing aNothing
    
  

data Either a b = Left (T.R a) | Right (T.R b)

instance T.WrapVal ((Either a b))
  where
  
  wrapVal pwrapVal (kwrapVal@(Left (T.R _ z1wrapVal))) p =
    T.R kwrapVal (T.mkValueApp1 p pwrapVal aLeft z1wrapVal)
  wrapVal pwrapVal (kwrapVal@(Right (T.R _ z1wrapVal))) p =
    T.R kwrapVal (T.mkValueApp1 p pwrapVal aRight z1wrapVal)
  

instance (Eq a,Eq b) => Eq ((Either a b))
  where
  
  (!==) (%==) p =
    T.ufun2 (+*$$=*#=*$$=*$==) (%==) p (*==)
    where
    
    (*==) (T.R (Left fy1) _) (T.R (Left fy2) _) p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fy1 fy2
    (*==) (T.R (Right fy1) _) (T.R (Right fy2) _) p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fy1 fy2
    (*==) _ _ p = T.con0 T.mkNoSrcPos p False aFalse
    
  

instance (Ord a,Ord b) => Ord ((Either a b))
  where
  
  gcompare pcompare p =
    T.ufun2 a522v55v522v57compare pcompare p hcompare
    where
    
    hcompare (T.R (Left fy3) _) (T.R (Left fy4) _) p =
      T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fy3 fy4
    hcompare (T.R (Right fy3) _) (T.R (Right fy4) _) p =
      T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fy3 fy4
    hcompare fy1 fy2 p =
      T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p)
        (T.uwrapForward p (hlocalFromEnum fy1 p) :: T.R Int)
        (T.uwrapForward p (hlocalFromEnum fy2 p))
      where
      
      glocalFromEnum plocalFromEnum p =
        T.ufun1 a522v55v522v57localFromEnum plocalFromEnum p hlocalFromEnum
      
      alocalFromEnum = a522v55v522v57localFromEnum
      
      hlocalFromEnum (T.R (Left _) _) p =
        T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0)
      hlocalFromEnum (T.R (Right _) _) p =
        T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 1)
      hlocalFromEnum _ p = T.fatal p
      
    
  

instance (Read a,Read b) => Read ((Either a b))
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a522v60v522v63readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fy1 p =
      T.uap2 T.mkNoSrcPos p (Hat.PreludeBasic.galt T.mkNoSrcPos p)
        (T.uwrapForward p
          (hreadParen
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) fy1
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 9)))
            (T.uap2 T.mkNoSrcPos p (Hat.PreludeBasic.gthenAp T.mkNoSrcPos p)
              (T.uwrapForward p
                (Hat.PreludeBasic.hthenLex
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gyield T.mkNoSrcPos p)
                    (T.pa0 Left T.cn1 T.mkNoSrcPos p aLeft))
                  (T.fromLitString T.mkNoSrcPos p "Left") p))
              (T.uap1 T.mkNoSrcPos p (greadsPrec T.mkNoSrcPos p)
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 10)))) p))
        (T.uwrapForward p
          (hreadParen
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) fy1
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 9)))
            (T.uap2 T.mkNoSrcPos p (Hat.PreludeBasic.gthenAp T.mkNoSrcPos p)
              (T.uwrapForward p
                (Hat.PreludeBasic.hthenLex
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gyield T.mkNoSrcPos p)
                    (T.pa0 Right T.cn1 T.mkNoSrcPos p aRight))
                  (T.fromLitString T.mkNoSrcPos p "Right") p))
              (T.uap1 T.mkNoSrcPos p (greadsPrec T.mkNoSrcPos p)
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 10)))) p))
    
  

instance (Show a,Show b) => Show ((Either a b))
  where
  
  gshowsPrec pshowsPrec p =
    T.ufun2 a522v66v522v69showsPrec pshowsPrec p hshowsPrec
    where
    
    hshowsPrec fy1 (T.R (Left fy2) _) p =
      T.uwrapForward p
        (hshowParen
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) fy1
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 9)))
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
            (T.uap1 T.mkNoSrcPos p (gshowString T.mkNoSrcPos p)
              (T.fromLitString T.mkNoSrcPos p "Left "))
            (T.uap2 T.mkNoSrcPos p (gshowsPrec T.mkNoSrcPos p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 10)) fy2)) p)
    hshowsPrec fy1 (T.R (Right fy2) _) p =
      T.uwrapForward p
        (hshowParen
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) fy1
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 9)))
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
            (T.uap1 T.mkNoSrcPos p (gshowString T.mkNoSrcPos p)
              (T.fromLitString T.mkNoSrcPos p "Right "))
            (T.uap2 T.mkNoSrcPos p (gshowsPrec T.mkNoSrcPos p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 10)) fy2)) p)
    hshowsPrec _ _ p = T.fatal p
    
  

geither ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun (T.Fun a c) (T.Fun (T.Fun b c) (T.Fun (Either a b) c)))

heither ::
  (T.R (T.Fun a c)) ->
    (T.R (T.Fun b c)) -> (T.R (Either a b)) -> T.RefExp -> T.R c

geither peither p = T.ufun3 aeither peither p heither

heither ff fg (T.R (Left fx) _) p = T.uap1 T.mkNoSrcPos p ff fx
heither ff fg (T.R (Right fy) _) p = T.uap1 T.mkNoSrcPos p fg fy
heither _ _ _ p = T.fatal p

instance Functor (IO)
  where
  
  gfmap pfmap p =
    T.ufun2 a536v4v536v42fmap pfmap p hfmap
    where
    
    hfmap ff fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !>>= p) fx
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p) (greturn T.mkNoSrcPos p) ff)
    
  

instance Monad (IO)
  where
  
  (!>>=) (%>>=) p = T.uconstUse (%>>=) p (|>>=)
  
  (|>>=) =
    T.uconstDef T.mkRoot (+*&!=*=*&!=$$>>=) (\ p -> gprimIOBind T.mkNoSrcPos p)
  
  greturn preturn p = T.uconstUse preturn p sreturn
  
  sreturn =
    T.uconstDef T.mkRoot a541v4v541v24return
      (\ p -> gprimIOReturn T.mkNoSrcPos p)
  
  gfail pfail p =
    T.ufun1 a542v4v542v32fail pfail p hfail
    where
    
    hfail fs p =
      T.uwrapForward p (hioError (T.uwrapForward p (huserError fs p)) p)
    
  

data Ordering = LT  | EQ  | GT 

instance T.WrapVal (Ordering)
  where
  
  wrapVal pwrapVal (kwrapVal@LT) p = T.R kwrapVal (T.mkValueUse p pwrapVal aLT)
  wrapVal pwrapVal (kwrapVal@EQ) p = T.R kwrapVal (T.mkValueUse p pwrapVal aEQ)
  wrapVal pwrapVal (kwrapVal@GT) p = T.R kwrapVal (T.mkValueUse p pwrapVal aGT)
  

instance Eq (Ordering)
  where
  
  (!==) (%==) p =
    T.ufun2 (+*&@=$#=*&@=$$==) (%==) p (*==)
    where
    
    (*==) (T.R LT _) (T.R LT _) p = T.con0 T.mkNoSrcPos p True aTrue
    (*==) (T.R EQ _) (T.R EQ _) p = T.con0 T.mkNoSrcPos p True aTrue
    (*==) (T.R GT _) (T.R GT _) p = T.con0 T.mkNoSrcPos p True aTrue
    (*==) _ _ p = T.con0 T.mkNoSrcPos p False aFalse
    
  

instance Ord (Ordering)
  where
  
  gcompare pcompare p =
    T.ufun2 a548v25v548v27compare pcompare p hcompare
    where
    
    hcompare fy1 fy2 p =
      T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p)
        (T.uwrapForward p (hlocalFromEnum fy1 p) :: T.R Int)
        (T.uwrapForward p (hlocalFromEnum fy2 p))
      where
      
      glocalFromEnum plocalFromEnum p =
        T.ufun1 a548v25v548v27localFromEnum plocalFromEnum p hlocalFromEnum
      
      alocalFromEnum = a548v25v548v27localFromEnum
      
      hlocalFromEnum (T.R (LT) _) p =
        T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0)
      hlocalFromEnum (T.R (EQ) _) p =
        T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 1)
      hlocalFromEnum (T.R (GT) _) p =
        T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 2)
      hlocalFromEnum _ p = T.fatal p
      
    
  

instance Enum (Ordering)
  where
  
  gfromEnum pfromEnum p =
    T.ufun1 a548v30v548v33fromEnum pfromEnum p hfromEnum
    where
    
    hfromEnum (T.R LT _) p =
      T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0)
    hfromEnum (T.R EQ _) p =
      T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 1)
    hfromEnum (T.R GT _) p =
      T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 2)
    hfromEnum _ p = T.fatal p
    
  
  gtoEnum ptoEnum p =
    T.ufun1 a548v30v548v33toEnum ptoEnum p htoEnum
    where
    
    htoEnum fv548v30v548v33n p =
      T.ucguard
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fv548v30v548v33n
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 0))) (h p)
        (y1toEnum fv548v30v548v33n p)
      where
      
      h p = T.con0 T.mkNoSrcPos p LT aLT
      h p = y1toEnum fv548v30v548v33n p
      
    htoEnum fv548v30v548v33n p = y1toEnum fv548v30v548v33n p
    
    y1toEnum fv548v30v548v33n p =
      T.ucguard
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fv548v30v548v33n
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 1))) (h p)
        (y2toEnum fv548v30v548v33n p)
      where
      
      h p = T.con0 T.mkNoSrcPos p EQ aEQ
      h p = y2toEnum fv548v30v548v33n p
      
    y1toEnum fv548v30v548v33n p = y2toEnum fv548v30v548v33n p
    
    y2toEnum fv548v30v548v33n p =
      T.ucguard
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fv548v30v548v33n
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 2))) (h p)
        (y3toEnum fv548v30v548v33n p)
      where
      
      h p = T.con0 T.mkNoSrcPos p GT aGT
      h p = y3toEnum fv548v30v548v33n p
      
    y2toEnum fv548v30v548v33n p = y3toEnum fv548v30v548v33n p
    
    y3toEnum _ p =
      T.uwrapForward p
        (herror
          (T.fromLitString T.mkNoSrcPos p "toEnum: argument out of bounds") p)
    
  
  genumFrom penumFrom p =
    T.ufun1 a548v30v548v33enumFrom penumFrom p henumFrom
    where
    
    henumFrom fy1 p =
      T.uap2 T.mkNoSrcPos p (genumFromTo T.mkNoSrcPos p) fy1
        (T.con0 T.mkNoSrcPos p GT aGT)
    
  
  genumFromThen penumFromThen p =
    T.ufun2 a548v30v548v33enumFromThen penumFromThen p henumFromThen
    where
    
    henumFromThen fy1 fy2 p =
      T.uap3 T.mkNoSrcPos p (genumFromThenTo T.mkNoSrcPos p) fy1 fy2
        (T.ucif p
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !>= p)
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fy1)
            (T.uap1 T.mkNoSrcPos p (gfromEnum T.mkNoSrcPos p) fy2))
          (T.con0 T.mkNoSrcPos p GT aGT) (T.con0 T.mkNoSrcPos p LT aLT))
    
  

instance Read (Ordering)
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a548v36v548v39readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fy1 p =
      T.uap2 T.mkNoSrcPos p (Hat.PreludeBasic.galt T.mkNoSrcPos p)
        (T.uwrapForward p
          (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
            (T.uwrapForward p
              (Hat.PreludeBasic.hthenLex
                (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gyield T.mkNoSrcPos p)
                  (T.con0 T.mkNoSrcPos p LT aLT))
                (T.fromLitString T.mkNoSrcPos p "LT") p)) p))
        (T.uap2 T.mkNoSrcPos p (Hat.PreludeBasic.galt T.mkNoSrcPos p)
          (T.uwrapForward p
            (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
              (T.uwrapForward p
                (Hat.PreludeBasic.hthenLex
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gyield T.mkNoSrcPos p)
                    (T.con0 T.mkNoSrcPos p EQ aEQ))
                  (T.fromLitString T.mkNoSrcPos p "EQ") p)) p))
          (T.uwrapForward p
            (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
              (T.uwrapForward p
                (Hat.PreludeBasic.hthenLex
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gyield T.mkNoSrcPos p)
                    (T.con0 T.mkNoSrcPos p GT aGT))
                  (T.fromLitString T.mkNoSrcPos p "GT") p)) p)))
    
  

instance Show (Ordering)
  where
  
  gshowsPrec pshowsPrec p =
    T.ufun2 a548v42v548v45showsPrec pshowsPrec p hshowsPrec
    where
    
    hshowsPrec fy1 (T.R (LT) _) p =
      T.uap1 T.mkNoSrcPos p (gshowString T.mkNoSrcPos p)
        (T.fromLitString T.mkNoSrcPos p "LT")
    hshowsPrec fy1 (T.R (EQ) _) p =
      T.uap1 T.mkNoSrcPos p (gshowString T.mkNoSrcPos p)
        (T.fromLitString T.mkNoSrcPos p "EQ")
    hshowsPrec fy1 (T.R (GT) _) p =
      T.uap1 T.mkNoSrcPos p (gshowString T.mkNoSrcPos p)
        (T.fromLitString T.mkNoSrcPos p "GT")
    hshowsPrec _ _ p = T.fatal p
    
  

instance Bounded (Ordering)
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a548v48v548v54minBound
      (\ p -> T.con0 T.mkNoSrcPos p LT aLT)
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a548v48v548v54maxBound
      (\ p -> T.con0 T.mkNoSrcPos p GT aGT)
  

instance Eq (Int)
  where
  
  (!==) (%==) p =
    T.ufun2 (+**>=*=**>=+==) (%==) p (*==)
    where
    
    (*==) fa fb p = T.uwrapForward p (hprimIntEq fa fb p)
    
  
  (!/=) (%/=) p =
    T.ufun2 (+*+!=*=*+!=+/=) (%/=) p (*/=)
    where
    
    (*/=) fa fb p = T.uwrapForward p (hprimIntNe fa fb p)
    
  

instance Ord (Int)
  where
  
  (!<) (%<) p =
    T.ufun2 (+*+%=*=*+%=*<) (%<) p (*<)
    where
    
    (*<) fa fb p = T.uwrapForward p (hprimIntLt fa fb p)
    
  
  (!<=) (%<=) p =
    T.ufun2 (+*+&=*=*+&=+<=) (%<=) p (*<=)
    where
    
    (*<=) fa fb p = T.uwrapForward p (hprimIntLe fa fb p)
    
  
  (!>=) (%>=) p =
    T.ufun2 (+*+*=*=*+*=+>=) (%>=) p (*>=)
    where
    
    (*>=) fa fb p = T.uwrapForward p (hprimIntGe fa fb p)
    
  
  (!>) (%>) p =
    T.ufun2 (+*++=*=*++=*>) (%>) p (*>)
    where
    
    (*>) fa fb p = T.uwrapForward p (hprimIntGt fa fb p)
    
  

instance Num (Int)
  where
  
  (!+) (%+) p =
    T.ufun2 (+*+>=&=*+>=&+) (%+) p (*+)
    where
    
    (*+) fa fb p = T.uwrapForward p (hprimIntPlus fa fb p)
    
  
  (!-) (%-) p =
    T.ufun2 (+*^!=&=*^!=&-) (%-) p (*-)
    where
    
    (*-) fa fb p = T.uwrapForward p (hprimIntMinus fa fb p)
    
  
  (!*) (%*) p =
    T.ufun2 (+*^#=&=*^#=&*) (%*) p (**)
    where
    
    (**) fa fb p = T.uwrapForward p (hprimIntTimes fa fb p)
    
  
  gnegate pnegate p =
    T.ufun1 a572v2v572v27negate pnegate p hnegate
    where
    
    hnegate fa p = T.uwrapForward p (hprimIntNegate fa p)
    
  
  gabs pabs p =
    T.ufun1 a573v2v573v24abs pabs p habs
    where
    
    habs fa p = T.uwrapForward p (hprimIntAbs fa p)
    
  
  gsignum psignum p =
    T.ufun1 a574v2v574v27signum psignum p hsignum
    where
    
    hsignum fa p = T.uwrapForward p (hprimIntSignum fa p)
    
  
  gfromInteger pfromInteger p =
    T.ufun1 a575v2v575v37fromInteger pfromInteger p hfromInteger
    where
    
    hfromInteger fi p = T.uwrapForward p (hprimIntFromInteger fi p)
    
  

instance Real (Int)
  where
  
  gtoRational ptoRational p =
    T.ufun1 a578v5v578v36toRational ptoRational p htoRational
    where
    
    htoRational fi p =
      T.uwrapForward p
        (((T.uap1 T.mkNoSrcPos p (gtoInteger T.mkNoSrcPos p) fi)
            *%
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 1))) p)
    
  

instance Integral (Int)
  where
  
  gquot pquot p =
    T.ufun2 a581v8v581v11quot pquot p hquot
    where
    
    hquot fn fd p = T.uwrapForward p (hprimIntQuot fn fd p)
    
  
  grem prem p =
    T.ufun2 a582v8v582v10rem prem p hrem
    where
    
    hrem fn fd p = T.uwrapForward p (hprimIntRem fn fd p)
    
  
  gquotRem pquotRem p =
    T.ufun2 a583v8v583v14quotRem pquotRem p hquotRem
    where
    
    hquotRem fn fd p =
      T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
        (T.uap2 T.mkNoSrcPos p (gquot T.mkNoSrcPos p) fn fd)
        (T.uap2 T.mkNoSrcPos p (grem T.mkNoSrcPos p) fn fd)
    
  
  gtoInteger ptoInteger p =
    T.ufun1 a585v5v585v46toInteger ptoInteger p htoInteger
    where
    
    htoInteger fn p = T.uwrapForward p (hprimIntegerFromInt fn p)
    
  

instance Enum (Int)
  where
  
  gtoEnum ptoEnum p = T.uconstUse ptoEnum p stoEnum
  
  stoEnum = T.uconstDef T.mkRoot a588v3v588v13toEnum (\ p -> gid T.mkNoSrcPos p)
  
  gfromEnum pfromEnum p = T.uconstUse pfromEnum p sfromEnum
  
  sfromEnum =
    T.uconstDef T.mkRoot a589v3v589v15fromEnum (\ p -> gid T.mkNoSrcPos p)
  
  genumFrom penumFrom p =
    T.ufun1 a591v3v591v36enumFrom penumFrom p henumFrom
    where
    
    henumFrom fx p =
      T.uap2 T.mkNoSrcPos p (genumFromTo T.mkNoSrcPos p) fx
        (gmaxBound T.mkNoSrcPos p)
    
  
  genumFromThen penumFromThen p =
    T.ufun2 a592v3v592v78enumFromThen penumFromThen p henumFromThen
    where
    
    henumFromThen fx fy p =
      T.uap3 T.mkNoSrcPos p (genumFromThenTo T.mkNoSrcPos p) fx fy
        (T.ucif p (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !>= p) fy fx)
          (gmaxBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p))
    
  
  genumFromTo penumFromTo p =
    T.ufun2 a593v3v593v40enumFromTo penumFromTo p henumFromTo
    where
    
    henumFromTo fn fm p =
      T.uwrapForward p
        (hintEnumFromByTo fn
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 1)) fm p)
    
  
  genumFromThenTo penumFromThenTo p =
    T.ufun3 a594v3v594v52enumFromThenTo penumFromThenTo p henumFromThenTo
    where
    
    henumFromThenTo fn fn' fm p =
      T.uwrapForward p
        (hintEnumFromByTo fn (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fn' fn)
          fm p)
    
  

gintEnumFromByTo ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun Int (T.Fun Int (T.Fun Int (T.List Int))))

hintEnumFromByTo ::
  (T.R Int) -> (T.R Int) -> (T.R Int) -> T.RefExp -> T.R (T.List Int)

gintEnumFromByTo pintEnumFromByTo p =
  T.ufun3 aintEnumFromByTo pintEnumFromByTo p hintEnumFromByTo

hintEnumFromByTo fn fd fm p =
  T.uccase T.mkNoSrcPos p
    (let
      v600v3v603v45v1 (T.R GT _) p =
        T.ucif p (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) fn fm)
          (T.con0 T.mkNoSrcPos p T.List T.aList)
          (T.uwrapForward p
            (hgo
              (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !<= p)
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fm fd)) fn p))
      v600v3v603v45v1 (T.R EQ _) p = T.uwrapForward p (hrepeat fn p)
      v600v3v603v45v1 (T.R LT _) p =
        T.ucif p (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p) fn fm)
          (T.con0 T.mkNoSrcPos p T.List T.aList)
          (T.uwrapForward p
            (hgo
              (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !>= p)
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fm fd)) fn p))
      v600v3v603v45v1 _ p = T.fatal p in (v600v3v603v45v1))
    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fd
      (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0)))
  where
  
  ggo ::
    T.RefSrcPos ->
      T.RefExp -> T.R (T.Fun (T.Fun Int Bool) (T.Fun Int (T.List Int)))
  
  hgo :: (T.R (T.Fun Int Bool)) -> (T.R Int) -> T.RefExp -> T.R (T.List Int)
  
  ggo pgo p = T.ufun2 a606v3v606v68go pgo p hgo
  
  ago = a606v3v606v68go
  
  hgo fcontinue fn p =
    T.con2 T.mkNoSrcPos p T.Cons T.aCons fn
      (T.ucif p (T.uap1 T.mkNoSrcPos p fcontinue fn)
        (T.uwrapForward p
          (hgo fcontinue (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fn fd) p))
        (T.con0 T.mkNoSrcPos p T.List T.aList))
  

instance Bounded (Int)
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a610v3v610v28minBound
      (\ p -> gprimIntMinBound T.mkNoSrcPos p)
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a611v3v611v28maxBound
      (\ p -> gprimIntMaxBound T.mkNoSrcPos p)
  

instance Eq (Integer)
  where
  
  (!==) (%==) p =
    T.ufun2 (++#^=*=+#^=+==) (%==) p (*==)
    where
    
    (*==) fa fb p = T.uwrapForward p (hprimIntegerEq fa fb p)
    
  
  (!/=) (%/=) p =
    T.ufun2 (++#@=*=+#@=+/=) (%/=) p (*/=)
    where
    
    (*/=) fa fb p = T.uwrapForward p (hprimIntegerNe fa fb p)
    
  

instance Ord (Integer)
  where
  
  (!<) (%<) p =
    T.ufun2 (++$#=*=+$#=*<) (%<) p (*<)
    where
    
    (*<) fa fb p = T.uwrapForward p (hprimIntegerLt fa fb p)
    
  
  (!<=) (%<=) p =
    T.ufun2 (++$$=*=+$$=+<=) (%<=) p (*<=)
    where
    
    (*<=) fa fb p = T.uwrapForward p (hprimIntegerLe fa fb p)
    
  
  (!>=) (%>=) p =
    T.ufun2 (++$%=*=+$%=+>=) (%>=) p (*>=)
    where
    
    (*>=) fa fb p = T.uwrapForward p (hprimIntegerGe fa fb p)
    
  
  (!>) (%>) p =
    T.ufun2 (++$&=*=+$&=*>) (%>) p (*>)
    where
    
    (*>) fa fb p = T.uwrapForward p (hprimIntegerGt fa fb p)
    
  

instance Num (Integer)
  where
  
  (!+) (%+) p =
    T.ufun2 (++$^=&=+$^=&+) (%+) p (*+)
    where
    
    (*+) fa fb p = T.uwrapForward p (hprimIntegerAdd fa fb p)
    
  
  (!-) (%-) p =
    T.ufun2 (++$@=&=+$@=&-) (%-) p (*-)
    where
    
    (*-) fa fb p = T.uwrapForward p (hprimIntegerSub fa fb p)
    
  
  (!*) (%*) p =
    T.ufun2 (++$>=&=+$>=&*) (%*) p (**)
    where
    
    (**) fa fb p = T.uwrapForward p (hprimIntegerMul fa fb p)
    
  
  gnegate pnegate p =
    T.ufun1 a630v2v630v28negate pnegate p hnegate
    where
    
    hnegate fa p = T.uwrapForward p (hprimIntegerNeg fa p)
    
  
  gabs pabs p =
    T.ufun1 a631v2v631v41abs pabs p habs
    where
    
    habs fi p =
      T.ucif p
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p) fi
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 0)))
        (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fi)
        (T.projection T.mkNoSrcPos p fi)
    
  
  gsignum psignum p =
    T.ufun1 a632v2v635v24signum psignum p hsignum
    where
    
    hsignum fi p =
      T.uccase T.mkNoSrcPos p
        (let
          v632v13v635v24v1 (T.R LT _) p =
            T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 1))
          v632v13v635v24v1 (T.R EQ _) p =
            T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 0)
          v632v13v635v24v1 (T.R GT _) p =
            T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 1)
          v632v13v635v24v1 _ p = T.fatal p in (v632v13v635v24v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fi
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 0)))
    
  
  gfromInteger pfromInteger p =
    T.ufun1 a636v2v636v18fromInteger pfromInteger p hfromInteger
    where
    
    hfromInteger fa p = T.projection T.mkNoSrcPos p fa
    
  

instance Real (Integer)
  where
  
  gtoRational ptoRational p =
    T.ufun1 a639v5v639v24toRational ptoRational p htoRational
    where
    
    htoRational fi p =
      T.uwrapForward p
        ((fi
            *%
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 1))) p)
    
  

instance Integral (Integer)
  where
  
  gquot pquot p =
    T.ufun2 a642v8v642v11quot pquot p hquot
    where
    
    hquot fn fd p = T.uwrapForward p (hprimIntegerQuot fn fd p)
    
  
  grem prem p =
    T.ufun2 a643v8v643v10rem prem p hrem
    where
    
    hrem fn fd p = T.uwrapForward p (hprimIntegerRem fn fd p)
    
  
  gdiv pdiv p =
    T.ufun2 a644v8v644v10div pdiv p hdiv
    where
    
    hdiv fn fd p =
      T.uwrapForward p
        (hfst (T.uap2 T.mkNoSrcPos p (gdivMod T.mkNoSrcPos p) fn fd) p)
    
  
  gmod pmod p =
    T.ufun2 a645v8v645v10mod pmod p hmod
    where
    
    hmod fn fd p =
      T.uwrapForward p
        (hsnd (T.uap2 T.mkNoSrcPos p (gdivMod T.mkNoSrcPos p) fn fd) p)
    
  
  gquotRem pquotRem p =
    T.ufun2 a647v8v647v14quotRem pquotRem p hquotRem
    where
    
    hquotRem fn fd p = T.uwrapForward p (hprimIntegerQuotRem fn fd p)
    
  
  gtoInteger ptoInteger p =
    T.ufun1 a649v5v649v21toInteger ptoInteger p htoInteger
    where
    
    htoInteger fn p = T.projection T.mkNoSrcPos p fn
    
  

instance Enum (Integer)
  where
  
  gsucc psucc p =
    T.ufun1 a652v3v652v18succ psucc p hsucc
    where
    
    hsucc fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 1))
    
  
  gpred ppred p =
    T.ufun1 a653v3v653v18pred ppred p hpred
    where
    
    hpred fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fx
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 1))
    
  
  gtoEnum ptoEnum p =
    T.ufun1 a654v3v654v26toEnum ptoEnum p htoEnum
    where
    
    htoEnum fx p = T.uap1 T.mkNoSrcPos p (gtoInteger T.mkNoSrcPos p) fx
    
  
  gfromEnum pfromEnum p =
    T.ufun1 a655v3v655v28fromEnum pfromEnum p hfromEnum
    where
    
    hfromEnum fx p = T.uap1 T.mkNoSrcPos p (gfromInteger T.mkNoSrcPos p) fx
    
  
  genumFrom penumFrom p = T.uconstUse penumFrom p senumFrom
  
  senumFrom =
    T.uconstDef T.mkRoot a657v3v657v24enumFrom
      (\ p ->
        T.uap1 T.mkNoSrcPos p (giterate T.mkNoSrcPos p)
          (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !+ p)
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 1))))
  
  genumFromThen penumFromThen p =
    T.ufun2 a658v3v658v41enumFromThen penumFromThen p henumFromThen
    where
    
    henumFromThen fn fn' p =
      T.uwrapForward p
        (hiterate
          (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !+ p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fn' fn)) fn p)
    
  
  genumFromTo penumFromTo p =
    T.ufun2 a659v3v659v51enumFromTo penumFromTo p henumFromTo
    where
    
    henumFromTo fn fm p =
      T.uwrapForward p
        (htakeWhile
          (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !<= p) fm)
          (T.uwrapForward p
            (hiterate
              (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !+ p)
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 1))) fn p)) p)
    
  
  genumFromThenTo penumFromThenTo p =
    T.ufun3 a660v3v663v54enumFromThenTo penumFromThenTo p henumFromThenTo
    where
    
    henumFromThenTo fn fn' fm p =
      let
        gd pd p = T.uconstUse pd p sd
        sd =
          T.uconstDef p a661v9v661v16d
            (\ p -> T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fn' fn) in
        (T.ucif p
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !>= p) (gd T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 0)))
          (T.uwrapForward p
            (htakeWhile
              (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !<= p)
                fm)
              (T.uwrapForward p
                (hiterate
                  (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p)
                    (T.mkNoSrcPos !+ p) (gd T.mkNoSrcPos p)) fn p)) p))
          (T.uwrapForward p
            (htakeWhile
              (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !>= p)
                fm)
              (T.uwrapForward p
                (hiterate
                  (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p)
                    (T.mkNoSrcPos !+ p) (gd T.mkNoSrcPos p)) fn p)) p)))
    
  

instance Eq (Float)
  where
  
  (!==) (%==) p =
    T.ufun2 (+++>=*=++>=+==) (%==) p (*==)
    where
    
    (*==) fa fb p = T.uwrapForward p (hprimFloatEq fa fb p)
    
  
  (!/=) (%/=) p =
    T.ufun2 (++^!=*=+^!=+/=) (%/=) p (*/=)
    where
    
    (*/=) fa fb p = T.uwrapForward p (hprimFloatNe fa fb p)
    
  

instance Ord (Float)
  where
  
  (!<) (%<) p =
    T.ufun2 (++^%=*=+^%=*<) (%<) p (*<)
    where
    
    (*<) fa fb p = T.uwrapForward p (hprimFloatLt fa fb p)
    
  
  (!<=) (%<=) p =
    T.ufun2 (++^&=*=+^&=+<=) (%<=) p (*<=)
    where
    
    (*<=) fa fb p = T.uwrapForward p (hprimFloatLe fa fb p)
    
  
  (!>=) (%>=) p =
    T.ufun2 (++^*=*=+^*=+>=) (%>=) p (*>=)
    where
    
    (*>=) fa fb p = T.uwrapForward p (hprimFloatGe fa fb p)
    
  
  (!>) (%>) p =
    T.ufun2 (++^+=*=+^+=*>) (%>) p (*>)
    where
    
    (*>) fa fb p = T.uwrapForward p (hprimFloatGt fa fb p)
    
  

instance Num (Float)
  where
  
  (!+) (%+) p =
    T.ufun2 (++^>=&=+^>=&+) (%+) p (*+)
    where
    
    (*+) fa fb p = T.uwrapForward p (hprimFloatAdd fa fb p)
    
  
  (!-) (%-) p =
    T.ufun2 (++@!=&=+@!=&-) (%-) p (*-)
    where
    
    (*-) fa fb p = T.uwrapForward p (hprimFloatSub fa fb p)
    
  
  (!*) (%*) p =
    T.ufun2 (++@#=&=+@#=&*) (%*) p (**)
    where
    
    (**) fa fb p = T.uwrapForward p (hprimFloatMul fa fb p)
    
  
  gnegate pnegate p =
    T.ufun1 a682v2v682v17negate pnegate p hnegate
    where
    
    hnegate fa p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p)
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0)) fa
    
  
  gabs pabs p =
    T.ufun1 a683v2v683v26abs pabs p habs
    where
    
    habs fa p = T.uwrapForward p (hprimFloatAbs fa p)
    
  
  gsignum psignum p =
    T.ufun1 a684v2v684v29signum psignum p hsignum
    where
    
    hsignum fa p = T.uwrapForward p (hprimFloatSignum fa p)
    
  
  gfromInteger pfromInteger p =
    T.ufun1 a685v2v685v39fromInteger pfromInteger p hfromInteger
    where
    
    hfromInteger fi p = T.uwrapForward p (hprimFloatFromInteger fi p)
    
  

instance Real (Float)
  where
  
  gtoRational ptoRational p =
    T.ufun1 a688v5v689v52toRational ptoRational p htoRational
    where
    
    htoRational fx p =
      T.uccase T.mkNoSrcPos p
        (let
          v688v20v688v65v1 (T.R (T.Tuple2 fm fn) _) p =
            T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
              (T.uwrapForward p
                ((fm
                    *%
                    (T.uap1 T.mkNoSrcPos p
                      (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                      (T.conInteger T.mkNoSrcPos p 1))) p))
              (T.uwrapForward p
                (((T.uwrapForward p
                      (((gbf T.mkNoSrcPos p)
                          *%
                          (T.uap1 T.mkNoSrcPos p
                            (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                            (T.conInteger T.mkNoSrcPos p 1))) p))
                    *^^
                    fn) p))
          v688v20v688v65v1 _ p = T.fatal p in (v688v20v688v65v1))
        (T.uap1 T.mkNoSrcPos p (gdecodeFloat T.mkNoSrcPos p) fx)
      where
      
      gbf pbf p = T.uconstUse pbf p sbf
      
      sbf =
        T.uconstDef p a689v31v689v52bf
          (\ p -> T.uap1 T.mkNoSrcPos p (gfloatRadix T.mkNoSrcPos p) fx)
      
    
  

instance Fractional (Float)
  where
  
  (!/) (%/) p =
    T.ufun2 (++>$=*=+>$=*/) (%/) p (*/)
    where
    
    (*/) fx fy p = T.uwrapForward p (hprimFloatDiv fx fy p)
    
  
  gfromRational pfromRational p =
    T.ufun1 a693v3v701v76fromRational pfromRational p hfromRational
    where
    
    hfromRational fx p =
      gx0 T.mkNoSrcPos p
      where
      
      gx0 px0 p = T.uconstUse px0 p sx0
      
      sx0 =
        T.uconstDef p a694v13v694v25x0
          (\ p -> T.uwrapForward p (hff (gef T.mkNoSrcPos p) p))
      
      gff pff p = T.ufun1 a695v13v699v48ff pff p hff
      
      aff = a695v13v699v48ff
      
      hff fef p =
        T.ucif p
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) (gef' T.mkNoSrcPos p) fef)
          (gyf T.mkNoSrcPos p) (T.uwrapForward p (hff (gef' T.mkNoSrcPos p) p))
        where
        
        gyf :: T.RefSrcPos -> T.RefExp -> T.R Float
        
        syf :: T.R Float
        
        gyf pyf p = T.uconstUse pyf p syf
        
        syf =
          T.uconstDef p a697v26v697v78yf
            (\ p ->
              T.uap2 T.mkNoSrcPos p (gencodeFloat T.mkNoSrcPos p)
                (T.uap1 T.mkNoSrcPos p (ground T.mkNoSrcPos p)
                  (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fx
                    (T.uwrapForward p
                      (((T.uwrapForward p
                            (((T.uap1 T.mkNoSrcPos p
                                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                                  (T.conInteger T.mkNoSrcPos p 1))
                                *%
                                (gbf T.mkNoSrcPos p)) p))
                          *^^
                          fef) p)))) fef)
        
        gef' pef' p = T.uconstUse pef' p sef'
        
        j698v26v698v32ef' =
          case
            T.uap1 T.mkNoSrcPos p (gdecodeFloat T.mkNoSrcPos p)
              (gyf T.mkNoSrcPos p) of
            T.R (T.Tuple2 _ fef') kef' -> (kef',fef')
            _ -> T.fatal p
        
        sef' =
          T.uconstDef p a698v29v698v31ef'
            (\ _ -> case j698v26v698v32ef' of (kef',fef') -> fef')
        
        gbf pbf p = T.uconstUse pbf p sbf
        
        sbf =
          T.uconstDef p a699v26v699v48bf
            (\ p ->
              T.uap1 T.mkNoSrcPos p (gfloatRadix T.mkNoSrcPos p)
                (gx0 T.mkNoSrcPos p))
        
      
      gef pef p = T.uconstUse pef p sef
      
      j700v13v700v18ef =
        case
          T.uap1 T.mkNoSrcPos p (gdecodeFloat T.mkNoSrcPos p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
              (T.uap2 T.mkNoSrcPos p (gasTypeOf T.mkNoSrcPos p)
                (T.uap1 T.mkNoSrcPos p (gfromInteger T.mkNoSrcPos p)
                  (T.uwrapForward p (hnumerator fx p))) (gx0 T.mkNoSrcPos p))
              (T.uap1 T.mkNoSrcPos p (gfromInteger T.mkNoSrcPos p)
                (T.uwrapForward p (hdenominator fx p)))) of
          T.R (T.Tuple2 _ fef) kef -> (kef,fef)
          _ -> T.fatal p
      
      sef =
        T.uconstDef p a700v16v700v17ef
          (\ _ -> case j700v13v700v18ef of (kef,fef) -> fef)
      
    
  

instance Floating (Float)
  where
  
  gpi ppi p = T.uconstUse ppi p spi
  
  spi =
    T.uconstDef T.mkRoot a704v5v704v38pi (\ p -> gprimFloatPi T.mkNoSrcPos p)
  
  gexp pexp p =
    T.ufun1 a705v5v705v41exp pexp p hexp
    where
    
    hexp fx p = T.uwrapForward p (hprimFloatExp fx p)
    
  
  glog plog p =
    T.ufun1 a706v5v706v41log plog p hlog
    where
    
    hlog fx p = T.uwrapForward p (hprimFloatLog fx p)
    
  
  gsqrt psqrt p =
    T.ufun1 a707v5v707v42sqrt psqrt p hsqrt
    where
    
    hsqrt fx p = T.uwrapForward p (hprimFloatSqrt fx p)
    
  
  gsin psin p =
    T.ufun1 a708v5v708v41sin psin p hsin
    where
    
    hsin fx p = T.uwrapForward p (hprimFloatSin fx p)
    
  
  gcos pcos p =
    T.ufun1 a709v5v709v41cos pcos p hcos
    where
    
    hcos fx p = T.uwrapForward p (hprimFloatCos fx p)
    
  
  gtan ptan p =
    T.ufun1 a710v5v710v41tan ptan p htan
    where
    
    htan fx p = T.uwrapForward p (hprimFloatTan fx p)
    
  
  gasin pasin p =
    T.ufun1 a711v5v711v42asin pasin p hasin
    where
    
    hasin fx p = T.uwrapForward p (hprimFloatAsin fx p)
    
  
  gacos pacos p =
    T.ufun1 a712v5v712v42acos pacos p hacos
    where
    
    hacos fx p = T.uwrapForward p (hprimFloatAcos fx p)
    
  
  gatan patan p =
    T.ufun1 a713v5v713v42atan patan p hatan
    where
    
    hatan fx p = T.uwrapForward p (hprimFloatAtan fx p)
    
  
  gsinh psinh p =
    T.ufun1 a714v5v714v48sinh psinh p hsinh
    where
    
    hsinh fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromRational T.mkNoSrcPos p)
          (T.R
            ((T.conInteger T.mkNoSrcPos p 1)
              Hat.PreludeBasic.:%
              (T.conInteger T.mkNoSrcPos p 2))
            (T.mkAtomRational T.mkNoSrcPos p 0.5)))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p)
          (T.uap1 T.mkNoSrcPos p (gexp T.mkNoSrcPos p) fx)
          (T.uap1 T.mkNoSrcPos p (gexp T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fx)))
    
  
  gcosh pcosh p =
    T.ufun1 a715v5v715v48cosh pcosh p hcosh
    where
    
    hcosh fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromRational T.mkNoSrcPos p)
          (T.R
            ((T.conInteger T.mkNoSrcPos p 1)
              Hat.PreludeBasic.:%
              (T.conInteger T.mkNoSrcPos p 2))
            (T.mkAtomRational T.mkNoSrcPos p 0.5)))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
          (T.uap1 T.mkNoSrcPos p (gexp T.mkNoSrcPos p) fx)
          (T.uap1 T.mkNoSrcPos p (gexp T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fx)))
    
  
  gtanh ptanh p =
    T.ufun1 a716v5v716v73tanh ptanh p htanh
    where
    
    htanh fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) (gaf T.mkNoSrcPos p)
          (gbf T.mkNoSrcPos p))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) (gaf T.mkNoSrcPos p)
          (gbf T.mkNoSrcPos p))
      where
      
      gaf paf p = T.uconstUse paf p saf
      
      saf =
        T.uconstDef p a716v49v716v58af
          (\ p -> T.uap1 T.mkNoSrcPos p (gexp T.mkNoSrcPos p) fx)
      
      gbf pbf p = T.uconstUse pbf p sbf
      
      sbf =
        T.uconstDef p a716v62v716v73bf
          (\ p ->
            T.uap1 T.mkNoSrcPos p (gexp T.mkNoSrcPos p)
              (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fx))
      
    
  
  gasinh pasinh p =
    T.ufun1 a717v5v717v34asinh pasinh p hasinh
    where
    
    hasinh fx p =
      T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx
          (T.uap1 T.mkNoSrcPos p (gsqrt T.mkNoSrcPos p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 1))
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fx fx))))
    
  
  gacosh pacosh p =
    T.ufun1 a718v5v718v47acosh pacosh p hacosh
    where
    
    hacosh fx p =
      T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 1)))
            (T.uap1 T.mkNoSrcPos p (gsqrt T.mkNoSrcPos p)
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fx
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 1)))
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 1)))))))
    
  
  gatanh patanh p =
    T.ufun1 a719v5v719v40atanh patanh p hatanh
    where
    
    hatanh fx p =
      T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 1)))
          (T.uap1 T.mkNoSrcPos p (gsqrt T.mkNoSrcPos p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 1))
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fx fx))))
    
  

instance RealFrac (Float)
  where
  
  gproperFraction pproperFraction p =
    T.ufun1 a722v5v728v67properFraction pproperFraction p hproperFraction
    where
    
    hproperFraction fx p =
      T.uccase T.mkNoSrcPos p
        (let
          v723v9v728v67v1 (T.R (T.Tuple2 fm fn) _) p =
            T.ucif p
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !>= p) fn
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 0)))
              (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
                  (T.uap1 T.mkNoSrcPos p (gfromInteger T.mkNoSrcPos p) fm)
                  (T.uwrapForward p
                    (((T.uap1 T.mkNoSrcPos p (gfromInteger T.mkNoSrcPos p)
                          (T.uap1 T.mkNoSrcPos p (gfloatRadix T.mkNoSrcPos p)
                            fx))
                        *^
                        fn) p)))
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 0)))
              (T.uccase T.mkNoSrcPos p
                (let
                  v727v25v728v67v1 (T.R (T.Tuple2 fw fr) _) p =
                    T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                      (T.uap1 T.mkNoSrcPos p (gfromInteger T.mkNoSrcPos p) fw)
                      (T.uap2 T.mkNoSrcPos p (gencodeFloat T.mkNoSrcPos p) fr
                        fn)
                  v727v25v728v67v1 _ p = T.fatal p in (v727v25v728v67v1))
                (T.uap2 T.mkNoSrcPos p (gquotRem T.mkNoSrcPos p) fm
                  (T.uwrapForward p
                    (((T.uap1 T.mkNoSrcPos p (gfloatRadix T.mkNoSrcPos p) fx)
                        *^
                        (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fn))
                      p))))
          v723v9v728v67v1 _ p = T.fatal p in (v723v9v728v67v1))
        (T.uap1 T.mkNoSrcPos p (gdecodeFloat T.mkNoSrcPos p) fx)
    
  

instance RealFloat (Float)
  where
  
  gfloatRadix pfloatRadix p = T.uconstUse pfloatRadix p sfloatRadix
  
  sfloatRadix =
    T.uconstDef T.mkRoot a731v5v731v34floatRadix
      (\ p -> gprimFloatRadix T.mkNoSrcPos p)
  
  gfloatDigits pfloatDigits p = T.uconstUse pfloatDigits p sfloatDigits
  
  sfloatDigits =
    T.uconstDef T.mkRoot a732v5v732v35floatDigits
      (\ p -> gprimFloatDigits T.mkNoSrcPos p)
  
  gfloatRange pfloatRange p = T.uconstUse pfloatRange p sfloatRange
  
  sfloatRange =
    T.uconstDef T.mkRoot a733v5v733v34floatRange
      (\ p -> gprimFloatRange T.mkNoSrcPos p)
  
  gdecodeFloat pdecodeFloat p =
    T.ufun1 a734v5v734v37decodeFloat pdecodeFloat p hdecodeFloat
    where
    
    hdecodeFloat fx p = T.uwrapForward p (hprimDecodeFloat fx p)
    
  
  gencodeFloat pencodeFloat p =
    T.ufun2 a735v5v735v41encodeFloat pencodeFloat p hencodeFloat
    where
    
    hencodeFloat fx fy p = T.uwrapForward p (hprimEncodeFloat fx fy p)
    
  
  gisNaN pisNaN p = T.uconstUse pisNaN p sisNaN
  
  sisNaN =
    T.uconstDef T.mkRoot a737v5v737v35isNaN
      (\ p -> gprimFloatIsNaN T.mkNoSrcPos p)
  
  gisInfinite pisInfinite p = T.uconstUse pisInfinite p sisInfinite
  
  sisInfinite =
    T.uconstDef T.mkRoot a738v5v738v40isInfinite
      (\ p -> gprimFloatIsInfinite T.mkNoSrcPos p)
  
  gisDenormalized pisDenormalized p =
    T.uconstUse pisDenormalized p sisDenormalized
  
  sisDenormalized =
    T.uconstDef T.mkRoot a739v5v739v44isDenormalized
      (\ p -> gprimFloatIsDenormalized T.mkNoSrcPos p)
  
  gisNegativeZero pisNegativeZero p =
    T.uconstUse pisNegativeZero p sisNegativeZero
  
  sisNegativeZero =
    T.uconstDef T.mkRoot a740v5v740v44isNegativeZero
      (\ p -> gprimFloatIsNegativeZero T.mkNoSrcPos p)
  
  gisIEEE pisIEEE p = T.uconstUse pisIEEE p sisIEEE
  
  sisIEEE =
    T.uconstDef T.mkRoot a741v5v741v36isIEEE
      (\ p -> gprimFloatIsIEEE T.mkNoSrcPos p)
  

instance Eq (Double)
  where
  
  (!==) (%==) p =
    T.ufun2 (+^&^=*=^&^=+==) (%==) p (*==)
    where
    
    (*==) fa fb p = T.uwrapForward p (hprimDoubleEq fa fb p)
    
  
  (!/=) (%/=) p =
    T.ufun2 (+^&@=*=^&@=+/=) (%/=) p (*/=)
    where
    
    (*/=) fa fb p = T.uwrapForward p (hprimDoubleNe fa fb p)
    
  

instance Ord (Double)
  where
  
  (!<) (%<) p =
    T.ufun2 (+^*#=*=^*#=*<) (%<) p (*<)
    where
    
    (*<) fa fb p = T.uwrapForward p (hprimDoubleLt fa fb p)
    
  
  (!<=) (%<=) p =
    T.ufun2 (+^*$=*=^*$=+<=) (%<=) p (*<=)
    where
    
    (*<=) fa fb p = T.uwrapForward p (hprimDoubleLe fa fb p)
    
  
  (!>=) (%>=) p =
    T.ufun2 (+^*%=*=^*%=+>=) (%>=) p (*>=)
    where
    
    (*>=) fa fb p = T.uwrapForward p (hprimDoubleGe fa fb p)
    
  
  (!>) (%>) p =
    T.ufun2 (+^*&=*=^*&=*>) (%>) p (*>)
    where
    
    (*>) fa fb p = T.uwrapForward p (hprimDoubleGt fa fb p)
    
  

instance Num (Double)
  where
  
  (!+) (%+) p =
    T.ufun2 (+^*^=&=^*^=&+) (%+) p (*+)
    where
    
    (*+) fa fb p = T.uwrapForward p (hprimDoubleAdd fa fb p)
    
  
  (!-) (%-) p =
    T.ufun2 (+^*@=&=^*@=&-) (%-) p (*-)
    where
    
    (*-) fa fb p = T.uwrapForward p (hprimDoubleSub fa fb p)
    
  
  (!*) (%*) p =
    T.ufun2 (+^*>=&=^*>=&*) (%*) p (**)
    where
    
    (**) fa fb p = T.uwrapForward p (hprimDoubleMul fa fb p)
    
  
  gnegate pnegate p =
    T.ufun1 a760v2v760v18negate pnegate p hnegate
    where
    
    hnegate fa p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p)
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0)) fa
    
  
  gabs pabs p =
    T.ufun1 a761v2v761v27abs pabs p habs
    where
    
    habs fa p = T.uwrapForward p (hprimDoubleAbs fa p)
    
  
  gsignum psignum p =
    T.ufun1 a762v2v762v30signum psignum p hsignum
    where
    
    hsignum fa p = T.uwrapForward p (hprimDoubleSignum fa p)
    
  
  gfromInteger pfromInteger p =
    T.ufun1 a763v2v763v40fromInteger pfromInteger p hfromInteger
    where
    
    hfromInteger fi p = T.uwrapForward p (hprimDoubleFromInteger fi p)
    
  

instance Real (Double)
  where
  
  gtoRational ptoRational p =
    T.ufun1 a766v5v767v51toRational ptoRational p htoRational
    where
    
    htoRational fx p =
      T.uccase T.mkNoSrcPos p
        (let
          v766v20v766v64v1 (T.R (T.Tuple2 fm fn) _) p =
            T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
              (T.uwrapForward p
                ((fm
                    *%
                    (T.uap1 T.mkNoSrcPos p
                      (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                      (T.conInteger T.mkNoSrcPos p 1))) p))
              (T.uwrapForward p
                (((T.uwrapForward p
                      (((gb T.mkNoSrcPos p)
                          *%
                          (T.uap1 T.mkNoSrcPos p
                            (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                            (T.conInteger T.mkNoSrcPos p 1))) p))
                    *^^
                    fn) p))
          v766v20v766v64v1 _ p = T.fatal p in (v766v20v766v64v1))
        (T.uap1 T.mkNoSrcPos p (gdecodeFloat T.mkNoSrcPos p) fx)
      where
      
      gb pb p = T.uconstUse pb p sb
      
      sb =
        T.uconstDef p a767v31v767v51b
          (\ p -> T.uap1 T.mkNoSrcPos p (gfloatRadix T.mkNoSrcPos p) fx)
      
    
  

instance Fractional (Double)
  where
  
  (!/) (%/) p =
    T.ufun2 (+^^!=*=^^!=*/) (%/) p (*/)
    where
    
    (*/) fx fy p = T.uwrapForward p (hprimDoubleDiv fx fy p)
    
  
  gfromRational pfromRational p =
    T.ufun1 a771v3v780v11fromRational pfromRational p hfromRational
    where
    
    hfromRational fx p =
      let
        gf pf p = T.ufun1 a772v11v776v48f pf p hf
        af = a772v11v776v48f
        hf fex p =
          let
            gy :: T.RefSrcPos -> T.RefExp -> T.R Double
            sy :: T.R Double
            gy py p = T.uconstUse py p sy
            sy =
              T.uconstDef p a773v22v773v69y
                (\ p ->
                  T.uap2 T.mkNoSrcPos p (gencodeFloat T.mkNoSrcPos p)
                    (T.uap1 T.mkNoSrcPos p (ground T.mkNoSrcPos p)
                      (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fx
                        (T.uwrapForward p
                          (((T.uwrapForward p
                                (((T.uap1 T.mkNoSrcPos p
                                      (Hat.PreludeBasic.gfromInteger
                                        T.mkNoSrcPos p)
                                      (T.conInteger T.mkNoSrcPos p 1))
                                    *%
                                    (gbd T.mkNoSrcPos p)) p))
                              *^^
                              fex) p)))) fex)
            ge' pe' p = T.uconstUse pe' p se'
            se' =
              T.uconstDef p a774v22v774v44e'
                (\ p ->
                  T.uwrapForward p
                    (hsnd
                      (T.uap1 T.mkNoSrcPos p (gdecodeFloat T.mkNoSrcPos p)
                        (gy T.mkNoSrcPos p)) p))
            gbd pbd p = T.uconstUse pbd p sbd
            sbd =
              T.uconstDef p a775v22v775v39bd
                (\ p ->
                  T.uap1 T.mkNoSrcPos p (gfloatRadix T.mkNoSrcPos p)
                    (gx' T.mkNoSrcPos p)) in
            (T.ucif p
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) (ge' T.mkNoSrcPos p)
                fex) (gy T.mkNoSrcPos p)
              (T.uwrapForward p (hf (ge' T.mkNoSrcPos p) p)))
        ge pe p = T.uconstUse pe p se
        se =
          T.uconstDef p a777v11v778v76e
            (\ p ->
              T.uwrapForward p
                (hsnd
                  (T.uap1 T.mkNoSrcPos p (gdecodeFloat T.mkNoSrcPos p)
                    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
                      (T.uap2 T.mkNoSrcPos p (gasTypeOf T.mkNoSrcPos p)
                        (T.uap1 T.mkNoSrcPos p (gfromInteger T.mkNoSrcPos p)
                          (T.uwrapForward p (hnumerator fx p)))
                        (gx' T.mkNoSrcPos p))
                      (T.uap1 T.mkNoSrcPos p (gfromInteger T.mkNoSrcPos p)
                        (T.uwrapForward p (hdenominator fx p))))) p))
        gx' px' p = T.uconstUse px' p sx'
        sx' =
          T.uconstDef p a779v11v779v20x'
            (\ p -> T.uwrapForward p (hf (ge T.mkNoSrcPos p) p)) in
        (gx' T.mkNoSrcPos p)
    
  

instance Floating (Double)
  where
  
  gpi ppi p = T.uconstUse ppi p spi
  
  spi =
    T.uconstDef T.mkRoot a784v5v784v39pi (\ p -> gprimDoublePi T.mkNoSrcPos p)
  
  gexp pexp p =
    T.ufun1 a785v5v785v42exp pexp p hexp
    where
    
    hexp fx p = T.uwrapForward p (hprimDoubleExp fx p)
    
  
  glog plog p =
    T.ufun1 a786v5v786v42log plog p hlog
    where
    
    hlog fx p = T.uwrapForward p (hprimDoubleLog fx p)
    
  
  gsqrt psqrt p =
    T.ufun1 a787v5v787v43sqrt psqrt p hsqrt
    where
    
    hsqrt fx p = T.uwrapForward p (hprimDoubleSqrt fx p)
    
  
  gsin psin p =
    T.ufun1 a788v5v788v42sin psin p hsin
    where
    
    hsin fx p = T.uwrapForward p (hprimDoubleSin fx p)
    
  
  gcos pcos p =
    T.ufun1 a789v5v789v42cos pcos p hcos
    where
    
    hcos fx p = T.uwrapForward p (hprimDoubleCos fx p)
    
  
  gtan ptan p =
    T.ufun1 a790v5v790v42tan ptan p htan
    where
    
    htan fx p = T.uwrapForward p (hprimDoubleTan fx p)
    
  
  gasin pasin p =
    T.ufun1 a791v5v791v43asin pasin p hasin
    where
    
    hasin fx p = T.uwrapForward p (hprimDoubleAsin fx p)
    
  
  gacos pacos p =
    T.ufun1 a792v5v792v43acos pacos p hacos
    where
    
    hacos fx p = T.uwrapForward p (hprimDoubleAcos fx p)
    
  
  gatan patan p =
    T.ufun1 a793v5v793v43atan patan p hatan
    where
    
    hatan fx p = T.uwrapForward p (hprimDoubleAtan fx p)
    
  
  gsinh psinh p =
    T.ufun1 a794v5v794v63sinh psinh p hsinh
    where
    
    hsinh fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
        (T.uap1 T.mkNoSrcPos p (gfromRational T.mkNoSrcPos p)
          (T.uwrapForward p
            (((T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 1))
                *%
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 2))) p)))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p)
          (T.uap1 T.mkNoSrcPos p (gexp T.mkNoSrcPos p) fx)
          (T.uap1 T.mkNoSrcPos p (gexp T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fx)))
    
  
  gcosh pcosh p =
    T.ufun1 a795v5v795v63cosh pcosh p hcosh
    where
    
    hcosh fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
        (T.uap1 T.mkNoSrcPos p (gfromRational T.mkNoSrcPos p)
          (T.uwrapForward p
            (((T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 1))
                *%
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 2))) p)))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
          (T.uap1 T.mkNoSrcPos p (gexp T.mkNoSrcPos p) fx)
          (T.uap1 T.mkNoSrcPos p (gexp T.mkNoSrcPos p)
            (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fx)))
    
  
  gtanh ptanh p =
    T.ufun1 a796v5v796v67tanh ptanh p htanh
    where
    
    htanh fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) (ga T.mkNoSrcPos p)
          (gb T.mkNoSrcPos p))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) (ga T.mkNoSrcPos p)
          (gb T.mkNoSrcPos p))
      where
      
      ga pa p = T.uconstUse pa p sa
      
      sa =
        T.uconstDef p a796v45v796v53a
          (\ p -> T.uap1 T.mkNoSrcPos p (gexp T.mkNoSrcPos p) fx)
      
      gb pb p = T.uconstUse pb p sb
      
      sb =
        T.uconstDef p a796v57v796v67b
          (\ p ->
            T.uap1 T.mkNoSrcPos p (gexp T.mkNoSrcPos p)
              (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fx))
      
    
  
  gasinh pasinh p =
    T.ufun1 a797v5v797v34asinh pasinh p hasinh
    where
    
    hasinh fx p =
      T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx
          (T.uap1 T.mkNoSrcPos p (gsqrt T.mkNoSrcPos p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 1))
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fx fx))))
    
  
  gacosh pacosh p =
    T.ufun1 a798v5v798v47acosh pacosh p hacosh
    where
    
    hacosh fx p =
      T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 1)))
            (T.uap1 T.mkNoSrcPos p (gsqrt T.mkNoSrcPos p)
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fx
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 1)))
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 1)))))))
    
  
  gatanh patanh p =
    T.ufun1 a799v5v799v40atanh patanh p hatanh
    where
    
    hatanh fx p =
      T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 1)))
          (T.uap1 T.mkNoSrcPos p (gsqrt T.mkNoSrcPos p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 1))
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fx fx))))
    
  

instance RealFrac (Double)
  where
  
  gproperFraction pproperFraction p =
    T.ufun1 a802v5v808v67properFraction pproperFraction p hproperFraction
    where
    
    hproperFraction fx p =
      T.uccase T.mkNoSrcPos p
        (let
          v803v9v808v67v1 (T.R (T.Tuple2 fm fn) _) p =
            T.ucif p
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !>= p) fn
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 0)))
              (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
                  (T.uap1 T.mkNoSrcPos p (gfromInteger T.mkNoSrcPos p) fm)
                  (T.uwrapForward p
                    (((T.uap1 T.mkNoSrcPos p (gfromInteger T.mkNoSrcPos p)
                          (T.uap1 T.mkNoSrcPos p (gfloatRadix T.mkNoSrcPos p)
                            fx))
                        *^
                        fn) p)))
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 0)))
              (T.uccase T.mkNoSrcPos p
                (let
                  v807v25v808v67v1 (T.R (T.Tuple2 fw fr) _) p =
                    T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                      (T.uap1 T.mkNoSrcPos p (gfromInteger T.mkNoSrcPos p) fw)
                      (T.uap2 T.mkNoSrcPos p (gencodeFloat T.mkNoSrcPos p) fr
                        fn)
                  v807v25v808v67v1 _ p = T.fatal p in (v807v25v808v67v1))
                (T.uap2 T.mkNoSrcPos p (gquotRem T.mkNoSrcPos p) fm
                  (T.uwrapForward p
                    (((T.uap1 T.mkNoSrcPos p (gfloatRadix T.mkNoSrcPos p) fx)
                        *^
                        (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fn))
                      p))))
          v803v9v808v67v1 _ p = T.fatal p in (v803v9v808v67v1))
        (T.uap1 T.mkNoSrcPos p (gdecodeFloat T.mkNoSrcPos p) fx)
    
  

instance RealFloat (Double)
  where
  
  gfloatRadix pfloatRadix p = T.uconstUse pfloatRadix p sfloatRadix
  
  sfloatRadix =
    T.uconstDef T.mkRoot a812v5v812v35floatRadix
      (\ p -> gprimDoubleRadix T.mkNoSrcPos p)
  
  gfloatDigits pfloatDigits p = T.uconstUse pfloatDigits p sfloatDigits
  
  sfloatDigits =
    T.uconstDef T.mkRoot a813v5v813v36floatDigits
      (\ p -> gprimDoubleDigits T.mkNoSrcPos p)
  
  gfloatRange pfloatRange p = T.uconstUse pfloatRange p sfloatRange
  
  sfloatRange =
    T.uconstDef T.mkRoot a814v5v814v35floatRange
      (\ p -> gprimDoubleRange T.mkNoSrcPos p)
  
  gdecodeFloat pdecodeFloat p =
    T.ufun1 a815v5v815v38decodeFloat pdecodeFloat p hdecodeFloat
    where
    
    hdecodeFloat fx p = T.uwrapForward p (hprimDecodeDouble fx p)
    
  
  gencodeFloat pencodeFloat p =
    T.ufun2 a816v5v816v42encodeFloat pencodeFloat p hencodeFloat
    where
    
    hencodeFloat fx fy p = T.uwrapForward p (hprimEncodeDouble fx fy p)
    
  
  gisNaN pisNaN p = T.uconstUse pisNaN p sisNaN
  
  sisNaN =
    T.uconstDef T.mkRoot a818v5v818v36isNaN
      (\ p -> gprimDoubleIsNaN T.mkNoSrcPos p)
  
  gisInfinite pisInfinite p = T.uconstUse pisInfinite p sisInfinite
  
  sisInfinite =
    T.uconstDef T.mkRoot a819v5v819v41isInfinite
      (\ p -> gprimDoubleIsInfinite T.mkNoSrcPos p)
  
  gisDenormalized pisDenormalized p =
    T.uconstUse pisDenormalized p sisDenormalized
  
  sisDenormalized =
    T.uconstDef T.mkRoot a820v5v820v45isDenormalized
      (\ p -> gprimDoubleIsDenormalized T.mkNoSrcPos p)
  
  gisNegativeZero pisNegativeZero p =
    T.uconstUse pisNegativeZero p sisNegativeZero
  
  sisNegativeZero =
    T.uconstDef T.mkRoot a821v5v821v45isNegativeZero
      (\ p -> gprimDoubleIsNegativeZero T.mkNoSrcPos p)
  
  gisIEEE pisIEEE p = T.uconstUse pisIEEE p sisIEEE
  
  sisIEEE =
    T.uconstDef T.mkRoot a822v5v822v37isIEEE
      (\ p -> gprimDoubleIsIEEE T.mkNoSrcPos p)
  

instance Enum (Float)
  where
  
  gsucc psucc p =
    T.ufun1 a833v5v833v27succ psucc p hsucc
    where
    
    hsucc fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 1))
    
  
  gpred ppred p =
    T.ufun1 a834v5v834v27pred ppred p hpred
    where
    
    hpred fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fx
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 1))
    
  
  gtoEnum ptoEnum p = T.uconstUse ptoEnum p stoEnum
  
  stoEnum =
    T.uconstDef T.mkRoot a835v5v835v36toEnum
      (\ p -> gfromIntegral T.mkNoSrcPos p)
  
  gfromEnum pfromEnum p = T.uconstUse pfromEnum p sfromEnum
  
  sfromEnum =
    T.uconstDef T.mkRoot a836v5v836v46fromEnum
      (\ p ->
        T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p) (gfromInteger T.mkNoSrcPos p)
          (gtruncate T.mkNoSrcPos p))
  
  genumFrom penumFrom p = T.uconstUse penumFrom p senumFrom
  
  senumFrom =
    T.uconstDef T.mkRoot a837v5v837v39enumFrom
      (\ p -> gnumericEnumFrom T.mkNoSrcPos p)
  
  genumFromThen penumFromThen p = T.uconstUse penumFromThen p senumFromThen
  
  senumFromThen =
    T.uconstDef T.mkRoot a838v5v838v43enumFromThen
      (\ p -> gnumericEnumFromThen T.mkNoSrcPos p)
  
  genumFromTo penumFromTo p = T.uconstUse penumFromTo p senumFromTo
  
  senumFromTo =
    T.uconstDef T.mkRoot a839v5v839v41enumFromTo
      (\ p -> gnumericEnumFromTo T.mkNoSrcPos p)
  
  genumFromThenTo penumFromThenTo p =
    T.uconstUse penumFromThenTo p senumFromThenTo
  
  senumFromThenTo =
    T.uconstDef T.mkRoot a840v5v840v45enumFromThenTo
      (\ p -> gnumericEnumFromThenTo T.mkNoSrcPos p)
  

instance Enum (Double)
  where
  
  gsucc psucc p =
    T.ufun1 a844v5v844v27succ psucc p hsucc
    where
    
    hsucc fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 1))
    
  
  gpred ppred p =
    T.ufun1 a845v5v845v27pred ppred p hpred
    where
    
    hpred fx p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fx
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 1))
    
  
  gtoEnum ptoEnum p = T.uconstUse ptoEnum p stoEnum
  
  stoEnum =
    T.uconstDef T.mkRoot a846v5v846v36toEnum
      (\ p -> gfromIntegral T.mkNoSrcPos p)
  
  gfromEnum pfromEnum p = T.uconstUse pfromEnum p sfromEnum
  
  sfromEnum =
    T.uconstDef T.mkRoot a847v5v847v46fromEnum
      (\ p ->
        T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p) (gfromInteger T.mkNoSrcPos p)
          (gtruncate T.mkNoSrcPos p))
  
  genumFrom penumFrom p = T.uconstUse penumFrom p senumFrom
  
  senumFrom =
    T.uconstDef T.mkRoot a848v5v848v39enumFrom
      (\ p -> gnumericEnumFrom T.mkNoSrcPos p)
  
  genumFromThen penumFromThen p = T.uconstUse penumFromThen p senumFromThen
  
  senumFromThen =
    T.uconstDef T.mkRoot a849v5v849v43enumFromThen
      (\ p -> gnumericEnumFromThen T.mkNoSrcPos p)
  
  genumFromTo penumFromTo p = T.uconstUse penumFromTo p senumFromTo
  
  senumFromTo =
    T.uconstDef T.mkRoot a850v5v850v41enumFromTo
      (\ p -> gnumericEnumFromTo T.mkNoSrcPos p)
  
  genumFromThenTo penumFromThenTo p =
    T.uconstUse penumFromThenTo p senumFromThenTo
  
  senumFromThenTo =
    T.uconstDef T.mkRoot a851v5v851v45enumFromThenTo
      (\ p -> gnumericEnumFromThenTo T.mkNoSrcPos p)
  

gnumericEnumFrom ::
  Fractional a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.List a))

snumericEnumFrom :: Fractional a => T.R (T.Fun a (T.List a))

gnumericEnumFromThen ::
  Fractional a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a (T.List a)))

hnumericEnumFromThen ::
  Fractional a => (T.R a) -> (T.R a) -> T.RefExp -> T.R (T.List a)

gnumericEnumFromTo ::
  (Fractional a,Ord a) =>
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a (T.List a)))

hnumericEnumFromTo ::
  (Fractional a,Ord a) => (T.R a) -> (T.R a) -> T.RefExp -> T.R (T.List a)

gnumericEnumFromThenTo ::
  (Fractional a,Ord a) =>
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a (T.Fun a (T.List a))))

hnumericEnumFromThenTo ::
  (Fractional a,Ord a) =>
  (T.R a) -> (T.R a) -> (T.R a) -> T.RefExp -> T.R (T.List a)

gnumericEnumFrom pnumericEnumFrom p =
  T.uconstUse pnumericEnumFrom p snumericEnumFrom

snumericEnumFrom =
  T.uconstDef T.mkRoot anumericEnumFrom
    (\ p ->
      T.uap1 T.mkNoSrcPos p (giterate T.mkNoSrcPos p)
        (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !+ p)
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 1))))

gnumericEnumFromThen pnumericEnumFromThen p =
  T.ufun2 anumericEnumFromThen pnumericEnumFromThen p hnumericEnumFromThen

hnumericEnumFromThen fn fm p =
  T.uwrapForward p
    (hiterate
      (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !+ p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fm fn)) fn p)

gnumericEnumFromTo pnumericEnumFromTo p =
  T.ufun2 anumericEnumFromTo pnumericEnumFromTo p hnumericEnumFromTo

hnumericEnumFromTo fn fm p =
  T.uwrapForward p
    (htakeWhile
      (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !<= p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fm
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 1))
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 2)))))
      (T.uap1 T.mkNoSrcPos p (gnumericEnumFrom T.mkNoSrcPos p) fn) p)

gnumericEnumFromThenTo pnumericEnumFromThenTo p =
  T.ufun3 anumericEnumFromThenTo pnumericEnumFromThenTo p hnumericEnumFromThenTo

hnumericEnumFromThenTo fn fn' fm p =
  T.uwrapForward p
    (htakeWhile (gp T.mkNoSrcPos p)
      (T.uwrapForward p (hnumericEnumFromThen fn fn' p)) p)
  where
  
  gp pp p = T.uconstUse pp p sp
  
  sp =
    T.uconstDef p a866v32v867v63p
      (\ p ->
        T.ucguard (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !> p) fn' fn)
          (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !<= p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fm
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fn' fn)
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 2)))))
          (T.ucguard (gotherwise T.mkNoSrcPos p)
            (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !>= p)
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fm
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
                  (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fn' fn)
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 2))))) (T.fatal p)))
  

instance Eq a => Eq ((T.List a))
  where
  
  (!==) (%==) p =
    T.ufun2 (+@^^=#!=@^>=##==) (%==) p (*==)
    where
    
    (*==) (T.R T.List _) (T.R T.List _) p = T.con0 T.mkNoSrcPos p True aTrue
    (*==) (T.R (T.Cons fa fas) _) (T.R (T.Cons fb fbs) _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fb)
            *&&
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fas fbs)) p)
    (*==) _ _ p = T.con0 T.mkNoSrcPos p False aFalse
    
  

instance Ord a => Ord ((T.List a))
  where
  
  gcompare pcompare p =
    T.ufun2 a882v3v889v16compare pcompare p hcompare
    where
    
    hcompare (T.R T.List _) (T.R T.List _) p = T.con0 T.mkNoSrcPos p EQ aEQ
    hcompare (T.R T.List _) (T.R (T.Cons fb fbs) _) p =
      T.con0 T.mkNoSrcPos p LT aLT
    hcompare (T.R (T.Cons fa fas) _) (T.R T.List _) p =
      T.con0 T.mkNoSrcPos p GT aGT
    hcompare (T.R (T.Cons fa fas) _) (T.R (T.Cons fb fbs) _) p =
      T.uccase T.mkNoSrcPos p
        (let
          v886v5v889v16v1 (T.R LT _) p = T.con0 T.mkNoSrcPos p LT aLT
          v886v5v889v16v1 (T.R EQ _) p =
            T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fas fbs
          v886v5v889v16v1 (T.R GT _) p = T.con0 T.mkNoSrcPos p GT aGT
          v886v5v889v16v1 _ p = T.fatal p in (v886v5v889v16v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fb)
    hcompare _ _ p = T.fatal p
    
  

instance Functor (T.List)
  where
  
  gfmap pfmap p = T.uconstUse pfmap p sfmap
  
  sfmap = T.uconstDef T.mkRoot a893v5v893v14fmap (\ p -> gmap T.mkNoSrcPos p)
  

instance Monad (T.List)
  where
  
  (!>>=) (%>>=) p =
    T.ufun2 (+@>^=^=@>^=>>>=) (%>>=) p (*>>=)
    where
    
    (*>>=) fm fk p =
      T.uwrapForward p (hconcat (T.uwrapForward p (hmap fk fm p)) p)
    
  
  greturn preturn p =
    T.ufun1 a898v5v898v26return preturn p hreturn
    where
    
    hreturn fx p = T.fromExpList T.mkNoSrcPos p [fx]
    
  
  gfail pfail p =
    T.ufun1 a899v5v899v25fail pfail p hfail
    where
    
    hfail fs p = T.con0 T.mkNoSrcPos p T.List T.aList
    
  

instance (Eq a,Eq b) => Eq ((T.Tuple2 a b))
  where
  
  (!==) (%==) p =
    T.ufun2 (+>#!=>=>#!=#!==) (%==) p (*==)
    where
    
    (*==) (T.R (T.Tuple2 fa fb) _) (T.R (T.Tuple2 fa' fb') _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fa')
            *&&
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fb fb')) p)
    (*==) _ _ p = T.fatal p
    
  

instance (Ord a,Ord b) => Ord ((T.Tuple2 a b))
  where
  
  gcompare pcompare p =
    T.ufun2 a913v3v917v16compare pcompare p hcompare
    where
    
    hcompare (T.R (T.Tuple2 fa fb) _) (T.R (T.Tuple2 fa' fb') _) p =
      T.uccase T.mkNoSrcPos p
        (let
          v914v5v917v16v1 (T.R LT _) p = T.con0 T.mkNoSrcPos p LT aLT
          v914v5v917v16v1 (T.R EQ _) p =
            T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fb fb'
          v914v5v917v16v1 (T.R GT _) p = T.con0 T.mkNoSrcPos p GT aGT
          v914v5v917v16v1 _ p = T.fatal p in (v914v5v917v16v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fa')
    hcompare _ _ p = T.fatal p
    
  

instance (Bounded a,Bounded b) => Bounded ((T.Tuple2 a b))
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a920v3v920v33minBound
      (\ p ->
        T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2 (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p))
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a921v3v921v33maxBound
      (\ p ->
        T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2 (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p))
  

instance (Eq a,Eq b,Eq c) => Eq ((T.Tuple3 a b c))
  where
  
  (!==) (%==) p =
    T.ufun2 (+>$*=##=>$*=#$==) (%==) p (*==)
    where
    
    (*==) (T.R (T.Tuple3 fa fb fc) _) (T.R (T.Tuple3 fa' fb' fc') _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fa')
            *&&
            (T.uwrapForward p
              (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fb fb')
                  *&&
                  (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fc fc')) p))) p)
    (*==) _ _ p = T.fatal p
    
  

instance (Ord a,Ord b,Ord c) => Ord ((T.Tuple3 a b c))
  where
  
  gcompare pcompare p =
    T.ufun2 a928v3v933v15compare pcompare p hcompare
    where
    
    hcompare (T.R (T.Tuple3 fa fb fc) _) (T.R (T.Tuple3 fa' fb' fc') _) p =
      T.uccase T.mkNoSrcPos p
        (let
          v929v5v933v15v1 (T.R EQ _) p =
            T.uccase T.mkNoSrcPos p
              (let
                v930v15v932v23v1 (T.R EQ _) p =
                  T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fc fc'
                v930v15v932v23v1 fx p = T.projection T.mkNoSrcPos p fx in
                (v930v15v932v23v1))
              (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fb fb')
          v929v5v933v15v1 fx p = T.projection T.mkNoSrcPos p fx in
          (v929v5v933v15v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fa')
    hcompare _ _ p = T.fatal p
    
  

instance (Bounded a,Bounded b,Bounded c) => Bounded ((T.Tuple3 a b c))
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a936v3v936v41minBound
      (\ p ->
        T.con3 T.mkNoSrcPos p T.Tuple3 T.aTuple3 (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p))
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a937v3v937v41maxBound
      (\ p ->
        T.con3 T.mkNoSrcPos p T.Tuple3 T.aTuple3 (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p))
  

instance (Eq a,Eq b,Eq c,Eq d) => Eq ((T.Tuple4 a b c d))
  where
  
  (!==) (%==) p =
    T.ufun2 (+>&#=#%=>&#=#&==) (%==) p (*==)
    where
    
    (*==) (T.R (T.Tuple4 fa fb fc fd) _) (T.R (T.Tuple4 fa' fb' fc' fd') _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fa')
            *&&
            (T.uwrapForward p
              (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fb fb')
                  *&&
                  (T.uwrapForward p
                    (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fc fc')
                        *&&
                        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fd fd'))
                      p))) p))) p)
    (*==) _ _ p = T.fatal p
    
  

instance (Ord a,Ord b,Ord c,Ord d) => Ord ((T.Tuple4 a b c d))
  where
  
  gcompare pcompare p =
    T.ufun2 a944v3v951v15compare pcompare p hcompare
    where
    
    hcompare (T.R (T.Tuple4 fa fb fc fd) _) (T.R (T.Tuple4 fa' fb' fc' fd') _)
      p =
      T.uccase T.mkNoSrcPos p
        (let
          v945v5v951v15v1 (T.R EQ _) p =
            T.uccase T.mkNoSrcPos p
              (let
                v946v15v950v23v1 (T.R EQ _) p =
                  T.uccase T.mkNoSrcPos p
                    (let
                      v947v23v949v31v1 (T.R EQ _) p =
                        T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fd fd'
                      v947v23v949v31v1 fx p = T.projection T.mkNoSrcPos p fx in
                      (v947v23v949v31v1))
                    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fc fc')
                v946v15v950v23v1 fx p = T.projection T.mkNoSrcPos p fx in
                (v946v15v950v23v1))
              (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fb fb')
          v945v5v951v15v1 fx p = T.projection T.mkNoSrcPos p fx in
          (v945v5v951v15v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fa')
    hcompare _ _ p = T.fatal p
    
  

instance
  (Bounded a,Bounded b,Bounded c,Bounded d) => Bounded ((T.Tuple4 a b c d))
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a954v3v954v50minBound
      (\ p ->
        T.con4 T.mkNoSrcPos p T.Tuple4 T.aTuple4 (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p))
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a955v3v955v50maxBound
      (\ p ->
        T.con4 T.mkNoSrcPos p T.Tuple4 T.aTuple4 (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p))
  

instance (Eq a,Eq b,Eq c,Eq d,Eq e) => Eq ((T.Tuple5 a b c d e))
  where
  
  (!==) (%==) p =
    T.ufun2 (+>*>=#*=>*>=#+==) (%==) p (*==)
    where
    
    (*==) (T.R (T.Tuple5 fa fb fc fd fe) _)
      (T.R (T.Tuple5 fa' fb' fc' fd' fe') _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fa')
            *&&
            (T.uwrapForward p
              (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fb fb')
                  *&&
                  (T.uwrapForward p
                    (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fc fc')
                        *&&
                        (T.uwrapForward p
                          (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fd fd')
                              *&&
                              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fe
                                fe')) p))) p))) p))) p)
    (*==) _ _ p = T.fatal p
    
  

instance (Ord a,Ord b,Ord c,Ord d,Ord e) => Ord ((T.Tuple5 a b c d e))
  where
  
  gcompare pcompare p =
    T.ufun2 a963v3v972v15compare pcompare p hcompare
    where
    
    hcompare (T.R (T.Tuple5 fa fb fc fd fe) _)
      (T.R (T.Tuple5 fa' fb' fc' fd' fe') _) p =
      T.uccase T.mkNoSrcPos p
        (let
          v964v5v972v15v1 (T.R EQ _) p =
            T.uccase T.mkNoSrcPos p
              (let
                v965v15v971v23v1 (T.R EQ _) p =
                  T.uccase T.mkNoSrcPos p
                    (let
                      v966v23v970v31v1 (T.R EQ _) p =
                        T.uccase T.mkNoSrcPos p
                          (let
                            v967v31v969v39v1 (T.R EQ _) p =
                              T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fe
                                fe'
                            v967v31v969v39v1 fx p =
                              T.projection T.mkNoSrcPos p fx in
                            (v967v31v969v39v1))
                          (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fd
                            fd')
                      v966v23v970v31v1 fx p = T.projection T.mkNoSrcPos p fx in
                      (v966v23v970v31v1))
                    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fc fc')
                v965v15v971v23v1 fx p = T.projection T.mkNoSrcPos p fx in
                (v965v15v971v23v1))
              (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fb fb')
          v964v5v972v15v1 fx p = T.projection T.mkNoSrcPos p fx in
          (v964v5v972v15v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fa')
    hcompare _ _ p = T.fatal p
    
  

instance
  (Bounded a,Bounded b,Bounded c,Bounded d,Bounded e) =>
    Bounded ((T.Tuple5 a b c d e))
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a976v3v976v59minBound
      (\ p ->
        T.con5 T.mkNoSrcPos p T.Tuple5 T.aTuple5 (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p))
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a977v3v977v59maxBound
      (\ p ->
        T.con5 T.mkNoSrcPos p T.Tuple5 T.aTuple5 (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p))
  

instance (Eq a,Eq b,Eq c,Eq d,Eq e,Eq f) => Eq ((T.Tuple6 a b c d e f))
  where
  
  (!==) (%==) p =
    T.ufun2 (+>@#=#^=>@#=#@==) (%==) p (*==)
    where
    
    (*==) (T.R (T.Tuple6 fa fb fc fd fe ff) _)
      (T.R (T.Tuple6 fa' fb' fc' fd' fe' ff') _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fa')
            *&&
            (T.uwrapForward p
              (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fb fb')
                  *&&
                  (T.uwrapForward p
                    (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fc fc')
                        *&&
                        (T.uwrapForward p
                          (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fd fd')
                              *&&
                              (T.uwrapForward p
                                (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fe
                                      fe')
                                    *&&
                                    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p)
                                      ff ff')) p))) p))) p))) p))) p)
    (*==) _ _ p = T.fatal p
    
  

instance (Ord a,Ord b,Ord c,Ord d,Ord e,Ord f) => Ord ((T.Tuple6 a b c d e f))
  where
  
  gcompare pcompare p =
    T.ufun2 a985v3v996v15compare pcompare p hcompare
    where
    
    hcompare (T.R (T.Tuple6 fa fb fc fd fe ff) _)
      (T.R (T.Tuple6 fa' fb' fc' fd' fe' ff') _) p =
      T.uccase T.mkNoSrcPos p
        (let
          v986v5v996v15v1 (T.R EQ _) p =
            T.uccase T.mkNoSrcPos p
              (let
                v987v15v995v23v1 (T.R EQ _) p =
                  T.uccase T.mkNoSrcPos p
                    (let
                      v988v23v994v31v1 (T.R EQ _) p =
                        T.uccase T.mkNoSrcPos p
                          (let
                            v989v31v993v39v1 (T.R EQ _) p =
                              T.uccase T.mkNoSrcPos p
                                (let
                                  v990v39v992v47v1 (T.R EQ _) p =
                                    T.uap2 T.mkNoSrcPos p
                                      (gcompare T.mkNoSrcPos p) ff ff'
                                  v990v39v992v47v1 fx p =
                                    T.projection T.mkNoSrcPos p fx in
                                  (v990v39v992v47v1))
                                (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p)
                                  fe fe')
                            v989v31v993v39v1 fx p =
                              T.projection T.mkNoSrcPos p fx in
                            (v989v31v993v39v1))
                          (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fd
                            fd')
                      v988v23v994v31v1 fx p = T.projection T.mkNoSrcPos p fx in
                      (v988v23v994v31v1))
                    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fc fc')
                v987v15v995v23v1 fx p = T.projection T.mkNoSrcPos p fx in
                (v987v15v995v23v1))
              (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fb fb')
          v986v5v996v15v1 fx p = T.projection T.mkNoSrcPos p fx in
          (v986v5v996v15v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fa')
    hcompare _ _ p = T.fatal p
    
  

instance
  (Bounded a,Bounded b,Bounded c,Bounded d,Bounded e,Bounded f) =>
    Bounded ((T.Tuple6 a b c d e f))
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a1000v3v1000v68minBound
      (\ p ->
        T.con6 T.mkNoSrcPos p T.Tuple6 T.aTuple6 (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p))
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a1001v3v1001v68maxBound
      (\ p ->
        T.con6 T.mkNoSrcPos p T.Tuple6 T.aTuple6 (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p))
  

instance (Eq a,Eq b,Eq c,Eq d,Eq e,Eq f,Eq g) => Eq ((T.Tuple7 a b c d e f g))
  where
  
  (!==) (%==) p =
    T.ufun2 (+#!!*=#>=#!!*=$!==) (%==) p (*==)
    where
    
    (*==) (T.R (T.Tuple7 fa fb fc fd fe ff fg) _)
      (T.R (T.Tuple7 fa' fb' fc' fd' fe' ff' fg') _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fa')
            *&&
            (T.uwrapForward p
              (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fb fb')
                  *&&
                  (T.uwrapForward p
                    (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fc fc')
                        *&&
                        (T.uwrapForward p
                          (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fd fd')
                              *&&
                              (T.uwrapForward p
                                (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fe
                                      fe')
                                    *&&
                                    (T.uwrapForward p
                                      (((T.uap2 T.mkNoSrcPos p
                                            (T.mkNoSrcPos !== p) ff ff')
                                          *&&
                                          (T.uap2 T.mkNoSrcPos p
                                            (T.mkNoSrcPos !== p) fg fg')) p)))
                                  p))) p))) p))) p))) p)
    (*==) _ _ p = T.fatal p
    
  

instance
  (Ord a,Ord b,Ord c,Ord d,Ord e,Ord f,Ord g) => Ord ((T.Tuple7 a b c d e f g))
  where
  
  gcompare pcompare p =
    T.ufun2 a1010v3v1023v15compare pcompare p hcompare
    where
    
    hcompare (T.R (T.Tuple7 fa fb fc fd fe ff fg) _)
      (T.R (T.Tuple7 fa' fb' fc' fd' fe' ff' fg') _) p =
      T.uccase T.mkNoSrcPos p
        (let
          v1011v5v1023v15v1 (T.R EQ _) p =
            T.uccase T.mkNoSrcPos p
              (let
                v1012v15v1022v23v1 (T.R EQ _) p =
                  T.uccase T.mkNoSrcPos p
                    (let
                      v1013v23v1021v31v1 (T.R EQ _) p =
                        T.uccase T.mkNoSrcPos p
                          (let
                            v1014v31v1020v39v1 (T.R EQ _) p =
                              T.uccase T.mkNoSrcPos p
                                (let
                                  v1015v39v1019v47v1 (T.R EQ _) p =
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v1016v47v1018v55v1 (T.R EQ _) p =
                                          T.uap2 T.mkNoSrcPos p
                                            (gcompare T.mkNoSrcPos p) fg fg'
                                        v1016v47v1018v55v1 fx p =
                                          T.projection T.mkNoSrcPos p fx in
                                        (v1016v47v1018v55v1))
                                      (T.uap2 T.mkNoSrcPos p
                                        (gcompare T.mkNoSrcPos p) ff ff')
                                  v1015v39v1019v47v1 fx p =
                                    T.projection T.mkNoSrcPos p fx in
                                  (v1015v39v1019v47v1))
                                (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p)
                                  fe fe')
                            v1014v31v1020v39v1 fx p =
                              T.projection T.mkNoSrcPos p fx in
                            (v1014v31v1020v39v1))
                          (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fd
                            fd')
                      v1013v23v1021v31v1 fx p = T.projection T.mkNoSrcPos p fx
                      in (v1013v23v1021v31v1))
                    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fc fc')
                v1012v15v1022v23v1 fx p = T.projection T.mkNoSrcPos p fx in
                (v1012v15v1022v23v1))
              (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fb fb')
          v1011v5v1023v15v1 fx p = T.projection T.mkNoSrcPos p fx in
          (v1011v5v1023v15v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fa')
    hcompare _ _ p = T.fatal p
    
  

instance
  (Bounded a,Bounded b,Bounded c,Bounded d,Bounded e,Bounded f,Bounded g) =>
    Bounded ((T.Tuple7 a b c d e f g))
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a1028v3v1028v77minBound
      (\ p ->
        T.con7 T.mkNoSrcPos p T.Tuple7 T.aTuple7 (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p))
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a1029v3v1029v77maxBound
      (\ p ->
        T.con7 T.mkNoSrcPos p T.Tuple7 T.aTuple7 (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p))
  

instance
  (Eq a,Eq b,Eq c,Eq d,Eq e,Eq f,Eq g,Eq h) => Eq ((T.Tuple8 a b c d e f g h))
  where
  
  (!==) (%==) p =
    T.ufun2 (+#!%&=$#=#!%&=$$==) (%==) p (*==)
    where
    
    (*==) (T.R (T.Tuple8 fa fb fc fd fe ff fg fh) _)
      (T.R (T.Tuple8 fa' fb' fc' fd' fe' ff' fg' fh') _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fa')
            *&&
            (T.uwrapForward p
              (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fb fb')
                  *&&
                  (T.uwrapForward p
                    (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fc fc')
                        *&&
                        (T.uwrapForward p
                          (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fd fd')
                              *&&
                              (T.uwrapForward p
                                (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fe
                                      fe')
                                    *&&
                                    (T.uwrapForward p
                                      (((T.uap2 T.mkNoSrcPos p
                                            (T.mkNoSrcPos !== p) ff ff')
                                          *&&
                                          (T.uwrapForward p
                                            (((T.uap2 T.mkNoSrcPos p
                                                  (T.mkNoSrcPos !== p) fg fg')
                                                *&&
                                                (T.uap2 T.mkNoSrcPos p
                                                  (T.mkNoSrcPos !== p) fh fh'))
                                              p))) p))) p))) p))) p))) p))) p)
    (*==) _ _ p = T.fatal p
    
  

instance
  (Ord a,Ord b,Ord c,Ord d,Ord e,Ord f,Ord g,Ord h) =>
    Ord ((T.Tuple8 a b c d e f g h))
  where
  
  gcompare pcompare p =
    T.ufun2 a1040v3v1054v15compare pcompare p hcompare
    where
    
    hcompare (T.R (T.Tuple8 fa fb fc fd fe ff fg fh) _)
      (T.R (T.Tuple8 fa' fb' fc' fd' fe' ff' fg' fh') _) p =
      T.uccase T.mkNoSrcPos p
        (let
          v1041v5v1054v15v1 (T.R EQ _) p =
            T.uccase T.mkNoSrcPos p
              (let
                v1042v15v1053v23v1 (T.R EQ _) p =
                  T.uccase T.mkNoSrcPos p
                    (let
                      v1043v23v1052v31v1 (T.R EQ _) p =
                        T.uccase T.mkNoSrcPos p
                          (let
                            v1044v31v1051v39v1 (T.R EQ _) p =
                              T.uccase T.mkNoSrcPos p
                                (let
                                  v1045v39v1050v47v1 (T.R EQ _) p =
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v1046v47v1049v55v1 (T.R EQ _) p =
                                          T.uccase T.mkNoSrcPos p
                                            (let
                                              v1047v55v1048v74v1 (T.R EQ _) p =
                                                T.uap2 T.mkNoSrcPos p
                                                  (gcompare T.mkNoSrcPos p) fh
                                                  fh'
                                              v1047v55v1048v74v1 _ p = T.fatal p
                                              in (v1047v55v1048v74v1))
                                            (T.uap2 T.mkNoSrcPos p
                                              (gcompare T.mkNoSrcPos p) fg fg')
                                        v1046v47v1049v55v1 fx p =
                                          T.projection T.mkNoSrcPos p fx in
                                        (v1046v47v1049v55v1))
                                      (T.uap2 T.mkNoSrcPos p
                                        (gcompare T.mkNoSrcPos p) ff ff')
                                  v1045v39v1050v47v1 fx p =
                                    T.projection T.mkNoSrcPos p fx in
                                  (v1045v39v1050v47v1))
                                (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p)
                                  fe fe')
                            v1044v31v1051v39v1 fx p =
                              T.projection T.mkNoSrcPos p fx in
                            (v1044v31v1051v39v1))
                          (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fd
                            fd')
                      v1043v23v1052v31v1 fx p = T.projection T.mkNoSrcPos p fx
                      in (v1043v23v1052v31v1))
                    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fc fc')
                v1042v15v1053v23v1 fx p = T.projection T.mkNoSrcPos p fx in
                (v1042v15v1053v23v1))
              (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fb fb')
          v1041v5v1054v15v1 fx p = T.projection T.mkNoSrcPos p fx in
          (v1041v5v1054v15v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fa')
    hcompare _ _ p = T.fatal p
    
  

instance
  (Bounded a,Bounded b,Bounded c,Bounded d,Bounded e,Bounded f,Bounded g
      ,Bounded h) => Bounded ((T.Tuple8 a b c d e f g h))
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a1059v3v1060v23minBound
      (\ p ->
        T.con8 T.mkNoSrcPos p T.Tuple8 T.aTuple8 (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p))
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a1061v3v1062v23maxBound
      (\ p ->
        T.con8 T.mkNoSrcPos p T.Tuple8 T.aTuple8 (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p))
  

instance
  (Eq a,Eq b,Eq c,Eq d,Eq e,Eq f,Eq g,Eq h,Eq i) =>
    Eq ((T.Tuple9 a b c d e f g h i))
  where
  
  (!==) (%==) p =
    T.ufun2 (+#!++=$%=#!++=$&==) (%==) p (*==)
    where
    
    (*==) (T.R (T.Tuple9 fa fb fc fd fe ff fg fh fi) _)
      (T.R (T.Tuple9 fa' fb' fc' fd' fe' ff' fg' fh' fi') _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fa')
            *&&
            (T.uwrapForward p
              (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fb fb')
                  *&&
                  (T.uwrapForward p
                    (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fc fc')
                        *&&
                        (T.uwrapForward p
                          (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fd fd')
                              *&&
                              (T.uwrapForward p
                                (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fe
                                      fe')
                                    *&&
                                    (T.uwrapForward p
                                      (((T.uap2 T.mkNoSrcPos p
                                            (T.mkNoSrcPos !== p) ff ff')
                                          *&&
                                          (T.uwrapForward p
                                            (((T.uap2 T.mkNoSrcPos p
                                                  (T.mkNoSrcPos !== p) fg fg')
                                                *&&
                                                (T.uwrapForward p
                                                  (((T.uap2 T.mkNoSrcPos p
                                                        (T.mkNoSrcPos !== p) fh
                                                        fh')
                                                      *&&
                                                      (T.uap2 T.mkNoSrcPos p
                                                        (T.mkNoSrcPos !== p) fi
                                                        fi')) p))) p))) p)))
                                  p))) p))) p))) p))) p)
    (*==) _ _ p = T.fatal p
    
  

instance
  (Ord a,Ord b,Ord c,Ord d,Ord e,Ord f,Ord g,Ord h,Ord i) =>
    Ord ((T.Tuple9 a b c d e f g h i))
  where
  
  gcompare pcompare p =
    T.ufun2 a1072v3v1088v13compare pcompare p hcompare
    where
    
    hcompare (T.R (T.Tuple9 fa fb fc fd fe ff fg fh fi) _)
      (T.R (T.Tuple9 fa' fb' fc' fd' fe' ff' fg' fh' fi') _) p =
      T.uccase T.mkNoSrcPos p
        (let
          v1073v5v1088v13v1 (T.R EQ _) p =
            T.uccase T.mkNoSrcPos p
              (let
                v1074v12v1088v13v1 (T.R EQ _) p =
                  T.uccase T.mkNoSrcPos p
                    (let
                      v1075v13v1087v14v1 (T.R EQ _) p =
                        T.uccase T.mkNoSrcPos p
                          (let
                            v1076v14v1086v15v1 (T.R EQ _) p =
                              T.uccase T.mkNoSrcPos p
                                (let
                                  v1077v15v1085v16v1 (T.R EQ _) p =
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v1078v16v1084v17v1 (T.R EQ _) p =
                                          T.uccase T.mkNoSrcPos p
                                            (let
                                              v1079v17v1083v18v1 (T.R EQ _) p =
                                                T.uccase T.mkNoSrcPos p
                                                  (let
                                                    v1080v18v1082v19v1
                                                      (T.R EQ _) p =
                                                      T.uap2 T.mkNoSrcPos p
                                                        (gcompare T.mkNoSrcPos
                                                          p) fi fi'
                                                    v1080v18v1082v19v1 fx p =
                                                      T.projection T.mkNoSrcPos
                                                        p fx in
                                                    (v1080v18v1082v19v1))
                                                  (T.uap2 T.mkNoSrcPos p
                                                    (gcompare T.mkNoSrcPos p) fh
                                                    fh')
                                              v1079v17v1083v18v1 fx p =
                                                T.projection T.mkNoSrcPos p fx
                                              in (v1079v17v1083v18v1))
                                            (T.uap2 T.mkNoSrcPos p
                                              (gcompare T.mkNoSrcPos p) fg fg')
                                        v1078v16v1084v17v1 fx p =
                                          T.projection T.mkNoSrcPos p fx in
                                        (v1078v16v1084v17v1))
                                      (T.uap2 T.mkNoSrcPos p
                                        (gcompare T.mkNoSrcPos p) ff ff')
                                  v1077v15v1085v16v1 fx p =
                                    T.projection T.mkNoSrcPos p fx in
                                  (v1077v15v1085v16v1))
                                (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p)
                                  fe fe')
                            v1076v14v1086v15v1 fx p =
                              T.projection T.mkNoSrcPos p fx in
                            (v1076v14v1086v15v1))
                          (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fd
                            fd')
                      v1075v13v1087v14v1 fx p = T.projection T.mkNoSrcPos p fx
                      in (v1075v13v1087v14v1))
                    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fc fc')
                v1074v12v1088v13v1 fx p = T.projection T.mkNoSrcPos p fx in
                (v1074v12v1088v13v1))
              (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fb fb')
          v1073v5v1088v13v1 _ p = T.fatal p in (v1073v5v1088v13v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fa')
    hcompare _ _ p = T.fatal p
    
  

instance
  (Bounded a,Bounded b,Bounded c,Bounded d,Bounded e,Bounded f,Bounded g
      ,Bounded h,Bounded i) => Bounded ((T.Tuple9 a b c d e f g h i))
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a1093v3v1094v32minBound
      (\ p ->
        T.con9 T.mkNoSrcPos p T.Tuple9 T.aTuple9 (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p))
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a1095v3v1096v32maxBound
      (\ p ->
        T.con9 T.mkNoSrcPos p T.Tuple9 T.aTuple9 (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p))
  

instance
  (Eq a,Eq b,Eq c,Eq d,Eq e,Eq f,Eq g,Eq h,Eq i,Eq j) =>
    Eq ((T.Tuple10 a b c d e f g h i j))
  where
  
  (!==) (%==) p =
    T.ufun2 (+##!#=$*=##!#=$+==) (%==) p (*==)
    where
    
    (*==) (T.R (T.Tuple10 fa fb fc fd fe ff fg fh fi fj) _)
      (T.R (T.Tuple10 fa' fb' fc' fd' fe' ff' fg' fh' fi' fj') _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fa')
            *&&
            (T.uwrapForward p
              (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fb fb')
                  *&&
                  (T.uwrapForward p
                    (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fc fc')
                        *&&
                        (T.uwrapForward p
                          (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fd fd')
                              *&&
                              (T.uwrapForward p
                                (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fe
                                      fe')
                                    *&&
                                    (T.uwrapForward p
                                      (((T.uap2 T.mkNoSrcPos p
                                            (T.mkNoSrcPos !== p) ff ff')
                                          *&&
                                          (T.uwrapForward p
                                            (((T.uap2 T.mkNoSrcPos p
                                                  (T.mkNoSrcPos !== p) fg fg')
                                                *&&
                                                (T.uwrapForward p
                                                  (((T.uap2 T.mkNoSrcPos p
                                                        (T.mkNoSrcPos !== p) fh
                                                        fh')
                                                      *&&
                                                      (T.uwrapForward p
                                                        (((T.uap2 T.mkNoSrcPos p
                                                              (T.mkNoSrcPos
                                                                !==
                                                                p) fi fi')
                                                            *&&
                                                            (T.uap2 T.mkNoSrcPos
                                                              p
                                                              (T.mkNoSrcPos
                                                                !==
                                                                p) fj fj')) p)))
                                                    p))) p))) p))) p))) p)))
                      p))) p))) p)
    (*==) _ _ p = T.fatal p
    
  

instance
  (Ord a,Ord b,Ord c,Ord d,Ord e,Ord f,Ord g,Ord h,Ord i,Ord j) =>
    Ord ((T.Tuple10 a b c d e f g h i j))
  where
  
  gcompare pcompare p =
    T.ufun2 a1107v3v1125v13compare pcompare p hcompare
    where
    
    hcompare (T.R (T.Tuple10 fa fb fc fd fe ff fg fh fi fj) _)
      (T.R (T.Tuple10 fa' fb' fc' fd' fe' ff' fg' fh' fi' fj') _) p =
      T.uccase T.mkNoSrcPos p
        (let
          v1108v5v1125v13v1 (T.R EQ _) p =
            T.uccase T.mkNoSrcPos p
              (let
                v1109v12v1125v13v1 (T.R EQ _) p =
                  T.uccase T.mkNoSrcPos p
                    (let
                      v1110v13v1124v14v1 (T.R EQ _) p =
                        T.uccase T.mkNoSrcPos p
                          (let
                            v1111v14v1123v15v1 (T.R EQ _) p =
                              T.uccase T.mkNoSrcPos p
                                (let
                                  v1112v15v1122v16v1 (T.R EQ _) p =
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v1113v16v1121v17v1 (T.R EQ _) p =
                                          T.uccase T.mkNoSrcPos p
                                            (let
                                              v1114v17v1120v18v1 (T.R EQ _) p =
                                                T.uccase T.mkNoSrcPos p
                                                  (let
                                                    v1115v18v1119v19v1
                                                      (T.R EQ _) p =
                                                      T.uccase T.mkNoSrcPos p
                                                        (let
                                                          v1116v19v1118v20v1
                                                            (T.R EQ _) p =
                                                            T.uap2 T.mkNoSrcPos
                                                              p
                                                              (gcompare
                                                                T.mkNoSrcPos p)
                                                              fj fj'
                                                          v1116v19v1118v20v1 fx
                                                            p =
                                                            T.projection
                                                              T.mkNoSrcPos p fx
                                                          in
                                                          (v1116v19v1118v20v1))
                                                        (T.uap2 T.mkNoSrcPos p
                                                          (gcompare T.mkNoSrcPos
                                                            p) fi fi')
                                                    v1115v18v1119v19v1 fx p =
                                                      T.projection T.mkNoSrcPos
                                                        p fx in
                                                    (v1115v18v1119v19v1))
                                                  (T.uap2 T.mkNoSrcPos p
                                                    (gcompare T.mkNoSrcPos p) fh
                                                    fh')
                                              v1114v17v1120v18v1 fx p =
                                                T.projection T.mkNoSrcPos p fx
                                              in (v1114v17v1120v18v1))
                                            (T.uap2 T.mkNoSrcPos p
                                              (gcompare T.mkNoSrcPos p) fg fg')
                                        v1113v16v1121v17v1 fx p =
                                          T.projection T.mkNoSrcPos p fx in
                                        (v1113v16v1121v17v1))
                                      (T.uap2 T.mkNoSrcPos p
                                        (gcompare T.mkNoSrcPos p) ff ff')
                                  v1112v15v1122v16v1 fx p =
                                    T.projection T.mkNoSrcPos p fx in
                                  (v1112v15v1122v16v1))
                                (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p)
                                  fe fe')
                            v1111v14v1123v15v1 fx p =
                              T.projection T.mkNoSrcPos p fx in
                            (v1111v14v1123v15v1))
                          (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fd
                            fd')
                      v1110v13v1124v14v1 fx p = T.projection T.mkNoSrcPos p fx
                      in (v1110v13v1124v14v1))
                    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fc fc')
                v1109v12v1125v13v1 fx p = T.projection T.mkNoSrcPos p fx in
                (v1109v12v1125v13v1))
              (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fb fb')
          v1108v5v1125v13v1 _ p = T.fatal p in (v1108v5v1125v13v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fa')
    hcompare _ _ p = T.fatal p
    
  

instance
  (Bounded a,Bounded b,Bounded c,Bounded d,Bounded e,Bounded f,Bounded g
      ,Bounded h,Bounded i,Bounded j) =>
    Bounded ((T.Tuple10 a b c d e f g h i j))
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a1130v3v1131v41minBound
      (\ p ->
        T.con10 T.mkNoSrcPos p T.Tuple10 T.aTuple10 (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p))
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a1132v3v1133v41maxBound
      (\ p ->
        T.con10 T.mkNoSrcPos p T.Tuple10 T.aTuple10 (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p))
  

instance
  (Eq a,Eq b,Eq c,Eq d,Eq e,Eq f,Eq g,Eq h,Eq i,Eq j,Eq k) =>
    Eq ((T.Tuple11 a b c d e f g h i j k))
  where
  
  (!==) (%==) p =
    T.ufun2 (+##%@=$^=##%@=$@==) (%==) p (*==)
    where
    
    (*==) (T.R (T.Tuple11 fa fb fc fd fe ff fg fh fi fj fk) _)
      (T.R (T.Tuple11 fa' fb' fc' fd' fe' ff' fg' fh' fi' fj' fk') _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fa')
            *&&
            (T.uwrapForward p
              (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fb fb')
                  *&&
                  (T.uwrapForward p
                    (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fc fc')
                        *&&
                        (T.uwrapForward p
                          (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fd fd')
                              *&&
                              (T.uwrapForward p
                                (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fe
                                      fe')
                                    *&&
                                    (T.uwrapForward p
                                      (((T.uap2 T.mkNoSrcPos p
                                            (T.mkNoSrcPos !== p) ff ff')
                                          *&&
                                          (T.uwrapForward p
                                            (((T.uap2 T.mkNoSrcPos p
                                                  (T.mkNoSrcPos !== p) fg fg')
                                                *&&
                                                (T.uwrapForward p
                                                  (((T.uap2 T.mkNoSrcPos p
                                                        (T.mkNoSrcPos !== p) fh
                                                        fh')
                                                      *&&
                                                      (T.uwrapForward p
                                                        (((T.uap2 T.mkNoSrcPos p
                                                              (T.mkNoSrcPos
                                                                !==
                                                                p) fi fi')
                                                            *&&
                                                            (T.uwrapForward p
                                                              (((T.uap2
                                                                    T.mkNoSrcPos
                                                                    p
                                                                    (T.mkNoSrcPos
                                                                      !==
                                                                      p) fj fj')
                                                                  *&&
                                                                  (T.uap2
                                                                    T.mkNoSrcPos
                                                                    p
                                                                    (T.mkNoSrcPos
                                                                      !==
                                                                      p) fk
                                                                    fk')) p)))
                                                          p))) p))) p))) p)))
                                  p))) p))) p))) p))) p)
    (*==) _ _ p = T.fatal p
    
  

instance
  (Ord a,Ord b,Ord c,Ord d,Ord e,Ord f,Ord g,Ord h,Ord i,Ord j,Ord k) =>
    Ord ((T.Tuple11 a b c d e f g h i j k))
  where
  
  gcompare pcompare p =
    T.ufun2 a1144v3v1164v13compare pcompare p hcompare
    where
    
    hcompare (T.R (T.Tuple11 fa fb fc fd fe ff fg fh fi fj fk) _)
      (T.R (T.Tuple11 fa' fb' fc' fd' fe' ff' fg' fh' fi' fj' fk') _) p =
      T.uccase T.mkNoSrcPos p
        (let
          v1145v5v1164v13v1 (T.R EQ _) p =
            T.uccase T.mkNoSrcPos p
              (let
                v1146v12v1164v13v1 (T.R EQ _) p =
                  T.uccase T.mkNoSrcPos p
                    (let
                      v1147v13v1163v14v1 (T.R EQ _) p =
                        T.uccase T.mkNoSrcPos p
                          (let
                            v1148v14v1162v15v1 (T.R EQ _) p =
                              T.uccase T.mkNoSrcPos p
                                (let
                                  v1149v15v1161v16v1 (T.R EQ _) p =
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v1150v16v1160v17v1 (T.R EQ _) p =
                                          T.uccase T.mkNoSrcPos p
                                            (let
                                              v1151v17v1159v18v1 (T.R EQ _) p =
                                                T.uccase T.mkNoSrcPos p
                                                  (let
                                                    v1152v18v1158v19v1
                                                      (T.R EQ _) p =
                                                      T.uccase T.mkNoSrcPos p
                                                        (let
                                                          v1153v19v1157v20v1
                                                            (T.R EQ _) p =
                                                            T.uccase
                                                              T.mkNoSrcPos p
                                                              (let
                                                                v1154v20v1156v21v1
                                                                  (T.R EQ _) p =
                                                                  T.uap2
                                                                    T.mkNoSrcPos
                                                                    p
                                                                    (gcompare
                                                                      T.mkNoSrcPos
                                                                      p) fk fk'
                                                                v1154v20v1156v21v1
                                                                  fx p =
                                                                  T.projection
                                                                    T.mkNoSrcPos
                                                                    p fx in
                                                                (v1154v20v1156v21v1))
                                                              (T.uap2
                                                                T.mkNoSrcPos p
                                                                (gcompare
                                                                  T.mkNoSrcPos
                                                                  p) fj fj')
                                                          v1153v19v1157v20v1 fx
                                                            p =
                                                            T.projection
                                                              T.mkNoSrcPos p fx
                                                          in
                                                          (v1153v19v1157v20v1))
                                                        (T.uap2 T.mkNoSrcPos p
                                                          (gcompare T.mkNoSrcPos
                                                            p) fi fi')
                                                    v1152v18v1158v19v1 fx p =
                                                      T.projection T.mkNoSrcPos
                                                        p fx in
                                                    (v1152v18v1158v19v1))
                                                  (T.uap2 T.mkNoSrcPos p
                                                    (gcompare T.mkNoSrcPos p) fh
                                                    fh')
                                              v1151v17v1159v18v1 fx p =
                                                T.projection T.mkNoSrcPos p fx
                                              in (v1151v17v1159v18v1))
                                            (T.uap2 T.mkNoSrcPos p
                                              (gcompare T.mkNoSrcPos p) fg fg')
                                        v1150v16v1160v17v1 fx p =
                                          T.projection T.mkNoSrcPos p fx in
                                        (v1150v16v1160v17v1))
                                      (T.uap2 T.mkNoSrcPos p
                                        (gcompare T.mkNoSrcPos p) ff ff')
                                  v1149v15v1161v16v1 fx p =
                                    T.projection T.mkNoSrcPos p fx in
                                  (v1149v15v1161v16v1))
                                (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p)
                                  fe fe')
                            v1148v14v1162v15v1 fx p =
                              T.projection T.mkNoSrcPos p fx in
                            (v1148v14v1162v15v1))
                          (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fd
                            fd')
                      v1147v13v1163v14v1 fx p = T.projection T.mkNoSrcPos p fx
                      in (v1147v13v1163v14v1))
                    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fc fc')
                v1146v12v1164v13v1 fx p = T.projection T.mkNoSrcPos p fx in
                (v1146v12v1164v13v1))
              (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fb fb')
          v1145v5v1164v13v1 _ p = T.fatal p in (v1145v5v1164v13v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fa')
    hcompare _ _ p = T.fatal p
    
  

instance
  (Bounded a,Bounded b,Bounded c,Bounded d,Bounded e,Bounded f,Bounded g
      ,Bounded h,Bounded i,Bounded j,Bounded k) =>
    Bounded ((T.Tuple11 a b c d e f g h i j k))
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a1169v3v1170v50minBound
      (\ p ->
        T.con11 T.mkNoSrcPos p T.Tuple11 T.aTuple11 (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p))
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a1171v3v1172v50maxBound
      (\ p ->
        T.con11 T.mkNoSrcPos p T.Tuple11 T.aTuple11 (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p))
  

instance
  (Eq a,Eq b,Eq c,Eq d,Eq e,Eq f,Eq g,Eq h,Eq i,Eq j,Eq k,Eq l) =>
    Eq ((T.Tuple12 a b c d e f g h i j k l))
  where
  
  (!==) (%==) p =
    T.ufun2 (+##^^=$>=##^^=%!==) (%==) p (*==)
    where
    
    (*==) (T.R (T.Tuple12 fa fb fc fd fe ff fg fh fi fj fk fl) _)
      (T.R (T.Tuple12 fa' fb' fc' fd' fe' ff' fg' fh' fi' fj' fk' fl') _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fa')
            *&&
            (T.uwrapForward p
              (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fb fb')
                  *&&
                  (T.uwrapForward p
                    (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fc fc')
                        *&&
                        (T.uwrapForward p
                          (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fd fd')
                              *&&
                              (T.uwrapForward p
                                (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fe
                                      fe')
                                    *&&
                                    (T.uwrapForward p
                                      (((T.uap2 T.mkNoSrcPos p
                                            (T.mkNoSrcPos !== p) ff ff')
                                          *&&
                                          (T.uwrapForward p
                                            (((T.uap2 T.mkNoSrcPos p
                                                  (T.mkNoSrcPos !== p) fg fg')
                                                *&&
                                                (T.uwrapForward p
                                                  (((T.uap2 T.mkNoSrcPos p
                                                        (T.mkNoSrcPos !== p) fh
                                                        fh')
                                                      *&&
                                                      (T.uwrapForward p
                                                        (((T.uap2 T.mkNoSrcPos p
                                                              (T.mkNoSrcPos
                                                                !==
                                                                p) fi fi')
                                                            *&&
                                                            (T.uwrapForward p
                                                              (((T.uap2
                                                                    T.mkNoSrcPos
                                                                    p
                                                                    (T.mkNoSrcPos
                                                                      !==
                                                                      p) fj fj')
                                                                  *&&
                                                                  (T.uwrapForward
                                                                    p
                                                                    (((T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (T.mkNoSrcPos
                                                                            !==
                                                                            p)
                                                                          fk
                                                                          fk')
                                                                        *&&
                                                                        (T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (T.mkNoSrcPos
                                                                            !==
                                                                            p)
                                                                          fl
                                                                          fl'))
                                                                      p))) p)))
                                                          p))) p))) p))) p)))
                                  p))) p))) p))) p))) p)
    (*==) _ _ p = T.fatal p
    
  

instance
  (Ord a,Ord b,Ord c,Ord d,Ord e,Ord f,Ord g,Ord h,Ord i,Ord j,Ord k,Ord l) =>
    Ord ((T.Tuple12 a b c d e f g h i j k l))
  where
  
  gcompare pcompare p =
    T.ufun2 a1184v3v1206v13compare pcompare p hcompare
    where
    
    hcompare (T.R (T.Tuple12 fa fb fc fd fe ff fg fh fi fj fk fl) _)
      (T.R (T.Tuple12 fa' fb' fc' fd' fe' ff' fg' fh' fi' fj' fk' fl') _) p =
      T.uccase T.mkNoSrcPos p
        (let
          v1185v5v1206v13v1 (T.R EQ _) p =
            T.uccase T.mkNoSrcPos p
              (let
                v1186v12v1206v13v1 (T.R EQ _) p =
                  T.uccase T.mkNoSrcPos p
                    (let
                      v1187v13v1205v14v1 (T.R EQ _) p =
                        T.uccase T.mkNoSrcPos p
                          (let
                            v1188v14v1204v15v1 (T.R EQ _) p =
                              T.uccase T.mkNoSrcPos p
                                (let
                                  v1189v15v1203v16v1 (T.R EQ _) p =
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v1190v16v1202v17v1 (T.R EQ _) p =
                                          T.uccase T.mkNoSrcPos p
                                            (let
                                              v1191v17v1201v18v1 (T.R EQ _) p =
                                                T.uccase T.mkNoSrcPos p
                                                  (let
                                                    v1192v18v1200v19v1
                                                      (T.R EQ _) p =
                                                      T.uccase T.mkNoSrcPos p
                                                        (let
                                                          v1193v19v1199v20v1
                                                            (T.R EQ _) p =
                                                            T.uccase
                                                              T.mkNoSrcPos p
                                                              (let
                                                                v1194v20v1198v21v1
                                                                  (T.R EQ _) p =
                                                                  T.uccase
                                                                    T.mkNoSrcPos
                                                                    p
                                                                    (let
                                                                      v1195v21v1197v23v1
                                                                        (T.R EQ
                                                                          _) p =
                                                                        T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (gcompare
                                                                            T.mkNoSrcPos
                                                                            p)
                                                                          fl fl'
                                                                      v1195v21v1197v23v1
                                                                        fx p =
                                                                        T.projection
                                                                          T.mkNoSrcPos
                                                                          p fx
                                                                      in
                                                                      (v1195v21v1197v23v1))
                                                                    (T.uap2
                                                                      T.mkNoSrcPos
                                                                      p
                                                                      (gcompare
                                                                        T.mkNoSrcPos
                                                                        p) fk
                                                                      fk')
                                                                v1194v20v1198v21v1
                                                                  fx p =
                                                                  T.projection
                                                                    T.mkNoSrcPos
                                                                    p fx in
                                                                (v1194v20v1198v21v1))
                                                              (T.uap2
                                                                T.mkNoSrcPos p
                                                                (gcompare
                                                                  T.mkNoSrcPos
                                                                  p) fj fj')
                                                          v1193v19v1199v20v1 fx
                                                            p =
                                                            T.projection
                                                              T.mkNoSrcPos p fx
                                                          in
                                                          (v1193v19v1199v20v1))
                                                        (T.uap2 T.mkNoSrcPos p
                                                          (gcompare T.mkNoSrcPos
                                                            p) fi fi')
                                                    v1192v18v1200v19v1 fx p =
                                                      T.projection T.mkNoSrcPos
                                                        p fx in
                                                    (v1192v18v1200v19v1))
                                                  (T.uap2 T.mkNoSrcPos p
                                                    (gcompare T.mkNoSrcPos p) fh
                                                    fh')
                                              v1191v17v1201v18v1 fx p =
                                                T.projection T.mkNoSrcPos p fx
                                              in (v1191v17v1201v18v1))
                                            (T.uap2 T.mkNoSrcPos p
                                              (gcompare T.mkNoSrcPos p) fg fg')
                                        v1190v16v1202v17v1 fx p =
                                          T.projection T.mkNoSrcPos p fx in
                                        (v1190v16v1202v17v1))
                                      (T.uap2 T.mkNoSrcPos p
                                        (gcompare T.mkNoSrcPos p) ff ff')
                                  v1189v15v1203v16v1 fx p =
                                    T.projection T.mkNoSrcPos p fx in
                                  (v1189v15v1203v16v1))
                                (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p)
                                  fe fe')
                            v1188v14v1204v15v1 fx p =
                              T.projection T.mkNoSrcPos p fx in
                            (v1188v14v1204v15v1))
                          (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fd
                            fd')
                      v1187v13v1205v14v1 fx p = T.projection T.mkNoSrcPos p fx
                      in (v1187v13v1205v14v1))
                    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fc fc')
                v1186v12v1206v13v1 fx p = T.projection T.mkNoSrcPos p fx in
                (v1186v12v1206v13v1))
              (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fb fb')
          v1185v5v1206v13v1 _ p = T.fatal p in (v1185v5v1206v13v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fa')
    hcompare _ _ p = T.fatal p
    
  

instance
  (Bounded a,Bounded b,Bounded c,Bounded d,Bounded e,Bounded f,Bounded g
      ,Bounded h,Bounded i,Bounded j,Bounded k,Bounded l) =>
    Bounded ((T.Tuple12 a b c d e f g h i j k l))
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a1211v3v1212v59minBound
      (\ p ->
        T.con12 T.mkNoSrcPos p T.Tuple12 T.aTuple12 (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p))
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a1213v3v1214v59maxBound
      (\ p ->
        T.con12 T.mkNoSrcPos p T.Tuple12 T.aTuple12 (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p))
  

instance
  (Eq a,Eq b,Eq c,Eq d,Eq e,Eq f,Eq g,Eq h,Eq i,Eq j,Eq k,Eq l,Eq m) =>
    Eq ((T.Tuple13 a b c d e f g h i j k l m))
  where
  
  (!==) (%==) p =
    T.ufun2 (+#$#>=%#=#$#>=%$==) (%==) p (*==)
    where
    
    (*==) (T.R (T.Tuple13 fa fb fc fd fe ff fg fh fi fj fk fl fm) _)
      (T.R (T.Tuple13 fa' fb' fc' fd' fe' ff' fg' fh' fi' fj' fk' fl' fm') _)
      p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fa')
            *&&
            (T.uwrapForward p
              (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fb fb')
                  *&&
                  (T.uwrapForward p
                    (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fc fc')
                        *&&
                        (T.uwrapForward p
                          (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fd fd')
                              *&&
                              (T.uwrapForward p
                                (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fe
                                      fe')
                                    *&&
                                    (T.uwrapForward p
                                      (((T.uap2 T.mkNoSrcPos p
                                            (T.mkNoSrcPos !== p) ff ff')
                                          *&&
                                          (T.uwrapForward p
                                            (((T.uap2 T.mkNoSrcPos p
                                                  (T.mkNoSrcPos !== p) fg fg')
                                                *&&
                                                (T.uwrapForward p
                                                  (((T.uap2 T.mkNoSrcPos p
                                                        (T.mkNoSrcPos !== p) fh
                                                        fh')
                                                      *&&
                                                      (T.uwrapForward p
                                                        (((T.uap2 T.mkNoSrcPos p
                                                              (T.mkNoSrcPos
                                                                !==
                                                                p) fi fi')
                                                            *&&
                                                            (T.uwrapForward p
                                                              (((T.uap2
                                                                    T.mkNoSrcPos
                                                                    p
                                                                    (T.mkNoSrcPos
                                                                      !==
                                                                      p) fj fj')
                                                                  *&&
                                                                  (T.uwrapForward
                                                                    p
                                                                    (((T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (T.mkNoSrcPos
                                                                            !==
                                                                            p)
                                                                          fk
                                                                          fk')
                                                                        *&&
                                                                        (T.uwrapForward
                                                                          p
                                                                          (((T.uap2
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (T.mkNoSrcPos
                                                                                  !==
                                                                                  p)
                                                                                fl
                                                                                fl')
                                                                              *&&
                                                                              (T.uap2
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (T.mkNoSrcPos
                                                                                  !==
                                                                                  p)
                                                                                fm
                                                                                fm'))
                                                                            p)))
                                                                      p))) p)))
                                                          p))) p))) p))) p)))
                                  p))) p))) p))) p))) p)
    (*==) _ _ p = T.fatal p
    
  

instance
  (Ord a,Ord b,Ord c,Ord d,Ord e,Ord f,Ord g,Ord h,Ord i,Ord j,Ord k,Ord l
      ,Ord m) => Ord ((T.Tuple13 a b c d e f g h i j k l m))
  where
  
  gcompare pcompare p =
    T.ufun2 a1226v3v1251v13compare pcompare p hcompare
    where
    
    hcompare (T.R (T.Tuple13 fa fb fc fd fe ff fg fh fi fj fk fl fm) _)
      (T.R (T.Tuple13 fa' fb' fc' fd' fe' ff' fg' fh' fi' fj' fk' fl' fm') _)
      p =
      T.uccase T.mkNoSrcPos p
        (let
          v1228v5v1251v13v1 (T.R EQ _) p =
            T.uccase T.mkNoSrcPos p
              (let
                v1229v12v1251v13v1 (T.R EQ _) p =
                  T.uccase T.mkNoSrcPos p
                    (let
                      v1230v13v1250v14v1 (T.R EQ _) p =
                        T.uccase T.mkNoSrcPos p
                          (let
                            v1231v14v1249v15v1 (T.R EQ _) p =
                              T.uccase T.mkNoSrcPos p
                                (let
                                  v1232v15v1248v16v1 (T.R EQ _) p =
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v1233v16v1247v17v1 (T.R EQ _) p =
                                          T.uccase T.mkNoSrcPos p
                                            (let
                                              v1234v17v1246v18v1 (T.R EQ _) p =
                                                T.uccase T.mkNoSrcPos p
                                                  (let
                                                    v1235v18v1245v19v1
                                                      (T.R EQ _) p =
                                                      T.uccase T.mkNoSrcPos p
                                                        (let
                                                          v1236v19v1244v20v1
                                                            (T.R EQ _) p =
                                                            T.uccase
                                                              T.mkNoSrcPos p
                                                              (let
                                                                v1237v20v1243v21v1
                                                                  (T.R EQ _) p =
                                                                  T.uccase
                                                                    T.mkNoSrcPos
                                                                    p
                                                                    (let
                                                                      v1238v21v1242v22v1
                                                                        (T.R EQ
                                                                          _) p =
                                                                        T.uccase
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (let
                                                                            v1239v22v1241v23v1
                                                                              (T.R
                                                                                EQ
                                                                                _)
                                                                              p =
                                                                              T.uap2
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (gcompare
                                                                                  T.mkNoSrcPos
                                                                                  p)
                                                                                fm
                                                                                fm'
                                                                            v1239v22v1241v23v1
                                                                              fx
                                                                              p =
                                                                              T.projection
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                fx
                                                                            in
                                                                            (v1239v22v1241v23v1))
                                                                          (T.uap2
                                                                            T.mkNoSrcPos
                                                                            p
                                                                            (gcompare
                                                                              T.mkNoSrcPos
                                                                              p)
                                                                            fl
                                                                            fl')
                                                                      v1238v21v1242v22v1
                                                                        fx p =
                                                                        T.projection
                                                                          T.mkNoSrcPos
                                                                          p fx
                                                                      in
                                                                      (v1238v21v1242v22v1))
                                                                    (T.uap2
                                                                      T.mkNoSrcPos
                                                                      p
                                                                      (gcompare
                                                                        T.mkNoSrcPos
                                                                        p) fk
                                                                      fk')
                                                                v1237v20v1243v21v1
                                                                  fx p =
                                                                  T.projection
                                                                    T.mkNoSrcPos
                                                                    p fx in
                                                                (v1237v20v1243v21v1))
                                                              (T.uap2
                                                                T.mkNoSrcPos p
                                                                (gcompare
                                                                  T.mkNoSrcPos
                                                                  p) fj fj')
                                                          v1236v19v1244v20v1 fx
                                                            p =
                                                            T.projection
                                                              T.mkNoSrcPos p fx
                                                          in
                                                          (v1236v19v1244v20v1))
                                                        (T.uap2 T.mkNoSrcPos p
                                                          (gcompare T.mkNoSrcPos
                                                            p) fi fi')
                                                    v1235v18v1245v19v1 fx p =
                                                      T.projection T.mkNoSrcPos
                                                        p fx in
                                                    (v1235v18v1245v19v1))
                                                  (T.uap2 T.mkNoSrcPos p
                                                    (gcompare T.mkNoSrcPos p) fh
                                                    fh')
                                              v1234v17v1246v18v1 fx p =
                                                T.projection T.mkNoSrcPos p fx
                                              in (v1234v17v1246v18v1))
                                            (T.uap2 T.mkNoSrcPos p
                                              (gcompare T.mkNoSrcPos p) fg fg')
                                        v1233v16v1247v17v1 fx p =
                                          T.projection T.mkNoSrcPos p fx in
                                        (v1233v16v1247v17v1))
                                      (T.uap2 T.mkNoSrcPos p
                                        (gcompare T.mkNoSrcPos p) ff ff')
                                  v1232v15v1248v16v1 fx p =
                                    T.projection T.mkNoSrcPos p fx in
                                  (v1232v15v1248v16v1))
                                (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p)
                                  fe fe')
                            v1231v14v1249v15v1 fx p =
                              T.projection T.mkNoSrcPos p fx in
                            (v1231v14v1249v15v1))
                          (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fd
                            fd')
                      v1230v13v1250v14v1 fx p = T.projection T.mkNoSrcPos p fx
                      in (v1230v13v1250v14v1))
                    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fc fc')
                v1229v12v1251v13v1 fx p = T.projection T.mkNoSrcPos p fx in
                (v1229v12v1251v13v1))
              (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fb fb')
          v1228v5v1251v13v1 _ p = T.fatal p in (v1228v5v1251v13v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fa')
    hcompare _ _ p = T.fatal p
    
  

instance
  (Bounded a,Bounded b,Bounded c,Bounded d,Bounded e,Bounded f,Bounded g
      ,Bounded h,Bounded i,Bounded j,Bounded k,Bounded l,Bounded m) =>
    Bounded ((T.Tuple13 a b c d e f g h i j k l m))
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a1257v3v1258v68minBound
      (\ p ->
        T.con13 T.mkNoSrcPos p T.Tuple13 T.aTuple13 (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p))
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a1259v3v1260v68maxBound
      (\ p ->
        T.con13 T.mkNoSrcPos p T.Tuple13 T.aTuple13 (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p))
  

instance
  (Eq a,Eq b,Eq c,Eq d,Eq e,Eq f,Eq g,Eq h,Eq i,Eq j,Eq k,Eq l,Eq m,Eq n) =>
    Eq ((T.Tuple14 a b c d e f g h i j k l m n))
  where
  
  (!==) (%==) p =
    T.ufun2 (+#$+*=%%=#$+*=%&==) (%==) p (*==)
    where
    
    (*==) (T.R (T.Tuple14 fa fb fc fd fe ff fg fh fi fj fk fl fm fn) _)
      (T.R (T.Tuple14 fa' fb' fc' fd' fe' ff' fg' fh' fi' fj' fk' fl' fm' fn')
        _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fa')
            *&&
            (T.uwrapForward p
              (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fb fb')
                  *&&
                  (T.uwrapForward p
                    (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fc fc')
                        *&&
                        (T.uwrapForward p
                          (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fd fd')
                              *&&
                              (T.uwrapForward p
                                (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fe
                                      fe')
                                    *&&
                                    (T.uwrapForward p
                                      (((T.uap2 T.mkNoSrcPos p
                                            (T.mkNoSrcPos !== p) ff ff')
                                          *&&
                                          (T.uwrapForward p
                                            (((T.uap2 T.mkNoSrcPos p
                                                  (T.mkNoSrcPos !== p) fg fg')
                                                *&&
                                                (T.uwrapForward p
                                                  (((T.uap2 T.mkNoSrcPos p
                                                        (T.mkNoSrcPos !== p) fh
                                                        fh')
                                                      *&&
                                                      (T.uwrapForward p
                                                        (((T.uap2 T.mkNoSrcPos p
                                                              (T.mkNoSrcPos
                                                                !==
                                                                p) fi fi')
                                                            *&&
                                                            (T.uwrapForward p
                                                              (((T.uap2
                                                                    T.mkNoSrcPos
                                                                    p
                                                                    (T.mkNoSrcPos
                                                                      !==
                                                                      p) fj fj')
                                                                  *&&
                                                                  (T.uwrapForward
                                                                    p
                                                                    (((T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (T.mkNoSrcPos
                                                                            !==
                                                                            p)
                                                                          fk
                                                                          fk')
                                                                        *&&
                                                                        (T.uwrapForward
                                                                          p
                                                                          (((T.uap2
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (T.mkNoSrcPos
                                                                                  !==
                                                                                  p)
                                                                                fl
                                                                                fl')
                                                                              *&&
                                                                              (T.uwrapForward
                                                                                p
                                                                                (((T.uap2
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      (T.mkNoSrcPos
                                                                                        !==
                                                                                        p)
                                                                                      fm
                                                                                      fm')
                                                                                    *&&
                                                                                    (T.uap2
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      (T.mkNoSrcPos
                                                                                        !==
                                                                                        p)
                                                                                      fn
                                                                                      fn'))
                                                                                  p)))
                                                                            p)))
                                                                      p))) p)))
                                                          p))) p))) p))) p)))
                                  p))) p))) p))) p))) p)
    (*==) _ _ p = T.fatal p
    
  

instance
  (Ord a,Ord b,Ord c,Ord d,Ord e,Ord f,Ord g,Ord h,Ord i,Ord j,Ord k,Ord l,Ord m
      ,Ord n) => Ord ((T.Tuple14 a b c d e f g h i j k l m n))
  where
  
  gcompare pcompare p =
    T.ufun2 a1274v3v1301v13compare pcompare p hcompare
    where
    
    hcompare (T.R (T.Tuple14 fa fb fc fd fe ff fg fh fi fj fk fl fm fn) _)
      (T.R (T.Tuple14 fa' fb' fc' fd' fe' ff' fg' fh' fi' fj' fk' fl' fm' fn')
        _) p =
      T.uccase T.mkNoSrcPos p
        (let
          v1276v5v1301v13v1 (T.R EQ _) p =
            T.uccase T.mkNoSrcPos p
              (let
                v1277v12v1301v13v1 (T.R EQ _) p =
                  T.uccase T.mkNoSrcPos p
                    (let
                      v1278v13v1300v14v1 (T.R EQ _) p =
                        T.uccase T.mkNoSrcPos p
                          (let
                            v1279v14v1299v15v1 (T.R EQ _) p =
                              T.uccase T.mkNoSrcPos p
                                (let
                                  v1280v15v1298v16v1 (T.R EQ _) p =
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v1281v16v1297v17v1 (T.R EQ _) p =
                                          T.uccase T.mkNoSrcPos p
                                            (let
                                              v1282v17v1296v18v1 (T.R EQ _) p =
                                                T.uccase T.mkNoSrcPos p
                                                  (let
                                                    v1283v18v1295v19v1
                                                      (T.R EQ _) p =
                                                      T.uccase T.mkNoSrcPos p
                                                        (let
                                                          v1284v19v1294v20v1
                                                            (T.R EQ _) p =
                                                            T.uccase
                                                              T.mkNoSrcPos p
                                                              (let
                                                                v1285v20v1293v21v1
                                                                  (T.R EQ _) p =
                                                                  T.uccase
                                                                    T.mkNoSrcPos
                                                                    p
                                                                    (let
                                                                      v1286v21v1292v22v1
                                                                        (T.R EQ
                                                                          _) p =
                                                                        T.uccase
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (let
                                                                            v1287v22v1291v23v1
                                                                              (T.R
                                                                                EQ
                                                                                _)
                                                                              p =
                                                                              T.uccase
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (let
                                                                                  v1288v23v1290v24v1
                                                                                    (T.R
                                                                                      EQ
                                                                                      _)
                                                                                    p =
                                                                                    T.uap2
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      (gcompare
                                                                                        T.mkNoSrcPos
                                                                                        p)
                                                                                      fn
                                                                                      fn'
                                                                                  v1288v23v1290v24v1
                                                                                    fx
                                                                                    p =
                                                                                    T.projection
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      fx
                                                                                  in
                                                                                  (v1288v23v1290v24v1))
                                                                                (T.uap2
                                                                                  T.mkNoSrcPos
                                                                                  p
                                                                                  (gcompare
                                                                                    T.mkNoSrcPos
                                                                                    p)
                                                                                  fm
                                                                                  fm')
                                                                            v1287v22v1291v23v1
                                                                              fx
                                                                              p =
                                                                              T.projection
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                fx
                                                                            in
                                                                            (v1287v22v1291v23v1))
                                                                          (T.uap2
                                                                            T.mkNoSrcPos
                                                                            p
                                                                            (gcompare
                                                                              T.mkNoSrcPos
                                                                              p)
                                                                            fl
                                                                            fl')
                                                                      v1286v21v1292v22v1
                                                                        fx p =
                                                                        T.projection
                                                                          T.mkNoSrcPos
                                                                          p fx
                                                                      in
                                                                      (v1286v21v1292v22v1))
                                                                    (T.uap2
                                                                      T.mkNoSrcPos
                                                                      p
                                                                      (gcompare
                                                                        T.mkNoSrcPos
                                                                        p) fk
                                                                      fk')
                                                                v1285v20v1293v21v1
                                                                  fx p =
                                                                  T.projection
                                                                    T.mkNoSrcPos
                                                                    p fx in
                                                                (v1285v20v1293v21v1))
                                                              (T.uap2
                                                                T.mkNoSrcPos p
                                                                (gcompare
                                                                  T.mkNoSrcPos
                                                                  p) fj fj')
                                                          v1284v19v1294v20v1 fx
                                                            p =
                                                            T.projection
                                                              T.mkNoSrcPos p fx
                                                          in
                                                          (v1284v19v1294v20v1))
                                                        (T.uap2 T.mkNoSrcPos p
                                                          (gcompare T.mkNoSrcPos
                                                            p) fi fi')
                                                    v1283v18v1295v19v1 fx p =
                                                      T.projection T.mkNoSrcPos
                                                        p fx in
                                                    (v1283v18v1295v19v1))
                                                  (T.uap2 T.mkNoSrcPos p
                                                    (gcompare T.mkNoSrcPos p) fh
                                                    fh')
                                              v1282v17v1296v18v1 fx p =
                                                T.projection T.mkNoSrcPos p fx
                                              in (v1282v17v1296v18v1))
                                            (T.uap2 T.mkNoSrcPos p
                                              (gcompare T.mkNoSrcPos p) fg fg')
                                        v1281v16v1297v17v1 fx p =
                                          T.projection T.mkNoSrcPos p fx in
                                        (v1281v16v1297v17v1))
                                      (T.uap2 T.mkNoSrcPos p
                                        (gcompare T.mkNoSrcPos p) ff ff')
                                  v1280v15v1298v16v1 fx p =
                                    T.projection T.mkNoSrcPos p fx in
                                  (v1280v15v1298v16v1))
                                (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p)
                                  fe fe')
                            v1279v14v1299v15v1 fx p =
                              T.projection T.mkNoSrcPos p fx in
                            (v1279v14v1299v15v1))
                          (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fd
                            fd')
                      v1278v13v1300v14v1 fx p = T.projection T.mkNoSrcPos p fx
                      in (v1278v13v1300v14v1))
                    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fc fc')
                v1277v12v1301v13v1 fx p = T.projection T.mkNoSrcPos p fx in
                (v1277v12v1301v13v1))
              (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fb fb')
          v1276v5v1301v13v1 _ p = T.fatal p in (v1276v5v1301v13v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fa')
    hcompare _ _ p = T.fatal p
    
  

instance
  (Bounded a,Bounded b,Bounded c,Bounded d,Bounded e,Bounded f,Bounded g
      ,Bounded h,Bounded i,Bounded j,Bounded k,Bounded l,Bounded m,Bounded n) =>
    Bounded ((T.Tuple14 a b c d e f g h i j k l m n))
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a1307v3v1308v77minBound
      (\ p ->
        T.con14 T.mkNoSrcPos p T.Tuple14 T.aTuple14 (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p))
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a1309v3v1310v77maxBound
      (\ p ->
        T.con14 T.mkNoSrcPos p T.Tuple14 T.aTuple14 (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p))
  

instance
  (Eq a,Eq b,Eq c,Eq d,Eq e,Eq f,Eq g,Eq h,Eq i,Eq j,Eq k,Eq l,Eq m,Eq n
      ,Eq o) => Eq ((T.Tuple15 a b c d e f g h i j k l m n o))
  where
  
  (!==) (%==) p =
    T.ufun2 (+#%#+=%*=#%#+=%+==) (%==) p (*==)
    where
    
    (*==) (T.R (T.Tuple15 fa fb fc fd fe ff fg fh fi fj fk fl fm fn fo) _)
      (T.R
        (T.Tuple15 fa' fb' fc' fd' fe' ff' fg' fh' fi' fj' fk' fl' fm' fn' fo')
        _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fa fa')
            *&&
            (T.uwrapForward p
              (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fb fb')
                  *&&
                  (T.uwrapForward p
                    (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fc fc')
                        *&&
                        (T.uwrapForward p
                          (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fd fd')
                              *&&
                              (T.uwrapForward p
                                (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fe
                                      fe')
                                    *&&
                                    (T.uwrapForward p
                                      (((T.uap2 T.mkNoSrcPos p
                                            (T.mkNoSrcPos !== p) ff ff')
                                          *&&
                                          (T.uwrapForward p
                                            (((T.uap2 T.mkNoSrcPos p
                                                  (T.mkNoSrcPos !== p) fg fg')
                                                *&&
                                                (T.uwrapForward p
                                                  (((T.uap2 T.mkNoSrcPos p
                                                        (T.mkNoSrcPos !== p) fh
                                                        fh')
                                                      *&&
                                                      (T.uwrapForward p
                                                        (((T.uap2 T.mkNoSrcPos p
                                                              (T.mkNoSrcPos
                                                                !==
                                                                p) fi fi')
                                                            *&&
                                                            (T.uwrapForward p
                                                              (((T.uap2
                                                                    T.mkNoSrcPos
                                                                    p
                                                                    (T.mkNoSrcPos
                                                                      !==
                                                                      p) fj fj')
                                                                  *&&
                                                                  (T.uwrapForward
                                                                    p
                                                                    (((T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (T.mkNoSrcPos
                                                                            !==
                                                                            p)
                                                                          fk
                                                                          fk')
                                                                        *&&
                                                                        (T.uwrapForward
                                                                          p
                                                                          (((T.uap2
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (T.mkNoSrcPos
                                                                                  !==
                                                                                  p)
                                                                                fl
                                                                                fl')
                                                                              *&&
                                                                              (T.uwrapForward
                                                                                p
                                                                                (((T.uap2
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      (T.mkNoSrcPos
                                                                                        !==
                                                                                        p)
                                                                                      fm
                                                                                      fm')
                                                                                    *&&
                                                                                    (T.uwrapForward
                                                                                      p
                                                                                      (((T.uap2
                                                                                            T.mkNoSrcPos
                                                                                            p
                                                                                            (T.mkNoSrcPos
                                                                                              !==
                                                                                              p)
                                                                                            fn
                                                                                            fn')
                                                                                          *&&
                                                                                          (T.uap2
                                                                                            T.mkNoSrcPos
                                                                                            p
                                                                                            (T.mkNoSrcPos
                                                                                              !==
                                                                                              p)
                                                                                            fo
                                                                                            fo'))
                                                                                        p)))
                                                                                  p)))
                                                                            p)))
                                                                      p))) p)))
                                                          p))) p))) p))) p)))
                                  p))) p))) p))) p))) p)
    (*==) _ _ p = T.fatal p
    
  

instance
  (Ord a,Ord b,Ord c,Ord d,Ord e,Ord f,Ord g,Ord h,Ord i,Ord j,Ord k,Ord l,Ord m
      ,Ord n,Ord o) => Ord ((T.Tuple15 a b c d e f g h i j k l m n o))
  where
  
  gcompare pcompare p =
    T.ufun2 a1325v3v1354v13compare pcompare p hcompare
    where
    
    hcompare (T.R (T.Tuple15 fa fb fc fd fe ff fg fh fi fj fk fl fm fn fo) _)
      (T.R
        (T.Tuple15 fa' fb' fc' fd' fe' ff' fg' fh' fi' fj' fk' fl' fm' fn' fo')
        _) p =
      T.uccase T.mkNoSrcPos p
        (let
          v1327v5v1354v13v1 (T.R EQ _) p =
            T.uccase T.mkNoSrcPos p
              (let
                v1328v12v1354v13v1 (T.R EQ _) p =
                  T.uccase T.mkNoSrcPos p
                    (let
                      v1329v13v1353v14v1 (T.R EQ _) p =
                        T.uccase T.mkNoSrcPos p
                          (let
                            v1330v14v1352v15v1 (T.R EQ _) p =
                              T.uccase T.mkNoSrcPos p
                                (let
                                  v1331v15v1351v16v1 (T.R EQ _) p =
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v1332v16v1350v17v1 (T.R EQ _) p =
                                          T.uccase T.mkNoSrcPos p
                                            (let
                                              v1333v17v1349v18v1 (T.R EQ _) p =
                                                T.uccase T.mkNoSrcPos p
                                                  (let
                                                    v1334v18v1348v19v1
                                                      (T.R EQ _) p =
                                                      T.uccase T.mkNoSrcPos p
                                                        (let
                                                          v1335v19v1347v20v1
                                                            (T.R EQ _) p =
                                                            T.uccase
                                                              T.mkNoSrcPos p
                                                              (let
                                                                v1336v20v1346v21v1
                                                                  (T.R EQ _) p =
                                                                  T.uccase
                                                                    T.mkNoSrcPos
                                                                    p
                                                                    (let
                                                                      v1337v21v1345v22v1
                                                                        (T.R EQ
                                                                          _) p =
                                                                        T.uccase
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (let
                                                                            v1338v22v1344v23v1
                                                                              (T.R
                                                                                EQ
                                                                                _)
                                                                              p =
                                                                              T.uccase
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (let
                                                                                  v1339v23v1343v24v1
                                                                                    (T.R
                                                                                      EQ
                                                                                      _)
                                                                                    p =
                                                                                    T.uccase
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      (let
                                                                                        v1340v24v1342v25v1
                                                                                          (T.R
                                                                                            EQ
                                                                                            _)
                                                                                          p =
                                                                                          T.uap2
                                                                                            T.mkNoSrcPos
                                                                                            p
                                                                                            (gcompare
                                                                                              T.mkNoSrcPos
                                                                                              p)
                                                                                            fo
                                                                                            fo'
                                                                                        v1340v24v1342v25v1
                                                                                          fx
                                                                                          p =
                                                                                          T.projection
                                                                                            T.mkNoSrcPos
                                                                                            p
                                                                                            fx
                                                                                        in
                                                                                        (v1340v24v1342v25v1))
                                                                                      (T.uap2
                                                                                        T.mkNoSrcPos
                                                                                        p
                                                                                        (gcompare
                                                                                          T.mkNoSrcPos
                                                                                          p)
                                                                                        fn
                                                                                        fn')
                                                                                  v1339v23v1343v24v1
                                                                                    fx
                                                                                    p =
                                                                                    T.projection
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      fx
                                                                                  in
                                                                                  (v1339v23v1343v24v1))
                                                                                (T.uap2
                                                                                  T.mkNoSrcPos
                                                                                  p
                                                                                  (gcompare
                                                                                    T.mkNoSrcPos
                                                                                    p)
                                                                                  fm
                                                                                  fm')
                                                                            v1338v22v1344v23v1
                                                                              fx
                                                                              p =
                                                                              T.projection
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                fx
                                                                            in
                                                                            (v1338v22v1344v23v1))
                                                                          (T.uap2
                                                                            T.mkNoSrcPos
                                                                            p
                                                                            (gcompare
                                                                              T.mkNoSrcPos
                                                                              p)
                                                                            fl
                                                                            fl')
                                                                      v1337v21v1345v22v1
                                                                        fx p =
                                                                        T.projection
                                                                          T.mkNoSrcPos
                                                                          p fx
                                                                      in
                                                                      (v1337v21v1345v22v1))
                                                                    (T.uap2
                                                                      T.mkNoSrcPos
                                                                      p
                                                                      (gcompare
                                                                        T.mkNoSrcPos
                                                                        p) fk
                                                                      fk')
                                                                v1336v20v1346v21v1
                                                                  fx p =
                                                                  T.projection
                                                                    T.mkNoSrcPos
                                                                    p fx in
                                                                (v1336v20v1346v21v1))
                                                              (T.uap2
                                                                T.mkNoSrcPos p
                                                                (gcompare
                                                                  T.mkNoSrcPos
                                                                  p) fj fj')
                                                          v1335v19v1347v20v1 fx
                                                            p =
                                                            T.projection
                                                              T.mkNoSrcPos p fx
                                                          in
                                                          (v1335v19v1347v20v1))
                                                        (T.uap2 T.mkNoSrcPos p
                                                          (gcompare T.mkNoSrcPos
                                                            p) fi fi')
                                                    v1334v18v1348v19v1 fx p =
                                                      T.projection T.mkNoSrcPos
                                                        p fx in
                                                    (v1334v18v1348v19v1))
                                                  (T.uap2 T.mkNoSrcPos p
                                                    (gcompare T.mkNoSrcPos p) fh
                                                    fh')
                                              v1333v17v1349v18v1 fx p =
                                                T.projection T.mkNoSrcPos p fx
                                              in (v1333v17v1349v18v1))
                                            (T.uap2 T.mkNoSrcPos p
                                              (gcompare T.mkNoSrcPos p) fg fg')
                                        v1332v16v1350v17v1 fx p =
                                          T.projection T.mkNoSrcPos p fx in
                                        (v1332v16v1350v17v1))
                                      (T.uap2 T.mkNoSrcPos p
                                        (gcompare T.mkNoSrcPos p) ff ff')
                                  v1331v15v1351v16v1 fx p =
                                    T.projection T.mkNoSrcPos p fx in
                                  (v1331v15v1351v16v1))
                                (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p)
                                  fe fe')
                            v1330v14v1352v15v1 fx p =
                              T.projection T.mkNoSrcPos p fx in
                            (v1330v14v1352v15v1))
                          (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fd
                            fd')
                      v1329v13v1353v14v1 fx p = T.projection T.mkNoSrcPos p fx
                      in (v1329v13v1353v14v1))
                    (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fc fc')
                v1328v12v1354v13v1 fx p = T.projection T.mkNoSrcPos p fx in
                (v1328v12v1354v13v1))
              (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fb fb')
          v1327v5v1354v13v1 _ p = T.fatal p in (v1327v5v1354v13v1))
        (T.uap2 T.mkNoSrcPos p (gcompare T.mkNoSrcPos p) fa fa')
    hcompare _ _ p = T.fatal p
    
  

instance
  (Bounded a,Bounded b,Bounded c,Bounded d,Bounded e,Bounded f,Bounded g
      ,Bounded h,Bounded i,Bounded j,Bounded k,Bounded l,Bounded m,Bounded n
      ,Bounded o) => Bounded ((T.Tuple15 a b c d e f g h i j k l m n o))
  where
  
  gminBound pminBound p = T.uconstUse pminBound p sminBound
  
  sminBound =
    T.uconstDef T.mkRoot a1360v3v1362v23minBound
      (\ p ->
        T.con15 T.mkNoSrcPos p T.Tuple15 T.aTuple15 (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p)
          (gminBound T.mkNoSrcPos p) (gminBound T.mkNoSrcPos p))
  
  gmaxBound pmaxBound p = T.uconstUse pmaxBound p smaxBound
  
  smaxBound =
    T.uconstDef T.mkRoot a1363v3v1365v23maxBound
      (\ p ->
        T.con15 T.mkNoSrcPos p T.Tuple15 T.aTuple15 (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p)
          (gmaxBound T.mkNoSrcPos p) (gmaxBound T.mkNoSrcPos p))
  

gfst :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.Tuple2 a b) a)

hfst :: (T.R (T.Tuple2 a b)) -> T.RefExp -> T.R a

gfst pfst p = T.ufun1 afst pfst p hfst

hfst (T.R (T.Tuple2 fx fy) _) p = T.projection T.mkNoSrcPos p fx
hfst _ p = T.fatal p

gsnd :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.Tuple2 a b) b)

hsnd :: (T.R (T.Tuple2 a b)) -> T.RefExp -> T.R b

gsnd psnd p = T.ufun1 asnd psnd p hsnd

hsnd (T.R (T.Tuple2 fx fy) _) p = T.projection T.mkNoSrcPos p fy
hsnd _ p = T.fatal p

gcurry ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun (T.Tuple2 a b) c) (T.Fun a (T.Fun b c)))

hcurry ::
  (T.R (T.Fun (T.Tuple2 a b) c)) -> (T.R a) -> (T.R b) -> T.RefExp -> T.R c

gcurry pcurry p = T.ufun3 acurry pcurry p hcurry

hcurry ff fx fy p =
  T.uap1 T.mkNoSrcPos p ff
    (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2 (T.projection T.mkNoSrcPos p fx)
      (T.projection T.mkNoSrcPos p fy))

guncurry ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a (T.Fun b c)) (T.Fun (T.Tuple2 a b) c))

huncurry ::
  (T.R (T.Fun a (T.Fun b c))) -> (T.R (T.Tuple2 a b)) -> T.RefExp -> T.R c

guncurry puncurry p = T.ufun2 auncurry puncurry p huncurry

huncurry ff fp p =
  T.uap2 T.mkNoSrcPos p ff (T.uwrapForward p (hfst fp p))
    (T.uwrapForward p (hsnd fp p))

guntil ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a Bool) (T.Fun (T.Fun a a) (T.Fun a a)))

huntil ::
  (T.R (T.Fun a Bool)) -> (T.R (T.Fun a a)) -> (T.R a) -> T.RefExp -> T.R a

guntil puntil p = T.ufun3 auntil puntil p huntil

huntil fp ff fx p =
  T.ucguard (T.uap1 T.mkNoSrcPos p fp fx) (T.projection T.mkNoSrcPos p fx)
    (T.ucguard (gotherwise T.mkNoSrcPos p)
      (T.uwrapForward p (huntil fp ff (T.uap1 T.mkNoSrcPos p ff fx) p))
      (T.fatal p))

gasTypeOf :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))

sasTypeOf :: T.R (T.Fun a (T.Fun a a))

gasTypeOf pasTypeOf p = T.uconstUse pasTypeOf p sasTypeOf

sasTypeOf = T.uconstDef T.mkRoot aasTypeOf (\ p -> gconst T.mkNoSrcPos p)

g_foldr ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a (T.Fun b b)) (T.Fun (T.List a) (T.Fun b b)))

h_foldr ::
  (T.R (T.Fun a (T.Fun b b))) ->
    (T.R (T.List a)) -> (T.R b) -> T.RefExp -> T.R b

g_foldr p_foldr p = T.ufun3 a_foldr p_foldr p h_foldr

h_foldr ff (T.R T.List _) fd p = T.projection T.mkNoSrcPos p fd
h_foldr ff (T.R (T.Cons fx fxs) _) fd p =
  T.uap2 T.mkNoSrcPos p ff fx (T.uwrapForward p (h_foldr ff fxs fd p))
h_foldr _ _ _ p = T.fatal p

g_filter ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun Bool
          (T.Fun (T.Fun (T.List a) (T.List a)) (T.Fun (T.List a) (T.List a))))

h_filter ::
  (T.R Bool) ->
    (T.R (T.Fun (T.List a) (T.List a))) ->
      (T.R (T.List a)) -> T.RefExp -> T.R (T.List a)

g_filter p_filter p = T.ufun3 a_filter p_filter p h_filter

h_filter fb fe fr p =
  T.ucif p fb (T.uap1 T.mkNoSrcPos p fe fr) (T.projection T.mkNoSrcPos p fr)

gmap ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a b) (T.Fun (T.List a) (T.List b)))

hmap :: (T.R (T.Fun a b)) -> (T.R (T.List a)) -> T.RefExp -> T.R (T.List b)

gmap pmap p = T.ufun2 amap pmap p hmap

hmap ff (T.R T.List _) p = T.con0 T.mkNoSrcPos p T.List T.aList
hmap ff (T.R (T.Cons fx fxs) _) p =
  T.con2 T.mkNoSrcPos p T.Cons T.aCons (T.uap1 T.mkNoSrcPos p ff fx)
    (T.uwrapForward p (hmap ff fxs p))
hmap _ _ p = T.fatal p

(!++) ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.List a) (T.Fun (T.List a) (T.List a)))

(*++) :: (T.R (T.List a)) -> (T.R (T.List a)) -> T.RefExp -> T.R (T.List a)

(!++) (%++) p = T.ufun2 (+++) (%++) p (*++)

(*++) (T.R T.List _) fys p = T.projection T.mkNoSrcPos p fys
(*++) (T.R (T.Cons fx fxs) _) fys p =
  T.con2 T.mkNoSrcPos p T.Cons T.aCons fx (T.uwrapForward p ((fxs *++ fys) p))
(*++) _ _ p = T.fatal p

gfilter ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a Bool) (T.Fun (T.List a) (T.List a)))

hfilter ::
  (T.R (T.Fun a Bool)) -> (T.R (T.List a)) -> T.RefExp -> T.R (T.List a)

gfilter pfilter p = T.ufun2 afilter pfilter p hfilter

hfilter fp (T.R T.List _) p = T.con0 T.mkNoSrcPos p T.List T.aList
hfilter fp (T.R (T.Cons fx fxs) _) p =
  T.ucguard (T.uap1 T.mkNoSrcPos p fp fx)
    (T.con2 T.mkNoSrcPos p T.Cons T.aCons fx
      (T.uwrapForward p (hfilter fp fxs p)))
    (T.ucguard (gotherwise T.mkNoSrcPos p) (T.uwrapForward p (hfilter fp fxs p))
      (T.fatal p))
hfilter _ _ p = T.fatal p

gconcat :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List (T.List a)) (T.List a))

hconcat :: (T.R (T.List (T.List a))) -> T.RefExp -> T.R (T.List a)

gconcat pconcat p = T.ufun1 aconcat pconcat p hconcat

hconcat fxss p =
  T.uwrapForward p
    (hfoldr (T.mkNoSrcPos !++ p) (T.con0 T.mkNoSrcPos p T.List T.aList) fxss p)

ghead :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List a) a)

hhead :: (T.R (T.List a)) -> T.RefExp -> T.R a

ghead phead p = T.ufun1 ahead phead p hhead

hhead (T.R (T.Cons fx _) _) p = T.projection T.mkNoSrcPos p fx
hhead (T.R T.List _) p =
  T.uwrapForward p
    (herror (T.fromLitString T.mkNoSrcPos p "Prelude.head: empty list") p)
hhead _ p = T.fatal p

glast :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List a) a)

hlast :: (T.R (T.List a)) -> T.RefExp -> T.R a

glast plast p = T.ufun1 alast plast p hlast

hlast (T.R (T.Cons fx (T.R T.List _)) _) p = T.projection T.mkNoSrcPos p fx
hlast (T.R (T.Cons _ fxs) _) p = T.uwrapForward p (hlast fxs p)
hlast (T.R T.List _) p =
  T.uwrapForward p
    (herror (T.fromLitString T.mkNoSrcPos p "Prelude.last: empty list") p)
hlast _ p = T.fatal p

gtail :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List a) (T.List a))

htail :: (T.R (T.List a)) -> T.RefExp -> T.R (T.List a)

gtail ptail p = T.ufun1 atail ptail p htail

htail (T.R (T.Cons _ fxs) _) p = T.projection T.mkNoSrcPos p fxs
htail (T.R T.List _) p =
  T.uwrapForward p
    (herror (T.fromLitString T.mkNoSrcPos p "Prelude.tail: empty list") p)
htail _ p = T.fatal p

ginit :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List a) (T.List a))

hinit :: (T.R (T.List a)) -> T.RefExp -> T.R (T.List a)

ginit pinit p = T.ufun1 ainit pinit p hinit

hinit (T.R (T.Cons fx (T.R T.List _)) _) p =
  T.con0 T.mkNoSrcPos p T.List T.aList
hinit (T.R (T.Cons fx fxs) _) p =
  T.con2 T.mkNoSrcPos p T.Cons T.aCons fx (T.uwrapForward p (hinit fxs p))
hinit (T.R T.List _) p =
  T.uwrapForward p
    (herror (T.fromLitString T.mkNoSrcPos p "Prelude.init: empty list") p)
hinit _ p = T.fatal p

gnull :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List a) Bool)

hnull :: (T.R (T.List a)) -> T.RefExp -> T.R Bool

gnull pnull p = T.ufun1 anull pnull p hnull

hnull (T.R T.List _) p = T.con0 T.mkNoSrcPos p True aTrue
hnull (T.R (T.Cons _ _) _) p = T.con0 T.mkNoSrcPos p False aFalse
hnull _ p = T.fatal p

glength :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List a) Int)

hlength :: (T.R (T.List a)) -> T.RefExp -> T.R Int

glength plength p = T.ufun1 alength plength p hlength

hlength (T.R T.List _) p =
  T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
    (T.conInteger T.mkNoSrcPos p 0)
hlength (T.R (T.Cons _ fl) _) p =
  T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
    (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
      (T.conInteger T.mkNoSrcPos p 1)) (T.uwrapForward p (hlength fl p))
hlength _ p = T.fatal p

(!!!) :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List a) (T.Fun Int a))

(*!!) :: (T.R (T.List a)) -> (T.R Int) -> T.RefExp -> T.R a

(!!!) (%!!) p = T.ufun2 (+!!) (%!!) p (*!!)

(*!!) fxs fn p =
  T.ucguard
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p) fn
      (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0)))
    (T.uwrapForward p
      (herror (T.fromLitString T.mkNoSrcPos p "Prelude.!!: negative index") p))
    ((fxs >#!! fn) p)
(*!!) fxs fn p = (fxs >#!! fn) p

(>#!!) (T.R T.List _) _ p =
  T.uwrapForward p
    (herror (T.fromLitString T.mkNoSrcPos p "Prelude.!!: index too large") p)
(>#!!) ((^#!!)@(T.R (T.Cons fx _) _)) fv1514v11v1514v11n p =
  T.ucguard
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fv1514v11v1514v11n
      (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0))) (h p)
    (((^#!!) >$!! fv1514v11v1514v11n) p)
  where
  
  h p = T.projection T.mkNoSrcPos p fx
  h p = ((^#!!) >$!! fv1514v11v1514v11n) p
  
(>#!!) (^#!!) fv1514v11v1514v11n p = ((^#!!) >$!! fv1514v11v1514v11n) p

(>$!!) (T.R (T.Cons _ fxs) _) fn p =
  T.uwrapForward p
    ((fxs
        *!!
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fn
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 1)))) p)
(>$!!) _ _ p = T.fatal p

gfoldl ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a (T.Fun b a)) (T.Fun a (T.Fun (T.List b) a)))

hfoldl ::
  (T.R (T.Fun a (T.Fun b a))) ->
    (T.R a) -> (T.R (T.List b)) -> T.RefExp -> T.R a

gfoldl pfoldl p = T.ufun3 afoldl pfoldl p hfoldl

hfoldl ff fz (T.R T.List _) p = T.projection T.mkNoSrcPos p fz
hfoldl ff fz (T.R (T.Cons fx fxs) _) p =
  T.uwrapForward p (hfoldl ff (T.uap2 T.mkNoSrcPos p ff fz fx) fxs p)
hfoldl _ _ _ p = T.fatal p

gfoldl1 ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a (T.Fun a a)) (T.Fun (T.List a) a))

hfoldl1 :: (T.R (T.Fun a (T.Fun a a))) -> (T.R (T.List a)) -> T.RefExp -> T.R a

gfoldl1 pfoldl1 p = T.ufun2 afoldl1 pfoldl1 p hfoldl1

hfoldl1 ff (T.R (T.Cons fx fxs) _) p = T.uwrapForward p (hfoldl ff fx fxs p)
hfoldl1 _ (T.R T.List _) p =
  T.uwrapForward p
    (herror (T.fromLitString T.mkNoSrcPos p "Prelude.foldl1: empty list") p)
hfoldl1 _ _ p = T.fatal p

gscanl ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun (T.Fun a (T.Fun b a)) (T.Fun a (T.Fun (T.List b) (T.List a))))

hscanl ::
  (T.R (T.Fun a (T.Fun b a))) ->
    (T.R a) -> (T.R (T.List b)) -> T.RefExp -> T.R (T.List a)

gscanl pscanl p = T.ufun3 ascanl pscanl p hscanl

hscanl ff fq fxs p =
  T.con2 T.mkNoSrcPos p T.Cons T.aCons fq
    (T.uccase T.mkNoSrcPos p
      (let
        v1541v26v1543v54v1 (T.R T.List _) p =
          T.con0 T.mkNoSrcPos p T.List T.aList
        v1541v26v1543v54v1 (T.R (T.Cons fx fxs) _) p =
          T.uwrapForward p (hscanl ff (T.uap2 T.mkNoSrcPos p ff fq fx) fxs p)
        v1541v26v1543v54v1 _ p = T.fatal p in (v1541v26v1543v54v1)) fxs)

gscanl1 ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a (T.Fun a a)) (T.Fun (T.List a) (T.List a)))

hscanl1 ::
  (T.R (T.Fun a (T.Fun a a))) -> (T.R (T.List a)) -> T.RefExp -> T.R (T.List a)

gscanl1 pscanl1 p = T.ufun2 ascanl1 pscanl1 p hscanl1

hscanl1 ff (T.R (T.Cons fx fxs) _) p = T.uwrapForward p (hscanl ff fx fxs p)
hscanl1 _ (T.R T.List _) p = T.con0 T.mkNoSrcPos p T.List T.aList
hscanl1 _ _ p = T.fatal p

gfoldr ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a (T.Fun b b)) (T.Fun b (T.Fun (T.List a) b)))

hfoldr ::
  (T.R (T.Fun a (T.Fun b b))) ->
    (T.R b) -> (T.R (T.List a)) -> T.RefExp -> T.R b

gfoldr pfoldr p = T.ufun3 afoldr pfoldr p hfoldr

hfoldr ff fz (T.R T.List _) p = T.projection T.mkNoSrcPos p fz
hfoldr ff fz (T.R (T.Cons fx fxs) _) p =
  T.uap2 T.mkNoSrcPos p ff fx (T.uwrapForward p (hfoldr ff fz fxs p))
hfoldr _ _ _ p = T.fatal p

gfoldr1 ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a (T.Fun a a)) (T.Fun (T.List a) a))

hfoldr1 :: (T.R (T.Fun a (T.Fun a a))) -> (T.R (T.List a)) -> T.RefExp -> T.R a

gfoldr1 pfoldr1 p = T.ufun2 afoldr1 pfoldr1 p hfoldr1

hfoldr1 ff (T.R (T.Cons fx (T.R T.List _)) _) p = T.projection T.mkNoSrcPos p fx
hfoldr1 ff (T.R (T.Cons fx fxs) _) p =
  T.uap2 T.mkNoSrcPos p ff fx (T.uwrapForward p (hfoldr1 ff fxs p))
hfoldr1 _ (T.R T.List _) p =
  T.uwrapForward p
    (herror (T.fromLitString T.mkNoSrcPos p "Prelude.foldr1: empty list") p)
hfoldr1 _ _ p = T.fatal p

gscanr ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun (T.Fun a (T.Fun b b)) (T.Fun b (T.Fun (T.List a) (T.List b))))

hscanr ::
  (T.R (T.Fun a (T.Fun b b))) ->
    (T.R b) -> (T.R (T.List a)) -> T.RefExp -> T.R (T.List b)

gscanr pscanr p = T.ufun3 ascanr pscanr p hscanr

hscanr ff fq0 (T.R T.List _) p = T.fromExpList T.mkNoSrcPos p [fq0]
hscanr ff fq0 (T.R (T.Cons fx fxs) _) p =
  T.con2 T.mkNoSrcPos p T.Cons T.aCons
    (T.uap2 T.mkNoSrcPos p ff fx (gq T.mkNoSrcPos p)) (gqs T.mkNoSrcPos p)
  where
  
  gqs pqs p = T.uconstUse pqs p sqs
  
  sqs =
    T.uconstDef p a1568v28v1568v29qs
      (\ p -> T.uwrapForward p (hscanr ff fq0 fxs p))
  
  gq pq p = T.uconstUse pq p sq
  
  j1568v32v1568v34q =
    case gqs T.mkNoSrcPos p of T.R (T.Cons fq _) kq -> (kq,fq); _ -> T.fatal p
  
  sq =
    T.uconstDef p a1568v32v1568v32q
      (\ _ -> case j1568v32v1568v34q of (kq,fq) -> fq)
  
hscanr _ _ _ p = T.fatal p

gscanr1 ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a (T.Fun a a)) (T.Fun (T.List a) (T.List a)))

hscanr1 ::
  (T.R (T.Fun a (T.Fun a a))) -> (T.R (T.List a)) -> T.RefExp -> T.R (T.List a)

gscanr1 pscanr1 p = T.ufun2 ascanr1 pscanr1 p hscanr1

hscanr1 ff (T.R T.List _) p = T.con0 T.mkNoSrcPos p T.List T.aList
hscanr1 ff (T.R (T.Cons fx (T.R T.List _)) _) p =
  T.fromExpList T.mkNoSrcPos p [fx]
hscanr1 ff (T.R (T.Cons fx fxs) _) p =
  T.con2 T.mkNoSrcPos p T.Cons T.aCons
    (T.uap2 T.mkNoSrcPos p ff fx (gq T.mkNoSrcPos p)) (gqs T.mkNoSrcPos p)
  where
  
  gqs pqs p = T.uconstUse pqs p sqs
  
  sqs =
    T.uconstDef p a1575v26v1575v27qs
      (\ p -> T.uwrapForward p (hscanr1 ff fxs p))
  
  gq pq p = T.uconstUse pq p sq
  
  j1575v30v1575v32q =
    case gqs T.mkNoSrcPos p of T.R (T.Cons fq _) kq -> (kq,fq); _ -> T.fatal p
  
  sq =
    T.uconstDef p a1575v30v1575v30q
      (\ _ -> case j1575v30v1575v32q of (kq,fq) -> fq)
  
hscanr1 _ _ p = T.fatal p

giterate ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.Fun a a) (T.Fun a (T.List a)))

hiterate :: (T.R (T.Fun a a)) -> (T.R a) -> T.RefExp -> T.R (T.List a)

giterate piterate p = T.ufun2 aiterate piterate p hiterate

hiterate ff fx p =
  T.con2 T.mkNoSrcPos p T.Cons T.aCons fx
    (T.uwrapForward p (hiterate ff (T.uap1 T.mkNoSrcPos p ff fx) p))

grepeat :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.List a))

hrepeat :: (T.R a) -> T.RefExp -> T.R (T.List a)

grepeat prepeat p = T.ufun1 arepeat prepeat p hrepeat

hrepeat fx p =
  gxs T.mkNoSrcPos p
  where
  
  gxs pxs p = T.uconstUse pxs p sxs
  
  sxs =
    T.uconstDef p a1586v30v1586v38xs
      (\ p -> T.con2 T.mkNoSrcPos p T.Cons T.aCons fx (gxs T.mkNoSrcPos p))
  

greplicate :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (T.Fun a (T.List a)))

hreplicate :: (T.R Int) -> (T.R a) -> T.RefExp -> T.R (T.List a)

greplicate preplicate p = T.ufun2 areplicate preplicate p hreplicate

hreplicate fn fx p =
  T.uwrapForward p (htake fn (T.uwrapForward p (hrepeat fx p)) p)

gcycle :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List a) (T.List a))

hcycle :: (T.R (T.List a)) -> T.RefExp -> T.R (T.List a)

gcycle pcycle p = T.ufun1 acycle pcycle p hcycle

hcycle (T.R T.List _) p =
  T.uwrapForward p
    (herror (T.fromLitString T.mkNoSrcPos p "Prelude.cycle: empty list") p)
hcycle fxs p =
  gxs' T.mkNoSrcPos p
  where
  
  gxs' pxs' p = T.uconstUse pxs' p sxs'
  
  sxs' =
    T.uconstDef p a1600v31v1600v45xs'
      (\ p -> T.uwrapForward p ((fxs *++ (gxs' T.mkNoSrcPos p)) p))
  

gtake ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (T.Fun (T.List a) (T.List a)))

htake :: (T.R Int) -> (T.R (T.List a)) -> T.RefExp -> T.R (T.List a)

gtake ptake p = T.ufun2 atake ptake p htake

htake fn (z2take@_) p =
  T.ucguard
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !<= p) fn
      (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0))) (T.con0 T.mkNoSrcPos p T.List T.aList)
    (y1take fn z2take p)
htake fn z2take p = y1take fn z2take p

y1take _ (T.R T.List _) p = T.con0 T.mkNoSrcPos p T.List T.aList
y1take fn (T.R (T.Cons fx fxs) _) p =
  T.con2 T.mkNoSrcPos p T.Cons T.aCons fx
    (T.uwrapForward p
      (htake
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fn
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 1))) fxs p))
y1take _ _ p = T.fatal p

gdrop ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (T.Fun (T.List a) (T.List a)))

hdrop :: (T.R Int) -> (T.R (T.List a)) -> T.RefExp -> T.R (T.List a)

gdrop pdrop p = T.ufun2 adrop pdrop p hdrop

hdrop fn fxs p =
  T.ucguard
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !<= p) fn
      (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0))) (T.projection T.mkNoSrcPos p fxs)
    (y1drop fn fxs p)
hdrop fn fxs p = y1drop fn fxs p

y1drop _ (T.R T.List _) p = T.con0 T.mkNoSrcPos p T.List T.aList
y1drop fn (T.R (T.Cons _ fxs) _) p =
  T.uwrapForward p
    (hdrop
      (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fn
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 1))) fxs p)
y1drop _ _ p = T.fatal p

gsplitAt ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun Int (T.Fun (T.List a) (T.Tuple2 (T.List a) (T.List a))))

hsplitAt ::
  (T.R Int) ->
    (T.R (T.List a)) -> T.RefExp -> T.R (T.Tuple2 (T.List a) (T.List a))

gsplitAt psplitAt p = T.ufun2 asplitAt psplitAt p hsplitAt

hsplitAt fn fxs p =
  T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2 (T.uwrapForward p (htake fn fxs p))
    (T.uwrapForward p (hdrop fn fxs p))

gtakeWhile ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a Bool) (T.Fun (T.List a) (T.List a)))

htakeWhile ::
  (T.R (T.Fun a Bool)) -> (T.R (T.List a)) -> T.RefExp -> T.R (T.List a)

gtakeWhile ptakeWhile p = T.ufun2 atakeWhile ptakeWhile p htakeWhile

htakeWhile fp (T.R T.List _) p = T.con0 T.mkNoSrcPos p T.List T.aList
htakeWhile fp (T.R (T.Cons fx fxs) _) p =
  T.ucguard (T.uap1 T.mkNoSrcPos p fp fx)
    (T.con2 T.mkNoSrcPos p T.Cons T.aCons fx
      (T.uwrapForward p (htakeWhile fp fxs p)))
    (T.ucguard (gotherwise T.mkNoSrcPos p)
      (T.con0 T.mkNoSrcPos p T.List T.aList) (T.fatal p))
htakeWhile _ _ p = T.fatal p

gdropWhile ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a Bool) (T.Fun (T.List a) (T.List a)))

hdropWhile ::
  (T.R (T.Fun a Bool)) -> (T.R (T.List a)) -> T.RefExp -> T.R (T.List a)

gdropWhile pdropWhile p = T.ufun2 adropWhile pdropWhile p hdropWhile

hdropWhile fp (T.R T.List _) p = T.con0 T.mkNoSrcPos p T.List T.aList
hdropWhile fp (fxs@(T.R (T.Cons fx fxs') _)) p =
  T.ucguard (T.uap1 T.mkNoSrcPos p fp fx)
    (T.uwrapForward p (hdropWhile fp fxs' p))
    (T.ucguard (gotherwise T.mkNoSrcPos p) (T.projection T.mkNoSrcPos p fxs)
      (T.fatal p))
hdropWhile _ _ p = T.fatal p

gspan,gbreak ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.Fun a Bool)
          (T.Fun (T.List a) (T.Tuple2 (T.List a) (T.List a))))

hspan ::
  (T.R (T.Fun a Bool)) ->
    (T.R (T.List a)) -> T.RefExp -> T.R (T.Tuple2 (T.List a) (T.List a))

hbreak ::
  (T.R (T.Fun a Bool)) ->
    T.RefExp -> T.R (T.Fun (T.List a) (T.Tuple2 (T.List a) (T.List a)))

gspan pspan p = T.ufun2 aspan pspan p hspan

hspan fp (T.R T.List _) p =
  T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
    (T.con0 T.mkNoSrcPos p T.List T.aList)
    (T.con0 T.mkNoSrcPos p T.List T.aList)
hspan fp (fxs@(T.R (T.Cons fx fxs') _)) p =
  T.ucguard (T.uap1 T.mkNoSrcPos p fp fx)
    (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
      (T.con2 T.mkNoSrcPos p T.Cons T.aCons (T.projection T.mkNoSrcPos p fx)
        (gys T.mkNoSrcPos p)) (gzs T.mkNoSrcPos p))
    (T.ucguard (gotherwise T.mkNoSrcPos p)
      (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
        (T.con0 T.mkNoSrcPos p T.List T.aList) fxs) (T.fatal p))
  where
  
  gys pys p = T.uconstUse pys p sys
  
  gzs pys p = T.uconstUse pys p szs
  
  j1648v34v1648v40ys =
    case T.uwrapForward p (hspan fp fxs' p) of
      T.R (T.Tuple2 fys fzs) kys -> (kys,fys,fzs)
      _ -> T.fatal p
  
  sys =
    T.uconstDef p a1648v35v1648v36ys
      (\ _ -> case j1648v34v1648v40ys of (kys,fys,fzs) -> fys)
  
  szs =
    T.uconstDef p a1648v38v1648v39zs
      (\ _ -> case j1648v34v1648v40ys of (kys,fys,fzs) -> fzs)
  
hspan _ _ p = T.fatal p

gbreak pbreak p = T.ufun1 abreak pbreak p hbreak

hbreak fp p =
  T.uap1 T.mkNoSrcPos p (gspan T.mkNoSrcPos p)
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p) (gnot T.mkNoSrcPos p) fp)

glines :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun String (T.List String))

hlines :: (T.R String) -> T.RefExp -> T.R (T.List String)

glines plines p = T.ufun1 alines plines p hlines

hlines (T.R T.List _) p = T.con0 T.mkNoSrcPos p T.List T.aList
hlines fs p =
  let
    gl pl p = T.uconstUse pl p sl
    gs' pl p = T.uconstUse pl p ss'
    j1662v25v1662v31l =
      case
        T.uap2 T.mkNoSrcPos p (gbreak T.mkNoSrcPos p)
          (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !== p)
            (T.conChar T.mkNoSrcPos p '\n')) fs of
        T.R (T.Tuple2 fl fs') kl -> (kl,fl,fs')
        _ -> T.fatal p
    sl =
      T.uconstDef p a1662v26v1662v26l
        (\ _ -> case j1662v25v1662v31l of (kl,fl,fs') -> fl)
    ss' =
      T.uconstDef p a1662v29v1662v30s'
        (\ _ -> case j1662v25v1662v31l of (kl,fl,fs') -> fs') in
    (T.con2 T.mkNoSrcPos p T.Cons T.aCons (gl T.mkNoSrcPos p)
      (T.uccase T.mkNoSrcPos p
        (let
          v1663v31v1665v52v1 (T.R T.List _) p =
            T.con0 T.mkNoSrcPos p T.List T.aList
          v1663v31v1665v52v1 (T.R (T.Cons _ fs'') _) p =
            T.uwrapForward p (hlines fs'' p)
          v1663v31v1665v52v1 _ p = T.fatal p in (v1663v31v1665v52v1))
        (gs' T.mkNoSrcPos p)))

gwords :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun String (T.List String))

hwords :: (T.R String) -> T.RefExp -> T.R (T.List String)

gwords pwords p = T.ufun1 awords pwords p hwords

hwords fs p =
  T.uccase T.mkNoSrcPos p
    (let
      v1669v21v1672v61v1 (T.R T.List _) p = T.con0 T.mkNoSrcPos p T.List T.aList
      v1669v21v1672v61v1 fs' p =
        T.con2 T.mkNoSrcPos p T.Cons T.aCons (gw T.mkNoSrcPos p)
          (T.uwrapForward p (hwords (gs'' T.mkNoSrcPos p) p))
        where
        
        gw pw p = T.uconstUse pw p sw
        
        gs'' pw p = T.uconstUse pw p ss''
        
        j1672v35v1672v42w =
          case
            T.uap2 T.mkNoSrcPos p (gbreak T.mkNoSrcPos p)
              (gisSpace T.mkNoSrcPos p) fs' of
            T.R (T.Tuple2 fw fs'') kw -> (kw,fw,fs'')
            _ -> T.fatal p
        
        sw =
          T.uconstDef p a1672v36v1672v36w
            (\ _ -> case j1672v35v1672v42w of (kw,fw,fs'') -> fw)
        
        ss'' =
          T.uconstDef p a1672v39v1672v41s''
            (\ _ -> case j1672v35v1672v42w of (kw,fw,fs'') -> fs'')
         in (v1669v21v1672v61v1))
    (T.uwrapForward p (hdropWhile (gisSpace T.mkNoSrcPos p) fs p))

gunlines :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List String) String)

sunlines :: T.R (T.Fun (T.List String) String)

gunlines punlines p = T.uconstUse punlines p sunlines

sunlines =
  T.uconstDef T.mkRoot aunlines
    (\ p ->
      T.uwrapForward p
        (hconcatMap
          (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !++ p)
            (T.fromLitString T.mkNoSrcPos p "\n")) p))

gunwords :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List String) String)

hunwords :: (T.R (T.List String)) -> T.RefExp -> T.R String

gunwords punwords p = T.ufun1 aunwords punwords p hunwords

hunwords (T.R T.List _) p = T.fromLitString T.mkNoSrcPos p ""
hunwords fws p =
  T.uwrapForward p
    (hfoldr1
      (T.ufun2 T.mkLambda T.mkNoSrcPos p
        (\ fw fs p ->
          T.uwrapForward p
            ((fw
                *++
                (T.con2 T.mkNoSrcPos p T.Cons T.aCons
                  (T.conChar T.mkNoSrcPos p ' ')
                  (T.projection T.mkNoSrcPos p fs))) p))) fws p)

greverse :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List a) (T.List a))

sreverse :: T.R (T.Fun (T.List a) (T.List a))

greverse preverse p = T.uconstUse preverse p sreverse

sreverse =
  T.uconstDef T.mkRoot areverse
    (\ p ->
      T.uap2 T.mkNoSrcPos p (gfoldl T.mkNoSrcPos p)
        (T.uap1 T.mkNoSrcPos p (gflip T.mkNoSrcPos p)
          (T.pa0 T.Cons T.cn2 T.mkNoSrcPos p T.aCons))
        (T.con0 T.mkNoSrcPos p T.List T.aList))

gand,gor :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List Bool) Bool)

sand,sor :: T.R (T.Fun (T.List Bool) Bool)

gand pand p = T.uconstUse pand p sand

sand =
  T.uconstDef T.mkRoot aand
    (\ p ->
      T.uap2 T.mkNoSrcPos p (gfoldr T.mkNoSrcPos p) (T.mkNoSrcPos !&& p)
        (T.con0 T.mkNoSrcPos p True aTrue))

gor por p = T.uconstUse por p sor

sor =
  T.uconstDef T.mkRoot aor
    (\ p ->
      T.uap2 T.mkNoSrcPos p (gfoldr T.mkNoSrcPos p) (T.mkNoSrcPos !|| p)
        (T.con0 T.mkNoSrcPos p False aFalse))

gany,gall ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.Fun a Bool) (T.Fun (T.List a) Bool))

hany :: (T.R (T.Fun a Bool)) -> T.RefExp -> T.R (T.Fun (T.List a) Bool)

hall :: (T.R (T.Fun a Bool)) -> T.RefExp -> T.R (T.Fun (T.List a) Bool)

gany pany p = T.ufun1 aany pany p hany

hany fp p =
  T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p) (gor T.mkNoSrcPos p)
    (T.uap1 T.mkNoSrcPos p (gmap T.mkNoSrcPos p) fp)

gall pall p = T.ufun1 aall pall p hall

hall fp p =
  T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p) (gand T.mkNoSrcPos p)
    (T.uap1 T.mkNoSrcPos p (gmap T.mkNoSrcPos p) fp)

gelem,gnotElem ::
  Eq a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun (T.List a) Bool))

helem :: Eq a => (T.R a) -> T.RefExp -> T.R (T.Fun (T.List a) Bool)

hnotElem :: Eq a => (T.R a) -> T.RefExp -> T.R (T.Fun (T.List a) Bool)

gelem pelem p = T.ufun1 aelem pelem p helem

helem fx p =
  T.uwrapForward p
    (hany (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !== p) fx)
      p)

gnotElem pnotElem p = T.ufun1 anotElem pnotElem p hnotElem

hnotElem fx p =
  T.uwrapForward p
    (hall (T.uap2 T.mkNoSrcPos p (gflip T.mkNoSrcPos p) (T.mkNoSrcPos !/= p) fx)
      p)

glookup ::
  Eq a =>
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun a (T.Fun (T.List (T.Tuple2 a b)) (Maybe b)))

hlookup ::
  Eq a => (T.R a) -> (T.R (T.List (T.Tuple2 a b))) -> T.RefExp -> T.R (Maybe b)

glookup plookup p = T.ufun2 alookup plookup p hlookup

hlookup fkey (T.R T.List _) p = T.con0 T.mkNoSrcPos p Nothing aNothing
hlookup fkey (T.R (T.Cons (T.R (T.Tuple2 fx fy) _) fxys) _) p =
  T.ucguard (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !== p) fkey fx)
    (T.con1 T.mkNoSrcPos p Just aJust fy)
    (T.ucguard (gotherwise T.mkNoSrcPos p)
      (T.uwrapForward p (hlookup fkey fxys p)) (T.fatal p))
hlookup _ _ p = T.fatal p

gsum,gproduct :: Num a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List a) a)

ssum,sproduct :: Num a => T.R (T.Fun (T.List a) a)

gsum psum p = T.uconstUse psum p ssum

ssum =
  T.uconstDef T.mkRoot asum
    (\ p ->
      T.uap2 T.mkNoSrcPos p (gfoldl T.mkNoSrcPos p) (T.mkNoSrcPos !+ p)
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0)))

gproduct pproduct p = T.uconstUse pproduct p sproduct

sproduct =
  T.uconstDef T.mkRoot aproduct
    (\ p ->
      T.uap2 T.mkNoSrcPos p (gfoldl T.mkNoSrcPos p) (T.mkNoSrcPos !* p)
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 1)))

gmaximum,gminimum ::
  Ord a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List a) a)

hmaximum :: Ord a => (T.R (T.List a)) -> T.RefExp -> T.R a

hminimum :: Ord a => (T.R (T.List a)) -> T.RefExp -> T.R a

gmaximum pmaximum p = T.ufun1 amaximum pmaximum p hmaximum

hmaximum (T.R T.List _) p =
  T.uwrapForward p
    (herror (T.fromLitString T.mkNoSrcPos p "Prelude.maximum: empty list") p)
hmaximum fxs p = T.uwrapForward p (hfoldl1 (gmax T.mkNoSrcPos p) fxs p)

gminimum pminimum p = T.ufun1 aminimum pminimum p hminimum

hminimum (T.R T.List _) p =
  T.uwrapForward p
    (herror (T.fromLitString T.mkNoSrcPos p "Prelude.minimum: empty list") p)
hminimum fxs p = T.uwrapForward p (hfoldl1 (gmin T.mkNoSrcPos p) fxs p)

gconcatMap ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (T.Fun a (T.List b)) (T.Fun (T.List a) (T.List b)))

hconcatMap ::
  (T.R (T.Fun a (T.List b))) -> T.RefExp -> T.R (T.Fun (T.List a) (T.List b))

gconcatMap pconcatMap p = T.ufun1 aconcatMap pconcatMap p hconcatMap

hconcatMap ff p =
  T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p) (gconcat T.mkNoSrcPos p)
    (T.uap1 T.mkNoSrcPos p (gmap T.mkNoSrcPos p) ff)

gzip ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun (T.List a) (T.Fun (T.List b) (T.List (T.Tuple2 a b))))

szip :: T.R (T.Fun (T.List a) (T.Fun (T.List b) (T.List (T.Tuple2 a b))))

gzip pzip p = T.uconstUse pzip p szip

szip =
  T.uconstDef T.mkRoot azip
    (\ p ->
      T.uap1 T.mkNoSrcPos p (gzipWith T.mkNoSrcPos p)
        (T.pa0 T.Tuple2 T.cn2 T.mkNoSrcPos p T.aTuple2))

gzip3 ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.List a)
          (T.Fun (T.List b) (T.Fun (T.List c) (T.List (T.Tuple3 a b c)))))

szip3 ::
  T.R
    (T.Fun (T.List a)
      (T.Fun (T.List b) (T.Fun (T.List c) (T.List (T.Tuple3 a b c)))))

gzip3 pzip3 p = T.uconstUse pzip3 p szip3

szip3 =
  T.uconstDef T.mkRoot azip3
    (\ p ->
      T.uap1 T.mkNoSrcPos p (gzipWith3 T.mkNoSrcPos p)
        (T.pa0 T.Tuple3 T.cn3 T.mkNoSrcPos p T.aTuple3))

gzipWith ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.Fun a (T.Fun b c))
          (T.Fun (T.List a) (T.Fun (T.List b) (T.List c))))

hzipWith ::
  (T.R (T.Fun a (T.Fun b c))) ->
    (T.R (T.List a)) -> (T.R (T.List b)) -> T.RefExp -> T.R (T.List c)

gzipWith pzipWith p = T.ufun3 azipWith pzipWith p hzipWith

hzipWith fz (T.R (T.Cons fa fas) _) (T.R (T.Cons fb fbs) _) p =
  T.con2 T.mkNoSrcPos p T.Cons T.aCons (T.uap2 T.mkNoSrcPos p fz fa fb)
    (T.uwrapForward p (hzipWith fz fas fbs p))
hzipWith _ _ _ p = T.con0 T.mkNoSrcPos p T.List T.aList

gzipWith3 ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.Fun a (T.Fun b (T.Fun c d)))
          (T.Fun (T.List a) (T.Fun (T.List b) (T.Fun (T.List c) (T.List d)))))

hzipWith3 ::
  (T.R (T.Fun a (T.Fun b (T.Fun c d)))) ->
    (T.R (T.List a)) ->
      (T.R (T.List b)) -> (T.R (T.List c)) -> T.RefExp -> T.R (T.List d)

gzipWith3 pzipWith3 p = T.ufun4 azipWith3 pzipWith3 p hzipWith3

hzipWith3 fz (T.R (T.Cons fa fas) _) (T.R (T.Cons fb fbs) _)
  (T.R (T.Cons fc fcs) _) p =
  T.con2 T.mkNoSrcPos p T.Cons T.aCons (T.uap3 T.mkNoSrcPos p fz fa fb fc)
    (T.uwrapForward p (hzipWith3 fz fas fbs fcs p))
hzipWith3 _ _ _ _ p = T.con0 T.mkNoSrcPos p T.List T.aList

gunzip ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R (T.Fun (T.List (T.Tuple2 a b)) (T.Tuple2 (T.List a) (T.List b)))

sunzip :: T.R (T.Fun (T.List (T.Tuple2 a b)) (T.Tuple2 (T.List a) (T.List b)))

gunzip punzip p = T.uconstUse punzip p sunzip

sunzip =
  T.uconstDef T.mkRoot aunzip
    (\ p ->
      T.uap2 T.mkNoSrcPos p (gfoldr T.mkNoSrcPos p)
        (T.ufun2 T.mkLambda T.mkNoSrcPos p
          (\ v1773v28v1773v57v1 v1773v28v1773v57v2 p ->
            case (v1773v28v1773v57v1,v1773v28v1773v57v2) of
              (T.R (T.Tuple2 fa fb) _,T.R ~(T.Tuple2 fas fbs) _) ->
                let
                  gas pas p = T.uconstUse pas p sas
                  sas =
                    T.uconstDef p a0v0v0v0as
                      (\ p -> T.projection T.mkNoSrcPos p fas)
                  gbs pbs p = T.uconstUse pbs p sbs
                  sbs =
                    T.uconstDef p a0v0v0v0bs
                      (\ p -> T.projection T.mkNoSrcPos p fbs) in
                  (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                    (T.con2 T.mkNoSrcPos p T.Cons T.aCons
                      (T.projection T.mkNoSrcPos p fa) (gas T.mkNoSrcPos p))
                    (T.con2 T.mkNoSrcPos p T.Cons T.aCons
                      (T.projection T.mkNoSrcPos p fb) (gbs T.mkNoSrcPos p)))
              _ -> T.fatal p))
        (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
          (T.con0 T.mkNoSrcPos p T.List T.aList)
          (T.con0 T.mkNoSrcPos p T.List T.aList)))

gunzip3 ::
  T.RefSrcPos ->
    T.RefExp ->
      T.R
        (T.Fun (T.List (T.Tuple3 a b c))
          (T.Tuple3 (T.List a) (T.List b) (T.List c)))

sunzip3 ::
  T.R
    (T.Fun (T.List (T.Tuple3 a b c))
      (T.Tuple3 (T.List a) (T.List b) (T.List c)))

gunzip3 punzip3 p = T.uconstUse punzip3 p sunzip3

sunzip3 =
  T.uconstDef T.mkRoot aunzip3
    (\ p ->
      T.uap2 T.mkNoSrcPos p (gfoldr T.mkNoSrcPos p)
        (T.ufun2 T.mkLambda T.mkNoSrcPos p
          (\ v1777v28v1777v67v1 v1777v28v1777v67v2 p ->
            case (v1777v28v1777v67v1,v1777v28v1777v67v2) of
              (T.R (T.Tuple3 fa fb fc) _,T.R ~(T.Tuple3 fas fbs fcs) _) ->
                let
                  gas pas p = T.uconstUse pas p sas
                  sas =
                    T.uconstDef p a0v0v0v0as
                      (\ p -> T.projection T.mkNoSrcPos p fas)
                  gbs pbs p = T.uconstUse pbs p sbs
                  sbs =
                    T.uconstDef p a0v0v0v0bs
                      (\ p -> T.projection T.mkNoSrcPos p fbs)
                  gcs pcs p = T.uconstUse pcs p scs
                  scs =
                    T.uconstDef p a0v0v0v0cs
                      (\ p -> T.projection T.mkNoSrcPos p fcs) in
                  (T.con3 T.mkNoSrcPos p T.Tuple3 T.aTuple3
                    (T.con2 T.mkNoSrcPos p T.Cons T.aCons
                      (T.projection T.mkNoSrcPos p fa) (gas T.mkNoSrcPos p))
                    (T.con2 T.mkNoSrcPos p T.Cons T.aCons
                      (T.projection T.mkNoSrcPos p fb) (gbs T.mkNoSrcPos p))
                    (T.con2 T.mkNoSrcPos p T.Cons T.aCons
                      (T.projection T.mkNoSrcPos p fc) (gcs T.mkNoSrcPos p)))
              _ -> T.fatal p))
        (T.con3 T.mkNoSrcPos p T.Tuple3 T.aTuple3
          (T.con0 T.mkNoSrcPos p T.List T.aList)
          (T.con0 T.mkNoSrcPos p T.List T.aList)
          (T.con0 T.mkNoSrcPos p T.List T.aList)))

type ReadS a = T.Fun String (T.List (T.Tuple2 a String))

type ReadS___1 a = String

type ReadS___2 a = T.List (T.Tuple2 a String)

type ShowS = T.Fun String String

type ShowS___1 = String

type ShowS___2 = String

class Read a
  where
  
  greadsPrec :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (ReadS a))
  
  greadList :: T.RefSrcPos -> T.RefExp -> T.R (ReadS (T.List a))
  
  greadList preadList p = T.uconstUse preadList p sreadList
  
  sreadList =
    T.uconstDef T.mkRoot a1804v5v1809v35readList
      (\ p ->
        let
          greadl preadl p = T.ufun1 a1806v30v1806v34readl preadl p hreadl
          areadl = a1806v30v1806v34readl
          hreadl fs p =
            T.uwrapForward p
              (((T.uap1 T.mkNoSrcPos p
                    (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                      (T.ufun2 T.mkLambda T.mkNoSrcPos p
                        (\ f_x f_y p ->
                          T.uccase T.mkNoSrcPos p
                            (let
                              v0v0v0v0v1
                                (T.R
                                  (T.Tuple2
                                    (T.R (T.Cons (T.R ']' _) (T.R T.List _)) _)
                                    ft) _) p =
                                T.uap1 T.mkNoSrcPos p
                                  (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                                    (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                                      (T.con0 T.mkNoSrcPos p T.List T.aList)
                                      ft)) f_y
                              v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y
                              in (v0v0v0v0v1)) f_x))
                      (T.uwrapForward p (hlex fs p)))
                    (T.fromExpList T.mkNoSrcPos p []))
                  *++
                  (T.uap1 T.mkNoSrcPos p
                    (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                      (T.ufun2 T.mkLambda T.mkNoSrcPos p
                        (\ f_x f_y p ->
                          T.uccase T.mkNoSrcPos p
                            (let
                              v0v0v0v0v1 (T.R (T.Tuple2 fx ft) _) p =
                                T.uap1 T.mkNoSrcPos p
                                  (T.uap2 T.mkNoSrcPos p
                                    (g_foldr T.mkNoSrcPos p)
                                    (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                      (\ f_x f_y p ->
                                        T.uccase T.mkNoSrcPos p
                                          (let
                                            v0v0v0v0v1 (T.R (T.Tuple2 fxs fu) _)
                                              p =
                                              T.uap1 T.mkNoSrcPos p
                                                (T.pa1 T.Cons T.cn1 T.mkNoSrcPos
                                                  p T.aCons
                                                  (T.con2 T.mkNoSrcPos p
                                                    T.Tuple2 T.aTuple2
                                                    (T.con2 T.mkNoSrcPos p
                                                      T.Cons T.aCons
                                                      (T.projection T.mkNoSrcPos
                                                        p fx)
                                                      (T.projection T.mkNoSrcPos
                                                        p fxs)) fu)) f_y
                                            v0v0v0v0v1 _ p =
                                              T.projection T.mkNoSrcPos p f_y in
                                            (v0v0v0v0v1)) f_x))
                                    (T.uwrapForward p (hreadl' ft p))) f_y
                              v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y
                              in (v0v0v0v0v1)) f_x))
                      (T.uap1 T.mkNoSrcPos p (greads T.mkNoSrcPos p) fs))
                    (T.fromExpList T.mkNoSrcPos p []))) p)
          greadl' preadl' p = T.ufun1 a1809v30v1809v35readl' preadl' p hreadl'
          areadl' = a1809v30v1809v35readl'
          hreadl' fs p =
            T.uwrapForward p
              (((T.uap1 T.mkNoSrcPos p
                    (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                      (T.ufun2 T.mkLambda T.mkNoSrcPos p
                        (\ f_x f_y p ->
                          T.uccase T.mkNoSrcPos p
                            (let
                              v0v0v0v0v1
                                (T.R
                                  (T.Tuple2
                                    (T.R (T.Cons (T.R ']' _) (T.R T.List _)) _)
                                    ft) _) p =
                                T.uap1 T.mkNoSrcPos p
                                  (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                                    (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                                      (T.con0 T.mkNoSrcPos p T.List T.aList)
                                      ft)) f_y
                              v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y
                              in (v0v0v0v0v1)) f_x))
                      (T.uwrapForward p (hlex fs p)))
                    (T.fromExpList T.mkNoSrcPos p []))
                  *++
                  (T.uap1 T.mkNoSrcPos p
                    (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                      (T.ufun2 T.mkLambda T.mkNoSrcPos p
                        (\ f_x f_y p ->
                          T.uccase T.mkNoSrcPos p
                            (let
                              v0v0v0v0v1
                                (T.R
                                  (T.Tuple2
                                    (T.R (T.Cons (T.R ',' _) (T.R T.List _)) _)
                                    ft) _) p =
                                T.uap1 T.mkNoSrcPos p
                                  (T.uap2 T.mkNoSrcPos p
                                    (g_foldr T.mkNoSrcPos p)
                                    (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                      (\ f_x f_y p ->
                                        T.uccase T.mkNoSrcPos p
                                          (let
                                            v0v0v0v0v1 (T.R (T.Tuple2 fx fu) _)
                                              p =
                                              T.uap1 T.mkNoSrcPos p
                                                (T.uap2 T.mkNoSrcPos p
                                                  (g_foldr T.mkNoSrcPos p)
                                                  (T.ufun2 T.mkLambda
                                                    T.mkNoSrcPos p
                                                    (\ f_x f_y p ->
                                                      T.uccase T.mkNoSrcPos p
                                                        (let
                                                          v0v0v0v0v1
                                                            (T.R
                                                              (T.Tuple2 fxs fv)
                                                              _) p =
                                                            T.uap1 T.mkNoSrcPos
                                                              p
                                                              (T.pa1 T.Cons
                                                                T.cn1
                                                                T.mkNoSrcPos p
                                                                T.aCons
                                                                (T.con2
                                                                  T.mkNoSrcPos p
                                                                  T.Tuple2
                                                                  T.aTuple2
                                                                  (T.con2
                                                                    T.mkNoSrcPos
                                                                    p T.Cons
                                                                    T.aCons
                                                                    (T.projection
                                                                      T.mkNoSrcPos
                                                                      p fx)
                                                                    (T.projection
                                                                      T.mkNoSrcPos
                                                                      p fxs))
                                                                  fv)) f_y
                                                          v0v0v0v0v1 _ p =
                                                            T.projection
                                                              T.mkNoSrcPos p f_y
                                                          in (v0v0v0v0v1)) f_x))
                                                  (T.uwrapForward p
                                                    (hreadl' fu p))) f_y
                                            v0v0v0v0v1 _ p =
                                              T.projection T.mkNoSrcPos p f_y in
                                            (v0v0v0v0v1)) f_x))
                                    (T.uap1 T.mkNoSrcPos p
                                      (greads T.mkNoSrcPos p) ft)) f_y
                              v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y
                              in (v0v0v0v0v1)) f_x))
                      (T.uwrapForward p (hlex fs p)))
                    (T.fromExpList T.mkNoSrcPos p []))) p) in
          (T.uwrapForward p
            (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
              (T.ufun1 T.mkLambda T.mkNoSrcPos p
                (\ fr p ->
                  T.uap1 T.mkNoSrcPos p
                    (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                      (T.ufun2 T.mkLambda T.mkNoSrcPos p
                        (\ f_x f_y p ->
                          T.uccase T.mkNoSrcPos p
                            (let
                              v0v0v0v0v1
                                (T.R
                                  (T.Tuple2
                                    (T.R (T.Cons (T.R '[' _) (T.R T.List _)) _)
                                    fs) _) p =
                                T.uap1 T.mkNoSrcPos p
                                  (T.uap2 T.mkNoSrcPos p
                                    (g_foldr T.mkNoSrcPos p)
                                    (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                      (\ f_x f_y p ->
                                        T.uccase T.mkNoSrcPos p
                                          (let
                                            v0v0v0v0v1 fpr p =
                                              T.uap1 T.mkNoSrcPos p
                                                (T.pa1 T.Cons T.cn1 T.mkNoSrcPos
                                                  p T.aCons
                                                  (T.projection T.mkNoSrcPos p
                                                    fpr)) f_y
                                            v0v0v0v0v1 _ p =
                                              T.projection T.mkNoSrcPos p f_y in
                                            (v0v0v0v0v1)) f_x))
                                    (T.uwrapForward p (hreadl fs p))) f_y
                              v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y
                              in (v0v0v0v0v1)) f_x))
                      (T.uwrapForward p (hlex fr p)))
                    (T.fromExpList T.mkNoSrcPos p []))) p)))
  
  sreadsPrec :: T.R (T.Fun Int (ReadS a))
  
  sreadList :: T.R (ReadS (T.List a))
  

class Show a
  where
  
  gshowsPrec :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Int (T.Fun a ShowS))
  
  gshow :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a String)
  
  gshowList :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List a) ShowS)
  
  gshowsPrec pshowsPrec p =
    T.ufun3 a1822v5v1822v35showsPrec pshowsPrec p hshowsPrec
    where
    
    hshowsPrec _ fx fs p =
      T.uwrapForward p
        (((T.uap1 T.mkNoSrcPos p (gshow T.mkNoSrcPos p) fx) *++ fs) p)
    
  
  gshow pshow p =
    T.ufun1 a1824v5v1824v36show pshow p hshow
    where
    
    hshow fx p =
      T.uap3 T.mkNoSrcPos p (gshowsPrec T.mkNoSrcPos p)
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0)) fx
        (T.fromLitString T.mkNoSrcPos p "")
    
  
  gshowList pshowList p =
    T.ufun1 a1826v5v1830v53showList pshowList p hshowList
    where
    
    hshowList (T.R T.List _) p =
      T.uap1 T.mkNoSrcPos p (gshowString T.mkNoSrcPos p)
        (T.fromLitString T.mkNoSrcPos p "[]")
    hshowList (T.R (T.Cons fx fxs) _) p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
        (T.uap1 T.mkNoSrcPos p (gshowChar T.mkNoSrcPos p)
          (T.conChar T.mkNoSrcPos p '['))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
          (T.uap1 T.mkNoSrcPos p (gshows T.mkNoSrcPos p) fx)
          (T.uwrapForward p (hshowl fxs p)))
      where
      
      gshowl pshowl p = T.ufun1 a1828v31v1830v53showl pshowl p hshowl
      
      ashowl = a1828v31v1830v53showl
      
      hshowl (T.R T.List _) p =
        T.uap1 T.mkNoSrcPos p (gshowChar T.mkNoSrcPos p)
          (T.conChar T.mkNoSrcPos p ']')
      hshowl (T.R (T.Cons fx fxs) _) p =
        T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
          (T.uap1 T.mkNoSrcPos p (gshowChar T.mkNoSrcPos p)
            (T.conChar T.mkNoSrcPos p ','))
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
            (T.uap1 T.mkNoSrcPos p (gshows T.mkNoSrcPos p) fx)
            (T.uwrapForward p (hshowl fxs p)))
      hshowl _ p = T.fatal p
      
    hshowList _ p = T.fatal p
    
  
  sshowsPrec :: T.R (T.Fun Int (T.Fun a ShowS))
  
  sshow :: T.R (T.Fun a String)
  
  sshowList :: T.R (T.Fun (T.List a) ShowS)
  

greads :: Read a => T.RefSrcPos -> T.RefExp -> T.R (ReadS a)

sreads :: Read a => T.R (ReadS a)

greads preads p = T.uconstUse preads p sreads

sreads =
  T.uconstDef T.mkRoot areads
    (\ p ->
      T.uap1 T.mkNoSrcPos p (greadsPrec T.mkNoSrcPos p)
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0)))

gshows :: Show a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a ShowS)

sshows :: Show a => T.R (T.Fun a ShowS)

gshows pshows p = T.uconstUse pshows p sshows

sshows =
  T.uconstDef T.mkRoot ashows
    (\ p ->
      T.uap1 T.mkNoSrcPos p (gshowsPrec T.mkNoSrcPos p)
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0)))

gread :: Read a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun String a)

hread :: Read a => (T.R String) -> T.RefExp -> T.R a

gread pread p = T.ufun1 aread pread p hread

hread fs p =
  T.uccase T.mkNoSrcPos p
    (let
      v1841v21v1844v69v1 (T.R (T.Cons fx (T.R T.List _)) _) p =
        T.projection T.mkNoSrcPos p fx
      v1841v21v1844v69v1 (T.R T.List _) p =
        T.uwrapForward p
          (herror (T.fromLitString T.mkNoSrcPos p "Prelude.read: no parse") p)
      v1841v21v1844v69v1 _ p =
        T.uwrapForward p
          (herror
            (T.fromLitString T.mkNoSrcPos p "Prelude.read: ambiguous parse") p)
      in (v1841v21v1844v69v1))
    (T.uap1 T.mkNoSrcPos p
      (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
        (T.ufun2 T.mkLambda T.mkNoSrcPos p
          (\ f_x f_y p ->
            T.uccase T.mkNoSrcPos p
              (let
                v0v0v0v0v1 (T.R (T.Tuple2 fx ft) _) p =
                  T.uap1 T.mkNoSrcPos p
                    (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                      (T.ufun2 T.mkLambda T.mkNoSrcPos p
                        (\ f_x f_y p ->
                          T.uccase T.mkNoSrcPos p
                            (let
                              v0v0v0v0v1
                                (T.R (T.Tuple2 (T.R T.List _) (T.R T.List _)) _)
                                p =
                                T.uap1 T.mkNoSrcPos p
                                  (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                                    (T.projection T.mkNoSrcPos p fx)) f_y
                              v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y
                              in (v0v0v0v0v1)) f_x))
                      (T.uwrapForward p (hlex ft p))) f_y
                v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                (v0v0v0v0v1)) f_x))
        (T.uap1 T.mkNoSrcPos p (greads T.mkNoSrcPos p) fs))
      (T.fromExpList T.mkNoSrcPos p []))

gshowChar :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Char ShowS)

sshowChar :: T.R (T.Fun Char ShowS)

gshowChar pshowChar p = T.uconstUse pshowChar p sshowChar

sshowChar =
  T.uconstDef T.mkRoot ashowChar
    (\ p -> T.pa0 T.Cons T.cn2 T.mkNoSrcPos p T.aCons)

gshowString :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun String ShowS)

sshowString :: T.R (T.Fun String ShowS)

gshowString pshowString p = T.uconstUse pshowString p sshowString

sshowString = T.uconstDef T.mkRoot ashowString (\ p -> (T.mkNoSrcPos !++ p))

gshowParen :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun Bool (T.Fun ShowS ShowS))

hshowParen :: (T.R Bool) -> (T.R ShowS) -> T.RefExp -> T.R ShowS

gshowParen pshowParen p = T.ufun2 ashowParen pshowParen p hshowParen

hshowParen fb fp p =
  T.ucif p fb
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
      (T.uap1 T.mkNoSrcPos p (gshowChar T.mkNoSrcPos p)
        (T.conChar T.mkNoSrcPos p '('))
      (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p) fp
        (T.uap1 T.mkNoSrcPos p (gshowChar T.mkNoSrcPos p)
          (T.conChar T.mkNoSrcPos p ')')))) (T.projection T.mkNoSrcPos p fp)

greadParen ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun Bool (T.Fun (ReadS a) (ReadS a)))

hreadParen :: (T.R Bool) -> (T.R (ReadS a)) -> T.RefExp -> T.R (ReadS a)

greadParen preadParen p = T.ufun2 areadParen preadParen p hreadParen

hreadParen fb fg p =
  T.ucif p fb (gmandatory T.mkNoSrcPos p) (goptional T.mkNoSrcPos p)
  where
  
  goptional poptional p = T.ufun1 a1861v27v1861v58optional poptional p hoptional
  
  aoptional = a1861v27v1861v58optional
  
  hoptional fr p =
    T.uwrapForward p
      (((T.uap1 T.mkNoSrcPos p fg fr) *++ (T.uwrapForward p (hmandatory fr p)))
        p)
  
  gmandatory pmandatory p =
    T.ufun1 a1862v27v1862v35mandatory pmandatory p hmandatory
  
  amandatory = a1862v27v1862v35mandatory
  
  hmandatory fr p =
    T.uap1 T.mkNoSrcPos p
      (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
        (T.ufun2 T.mkLambda T.mkNoSrcPos p
          (\ f_x f_y p ->
            T.uccase T.mkNoSrcPos p
              (let
                v0v0v0v0v1
                  (T.R (T.Tuple2 (T.R (T.Cons (T.R '(' _) (T.R T.List _)) _) fs)
                    _) p =
                  T.uap1 T.mkNoSrcPos p
                    (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                      (T.ufun2 T.mkLambda T.mkNoSrcPos p
                        (\ f_x f_y p ->
                          T.uccase T.mkNoSrcPos p
                            (let
                              v0v0v0v0v1 (T.R (T.Tuple2 fx ft) _) p =
                                T.uap1 T.mkNoSrcPos p
                                  (T.uap2 T.mkNoSrcPos p
                                    (g_foldr T.mkNoSrcPos p)
                                    (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                      (\ f_x f_y p ->
                                        T.uccase T.mkNoSrcPos p
                                          (let
                                            v0v0v0v0v1
                                              (T.R
                                                (T.Tuple2
                                                  (T.R
                                                    (T.Cons (T.R ')' _)
                                                      (T.R T.List _)) _) fu) _)
                                              p =
                                              T.uap1 T.mkNoSrcPos p
                                                (T.pa1 T.Cons T.cn1 T.mkNoSrcPos
                                                  p T.aCons
                                                  (T.con2 T.mkNoSrcPos p
                                                    T.Tuple2 T.aTuple2 fx fu))
                                                f_y
                                            v0v0v0v0v1 _ p =
                                              T.projection T.mkNoSrcPos p f_y in
                                            (v0v0v0v0v1)) f_x))
                                    (T.uwrapForward p (hlex ft p))) f_y
                              v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y
                              in (v0v0v0v0v1)) f_x))
                      (T.uwrapForward p (hoptional fs p))) f_y
                v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                (v0v0v0v0v1)) f_x)) (T.uwrapForward p (hlex fr p)))
      (T.fromExpList T.mkNoSrcPos p [])
  

glex :: T.RefSrcPos -> T.RefExp -> T.R (ReadS String)

hlex :: (T.R (ReadS___1 String)) -> T.RefExp -> T.R (ReadS___2 String)

glex plex p = T.ufun1 alex plex p hlex

hlex (T.R T.List _) p =
  T.fromExpList T.mkNoSrcPos p
    [T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
        (T.fromLitString T.mkNoSrcPos p "") (T.fromLitString T.mkNoSrcPos p "")]
hlex (z1lex@(T.R (T.Cons fc fs) _)) p =
  T.ucguard (T.uwrapForward p (hisSpace fc p))
    (T.uwrapForward p
      (hlex (T.uwrapForward p (hdropWhile (gisSpace T.mkNoSrcPos p) fs p)) p))
    (y1lex z1lex p)
hlex z1lex p = y1lex z1lex p

y1lex (T.R (T.Cons (T.R '\'' _) fs) _) p =
  T.uap1 T.mkNoSrcPos p
    (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
      (T.ufun2 T.mkLambda T.mkNoSrcPos p
        (\ f_x f_y p ->
          T.uccase T.mkNoSrcPos p
            (let
              v0v0v0v0v1 (T.R (T.Tuple2 fch (T.R (T.Cons (T.R '\'' _) ft) _)) _)
                p =
                T.uap1 T.mkNoSrcPos p
                  (T.uap2 T.mkNoSrcPos p (g_filter T.mkNoSrcPos p)
                    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/= p) fch
                      (T.fromLitString T.mkNoSrcPos p "'"))
                    (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                      (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                        (T.con2 T.mkNoSrcPos p T.Cons T.aCons
                          (T.conChar T.mkNoSrcPos p '\'')
                          (T.uwrapForward p
                            ((fch *++ (T.fromLitString T.mkNoSrcPos p "'")) p)))
                        ft))) f_y
              v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in (v0v0v0v0v1))
            f_x)) (T.uwrapForward p (hlexLitChar fs p)))
    (T.fromExpList T.mkNoSrcPos p [])
y1lex (T.R (T.Cons (T.R '"' _) fs) _) p =
  T.uap1 T.mkNoSrcPos p
    (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
      (T.ufun2 T.mkLambda T.mkNoSrcPos p
        (\ f_x f_y p ->
          T.uccase T.mkNoSrcPos p
            (let
              v0v0v0v0v1 (T.R (T.Tuple2 fstr ft) _) p =
                T.uap1 T.mkNoSrcPos p
                  (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                    (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                      (T.con2 T.mkNoSrcPos p T.Cons T.aCons
                        (T.conChar T.mkNoSrcPos p '"')
                        (T.projection T.mkNoSrcPos p fstr)) ft)) f_y
              v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in (v0v0v0v0v1))
            f_x)) (T.uwrapForward p (hlexString fs p)))
    (T.fromExpList T.mkNoSrcPos p [])
  where
  
  glexString plexString p =
    T.ufun1 a1881v21v1882v29lexString plexString p hlexString
  
  alexString = a1881v21v1882v29lexString
  
  hlexString (T.R (T.Cons (T.R '"' _) fs) _) p =
    T.fromExpList T.mkNoSrcPos p
      [T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
          (T.fromLitString T.mkNoSrcPos p "\"")
          (T.projection T.mkNoSrcPos p fs)]
  hlexString fs p =
    T.uap1 T.mkNoSrcPos p
      (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
        (T.ufun2 T.mkLambda T.mkNoSrcPos p
          (\ f_x f_y p ->
            T.uccase T.mkNoSrcPos p
              (let
                v0v0v0v0v1 (T.R (T.Tuple2 fch ft) _) p =
                  T.uap1 T.mkNoSrcPos p
                    (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                      (T.ufun2 T.mkLambda T.mkNoSrcPos p
                        (\ f_x f_y p ->
                          T.uccase T.mkNoSrcPos p
                            (let
                              v0v0v0v0v1 (T.R (T.Tuple2 fstr fu) _) p =
                                T.uap1 T.mkNoSrcPos p
                                  (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                                    (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                                      (T.uwrapForward p ((fch *++ fstr) p)) fu))
                                  f_y
                              v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y
                              in (v0v0v0v0v1)) f_x))
                      (T.uwrapForward p (hlexString ft p))) f_y
                v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                (v0v0v0v0v1)) f_x)) (T.uwrapForward p (hlexStrItem fs p)))
      (T.fromExpList T.mkNoSrcPos p [])
  
  glexStrItem plexStrItem p =
    T.ufun1 a1886v21v1891v58lexStrItem plexStrItem p hlexStrItem
  
  alexStrItem = a1886v21v1891v58lexStrItem
  
  hlexStrItem (T.R (T.Cons (T.R '\\' _) (T.R (T.Cons (T.R '&' _) fs) _)) _) p =
    T.fromExpList T.mkNoSrcPos p
      [T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
          (T.fromLitString T.mkNoSrcPos p "\\&")
          (T.projection T.mkNoSrcPos p fs)]
  hlexStrItem
    (z1lexStrItem@(T.R (T.Cons (T.R '\\' _) (T.R (T.Cons fc fs) _)) _)) p =
    T.ucguard (T.uwrapForward p (hisSpace fc p))
      (T.uap1 T.mkNoSrcPos p
        (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
          (T.ufun2 T.mkLambda T.mkNoSrcPos p
            (\ f_x f_y p ->
              T.uccase T.mkNoSrcPos p
                (let
                  v0v0v0v0v1 (T.R (T.Cons (T.R '\\' _) ft) _) p =
                    T.uap1 T.mkNoSrcPos p
                      (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                        (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                          (T.fromLitString T.mkNoSrcPos p "\\&") ft)) f_y
                  v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                  (v0v0v0v0v1)) f_x))
          (T.fromExpList T.mkNoSrcPos p
            [T.uwrapForward p (hdropWhile (gisSpace T.mkNoSrcPos p) fs p)]))
        (T.fromExpList T.mkNoSrcPos p [])) (y1lexStrItem z1lexStrItem p)
  hlexStrItem z1lexStrItem p = y1lexStrItem z1lexStrItem p
  
  y1lexStrItem fs p = T.uwrapForward p (hlexLitChar fs p)
  
y1lex (T.R (T.Cons fc fs) _) p =
  T.ucguard (T.uwrapForward p (hisSingle fc p))
    (T.fromExpList T.mkNoSrcPos p
      [T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
          (T.fromExpList T.mkNoSrcPos p [fc]) (T.projection T.mkNoSrcPos p fs)])
    (T.ucguard (T.uwrapForward p (hisSym fc p))
      (T.uap1 T.mkNoSrcPos p
        (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
          (T.ufun2 T.mkLambda T.mkNoSrcPos p
            (\ f_x f_y p ->
              T.uccase T.mkNoSrcPos p
                (let
                  v0v0v0v0v1 (T.R (T.Tuple2 fsym ft) _) p =
                    T.uap1 T.mkNoSrcPos p
                      (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                        (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                          (T.con2 T.mkNoSrcPos p T.Cons T.aCons
                            (T.projection T.mkNoSrcPos p fc)
                            (T.projection T.mkNoSrcPos p fsym)) ft)) f_y
                  v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                  (v0v0v0v0v1)) f_x))
          (T.fromExpList T.mkNoSrcPos p
            [T.uwrapForward p (hspan (gisSym T.mkNoSrcPos p) fs p)]))
        (T.fromExpList T.mkNoSrcPos p []))
      (T.ucguard (T.uwrapForward p (hisAlpha fc p))
        (T.uap1 T.mkNoSrcPos p
          (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
            (T.ufun2 T.mkLambda T.mkNoSrcPos p
              (\ f_x f_y p ->
                T.uccase T.mkNoSrcPos p
                  (let
                    v0v0v0v0v1 (T.R (T.Tuple2 fnam ft) _) p =
                      T.uap1 T.mkNoSrcPos p
                        (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                          (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                            (T.con2 T.mkNoSrcPos p T.Cons T.aCons
                              (T.projection T.mkNoSrcPos p fc)
                              (T.projection T.mkNoSrcPos p fnam)) ft)) f_y
                    v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                    (v0v0v0v0v1)) f_x))
            (T.fromExpList T.mkNoSrcPos p
              [T.uwrapForward p (hspan (gisIdChar T.mkNoSrcPos p) fs p)]))
          (T.fromExpList T.mkNoSrcPos p []))
        (T.ucguard (T.uwrapForward p (hisDigit fc p))
          (T.uap1 T.mkNoSrcPos p
            (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
              (T.ufun2 T.mkLambda T.mkNoSrcPos p
                (\ f_x f_y p ->
                  T.uccase T.mkNoSrcPos p
                    (let
                      v0v0v0v0v1 (T.R (T.Tuple2 fds fs) _) p =
                        T.uap1 T.mkNoSrcPos p
                          (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                            (T.ufun2 T.mkLambda T.mkNoSrcPos p
                              (\ f_x f_y p ->
                                T.uccase T.mkNoSrcPos p
                                  (let
                                    v0v0v0v0v1 (T.R (T.Tuple2 ffe ft) _) p =
                                      T.uap1 T.mkNoSrcPos p
                                        (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p
                                          T.aCons
                                          (T.con2 T.mkNoSrcPos p T.Tuple2
                                            T.aTuple2
                                            (T.con2 T.mkNoSrcPos p T.Cons
                                              T.aCons
                                              (T.projection T.mkNoSrcPos p fc)
                                              (T.uwrapForward p
                                                ((fds *++ ffe) p))) ft)) f_y
                                    v0v0v0v0v1 _ p =
                                      T.projection T.mkNoSrcPos p f_y in
                                    (v0v0v0v0v1)) f_x))
                            (T.uwrapForward p (hlexFracExp fs p))) f_y
                      v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                      (v0v0v0v0v1)) f_x))
              (T.fromExpList T.mkNoSrcPos p
                [T.uwrapForward p (hspan (gisDigit T.mkNoSrcPos p) fs p)]))
            (T.fromExpList T.mkNoSrcPos p []))
          (T.ucguard (gotherwise T.mkNoSrcPos p)
            (T.con0 T.mkNoSrcPos p T.List T.aList) (T.fatal p)))))
  where
  
  gisSingle pisSingle p = T.ufun1 a1900v15v1900v49isSingle pisSingle p hisSingle
  
  aisSingle = a1900v15v1900v49isSingle
  
  hisSingle fc p =
    T.uap2 T.mkNoSrcPos p (gelem T.mkNoSrcPos p) fc
      (T.fromLitString T.mkNoSrcPos p ",;()[]{}_`")
  
  gisSym pisSym p = T.ufun1 a1901v15v1901v60isSym pisSym p hisSym
  
  aisSym = a1901v15v1901v60isSym
  
  hisSym fc p =
    T.uap2 T.mkNoSrcPos p (gelem T.mkNoSrcPos p) fc
      (T.fromLitString T.mkNoSrcPos p "!@#$%&*+./<=>?\\^|:-~")
  
  gisIdChar pisIdChar p = T.ufun1 a1902v15v1902v57isIdChar pisIdChar p hisIdChar
  
  aisIdChar = a1902v15v1902v57isIdChar
  
  hisIdChar fc p =
    T.uwrapForward p
      (((T.uwrapForward p (hisAlphaNum fc p))
          *||
          (T.uap2 T.mkNoSrcPos p (gelem T.mkNoSrcPos p) fc
            (T.fromLitString T.mkNoSrcPos p "_'"))) p)
  
  glexFracExp plexFracExp p =
    T.ufun1 a1904v15v1907v38lexFracExp plexFracExp p hlexFracExp
  
  alexFracExp = a1904v15v1907v38lexFracExp
  
  hlexFracExp
    (z1lexFracExp@(T.R (T.Cons (T.R '.' _) (T.R (T.Cons fc fcs) _)) _)) p =
    T.ucguard (T.uwrapForward p (hisDigit fc p))
      (T.uap1 T.mkNoSrcPos p
        (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
          (T.ufun2 T.mkLambda T.mkNoSrcPos p
            (\ f_x f_y p ->
              T.uccase T.mkNoSrcPos p
                (let
                  v0v0v0v0v1 (T.R (T.Tuple2 fds ft) _) p =
                    T.uap1 T.mkNoSrcPos p
                      (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                        (T.ufun2 T.mkLambda T.mkNoSrcPos p
                          (\ f_x f_y p ->
                            T.uccase T.mkNoSrcPos p
                              (let
                                v0v0v0v0v1 (T.R (T.Tuple2 fe fu) _) p =
                                  T.uap1 T.mkNoSrcPos p
                                    (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                                      (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                                        (T.con2 T.mkNoSrcPos p T.Cons T.aCons
                                          (T.conChar T.mkNoSrcPos p '.')
                                          (T.uwrapForward p ((fds *++ fe) p)))
                                        fu)) f_y
                                v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y
                                in (v0v0v0v0v1)) f_x))
                        (T.uwrapForward p (hlexExp ft p))) f_y
                  v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                  (v0v0v0v0v1)) f_x))
          (T.uap1 T.mkNoSrcPos p (glexDigits T.mkNoSrcPos p)
            (T.con2 T.mkNoSrcPos p T.Cons T.aCons
              (T.projection T.mkNoSrcPos p fc)
              (T.projection T.mkNoSrcPos p fcs))))
        (T.fromExpList T.mkNoSrcPos p [])) (y1lexFracExp z1lexFracExp p)
  hlexFracExp z1lexFracExp p = y1lexFracExp z1lexFracExp p
  
  y1lexFracExp fs p = T.uwrapForward p (hlexExp fs p)
  
  glexExp plexExp p = T.ufun1 a1909v15v1913v33lexExp plexExp p hlexExp
  
  alexExp = a1909v15v1913v33lexExp
  
  hlexExp (z1lexExp@(T.R (T.Cons fe fs) _)) p =
    T.ucguard
      (T.uap2 T.mkNoSrcPos p (gelem T.mkNoSrcPos p) fe
        (T.fromLitString T.mkNoSrcPos p "eE"))
      (T.uwrapForward p
        (((T.uap1 T.mkNoSrcPos p
              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                  (\ f_x f_y p ->
                    T.uccase T.mkNoSrcPos p
                      (let
                        v0v0v0v0v1 (T.R (T.Cons fc ft) _) p =
                          T.uap1 T.mkNoSrcPos p
                            (T.uap2 T.mkNoSrcPos p (g_filter T.mkNoSrcPos p)
                              (T.uap2 T.mkNoSrcPos p (gelem T.mkNoSrcPos p) fc
                                (T.fromLitString T.mkNoSrcPos p "+-"))
                              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                  (\ f_x f_y p ->
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v0v0v0v0v1 (T.R (T.Tuple2 fds fu) _) p =
                                          T.uap1 T.mkNoSrcPos p
                                            (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p
                                              T.aCons
                                              (T.con2 T.mkNoSrcPos p T.Tuple2
                                                T.aTuple2
                                                (T.con2 T.mkNoSrcPos p T.Cons
                                                  T.aCons
                                                  (T.projection T.mkNoSrcPos p
                                                    fe)
                                                  (T.con2 T.mkNoSrcPos p T.Cons
                                                    T.aCons fc fds)) fu)) f_y
                                        v0v0v0v0v1 _ p =
                                          T.projection T.mkNoSrcPos p f_y in
                                        (v0v0v0v0v1)) f_x))
                                (T.uap1 T.mkNoSrcPos p
                                  (glexDigits T.mkNoSrcPos p) ft))) f_y
                        v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                        (v0v0v0v0v1)) f_x)) (T.fromExpList T.mkNoSrcPos p [fs]))
              (T.fromExpList T.mkNoSrcPos p []))
            *++
            (T.uap1 T.mkNoSrcPos p
              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                  (\ f_x f_y p ->
                    T.uccase T.mkNoSrcPos p
                      (let
                        v0v0v0v0v1 (T.R (T.Tuple2 fds ft) _) p =
                          T.uap1 T.mkNoSrcPos p
                            (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                              (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                                (T.con2 T.mkNoSrcPos p T.Cons T.aCons
                                  (T.projection T.mkNoSrcPos p fe)
                                  (T.projection T.mkNoSrcPos p fds)) ft)) f_y
                        v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                        (v0v0v0v0v1)) f_x))
                (T.uap1 T.mkNoSrcPos p (glexDigits T.mkNoSrcPos p) fs))
              (T.fromExpList T.mkNoSrcPos p []))) p)) (y1lexExp z1lexExp p)
  hlexExp z1lexExp p = y1lexExp z1lexExp p
  
  y1lexExp fs p =
    T.fromExpList T.mkNoSrcPos p
      [T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
          (T.fromLitString T.mkNoSrcPos p "") (T.projection T.mkNoSrcPos p fs)]
  
y1lex _ p = T.fatal p

instance Show (Int)
  where
  
  gshowsPrec pshowsPrec p =
    T.ufun1 a1917v5v1917v41showsPrec pshowsPrec p hshowsPrec
    where
    
    hshowsPrec fn p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
        (T.uap1 T.mkNoSrcPos p (gshowsPrec T.mkNoSrcPos p) fn)
        (gtoInteger T.mkNoSrcPos p)
    
  

instance Read (Int)
  where
  
  greadsPrec preadsPrec p =
    T.ufun2 a1923v3v1923v11readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp fr p =
      T.uap1 T.mkNoSrcPos p
        (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
          (T.ufun2 T.mkLambda T.mkNoSrcPos p
            (\ f_x f_y p ->
              T.uccase T.mkNoSrcPos p
                (let
                  v0v0v0v0v1 (T.R (T.Tuple2 fi ft) _) p =
                    T.uap1 T.mkNoSrcPos p
                      (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p T.aCons
                        (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                          (T.uap1 T.mkNoSrcPos p (gfromInteger T.mkNoSrcPos p)
                            fi) ft)) f_y
                  v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                  (v0v0v0v0v1)) f_x))
          (T.uap2 T.mkNoSrcPos p (greadsPrec T.mkNoSrcPos p) fp fr))
        (T.fromExpList T.mkNoSrcPos p [])
    
  

instance Show (Integer)
  where
  
  gshowsPrec pshowsPrec p = T.uconstUse pshowsPrec p sshowsPrec
  
  sshowsPrec =
    T.uconstDef T.mkRoot a1929v5v1929v44showsPrec
      (\ p ->
        T.uap1 T.mkNoSrcPos p (gshowSigned T.mkNoSrcPos p)
          (gshowInt T.mkNoSrcPos p))
  

instance Read (Integer)
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a1933v5v1933v44readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p = T.uwrapForward p (hreadSigned (greadDec T.mkNoSrcPos p) p)
    
  

instance Show (Float)
  where
  
  gshowsPrec pshowsPrec p =
    T.ufun1 a1937v5v1937v35showsPrec pshowsPrec p hshowsPrec
    where
    
    hshowsPrec fp p = gshowFloat T.mkNoSrcPos p
    
  

instance Read (Float)
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a1941v5v1941v46readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p =
      T.uwrapForward p (hreadSigned (greadFloat T.mkNoSrcPos p) p)
    
  

instance Show (Double)
  where
  
  gshowsPrec pshowsPrec p =
    T.ufun1 a1945v5v1945v35showsPrec pshowsPrec p hshowsPrec
    where
    
    hshowsPrec fp p = gshowFloat T.mkNoSrcPos p
    
  

instance Read (Double)
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a1949v5v1949v46readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p =
      T.uwrapForward p (hreadSigned (greadFloat T.mkNoSrcPos p) p)
    
  

instance Show (T.Tuple0)
  where
  
  gshowsPrec pshowsPrec p =
    T.ufun2 a1953v5v1953v37showsPrec pshowsPrec p hshowsPrec
    where
    
    hshowsPrec fp (T.R T.Tuple0 _) p =
      T.uap1 T.mkNoSrcPos p (gshowString T.mkNoSrcPos p)
        (T.fromLitString T.mkNoSrcPos p "()")
    hshowsPrec _ _ p = T.fatal p
    
  

instance Read (T.Tuple0)
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a1957v5v1958v30readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p =
      T.uwrapForward p
        (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
          (T.ufun1 T.mkLambda T.mkNoSrcPos p
            (\ fr p ->
              T.uap1 T.mkNoSrcPos p
                (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                  (T.ufun2 T.mkLambda T.mkNoSrcPos p
                    (\ f_x f_y p ->
                      T.uccase T.mkNoSrcPos p
                        (let
                          v0v0v0v0v1
                            (T.R
                              (T.Tuple2
                                (T.R (T.Cons (T.R '(' _) (T.R T.List _)) _) fs)
                              _) p =
                            T.uap1 T.mkNoSrcPos p
                              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                  (\ f_x f_y p ->
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v0v0v0v0v1
                                          (T.R
                                            (T.Tuple2
                                              (T.R
                                                (T.Cons (T.R ')' _)
                                                  (T.R T.List _)) _) ft) _) p =
                                          T.uap1 T.mkNoSrcPos p
                                            (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p
                                              T.aCons
                                              (T.con2 T.mkNoSrcPos p T.Tuple2
                                                T.aTuple2
                                                (T.con0 T.mkNoSrcPos p T.Tuple0
                                                  T.aTuple0) ft)) f_y
                                        v0v0v0v0v1 _ p =
                                          T.projection T.mkNoSrcPos p f_y in
                                        (v0v0v0v0v1)) f_x))
                                (T.uwrapForward p (hlex fs p))) f_y
                          v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                          (v0v0v0v0v1)) f_x)) (T.uwrapForward p (hlex fr p)))
                (T.fromExpList T.mkNoSrcPos p []))) p)
    
  

instance Show (Char)
  where
  
  gshowsPrec pshowsPrec p =
    T.ufun2 a1962v5v1963v68showsPrec pshowsPrec p hshowsPrec
    where
    
    hshowsPrec fp (T.R '\'' _) p =
      T.uap1 T.mkNoSrcPos p (gshowString T.mkNoSrcPos p)
        (T.fromLitString T.mkNoSrcPos p "'\\''")
    hshowsPrec fp fc p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
        (T.uap1 T.mkNoSrcPos p (gshowChar T.mkNoSrcPos p)
          (T.conChar T.mkNoSrcPos p '\''))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
          (T.uwrapForward p (hshowLitChar fc p))
          (T.uap1 T.mkNoSrcPos p (gshowChar T.mkNoSrcPos p)
            (T.conChar T.mkNoSrcPos p '\'')))
    
  
  gshowList pshowList p =
    T.ufun1 a1965v5v1968v64showList pshowList p hshowList
    where
    
    hshowList fcs p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
        (T.uap1 T.mkNoSrcPos p (gshowChar T.mkNoSrcPos p)
          (T.conChar T.mkNoSrcPos p '"')) (T.uwrapForward p (hshowl fcs p))
      where
      
      gshowl pshowl p = T.ufun1 a1966v24v1968v64showl pshowl p hshowl
      
      ashowl = a1966v24v1968v64showl
      
      hshowl (T.R T.List _) p =
        T.uap1 T.mkNoSrcPos p (gshowChar T.mkNoSrcPos p)
          (T.conChar T.mkNoSrcPos p '"')
      hshowl (T.R (T.Cons (T.R '"' _) fcs) _) p =
        T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
          (T.uap1 T.mkNoSrcPos p (gshowString T.mkNoSrcPos p)
            (T.fromLitString T.mkNoSrcPos p "\\\""))
          (T.uwrapForward p (hshowl fcs p))
      hshowl (T.R (T.Cons fc fcs) _) p =
        T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
          (T.uwrapForward p (hshowLitChar fc p))
          (T.uwrapForward p (hshowl fcs p))
      hshowl _ p = T.fatal p
      
    
  

instance Read (Char)
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a1972v5v1973v30readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p =
      T.uwrapForward p
        (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
          (T.ufun1 T.mkLambda T.mkNoSrcPos p
            (\ fr p ->
              T.uap1 T.mkNoSrcPos p
                (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                  (T.ufun2 T.mkLambda T.mkNoSrcPos p
                    (\ f_x f_y p ->
                      T.uccase T.mkNoSrcPos p
                        (let
                          v0v0v0v0v1
                            (T.R (T.Tuple2 (T.R (T.Cons (T.R '\'' _) fs) _) ft)
                              _) p =
                            T.uap1 T.mkNoSrcPos p
                              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                  (\ f_x f_y p ->
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v0v0v0v0v1
                                          (T.R
                                            (T.Tuple2 fc
                                              (T.R
                                                (T.Cons (T.R '\'' _)
                                                  (T.R T.List _)) _)) _) p =
                                          T.uap1 T.mkNoSrcPos p
                                            (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p
                                              T.aCons
                                              (T.con2 T.mkNoSrcPos p T.Tuple2
                                                T.aTuple2 fc ft)) f_y
                                        v0v0v0v0v1 _ p =
                                          T.projection T.mkNoSrcPos p f_y in
                                        (v0v0v0v0v1)) f_x))
                                (T.uwrapForward p (hreadLitChar fs p))) f_y
                          v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                          (v0v0v0v0v1)) f_x)) (T.uwrapForward p (hlex fr p)))
                (T.fromExpList T.mkNoSrcPos p []))) p)
    
  
  greadList preadList p = T.uconstUse preadList p sreadList
  
  sreadList =
    T.uconstDef T.mkRoot a1976v5v1980v19readList
      (\ p ->
        let
          greadl preadl p = T.ufun1 a1978v15v1980v19readl preadl p hreadl
          areadl = a1978v15v1980v19readl
          hreadl (T.R (T.Cons (T.R '"' _) fs) _) p =
            T.fromExpList T.mkNoSrcPos p
              [T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2
                  (T.fromLitString T.mkNoSrcPos p "")
                  (T.projection T.mkNoSrcPos p fs)]
          hreadl (T.R (T.Cons (T.R '\\' _) (T.R (T.Cons (T.R '&' _) fs) _)) _)
            p =
            T.uwrapForward p (hreadl fs p)
          hreadl fs p =
            T.uap1 T.mkNoSrcPos p
              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                  (\ f_x f_y p ->
                    T.uccase T.mkNoSrcPos p
                      (let
                        v0v0v0v0v1 (T.R (T.Tuple2 fc ft) _) p =
                          T.uap1 T.mkNoSrcPos p
                            (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                              (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                (\ f_x f_y p ->
                                  T.uccase T.mkNoSrcPos p
                                    (let
                                      v0v0v0v0v1 (T.R (T.Tuple2 fcs fu) _) p =
                                        T.uap1 T.mkNoSrcPos p
                                          (T.pa1 T.Cons T.cn1 T.mkNoSrcPos p
                                            T.aCons
                                            (T.con2 T.mkNoSrcPos p T.Tuple2
                                              T.aTuple2
                                              (T.con2 T.mkNoSrcPos p T.Cons
                                                T.aCons
                                                (T.projection T.mkNoSrcPos p fc)
                                                (T.projection T.mkNoSrcPos p
                                                  fcs)) fu)) f_y
                                      v0v0v0v0v1 _ p =
                                        T.projection T.mkNoSrcPos p f_y in
                                      (v0v0v0v0v1)) f_x))
                              (T.uwrapForward p (hreadl ft p))) f_y
                        v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                        (v0v0v0v0v1)) f_x))
                (T.uwrapForward p (hreadLitChar fs p)))
              (T.fromExpList T.mkNoSrcPos p []) in
          (T.uwrapForward p
            (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
              (T.ufun1 T.mkLambda T.mkNoSrcPos p
                (\ fr p ->
                  T.uap1 T.mkNoSrcPos p
                    (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                      (T.ufun2 T.mkLambda T.mkNoSrcPos p
                        (\ f_x f_y p ->
                          T.uccase T.mkNoSrcPos p
                            (let
                              v0v0v0v0v1
                                (T.R
                                  (T.Tuple2 (T.R (T.Cons (T.R '"' _) fs) _) ft)
                                  _) p =
                                T.uap1 T.mkNoSrcPos p
                                  (T.uap2 T.mkNoSrcPos p
                                    (g_foldr T.mkNoSrcPos p)
                                    (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                      (\ f_x f_y p ->
                                        T.uccase T.mkNoSrcPos p
                                          (let
                                            v0v0v0v0v1 (T.R (T.Tuple2 fl _) _)
                                              p =
                                              T.uap1 T.mkNoSrcPos p
                                                (T.pa1 T.Cons T.cn1 T.mkNoSrcPos
                                                  p T.aCons
                                                  (T.con2 T.mkNoSrcPos p
                                                    T.Tuple2 T.aTuple2 fl ft))
                                                f_y
                                            v0v0v0v0v1 _ p =
                                              T.projection T.mkNoSrcPos p f_y in
                                            (v0v0v0v0v1)) f_x))
                                    (T.uwrapForward p (hreadl fs p))) f_y
                              v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y
                              in (v0v0v0v0v1)) f_x))
                      (T.uwrapForward p (hlex fr p)))
                    (T.fromExpList T.mkNoSrcPos p []))) p)))
  

instance Show a => Show ((T.List a))
  where
  
  gshowsPrec pshowsPrec p =
    T.ufun1 a1985v5v1985v31showsPrec pshowsPrec p hshowsPrec
    where
    
    hshowsPrec fp p = gshowList T.mkNoSrcPos p
    
  

instance Read a => Read ((T.List a))
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a1989v5v1989v31readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p = greadList T.mkNoSrcPos p
    
  

instance (Show a,Show b) => Show ((T.Tuple2 a b))
  where
  
  gshowsPrec pshowsPrec p =
    T.ufun2 a1995v5v1996v61showsPrec pshowsPrec p hshowsPrec
    where
    
    hshowsPrec fp (T.R (T.Tuple2 fx fy) _) p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
        (T.uap1 T.mkNoSrcPos p (gshowChar T.mkNoSrcPos p)
          (T.conChar T.mkNoSrcPos p '('))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
          (T.uap1 T.mkNoSrcPos p (gshows T.mkNoSrcPos p) fx)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
            (T.uap1 T.mkNoSrcPos p (gshowChar T.mkNoSrcPos p)
              (T.conChar T.mkNoSrcPos p ','))
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !. p)
              (T.uap1 T.mkNoSrcPos p (gshows T.mkNoSrcPos p) fy)
              (T.uap1 T.mkNoSrcPos p (gshowChar T.mkNoSrcPos p)
                (T.conChar T.mkNoSrcPos p ')')))))
    hshowsPrec _ _ p = T.fatal p
    
  

instance (Read a,Read b) => Read ((T.Tuple2 a b))
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a2000v5v2001v30readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p =
      T.uwrapForward p
        (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
          (T.ufun1 T.mkLambda T.mkNoSrcPos p
            (\ fr p ->
              T.uap1 T.mkNoSrcPos p
                (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                  (T.ufun2 T.mkLambda T.mkNoSrcPos p
                    (\ f_x f_y p ->
                      T.uccase T.mkNoSrcPos p
                        (let
                          v0v0v0v0v1
                            (T.R
                              (T.Tuple2
                                (T.R (T.Cons (T.R '(' _) (T.R T.List _)) _) fs)
                              _) p =
                            T.uap1 T.mkNoSrcPos p
                              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                  (\ f_x f_y p ->
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v0v0v0v0v1 (T.R (T.Tuple2 fx ft) _) p =
                                          T.uap1 T.mkNoSrcPos p
                                            (T.uap2 T.mkNoSrcPos p
                                              (g_foldr T.mkNoSrcPos p)
                                              (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                                (\ f_x f_y p ->
                                                  T.uccase T.mkNoSrcPos p
                                                    (let
                                                      v0v0v0v0v1
                                                        (T.R
                                                          (T.Tuple2
                                                            (T.R
                                                              (T.Cons
                                                                (T.R ',' _)
                                                                (T.R T.List _))
                                                              _) fu) _) p =
                                                        T.uap1 T.mkNoSrcPos p
                                                          (T.uap2 T.mkNoSrcPos p
                                                            (g_foldr
                                                              T.mkNoSrcPos p)
                                                            (T.ufun2 T.mkLambda
                                                              T.mkNoSrcPos p
                                                              (\ f_x f_y p ->
                                                                T.uccase
                                                                  T.mkNoSrcPos p
                                                                  (let
                                                                    v0v0v0v0v1
                                                                      (T.R
                                                                        (T.Tuple2
                                                                          fy fv)
                                                                        _) p =
                                                                      T.uap1
                                                                        T.mkNoSrcPos
                                                                        p
                                                                        (T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (g_foldr
                                                                            T.mkNoSrcPos
                                                                            p)
                                                                          (T.ufun2
                                                                            T.mkLambda
                                                                            T.mkNoSrcPos
                                                                            p
                                                                            (\ f_x
                                                                              f_y
                                                                              p ->
                                                                              T.uccase
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (let
                                                                                  v0v0v0v0v1
                                                                                    (T.R
                                                                                      (T.Tuple2
                                                                                        (T.R
                                                                                          (T.Cons
                                                                                            (T.R
                                                                                              ')'
                                                                                              _)
                                                                                            (T.R
                                                                                              T.List
                                                                                              _))
                                                                                          _)
                                                                                        fw)
                                                                                      _)
                                                                                    p =
                                                                                    T.uap1
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      (T.pa1
                                                                                        T.Cons
                                                                                        T.cn1
                                                                                        T.mkNoSrcPos
                                                                                        p
                                                                                        T.aCons
                                                                                        (T.con2
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          T.Tuple2
                                                                                          T.aTuple2
                                                                                          (T.con2
                                                                                            T.mkNoSrcPos
                                                                                            p
                                                                                            T.Tuple2
                                                                                            T.aTuple2
                                                                                            (T.projection
                                                                                              T.mkNoSrcPos
                                                                                              p
                                                                                              fx)
                                                                                            (T.projection
                                                                                              T.mkNoSrcPos
                                                                                              p
                                                                                              fy))
                                                                                          fw))
                                                                                      f_y
                                                                                  v0v0v0v0v1
                                                                                    _
                                                                                    p =
                                                                                    T.projection
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      f_y
                                                                                  in
                                                                                  (v0v0v0v0v1))
                                                                                f_x))
                                                                          (T.uwrapForward
                                                                            p
                                                                            (hlex
                                                                              fv
                                                                              p)))
                                                                        f_y
                                                                    v0v0v0v0v1 _
                                                                      p =
                                                                      T.projection
                                                                        T.mkNoSrcPos
                                                                        p f_y in
                                                                    (v0v0v0v0v1))
                                                                  f_x))
                                                            (T.uap1 T.mkNoSrcPos
                                                              p
                                                              (greads
                                                                T.mkNoSrcPos p)
                                                              fu)) f_y
                                                      v0v0v0v0v1 _ p =
                                                        T.projection
                                                          T.mkNoSrcPos p f_y in
                                                      (v0v0v0v0v1)) f_x))
                                              (T.uwrapForward p (hlex ft p)))
                                            f_y
                                        v0v0v0v0v1 _ p =
                                          T.projection T.mkNoSrcPos p f_y in
                                        (v0v0v0v0v1)) f_x))
                                (T.uap1 T.mkNoSrcPos p (greads T.mkNoSrcPos p)
                                  fs)) f_y
                          v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                          (v0v0v0v0v1)) f_x)) (T.uwrapForward p (hlex fr p)))
                (T.fromExpList T.mkNoSrcPos p []))) p)
    
  

instance (Read a,Read b,Read c) => Read ((T.Tuple3 a b c))
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a2009v5v2010v30readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p =
      T.uwrapForward p
        (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
          (T.ufun1 T.mkLambda T.mkNoSrcPos p
            (\ fr0 p ->
              T.uap1 T.mkNoSrcPos p
                (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                  (T.ufun2 T.mkLambda T.mkNoSrcPos p
                    (\ f_x f_y p ->
                      T.uccase T.mkNoSrcPos p
                        (let
                          v0v0v0v0v1
                            (T.R
                              (T.Tuple2
                                (T.R (T.Cons (T.R '(' _) (T.R T.List _)) _) fs1)
                              _) p =
                            T.uap1 T.mkNoSrcPos p
                              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                  (\ f_x f_y p ->
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v0v0v0v0v1 (T.R (T.Tuple2 fx1 fr1) _)
                                          p =
                                          T.uap1 T.mkNoSrcPos p
                                            (T.uap2 T.mkNoSrcPos p
                                              (g_foldr T.mkNoSrcPos p)
                                              (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                                (\ f_x f_y p ->
                                                  T.uccase T.mkNoSrcPos p
                                                    (let
                                                      v0v0v0v0v1
                                                        (T.R
                                                          (T.Tuple2
                                                            (T.R
                                                              (T.Cons
                                                                (T.R ',' _)
                                                                (T.R T.List _))
                                                              _) fs2) _) p =
                                                        T.uap1 T.mkNoSrcPos p
                                                          (T.uap2 T.mkNoSrcPos p
                                                            (g_foldr
                                                              T.mkNoSrcPos p)
                                                            (T.ufun2 T.mkLambda
                                                              T.mkNoSrcPos p
                                                              (\ f_x f_y p ->
                                                                T.uccase
                                                                  T.mkNoSrcPos p
                                                                  (let
                                                                    v0v0v0v0v1
                                                                      (T.R
                                                                        (T.Tuple2
                                                                          fx2
                                                                          fr2)
                                                                        _) p =
                                                                      T.uap1
                                                                        T.mkNoSrcPos
                                                                        p
                                                                        (T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (g_foldr
                                                                            T.mkNoSrcPos
                                                                            p)
                                                                          (T.ufun2
                                                                            T.mkLambda
                                                                            T.mkNoSrcPos
                                                                            p
                                                                            (\ f_x
                                                                              f_y
                                                                              p ->
                                                                              T.uccase
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (let
                                                                                  v0v0v0v0v1
                                                                                    (T.R
                                                                                      (T.Tuple2
                                                                                        (T.R
                                                                                          (T.Cons
                                                                                            (T.R
                                                                                              ','
                                                                                              _)
                                                                                            (T.R
                                                                                              T.List
                                                                                              _))
                                                                                          _)
                                                                                        fs3)
                                                                                      _)
                                                                                    p =
                                                                                    T.uap1
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      (T.uap2
                                                                                        T.mkNoSrcPos
                                                                                        p
                                                                                        (g_foldr
                                                                                          T.mkNoSrcPos
                                                                                          p)
                                                                                        (T.ufun2
                                                                                          T.mkLambda
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (\ f_x
                                                                                            f_y
                                                                                            p ->
                                                                                            T.uccase
                                                                                              T.mkNoSrcPos
                                                                                              p
                                                                                              (let
                                                                                                v0v0v0v0v1
                                                                                                  (T.R
                                                                                                    (T.Tuple2
                                                                                                      fx3
                                                                                                      fr3)
                                                                                                    _)
                                                                                                  p =
                                                                                                  T.uap1
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    (T.uap2
                                                                                                      T.mkNoSrcPos
                                                                                                      p
                                                                                                      (g_foldr
                                                                                                        T.mkNoSrcPos
                                                                                                        p)
                                                                                                      (T.ufun2
                                                                                                        T.mkLambda
                                                                                                        T.mkNoSrcPos
                                                                                                        p
                                                                                                        (\ f_x
                                                                                                          f_y
                                                                                                          p ->
                                                                                                          T.uccase
                                                                                                            T.mkNoSrcPos
                                                                                                            p
                                                                                                            (let
                                                                                                              v0v0v0v0v1
                                                                                                                (T.R
                                                                                                                  (T.Tuple2
                                                                                                                    (T.R
                                                                                                                      (T.Cons
                                                                                                                        (T.R
                                                                                                                          ')'
                                                                                                                          _)
                                                                                                                        (T.R
                                                                                                                          T.List
                                                                                                                          _))
                                                                                                                      _)
                                                                                                                    fw)
                                                                                                                  _)
                                                                                                                p =
                                                                                                                T.uap1
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  (T.pa1
                                                                                                                    T.Cons
                                                                                                                    T.cn1
                                                                                                                    T.mkNoSrcPos
                                                                                                                    p
                                                                                                                    T.aCons
                                                                                                                    (T.con2
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p
                                                                                                                      T.Tuple2
                                                                                                                      T.aTuple2
                                                                                                                      (T.con3
                                                                                                                        T.mkNoSrcPos
                                                                                                                        p
                                                                                                                        T.Tuple3
                                                                                                                        T.aTuple3
                                                                                                                        (T.projection
                                                                                                                          T.mkNoSrcPos
                                                                                                                          p
                                                                                                                          fx1)
                                                                                                                        (T.projection
                                                                                                                          T.mkNoSrcPos
                                                                                                                          p
                                                                                                                          fx2)
                                                                                                                        (T.projection
                                                                                                                          T.mkNoSrcPos
                                                                                                                          p
                                                                                                                          fx3))
                                                                                                                      fw))
                                                                                                                  f_y
                                                                                                              v0v0v0v0v1
                                                                                                                _
                                                                                                                p =
                                                                                                                T.projection
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  f_y
                                                                                                              in
                                                                                                              (v0v0v0v0v1))
                                                                                                            f_x))
                                                                                                      (T.uwrapForward
                                                                                                        p
                                                                                                        (hlex
                                                                                                          fr3
                                                                                                          p)))
                                                                                                    f_y
                                                                                                v0v0v0v0v1
                                                                                                  _
                                                                                                  p =
                                                                                                  T.projection
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    f_y
                                                                                                in
                                                                                                (v0v0v0v0v1))
                                                                                              f_x))
                                                                                        (T.uap1
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (greads
                                                                                            T.mkNoSrcPos
                                                                                            p)
                                                                                          fs3))
                                                                                      f_y
                                                                                  v0v0v0v0v1
                                                                                    _
                                                                                    p =
                                                                                    T.projection
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      f_y
                                                                                  in
                                                                                  (v0v0v0v0v1))
                                                                                f_x))
                                                                          (T.uwrapForward
                                                                            p
                                                                            (hlex
                                                                              fr2
                                                                              p)))
                                                                        f_y
                                                                    v0v0v0v0v1 _
                                                                      p =
                                                                      T.projection
                                                                        T.mkNoSrcPos
                                                                        p f_y in
                                                                    (v0v0v0v0v1))
                                                                  f_x))
                                                            (T.uap1 T.mkNoSrcPos
                                                              p
                                                              (greads
                                                                T.mkNoSrcPos p)
                                                              fs2)) f_y
                                                      v0v0v0v0v1 _ p =
                                                        T.projection
                                                          T.mkNoSrcPos p f_y in
                                                      (v0v0v0v0v1)) f_x))
                                              (T.uwrapForward p (hlex fr1 p)))
                                            f_y
                                        v0v0v0v0v1 _ p =
                                          T.projection T.mkNoSrcPos p f_y in
                                        (v0v0v0v0v1)) f_x))
                                (T.uap1 T.mkNoSrcPos p (greads T.mkNoSrcPos p)
                                  fs1)) f_y
                          v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                          (v0v0v0v0v1)) f_x)) (T.uwrapForward p (hlex fr0 p)))
                (T.fromExpList T.mkNoSrcPos p []))) p)
    
  

instance (Read a,Read b,Read c,Read d) => Read ((T.Tuple4 a b c d))
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a2020v5v2021v30readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p =
      T.uwrapForward p
        (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
          (T.ufun1 T.mkLambda T.mkNoSrcPos p
            (\ fr0 p ->
              T.uap1 T.mkNoSrcPos p
                (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                  (T.ufun2 T.mkLambda T.mkNoSrcPos p
                    (\ f_x f_y p ->
                      T.uccase T.mkNoSrcPos p
                        (let
                          v0v0v0v0v1
                            (T.R
                              (T.Tuple2
                                (T.R (T.Cons (T.R '(' _) (T.R T.List _)) _) fs1)
                              _) p =
                            T.uap1 T.mkNoSrcPos p
                              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                  (\ f_x f_y p ->
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v0v0v0v0v1 (T.R (T.Tuple2 fx1 fr1) _)
                                          p =
                                          T.uap1 T.mkNoSrcPos p
                                            (T.uap2 T.mkNoSrcPos p
                                              (g_foldr T.mkNoSrcPos p)
                                              (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                                (\ f_x f_y p ->
                                                  T.uccase T.mkNoSrcPos p
                                                    (let
                                                      v0v0v0v0v1
                                                        (T.R
                                                          (T.Tuple2
                                                            (T.R
                                                              (T.Cons
                                                                (T.R ',' _)
                                                                (T.R T.List _))
                                                              _) fs2) _) p =
                                                        T.uap1 T.mkNoSrcPos p
                                                          (T.uap2 T.mkNoSrcPos p
                                                            (g_foldr
                                                              T.mkNoSrcPos p)
                                                            (T.ufun2 T.mkLambda
                                                              T.mkNoSrcPos p
                                                              (\ f_x f_y p ->
                                                                T.uccase
                                                                  T.mkNoSrcPos p
                                                                  (let
                                                                    v0v0v0v0v1
                                                                      (T.R
                                                                        (T.Tuple2
                                                                          fx2
                                                                          fr2)
                                                                        _) p =
                                                                      T.uap1
                                                                        T.mkNoSrcPos
                                                                        p
                                                                        (T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (g_foldr
                                                                            T.mkNoSrcPos
                                                                            p)
                                                                          (T.ufun2
                                                                            T.mkLambda
                                                                            T.mkNoSrcPos
                                                                            p
                                                                            (\ f_x
                                                                              f_y
                                                                              p ->
                                                                              T.uccase
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (let
                                                                                  v0v0v0v0v1
                                                                                    (T.R
                                                                                      (T.Tuple2
                                                                                        (T.R
                                                                                          (T.Cons
                                                                                            (T.R
                                                                                              ','
                                                                                              _)
                                                                                            (T.R
                                                                                              T.List
                                                                                              _))
                                                                                          _)
                                                                                        fs3)
                                                                                      _)
                                                                                    p =
                                                                                    T.uap1
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      (T.uap2
                                                                                        T.mkNoSrcPos
                                                                                        p
                                                                                        (g_foldr
                                                                                          T.mkNoSrcPos
                                                                                          p)
                                                                                        (T.ufun2
                                                                                          T.mkLambda
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (\ f_x
                                                                                            f_y
                                                                                            p ->
                                                                                            T.uccase
                                                                                              T.mkNoSrcPos
                                                                                              p
                                                                                              (let
                                                                                                v0v0v0v0v1
                                                                                                  (T.R
                                                                                                    (T.Tuple2
                                                                                                      fx3
                                                                                                      fr3)
                                                                                                    _)
                                                                                                  p =
                                                                                                  T.uap1
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    (T.uap2
                                                                                                      T.mkNoSrcPos
                                                                                                      p
                                                                                                      (g_foldr
                                                                                                        T.mkNoSrcPos
                                                                                                        p)
                                                                                                      (T.ufun2
                                                                                                        T.mkLambda
                                                                                                        T.mkNoSrcPos
                                                                                                        p
                                                                                                        (\ f_x
                                                                                                          f_y
                                                                                                          p ->
                                                                                                          T.uccase
                                                                                                            T.mkNoSrcPos
                                                                                                            p
                                                                                                            (let
                                                                                                              v0v0v0v0v1
                                                                                                                (T.R
                                                                                                                  (T.Tuple2
                                                                                                                    (T.R
                                                                                                                      (T.Cons
                                                                                                                        (T.R
                                                                                                                          ','
                                                                                                                          _)
                                                                                                                        (T.R
                                                                                                                          T.List
                                                                                                                          _))
                                                                                                                      _)
                                                                                                                    fs4)
                                                                                                                  _)
                                                                                                                p =
                                                                                                                T.uap1
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  (T.uap2
                                                                                                                    T.mkNoSrcPos
                                                                                                                    p
                                                                                                                    (g_foldr
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p)
                                                                                                                    (T.ufun2
                                                                                                                      T.mkLambda
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p
                                                                                                                      (\ f_x
                                                                                                                        f_y
                                                                                                                        p ->
                                                                                                                        T.uccase
                                                                                                                          T.mkNoSrcPos
                                                                                                                          p
                                                                                                                          (let
                                                                                                                            v0v0v0v0v1
                                                                                                                              (T.R
                                                                                                                                (T.Tuple2
                                                                                                                                  fx4
                                                                                                                                  fr4)
                                                                                                                                _)
                                                                                                                              p =
                                                                                                                              T.uap1
                                                                                                                                T.mkNoSrcPos
                                                                                                                                p
                                                                                                                                (T.uap2
                                                                                                                                  T.mkNoSrcPos
                                                                                                                                  p
                                                                                                                                  (g_foldr
                                                                                                                                    T.mkNoSrcPos
                                                                                                                                    p)
                                                                                                                                  (T.ufun2
                                                                                                                                    T.mkLambda
                                                                                                                                    T.mkNoSrcPos
                                                                                                                                    p
                                                                                                                                    (\ f_x
                                                                                                                                      f_y
                                                                                                                                      p ->
                                                                                                                                      T.uccase
                                                                                                                                        T.mkNoSrcPos
                                                                                                                                        p
                                                                                                                                        (let
                                                                                                                                          v0v0v0v0v1
                                                                                                                                            (T.R
                                                                                                                                              (T.Tuple2
                                                                                                                                                (T.R
                                                                                                                                                  (T.Cons
                                                                                                                                                    (T.R
                                                                                                                                                      ')'
                                                                                                                                                      _)
                                                                                                                                                    (T.R
                                                                                                                                                      T.List
                                                                                                                                                      _))
                                                                                                                                                  _)
                                                                                                                                                fw)
                                                                                                                                              _)
                                                                                                                                            p =
                                                                                                                                            T.uap1
                                                                                                                                              T.mkNoSrcPos
                                                                                                                                              p
                                                                                                                                              (T.pa1
                                                                                                                                                T.Cons
                                                                                                                                                T.cn1
                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                p
                                                                                                                                                T.aCons
                                                                                                                                                (T.con2
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p
                                                                                                                                                  T.Tuple2
                                                                                                                                                  T.aTuple2
                                                                                                                                                  (T.con4
                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                    p
                                                                                                                                                    T.Tuple4
                                                                                                                                                    T.aTuple4
                                                                                                                                                    (T.projection
                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                      p
                                                                                                                                                      fx1)
                                                                                                                                                    (T.projection
                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                      p
                                                                                                                                                      fx2)
                                                                                                                                                    (T.projection
                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                      p
                                                                                                                                                      fx3)
                                                                                                                                                    (T.projection
                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                      p
                                                                                                                                                      fx4))
                                                                                                                                                  fw))
                                                                                                                                              f_y
                                                                                                                                          v0v0v0v0v1
                                                                                                                                            _
                                                                                                                                            p =
                                                                                                                                            T.projection
                                                                                                                                              T.mkNoSrcPos
                                                                                                                                              p
                                                                                                                                              f_y
                                                                                                                                          in
                                                                                                                                          (v0v0v0v0v1))
                                                                                                                                        f_x))
                                                                                                                                  (T.uwrapForward
                                                                                                                                    p
                                                                                                                                    (hlex
                                                                                                                                      fr4
                                                                                                                                      p)))
                                                                                                                                f_y
                                                                                                                            v0v0v0v0v1
                                                                                                                              _
                                                                                                                              p =
                                                                                                                              T.projection
                                                                                                                                T.mkNoSrcPos
                                                                                                                                p
                                                                                                                                f_y
                                                                                                                            in
                                                                                                                            (v0v0v0v0v1))
                                                                                                                          f_x))
                                                                                                                    (T.uap1
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p
                                                                                                                      (greads
                                                                                                                        T.mkNoSrcPos
                                                                                                                        p)
                                                                                                                      fs4))
                                                                                                                  f_y
                                                                                                              v0v0v0v0v1
                                                                                                                _
                                                                                                                p =
                                                                                                                T.projection
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  f_y
                                                                                                              in
                                                                                                              (v0v0v0v0v1))
                                                                                                            f_x))
                                                                                                      (T.uwrapForward
                                                                                                        p
                                                                                                        (hlex
                                                                                                          fr3
                                                                                                          p)))
                                                                                                    f_y
                                                                                                v0v0v0v0v1
                                                                                                  _
                                                                                                  p =
                                                                                                  T.projection
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    f_y
                                                                                                in
                                                                                                (v0v0v0v0v1))
                                                                                              f_x))
                                                                                        (T.uap1
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (greads
                                                                                            T.mkNoSrcPos
                                                                                            p)
                                                                                          fs3))
                                                                                      f_y
                                                                                  v0v0v0v0v1
                                                                                    _
                                                                                    p =
                                                                                    T.projection
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      f_y
                                                                                  in
                                                                                  (v0v0v0v0v1))
                                                                                f_x))
                                                                          (T.uwrapForward
                                                                            p
                                                                            (hlex
                                                                              fr2
                                                                              p)))
                                                                        f_y
                                                                    v0v0v0v0v1 _
                                                                      p =
                                                                      T.projection
                                                                        T.mkNoSrcPos
                                                                        p f_y in
                                                                    (v0v0v0v0v1))
                                                                  f_x))
                                                            (T.uap1 T.mkNoSrcPos
                                                              p
                                                              (greads
                                                                T.mkNoSrcPos p)
                                                              fs2)) f_y
                                                      v0v0v0v0v1 _ p =
                                                        T.projection
                                                          T.mkNoSrcPos p f_y in
                                                      (v0v0v0v0v1)) f_x))
                                              (T.uwrapForward p (hlex fr1 p)))
                                            f_y
                                        v0v0v0v0v1 _ p =
                                          T.projection T.mkNoSrcPos p f_y in
                                        (v0v0v0v0v1)) f_x))
                                (T.uap1 T.mkNoSrcPos p (greads T.mkNoSrcPos p)
                                  fs1)) f_y
                          v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                          (v0v0v0v0v1)) f_x)) (T.uwrapForward p (hlex fr0 p)))
                (T.fromExpList T.mkNoSrcPos p []))) p)
    
  

instance (Read a,Read b,Read c,Read d,Read e) => Read ((T.Tuple5 a b c d e))
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a2033v5v2034v30readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p =
      T.uwrapForward p
        (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
          (T.ufun1 T.mkLambda T.mkNoSrcPos p
            (\ fr0 p ->
              T.uap1 T.mkNoSrcPos p
                (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                  (T.ufun2 T.mkLambda T.mkNoSrcPos p
                    (\ f_x f_y p ->
                      T.uccase T.mkNoSrcPos p
                        (let
                          v0v0v0v0v1
                            (T.R
                              (T.Tuple2
                                (T.R (T.Cons (T.R '(' _) (T.R T.List _)) _) fs1)
                              _) p =
                            T.uap1 T.mkNoSrcPos p
                              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                  (\ f_x f_y p ->
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v0v0v0v0v1 (T.R (T.Tuple2 fx1 fr1) _)
                                          p =
                                          T.uap1 T.mkNoSrcPos p
                                            (T.uap2 T.mkNoSrcPos p
                                              (g_foldr T.mkNoSrcPos p)
                                              (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                                (\ f_x f_y p ->
                                                  T.uccase T.mkNoSrcPos p
                                                    (let
                                                      v0v0v0v0v1
                                                        (T.R
                                                          (T.Tuple2
                                                            (T.R
                                                              (T.Cons
                                                                (T.R ',' _)
                                                                (T.R T.List _))
                                                              _) fs2) _) p =
                                                        T.uap1 T.mkNoSrcPos p
                                                          (T.uap2 T.mkNoSrcPos p
                                                            (g_foldr
                                                              T.mkNoSrcPos p)
                                                            (T.ufun2 T.mkLambda
                                                              T.mkNoSrcPos p
                                                              (\ f_x f_y p ->
                                                                T.uccase
                                                                  T.mkNoSrcPos p
                                                                  (let
                                                                    v0v0v0v0v1
                                                                      (T.R
                                                                        (T.Tuple2
                                                                          fx2
                                                                          fr2)
                                                                        _) p =
                                                                      T.uap1
                                                                        T.mkNoSrcPos
                                                                        p
                                                                        (T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (g_foldr
                                                                            T.mkNoSrcPos
                                                                            p)
                                                                          (T.ufun2
                                                                            T.mkLambda
                                                                            T.mkNoSrcPos
                                                                            p
                                                                            (\ f_x
                                                                              f_y
                                                                              p ->
                                                                              T.uccase
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (let
                                                                                  v0v0v0v0v1
                                                                                    (T.R
                                                                                      (T.Tuple2
                                                                                        (T.R
                                                                                          (T.Cons
                                                                                            (T.R
                                                                                              ','
                                                                                              _)
                                                                                            (T.R
                                                                                              T.List
                                                                                              _))
                                                                                          _)
                                                                                        fs3)
                                                                                      _)
                                                                                    p =
                                                                                    T.uap1
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      (T.uap2
                                                                                        T.mkNoSrcPos
                                                                                        p
                                                                                        (g_foldr
                                                                                          T.mkNoSrcPos
                                                                                          p)
                                                                                        (T.ufun2
                                                                                          T.mkLambda
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (\ f_x
                                                                                            f_y
                                                                                            p ->
                                                                                            T.uccase
                                                                                              T.mkNoSrcPos
                                                                                              p
                                                                                              (let
                                                                                                v0v0v0v0v1
                                                                                                  (T.R
                                                                                                    (T.Tuple2
                                                                                                      fx3
                                                                                                      fr3)
                                                                                                    _)
                                                                                                  p =
                                                                                                  T.uap1
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    (T.uap2
                                                                                                      T.mkNoSrcPos
                                                                                                      p
                                                                                                      (g_foldr
                                                                                                        T.mkNoSrcPos
                                                                                                        p)
                                                                                                      (T.ufun2
                                                                                                        T.mkLambda
                                                                                                        T.mkNoSrcPos
                                                                                                        p
                                                                                                        (\ f_x
                                                                                                          f_y
                                                                                                          p ->
                                                                                                          T.uccase
                                                                                                            T.mkNoSrcPos
                                                                                                            p
                                                                                                            (let
                                                                                                              v0v0v0v0v1
                                                                                                                (T.R
                                                                                                                  (T.Tuple2
                                                                                                                    (T.R
                                                                                                                      (T.Cons
                                                                                                                        (T.R
                                                                                                                          ','
                                                                                                                          _)
                                                                                                                        (T.R
                                                                                                                          T.List
                                                                                                                          _))
                                                                                                                      _)
                                                                                                                    fs4)
                                                                                                                  _)
                                                                                                                p =
                                                                                                                T.uap1
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  (T.uap2
                                                                                                                    T.mkNoSrcPos
                                                                                                                    p
                                                                                                                    (g_foldr
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p)
                                                                                                                    (T.ufun2
                                                                                                                      T.mkLambda
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p
                                                                                                                      (\ f_x
                                                                                                                        f_y
                                                                                                                        p ->
                                                                                                                        T.uccase
                                                                                                                          T.mkNoSrcPos
                                                                                                                          p
                                                                                                                          (let
                                                                                                                            v0v0v0v0v1
                                                                                                                              (T.R
                                                                                                                                (T.Tuple2
                                                                                                                                  fx4
                                                                                                                                  fr4)
                                                                                                                                _)
                                                                                                                              p =
                                                                                                                              T.uap1
                                                                                                                                T.mkNoSrcPos
                                                                                                                                p
                                                                                                                                (T.uap2
                                                                                                                                  T.mkNoSrcPos
                                                                                                                                  p
                                                                                                                                  (g_foldr
                                                                                                                                    T.mkNoSrcPos
                                                                                                                                    p)
                                                                                                                                  (T.ufun2
                                                                                                                                    T.mkLambda
                                                                                                                                    T.mkNoSrcPos
                                                                                                                                    p
                                                                                                                                    (\ f_x
                                                                                                                                      f_y
                                                                                                                                      p ->
                                                                                                                                      T.uccase
                                                                                                                                        T.mkNoSrcPos
                                                                                                                                        p
                                                                                                                                        (let
                                                                                                                                          v0v0v0v0v1
                                                                                                                                            (T.R
                                                                                                                                              (T.Tuple2
                                                                                                                                                (T.R
                                                                                                                                                  (T.Cons
                                                                                                                                                    (T.R
                                                                                                                                                      ','
                                                                                                                                                      _)
                                                                                                                                                    (T.R
                                                                                                                                                      T.List
                                                                                                                                                      _))
                                                                                                                                                  _)
                                                                                                                                                fs5)
                                                                                                                                              _)
                                                                                                                                            p =
                                                                                                                                            T.uap1
                                                                                                                                              T.mkNoSrcPos
                                                                                                                                              p
                                                                                                                                              (T.uap2
                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                p
                                                                                                                                                (g_foldr
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p)
                                                                                                                                                (T.ufun2
                                                                                                                                                  T.mkLambda
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p
                                                                                                                                                  (\ f_x
                                                                                                                                                    f_y
                                                                                                                                                    p ->
                                                                                                                                                    T.uccase
                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                      p
                                                                                                                                                      (let
                                                                                                                                                        v0v0v0v0v1
                                                                                                                                                          (T.R
                                                                                                                                                            (T.Tuple2
                                                                                                                                                              fx5
                                                                                                                                                              fr5)
                                                                                                                                                            _)
                                                                                                                                                          p =
                                                                                                                                                          T.uap1
                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                            p
                                                                                                                                                            (T.uap2
                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                              p
                                                                                                                                                              (g_foldr
                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                p)
                                                                                                                                                              (T.ufun2
                                                                                                                                                                T.mkLambda
                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                p
                                                                                                                                                                (\ f_x
                                                                                                                                                                  f_y
                                                                                                                                                                  p ->
                                                                                                                                                                  T.uccase
                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                    p
                                                                                                                                                                    (let
                                                                                                                                                                      v0v0v0v0v1
                                                                                                                                                                        (T.R
                                                                                                                                                                          (T.Tuple2
                                                                                                                                                                            (T.R
                                                                                                                                                                              (T.Cons
                                                                                                                                                                                (T.R
                                                                                                                                                                                  ')'
                                                                                                                                                                                  _)
                                                                                                                                                                                (T.R
                                                                                                                                                                                  T.List
                                                                                                                                                                                  _))
                                                                                                                                                                              _)
                                                                                                                                                                            fw)
                                                                                                                                                                          _)
                                                                                                                                                                        p =
                                                                                                                                                                        T.uap1
                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                          p
                                                                                                                                                                          (T.pa1
                                                                                                                                                                            T.Cons
                                                                                                                                                                            T.cn1
                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                            p
                                                                                                                                                                            T.aCons
                                                                                                                                                                            (T.con2
                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                              p
                                                                                                                                                                              T.Tuple2
                                                                                                                                                                              T.aTuple2
                                                                                                                                                                              (T.con5
                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                p
                                                                                                                                                                                T.Tuple5
                                                                                                                                                                                T.aTuple5
                                                                                                                                                                                (T.projection
                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                  p
                                                                                                                                                                                  fx1)
                                                                                                                                                                                (T.projection
                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                  p
                                                                                                                                                                                  fx2)
                                                                                                                                                                                (T.projection
                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                  p
                                                                                                                                                                                  fx3)
                                                                                                                                                                                (T.projection
                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                  p
                                                                                                                                                                                  fx4)
                                                                                                                                                                                (T.projection
                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                  p
                                                                                                                                                                                  fx5))
                                                                                                                                                                              fw))
                                                                                                                                                                          f_y
                                                                                                                                                                      v0v0v0v0v1
                                                                                                                                                                        _
                                                                                                                                                                        p =
                                                                                                                                                                        T.projection
                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                          p
                                                                                                                                                                          f_y
                                                                                                                                                                      in
                                                                                                                                                                      (v0v0v0v0v1))
                                                                                                                                                                    f_x))
                                                                                                                                                              (T.uwrapForward
                                                                                                                                                                p
                                                                                                                                                                (hlex
                                                                                                                                                                  fr5
                                                                                                                                                                  p)))
                                                                                                                                                            f_y
                                                                                                                                                        v0v0v0v0v1
                                                                                                                                                          _
                                                                                                                                                          p =
                                                                                                                                                          T.projection
                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                            p
                                                                                                                                                            f_y
                                                                                                                                                        in
                                                                                                                                                        (v0v0v0v0v1))
                                                                                                                                                      f_x))
                                                                                                                                                (T.uap1
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p
                                                                                                                                                  (greads
                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                    p)
                                                                                                                                                  fs5))
                                                                                                                                              f_y
                                                                                                                                          v0v0v0v0v1
                                                                                                                                            _
                                                                                                                                            p =
                                                                                                                                            T.projection
                                                                                                                                              T.mkNoSrcPos
                                                                                                                                              p
                                                                                                                                              f_y
                                                                                                                                          in
                                                                                                                                          (v0v0v0v0v1))
                                                                                                                                        f_x))
                                                                                                                                  (T.uwrapForward
                                                                                                                                    p
                                                                                                                                    (hlex
                                                                                                                                      fr4
                                                                                                                                      p)))
                                                                                                                                f_y
                                                                                                                            v0v0v0v0v1
                                                                                                                              _
                                                                                                                              p =
                                                                                                                              T.projection
                                                                                                                                T.mkNoSrcPos
                                                                                                                                p
                                                                                                                                f_y
                                                                                                                            in
                                                                                                                            (v0v0v0v0v1))
                                                                                                                          f_x))
                                                                                                                    (T.uap1
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p
                                                                                                                      (greads
                                                                                                                        T.mkNoSrcPos
                                                                                                                        p)
                                                                                                                      fs4))
                                                                                                                  f_y
                                                                                                              v0v0v0v0v1
                                                                                                                _
                                                                                                                p =
                                                                                                                T.projection
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  f_y
                                                                                                              in
                                                                                                              (v0v0v0v0v1))
                                                                                                            f_x))
                                                                                                      (T.uwrapForward
                                                                                                        p
                                                                                                        (hlex
                                                                                                          fr3
                                                                                                          p)))
                                                                                                    f_y
                                                                                                v0v0v0v0v1
                                                                                                  _
                                                                                                  p =
                                                                                                  T.projection
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    f_y
                                                                                                in
                                                                                                (v0v0v0v0v1))
                                                                                              f_x))
                                                                                        (T.uap1
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (greads
                                                                                            T.mkNoSrcPos
                                                                                            p)
                                                                                          fs3))
                                                                                      f_y
                                                                                  v0v0v0v0v1
                                                                                    _
                                                                                    p =
                                                                                    T.projection
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      f_y
                                                                                  in
                                                                                  (v0v0v0v0v1))
                                                                                f_x))
                                                                          (T.uwrapForward
                                                                            p
                                                                            (hlex
                                                                              fr2
                                                                              p)))
                                                                        f_y
                                                                    v0v0v0v0v1 _
                                                                      p =
                                                                      T.projection
                                                                        T.mkNoSrcPos
                                                                        p f_y in
                                                                    (v0v0v0v0v1))
                                                                  f_x))
                                                            (T.uap1 T.mkNoSrcPos
                                                              p
                                                              (greads
                                                                T.mkNoSrcPos p)
                                                              fs2)) f_y
                                                      v0v0v0v0v1 _ p =
                                                        T.projection
                                                          T.mkNoSrcPos p f_y in
                                                      (v0v0v0v0v1)) f_x))
                                              (T.uwrapForward p (hlex fr1 p)))
                                            f_y
                                        v0v0v0v0v1 _ p =
                                          T.projection T.mkNoSrcPos p f_y in
                                        (v0v0v0v0v1)) f_x))
                                (T.uap1 T.mkNoSrcPos p (greads T.mkNoSrcPos p)
                                  fs1)) f_y
                          v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                          (v0v0v0v0v1)) f_x)) (T.uwrapForward p (hlex fr0 p)))
                (T.fromExpList T.mkNoSrcPos p []))) p)
    
  

instance
  (Read a,Read b,Read c,Read d,Read e,Read f) => Read ((T.Tuple6 a b c d e f))
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a2049v5v2050v30readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p =
      T.uwrapForward p
        (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
          (T.ufun1 T.mkLambda T.mkNoSrcPos p
            (\ fr0 p ->
              T.uap1 T.mkNoSrcPos p
                (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                  (T.ufun2 T.mkLambda T.mkNoSrcPos p
                    (\ f_x f_y p ->
                      T.uccase T.mkNoSrcPos p
                        (let
                          v0v0v0v0v1
                            (T.R
                              (T.Tuple2
                                (T.R (T.Cons (T.R '(' _) (T.R T.List _)) _) fs1)
                              _) p =
                            T.uap1 T.mkNoSrcPos p
                              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                  (\ f_x f_y p ->
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v0v0v0v0v1 (T.R (T.Tuple2 fx1 fr1) _)
                                          p =
                                          T.uap1 T.mkNoSrcPos p
                                            (T.uap2 T.mkNoSrcPos p
                                              (g_foldr T.mkNoSrcPos p)
                                              (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                                (\ f_x f_y p ->
                                                  T.uccase T.mkNoSrcPos p
                                                    (let
                                                      v0v0v0v0v1
                                                        (T.R
                                                          (T.Tuple2
                                                            (T.R
                                                              (T.Cons
                                                                (T.R ',' _)
                                                                (T.R T.List _))
                                                              _) fs2) _) p =
                                                        T.uap1 T.mkNoSrcPos p
                                                          (T.uap2 T.mkNoSrcPos p
                                                            (g_foldr
                                                              T.mkNoSrcPos p)
                                                            (T.ufun2 T.mkLambda
                                                              T.mkNoSrcPos p
                                                              (\ f_x f_y p ->
                                                                T.uccase
                                                                  T.mkNoSrcPos p
                                                                  (let
                                                                    v0v0v0v0v1
                                                                      (T.R
                                                                        (T.Tuple2
                                                                          fx2
                                                                          fr2)
                                                                        _) p =
                                                                      T.uap1
                                                                        T.mkNoSrcPos
                                                                        p
                                                                        (T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (g_foldr
                                                                            T.mkNoSrcPos
                                                                            p)
                                                                          (T.ufun2
                                                                            T.mkLambda
                                                                            T.mkNoSrcPos
                                                                            p
                                                                            (\ f_x
                                                                              f_y
                                                                              p ->
                                                                              T.uccase
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (let
                                                                                  v0v0v0v0v1
                                                                                    (T.R
                                                                                      (T.Tuple2
                                                                                        (T.R
                                                                                          (T.Cons
                                                                                            (T.R
                                                                                              ','
                                                                                              _)
                                                                                            (T.R
                                                                                              T.List
                                                                                              _))
                                                                                          _)
                                                                                        fs3)
                                                                                      _)
                                                                                    p =
                                                                                    T.uap1
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      (T.uap2
                                                                                        T.mkNoSrcPos
                                                                                        p
                                                                                        (g_foldr
                                                                                          T.mkNoSrcPos
                                                                                          p)
                                                                                        (T.ufun2
                                                                                          T.mkLambda
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (\ f_x
                                                                                            f_y
                                                                                            p ->
                                                                                            T.uccase
                                                                                              T.mkNoSrcPos
                                                                                              p
                                                                                              (let
                                                                                                v0v0v0v0v1
                                                                                                  (T.R
                                                                                                    (T.Tuple2
                                                                                                      fx3
                                                                                                      fr3)
                                                                                                    _)
                                                                                                  p =
                                                                                                  T.uap1
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    (T.uap2
                                                                                                      T.mkNoSrcPos
                                                                                                      p
                                                                                                      (g_foldr
                                                                                                        T.mkNoSrcPos
                                                                                                        p)
                                                                                                      (T.ufun2
                                                                                                        T.mkLambda
                                                                                                        T.mkNoSrcPos
                                                                                                        p
                                                                                                        (\ f_x
                                                                                                          f_y
                                                                                                          p ->
                                                                                                          T.uccase
                                                                                                            T.mkNoSrcPos
                                                                                                            p
                                                                                                            (let
                                                                                                              v0v0v0v0v1
                                                                                                                (T.R
                                                                                                                  (T.Tuple2
                                                                                                                    (T.R
                                                                                                                      (T.Cons
                                                                                                                        (T.R
                                                                                                                          ','
                                                                                                                          _)
                                                                                                                        (T.R
                                                                                                                          T.List
                                                                                                                          _))
                                                                                                                      _)
                                                                                                                    fs4)
                                                                                                                  _)
                                                                                                                p =
                                                                                                                T.uap1
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  (T.uap2
                                                                                                                    T.mkNoSrcPos
                                                                                                                    p
                                                                                                                    (g_foldr
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p)
                                                                                                                    (T.ufun2
                                                                                                                      T.mkLambda
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p
                                                                                                                      (\ f_x
                                                                                                                        f_y
                                                                                                                        p ->
                                                                                                                        T.uccase
                                                                                                                          T.mkNoSrcPos
                                                                                                                          p
                                                                                                                          (let
                                                                                                                            v0v0v0v0v1
                                                                                                                              (T.R
                                                                                                                                (T.Tuple2
                                                                                                                                  fx4
                                                                                                                                  fr4)
                                                                                                                                _)
                                                                                                                              p =
                                                                                                                              T.uap1
                                                                                                                                T.mkNoSrcPos
                                                                                                                                p
                                                                                                                                (T.uap2
                                                                                                                                  T.mkNoSrcPos
                                                                                                                                  p
                                                                                                                                  (g_foldr
                                                                                                                                    T.mkNoSrcPos
                                                                                                                                    p)
                                                                                                                                  (T.ufun2
                                                                                                                                    T.mkLambda
                                                                                                                                    T.mkNoSrcPos
                                                                                                                                    p
                                                                                                                                    (\ f_x
                                                                                                                                      f_y
                                                                                                                                      p ->
                                                                                                                                      T.uccase
                                                                                                                                        T.mkNoSrcPos
                                                                                                                                        p
                                                                                                                                        (let
                                                                                                                                          v0v0v0v0v1
                                                                                                                                            (T.R
                                                                                                                                              (T.Tuple2
                                                                                                                                                (T.R
                                                                                                                                                  (T.Cons
                                                                                                                                                    (T.R
                                                                                                                                                      ','
                                                                                                                                                      _)
                                                                                                                                                    (T.R
                                                                                                                                                      T.List
                                                                                                                                                      _))
                                                                                                                                                  _)
                                                                                                                                                fs5)
                                                                                                                                              _)
                                                                                                                                            p =
                                                                                                                                            T.uap1
                                                                                                                                              T.mkNoSrcPos
                                                                                                                                              p
                                                                                                                                              (T.uap2
                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                p
                                                                                                                                                (g_foldr
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p)
                                                                                                                                                (T.ufun2
                                                                                                                                                  T.mkLambda
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p
                                                                                                                                                  (\ f_x
                                                                                                                                                    f_y
                                                                                                                                                    p ->
                                                                                                                                                    T.uccase
                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                      p
                                                                                                                                                      (let
                                                                                                                                                        v0v0v0v0v1
                                                                                                                                                          (T.R
                                                                                                                                                            (T.Tuple2
                                                                                                                                                              fx5
                                                                                                                                                              fr5)
                                                                                                                                                            _)
                                                                                                                                                          p =
                                                                                                                                                          T.uap1
                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                            p
                                                                                                                                                            (T.uap2
                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                              p
                                                                                                                                                              (g_foldr
                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                p)
                                                                                                                                                              (T.ufun2
                                                                                                                                                                T.mkLambda
                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                p
                                                                                                                                                                (\ f_x
                                                                                                                                                                  f_y
                                                                                                                                                                  p ->
                                                                                                                                                                  T.uccase
                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                    p
                                                                                                                                                                    (let
                                                                                                                                                                      v0v0v0v0v1
                                                                                                                                                                        (T.R
                                                                                                                                                                          (T.Tuple2
                                                                                                                                                                            (T.R
                                                                                                                                                                              (T.Cons
                                                                                                                                                                                (T.R
                                                                                                                                                                                  ','
                                                                                                                                                                                  _)
                                                                                                                                                                                (T.R
                                                                                                                                                                                  T.List
                                                                                                                                                                                  _))
                                                                                                                                                                              _)
                                                                                                                                                                            fs6)
                                                                                                                                                                          _)
                                                                                                                                                                        p =
                                                                                                                                                                        T.uap1
                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                          p
                                                                                                                                                                          (T.uap2
                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                            p
                                                                                                                                                                            (g_foldr
                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                              p)
                                                                                                                                                                            (T.ufun2
                                                                                                                                                                              T.mkLambda
                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                              p
                                                                                                                                                                              (\ f_x
                                                                                                                                                                                f_y
                                                                                                                                                                                p ->
                                                                                                                                                                                T.uccase
                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                  p
                                                                                                                                                                                  (let
                                                                                                                                                                                    v0v0v0v0v1
                                                                                                                                                                                      (T.R
                                                                                                                                                                                        (T.Tuple2
                                                                                                                                                                                          fx6
                                                                                                                                                                                          fr6)
                                                                                                                                                                                        _)
                                                                                                                                                                                      p =
                                                                                                                                                                                      T.uap1
                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                        p
                                                                                                                                                                                        (T.uap2
                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                          p
                                                                                                                                                                                          (g_foldr
                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                            p)
                                                                                                                                                                                          (T.ufun2
                                                                                                                                                                                            T.mkLambda
                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                            p
                                                                                                                                                                                            (\ f_x
                                                                                                                                                                                              f_y
                                                                                                                                                                                              p ->
                                                                                                                                                                                              T.uccase
                                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                                p
                                                                                                                                                                                                (let
                                                                                                                                                                                                  v0v0v0v0v1
                                                                                                                                                                                                    (T.R
                                                                                                                                                                                                      (T.Tuple2
                                                                                                                                                                                                        (T.R
                                                                                                                                                                                                          (T.Cons
                                                                                                                                                                                                            (T.R
                                                                                                                                                                                                              ')'
                                                                                                                                                                                                              _)
                                                                                                                                                                                                            (T.R
                                                                                                                                                                                                              T.List
                                                                                                                                                                                                              _))
                                                                                                                                                                                                          _)
                                                                                                                                                                                                        fw)
                                                                                                                                                                                                      _)
                                                                                                                                                                                                    p =
                                                                                                                                                                                                    T.uap1
                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                      p
                                                                                                                                                                                                      (T.pa1
                                                                                                                                                                                                        T.Cons
                                                                                                                                                                                                        T.cn1
                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                        p
                                                                                                                                                                                                        T.aCons
                                                                                                                                                                                                        (T.con2
                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                          p
                                                                                                                                                                                                          T.Tuple2
                                                                                                                                                                                                          T.aTuple2
                                                                                                                                                                                                          (T.con6
                                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                                            p
                                                                                                                                                                                                            T.Tuple6
                                                                                                                                                                                                            T.aTuple6
                                                                                                                                                                                                            (T.projection
                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                              p
                                                                                                                                                                                                              fx1)
                                                                                                                                                                                                            (T.projection
                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                              p
                                                                                                                                                                                                              fx2)
                                                                                                                                                                                                            (T.projection
                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                              p
                                                                                                                                                                                                              fx3)
                                                                                                                                                                                                            (T.projection
                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                              p
                                                                                                                                                                                                              fx4)
                                                                                                                                                                                                            (T.projection
                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                              p
                                                                                                                                                                                                              fx5)
                                                                                                                                                                                                            (T.projection
                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                              p
                                                                                                                                                                                                              fx6))
                                                                                                                                                                                                          fw))
                                                                                                                                                                                                      f_y
                                                                                                                                                                                                  v0v0v0v0v1
                                                                                                                                                                                                    _
                                                                                                                                                                                                    p =
                                                                                                                                                                                                    T.projection
                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                      p
                                                                                                                                                                                                      f_y
                                                                                                                                                                                                  in
                                                                                                                                                                                                  (v0v0v0v0v1))
                                                                                                                                                                                                f_x))
                                                                                                                                                                                          (T.uwrapForward
                                                                                                                                                                                            p
                                                                                                                                                                                            (hlex
                                                                                                                                                                                              fr6
                                                                                                                                                                                              p)))
                                                                                                                                                                                        f_y
                                                                                                                                                                                    v0v0v0v0v1
                                                                                                                                                                                      _
                                                                                                                                                                                      p =
                                                                                                                                                                                      T.projection
                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                        p
                                                                                                                                                                                        f_y
                                                                                                                                                                                    in
                                                                                                                                                                                    (v0v0v0v0v1))
                                                                                                                                                                                  f_x))
                                                                                                                                                                            (T.uap1
                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                              p
                                                                                                                                                                              (greads
                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                p)
                                                                                                                                                                              fs6))
                                                                                                                                                                          f_y
                                                                                                                                                                      v0v0v0v0v1
                                                                                                                                                                        _
                                                                                                                                                                        p =
                                                                                                                                                                        T.projection
                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                          p
                                                                                                                                                                          f_y
                                                                                                                                                                      in
                                                                                                                                                                      (v0v0v0v0v1))
                                                                                                                                                                    f_x))
                                                                                                                                                              (T.uwrapForward
                                                                                                                                                                p
                                                                                                                                                                (hlex
                                                                                                                                                                  fr5
                                                                                                                                                                  p)))
                                                                                                                                                            f_y
                                                                                                                                                        v0v0v0v0v1
                                                                                                                                                          _
                                                                                                                                                          p =
                                                                                                                                                          T.projection
                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                            p
                                                                                                                                                            f_y
                                                                                                                                                        in
                                                                                                                                                        (v0v0v0v0v1))
                                                                                                                                                      f_x))
                                                                                                                                                (T.uap1
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p
                                                                                                                                                  (greads
                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                    p)
                                                                                                                                                  fs5))
                                                                                                                                              f_y
                                                                                                                                          v0v0v0v0v1
                                                                                                                                            _
                                                                                                                                            p =
                                                                                                                                            T.projection
                                                                                                                                              T.mkNoSrcPos
                                                                                                                                              p
                                                                                                                                              f_y
                                                                                                                                          in
                                                                                                                                          (v0v0v0v0v1))
                                                                                                                                        f_x))
                                                                                                                                  (T.uwrapForward
                                                                                                                                    p
                                                                                                                                    (hlex
                                                                                                                                      fr4
                                                                                                                                      p)))
                                                                                                                                f_y
                                                                                                                            v0v0v0v0v1
                                                                                                                              _
                                                                                                                              p =
                                                                                                                              T.projection
                                                                                                                                T.mkNoSrcPos
                                                                                                                                p
                                                                                                                                f_y
                                                                                                                            in
                                                                                                                            (v0v0v0v0v1))
                                                                                                                          f_x))
                                                                                                                    (T.uap1
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p
                                                                                                                      (greads
                                                                                                                        T.mkNoSrcPos
                                                                                                                        p)
                                                                                                                      fs4))
                                                                                                                  f_y
                                                                                                              v0v0v0v0v1
                                                                                                                _
                                                                                                                p =
                                                                                                                T.projection
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  f_y
                                                                                                              in
                                                                                                              (v0v0v0v0v1))
                                                                                                            f_x))
                                                                                                      (T.uwrapForward
                                                                                                        p
                                                                                                        (hlex
                                                                                                          fr3
                                                                                                          p)))
                                                                                                    f_y
                                                                                                v0v0v0v0v1
                                                                                                  _
                                                                                                  p =
                                                                                                  T.projection
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    f_y
                                                                                                in
                                                                                                (v0v0v0v0v1))
                                                                                              f_x))
                                                                                        (T.uap1
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (greads
                                                                                            T.mkNoSrcPos
                                                                                            p)
                                                                                          fs3))
                                                                                      f_y
                                                                                  v0v0v0v0v1
                                                                                    _
                                                                                    p =
                                                                                    T.projection
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      f_y
                                                                                  in
                                                                                  (v0v0v0v0v1))
                                                                                f_x))
                                                                          (T.uwrapForward
                                                                            p
                                                                            (hlex
                                                                              fr2
                                                                              p)))
                                                                        f_y
                                                                    v0v0v0v0v1 _
                                                                      p =
                                                                      T.projection
                                                                        T.mkNoSrcPos
                                                                        p f_y in
                                                                    (v0v0v0v0v1))
                                                                  f_x))
                                                            (T.uap1 T.mkNoSrcPos
                                                              p
                                                              (greads
                                                                T.mkNoSrcPos p)
                                                              fs2)) f_y
                                                      v0v0v0v0v1 _ p =
                                                        T.projection
                                                          T.mkNoSrcPos p f_y in
                                                      (v0v0v0v0v1)) f_x))
                                              (T.uwrapForward p (hlex fr1 p)))
                                            f_y
                                        v0v0v0v0v1 _ p =
                                          T.projection T.mkNoSrcPos p f_y in
                                        (v0v0v0v0v1)) f_x))
                                (T.uap1 T.mkNoSrcPos p (greads T.mkNoSrcPos p)
                                  fs1)) f_y
                          v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                          (v0v0v0v0v1)) f_x)) (T.uwrapForward p (hlex fr0 p)))
                (T.fromExpList T.mkNoSrcPos p []))) p)
    
  

instance
  (Read a,Read b,Read c,Read d,Read e,Read f,Read g) =>
    Read ((T.Tuple7 a b c d e f g))
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a2067v5v2068v30readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p =
      T.uwrapForward p
        (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
          (T.ufun1 T.mkLambda T.mkNoSrcPos p
            (\ fr0 p ->
              T.uap1 T.mkNoSrcPos p
                (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                  (T.ufun2 T.mkLambda T.mkNoSrcPos p
                    (\ f_x f_y p ->
                      T.uccase T.mkNoSrcPos p
                        (let
                          v0v0v0v0v1
                            (T.R
                              (T.Tuple2
                                (T.R (T.Cons (T.R '(' _) (T.R T.List _)) _) fs1)
                              _) p =
                            T.uap1 T.mkNoSrcPos p
                              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                  (\ f_x f_y p ->
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v0v0v0v0v1 (T.R (T.Tuple2 fx1 fr1) _)
                                          p =
                                          T.uap1 T.mkNoSrcPos p
                                            (T.uap2 T.mkNoSrcPos p
                                              (g_foldr T.mkNoSrcPos p)
                                              (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                                (\ f_x f_y p ->
                                                  T.uccase T.mkNoSrcPos p
                                                    (let
                                                      v0v0v0v0v1
                                                        (T.R
                                                          (T.Tuple2
                                                            (T.R
                                                              (T.Cons
                                                                (T.R ',' _)
                                                                (T.R T.List _))
                                                              _) fs2) _) p =
                                                        T.uap1 T.mkNoSrcPos p
                                                          (T.uap2 T.mkNoSrcPos p
                                                            (g_foldr
                                                              T.mkNoSrcPos p)
                                                            (T.ufun2 T.mkLambda
                                                              T.mkNoSrcPos p
                                                              (\ f_x f_y p ->
                                                                T.uccase
                                                                  T.mkNoSrcPos p
                                                                  (let
                                                                    v0v0v0v0v1
                                                                      (T.R
                                                                        (T.Tuple2
                                                                          fx2
                                                                          fr2)
                                                                        _) p =
                                                                      T.uap1
                                                                        T.mkNoSrcPos
                                                                        p
                                                                        (T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (g_foldr
                                                                            T.mkNoSrcPos
                                                                            p)
                                                                          (T.ufun2
                                                                            T.mkLambda
                                                                            T.mkNoSrcPos
                                                                            p
                                                                            (\ f_x
                                                                              f_y
                                                                              p ->
                                                                              T.uccase
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (let
                                                                                  v0v0v0v0v1
                                                                                    (T.R
                                                                                      (T.Tuple2
                                                                                        (T.R
                                                                                          (T.Cons
                                                                                            (T.R
                                                                                              ','
                                                                                              _)
                                                                                            (T.R
                                                                                              T.List
                                                                                              _))
                                                                                          _)
                                                                                        fs3)
                                                                                      _)
                                                                                    p =
                                                                                    T.uap1
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      (T.uap2
                                                                                        T.mkNoSrcPos
                                                                                        p
                                                                                        (g_foldr
                                                                                          T.mkNoSrcPos
                                                                                          p)
                                                                                        (T.ufun2
                                                                                          T.mkLambda
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (\ f_x
                                                                                            f_y
                                                                                            p ->
                                                                                            T.uccase
                                                                                              T.mkNoSrcPos
                                                                                              p
                                                                                              (let
                                                                                                v0v0v0v0v1
                                                                                                  (T.R
                                                                                                    (T.Tuple2
                                                                                                      fx3
                                                                                                      fr3)
                                                                                                    _)
                                                                                                  p =
                                                                                                  T.uap1
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    (T.uap2
                                                                                                      T.mkNoSrcPos
                                                                                                      p
                                                                                                      (g_foldr
                                                                                                        T.mkNoSrcPos
                                                                                                        p)
                                                                                                      (T.ufun2
                                                                                                        T.mkLambda
                                                                                                        T.mkNoSrcPos
                                                                                                        p
                                                                                                        (\ f_x
                                                                                                          f_y
                                                                                                          p ->
                                                                                                          T.uccase
                                                                                                            T.mkNoSrcPos
                                                                                                            p
                                                                                                            (let
                                                                                                              v0v0v0v0v1
                                                                                                                (T.R
                                                                                                                  (T.Tuple2
                                                                                                                    (T.R
                                                                                                                      (T.Cons
                                                                                                                        (T.R
                                                                                                                          ','
                                                                                                                          _)
                                                                                                                        (T.R
                                                                                                                          T.List
                                                                                                                          _))
                                                                                                                      _)
                                                                                                                    fs4)
                                                                                                                  _)
                                                                                                                p =
                                                                                                                T.uap1
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  (T.uap2
                                                                                                                    T.mkNoSrcPos
                                                                                                                    p
                                                                                                                    (g_foldr
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p)
                                                                                                                    (T.ufun2
                                                                                                                      T.mkLambda
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p
                                                                                                                      (\ f_x
                                                                                                                        f_y
                                                                                                                        p ->
                                                                                                                        T.uccase
                                                                                                                          T.mkNoSrcPos
                                                                                                                          p
                                                                                                                          (let
                                                                                                                            v0v0v0v0v1
                                                                                                                              (T.R
                                                                                                                                (T.Tuple2
                                                                                                                                  fx4
                                                                                                                                  fr4)
                                                                                                                                _)
                                                                                                                              p =
                                                                                                                              T.uap1
                                                                                                                                T.mkNoSrcPos
                                                                                                                                p
                                                                                                                                (T.uap2
                                                                                                                                  T.mkNoSrcPos
                                                                                                                                  p
                                                                                                                                  (g_foldr
                                                                                                                                    T.mkNoSrcPos
                                                                                                                                    p)
                                                                                                                                  (T.ufun2
                                                                                                                                    T.mkLambda
                                                                                                                                    T.mkNoSrcPos
                                                                                                                                    p
                                                                                                                                    (\ f_x
                                                                                                                                      f_y
                                                                                                                                      p ->
                                                                                                                                      T.uccase
                                                                                                                                        T.mkNoSrcPos
                                                                                                                                        p
                                                                                                                                        (let
                                                                                                                                          v0v0v0v0v1
                                                                                                                                            (T.R
                                                                                                                                              (T.Tuple2
                                                                                                                                                (T.R
                                                                                                                                                  (T.Cons
                                                                                                                                                    (T.R
                                                                                                                                                      ','
                                                                                                                                                      _)
                                                                                                                                                    (T.R
                                                                                                                                                      T.List
                                                                                                                                                      _))
                                                                                                                                                  _)
                                                                                                                                                fs5)
                                                                                                                                              _)
                                                                                                                                            p =
                                                                                                                                            T.uap1
                                                                                                                                              T.mkNoSrcPos
                                                                                                                                              p
                                                                                                                                              (T.uap2
                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                p
                                                                                                                                                (g_foldr
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p)
                                                                                                                                                (T.ufun2
                                                                                                                                                  T.mkLambda
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p
                                                                                                                                                  (\ f_x
                                                                                                                                                    f_y
                                                                                                                                                    p ->
                                                                                                                                                    T.uccase
                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                      p
                                                                                                                                                      (let
                                                                                                                                                        v0v0v0v0v1
                                                                                                                                                          (T.R
                                                                                                                                                            (T.Tuple2
                                                                                                                                                              fx5
                                                                                                                                                              fr5)
                                                                                                                                                            _)
                                                                                                                                                          p =
                                                                                                                                                          T.uap1
                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                            p
                                                                                                                                                            (T.uap2
                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                              p
                                                                                                                                                              (g_foldr
                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                p)
                                                                                                                                                              (T.ufun2
                                                                                                                                                                T.mkLambda
                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                p
                                                                                                                                                                (\ f_x
                                                                                                                                                                  f_y
                                                                                                                                                                  p ->
                                                                                                                                                                  T.uccase
                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                    p
                                                                                                                                                                    (let
                                                                                                                                                                      v0v0v0v0v1
                                                                                                                                                                        (T.R
                                                                                                                                                                          (T.Tuple2
                                                                                                                                                                            (T.R
                                                                                                                                                                              (T.Cons
                                                                                                                                                                                (T.R
                                                                                                                                                                                  ','
                                                                                                                                                                                  _)
                                                                                                                                                                                (T.R
                                                                                                                                                                                  T.List
                                                                                                                                                                                  _))
                                                                                                                                                                              _)
                                                                                                                                                                            fs6)
                                                                                                                                                                          _)
                                                                                                                                                                        p =
                                                                                                                                                                        T.uap1
                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                          p
                                                                                                                                                                          (T.uap2
                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                            p
                                                                                                                                                                            (g_foldr
                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                              p)
                                                                                                                                                                            (T.ufun2
                                                                                                                                                                              T.mkLambda
                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                              p
                                                                                                                                                                              (\ f_x
                                                                                                                                                                                f_y
                                                                                                                                                                                p ->
                                                                                                                                                                                T.uccase
                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                  p
                                                                                                                                                                                  (let
                                                                                                                                                                                    v0v0v0v0v1
                                                                                                                                                                                      (T.R
                                                                                                                                                                                        (T.Tuple2
                                                                                                                                                                                          fx6
                                                                                                                                                                                          fr6)
                                                                                                                                                                                        _)
                                                                                                                                                                                      p =
                                                                                                                                                                                      T.uap1
                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                        p
                                                                                                                                                                                        (T.uap2
                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                          p
                                                                                                                                                                                          (g_foldr
                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                            p)
                                                                                                                                                                                          (T.ufun2
                                                                                                                                                                                            T.mkLambda
                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                            p
                                                                                                                                                                                            (\ f_x
                                                                                                                                                                                              f_y
                                                                                                                                                                                              p ->
                                                                                                                                                                                              T.uccase
                                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                                p
                                                                                                                                                                                                (let
                                                                                                                                                                                                  v0v0v0v0v1
                                                                                                                                                                                                    (T.R
                                                                                                                                                                                                      (T.Tuple2
                                                                                                                                                                                                        (T.R
                                                                                                                                                                                                          (T.Cons
                                                                                                                                                                                                            (T.R
                                                                                                                                                                                                              ','
                                                                                                                                                                                                              _)
                                                                                                                                                                                                            (T.R
                                                                                                                                                                                                              T.List
                                                                                                                                                                                                              _))
                                                                                                                                                                                                          _)
                                                                                                                                                                                                        fs7)
                                                                                                                                                                                                      _)
                                                                                                                                                                                                    p =
                                                                                                                                                                                                    T.uap1
                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                      p
                                                                                                                                                                                                      (T.uap2
                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                        p
                                                                                                                                                                                                        (g_foldr
                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                          p)
                                                                                                                                                                                                        (T.ufun2
                                                                                                                                                                                                          T.mkLambda
                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                          p
                                                                                                                                                                                                          (\ f_x
                                                                                                                                                                                                            f_y
                                                                                                                                                                                                            p ->
                                                                                                                                                                                                            T.uccase
                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                              p
                                                                                                                                                                                                              (let
                                                                                                                                                                                                                v0v0v0v0v1
                                                                                                                                                                                                                  (T.R
                                                                                                                                                                                                                    (T.Tuple2
                                                                                                                                                                                                                      fx7
                                                                                                                                                                                                                      fr7)
                                                                                                                                                                                                                    _)
                                                                                                                                                                                                                  p =
                                                                                                                                                                                                                  T.uap1
                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                    p
                                                                                                                                                                                                                    (T.uap2
                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                      p
                                                                                                                                                                                                                      (g_foldr
                                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                                        p)
                                                                                                                                                                                                                      (T.ufun2
                                                                                                                                                                                                                        T.mkLambda
                                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                                        p
                                                                                                                                                                                                                        (\ f_x
                                                                                                                                                                                                                          f_y
                                                                                                                                                                                                                          p ->
                                                                                                                                                                                                                          T.uccase
                                                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                                                            p
                                                                                                                                                                                                                            (let
                                                                                                                                                                                                                              v0v0v0v0v1
                                                                                                                                                                                                                                (T.R
                                                                                                                                                                                                                                  (T.Tuple2
                                                                                                                                                                                                                                    (T.R
                                                                                                                                                                                                                                      (T.Cons
                                                                                                                                                                                                                                        (T.R
                                                                                                                                                                                                                                          ')'
                                                                                                                                                                                                                                          _)
                                                                                                                                                                                                                                        (T.R
                                                                                                                                                                                                                                          T.List
                                                                                                                                                                                                                                          _))
                                                                                                                                                                                                                                      _)
                                                                                                                                                                                                                                    fw)
                                                                                                                                                                                                                                  _)
                                                                                                                                                                                                                                p =
                                                                                                                                                                                                                                T.uap1
                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                  (T.pa1
                                                                                                                                                                                                                                    T.Cons
                                                                                                                                                                                                                                    T.cn1
                                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                                    p
                                                                                                                                                                                                                                    T.aCons
                                                                                                                                                                                                                                    (T.con2
                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                      p
                                                                                                                                                                                                                                      T.Tuple2
                                                                                                                                                                                                                                      T.aTuple2
                                                                                                                                                                                                                                      (T.con7
                                                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                                                        p
                                                                                                                                                                                                                                        T.Tuple7
                                                                                                                                                                                                                                        T.aTuple7
                                                                                                                                                                                                                                        (T.projection
                                                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                                                          p
                                                                                                                                                                                                                                          fx1)
                                                                                                                                                                                                                                        (T.projection
                                                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                                                          p
                                                                                                                                                                                                                                          fx2)
                                                                                                                                                                                                                                        (T.projection
                                                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                                                          p
                                                                                                                                                                                                                                          fx3)
                                                                                                                                                                                                                                        (T.projection
                                                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                                                          p
                                                                                                                                                                                                                                          fx4)
                                                                                                                                                                                                                                        (T.projection
                                                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                                                          p
                                                                                                                                                                                                                                          fx5)
                                                                                                                                                                                                                                        (T.projection
                                                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                                                          p
                                                                                                                                                                                                                                          fx6)
                                                                                                                                                                                                                                        (T.projection
                                                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                                                          p
                                                                                                                                                                                                                                          fx7))
                                                                                                                                                                                                                                      fw))
                                                                                                                                                                                                                                  f_y
                                                                                                                                                                                                                              v0v0v0v0v1
                                                                                                                                                                                                                                _
                                                                                                                                                                                                                                p =
                                                                                                                                                                                                                                T.projection
                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                  f_y
                                                                                                                                                                                                                              in
                                                                                                                                                                                                                              (v0v0v0v0v1))
                                                                                                                                                                                                                            f_x))
                                                                                                                                                                                                                      (T.uwrapForward
                                                                                                                                                                                                                        p
                                                                                                                                                                                                                        (hlex
                                                                                                                                                                                                                          fr7
                                                                                                                                                                                                                          p)))
                                                                                                                                                                                                                    f_y
                                                                                                                                                                                                                v0v0v0v0v1
                                                                                                                                                                                                                  _
                                                                                                                                                                                                                  p =
                                                                                                                                                                                                                  T.projection
                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                    p
                                                                                                                                                                                                                    f_y
                                                                                                                                                                                                                in
                                                                                                                                                                                                                (v0v0v0v0v1))
                                                                                                                                                                                                              f_x))
                                                                                                                                                                                                        (T.uap1
                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                          p
                                                                                                                                                                                                          (greads
                                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                                            p)
                                                                                                                                                                                                          fs7))
                                                                                                                                                                                                      f_y
                                                                                                                                                                                                  v0v0v0v0v1
                                                                                                                                                                                                    _
                                                                                                                                                                                                    p =
                                                                                                                                                                                                    T.projection
                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                      p
                                                                                                                                                                                                      f_y
                                                                                                                                                                                                  in
                                                                                                                                                                                                  (v0v0v0v0v1))
                                                                                                                                                                                                f_x))
                                                                                                                                                                                          (T.uwrapForward
                                                                                                                                                                                            p
                                                                                                                                                                                            (hlex
                                                                                                                                                                                              fr6
                                                                                                                                                                                              p)))
                                                                                                                                                                                        f_y
                                                                                                                                                                                    v0v0v0v0v1
                                                                                                                                                                                      _
                                                                                                                                                                                      p =
                                                                                                                                                                                      T.projection
                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                        p
                                                                                                                                                                                        f_y
                                                                                                                                                                                    in
                                                                                                                                                                                    (v0v0v0v0v1))
                                                                                                                                                                                  f_x))
                                                                                                                                                                            (T.uap1
                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                              p
                                                                                                                                                                              (greads
                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                p)
                                                                                                                                                                              fs6))
                                                                                                                                                                          f_y
                                                                                                                                                                      v0v0v0v0v1
                                                                                                                                                                        _
                                                                                                                                                                        p =
                                                                                                                                                                        T.projection
                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                          p
                                                                                                                                                                          f_y
                                                                                                                                                                      in
                                                                                                                                                                      (v0v0v0v0v1))
                                                                                                                                                                    f_x))
                                                                                                                                                              (T.uwrapForward
                                                                                                                                                                p
                                                                                                                                                                (hlex
                                                                                                                                                                  fr5
                                                                                                                                                                  p)))
                                                                                                                                                            f_y
                                                                                                                                                        v0v0v0v0v1
                                                                                                                                                          _
                                                                                                                                                          p =
                                                                                                                                                          T.projection
                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                            p
                                                                                                                                                            f_y
                                                                                                                                                        in
                                                                                                                                                        (v0v0v0v0v1))
                                                                                                                                                      f_x))
                                                                                                                                                (T.uap1
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p
                                                                                                                                                  (greads
                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                    p)
                                                                                                                                                  fs5))
                                                                                                                                              f_y
                                                                                                                                          v0v0v0v0v1
                                                                                                                                            _
                                                                                                                                            p =
                                                                                                                                            T.projection
                                                                                                                                              T.mkNoSrcPos
                                                                                                                                              p
                                                                                                                                              f_y
                                                                                                                                          in
                                                                                                                                          (v0v0v0v0v1))
                                                                                                                                        f_x))
                                                                                                                                  (T.uwrapForward
                                                                                                                                    p
                                                                                                                                    (hlex
                                                                                                                                      fr4
                                                                                                                                      p)))
                                                                                                                                f_y
                                                                                                                            v0v0v0v0v1
                                                                                                                              _
                                                                                                                              p =
                                                                                                                              T.projection
                                                                                                                                T.mkNoSrcPos
                                                                                                                                p
                                                                                                                                f_y
                                                                                                                            in
                                                                                                                            (v0v0v0v0v1))
                                                                                                                          f_x))
                                                                                                                    (T.uap1
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p
                                                                                                                      (greads
                                                                                                                        T.mkNoSrcPos
                                                                                                                        p)
                                                                                                                      fs4))
                                                                                                                  f_y
                                                                                                              v0v0v0v0v1
                                                                                                                _
                                                                                                                p =
                                                                                                                T.projection
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  f_y
                                                                                                              in
                                                                                                              (v0v0v0v0v1))
                                                                                                            f_x))
                                                                                                      (T.uwrapForward
                                                                                                        p
                                                                                                        (hlex
                                                                                                          fr3
                                                                                                          p)))
                                                                                                    f_y
                                                                                                v0v0v0v0v1
                                                                                                  _
                                                                                                  p =
                                                                                                  T.projection
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    f_y
                                                                                                in
                                                                                                (v0v0v0v0v1))
                                                                                              f_x))
                                                                                        (T.uap1
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (greads
                                                                                            T.mkNoSrcPos
                                                                                            p)
                                                                                          fs3))
                                                                                      f_y
                                                                                  v0v0v0v0v1
                                                                                    _
                                                                                    p =
                                                                                    T.projection
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      f_y
                                                                                  in
                                                                                  (v0v0v0v0v1))
                                                                                f_x))
                                                                          (T.uwrapForward
                                                                            p
                                                                            (hlex
                                                                              fr2
                                                                              p)))
                                                                        f_y
                                                                    v0v0v0v0v1 _
                                                                      p =
                                                                      T.projection
                                                                        T.mkNoSrcPos
                                                                        p f_y in
                                                                    (v0v0v0v0v1))
                                                                  f_x))
                                                            (T.uap1 T.mkNoSrcPos
                                                              p
                                                              (greads
                                                                T.mkNoSrcPos p)
                                                              fs2)) f_y
                                                      v0v0v0v0v1 _ p =
                                                        T.projection
                                                          T.mkNoSrcPos p f_y in
                                                      (v0v0v0v0v1)) f_x))
                                              (T.uwrapForward p (hlex fr1 p)))
                                            f_y
                                        v0v0v0v0v1 _ p =
                                          T.projection T.mkNoSrcPos p f_y in
                                        (v0v0v0v0v1)) f_x))
                                (T.uap1 T.mkNoSrcPos p (greads T.mkNoSrcPos p)
                                  fs1)) f_y
                          v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                          (v0v0v0v0v1)) f_x)) (T.uwrapForward p (hlex fr0 p)))
                (T.fromExpList T.mkNoSrcPos p []))) p)
    
  

instance
  (Read a,Read b,Read c,Read d,Read e,Read f,Read g,Read h) =>
    Read ((T.Tuple8 a b c d e f g h))
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a2088v5v2089v30readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p =
      T.uwrapForward p
        (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
          (T.ufun1 T.mkLambda T.mkNoSrcPos p
            (\ fr0 p ->
              T.uap1 T.mkNoSrcPos p
                (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                  (T.ufun2 T.mkLambda T.mkNoSrcPos p
                    (\ f_x f_y p ->
                      T.uccase T.mkNoSrcPos p
                        (let
                          v0v0v0v0v1
                            (T.R
                              (T.Tuple2
                                (T.R (T.Cons (T.R '(' _) (T.R T.List _)) _) fs1)
                              _) p =
                            T.uap1 T.mkNoSrcPos p
                              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                  (\ f_x f_y p ->
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v0v0v0v0v1 (T.R (T.Tuple2 fx1 fr1) _)
                                          p =
                                          T.uap1 T.mkNoSrcPos p
                                            (T.uap2 T.mkNoSrcPos p
                                              (g_foldr T.mkNoSrcPos p)
                                              (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                                (\ f_x f_y p ->
                                                  T.uccase T.mkNoSrcPos p
                                                    (let
                                                      v0v0v0v0v1
                                                        (T.R
                                                          (T.Tuple2
                                                            (T.R
                                                              (T.Cons
                                                                (T.R ',' _)
                                                                (T.R T.List _))
                                                              _) fs2) _) p =
                                                        T.uap1 T.mkNoSrcPos p
                                                          (T.uap2 T.mkNoSrcPos p
                                                            (g_foldr
                                                              T.mkNoSrcPos p)
                                                            (T.ufun2 T.mkLambda
                                                              T.mkNoSrcPos p
                                                              (\ f_x f_y p ->
                                                                T.uccase
                                                                  T.mkNoSrcPos p
                                                                  (let
                                                                    v0v0v0v0v1
                                                                      (T.R
                                                                        (T.Tuple2
                                                                          fx2
                                                                          fr2)
                                                                        _) p =
                                                                      T.uap1
                                                                        T.mkNoSrcPos
                                                                        p
                                                                        (T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (g_foldr
                                                                            T.mkNoSrcPos
                                                                            p)
                                                                          (T.ufun2
                                                                            T.mkLambda
                                                                            T.mkNoSrcPos
                                                                            p
                                                                            (\ f_x
                                                                              f_y
                                                                              p ->
                                                                              T.uccase
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (let
                                                                                  v0v0v0v0v1
                                                                                    (T.R
                                                                                      (T.Tuple2
                                                                                        (T.R
                                                                                          (T.Cons
                                                                                            (T.R
                                                                                              ','
                                                                                              _)
                                                                                            (T.R
                                                                                              T.List
                                                                                              _))
                                                                                          _)
                                                                                        fs3)
                                                                                      _)
                                                                                    p =
                                                                                    T.uap1
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      (T.uap2
                                                                                        T.mkNoSrcPos
                                                                                        p
                                                                                        (g_foldr
                                                                                          T.mkNoSrcPos
                                                                                          p)
                                                                                        (T.ufun2
                                                                                          T.mkLambda
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (\ f_x
                                                                                            f_y
                                                                                            p ->
                                                                                            T.uccase
                                                                                              T.mkNoSrcPos
                                                                                              p
                                                                                              (let
                                                                                                v0v0v0v0v1
                                                                                                  (T.R
                                                                                                    (T.Tuple2
                                                                                                      fx3
                                                                                                      fr3)
                                                                                                    _)
                                                                                                  p =
                                                                                                  T.uap1
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    (T.uap2
                                                                                                      T.mkNoSrcPos
                                                                                                      p
                                                                                                      (g_foldr
                                                                                                        T.mkNoSrcPos
                                                                                                        p)
                                                                                                      (T.ufun2
                                                                                                        T.mkLambda
                                                                                                        T.mkNoSrcPos
                                                                                                        p
                                                                                                        (\ f_x
                                                                                                          f_y
                                                                                                          p ->
                                                                                                          T.uccase
                                                                                                            T.mkNoSrcPos
                                                                                                            p
                                                                                                            (let
                                                                                                              v0v0v0v0v1
                                                                                                                (T.R
                                                                                                                  (T.Tuple2
                                                                                                                    (T.R
                                                                                                                      (T.Cons
                                                                                                                        (T.R
                                                                                                                          ','
                                                                                                                          _)
                                                                                                                        (T.R
                                                                                                                          T.List
                                                                                                                          _))
                                                                                                                      _)
                                                                                                                    fs4)
                                                                                                                  _)
                                                                                                                p =
                                                                                                                T.uap1
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  (T.uap2
                                                                                                                    T.mkNoSrcPos
                                                                                                                    p
                                                                                                                    (g_foldr
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p)
                                                                                                                    (T.ufun2
                                                                                                                      T.mkLambda
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p
                                                                                                                      (\ f_x
                                                                                                                        f_y
                                                                                                                        p ->
                                                                                                                        T.uccase
                                                                                                                          T.mkNoSrcPos
                                                                                                                          p
                                                                                                                          (let
                                                                                                                            v0v0v0v0v1
                                                                                                                              (T.R
                                                                                                                                (T.Tuple2
                                                                                                                                  fx4
                                                                                                                                  fr4)
                                                                                                                                _)
                                                                                                                              p =
                                                                                                                              T.uap1
                                                                                                                                T.mkNoSrcPos
                                                                                                                                p
                                                                                                                                (T.uap2
                                                                                                                                  T.mkNoSrcPos
                                                                                                                                  p
                                                                                                                                  (g_foldr
                                                                                                                                    T.mkNoSrcPos
                                                                                                                                    p)
                                                                                                                                  (T.ufun2
                                                                                                                                    T.mkLambda
                                                                                                                                    T.mkNoSrcPos
                                                                                                                                    p
                                                                                                                                    (\ f_x
                                                                                                                                      f_y
                                                                                                                                      p ->
                                                                                                                                      T.uccase
                                                                                                                                        T.mkNoSrcPos
                                                                                                                                        p
                                                                                                                                        (let
                                                                                                                                          v0v0v0v0v1
                                                                                                                                            (T.R
                                                                                                                                              (T.Tuple2
                                                                                                                                                (T.R
                                                                                                                                                  (T.Cons
                                                                                                                                                    (T.R
                                                                                                                                                      ','
                                                                                                                                                      _)
                                                                                                                                                    (T.R
                                                                                                                                                      T.List
                                                                                                                                                      _))
                                                                                                                                                  _)
                                                                                                                                                fs5)
                                                                                                                                              _)
                                                                                                                                            p =
                                                                                                                                            T.uap1
                                                                                                                                              T.mkNoSrcPos
                                                                                                                                              p
                                                                                                                                              (T.uap2
                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                p
                                                                                                                                                (g_foldr
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p)
                                                                                                                                                (T.ufun2
                                                                                                                                                  T.mkLambda
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p
                                                                                                                                                  (\ f_x
                                                                                                                                                    f_y
                                                                                                                                                    p ->
                                                                                                                                                    T.uccase
                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                      p
                                                                                                                                                      (let
                                                                                                                                                        v0v0v0v0v1
                                                                                                                                                          (T.R
                                                                                                                                                            (T.Tuple2
                                                                                                                                                              fx5
                                                                                                                                                              fr5)
                                                                                                                                                            _)
                                                                                                                                                          p =
                                                                                                                                                          T.uap1
                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                            p
                                                                                                                                                            (T.uap2
                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                              p
                                                                                                                                                              (g_foldr
                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                p)
                                                                                                                                                              (T.ufun2
                                                                                                                                                                T.mkLambda
                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                p
                                                                                                                                                                (\ f_x
                                                                                                                                                                  f_y
                                                                                                                                                                  p ->
                                                                                                                                                                  T.uccase
                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                    p
                                                                                                                                                                    (let
                                                                                                                                                                      v0v0v0v0v1
                                                                                                                                                                        (T.R
                                                                                                                                                                          (T.Tuple2
                                                                                                                                                                            (T.R
                                                                                                                                                                              (T.Cons
                                                                                                                                                                                (T.R
                                                                                                                                                                                  ','
                                                                                                                                                                                  _)
                                                                                                                                                                                (T.R
                                                                                                                                                                                  T.List
                                                                                                                                                                                  _))
                                                                                                                                                                              _)
                                                                                                                                                                            fs6)
                                                                                                                                                                          _)
                                                                                                                                                                        p =
                                                                                                                                                                        T.uap1
                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                          p
                                                                                                                                                                          (T.uap2
                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                            p
                                                                                                                                                                            (g_foldr
                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                              p)
                                                                                                                                                                            (T.ufun2
                                                                                                                                                                              T.mkLambda
                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                              p
                                                                                                                                                                              (\ f_x
                                                                                                                                                                                f_y
                                                                                                                                                                                p ->
                                                                                                                                                                                T.uccase
                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                  p
                                                                                                                                                                                  (let
                                                                                                                                                                                    v0v0v0v0v1
                                                                                                                                                                                      (T.R
                                                                                                                                                                                        (T.Tuple2
                                                                                                                                                                                          fx6
                                                                                                                                                                                          fr6)
                                                                                                                                                                                        _)
                                                                                                                                                                                      p =
                                                                                                                                                                                      T.uap1
                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                        p
                                                                                                                                                                                        (T.uap2
                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                          p
                                                                                                                                                                                          (g_foldr
                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                            p)
                                                                                                                                                                                          (T.ufun2
                                                                                                                                                                                            T.mkLambda
                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                            p
                                                                                                                                                                                            (\ f_x
                                                                                                                                                                                              f_y
                                                                                                                                                                                              p ->
                                                                                                                                                                                              T.uccase
                                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                                p
                                                                                                                                                                                                (let
                                                                                                                                                                                                  v0v0v0v0v1
                                                                                                                                                                                                    (T.R
                                                                                                                                                                                                      (T.Tuple2
                                                                                                                                                                                                        (T.R
                                                                                                                                                                                                          (T.Cons
                                                                                                                                                                                                            (T.R
                                                                                                                                                                                                              ','
                                                                                                                                                                                                              _)
                                                                                                                                                                                                            (T.R
                                                                                                                                                                                                              T.List
                                                                                                                                                                                                              _))
                                                                                                                                                                                                          _)
                                                                                                                                                                                                        fs7)
                                                                                                                                                                                                      _)
                                                                                                                                                                                                    p =
                                                                                                                                                                                                    T.uap1
                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                      p
                                                                                                                                                                                                      (T.uap2
                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                        p
                                                                                                                                                                                                        (g_foldr
                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                          p)
                                                                                                                                                                                                        (T.ufun2
                                                                                                                                                                                                          T.mkLambda
                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                          p
                                                                                                                                                                                                          (\ f_x
                                                                                                                                                                                                            f_y
                                                                                                                                                                                                            p ->
                                                                                                                                                                                                            T.uccase
                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                              p
                                                                                                                                                                                                              (let
                                                                                                                                                                                                                v0v0v0v0v1
                                                                                                                                                                                                                  (T.R
                                                                                                                                                                                                                    (T.Tuple2
                                                                                                                                                                                                                      fx7
                                                                                                                                                                                                                      fr7)
                                                                                                                                                                                                                    _)
                                                                                                                                                                                                                  p =
                                                                                                                                                                                                                  T.uap1
                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                    p
                                                                                                                                                                                                                    (T.uap2
                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                      p
                                                                                                                                                                                                                      (g_foldr
                                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                                        p)
                                                                                                                                                                                                                      (T.ufun2
                                                                                                                                                                                                                        T.mkLambda
                                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                                        p
                                                                                                                                                                                                                        (\ f_x
                                                                                                                                                                                                                          f_y
                                                                                                                                                                                                                          p ->
                                                                                                                                                                                                                          T.uccase
                                                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                                                            p
                                                                                                                                                                                                                            (let
                                                                                                                                                                                                                              v0v0v0v0v1
                                                                                                                                                                                                                                (T.R
                                                                                                                                                                                                                                  (T.Tuple2
                                                                                                                                                                                                                                    (T.R
                                                                                                                                                                                                                                      (T.Cons
                                                                                                                                                                                                                                        (T.R
                                                                                                                                                                                                                                          ','
                                                                                                                                                                                                                                          _)
                                                                                                                                                                                                                                        (T.R
                                                                                                                                                                                                                                          T.List
                                                                                                                                                                                                                                          _))
                                                                                                                                                                                                                                      _)
                                                                                                                                                                                                                                    fs8)
                                                                                                                                                                                                                                  _)
                                                                                                                                                                                                                                p =
                                                                                                                                                                                                                                T.uap1
                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                  (T.uap2
                                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                                    p
                                                                                                                                                                                                                                    (g_foldr
                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                      p)
                                                                                                                                                                                                                                    (T.ufun2
                                                                                                                                                                                                                                      T.mkLambda
                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                      p
                                                                                                                                                                                                                                      (\ f_x
                                                                                                                                                                                                                                        f_y
                                                                                                                                                                                                                                        p ->
                                                                                                                                                                                                                                        T.uccase
                                                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                                                          p
                                                                                                                                                                                                                                          (let
                                                                                                                                                                                                                                            v0v0v0v0v1
                                                                                                                                                                                                                                              (T.R
                                                                                                                                                                                                                                                (T.Tuple2
                                                                                                                                                                                                                                                  fx8
                                                                                                                                                                                                                                                  fr8)
                                                                                                                                                                                                                                                _)
                                                                                                                                                                                                                                              p =
                                                                                                                                                                                                                                              T.uap1
                                                                                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                                                                                p
                                                                                                                                                                                                                                                (T.uap2
                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                                  (g_foldr
                                                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                                                    p)
                                                                                                                                                                                                                                                  (T.ufun2
                                                                                                                                                                                                                                                    T.mkLambda
                                                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                                                    p
                                                                                                                                                                                                                                                    (\ f_x
                                                                                                                                                                                                                                                      f_y
                                                                                                                                                                                                                                                      p ->
                                                                                                                                                                                                                                                      T.uccase
                                                                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                                                                        p
                                                                                                                                                                                                                                                        (let
                                                                                                                                                                                                                                                          v0v0v0v0v1
                                                                                                                                                                                                                                                            (T.R
                                                                                                                                                                                                                                                              (T.Tuple2
                                                                                                                                                                                                                                                                (T.R
                                                                                                                                                                                                                                                                  (T.Cons
                                                                                                                                                                                                                                                                    (T.R
                                                                                                                                                                                                                                                                      ')'
                                                                                                                                                                                                                                                                      _)
                                                                                                                                                                                                                                                                    (T.R
                                                                                                                                                                                                                                                                      T.List
                                                                                                                                                                                                                                                                      _))
                                                                                                                                                                                                                                                                  _)
                                                                                                                                                                                                                                                                fw)
                                                                                                                                                                                                                                                              _)
                                                                                                                                                                                                                                                            p =
                                                                                                                                                                                                                                                            T.uap1
                                                                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                                                                              p
                                                                                                                                                                                                                                                              (T.pa1
                                                                                                                                                                                                                                                                T.Cons
                                                                                                                                                                                                                                                                T.cn1
                                                                                                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                                                                                                p
                                                                                                                                                                                                                                                                T.aCons
                                                                                                                                                                                                                                                                (T.con2
                                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                                                  T.Tuple2
                                                                                                                                                                                                                                                                  T.aTuple2
                                                                                                                                                                                                                                                                  (T.con8
                                                                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                                                                    p
                                                                                                                                                                                                                                                                    T.Tuple8
                                                                                                                                                                                                                                                                    T.aTuple8
                                                                                                                                                                                                                                                                    (T.projection
                                                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                                                      p
                                                                                                                                                                                                                                                                      fx1)
                                                                                                                                                                                                                                                                    (T.projection
                                                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                                                      p
                                                                                                                                                                                                                                                                      fx2)
                                                                                                                                                                                                                                                                    (T.projection
                                                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                                                      p
                                                                                                                                                                                                                                                                      fx3)
                                                                                                                                                                                                                                                                    (T.projection
                                                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                                                      p
                                                                                                                                                                                                                                                                      fx4)
                                                                                                                                                                                                                                                                    (T.projection
                                                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                                                      p
                                                                                                                                                                                                                                                                      fx5)
                                                                                                                                                                                                                                                                    (T.projection
                                                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                                                      p
                                                                                                                                                                                                                                                                      fx6)
                                                                                                                                                                                                                                                                    (T.projection
                                                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                                                      p
                                                                                                                                                                                                                                                                      fx7)
                                                                                                                                                                                                                                                                    (T.projection
                                                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                                                      p
                                                                                                                                                                                                                                                                      fx8))
                                                                                                                                                                                                                                                                  fw))
                                                                                                                                                                                                                                                              f_y
                                                                                                                                                                                                                                                          v0v0v0v0v1
                                                                                                                                                                                                                                                            _
                                                                                                                                                                                                                                                            p =
                                                                                                                                                                                                                                                            T.projection
                                                                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                                                                              p
                                                                                                                                                                                                                                                              f_y
                                                                                                                                                                                                                                                          in
                                                                                                                                                                                                                                                          (v0v0v0v0v1))
                                                                                                                                                                                                                                                        f_x))
                                                                                                                                                                                                                                                  (T.uwrapForward
                                                                                                                                                                                                                                                    p
                                                                                                                                                                                                                                                    (hlex
                                                                                                                                                                                                                                                      fr8
                                                                                                                                                                                                                                                      p)))
                                                                                                                                                                                                                                                f_y
                                                                                                                                                                                                                                            v0v0v0v0v1
                                                                                                                                                                                                                                              _
                                                                                                                                                                                                                                              p =
                                                                                                                                                                                                                                              T.projection
                                                                                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                                                                                p
                                                                                                                                                                                                                                                f_y
                                                                                                                                                                                                                                            in
                                                                                                                                                                                                                                            (v0v0v0v0v1))
                                                                                                                                                                                                                                          f_x))
                                                                                                                                                                                                                                    (T.uap1
                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                      p
                                                                                                                                                                                                                                      (greads
                                                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                                                        p)
                                                                                                                                                                                                                                      fs8))
                                                                                                                                                                                                                                  f_y
                                                                                                                                                                                                                              v0v0v0v0v1
                                                                                                                                                                                                                                _
                                                                                                                                                                                                                                p =
                                                                                                                                                                                                                                T.projection
                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                  f_y
                                                                                                                                                                                                                              in
                                                                                                                                                                                                                              (v0v0v0v0v1))
                                                                                                                                                                                                                            f_x))
                                                                                                                                                                                                                      (T.uwrapForward
                                                                                                                                                                                                                        p
                                                                                                                                                                                                                        (hlex
                                                                                                                                                                                                                          fr7
                                                                                                                                                                                                                          p)))
                                                                                                                                                                                                                    f_y
                                                                                                                                                                                                                v0v0v0v0v1
                                                                                                                                                                                                                  _
                                                                                                                                                                                                                  p =
                                                                                                                                                                                                                  T.projection
                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                    p
                                                                                                                                                                                                                    f_y
                                                                                                                                                                                                                in
                                                                                                                                                                                                                (v0v0v0v0v1))
                                                                                                                                                                                                              f_x))
                                                                                                                                                                                                        (T.uap1
                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                          p
                                                                                                                                                                                                          (greads
                                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                                            p)
                                                                                                                                                                                                          fs7))
                                                                                                                                                                                                      f_y
                                                                                                                                                                                                  v0v0v0v0v1
                                                                                                                                                                                                    _
                                                                                                                                                                                                    p =
                                                                                                                                                                                                    T.projection
                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                      p
                                                                                                                                                                                                      f_y
                                                                                                                                                                                                  in
                                                                                                                                                                                                  (v0v0v0v0v1))
                                                                                                                                                                                                f_x))
                                                                                                                                                                                          (T.uwrapForward
                                                                                                                                                                                            p
                                                                                                                                                                                            (hlex
                                                                                                                                                                                              fr6
                                                                                                                                                                                              p)))
                                                                                                                                                                                        f_y
                                                                                                                                                                                    v0v0v0v0v1
                                                                                                                                                                                      _
                                                                                                                                                                                      p =
                                                                                                                                                                                      T.projection
                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                        p
                                                                                                                                                                                        f_y
                                                                                                                                                                                    in
                                                                                                                                                                                    (v0v0v0v0v1))
                                                                                                                                                                                  f_x))
                                                                                                                                                                            (T.uap1
                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                              p
                                                                                                                                                                              (greads
                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                p)
                                                                                                                                                                              fs6))
                                                                                                                                                                          f_y
                                                                                                                                                                      v0v0v0v0v1
                                                                                                                                                                        _
                                                                                                                                                                        p =
                                                                                                                                                                        T.projection
                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                          p
                                                                                                                                                                          f_y
                                                                                                                                                                      in
                                                                                                                                                                      (v0v0v0v0v1))
                                                                                                                                                                    f_x))
                                                                                                                                                              (T.uwrapForward
                                                                                                                                                                p
                                                                                                                                                                (hlex
                                                                                                                                                                  fr5
                                                                                                                                                                  p)))
                                                                                                                                                            f_y
                                                                                                                                                        v0v0v0v0v1
                                                                                                                                                          _
                                                                                                                                                          p =
                                                                                                                                                          T.projection
                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                            p
                                                                                                                                                            f_y
                                                                                                                                                        in
                                                                                                                                                        (v0v0v0v0v1))
                                                                                                                                                      f_x))
                                                                                                                                                (T.uap1
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p
                                                                                                                                                  (greads
                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                    p)
                                                                                                                                                  fs5))
                                                                                                                                              f_y
                                                                                                                                          v0v0v0v0v1
                                                                                                                                            _
                                                                                                                                            p =
                                                                                                                                            T.projection
                                                                                                                                              T.mkNoSrcPos
                                                                                                                                              p
                                                                                                                                              f_y
                                                                                                                                          in
                                                                                                                                          (v0v0v0v0v1))
                                                                                                                                        f_x))
                                                                                                                                  (T.uwrapForward
                                                                                                                                    p
                                                                                                                                    (hlex
                                                                                                                                      fr4
                                                                                                                                      p)))
                                                                                                                                f_y
                                                                                                                            v0v0v0v0v1
                                                                                                                              _
                                                                                                                              p =
                                                                                                                              T.projection
                                                                                                                                T.mkNoSrcPos
                                                                                                                                p
                                                                                                                                f_y
                                                                                                                            in
                                                                                                                            (v0v0v0v0v1))
                                                                                                                          f_x))
                                                                                                                    (T.uap1
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p
                                                                                                                      (greads
                                                                                                                        T.mkNoSrcPos
                                                                                                                        p)
                                                                                                                      fs4))
                                                                                                                  f_y
                                                                                                              v0v0v0v0v1
                                                                                                                _
                                                                                                                p =
                                                                                                                T.projection
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  f_y
                                                                                                              in
                                                                                                              (v0v0v0v0v1))
                                                                                                            f_x))
                                                                                                      (T.uwrapForward
                                                                                                        p
                                                                                                        (hlex
                                                                                                          fr3
                                                                                                          p)))
                                                                                                    f_y
                                                                                                v0v0v0v0v1
                                                                                                  _
                                                                                                  p =
                                                                                                  T.projection
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    f_y
                                                                                                in
                                                                                                (v0v0v0v0v1))
                                                                                              f_x))
                                                                                        (T.uap1
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (greads
                                                                                            T.mkNoSrcPos
                                                                                            p)
                                                                                          fs3))
                                                                                      f_y
                                                                                  v0v0v0v0v1
                                                                                    _
                                                                                    p =
                                                                                    T.projection
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      f_y
                                                                                  in
                                                                                  (v0v0v0v0v1))
                                                                                f_x))
                                                                          (T.uwrapForward
                                                                            p
                                                                            (hlex
                                                                              fr2
                                                                              p)))
                                                                        f_y
                                                                    v0v0v0v0v1 _
                                                                      p =
                                                                      T.projection
                                                                        T.mkNoSrcPos
                                                                        p f_y in
                                                                    (v0v0v0v0v1))
                                                                  f_x))
                                                            (T.uap1 T.mkNoSrcPos
                                                              p
                                                              (greads
                                                                T.mkNoSrcPos p)
                                                              fs2)) f_y
                                                      v0v0v0v0v1 _ p =
                                                        T.projection
                                                          T.mkNoSrcPos p f_y in
                                                      (v0v0v0v0v1)) f_x))
                                              (T.uwrapForward p (hlex fr1 p)))
                                            f_y
                                        v0v0v0v0v1 _ p =
                                          T.projection T.mkNoSrcPos p f_y in
                                        (v0v0v0v0v1)) f_x))
                                (T.uap1 T.mkNoSrcPos p (greads T.mkNoSrcPos p)
                                  fs1)) f_y
                          v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                          (v0v0v0v0v1)) f_x)) (T.uwrapForward p (hlex fr0 p)))
                (T.fromExpList T.mkNoSrcPos p []))) p)
    
  

instance
  (Read a,Read b,Read c,Read d,Read e,Read f,Read g,Read h,Read i) =>
    Read ((T.Tuple9 a b c d e f g h i))
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a2111v5v2112v30readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p =
      T.uwrapForward p
        (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
          (T.ufun1 T.mkLambda T.mkNoSrcPos p
            (\ fr0 p ->
              T.uap1 T.mkNoSrcPos p
                (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                  (T.ufun2 T.mkLambda T.mkNoSrcPos p
                    (\ f_x f_y p ->
                      T.uccase T.mkNoSrcPos p
                        (let
                          v0v0v0v0v1
                            (T.R
                              (T.Tuple2
                                (T.R (T.Cons (T.R '(' _) (T.R T.List _)) _) fs1)
                              _) p =
                            T.uap1 T.mkNoSrcPos p
                              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                  (\ f_x f_y p ->
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v0v0v0v0v1 (T.R (T.Tuple2 fx1 fr1) _)
                                          p =
                                          T.uap1 T.mkNoSrcPos p
                                            (T.uap2 T.mkNoSrcPos p
                                              (g_foldr T.mkNoSrcPos p)
                                              (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                                (\ f_x f_y p ->
                                                  T.uccase T.mkNoSrcPos p
                                                    (let
                                                      v0v0v0v0v1
                                                        (T.R
                                                          (T.Tuple2
                                                            (T.R
                                                              (T.Cons
                                                                (T.R ',' _)
                                                                (T.R T.List _))
                                                              _) fs2) _) p =
                                                        T.uap1 T.mkNoSrcPos p
                                                          (T.uap2 T.mkNoSrcPos p
                                                            (g_foldr
                                                              T.mkNoSrcPos p)
                                                            (T.ufun2 T.mkLambda
                                                              T.mkNoSrcPos p
                                                              (\ f_x f_y p ->
                                                                T.uccase
                                                                  T.mkNoSrcPos p
                                                                  (let
                                                                    v0v0v0v0v1
                                                                      (T.R
                                                                        (T.Tuple2
                                                                          fx2
                                                                          fr2)
                                                                        _) p =
                                                                      T.uap1
                                                                        T.mkNoSrcPos
                                                                        p
                                                                        (T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (g_foldr
                                                                            T.mkNoSrcPos
                                                                            p)
                                                                          (T.ufun2
                                                                            T.mkLambda
                                                                            T.mkNoSrcPos
                                                                            p
                                                                            (\ f_x
                                                                              f_y
                                                                              p ->
                                                                              T.uccase
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (let
                                                                                  v0v0v0v0v1
                                                                                    (T.R
                                                                                      (T.Tuple2
                                                                                        (T.R
                                                                                          (T.Cons
                                                                                            (T.R
                                                                                              ','
                                                                                              _)
                                                                                            (T.R
                                                                                              T.List
                                                                                              _))
                                                                                          _)
                                                                                        fs3)
                                                                                      _)
                                                                                    p =
                                                                                    T.uap1
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      (T.uap2
                                                                                        T.mkNoSrcPos
                                                                                        p
                                                                                        (g_foldr
                                                                                          T.mkNoSrcPos
                                                                                          p)
                                                                                        (T.ufun2
                                                                                          T.mkLambda
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (\ f_x
                                                                                            f_y
                                                                                            p ->
                                                                                            T.uccase
                                                                                              T.mkNoSrcPos
                                                                                              p
                                                                                              (let
                                                                                                v0v0v0v0v1
                                                                                                  (T.R
                                                                                                    (T.Tuple2
                                                                                                      fx3
                                                                                                      fr3)
                                                                                                    _)
                                                                                                  p =
                                                                                                  T.uap1
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    (T.uap2
                                                                                                      T.mkNoSrcPos
                                                                                                      p
                                                                                                      (g_foldr
                                                                                                        T.mkNoSrcPos
                                                                                                        p)
                                                                                                      (T.ufun2
                                                                                                        T.mkLambda
                                                                                                        T.mkNoSrcPos
                                                                                                        p
                                                                                                        (\ f_x
                                                                                                          f_y
                                                                                                          p ->
                                                                                                          T.uccase
                                                                                                            T.mkNoSrcPos
                                                                                                            p
                                                                                                            (let
                                                                                                              v0v0v0v0v1
                                                                                                                (T.R
                                                                                                                  (T.Tuple2
                                                                                                                    (T.R
                                                                                                                      (T.Cons
                                                                                                                        (T.R
                                                                                                                          ','
                                                                                                                          _)
                                                                                                                        (T.R
                                                                                                                          T.List
                                                                                                                          _))
                                                                                                                      _)
                                                                                                                    fs4)
                                                                                                                  _)
                                                                                                                p =
                                                                                                                T.uap1
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  (T.uap2
                                                                                                                    T.mkNoSrcPos
                                                                                                                    p
                                                                                                                    (g_foldr
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p)
                                                                                                                    (T.ufun2
                                                                                                                      T.mkLambda
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p
                                                                                                                      (\ f_x
                                                                                                                        f_y
                                                                                                                        p ->
                                                                                                                        T.uccase
                                                                                                                          T.mkNoSrcPos
                                                                                                                          p
                                                                                                                          (let
                                                                                                                            v0v0v0v0v1
                                                                                                                              (T.R
                                                                                                                                (T.Tuple2
                                                                                                                                  fx4
                                                                                                                                  fr4)
                                                                                                                                _)
                                                                                                                              p =
                                                                                                                              T.uap1
                                                                                                                                T.mkNoSrcPos
                                                                                                                                p
                                                                                                                                (T.uap2
                                                                                                                                  T.mkNoSrcPos
                                                                                                                                  p
                                                                                                                                  (g_foldr
                                                                                                                                    T.mkNoSrcPos
                                                                                                                                    p)
                                                                                                                                  (T.ufun2
                                                                                                                                    T.mkLambda
                                                                                                                                    T.mkNoSrcPos
                                                                                                                                    p
                                                                                                                                    (\ f_x
                                                                                                                                      f_y
                                                                                                                                      p ->
                                                                                                                                      T.uccase
                                                                                                                                        T.mkNoSrcPos
                                                                                                                                        p
                                                                                                                                        (let
                                                                                                                                          v0v0v0v0v1
                                                                                                                                            (T.R
                                                                                                                                              (T.Tuple2
                                                                                                                                                (T.R
                                                                                                                                                  (T.Cons
                                                                                                                                                    (T.R
                                                                                                                                                      ','
                                                                                                                                                      _)
                                                                                                                                                    (T.R
                                                                                                                                                      T.List
                                                                                                                                                      _))
                                                                                                                                                  _)
                                                                                                                                                fs5)
                                                                                                                                              _)
                                                                                                                                            p =
                                                                                                                                            T.uap1
                                                                                                                                              T.mkNoSrcPos
                                                                                                                                              p
                                                                                                                                              (T.uap2
                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                p
                                                                                                                                                (g_foldr
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p)
                                                                                                                                                (T.ufun2
                                                                                                                                                  T.mkLambda
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p
                                                                                                                                                  (\ f_x
                                                                                                                                                    f_y
                                                                                                                                                    p ->
                                                                                                                                                    T.uccase
                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                      p
                                                                                                                                                      (let
                                                                                                                                                        v0v0v0v0v1
                                                                                                                                                          (T.R
                                                                                                                                                            (T.Tuple2
                                                                                                                                                              fx5
                                                                                                                                                              fr5)
                                                                                                                                                            _)
                                                                                                                                                          p =
                                                                                                                                                          T.uap1
                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                            p
                                                                                                                                                            (T.uap2
                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                              p
                                                                                                                                                              (g_foldr
                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                p)
                                                                                                                                                              (T.ufun2
                                                                                                                                                                T.mkLambda
                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                p
                                                                                                                                                                (\ f_x
                                                                                                                                                                  f_y
                                                                                                                                                                  p ->
                                                                                                                                                                  T.uccase
                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                    p
                                                                                                                                                                    (let
                                                                                                                                                                      v0v0v0v0v1
                                                                                                                                                                        (T.R
                                                                                                                                                                          (T.Tuple2
                                                                                                                                                                            (T.R
                                                                                                                                                                              (T.Cons
                                                                                                                                                                                (T.R
                                                                                                                                                                                  ','
                                                                                                                                                                                  _)
                                                                                                                                                                                (T.R
                                                                                                                                                                                  T.List
                                                                                                                                                                                  _))
                                                                                                                                                                              _)
                                                                                                                                                                            fs6)
                                                                                                                                                                          _)
                                                                                                                                                                        p =
                                                                                                                                                                        T.uap1
                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                          p
                                                                                                                                                                          (T.uap2
                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                            p
                                                                                                                                                                            (g_foldr
                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                              p)
                                                                                                                                                                            (T.ufun2
                                                                                                                                                                              T.mkLambda
                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                              p
                                                                                                                                                                              (\ f_x
                                                                                                                                                                                f_y
                                                                                                                                                                                p ->
                                                                                                                                                                                T.uccase
                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                  p
                                                                                                                                                                                  (let
                                                                                                                                                                                    v0v0v0v0v1
                                                                                                                                                                                      (T.R
                                                                                                                                                                                        (T.Tuple2
                                                                                                                                                                                          fx6
                                                                                                                                                                                          fr6)
                                                                                                                                                                                        _)
                                                                                                                                                                                      p =
                                                                                                                                                                                      T.uap1
                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                        p
                                                                                                                                                                                        (T.uap2
                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                          p
                                                                                                                                                                                          (g_foldr
                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                            p)
                                                                                                                                                                                          (T.ufun2
                                                                                                                                                                                            T.mkLambda
                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                            p
                                                                                                                                                                                            (\ f_x
                                                                                                                                                                                              f_y
                                                                                                                                                                                              p ->
                                                                                                                                                                                              T.uccase
                                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                                p
                                                                                                                                                                                                (let
                                                                                                                                                                                                  v0v0v0v0v1
                                                                                                                                                                                                    (T.R
                                                                                                                                                                                                      (T.Tuple2
                                                                                                                                                                                                        (T.R
                                                                                                                                                                                                          (T.Cons
                                                                                                                                                                                                            (T.R
                                                                                                                                                                                                              ','
                                                                                                                                                                                                              _)
                                                                                                                                                                                                            (T.R
                                                                                                                                                                                                              T.List
                                                                                                                                                                                                              _))
                                                                                                                                                                                                          _)
                                                                                                                                                                                                        fs7)
                                                                                                                                                                                                      _)
                                                                                                                                                                                                    p =
                                                                                                                                                                                                    T.uap1
                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                      p
                                                                                                                                                                                                      (T.uap2
                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                        p
                                                                                                                                                                                                        (g_foldr
                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                          p)
                                                                                                                                                                                                        (T.ufun2
                                                                                                                                                                                                          T.mkLambda
                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                          p
                                                                                                                                                                                                          (\ f_x
                                                                                                                                                                                                            f_y
                                                                                                                                                                                                            p ->
                                                                                                                                                                                                            T.uccase
                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                              p
                                                                                                                                                                                                              (let
                                                                                                                                                                                                                v0v0v0v0v1
                                                                                                                                                                                                                  (T.R
                                                                                                                                                                                                                    (T.Tuple2
                                                                                                                                                                                                                      fx7
                                                                                                                                                                                                                      fr7)
                                                                                                                                                                                                                    _)
                                                                                                                                                                                                                  p =
                                                                                                                                                                                                                  T.uap1
                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                    p
                                                                                                                                                                                                                    (T.uap2
                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                      p
                                                                                                                                                                                                                      (g_foldr
                                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                                        p)
                                                                                                                                                                                                                      (T.ufun2
                                                                                                                                                                                                                        T.mkLambda
                                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                                        p
                                                                                                                                                                                                                        (\ f_x
                                                                                                                                                                                                                          f_y
                                                                                                                                                                                                                          p ->
                                                                                                                                                                                                                          T.uccase
                                                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                                                            p
                                                                                                                                                                                                                            (let
                                                                                                                                                                                                                              v0v0v0v0v1
                                                                                                                                                                                                                                (T.R
                                                                                                                                                                                                                                  (T.Tuple2
                                                                                                                                                                                                                                    (T.R
                                                                                                                                                                                                                                      (T.Cons
                                                                                                                                                                                                                                        (T.R
                                                                                                                                                                                                                                          ','
                                                                                                                                                                                                                                          _)
                                                                                                                                                                                                                                        (T.R
                                                                                                                                                                                                                                          T.List
                                                                                                                                                                                                                                          _))
                                                                                                                                                                                                                                      _)
                                                                                                                                                                                                                                    fs8)
                                                                                                                                                                                                                                  _)
                                                                                                                                                                                                                                p =
                                                                                                                                                                                                                                T.uap1
                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                  (T.uap2
                                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                                    p
                                                                                                                                                                                                                                    (g_foldr
                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                      p)
                                                                                                                                                                                                                                    (T.ufun2
                                                                                                                                                                                                                                      T.mkLambda
                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                      p
                                                                                                                                                                                                                                      (\ f_x
                                                                                                                                                                                                                                        f_y
                                                                                                                                                                                                                                        p ->
                                                                                                                                                                                                                                        T.uccase
                                                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                                                          p
                                                                                                                                                                                                                                          (let
                                                                                                                                                                                                                                            v0v0v0v0v1
                                                                                                                                                                                                                                              (T.R
                                                                                                                                                                                                                                                (T.Tuple2
                                                                                                                                                                                                                                                  fx8
                                                                                                                                                                                                                                                  fr8)
                                                                                                                                                                                                                                                _)
                                                                                                                                                                                                                                              p =
                                                                                                                                                                                                                                              T.uap1
                                                                                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                                                                                p
                                                                                                                                                                                                                                                (T.uap2
                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                                  (g_foldr
                                                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                                                    p)
                                                                                                                                                                                                                                                  (T.ufun2
                                                                                                                                                                                                                                                    T.mkLambda
                                                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                                                    p
                                                                                                                                                                                                                                                    (\ f_x
                                                                                                                                                                                                                                                      f_y
                                                                                                                                                                                                                                                      p ->
                                                                                                                                                                                                                                                      T.uccase
                                                                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                                                                        p
                                                                                                                                                                                                                                                        (let
                                                                                                                                                                                                                                                          v0v0v0v0v1
                                                                                                                                                                                                                                                            (T.R
                                                                                                                                                                                                                                                              (T.Tuple2
                                                                                                                                                                                                                                                                (T.R
                                                                                                                                                                                                                                                                  (T.Cons
                                                                                                                                                                                                                                                                    (T.R
                                                                                                                                                                                                                                                                      ','
                                                                                                                                                                                                                                                                      _)
                                                                                                                                                                                                                                                                    (T.R
                                                                                                                                                                                                                                                                      T.List
                                                                                                                                                                                                                                                                      _))
                                                                                                                                                                                                                                                                  _)
                                                                                                                                                                                                                                                                fs9)
                                                                                                                                                                                                                                                              _)
                                                                                                                                                                                                                                                            p =
                                                                                                                                                                                                                                                            T.uap1
                                                                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                                                                              p
                                                                                                                                                                                                                                                              (T.uap2
                                                                                                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                                                                                                p
                                                                                                                                                                                                                                                                (g_foldr
                                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                                  p)
                                                                                                                                                                                                                                                                (T.ufun2
                                                                                                                                                                                                                                                                  T.mkLambda
                                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                                                  (\ f_x
                                                                                                                                                                                                                                                                    f_y
                                                                                                                                                                                                                                                                    p ->
                                                                                                                                                                                                                                                                    T.uccase
                                                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                                                      p
                                                                                                                                                                                                                                                                      (let
                                                                                                                                                                                                                                                                        v0v0v0v0v1
                                                                                                                                                                                                                                                                          (T.R
                                                                                                                                                                                                                                                                            (T.Tuple2
                                                                                                                                                                                                                                                                              fx9
                                                                                                                                                                                                                                                                              fr9)
                                                                                                                                                                                                                                                                            _)
                                                                                                                                                                                                                                                                          p =
                                                                                                                                                                                                                                                                          T.uap1
                                                                                                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                                                                                                            p
                                                                                                                                                                                                                                                                            (T.uap2
                                                                                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                                                                                              p
                                                                                                                                                                                                                                                                              (g_foldr
                                                                                                                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                                                                                                                p)
                                                                                                                                                                                                                                                                              (T.ufun2
                                                                                                                                                                                                                                                                                T.mkLambda
                                                                                                                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                                                                                                                p
                                                                                                                                                                                                                                                                                (\ f_x
                                                                                                                                                                                                                                                                                  f_y
                                                                                                                                                                                                                                                                                  p ->
                                                                                                                                                                                                                                                                                  T.uccase
                                                                                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                                                                                    p
                                                                                                                                                                                                                                                                                    (let
                                                                                                                                                                                                                                                                                      v0v0v0v0v1
                                                                                                                                                                                                                                                                                        (T.R
                                                                                                                                                                                                                                                                                          (T.Tuple2
                                                                                                                                                                                                                                                                                            (T.R
                                                                                                                                                                                                                                                                                              (T.Cons
                                                                                                                                                                                                                                                                                                (T.R
                                                                                                                                                                                                                                                                                                  ')'
                                                                                                                                                                                                                                                                                                  _)
                                                                                                                                                                                                                                                                                                (T.R
                                                                                                                                                                                                                                                                                                  T.List
                                                                                                                                                                                                                                                                                                  _))
                                                                                                                                                                                                                                                                                              _)
                                                                                                                                                                                                                                                                                            fw)
                                                                                                                                                                                                                                                                                          _)
                                                                                                                                                                                                                                                                                        p =
                                                                                                                                                                                                                                                                                        T.uap1
                                                                                                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                                                                                                          p
                                                                                                                                                                                                                                                                                          (T.pa1
                                                                                                                                                                                                                                                                                            T.Cons
                                                                                                                                                                                                                                                                                            T.cn1
                                                                                                                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                                                                                                                            p
                                                                                                                                                                                                                                                                                            T.aCons
                                                                                                                                                                                                                                                                                            (T.con2
                                                                                                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                                                                                                              p
                                                                                                                                                                                                                                                                                              T.Tuple2
                                                                                                                                                                                                                                                                                              T.aTuple2
                                                                                                                                                                                                                                                                                              (T.con9
                                                                                                                                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                                                                                                                                p
                                                                                                                                                                                                                                                                                                T.Tuple9
                                                                                                                                                                                                                                                                                                T.aTuple9
                                                                                                                                                                                                                                                                                                (T.projection
                                                                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                                                                                  fx1)
                                                                                                                                                                                                                                                                                                (T.projection
                                                                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                                                                                  fx2)
                                                                                                                                                                                                                                                                                                (T.projection
                                                                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                                                                                  fx3)
                                                                                                                                                                                                                                                                                                (T.projection
                                                                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                                                                                  fx4)
                                                                                                                                                                                                                                                                                                (T.projection
                                                                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                                                                                  fx5)
                                                                                                                                                                                                                                                                                                (T.projection
                                                                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                                                                                  fx6)
                                                                                                                                                                                                                                                                                                (T.projection
                                                                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                                                                                  fx7)
                                                                                                                                                                                                                                                                                                (T.projection
                                                                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                                                                                  fx8)
                                                                                                                                                                                                                                                                                                (T.projection
                                                                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                                                                                  fx9))
                                                                                                                                                                                                                                                                                              fw))
                                                                                                                                                                                                                                                                                          f_y
                                                                                                                                                                                                                                                                                      v0v0v0v0v1
                                                                                                                                                                                                                                                                                        _
                                                                                                                                                                                                                                                                                        p =
                                                                                                                                                                                                                                                                                        T.projection
                                                                                                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                                                                                                          p
                                                                                                                                                                                                                                                                                          f_y
                                                                                                                                                                                                                                                                                      in
                                                                                                                                                                                                                                                                                      (v0v0v0v0v1))
                                                                                                                                                                                                                                                                                    f_x))
                                                                                                                                                                                                                                                                              (T.uwrapForward
                                                                                                                                                                                                                                                                                p
                                                                                                                                                                                                                                                                                (hlex
                                                                                                                                                                                                                                                                                  fr9
                                                                                                                                                                                                                                                                                  p)))
                                                                                                                                                                                                                                                                            f_y
                                                                                                                                                                                                                                                                        v0v0v0v0v1
                                                                                                                                                                                                                                                                          _
                                                                                                                                                                                                                                                                          p =
                                                                                                                                                                                                                                                                          T.projection
                                                                                                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                                                                                                            p
                                                                                                                                                                                                                                                                            f_y
                                                                                                                                                                                                                                                                        in
                                                                                                                                                                                                                                                                        (v0v0v0v0v1))
                                                                                                                                                                                                                                                                      f_x))
                                                                                                                                                                                                                                                                (T.uap1
                                                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                                                  (greads
                                                                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                                                                    p)
                                                                                                                                                                                                                                                                  fs9))
                                                                                                                                                                                                                                                              f_y
                                                                                                                                                                                                                                                          v0v0v0v0v1
                                                                                                                                                                                                                                                            _
                                                                                                                                                                                                                                                            p =
                                                                                                                                                                                                                                                            T.projection
                                                                                                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                                                                                                              p
                                                                                                                                                                                                                                                              f_y
                                                                                                                                                                                                                                                          in
                                                                                                                                                                                                                                                          (v0v0v0v0v1))
                                                                                                                                                                                                                                                        f_x))
                                                                                                                                                                                                                                                  (T.uwrapForward
                                                                                                                                                                                                                                                    p
                                                                                                                                                                                                                                                    (hlex
                                                                                                                                                                                                                                                      fr8
                                                                                                                                                                                                                                                      p)))
                                                                                                                                                                                                                                                f_y
                                                                                                                                                                                                                                            v0v0v0v0v1
                                                                                                                                                                                                                                              _
                                                                                                                                                                                                                                              p =
                                                                                                                                                                                                                                              T.projection
                                                                                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                                                                                p
                                                                                                                                                                                                                                                f_y
                                                                                                                                                                                                                                            in
                                                                                                                                                                                                                                            (v0v0v0v0v1))
                                                                                                                                                                                                                                          f_x))
                                                                                                                                                                                                                                    (T.uap1
                                                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                                                      p
                                                                                                                                                                                                                                      (greads
                                                                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                                                                        p)
                                                                                                                                                                                                                                      fs8))
                                                                                                                                                                                                                                  f_y
                                                                                                                                                                                                                              v0v0v0v0v1
                                                                                                                                                                                                                                _
                                                                                                                                                                                                                                p =
                                                                                                                                                                                                                                T.projection
                                                                                                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                                                                                                  p
                                                                                                                                                                                                                                  f_y
                                                                                                                                                                                                                              in
                                                                                                                                                                                                                              (v0v0v0v0v1))
                                                                                                                                                                                                                            f_x))
                                                                                                                                                                                                                      (T.uwrapForward
                                                                                                                                                                                                                        p
                                                                                                                                                                                                                        (hlex
                                                                                                                                                                                                                          fr7
                                                                                                                                                                                                                          p)))
                                                                                                                                                                                                                    f_y
                                                                                                                                                                                                                v0v0v0v0v1
                                                                                                                                                                                                                  _
                                                                                                                                                                                                                  p =
                                                                                                                                                                                                                  T.projection
                                                                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                                                                    p
                                                                                                                                                                                                                    f_y
                                                                                                                                                                                                                in
                                                                                                                                                                                                                (v0v0v0v0v1))
                                                                                                                                                                                                              f_x))
                                                                                                                                                                                                        (T.uap1
                                                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                                                          p
                                                                                                                                                                                                          (greads
                                                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                                                            p)
                                                                                                                                                                                                          fs7))
                                                                                                                                                                                                      f_y
                                                                                                                                                                                                  v0v0v0v0v1
                                                                                                                                                                                                    _
                                                                                                                                                                                                    p =
                                                                                                                                                                                                    T.projection
                                                                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                                                                      p
                                                                                                                                                                                                      f_y
                                                                                                                                                                                                  in
                                                                                                                                                                                                  (v0v0v0v0v1))
                                                                                                                                                                                                f_x))
                                                                                                                                                                                          (T.uwrapForward
                                                                                                                                                                                            p
                                                                                                                                                                                            (hlex
                                                                                                                                                                                              fr6
                                                                                                                                                                                              p)))
                                                                                                                                                                                        f_y
                                                                                                                                                                                    v0v0v0v0v1
                                                                                                                                                                                      _
                                                                                                                                                                                      p =
                                                                                                                                                                                      T.projection
                                                                                                                                                                                        T.mkNoSrcPos
                                                                                                                                                                                        p
                                                                                                                                                                                        f_y
                                                                                                                                                                                    in
                                                                                                                                                                                    (v0v0v0v0v1))
                                                                                                                                                                                  f_x))
                                                                                                                                                                            (T.uap1
                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                              p
                                                                                                                                                                              (greads
                                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                                p)
                                                                                                                                                                              fs6))
                                                                                                                                                                          f_y
                                                                                                                                                                      v0v0v0v0v1
                                                                                                                                                                        _
                                                                                                                                                                        p =
                                                                                                                                                                        T.projection
                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                          p
                                                                                                                                                                          f_y
                                                                                                                                                                      in
                                                                                                                                                                      (v0v0v0v0v1))
                                                                                                                                                                    f_x))
                                                                                                                                                              (T.uwrapForward
                                                                                                                                                                p
                                                                                                                                                                (hlex
                                                                                                                                                                  fr5
                                                                                                                                                                  p)))
                                                                                                                                                            f_y
                                                                                                                                                        v0v0v0v0v1
                                                                                                                                                          _
                                                                                                                                                          p =
                                                                                                                                                          T.projection
                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                            p
                                                                                                                                                            f_y
                                                                                                                                                        in
                                                                                                                                                        (v0v0v0v0v1))
                                                                                                                                                      f_x))
                                                                                                                                                (T.uap1
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p
                                                                                                                                                  (greads
                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                    p)
                                                                                                                                                  fs5))
                                                                                                                                              f_y
                                                                                                                                          v0v0v0v0v1
                                                                                                                                            _
                                                                                                                                            p =
                                                                                                                                            T.projection
                                                                                                                                              T.mkNoSrcPos
                                                                                                                                              p
                                                                                                                                              f_y
                                                                                                                                          in
                                                                                                                                          (v0v0v0v0v1))
                                                                                                                                        f_x))
                                                                                                                                  (T.uwrapForward
                                                                                                                                    p
                                                                                                                                    (hlex
                                                                                                                                      fr4
                                                                                                                                      p)))
                                                                                                                                f_y
                                                                                                                            v0v0v0v0v1
                                                                                                                              _
                                                                                                                              p =
                                                                                                                              T.projection
                                                                                                                                T.mkNoSrcPos
                                                                                                                                p
                                                                                                                                f_y
                                                                                                                            in
                                                                                                                            (v0v0v0v0v1))
                                                                                                                          f_x))
                                                                                                                    (T.uap1
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p
                                                                                                                      (greads
                                                                                                                        T.mkNoSrcPos
                                                                                                                        p)
                                                                                                                      fs4))
                                                                                                                  f_y
                                                                                                              v0v0v0v0v1
                                                                                                                _
                                                                                                                p =
                                                                                                                T.projection
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  f_y
                                                                                                              in
                                                                                                              (v0v0v0v0v1))
                                                                                                            f_x))
                                                                                                      (T.uwrapForward
                                                                                                        p
                                                                                                        (hlex
                                                                                                          fr3
                                                                                                          p)))
                                                                                                    f_y
                                                                                                v0v0v0v0v1
                                                                                                  _
                                                                                                  p =
                                                                                                  T.projection
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    f_y
                                                                                                in
                                                                                                (v0v0v0v0v1))
                                                                                              f_x))
                                                                                        (T.uap1
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (greads
                                                                                            T.mkNoSrcPos
                                                                                            p)
                                                                                          fs3))
                                                                                      f_y
                                                                                  v0v0v0v0v1
                                                                                    _
                                                                                    p =
                                                                                    T.projection
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      f_y
                                                                                  in
                                                                                  (v0v0v0v0v1))
                                                                                f_x))
                                                                          (T.uwrapForward
                                                                            p
                                                                            (hlex
                                                                              fr2
                                                                              p)))
                                                                        f_y
                                                                    v0v0v0v0v1 _
                                                                      p =
                                                                      T.projection
                                                                        T.mkNoSrcPos
                                                                        p f_y in
                                                                    (v0v0v0v0v1))
                                                                  f_x))
                                                            (T.uap1 T.mkNoSrcPos
                                                              p
                                                              (greads
                                                                T.mkNoSrcPos p)
                                                              fs2)) f_y
                                                      v0v0v0v0v1 _ p =
                                                        T.projection
                                                          T.mkNoSrcPos p f_y in
                                                      (v0v0v0v0v1)) f_x))
                                              (T.uwrapForward p (hlex fr1 p)))
                                            f_y
                                        v0v0v0v0v1 _ p =
                                          T.projection T.mkNoSrcPos p f_y in
                                        (v0v0v0v0v1)) f_x))
                                (T.uap1 T.mkNoSrcPos p (greads T.mkNoSrcPos p)
                                  fs1)) f_y
                          v0v0v0v0v1 _ p = T.projection T.mkNoSrcPos p f_y in
                          (v0v0v0v0v1)) f_x)) (T.uwrapForward p (hlex fr0 p)))
                (T.fromExpList T.mkNoSrcPos p []))) p)
    
  

instance
  (Read a,Read b,Read c,Read d,Read e,Read f,Read g,Read h,Read i,Read j) =>
    Read ((T.Tuple10 a b c d e f g h i j))
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a2136v5v2137v30readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fp p =
      T.uwrapForward p
        (hreadParen (T.con0 T.mkNoSrcPos p False aFalse)
          (T.ufun1 T.mkLambda T.mkNoSrcPos p
            (\ fr0 p ->
              T.uap1 T.mkNoSrcPos p
                (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                  (T.ufun2 T.mkLambda T.mkNoSrcPos p
                    (\ f_x f_y p ->
                      T.uccase T.mkNoSrcPos p
                        (let
                          v0v0v0v0v1
                            (T.R
                              (T.Tuple2
                                (T.R (T.Cons (T.R '(' _) (T.R T.List _)) _) fs1)
                              _) p =
                            T.uap1 T.mkNoSrcPos p
                              (T.uap2 T.mkNoSrcPos p (g_foldr T.mkNoSrcPos p)
                                (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                  (\ f_x f_y p ->
                                    T.uccase T.mkNoSrcPos p
                                      (let
                                        v0v0v0v0v1 (T.R (T.Tuple2 fx1 fr1) _)
                                          p =
                                          T.uap1 T.mkNoSrcPos p
                                            (T.uap2 T.mkNoSrcPos p
                                              (g_foldr T.mkNoSrcPos p)
                                              (T.ufun2 T.mkLambda T.mkNoSrcPos p
                                                (\ f_x f_y p ->
                                                  T.uccase T.mkNoSrcPos p
                                                    (let
                                                      v0v0v0v0v1
                                                        (T.R
                                                          (T.Tuple2
                                                            (T.R
                                                              (T.Cons
                                                                (T.R ',' _)
                                                                (T.R T.List _))
                                                              _) fs2) _) p =
                                                        T.uap1 T.mkNoSrcPos p
                                                          (T.uap2 T.mkNoSrcPos p
                                                            (g_foldr
                                                              T.mkNoSrcPos p)
                                                            (T.ufun2 T.mkLambda
                                                              T.mkNoSrcPos p
                                                              (\ f_x f_y p ->
                                                                T.uccase
                                                                  T.mkNoSrcPos p
                                                                  (let
                                                                    v0v0v0v0v1
                                                                      (T.R
                                                                        (T.Tuple2
                                                                          fx2
                                                                          fr2)
                                                                        _) p =
                                                                      T.uap1
                                                                        T.mkNoSrcPos
                                                                        p
                                                                        (T.uap2
                                                                          T.mkNoSrcPos
                                                                          p
                                                                          (g_foldr
                                                                            T.mkNoSrcPos
                                                                            p)
                                                                          (T.ufun2
                                                                            T.mkLambda
                                                                            T.mkNoSrcPos
                                                                            p
                                                                            (\ f_x
                                                                              f_y
                                                                              p ->
                                                                              T.uccase
                                                                                T.mkNoSrcPos
                                                                                p
                                                                                (let
                                                                                  v0v0v0v0v1
                                                                                    (T.R
                                                                                      (T.Tuple2
                                                                                        (T.R
                                                                                          (T.Cons
                                                                                            (T.R
                                                                                              ','
                                                                                              _)
                                                                                            (T.R
                                                                                              T.List
                                                                                              _))
                                                                                          _)
                                                                                        fs3)
                                                                                      _)
                                                                                    p =
                                                                                    T.uap1
                                                                                      T.mkNoSrcPos
                                                                                      p
                                                                                      (T.uap2
                                                                                        T.mkNoSrcPos
                                                                                        p
                                                                                        (g_foldr
                                                                                          T.mkNoSrcPos
                                                                                          p)
                                                                                        (T.ufun2
                                                                                          T.mkLambda
                                                                                          T.mkNoSrcPos
                                                                                          p
                                                                                          (\ f_x
                                                                                            f_y
                                                                                            p ->
                                                                                            T.uccase
                                                                                              T.mkNoSrcPos
                                                                                              p
                                                                                              (let
                                                                                                v0v0v0v0v1
                                                                                                  (T.R
                                                                                                    (T.Tuple2
                                                                                                      fx3
                                                                                                      fr3)
                                                                                                    _)
                                                                                                  p =
                                                                                                  T.uap1
                                                                                                    T.mkNoSrcPos
                                                                                                    p
                                                                                                    (T.uap2
                                                                                                      T.mkNoSrcPos
                                                                                                      p
                                                                                                      (g_foldr
                                                                                                        T.mkNoSrcPos
                                                                                                        p)
                                                                                                      (T.ufun2
                                                                                                        T.mkLambda
                                                                                                        T.mkNoSrcPos
                                                                                                        p
                                                                                                        (\ f_x
                                                                                                          f_y
                                                                                                          p ->
                                                                                                          T.uccase
                                                                                                            T.mkNoSrcPos
                                                                                                            p
                                                                                                            (let
                                                                                                              v0v0v0v0v1
                                                                                                                (T.R
                                                                                                                  (T.Tuple2
                                                                                                                    (T.R
                                                                                                                      (T.Cons
                                                                                                                        (T.R
                                                                                                                          ','
                                                                                                                          _)
                                                                                                                        (T.R
                                                                                                                          T.List
                                                                                                                          _))
                                                                                                                      _)
                                                                                                                    fs4)
                                                                                                                  _)
                                                                                                                p =
                                                                                                                T.uap1
                                                                                                                  T.mkNoSrcPos
                                                                                                                  p
                                                                                                                  (T.uap2
                                                                                                                    T.mkNoSrcPos
                                                                                                                    p
                                                                                                                    (g_foldr
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p)
                                                                                                                    (T.ufun2
                                                                                                                      T.mkLambda
                                                                                                                      T.mkNoSrcPos
                                                                                                                      p
                                                                                                                      (\ f_x
                                                                                                                        f_y
                                                                                                                        p ->
                                                                                                                        T.uccase
                                                                                                                          T.mkNoSrcPos
                                                                                                                          p
                                                                                                                          (let
                                                                                                                            v0v0v0v0v1
                                                                                                                              (T.R
                                                                                                                                (T.Tuple2
                                                                                                                                  fx4
                                                                                                                                  fr4)
                                                                                                                                _)
                                                                                                                              p =
                                                                                                                              T.uap1
                                                                                                                                T.mkNoSrcPos
                                                                                                                                p
                                                                                                                                (T.uap2
                                                                                                                                  T.mkNoSrcPos
                                                                                                                                  p
                                                                                                                                  (g_foldr
                                                                                                                                    T.mkNoSrcPos
                                                                                                                                    p)
                                                                                                                                  (T.ufun2
                                                                                                                                    T.mkLambda
                                                                                                                                    T.mkNoSrcPos
                                                                                                                                    p
                                                                                                                                    (\ f_x
                                                                                                                                      f_y
                                                                                                                                      p ->
                                                                                                                                      T.uccase
                                                                                                                                        T.mkNoSrcPos
                                                                                                                                        p
                                                                                                                                        (let
                                                                                                                                          v0v0v0v0v1
                                                                                                                                            (T.R
                                                                                                                                              (T.Tuple2
                                                                                                                                                (T.R
                                                                                                                                                  (T.Cons
                                                                                                                                                    (T.R
                                                                                                                                                      ','
                                                                                                                                                      _)
                                                                                                                                                    (T.R
                                                                                                                                                      T.List
                                                                                                                                                      _))
                                                                                                                                                  _)
                                                                                                                                                fs5)
                                                                                                                                              _)
                                                                                                                                            p =
                                                                                                                                            T.uap1
                                                                                                                                              T.mkNoSrcPos
                                                                                                                                              p
                                                                                                                                              (T.uap2
                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                p
                                                                                                                                                (g_foldr
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p)
                                                                                                                                                (T.ufun2
                                                                                                                                                  T.mkLambda
                                                                                                                                                  T.mkNoSrcPos
                                                                                                                                                  p
                                                                                                                                                  (\ f_x
                                                                                                                                                    f_y
                                                                                                                                                    p ->
                                                                                                                                                    T.uccase
                                                                                                                                                      T.mkNoSrcPos
                                                                                                                                                      p
                                                                                                                                                      (let
                                                                                                                                                        v0v0v0v0v1
                                                                                                                                                          (T.R
                                                                                                                                                            (T.Tuple2
                                                                                                                                                              fx5
                                                                                                                                                              fr5)
                                                                                                                                                            _)
                                                                                                                                                          p =
                                                                                                                                                          T.uap1
                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                            p
                                                                                                                                                            (T.uap2
                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                              p
                                                                                                                                                              (g_foldr
                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                p)
                                                                                                                                                              (T.ufun2
                                                                                                                                                                T.mkLambda
                                                                                                                                                                T.mkNoSrcPos
                                                                                                                                                                p
                                                                                                                                                                (\ f_x
                                                                                                                                                                  f_y
                                                                                                                                                                  p ->
                                                                                                                                                                  T.uccase
                                                                                                                                                                    T.mkNoSrcPos
                                                                                                                                                                    p
                                                                                                                                                                    (let
                                                                                                                                                                      v0v0v0v0v1
                                                                                                                                                                        (T.R
                                                                                                                                                                          (T.Tuple2
                                                                                                                                                                            (T.R
                                                                                                                                                                              (T.Cons
                                                                                                                                                                                (T.R
                                                                                                                                                                                  ','
                                                                                                                                                                                  _)
                                                                                                                                                                                (T.R
                                                                                                                                                                                  T.List
                                                                                                                                                                                  _))
                                                                                                                                                                              _)
                                                                                                                                                                            fs6)
                                                                                                                                                                          _)
                                                                                                                                                                        p =
                                                                                                                                                                        T.uap1
                                                                                                                                                                          T.mkNoSrcPos
                                                                                                                                                                          p
                                                                                                                                                                          (T.uap2
                                                                                                                                                                            T.mkNoSrcPos
                                                                                                                                                                            p
                                                                                                                                                                            (g_foldr
                                                                                                                                                                              T.mkNoSrcPos
                                                                                                                                                                              p)
                                                                                                                                                                            (T.ufun2
    