/*
 * Copyright (c) 2005, The haXe Project Contributors
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   - Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   - Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HAXE PROJECT CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE HAXE PROJECT CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/**
	The basic String class.
**/
extern class String {

	/**
		The number of characters in the String.
	**/
	var length(default,null) : Int;

	function new(string:String) : Void;

	/**
		Returns an String where all characters have been uppercased.
	**/
	function toUpperCase() : String;

	/**
		Returns an String where all characters have been lowercased.
	**/
	function toLowerCase() : String;

	/**
		Returns the character at the given [index].
		Returns the empty String if
	**/
	function charAt( index : Int) : String;
	function charCodeAt( index : Int) : Int;

	/**
		Returns the index of first occurence of [value]
		If [value] is not found, will return -1
		The optional [startIndex] parameter allows you to specify which character to start searching. The position returned is still relative to the beginning of the string.
	**/
	function indexOf( value : String, ?startIndex : Int ) : Int;
	function lastIndexOf( value : String, startIndex : Int ) : Int;
	function split( delimiter : String ) : Array<String>;
	function substr( pos : Int, len : Int ) : String;

	function toString() : String;

}
