#! /bin/sh
#
# Copyright by The HDF Group.
# Copyright by the Board of Trustees of the University of Illinois.
# All rights reserved.
#
# This file is part of HDF5.  The full HDF5 copyright notice, including
# terms governing use, modification, and redistribution, is contained in
# the files COPYING and Copyright.html.  COPYING can be found at the root
# of the source code distribution tree; Copyright.html can be found at the
# root level of an installed copy of the electronic HDF5 document set and
# is linked from the top-level documents page.  It can also be found at
# http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have
# access to either file, you may request a copy from help@hdfgroup.org.
#
# Tests for the h5dump tool

DUMPER=h5dump               # The tool name
DUMPER_BIN=`pwd`/$DUMPER    # The path of the tool binary

CMP='cmp -s'
DIFF='diff -c'

nerrors=0
verbose=yes

# The build (current) directory might be different than the source directory.
if test -z "$srcdir"; then
   srcdir=.
fi

test -d ../testfiles || mkdir ../testfiles

# Print a line-line message left justified in a field of 70 characters
# beginning with the word "Testing".
#
TESTING() {
   SPACES="                                                               "
   echo "Testing $* $SPACES" | cut -c1-70 | tr -d '\012'
}

# Run a test and print PASS or *FAIL*.  If a test fails then increment
# the `nerrors' global variable and (if $verbose is set) display the
# difference between the actual output and the expected output. The
# expected output is given as the first argument to this function and
# the actual output file is calculated by replacing the `.ddl' with
# `.out'.  The actual output is not removed if $HDF5_NOCLEANUP has a
# non-zero value.
#
TOOLTEST() {
   expect="$srcdir/../testfiles/$1"
   actual="../testfiles/`basename $1 .ddl`.out"
   actual_err="../testfiles/`basename $1 .ddl`.err"
   shift

   # Run test.
   TESTING $DUMPER $@
   (
      echo "#############################"
      echo "Expected output for '$DUMPER $@'" 
      echo "#############################"
      cd $srcdir/../testfiles
      $RUNSERIAL $DUMPER_BIN $@
   ) >$actual 2>$actual_err
   cat $actual_err >> $actual


   if [ ! -f $expect ]; then
    # Create the expect file if it doesn't yet exist.
    echo " CREATED"
     cp $actual $expect		  
   elif  $CMP $expect $actual; then
      echo " PASSED"
   else
      echo "*FAILED*"
      echo "    Expected result (*.ddl) differs from actual result (*.out)"
      nerrors="`expr $nerrors + 1`"
      test yes = "$verbose" && $DIFF $expect $actual |sed 's/^/    /'
   fi

   # Clean up output file
   if test -z "$HDF5_NOCLEANUP"; then
      rm -f $actual $actual_err
   fi
}

##############################################################################
##############################################################################
###			  T H E   T E S T S                                ###
##############################################################################
##############################################################################

# test XML
TOOLTEST tall.h5.xml --xml tall.h5
TOOLTEST tattr.h5.xml --xml tattr.h5
TOOLTEST tbitfields.h5.xml --xml tbitfields.h5
TOOLTEST tcompound.h5.xml --xml tcompound.h5
TOOLTEST tcompound2.h5.xml --xml tcompound2.h5
TOOLTEST tdatareg.h5.xml --xml tdatareg.h5
TOOLTEST tdset.h5.xml --xml tdset.h5
TOOLTEST tdset2.h5.xml --xml tdset2.h5
TOOLTEST tenum.h5.xml --xml tenum.h5
TOOLTEST tgroup.h5.xml --xml tgroup.h5
TOOLTEST thlink.h5.xml --xml thlink.h5
TOOLTEST tloop.h5.xml --xml tloop.h5
TOOLTEST tloop2.h5.xml --xml tloop2.h5
TOOLTEST tmany.h5.xml --xml tmany.h5
TOOLTEST tnestedcomp.h5.xml --xml tnestedcomp.h5
TOOLTEST tcompound_complex.h5.xml --xml tcompound_complex.h5
TOOLTEST tobjref.h5.xml --xml tobjref.h5
TOOLTEST topaque.h5.xml --xml topaque.h5
TOOLTEST tslink.h5.xml --xml tslink.h5
TOOLTEST tstr.h5.xml --xml tstr.h5
TOOLTEST tstr2.h5.xml --xml tstr2.h5
TOOLTEST tref.h5.xml --xml tref.h5
TOOLTEST tname-amp.h5.xml --xml tname-amp.h5
TOOLTEST tname-apos.h5.xml --xml tname-apos.h5
TOOLTEST tname-gt.h5.xml --xml tname-gt.h5
TOOLTEST tname-lt.h5.xml --xml tname-lt.h5
TOOLTEST tname-quot.h5.xml --xml tname-quot.h5
TOOLTEST tname-sp.h5.xml --xml tname-sp.h5
TOOLTEST tstring.h5.xml --xml tstring.h5
TOOLTEST tstring-at.h5.xml --xml tstring-at.h5
TOOLTEST tref-escapes.h5.xml --xml tref-escapes.h5
TOOLTEST tref-escapes-at.h5.xml --xml tref-escapes-at.h5
TOOLTEST tnodata.h5.xml --xml tnodata.h5
TOOLTEST tarray1.h5.xml --xml tarray1.h5
TOOLTEST tarray2.h5.xml --xml tarray2.h5
TOOLTEST tarray3.h5.xml --xml tarray3.h5
TOOLTEST tarray6.h5.xml --xml tarray6.h5
TOOLTEST tarray7.h5.xml --xml tarray7.h5
TOOLTEST tvldtypes1.h5.xml --xml tvldtypes1.h5
TOOLTEST tvldtypes2.h5.xml --xml tvldtypes2.h5
TOOLTEST tvldtypes3.h5.xml --xml tvldtypes3.h5
TOOLTEST tvldtypes4.h5.xml --xml tvldtypes4.h5
TOOLTEST tvldtypes5.h5.xml --xml tvldtypes5.h5
TOOLTEST tvlstr.h5.xml --xml tvlstr.h5
TOOLTEST tsaf.h5.xml --xml tsaf.h5
TOOLTEST tempty.h5.xml --xml tempty.h5
TOOLTEST tnamed_dtype_attr.h5.xml --xml tnamed_dtype_attr.h5

# other options for xml

TOOLTEST tempty-dtd.h5.xml --xml --use-dtd tempty.h5
TOOLTEST tempty-dtd-2.h5.xml --xml -u tempty.h5
TOOLTEST tempty-nons.h5.xml --xml -X ":" tempty.h5
TOOLTEST tempty-nons-2.h5.xml --xml --xml-ns=":" tempty.h5

## Some of these combinations are syntactically correct but
##  the URLs are dummies 
TOOLTEST tempty-ns.h5.xml --xml -X "thing:" tempty.h5
TOOLTEST tempty-ns-2.h5.xml --xml --xml-ns="thing:" tempty.h5
TOOLTEST tempty-nons-uri.h5.xml --xml --xml-ns=":" --xml-dtd="http://somewhere.net" tempty.h5
TOOLTEST tempty-dtd-uri.h5.xml --xml --use-dtd --xml-dtd="http://somewhere.net" tempty.h5

TOOLTEST tall-2A.h5.xml --xml -A tall.h5


if test $nerrors -eq 0 ; then
   echo "All $DUMPER tests passed."
fi

exit $nerrors
