/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.algorithm.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import nom.tam.fits.compression.algorithm.api.ICompressor;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.ByteBufferInputStream;
import nom.tam.util.ByteBufferOutputStream;
import nom.tam.util.SaveClose;
import nom.tam.util.type.PrimitiveType;
import nom.tam.util.type.PrimitiveTypeHandler;
import nom.tam.util.type.PrimitiveTypes;

public abstract class GZipCompressor<T extends Buffer>
implements ICompressor<T> {
    private static final int DEFAULT_GZIP_BUFFER_SIZE = 65536;
    protected final int primitiveSize;
    protected byte[] buffer = new byte[65536];
    protected T nioBuffer;
    private final byte[] sizeArray = new byte[PrimitiveTypes.INT.size()];
    private final IntBuffer sizeBuffer = ByteBuffer.wrap(this.sizeArray).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();

    public GZipCompressor(int primitiveSize) {
        this.primitiveSize = primitiveSize;
    }

    @Override
    public boolean compress(T pixelData, ByteBuffer compressed) {
        ((Buffer)this.nioBuffer).rewind();
        int pixelDataLimit = ((Buffer)pixelData).limit();
        GZIPOutputStream zip = null;
        try {
            zip = this.createGZipOutputStream(pixelDataLimit, compressed);
            while (((Buffer)pixelData).hasRemaining()) {
                int count = Math.min(((Buffer)pixelData).remaining(), ((Buffer)this.nioBuffer).capacity());
                ((Buffer)pixelData).limit(((Buffer)pixelData).position() + count);
                this.getPixel(pixelData, null);
                zip.write(this.buffer, 0, ((Buffer)this.nioBuffer).position() * this.primitiveSize);
                ((Buffer)this.nioBuffer).rewind();
                ((Buffer)pixelData).limit(pixelDataLimit);
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("could not gzip data", e);
            }
            catch (Throwable throwable) {
                SaveClose.close(zip);
                throw throwable;
            }
        }
        SaveClose.close(zip);
        compressed.limit(compressed.position());
        return true;
    }

    @Override
    public void decompress(ByteBuffer compressed, T pixelData) {
        ((Buffer)this.nioBuffer).rewind();
        TypeConversion<Buffer> typeConverter = this.getTypeConverter(compressed, ((Buffer)pixelData).limit());
        GZIPInputStream zip = null;
        try {
            int count;
            zip = this.createGZipInputStream(compressed);
            while ((count = zip.read(this.buffer)) >= 0) {
                if (typeConverter != null) {
                    count = typeConverter.copy(count);
                }
                ((Buffer)this.nioBuffer).position(0);
                ((Buffer)this.nioBuffer).limit(count / this.primitiveSize);
                this.setPixel(pixelData, null);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("could not gunzip data", e);
        }
        finally {
            SaveClose.close(zip);
        }
    }

    private <B extends Buffer> PrimitiveType<B> getPrimitiveType(int size) {
        return PrimitiveTypeHandler.valueOf(size * 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeConversion<Buffer> getTypeConverter(ByteBuffer compressed, int nrOfPrimitiveElements) {
        if (compressed.limit() > 4) {
            int oldPosition = compressed.position();
            try {
                compressed.position(compressed.limit() - this.sizeArray.length);
                compressed.get(this.sizeArray);
                int uncompressedSize = this.sizeBuffer.get(0);
                if (uncompressedSize > 0) {
                    int compressedPrimitiveSize;
                    compressed.position(oldPosition);
                    if (uncompressedSize % nrOfPrimitiveElements == 0 && (compressedPrimitiveSize = uncompressedSize / nrOfPrimitiveElements) != this.primitiveSize) {
                        TypeConversion<Buffer> typeConversion = new TypeConversion<Buffer>(this.getPrimitiveType(compressedPrimitiveSize));
                        return typeConversion;
                    }
                }
            }
            finally {
                compressed.position(oldPosition);
            }
        }
        return null;
    }

    protected GZIPInputStream createGZipInputStream(ByteBuffer compressed) throws IOException {
        return new GZIPInputStream((InputStream)new ByteBufferInputStream(compressed), Math.min(compressed.limit() * 2, 65536));
    }

    protected GZIPOutputStream createGZipOutputStream(int length, ByteBuffer compressed) throws IOException {
        return new GZIPOutputStream((OutputStream)new ByteBufferOutputStream(compressed), Math.min(length * 2, 65536));
    }

    protected abstract void getPixel(T var1, byte[] var2);

    protected abstract void setPixel(T var1, byte[] var2);

    private final class TypeConversion<B extends Buffer> {
        private final PrimitiveType<B> from;
        private final PrimitiveType<T> to;
        private final B fromBuffer;
        private final T toBuffer;
        private final Object fromArray;
        private final Object toArray;

        private TypeConversion(PrimitiveType<B> from) {
            this.from = from;
            this.to = GZipCompressor.this.getPrimitiveType(GZipCompressor.this.primitiveSize);
            this.toBuffer = GZipCompressor.this.nioBuffer;
            this.fromBuffer = from.asTypedBuffer(ByteBuffer.wrap(GZipCompressor.this.buffer));
            this.fromArray = from.newArray(65536 / from.size());
            this.toArray = this.to.newArray(65536 / this.to.size());
        }

        int copy(int byteCount) {
            ((Buffer)this.fromBuffer).rewind();
            ((Buffer)this.toBuffer).rewind();
            this.from.getArray(this.fromBuffer, this.fromArray);
            ArrayFuncs.copyInto(this.fromArray, this.toArray);
            this.to.putArray(this.toBuffer, this.toArray);
            return byteCount * this.to.size() / this.from.size();
        }
    }

    public static class ShortGZipCompressor
    extends GZipCompressor<ShortBuffer> {
        protected static final int BYTE_SIZE_OF_SHORT = 2;

        public ShortGZipCompressor() {
            super(2);
            this.nioBuffer = ByteBuffer.wrap(this.buffer).asShortBuffer();
        }

        @Override
        protected void getPixel(ShortBuffer pixelData, byte[] pixelBytes) {
            ((ShortBuffer)this.nioBuffer).put(pixelData);
        }

        @Override
        protected void setPixel(ShortBuffer pixelData, byte[] pixelBytes) {
            pixelData.put((ShortBuffer)this.nioBuffer);
        }
    }

    public static class LongGZipCompressor
    extends GZipCompressor<LongBuffer> {
        protected static final int BYTE_SIZE_OF_LONG = 8;

        public LongGZipCompressor() {
            super(8);
            this.nioBuffer = ByteBuffer.wrap(this.buffer).asLongBuffer();
        }

        @Override
        protected void getPixel(LongBuffer pixelData, byte[] pixelBytes) {
            ((LongBuffer)this.nioBuffer).put(pixelData);
        }

        @Override
        protected void setPixel(LongBuffer pixelData, byte[] pixelBytes) {
            pixelData.put((LongBuffer)this.nioBuffer);
        }
    }

    public static class IntGZipCompressor
    extends GZipCompressor<IntBuffer> {
        protected static final int BYTE_SIZE_OF_INT = 4;

        public IntGZipCompressor() {
            super(4);
            this.nioBuffer = ByteBuffer.wrap(this.buffer).asIntBuffer();
        }

        @Override
        protected void getPixel(IntBuffer pixelData, byte[] pixelBytes) {
            ((IntBuffer)this.nioBuffer).put(pixelData);
        }

        @Override
        protected void setPixel(IntBuffer pixelData, byte[] pixelBytes) {
            pixelData.put((IntBuffer)this.nioBuffer);
        }
    }

    public static class FloatGZipCompressor
    extends GZipCompressor<FloatBuffer> {
        protected static final int BYTE_SIZE_OF_FLOAT = 4;

        public FloatGZipCompressor() {
            super(4);
            this.nioBuffer = ByteBuffer.wrap(this.buffer).asFloatBuffer();
        }

        @Override
        protected void getPixel(FloatBuffer pixelData, byte[] pixelBytes) {
            ((FloatBuffer)this.nioBuffer).put(pixelData);
        }

        @Override
        protected void setPixel(FloatBuffer pixelData, byte[] pixelBytes) {
            pixelData.put((FloatBuffer)this.nioBuffer);
        }
    }

    public static class DoubleGZipCompressor
    extends GZipCompressor<DoubleBuffer> {
        protected static final int BYTE_SIZE_OF_DOUBLE = 8;

        public DoubleGZipCompressor() {
            super(8);
            this.nioBuffer = ByteBuffer.wrap(this.buffer).asDoubleBuffer();
        }

        @Override
        protected void getPixel(DoubleBuffer pixelData, byte[] pixelBytes) {
            ((DoubleBuffer)this.nioBuffer).put(pixelData);
        }

        @Override
        protected void setPixel(DoubleBuffer pixelData, byte[] pixelBytes) {
            pixelData.put((DoubleBuffer)this.nioBuffer);
        }
    }

    public static class ByteGZipCompressor
    extends GZipCompressor<ByteBuffer> {
        public ByteGZipCompressor() {
            super(1);
            this.nioBuffer = ByteBuffer.wrap(this.buffer);
        }

        @Override
        protected void getPixel(ByteBuffer pixelData, byte[] pixelBytes) {
            ((ByteBuffer)this.nioBuffer).put(pixelData);
        }

        @Override
        protected void setPixel(ByteBuffer pixelData, byte[] pixelBytes) {
            pixelData.put((ByteBuffer)this.nioBuffer);
        }
    }
}

