/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import nom.tam.fits.header.Checksum;
import nom.tam.fits.header.FitsHeaderImpl;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;

public enum Compression implements IFitsHeader
{
    ZIMAGE(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.LOGICAL, ""),
    ZCMPTYPE(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, ""),
    ZBITPIX(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "", Standard.BITPIX),
    ZNAXIS(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "", Standard.NAXIS),
    ZNAXISn(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "", Standard.NAXISn),
    ZTILEn(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, ""),
    ZNAMEn(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, ""),
    ZVALn(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.ANY, ""),
    ZMASKCMP(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, ""),
    ZSIMPLE(IFitsHeader.HDU.PRIMARY, IFitsHeader.VALUE.LOGICAL, "", Standard.SIMPLE),
    ZTENSION(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "", Standard.XTENSION),
    ZEXTEND(IFitsHeader.HDU.PRIMARY, IFitsHeader.VALUE.LOGICAL, "", Standard.EXTEND),
    ZBLOCKED(IFitsHeader.HDU.PRIMARY, IFitsHeader.VALUE.LOGICAL, "", Standard.BLOCKED),
    ZPCOUNT(IFitsHeader.HDU.EXTENSION, IFitsHeader.VALUE.INTEGER, "", Standard.PCOUNT),
    ZGCOUNT(IFitsHeader.HDU.EXTENSION, IFitsHeader.VALUE.INTEGER, "", Standard.GCOUNT),
    ZHECKSUM(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "", Checksum.CHECKSUM),
    ZDATASUM(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "", Checksum.DATASUM),
    ZQUANTIZ(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, ""),
    ZDITHER0(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, ""),
    ZBLANK(IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "");

    public static final String ZQUANTIZ_NO_DITHER = "NO_DITHER";
    public static final String ZQUANTIZ_SUBTRACTIVE_DITHER_1 = "SUBTRACTIVE_DITHER_1";
    public static final String ZQUANTIZ_SUBTRACTIVE_DITHER_2 = "SUBTRACTIVE_DITHER_2";
    public static final String ZCMPTYPE_GZIP_1 = "GZIP_1";
    public static final String ZCMPTYPE_GZIP_2 = "GZIP_2";
    public static final String ZCMPTYPE_RICE_1 = "RICE_1";
    public static final String ZCMPTYPE_PLIO_1 = "PLIO_1";
    public static final String ZCMPTYPE_HCOMPRESS_1 = "HCOMPRESS_1";
    public static final String ZCMPTYPE_RICE_ONE = "RICE_ONE";
    public static final String COMPRESSED_DATA_COLUMN = "COMPRESSED_DATA";
    public static final String GZIP_COMPRESSED_DATA_COLUMN = "GZIP_COMPRESSED_DATA";
    public static final String UNCOMPRESSED_DATA_COLUMN = "UNCOMPRESSED_DATA";
    public static final String ZBLANK_COLUMN = "ZBLANK";
    public static final String ZZERO_COLUMN = "ZZERO";
    public static final String ZSCALE_COLUMN = "ZSCALE";
    public static final String NULL_PIXEL_MASK_COLUMN = "NULL_PIXEL_MASK_COLUMN";
    public static final String BYTEPIX = "BYTEPIX";
    public static final String BLOCKSIZE = "BLOCKSIZE";
    public static final String SCALE = "SCALE";
    public static final String SMOOTH = "SMOOTH";
    private final IFitsHeader key;
    private final IFitsHeader uncompressedKey;

    private Compression(IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment) {
        this(hdu, valueType, comment, null);
    }

    private Compression(IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment, IFitsHeader uncompressedKey) {
        this.key = new FitsHeaderImpl(this.name(), IFitsHeader.SOURCE.HEASARC, hdu, valueType, comment);
        this.uncompressedKey = uncompressedKey;
    }

    @Override
    public String comment() {
        return this.key.comment();
    }

    public IFitsHeader getUncompressedKey() {
        return this.uncompressedKey;
    }

    @Override
    public IFitsHeader.HDU hdu() {
        return this.key.hdu();
    }

    @Override
    public String key() {
        return this.key.key();
    }

    @Override
    public IFitsHeader n(int ... number) {
        return this.key.n(number);
    }

    @Override
    public IFitsHeader.SOURCE status() {
        return this.key.status();
    }

    @Override
    public IFitsHeader.VALUE valueType() {
        return this.key.valueType();
    }
}

