#!/bin/bash
#
# Copyright (C) 2004 Andrew Beekhof <andrew@beekhof.net>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

required_nodes=2
testdir=/usr/lib/heartbeat/crmtest
. ${testdir}/helper.sh || exit 1

CRM_ERR_SHUTDOWN=0
test_nodes=2

while [ $iteration -lt $repeats ]; do
    iteration=`expr $iteration + 1`
    echo -ne "\033]0;$test_type : Iteration $iteration of $repeats\007"
    echo "########### Begining iteration $iteration of $repeats ###########"
(
# make *sure* theres nothing left over from last time
crm-cleanup

#----

start_node $test_node_1

#----

do_cmd echo "Analyse CRMd startup"
do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search  -a -m 1500 \
    -s "crmd(.*) State transition (.*) \-> S_IDLE"
cts_assert "CRMd startup on ${test_node_1} failed."

do_cmd wait_for_state S_IDLE 3 $test_node_1 
cts_assert "S_IDLE not reached on $test_node_1 (startup)!"

#----

do_cmd echo Various sanity checks - stage 1

do_cmd is_running rsc1 $test_node_1
cts_assert_false "rsc1 IS running"

do_cmd is_running rsc2 $test_node_1
cts_assert_false "rsc2 IS running"

do_cmd is_dc $test_node_1
cts_assert "$test_node_1 is supposed to be the DC"

#----

start_node $test_node_2

#----

do_cmd echo "Analyse CRMd startup"
do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search -a -m 2500 \
    -s "${test_node_1} crmd(.*) State transition(.*) \-> S_IDLE" \
    -s "${test_node_2} crmd(.*) State transition S_PENDING \-> S_NOT_DC" 
cts_assert "CRMd on ${test_node_2} did not join the cluster."

#----

do_cmd echo Various sanity checks - stage 2
do_cmd wait_for_state S_IDLE 3 $test_node_1 
cts_assert "S_IDLE not reached on $test_node_1"

do_cmd is_running rsc1 $test_node_1
cts_assert_false "rsc1 IS running"

do_cmd is_running rsc2 $test_node_1
cts_assert_false "rsc2 IS running"

do_cmd is_dc $test_node_1
cts_assert "$test_node_1 is supposed to be the DC"

#----

stop_node $test_node_1 crmd

do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search -a -m 5000 \
    -s "${test_node_2} crmd(.*) State transition (.*) \-> S_ELECTION" \
    -s "${test_node_1} crmd(.*) State transition (.*) \-> S_NOT_DC"
cts_assert "Transition of the DC from ${test_node_1} to ${test_node_2} failed."

#----

do_cmd echo Various sanity checks - stage 3
do_cmd wait_for_state S_IDLE 60 $test_node_2
cts_assert "S_IDLE not reached on $test_node_2 after shutdown!"

do_cmd is_running rsc1 $test_node_1
cts_assert_false "rsc1 IS running"

do_cmd is_running rsc2 $test_node_1
cts_assert_false "rsc2 IS running"

do_cmd is_dc $test_node_2
cts_assert "$test_node_2 is supposed to be the DC"

#----

stop_node $test_node_2 crmd

#----

do_cmd remote_cmd $CRMD_USER $test_node_2 killall -9 crmd

echo "test: PASSED"
)
done
