# ***** BEGIN LICENSE BLOCK *****
# Source last modified: $Id: umake_win_vc7_makefile.py,v 1.7 2004/07/07 22:00:04 hubbe Exp $
# 
# Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
# 
# The contents of this file, and the files included with this file,
# are subject to the current version of the RealNetworks Public
# Source License (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the current version of the RealNetworks Community
# Source License (the "RCSL") available at
# http://www.helixcommunity.org/content/rcsl, in which case the RCSL
# will apply. You may also obtain the license terms directly from
# RealNetworks.  You may not use this file except in compliance with
# the RPSL or, if you have a valid RCSL with RealNetworks applicable
# to this file, the RCSL.  Please see the applicable RPSL or RCSL for
# the rights, obligations and limitations governing use of the
# contents of the file.
# 
# Alternatively, the contents of this file may be used under the
# terms of the GNU General Public License Version 2 or later (the
# "GPL") in which case the provisions of the GPL are applicable
# instead of those above. If you wish to allow use of your version of
# this file only under the terms of the GPL, and not to allow others
# to use your version of this file under the terms of either the RPSL
# or RCSL, indicate your decision by deleting the provisions above
# and replace them with the notice and other provisions required by
# the GPL. If you do not delete the provisions above, a recipient may
# use your version of this file under the terms of any one of the
# RPSL, the RCSL or the GPL.
# 
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the
# portions it created.
# 
# This file, and the files included with this file, is distributed
# and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
# KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
# ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
# ENJOYMENT OR NON-INFRINGEMENT.
# 
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
# 
# Contributor(s):
#   This file was contributed by Christian Buchner
# 
# ***** END LICENSE BLOCK *****
# 
# 
""" Makefile generator which generates nmake files and VC7 SLN/VCPROJ files """

## This 'inherits' umake_win_makefile
import os
import umake

umake.my_exec_file(os.path.join(umake.UMAKE_ROOT, "umake_win_makefile.py"), None, globals())

import md5

project_extension = "vcproj"
workspace_extension = "sln"

##
## FIXME list:
##   o Make "real" projects instead of projects that just invoke makefiles
##

def hexify(str):
  ret = []
  for c in str:
      ret.append("%02X" % ord(c))
  return string.join(ret,"")

try:
    md5.new("").hexdigest()

    def md5hex(str):
        return md5.new(str).hexdigest()

except AttributeError:
    def md5hex(str):
        return hexify(md5.new(str).digest())

guidhash={}
def make_guid(str):
    if guidhash.has_key(str):
        return guidhash[str]
    guid = md5hex(str)
    guid = "{%s-%s-%s-%s-%s}" % (guid[0:8], guid[8:12], guid[12:16], guid[16:20], guid[20:32] )
    guidhash[str]=guid
    return guid

class Config(Config):
    """Class representing one profile in a MSDEV project"""

    def generate(self, project):
        text = []
        text.append('		<Configuration')
        text.append('			Name="%s"' % self.type )
        text.append('			OutputDirectory="%s"' % self.variables["OUTDIR"])
        text.append('			IntermediateDirectory="%s"' % self.variables["OBJDIR"])
        text.append('			ConfigurationType="0">')
        text.append('			<Tool')
        text.append('				Name="VCNMakeTool"')
        text.append('				BuildCommandLine="nmake.exe /NOLOGO /f %s all copy"' % project.makefile_name)
        text.append('				ReBuildCommandLine="nmake.exe /NOLOGO /f %s /a all copy"' % project.makefile_name)
        text.append('				CleanCommandLine="nmake.exe /NOLOGO /f %s clean"' % project.makefile_name)
        text.append('				Output="%s"/>' % self.variables["OUTFILE"])
        text.append('		</Configuration>')
        
        return text

class Project(Project):
    """Class representing and generating one MSDEV project"""

    def generate(self):
        text = [ ]
        
        text.append('<?xml version="1.0" encoding = "Windows-1252"?>')
        
        text.append('<VisualStudioProject')
        
        guid = make_guid(self.name)
        
        text.append('	ProjectType="Visual C++"')
        text.append('	Version="7.00"')
        text.append('	Name="%s"' % self.name)
        text.append('	ProjectGUID="%s"' % guid)
        text.append('	Keyword="MakeFileProj">')
        
        text.append('	<Platforms>')
        text.append('		<Platform')
        text.append('			Name="Win32"/>')
        text.append('	</Platforms>')
        
        text.append('	<Configurations>')
        
        for config in self.configurations:
            text.extend(config.generate(self))
            
        text.append('	</Configurations>')
        
        text.append('	<Files>')
        
        text.append('		<Filter')
        text.append('			Name="Source Files"')
        text.append('			Filter="cpp;c;cxx;def;odl;idl;hpj;bat;asm">')
       
        for (source, objdir) in self.sourcefiles:
            text.append('			<File')
            text.append('				RelativePath="%s">' % source)
            text.append('			</File>')
        text.append('		</Filter>')
         
        text.append('		<Filter')
        text.append('			Name="Header Files"')
        text.append('			Filter="h;hpp;hxx;hm;inl;inc">')
        for source in self.headerfiles:
            text.append('			<File')
            text.append('				RelativePath="%s">' % source)
            text.append('			</File>')
        text.append('		</Filter>')
        
        text.append('		<Filter')
        text.append('			Name="Resource Files"')
        text.append('			Filter="rc;ico;cur;bmp;dlg;rc2;rct;bin;rgs;gif;jpg;jpeg;jpe">')
        text.append('		</Filter>')
        
        text.append('	</Files>')
        
        text.append('	<Globals>')
        text.append('	</Globals>')
        
        text.append('</VisualStudioProject>')

        text=string.join(text,"\n")
        text=string.replace(text,"$(MODULE)",self.name)

        return text;


class Workspace(Workspace):
    """Class representing and generating one MSDEV solution"""

    def generate(self):
        text = []
        text.append('Microsoft Visual Studio Solution File, Format Version 7.00')

        self.text=text
        self.done={}
        self.project_byname={}

        for (name, path) in self.projects:
            self.project_byname[name]=path

        for (name, path) in self.projects:
            self.generate_project(name)

        text.append('Global')

        text.append('	GlobalSection(SolutionConfiguration) = preSolution')
        text.append('		ConfigName.0 = Build')
        text.append('		DoSign = FALSE')
        text.append('	EndGlobalSection')

        text.append('	GlobalSection(ProjectDependencies) = postSolution')
        for (name, path) in self.projects:
            guid = make_guid(name)
            i = 0
            for d in self.dependencies.get(name,[]):
                #print d
                #print self.project_byname
                deppath = self.project_byname[d]
                depguid = make_guid(d)
                text.append('		%s.%d = %s' % (guid, i, depguid))
                i = i + 1
        text.append('	EndGlobalSection')

        text.append('	GlobalSection(ProjectConfiguration) = postSolution')
        for (name, path) in self.projects:
            guid = make_guid(name)
            text.append('		%s.Build.ActiveCfg = Build|Win32' % (guid))
            text.append('		%s.Build.Build.0 = Build|Win32' % (guid))
        text.append('	EndGlobalSection')

        text.append('	GlobalSection(ExtensibilityGlobals) = postSolution')
        text.append('	EndGlobalSection')

        text.append('	GlobalSection(ExtensibilityAddIns) = postSolution')
        text.append('	EndGlobalSection')

        text.append('EndGlobal')

        return string.join(self.text,"\n")
    
    def generate_project(self, name):
        if self.done.has_key(name):
            return

        self.done[name]=1

        if not self.project_byname.has_key(name):
            return

        path = self.project_byname[name]

        for d in self.dependencies.get(name,[]):
            self.generate_project(d)
        
        text=self.text
        guid = make_guid(name)
        text.append('Project("{8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942}") = "%s", "%s", "%s"' % (name, path, guid))
        text.append('EndProject')


class project_generator(project_generator):
    """Class which generates a VCPROJ file from the data in
    in the platform and project classes"""

    def add_configurations(self):
        self.do_config("Build|Win32")

