/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: base_page2pkt.h,v 1.2.2.3 2004/07/09 01:58:26 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#ifndef BASE_PAGE2PKT_H
#define BASE_PAGE2PKT_H

#include "page2packet.h"
#include "hxccf.h"
#include "hxslist.h"

class CBasePageToPacket : public COggPageToPacket
{
public:
    virtual ~CBasePageToPacket();

    STDMETHOD(Init)(IUnknown* pContext);

    STDMETHOD(SetStreamID)(UINT16 uStream);

    STDMETHOD(OnPage)(ogg_page* pPage);
    STDMETHOD(OnEndOfFile)();

    STDMETHOD(GetPacket)(REF(IHXPacket*) pPkt);
    STDMETHOD(GetNextTimestamp)(REF(UINT32) ulTimestamp);

    STDMETHOD(GetTACInfo)(REF(IHXValues*) pHeader);
    STDMETHOD(GetStreamHeader)(REF(IHXValues*) pHeader) PURE;

    STDMETHOD(OnSeek)(UINT32 ulSeekPoint);

    STDMETHOD(SetEndTime)(ogg_int64_t endTime);

    STDMETHOD_(BOOL,HasStartTime)() const;
    STDMETHOD_(UINT32,StartTime)() const;
    STDMETHOD_(UINT32,Duration)() const;

    STDMETHOD_(BOOL,EndOfStream)() const;

    STDMETHOD(GetTimestamp)(ogg_int64_t granulepos, 
                            REF(UINT32) ulTimestamp) const PURE;

protected:
    typedef enum {stStart,
                  stNeedHeaders,
                  stNeedStartTime,
                  stReady,
                  stSeeking
    } State;

    CBasePageToPacket();

    State GetState() const { return m_state;}
    IHXCommonClassFactory* GetCCF();

    virtual UINT32 HeaderCount() const PURE; // Number of codec headers expected
    virtual BOOL IsHeader(ogg_packet* pPkt) const PURE;

    virtual void StartStream() PURE;

    virtual void InvalidateCurrentTime() PURE;
    virtual ogg_int64_t CurrentTime() const PURE;
    virtual HX_RESULT OnHeader(ogg_packet* pPkt) PURE;
    virtual HX_RESULT OnDataPacket(ogg_packet* pPkt) PURE;
    virtual HX_RESULT OnPageEnd(ogg_page* pPage) PURE;

    void SetStartTime(ogg_int64_t startTime);
    void OnCurrentTimeValid();

protected:

private:

    void ChangeState(State newState);

    HX_RESULT EnqueuePage(ogg_page* pPage);

    HX_RESULT HandleTimedPage(ogg_int64_t startTime, ogg_page* pPage);
    HX_RESULT HandleUntimedPage(ogg_page* pPage);

    HX_RESULT CreatePagePacket(UINT32 ulTimestamp, ogg_page* pPage,
                               BOOL bIsHeader);

    HX_RESULT CacheHeader(ogg_page* pPage);
    BOOL HaveThisHeader(ogg_page* pPage);
    HX_RESULT CreateHeaderPackets();
    
    void FlushQueues();
    void FlushHeaders();

    BOOL m_bHasStreamID;
    UINT16 m_uStreamID;
    BOOL m_bHasStartTime;
    ogg_int64_t m_startTime;
    ogg_int64_t m_endTime;
    UINT32 m_ulSeekTime;
    BOOL m_bEndOfStream;
    UINT32 m_ulHeadersRemaining;

    State m_state;

    IHXCommonClassFactory* m_pCCF;

    CHXSimpleList m_pageQueue;
    CHXSimpleList m_packetQueue;
    CHXSimpleList m_headerPages;
    BOOL m_bSentHeaders;

    // Ogg stuff
    ogg_stream_state m_os;
};
#endif /* BASE_PAGE2PKT_H */
