/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE OGG VORBIS PROJECT SOURCE CODE.         *
 *                                                                  *
 * THE OGG VORBIS PROJECT SOURCE CODE IS (C) COPYRIGHT 1994-2001    *
 * by the XIPHOPHORUS Company http://www.xiph.org/                  *

 ********************************************************************

 function: headers of the file format plugin for RealSystem

********************************************************************/
/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: oggfformat.h,v 1.1.2.4 2004/07/09 01:58:26 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#ifndef __OGGFFORMAT_H__
#define __OGGFFORMAT_H__

#include "hlxclib/string.h"
#include "vorbis/vorbisfile.h"
#include "ogg_page_reader.h"
#include "strm_group.h"

#define PLUGIN_VERSION_NUM 0
#define DESCRIPTION "Ogg File Format Plugin"
#define COPYRIGHT "(c) 2001 Xiphophorus, All rights reserved."
#define MORE_INFO_URL "http://www.xiph.org"
#define FILE_MIME_TYPES {"application/x-ogg", "application/ogg", NULL}
#define FILE_EXTENSIONS {"ogg", NULL}
#define FILE_OPEN_NAMES {"Ogg (*.ogg)", NULL}
#define STREAM_MIME_TYPE "application/ogg"
#define READ_LENGTH 4096

typedef enum
{
    Start,
    InitPending,
    Ready,

    NeedFirstStream,
    GetIdentHeaders,
    NeedStartTime,

    GFHEndSearching,
    GFHSeekBeginPending,

    GetPacketReadPending,

    FindSeekPointPending
} PluginState;


class COggFileFormat :  public IHXFileFormatObject,
                        public IHXOggPageReaderResponse,
                        public IHXPlugin
{
public:

    COggFileFormat(void);

    // IHXFileFormatObject interface
    STDMETHOD(GetFileFormatInfo)
        (THIS_
         REF(const char **)pFileMimeTypes,
         REF(const char **)pFileExtensions,
         REF(const char **)pFileOpenNames
            );

    STDMETHOD(InitFileFormat)
        (THIS_
         IHXRequest *pRequest,
         IHXFormatResponse *pFormatResponse,
         IHXFileObject *pFileObject
            );

    STDMETHOD(GetFileHeader) (THIS);
    STDMETHOD(GetStreamHeader) (THIS_ UINT16 streamNo);
    STDMETHOD(GetPacket) (THIS_ UINT16 streamNo);
    STDMETHOD(Seek) (THIS_ UINT32 requestedTime);
    STDMETHOD(Close) (THIS);

    /*
     * IHXOggPageReaderResponse methods
     */
    STDMETHOD(PageReaderInitDone) (THIS_ HX_RESULT status);
    STDMETHOD(ReadNextPageDone) (THIS_ HX_RESULT status,
                                 ULONG32 ulFileOffset,
                                 UINT32 ulPageSize,
                                 ogg_page* pPage);

    // IHXPlugin Interface
    STDMETHOD(GetPluginInfo)
        (THIS_
         REF(BOOL) bLoadMultiple,
         REF(const char *) pDescription,
         REF(const char *) pCopyright,
         REF(const char *) pMoreInfoURL,
         REF(UINT32) versionNumber
            );

    STDMETHOD(InitPlugin) (THIS_ IUnknown *pRMACore);

    // IUnknown COM Interface
    STDMETHOD(QueryInterface) (THIS_ REFIID ID, void **ppInterfaceObj);
    STDMETHOD_(UINT32, AddRef) (THIS);
    STDMETHOD_(UINT32, Release) (THIS);

private:
    // private class variables
    INT32 m_RefCount;   // Objects reference count
    IHXCommonClassFactory *m_pClassFactory; // creates common RMA classes
    IHXFormatResponse* m_pResponse;       // Reports status to RMA core
    COggPageReader* m_pPageReader;
    PluginState m_State;        // Status used for async calls

    BOOL* m_pGetPacketPending; // Pending GetPacket() Booleans

    ULONG32 m_ulLastSeekOffset; // Set in DoFileSeek

    // Seek in playback variables
    UINT32 m_ulSeekTime;
    ULONG32 m_ulLowerOffset;
    UINT32 m_ulLowerPageSize;
    ULONG32 m_ulUpperOffset;

    // Keeps track of the last page
    // we've seen while looking for
    // the last page of the file.
    // This is to deal with truncated files
    ULONG32 m_ulLastValidPageOff;
    ogg_page* m_pLastValidPage;

    COggStreamGroup* m_pCurrentGroup;

    BOOL m_bInDispatchPendingRequest;

    // private static class variables
    int m_instno;
    static int instno;
    static const char *zm_pDescription;
    static const char *zm_pCopyright;
    static const char *zm_pMoreInfoURL;
    static const char *zm_pFileMimeTypes[];
    static const char *zm_pFileExtensions[];
    static const char *zm_pFileOpenNames[];    

    // private class methods
    ~COggFileFormat(void);
    HX_RESULT CreateFileHeader(void);
    void CreatePacketObj(ogg_page *og, ogg_int64_t granulepos);
    void ChangeState(PluginState newState);
    void OnError(HX_RESULT status);

    HX_RESULT HandleFileHeaderPage(ULONG32 ulFileOffset, UINT32 ulPageSize,
                                   ogg_page* pPage);
    HX_RESULT HandleIdentPage(ULONG32 ulFileOffset, UINT32 ulPageSize,
                              ogg_page*  pPage);
    HX_RESULT HaveFileHeaders(ULONG32 ulFileOffset);
    HX_RESULT HandleEndSearch(HX_RESULT status, ULONG32 ulFileOffset,
                              UINT32 ulPageSize, ogg_page* pPage);
    HX_RESULT HandlePacketPage(ogg_page* pPage);

    HX_RESULT DispatchPendingRequests();
    HX_RESULT DoFileSeek(ULONG32 ulFileOffset);

    HX_RESULT SeekToTheMiddle();
    HX_RESULT HandlePlaybackSeekPage(ULONG32 ulFileOffset,
                                     UINT32 ulPageSize, ogg_page* pPage);

    HX_RESULT FoundLastPage(ULONG32 ulFileOffset, ogg_page* pPage);

    HX_RESULT UpdateLastValidPage(ULONG32 ulFileOffset, ogg_page* pPage);
    void DestroyLastValidPage();
};

#endif  // __OGGFFORMAT_H__
