/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: strm_group.h,v 1.2.2.3 2004/07/09 01:58:26 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#ifndef STRM_GROUP_H
#define STRM_GROUP_H

#include "hxcom.h"
#include "ihxpckts.h"
#include "ogg/ogg.h"
#include "page2packet.h"

class COggStream
{
public:
    COggStream(UINT32 ulSerialNum, COggPageToPacket* pPage2Pkt);
    ~COggStream();

    UINT32 SerialNum() const;
    COggPageToPacket* GetPage2Packet() const;

private:
    UINT32 m_ulSerialNum;
    COggPageToPacket* m_pPage2Pkt;
};

class COggStreamGroup
{
public:
    COggStreamGroup();
    ~COggStreamGroup();
    
    HX_RESULT Init(IUnknown* pContext);
    
    HX_RESULT AddStream(ULONG32 ulFileOffset, UINT32 ulPageSize,
                        ogg_page* pPage);

    HX_RESULT GetTACInfo(UINT32 uStream, REF(IHXValues*)pHeader);
    HX_RESULT GetStreamHeader(UINT32 uStream, REF(IHXValues*)pHeader);

    HX_RESULT GetPacket(UINT16 uStream, REF(IHXPacket*) pPkt);

    HX_RESULT NextPacketStreamID(REF(UINT32) uStreamID);
    HX_RESULT GetNextPacket(REF(IHXPacket*) pPkt);

    HX_RESULT OnPage(ogg_page* pPage);
    HX_RESULT OnEndOfFile();

    HX_RESULT SetEndPage(ULONG32 ulFileOffset, ogg_page* pPage);

    HX_RESULT OnSeek(UINT32 ulSeekPoint);

    BOOL SerialInGroup(UINT32 ulSerialNum) const;
    UINT16 StreamCount() const;
    UINT32 Duration() const;
    ULONG32 StartOffset() const;
    UINT32 StartPageSize() const;
    ULONG32 EndOffset() const;
    BOOL HaveAllStartTimes();

    BOOL EndOfStream(UINT32 uStream) const;

    HX_RESULT GetTimestamp(ogg_page* pPage, REF(UINT32) ulTimestamp) const;


private:
    typedef COggPageToPacket* (*BuildFunc)(ogg_packet* pPacket);

    COggStream* StreamBySerial(UINT32 ulSerialNum) const;
    COggStream* StreamByPage(ogg_page* pPage) const;
    
    COggPageToPacket* Page2PktByStreamID(UINT16 uStream) const;
    COggPageToPacket* Page2PktByPage(ogg_page* pPage) const;

    HX_RESULT GetIdentPacket(ogg_stream_state* pOs, ogg_page* pPage, 
                             ogg_packet* pPkt);
    HX_RESULT AddStream(UINT32 ulSerialNum, COggPageToPacket* pPage2Pkt);
    
    BOOL NextStreamIDValid() const;
    void InvalidateNextStreamID();
    HX_RESULT FindNextPacket();

    IUnknown* m_pContext;
    UINT32 m_uStreamCount;
    COggStream** m_ppStreams;
    ULONG32 m_ulStartOffset;
    UINT32 m_uStartPageSize;
    ULONG32 m_ulEndOffset;
    BOOL m_bHaveAllStartTimes;

    UINT32 m_uNextStreamID;

    static const BuildFunc zm_buildFuncs[];
};

inline
BOOL COggStreamGroup::NextStreamIDValid() const
{
    return (m_uNextStreamID < m_uStreamCount);
}

inline
void COggStreamGroup::InvalidateNextStreamID()
{
    m_uNextStreamID = m_uStreamCount;
}

#endif /* STRM_GROUP_H */
